/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;

public class Bullet {
    public TRLCanvas canvas;
    public boolean shot = false;
    public boolean doubleDamage;
    public int damageInflicted;
    private float startP;
    private float startV;
    private float startH;
    private float bulletP;
    private float bulletV;
    private float bulletH;
    private int nbCharacters;
    private int[] relativePosition;
    private static final int BEHIND = 1;
    private static final int AHEAD = 2;
    private float range;
    private float deltaH;
    private long launchTime;
    private long lastCheckTime;
    private long startPauseTime;
    private long totalPauseTime;
    private float speed;
    private int direction;
    private Mesh image;
    private boolean owner;
    private BadGuy badGuy;
    private long startImpactTime;
    private long impactDuration;
    private float[] impactPos;
    private Mesh impactEffect;
    public static boolean bLaunchEnable = false;

    public Bullet(Mesh _bullet, TRLCanvas _c, boolean _owner, BadGuy bg, int _dmg) {
        try {
            this.canvas = _c;
            this.damageInflicted = _dmg;
            this.image = (Mesh)_bullet.duplicate();
            this.image.setRenderingEnable(false);
            _c.world.addChild((Node)this.image);
            this.owner = _owner;
            if (!_owner) {
                this.badGuy = bg;
                this.speed = Globals.YAK_BULLET_SPEED;
                this.range = bg.type != 100 ? Globals.GUN_DISTANCE : Globals.YARI_DISTANCE;
            } else {
                this.badGuy = null;
                this.range = Globals.LARAGUN_DISTANCE;
                this.speed = Globals.LARA_BULLET_SPEED;
            }
            this.impactEffect = (Mesh)this.canvas.action.impactEffect.duplicate();
            this.canvas.world.addChild((Node)this.impactEffect);
            this.impactEffect.setRenderingEnable(false);
            this.impactDuration = 50L;
            this.impactPos = new float[3];
            this.nbCharacters = this.canvas.nbStartYaks + 1;
            this.relativePosition = new int[this.nbCharacters];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void delete() {
        this.canvas.world.removeChild((Node)this.image);
        this.image = null;
        this.impactPos = null;
        this.canvas.world.removeChild((Node)this.impactEffect);
        this.impactEffect = null;
    }

    public void launch(float _x, float _y, float _z, int _dir) {
        this.startP = this.bulletP = _x;
        this.startV = this.bulletV = _y;
        this.startH = this.bulletH = _z;
        if (!this.owner) {
            this.relativePosition[0] = this.canvas.laraH + this.canvas.hSpeed > this.bulletH ? 1 : 2;
        } else {
            int bg = 0;
            while (bg < this.nbCharacters - 1) {
                this.relativePosition[bg + 1] = this.canvas.action.badGuys[bg].guyH + this.canvas.action.badGuys[bg].hSpeed > this.bulletH ? 1 : 2;
                ++bg;
            }
        }
        this.image.setTranslation(this.bulletP, this.bulletV, this.bulletH);
        this.image.setRenderingEnable(true);
        this.direction = _dir;
        this.shot = true;
        this.lastCheckTime = this.launchTime = System.currentTimeMillis();
    }

    public void move() {
        this.deltaH = (float)this.direction * ((float)(System.currentTimeMillis() - this.lastCheckTime) / 1000.0f * this.speed);
        this.lastCheckTime = System.currentTimeMillis();
        if (Math.abs(this.bulletH + this.deltaH - this.startH) > this.range) {
            this.shot = false;
            this.image.setRenderingEnable(false);
            return;
        }
        if (!this.collide()) {
            this.updateRelativePos();
            this.bulletH += this.deltaH;
            this.image.setTranslation(this.bulletP, this.bulletV, this.bulletH);
        }
    }

    public boolean isShot() {
        return this.shot;
    }

    private void updateRelativePos() {
        try {
            if (!this.owner) {
                this.relativePosition[0] = this.canvas.laraH > this.bulletH ? 1 : 2;
            } else {
                int bg = 0;
                while (bg < this.nbCharacters - 1) {
                    if (this.canvas.action.badGuys[bg] != null && this.canvas.action.badGuys[bg].isAlive()) {
                        this.relativePosition[bg + 1] = this.canvas.action.badGuys[bg].guyH + this.canvas.action.badGuys[bg].hSpeed > this.bulletH ? 1 : 2;
                    }
                    ++bg;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean collide() {
        collision = false;
        try {
            block34: {
                nextBulletH = this.bulletH + this.deltaH;
                nextBulletV = this.bulletV;
                if (!this.owner) break block34;
                i = 0;
                if (true) ** GOTO lbl128
            }
            laraP = this.canvas.laraP;
            laraV = this.canvas.laraV + this.canvas.vSpeed;
            laraH = this.canvas.laraH + this.canvas.hSpeed;
            dep1 = TRLCanvas.tabAnims[this.canvas.numAnim * 2];
            dep2 = TRLCanvas.tabAnims[this.canvas.numAnim * 2 + 1];
            laraAnim = this.canvas.numAnim;
            laraHeight = laraAnim == 32 || laraAnim == 11 || laraAnim == 57 || laraAnim == 58 || laraAnim == 59 ? 1.17f : (laraAnim == 0 || laraAnim == 2 || laraAnim == 8 || laraAnim == 34 ? 1.715f : (laraAnim == 22 ? 1.715f - (float)(this.canvas.m_bipedStep - dep1) / (float)(dep2 - dep1) * (1.715f - 1.17f) : (laraAnim == 23 ? 1.17f + (float)(this.canvas.m_bipedStep - dep1) / (float)(dep2 - dep1) * (1.715f - 1.17f) : (laraAnim == 33 ? 1.715f : (laraAnim == 12 ? 1.715f : 1.715f)))));
            if (this.bulletV >= laraV && this.bulletV <= laraV + laraHeight) {
                if (this.relativePosition[0] == 2 && nextBulletH <= laraH) {
                    collision = true;
                }
                if (this.relativePosition[0] == 1 && nextBulletH >= laraH) {
                    collision = true;
                }
            }
            if (collision && System.currentTimeMillis() - this.canvas.lastHurt > 1000L) {
                this.canvas.action.killLara(this.damageInflicted);
                if (this.canvas.laraLife != Globals.LARA_MAX_LIFE && (this.canvas.numAnim == 0 || this.canvas.numAnim == 2 || this.canvas.numAnim == 82 || this.canvas.numAnim == 83 || this.canvas.numAnim == 81) && this.direction != this.canvas.action.direction) {
                    this.canvas.changeAnim(50);
                }
                this.vanish();
                return true;
            }
lbl27:
            // 3 sources

            while (true) {
                bShowImpact = false;
                colH = 0.0f;
                colLeft = 0.0f;
                colRight = 0.0f;
                colTop = 0.0f;
                colBottom = 0.0f;
                col = 0;
                while (true) {
                    block35: {
                        if (col < this.canvas.nbCollisionsVert) break block35;
                        startH = 0.0f;
                        startV = 0.0f;
                        endH = 0.0f;
                        endV = 0.0f;
                        A = 0.0f;
                        B = 0.0f;
                        deltaV = 0.0f;
                        nextDeltaV = 0.0f;
                        col = 0;
                        if (true) ** GOTO lbl145
                    }
                    typeCol = this.canvas.tabCollisionsVTType[col * 12 + 0];
                    numTrap = this.canvas.tabCollisionsVTType[col * 12 + 4];
                    if (typeCol == 0 || typeCol == 3 && (numTrap == 7 || numTrap == 8)) {
                        colLeft = this.canvas.tabCollisionsVert[col * 5 + 0];
                        colRight = this.canvas.tabCollisionsVert[col * 5 + 2];
                        colTop = this.canvas.tabCollisionsVert[col * 5 + 3];
                        colBottom = this.canvas.tabCollisionsVert[col * 5 + 1];
                        if (this.bulletV <= colTop && this.bulletV >= colBottom) {
                            if (this.bulletH <= colLeft && nextBulletH >= colLeft) {
                                bShowImpact = true;
                                colH = colLeft;
                                collision = true;
                            }
                            if (this.bulletH <= colRight && nextBulletH >= colRight) {
                                bShowImpact = false;
                                colH = colRight;
                                collision = true;
                            }
                            if (this.bulletH >= colRight && nextBulletH <= colRight) {
                                bShowImpact = true;
                                colH = colRight;
                                collision = true;
                            }
                            if (this.bulletH >= colLeft && nextBulletH <= colLeft) {
                                bShowImpact = false;
                                colH = colLeft;
                                collision = true;
                            }
                        }
                        if (collision) {
                            if (typeCol == 3 && numTrap == 7) {
                                this.canvas.sound.PlayerStart(0);
                                this.canvas.tabCollisionsVTType[col * 12 + 4] = 70;
                            }
                            if (bShowImpact) {
                                this.setImpact(this.bulletP, this.bulletV, colH);
                            }
                            this.vanish();
                            return true;
                        }
                    }
                    ++col;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
        do {
            block36: {
                if (!this.canvas.action.badGuys[i].isAlive()) break block36;
                guyP = this.canvas.action.badGuys[i].guyP;
                guyV = this.canvas.action.badGuys[i].guyV;
                guyH = this.canvas.action.badGuys[i].guyH + this.canvas.action.badGuys[i].hSpeed;
                badGuyAnim = this.canvas.action.badGuys[i].numAnim;
                badGuyHeight = 0.0f;
                if (badGuyAnim == 32 || badGuyAnim == 57 || badGuyAnim == 60 || badGuyAnim == 78 || badGuyAnim == 76 || badGuyAnim == 77 || badGuyAnim == 58 || badGuyAnim == 59) {
                    badGuyHeight = 1.17f;
                } else if (badGuyAnim == 23) {
                    dep1 = TRLCanvas.tabAnims[2 * badGuyAnim];
                    dep2 = TRLCanvas.tabAnims[2 * badGuyAnim + 1];
                    bipedStep = this.canvas.action.badGuys[i].m_bipedStep;
                    badGuyHeight = 1.17f + (float)(bipedStep - dep1) / (float)(dep2 - dep1) * (1.715f - 1.17f);
                } else if (badGuyAnim == 22) {
                    dep1 = TRLCanvas.tabAnims[2 * badGuyAnim];
                    dep2 = TRLCanvas.tabAnims[2 * badGuyAnim + 1];
                    bipedStep = this.canvas.action.badGuys[i].m_bipedStep;
                    badGuyHeight = 1.715f - (float)(bipedStep - dep1) / (float)(dep2 - dep1) * (1.715f - 1.17f);
                } else {
                    badGuyHeight = 1.715f;
                }
                if (this.bulletV >= guyV && this.bulletV <= guyV + badGuyHeight) {
                    if (this.relativePosition[i + 1] == 2 && nextBulletH <= guyH) {
                        collision = true;
                    }
                    if (this.relativePosition[i + 1] == 1 && nextBulletH >= guyH) {
                        collision = true;
                    }
                }
                if (!collision) break block36;
                if (this.direction != this.canvas.action.badGuys[i].direction || this.canvas.action.badGuys[i].wakeup || this.canvas.action.badGuys[i].bGroggyYet) ** GOTO lbl-1000
                this.canvas.action.badGuys[i];
                if (this.canvas.action.badGuys[i].type == 99) ** GOTO lbl-1000
                this.canvas.action.badGuys[i];
                if (this.canvas.action.badGuys[i].type != 100) {
                    this.canvas.action.badGuys[i].setGroggy(this.damageInflicted);
                } else lbl-1000:
                // 3 sources

                {
                    this.canvas.action.badGuys[i].setShot(this.damageInflicted);
                }
                this.vanish();
                return true;
            }
            ++i;
lbl128:
            // 2 sources

        } while (i < this.canvas.nbStartYaks);
        ** while (true)
        do {
            if (this.canvas.tabCollisionsHZType[col * 3 + 0] == 5) {
                startH = this.canvas.tabCollisions[col * 4 + 0];
                startV = this.canvas.tabCollisions[col * 4 + 2];
                endH = this.canvas.tabCollisions[col * 4 + 1];
                endV = this.canvas.tabCollisions[col * 4 + 3];
                A = (endV - startV) / (endH - startH);
                B = (startV * endH - endV * startH) / (endH - startH);
                v0 = endV > startV ? endV : startV;
                if (this.bulletV <= v0) {
                    v1 = endV > startV ? startV : endV;
                    if (this.bulletV >= v1 && (this.bulletH <= endH && this.bulletH >= startH || nextBulletH <= endH && nextBulletH >= startH) && (this.direction == 1 && endV > startV || this.direction == -1 && endV < startV) && (deltaV = this.bulletV - (A * this.bulletH + B)) * (nextDeltaV = this.bulletV - (A * this.bulletH + B)) <= 0.0f) {
                        this.vanish();
                        return true;
                    }
                }
            }
            ++col;
lbl145:
            // 2 sources

        } while (col < this.canvas.nbCollisions);
        return false;
    }

    private void setImpact(float posP, float posV, float posH) {
        this.impactPos[0] = posP;
        this.impactPos[1] = posV;
        this.impactPos[2] = posH;
        this.impactEffect.setTranslation(this.impactPos[0], this.impactPos[1], this.impactPos[2]);
        if (this.doubleDamage) {
            this.impactEffect.setScale(2.0f, 2.0f, 2.0f);
        }
        this.impactEffect.setRenderingEnable(true);
        this.startImpactTime = System.currentTimeMillis();
    }

    public void showImpact() {
        long currTime = System.currentTimeMillis();
        if (currTime - this.startImpactTime > this.impactDuration) {
            this.impactEffect.setRenderingEnable(false);
        }
    }

    private void vanish() {
        this.shot = false;
        this.image.setRenderingEnable(false);
    }

    public void restart(long _pauseDelay) {
        this.launchTime += _pauseDelay;
        this.lastCheckTime += _pauseDelay;
    }
}

