/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TechTeam {
    private TRLCanvas canvas;
    private BitmapFont bmFont;
    private int Episode;
    private int Level;
    private boolean isTechTeamOn;
    public Image zip;
    public Image alister;
    private int currFace;
    private final int FACE_ZIP;
    private final int FACE_ALISTER;
    public int currTech = 0;
    private int newTech = 0;
    private int nbTech = 0;
    public int deltaTech = 0;
    private int scroll = 1;
    private final int SCROLL_UP;
    private final int SCROLL_DOWN;
    private int numChar;
    private int numLine;
    private int charHeight;
    private static final int TECH_HEIGHT = 60;
    private String line = new String();
    int nextCharToDisplay = 0;
    boolean isTechTextDone = false;
    private int currPos;
    private int currStrWidth;
    private int lastSpacePos;
    private int nbTechTeam = 0;
    public boolean[] tabTechTriggered;
    private int numFields = 10;
    private final int Ep;
    private final int Lvl;
    private final int Typ;
    private final int Dlg;
    private final int Phr;
    private final int Who;
    private final int Description;
    private final int ENGLISH;
    private final int FRENCH;
    private final int SPANISH;
    private final int START_DLG;
    private final int INGAME_DLG;
    private final int FINISH_DLG;
    private int nbPhrase = 0;
    private int[] tabType;
    private int[] tabNbPhrase;
    private String[] tabPhrase;
    private int[] tabFace;
    private int maxDialog;
    private int maxPhrase;
    private StringBuffer cell = new StringBuffer();

    public TechTeam(TRLCanvas _canvas, BitmapFont _bmFont, String _zipFile, String _alisterFile, int _level) {
        this.FACE_ZIP = 0;
        this.FACE_ALISTER = 1;
        this.SCROLL_UP = 0;
        this.SCROLL_DOWN = 1;
        this.Ep = 0;
        this.Lvl = 1;
        this.Typ = 2;
        this.Dlg = 3;
        this.Phr = 4;
        this.Who = 5;
        this.Description = 6;
        this.ENGLISH = 7;
        this.FRENCH = 8;
        this.SPANISH = 9;
        this.START_DLG = 1;
        this.INGAME_DLG = 2;
        this.FINISH_DLG = 3;
        this.canvas = _canvas;
        this.bmFont = _bmFont;
        this.Episode = _canvas.currEpisode;
        this.Level = _level;
        System.out.println("Creating techTeam for Episode " + this.Episode + " and Level " + this.Level);
        this.parseTechFile();
        this.tabTechTriggered = new boolean[this.nbTechTeam];
        int i = 0;
        while (i < this.nbTechTeam) {
            this.tabTechTriggered[i] = false;
            ++i;
        }
        if (this.tabType[0] == 1 && this.canvas.bTechTeam && this.shouldFirstDialogBePlayed()) {
            this.newTech = 0;
            this.currTech = 0;
            this.nbTech = this.tabNbPhrase[0];
        }
        this.loadTechTeamImages(_zipFile, _alisterFile);
    }

    private void loadTechTeamImages(String zipFile, String alisterFile) {
        try {
            this.alister = Image.createImage((String)alisterFile);
            this.zip = Image.createImage((String)zipFile);
        }
        catch (Exception e) {
            System.out.println("Error in loadTechTeamImages");
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void drawTechTeamByID(Graphics g2d, int techID) {
        try {
            if (this.scroll == 1) {
                if (this.deltaTech < 60) {
                    this.deltaTech += 8;
                    this.canvas.initKeys();
                } else {
                    this.deltaTech = 60;
                }
            } else {
                if (this.deltaTech <= 0) {
                    this.canvas.initKeys();
                    this.isTechTeamOn = false;
                    this.deltaTech = 0;
                    return;
                }
                this.canvas.bRedrawInterface = true;
                this.deltaTech -= 8;
            }
            g2d.setColor(0);
            g2d.fillRect(0, this.deltaTech - 60, this.canvas.getWidth(), 60);
            g2d.fillRect(0, this.canvas.getHeight() - this.deltaTech, this.canvas.getWidth(), this.deltaTech);
            g2d.setColor(0xFFFFFF);
            if (this.tabFace[techID] == 0) {
                g2d.drawImage(this.zip, 0, this.deltaTech - 60, 20);
            } else {
                g2d.drawImage(this.alister, 0, this.deltaTech - 60, 20);
            }
            int textStartX = this.alister.getWidth() + 2;
            int textStartY = 4;
            int textHeight = 56;
            int textWidth = this.canvas.getWidth() - this.alister.getWidth() - 2;
            boolean textInitialY = false;
            this.charHeight = this.bmFont.getCharHeight();
            this.numLine = 0;
            this.numChar = this.nextCharToDisplay;
            int xText = textStartX;
            while (true) {
                int yText;
                int nextNumChar;
                if (this.numChar >= this.tabPhrase[techID].length() || this.deltaTech != 60) {
                    this.isTechTextDone = true;
                    return;
                }
                while (true) {
                    if (this.tabPhrase[techID].charAt(this.numChar) != ' ' && this.tabPhrase[techID].charAt(this.numChar) != '\n') {
                        nextNumChar = this.getLargestString(this.numChar, this.tabPhrase[techID], textWidth);
                        this.line = this.tabPhrase[techID].substring(this.numChar, nextNumChar);
                        yText = this.numLine * this.charHeight + textStartY;
                        if (yText + this.charHeight <= 60) break;
                        this.isTechTextDone = false;
                        return;
                    }
                    ++this.numChar;
                }
                this.bmFont.drawString(g2d, this.line, xText, yText, 0);
                this.numChar = nextNumChar;
                ++this.numLine;
            }
        }
        catch (Exception e) {
            System.out.println("Error in drawTechTeam");
            e.printStackTrace();
        }
    }

    public void drawTechTeam(Graphics g2d) {
        if (this.currTech >= this.newTech && this.currTech < this.newTech + this.nbTech) {
            this.isTechTeamOn = true;
            this.scroll = 1;
            this.drawTechTeamByID(g2d, this.currTech);
        }
        if (this.isTechTeamOn && this.currTech == this.newTech + this.nbTech) {
            this.scroll = 0;
            this.drawTechTeamByID(g2d, this.currTech - 1);
        }
    }

    public void setCurrentTechTeamLoop(int _dialog) {
        int tmp = 0;
        int i = 0;
        while (i < _dialog) {
            tmp += this.tabNbPhrase[i];
            ++i;
        }
        this.currTech = this.newTech = tmp;
        this.nbTech = this.tabNbPhrase[_dialog];
        this.tabTechTriggered[_dialog] = true;
    }

    public void nextTechTeam() {
        if (this.isTechTextDone) {
            this.nextCharToDisplay = 0;
            if (this.currTech < this.newTech + this.nbTech) {
                ++this.currTech;
            }
        } else {
            this.nextCharToDisplay = this.numChar;
        }
        if (this.currTech >= this.newTech + this.nbTech) {
            this.canvas.bRedrawInterface = true;
            this.isTechTextDone = true;
        }
    }

    public void skipTechTeam() {
        this.currTech = this.newTech + this.nbTech;
        this.canvas.bRedrawInterface = true;
        this.isTechTextDone = true;
    }

    public void playLastDialog() {
        if (this.tabType[this.nbTechTeam - 1] == 3 && !this.tabTechTriggered[this.nbTechTeam - 1]) {
            this.setCurrentTechTeamLoop(this.nbTechTeam - 1);
        }
    }

    public boolean isTechTeamOn() {
        return this.isTechTeamOn;
    }

    public int getLargestString(int _numChar, String _cutSceneTxt, int _availableWidth) {
        try {
            this.currPos = _numChar;
            this.currStrWidth = this.bmFont.getCharWidth(_cutSceneTxt.charAt(_numChar));
            this.lastSpacePos = _numChar;
            while (this.currStrWidth < _availableWidth) {
                if (this.currPos == _cutSceneTxt.length() - 1) {
                    return this.currPos + 1;
                }
                ++this.currPos;
                if (_cutSceneTxt.charAt(this.currPos) == '\n') {
                    return this.currPos + 1;
                }
                if (_cutSceneTxt.charAt(this.currPos) == ' ') {
                    this.lastSpacePos = this.currPos;
                }
                this.currStrWidth += this.bmFont.getCharWidth(_cutSceneTxt.charAt(this.currPos));
            }
            if (_cutSceneTxt.charAt(this.currPos) != ' ' && _cutSceneTxt.charAt(this.currPos) != '\n') {
                this.currPos = this.lastSpacePos;
            }
        }
        catch (Exception e) {
            System.out.println("Error in getLargestString ");
        }
        return this.currPos;
    }

    public void parseTechFile() {
        try {
            try {
                InputStream techFile = this.getClass().getResourceAsStream("/TechTeamTxt.csv");
                InputStreamReader techReader = new InputStreamReader(techFile);
                if (techReader.markSupported()) {
                    techReader.mark(10000);
                }
                this.skipLine(3, techReader);
                boolean bStop = false;
                while (!bStop) {
                    int eof;
                    this.readCell(techReader);
                    if (!this.cell.toString().equals(Integer.toString(this.Episode))) {
                        if (this.skipLine(1, techReader) != -1) continue;
                        bStop = true;
                        continue;
                    }
                    this.readCell(techReader);
                    if (!this.cell.toString().equals(Integer.toString(this.Level))) {
                        if (this.skipLine(1, techReader) != -1) continue;
                        bStop = true;
                        continue;
                    }
                    this.skipCell(1, techReader);
                    this.readCell(techReader);
                    this.maxDialog = Integer.parseInt(this.cell.toString());
                    if (this.nbTechTeam < this.maxDialog) {
                        this.nbTechTeam = this.maxDialog;
                    }
                    this.readCell(techReader);
                    this.maxPhrase = Integer.parseInt(this.cell.toString());
                    if (this.nbPhrase < this.maxPhrase) {
                        this.nbPhrase = this.maxPhrase;
                    }
                    if ((eof = this.skipLine(1, techReader)) != -1) continue;
                    bStop = true;
                }
                if (techReader.markSupported()) {
                    techReader.reset();
                } else {
                    techFile = this.getClass().getResourceAsStream("/TechTeamTxt.csv");
                    techReader = new InputStreamReader(techFile);
                }
                this.tabType = null;
                this.tabNbPhrase = null;
                this.tabPhrase = null;
                this.tabFace = null;
                this.tabType = new int[this.nbTechTeam];
                this.tabNbPhrase = new int[this.nbTechTeam];
                int i = 0;
                while (i < this.nbTechTeam) {
                    this.tabNbPhrase[i] = 0;
                    ++i;
                }
                this.tabPhrase = new String[this.nbPhrase];
                this.tabFace = new int[this.nbPhrase];
                bStop = false;
                this.skipLine(3, techReader);
                while (!bStop) {
                    this.readCell(techReader);
                    if (!this.cell.toString().equals(Integer.toString(this.Episode))) {
                        if (this.skipLine(1, techReader) != -1) continue;
                        bStop = true;
                        continue;
                    }
                    this.readCell(techReader);
                    if (!this.cell.toString().equals(Integer.toString(this.Level))) {
                        if (this.skipLine(1, techReader) != -1) continue;
                        bStop = true;
                        continue;
                    }
                    this.readCell(techReader);
                    int type = Integer.parseInt(this.cell.toString());
                    this.readCell(techReader);
                    int numDialog = Integer.parseInt(this.cell.toString());
                    this.readCell(techReader);
                    int numPhrase = Integer.parseInt(this.cell.toString());
                    this.readCell(techReader);
                    String who = this.cell.toString();
                    this.skipCell(1 + this.canvas.currLang, techReader);
                    this.readCell(techReader);
                    String phrase = this.cell.toString();
                    this.tabType[numDialog - 1] = type;
                    int n = numDialog - 1;
                    this.tabNbPhrase[n] = this.tabNbPhrase[n] + 1;
                    this.tabPhrase[numPhrase - 1] = new String(phrase);
                    int n2 = this.tabFace[numPhrase - 1] = who.equals("Alister") ? 1 : 0;
                    if (this.skipLine(1, techReader) != -1) continue;
                    bStop = true;
                }
            }
            catch (Exception e) {
                TRLCanvas.message = "parseTechFile error" + e.getMessage();
                System.out.println("Error in parseTechFile");
                e.printStackTrace();
            }
        }
        finally {
            this.cell = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int skipLine(int n, InputStreamReader in) {
        int c = 0;
        int skipped = 0;
        try {
            c = in.read();
            while (true) {
                if (c == -1) {
                    return -1;
                }
                if ((char)c == '\n' && ++skipped == n) {
                    return 0;
                }
                c = in.read();
            }
        }
        catch (Exception e) {
            System.out.println("Error in skipLine");
            e.printStackTrace();
            return 0;
        }
    }

    private void skipCell(int n, InputStreamReader in) {
        int c = 0;
        int cellSkipped = 0;
        try {
            if (n == 0) {
                return;
            }
            c = in.read();
            while (c != -1) {
                if ((char)c == ';' && ++cellSkipped == n) {
                    return;
                }
                c = in.read();
            }
        }
        catch (Exception e) {
            System.out.println("Error in skipCell");
            e.printStackTrace();
        }
    }

    private void readCell(InputStreamReader in) {
        int c = 0;
        this.cell.setLength(0);
        try {
            c = in.read();
            while ((char)c != ';') {
                this.cell.append((char)c);
                c = in.read();
            }
        }
        catch (Exception e) {
            System.out.println("Error in readCell");
            e.printStackTrace();
        }
    }

    public void switchLanguage() {
        try {
            System.out.println("TechTeam: switching languages");
            InputStream techFile = this.getClass().getResourceAsStream("/TechTeamTxt.csv");
            InputStreamReader techReader = new InputStreamReader(techFile);
            this.cell = new StringBuffer();
            boolean bStop = false;
            this.skipLine(3, techReader);
            while (!bStop) {
                this.readCell(techReader);
                System.out.println("Episode: " + this.cell.toString());
                if (!this.cell.toString().equals(Integer.toString(this.Episode))) {
                    if (this.skipLine(1, techReader) != -1) continue;
                    bStop = true;
                    continue;
                }
                this.readCell(techReader);
                System.out.println("Level: " + this.cell.toString());
                if (!this.cell.toString().equals(Integer.toString(this.Level))) {
                    if (this.skipLine(1, techReader) != -1) continue;
                    bStop = true;
                    continue;
                }
                this.skipCell(2, techReader);
                this.readCell(techReader);
                System.out.println("Phrase number: " + this.cell.toString());
                int numPhrase = Integer.parseInt(this.cell.toString());
                this.skipCell(2 + this.canvas.currLang, techReader);
                this.readCell(techReader);
                String phrase = this.cell.toString();
                this.tabPhrase[numPhrase - 1] = new String(phrase);
                if (this.skipLine(1, techReader) != -1) continue;
                bStop = true;
            }
            int i = 0;
            while (i < this.nbTechTeam) {
                System.out.println("tabType[" + i + "]= " + this.tabType[i]);
                ++i;
            }
            i = 0;
            while (i < this.nbTechTeam) {
                System.out.println("tabNbPhrase[" + i + "]= " + this.tabNbPhrase[i]);
                ++i;
            }
            i = 0;
            while (i < this.nbPhrase) {
                System.out.println("tabPhrase[" + i + "]= " + this.tabPhrase[i] + " spoken by: " + this.tabFace[i]);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Error in switchLanguage");
            e.printStackTrace();
        }
    }

    private boolean shouldFirstDialogBePlayed() {
        return !this.canvas.bMission && this.canvas.currMaxCheckpoint <= 0;
    }
}

