/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BitmapFont {
    private Image bitmap;
    private final int SPACE_CHAR_CODE;
    private int charHeight;
    private int spaceWidth;
    public int charSpacing;
    private int charFileSpacing;
    private int charCodeFirst;
    private int charCodeLast;
    private int nbrClassicChars;
    private int[] tabWidth;
    private int nbrAdditionalChars;
    private int[] tabAddCharsCodes;
    private int[] tabAddCharsWidth;
    private String additionalChars;
    private int size;
    public static final int NORMAL = 1;
    public static final int BIG = 2;
    private String normalFontFile = "/font_6x9_tr_white_05.png";
    private String normalFontClassicCharsWidthFile = "/normalFontClassicWidth.txt";
    private String normalFontAdditionalCharsWidthFile = "/normalFontAdditionalWidth.txt";
    private String bigFontFile = "/font_12x14_05.png";
    private String bigFontClassicCharsWidthFile = "/bigFontClassicWidth.txt";
    private String bigFontAdditionalCharsWidthFile = "/bigFontAdditionalWidth.txt";
    private StringBuffer buff = new StringBuffer();

    public BitmapFont(int _size) {
        this.SPACE_CHAR_CODE = 32;
        this.size = _size;
        if (this.size == 1) {
            this.initialize(this.normalFontFile);
        } else if (this.size == 2) {
            this.initialize(this.bigFontFile);
        }
    }

    private void initialize(String fontFile) {
        try {
            this.bitmap = Image.createImage((String)fontFile);
            this.charCodeFirst = 33;
            this.charCodeLast = 122;
            this.nbrClassicChars = this.charCodeLast - this.charCodeFirst + 1;
            this.tabAddCharsCodes = new int[]{161, 169, 191, 192, 193, 196, 200, 201, 202, 203, 204, 205, 209, 210, 211, 212, 214, 217, 218, 220, 223, 224, 225, 226, 227, 228, 231, 232, 233, 234, 235, 236, 237, 238, 241, 242, 243, 244, 245, 246, 249, 250, 251, 252, 255, 338, 339};
            this.nbrAdditionalChars = this.tabAddCharsCodes.length;
            if (this.size == 1) {
                this.charFileSpacing = 0;
                this.charSpacing = 0;
                this.spaceWidth = 6;
                this.charHeight = 9;
                this.tabWidth = new int[this.nbrClassicChars];
                this.readWidth(this.normalFontClassicCharsWidthFile);
                this.tabAddCharsWidth = new int[this.nbrAdditionalChars];
                this.readAdditionalWidth(this.normalFontAdditionalCharsWidthFile);
            } else if (this.size == 2) {
                this.charFileSpacing = 0;
                this.charSpacing = 0;
                this.spaceWidth = 6;
                this.charHeight = 14;
                this.tabWidth = new int[90];
                this.readWidth(this.bigFontClassicCharsWidthFile);
                this.tabAddCharsWidth = new int[this.nbrAdditionalChars];
                this.readAdditionalWidth(this.bigFontAdditionalCharsWidthFile);
            }
        }
        catch (Exception e) {
            System.out.println("Error in initialize()");
            e.printStackTrace();
        }
    }

    public void drawString(Graphics g, String str, int x, int y, int anchor) {
        if ((anchor & 8) != 0) {
            x -= this.stringWidth(str);
        } else if ((anchor & 1) != 0) {
            x -= this.stringWidth(str) / 2;
        }
        if ((anchor & 0x20) != 0) {
            y -= this.charHeight;
        }
        int strLength = str.length();
        int i = 0;
        while (i < strLength) {
            char charCode = str.charAt(i);
            if (charCode == ' ') {
                x += this.spaceWidth;
            } else {
                this.drawChar(g, charCode, x, y, 20);
                x += this.getCharWidth(charCode) + this.charSpacing;
            }
            ++i;
        }
    }

    public void drawChar(Graphics g, int ch, int x, int y, int anchor) {
        int offset = this.getOffset(ch);
        int width = this.getCharWidth(ch);
        g.drawRegion(this.bitmap, 0, offset * (this.charHeight + this.charFileSpacing), width, this.charHeight, 0, x, y, anchor);
    }

    private int getOffset(int code) {
        int offset = 0;
        if (code >= this.charCodeFirst && code <= this.charCodeLast) {
            offset = code - this.charCodeFirst;
        } else {
            int ch = 0;
            while (ch < this.nbrAdditionalChars) {
                if (code == this.tabAddCharsCodes[ch]) {
                    return this.charCodeLast - this.charCodeFirst + 1 + ch;
                }
                ++ch;
            }
        }
        return offset;
    }

    public int getCharWidth(int code) {
        int width = 0;
        if (code == 32) {
            return this.spaceWidth;
        }
        if (code >= this.charCodeFirst && code <= this.charCodeLast) {
            int offset = code - this.charCodeFirst;
            width = this.tabWidth[offset];
        } else {
            int ch = 0;
            while (ch < this.nbrAdditionalChars) {
                if (code == this.tabAddCharsCodes[ch]) {
                    return this.tabAddCharsWidth[ch];
                }
                ++ch;
            }
        }
        return width;
    }

    public int getCharHeight() {
        return this.charHeight;
    }

    public int stringWidth(String str) {
        int strWidth = 0;
        try {
            int i = 0;
            while (i < str.length()) {
                char tmp;
                char code = tmp = str.charAt(i);
                strWidth += this.getCharWidth(code);
                ++i;
            }
            strWidth += (str.length() - 1) * this.charSpacing;
        }
        catch (Exception e) {
            System.out.println("Error in getStringWidth");
            e.printStackTrace();
        }
        return strWidth;
    }

    private void readWidth(String file) {
        try {
            InputStream fontFile = this.getClass().getResourceAsStream(file);
            InputStreamReader fontReader = new InputStreamReader(fontFile);
            int ch = this.charCodeFirst;
            while (ch <= this.charCodeLast) {
                int w;
                int c;
                this.buff.setLength(0);
                while ((c = fontReader.read()) != 32) {
                    this.buff.append((char)c);
                }
                this.buff.setLength(0);
                while ((char)(c = fontReader.read()) != '\n' && (char)c != '\r') {
                    this.buff.append((char)c);
                }
                this.tabWidth[ch - this.charCodeFirst] = w = Integer.parseInt(this.buff.toString());
                ++ch;
            }
        }
        catch (Exception e) {
            System.out.println("Error in readWidth");
            e.printStackTrace();
        }
    }

    private void readAdditionalWidth(String file) {
        try {
            InputStream fontFile = this.getClass().getResourceAsStream(file);
            InputStreamReader fontReader = new InputStreamReader(fontFile);
            int ch = 0;
            while (ch < this.nbrAdditionalChars) {
                int w;
                int c;
                this.buff.setLength(0);
                while ((c = fontReader.read()) != 32) {
                    this.buff.append((char)c);
                }
                this.buff.setLength(0);
                while ((char)(c = fontReader.read()) != '\n' && (char)c != '\r') {
                    this.buff.append((char)c);
                }
                this.tabAddCharsWidth[ch] = w = Integer.parseInt(this.buff.toString());
                ++ch;
            }
        }
        catch (Exception e) {
            System.out.println("Error in readAdditionalWidth");
            e.printStackTrace();
        }
    }
}

