/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class Sound {
    private TRLCanvas c;
    public static final int GUNS = 0;
    public static final int GRENADE = 1;
    public static final int MUSIC = 2;
    public Player laraGun = null;
    public Player yakNade = null;
    public Player music = null;
    public boolean bSound = false;
    private VolumeControl laraGunVolumeControl;
    private VolumeControl yakNadeVolumeControl;
    private VolumeControl musicVolumeControl;

    public Sound(TRLCanvas _c, boolean isSoundOn) {
        this.c = _c;
        this.loadMusic();
        this.bSound = isSoundOn;
        if (isSoundOn) {
            this.setSoundOn();
        } else {
            this.setSoundOff();
        }
    }

    public void loadMusic() {
        if (this.music != null) {
            return;
        }
        try {
            this.unloadPlayers();
            InputStream musicfile = this.getClass().getResourceAsStream("/theme1.mid");
            this.music = Manager.createPlayer((InputStream)musicfile, (String)"audio/midi");
            this.music.setLoopCount(-1);
            this.music.realize();
            this.musicVolumeControl = (VolumeControl)this.music.getControl("VolumeControl");
            musicfile.close();
            musicfile = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unloadMusic() {
        try {
            if (this.music != null) {
                if (this.music.getState() != 0) {
                    this.music.stop();
                }
                this.music.close();
                this.music = null;
                this.musicVolumeControl = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadPlayers() {
        if (this.laraGun != null) {
            return;
        }
        try {
            this.unloadMusic();
            InputStream larafile = this.getClass().getResourceAsStream("/lara_gun.mid");
            Object nadefile = null;
            this.laraGun = Manager.createPlayer((InputStream)larafile, (String)"audio/midi");
            this.laraGun.setLoopCount(1);
            this.laraGun.realize();
            this.laraGunVolumeControl = (VolumeControl)this.laraGun.getControl("VolumeControl");
            larafile.close();
            larafile = null;
            System.out.println("players created");
        }
        catch (Exception e) {
            System.out.println("Error in loadGunPlayer");
            e.printStackTrace();
        }
    }

    public void unloadPlayers() {
        try {
            if (this.laraGun != null) {
                if (this.laraGun.getState() != 0) {
                    this.laraGun.stop();
                }
                this.laraGun.close();
                this.laraGun = null;
                this.laraGunVolumeControl = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSoundOn() {
        try {
            System.out.println("setSoundOn");
            if (this.musicVolumeControl != null) {
                this.musicVolumeControl.setLevel(100);
            }
            if (this.laraGunVolumeControl != null) {
                this.laraGunVolumeControl.setLevel(100);
            }
            this.bSound = true;
            this.c.bSound = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error in setSoundOn");
        }
    }

    public void setSoundOff() {
        try {
            System.out.println("soundoff called");
            if (this.music != null) {
                this.music.stop();
            }
            if (this.laraGun != null) {
                this.laraGun.stop();
            }
            this.bSound = false;
            this.c.bSound = false;
        }
        catch (Exception e) {
            System.out.println("Error in setSoundOff");
        }
    }

    public void stopAllPlayers() {
        try {
            if (this.music != null && this.music.getState() == 400) {
                this.music.stop();
                while (this.music.getState() == 400) {
                    Thread.yield();
                    Thread.currentThread();
                }
            }
            if (this.laraGun != null && this.laraGun.getState() == 400) {
                this.laraGun.stop();
                while (this.laraGun.getState() == 400) {
                    Thread.yield();
                    Thread.currentThread();
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error in stopAllPlayers");
        }
    }

    public void StartMusic() {
        if (!this.bSound) {
            return;
        }
        try {
            if (this.music == null) {
                this.loadMusic();
            }
            if (this.music.getState() != 300) {
                this.music.prefetch();
            }
            while (this.music.getState() != 300) {
                Thread.yield();
                Thread.currentThread();
            }
            this.music.start();
        }
        catch (Exception e) {
            System.out.println("Error in PlayerStart");
        }
    }

    public void PlayerStart(int sound) {
        if (!this.bSound) {
            return;
        }
        if (this.laraGun == null) {
            this.loadPlayers();
        }
        try {
            this.stopAllPlayers();
            Player p = null;
            p = sound == 0 ? this.laraGun : this.yakNade;
            if (p.getState() != 300) {
                try {
                    p.prefetch();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            p.setMediaTime(0L);
            p.start();
            while (p.getState() != 400) {
                Thread.currentThread();
                Thread.yield();
            }
        }
        catch (Exception e) {
            System.out.println("Error in PlayerStart");
            e.printStackTrace();
        }
    }

    public void stopPlayer(Player p) {
        if (!this.bSound) {
            return;
        }
        try {
            if (p != null && p.getState() == 400) {
                p.stop();
            }
        }
        catch (Exception e) {
            System.out.println("Error in stoPlayer");
        }
    }
}

