/*
 * Decompiled with CFR 0.152.
 */
package com.fazzidice;

import com.fazzidice.DispManager;
import com.fazzidice.Sprite;
import javax.microedition.lcdui.Graphics;

public class Disp {
    public static final int PRECISION = 10;
    Sprite[] spritesLayers;
    protected int width;
    protected int height;
    protected int gameTime;

    public Disp(int spriteLayers) {
        this.spritesLayers = new Sprite[spriteLayers];
        for (int i = 0; i < spriteLayers; ++i) {
            this.spritesLayers[i] = new Sprite();
        }
        this.width = DispManager.getManager().getScreenWidth();
        this.height = DispManager.getManager().getScreenHeight();
    }

    public void addSprite(int layer, Sprite s) {
        s.addAfter(this.spritesLayers[layer]);
        s.parent = this;
        s.onAdd();
        s.toRemove = false;
    }

    public void load() {
    }

    public void onShow() {
    }

    public void onHide() {
    }

    public void display() {
        DispManager.setDisp(this, false);
    }

    public void paint(Graphics g) {
        for (int i = 0; i < this.spritesLayers.length; ++i) {
            this.paintLayer(g, i);
        }
    }

    public void paintLayer(Graphics g, int i) {
        DispManager.message = "paintLayer " + i;
        int tx = -g.getTranslateX();
        int ty = -g.getTranslateY();
        Sprite s = this.spritesLayers[i].next;
        while (s != this.spritesLayers[i]) {
            if (this.toPx(s.x + s.getWidth()) >= tx && this.toPx(s.x) < tx + this.width && this.toPx(s.y) >= ty && this.toPx(s.y - s.getHeight()) < ty + this.height) {
                s.paint(g);
            }
            s = s.next;
        }
        DispManager.message = "/paintLayer " + i;
    }

    public void update(int time) {
        for (int i = 0; i < this.spritesLayers.length; ++i) {
            Sprite n;
            Sprite s = this.spritesLayers[i].next;
            while (s != this.spritesLayers[i]) {
                n = s.next;
                s.update(time);
                s = n;
            }
            s = this.spritesLayers[i].next;
            while (s != this.spritesLayers[i]) {
                n = s.next;
                if (s.toRemove) {
                    s.prev.next = s.next;
                    s.next.prev = s.prev;
                    s.onRemove();
                }
                s = n;
            }
        }
        this.gameTime += time;
    }

    public void cleanupRemovedSprites() {
        for (int i = 0; i < this.spritesLayers.length; ++i) {
            Sprite s = this.spritesLayers[i].next;
            s = this.spritesLayers[i].next;
            while (s != this.spritesLayers[i]) {
                Sprite n = s.next;
                if (s.toRemove) {
                    s.prev.next = s.next;
                    s.next.prev = s.prev;
                    s.onRemove();
                }
                s = n;
            }
        }
    }

    public final Sprite spriteAt(int x, int y) {
        for (int i = this.spritesLayers.length - 1; i >= 0; --i) {
            Sprite s = this.spritesLayers[i].prev;
            while (s != this.spritesLayers[i]) {
                if (this.fromPx(x) >= s.x && this.fromPx(x) < s.x + s.getWidth() && this.fromPx(y) >= s.y - s.getHeight() && this.fromPx(y) < s.y) {
                    return s;
                }
                s = s.prev;
            }
        }
        return null;
    }

    public final Sprite spriteAt(int layer, int x, int y) {
        Sprite s = this.spritesLayers[layer].prev;
        while (s != this.spritesLayers[layer]) {
            if (this.fromPx(x) >= s.x && this.fromPx(x) < s.x + s.getWidth() && this.fromPx(y) >= s.y - s.getHeight() && this.fromPx(y) < s.y) {
                return s;
            }
            s = s.prev;
        }
        return null;
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
    }

    public void keyRepeated(int keyCode) {
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public final int toPx(int a) {
        return a;
    }

    public final int fromPx(int a) {
        return a;
    }
}

