/*
 * Decompiled with CFR 0.152.
 */
package com.fazzidice;

import com.fazzidice.DispManager;
import com.fazzidice.ImageFont;
import com.fazzidice.PartialInputStream;
import com.fazzidice.Point;
import com.fazzidice.ResManParser;
import com.fazzidice.TileSet;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Paintable
implements Runnable {
    private static Hashtable images = new Hashtable(30);
    public static final int CLIP_LEFT = 0;
    public static final int CLIP_UP = 1;
    public static final int CLIP_RIGHT = 2;
    public static final int CLIP_DOWN = 3;
    static final int UNLOADED = -1;
    static final int IMAGE = 0;
    static final int ANIMATION = 1;
    static final int COMPOSITION = 2;
    static final int TEXT = 3;
    static final int TILE_SET_IMAGE = 4;
    static final int WITH_START_ANIM = 5;
    static final int INVISIBLE_RECT = 6;
    static final int CLIPPED = 7;
    static final int RECT = 8;
    static final int FILL_RECT = 9;
    static final int ROUND_RECT = 10;
    static final int FILL_ROUND_RECT = 11;
    String imgName;
    Image img;
    private Sprite mirrorImage;
    Paintable[] frames;
    Vector elements;
    Vector pos;
    TileSet tileset;
    ImageFont font;
    String[] text;
    Paintable start;
    Paintable cont;
    int int_1;
    int int_2;
    int int_3;
    int int_4;
    private int[] intTab_1;
    int type;
    private int resourceId = -1;
    private boolean bool_1;
    private boolean mirror;
    public static final int RES_NUM = 138;
    private static Object[] resources = new Object[138];
    private static boolean[] toLoad = new boolean[138];
    private static Hashtable res = new Hashtable(30);
    public static boolean isLoading = false;
    public static boolean isPreloading = false;
    public static int toLoadNum;
    public static int loaded;
    public static int loading;
    public static final String PACK_PRE = "/pack";
    public static final String PACK_POST = ".res";
    private static boolean wasPreloaded;
    public static final int MAX_SCALE = 1024;

    public final int getType() {
        return this.type;
    }

    public final boolean getMirror() {
        return this.mirror;
    }

    public final void setMirror(boolean mirror) {
        this.mirror = mirror;
        switch (this.type) {
            case 5: {
                this.start.setMirror(mirror);
                this.cont.setMirror(mirror);
                break;
            }
            case 1: {
                for (int i = 0; i < this.frames.length; ++i) {
                    this.frames[i].setMirror(mirror);
                }
                break;
            }
        }
    }

    private Paintable() {
    }

    public static Paintable createFromResMan(int resourceId) {
        Object p = res.get(new Integer(resourceId));
        if (p != null) {
            if (p instanceof Paintable) {
                return (Paintable)p;
            }
            return null;
        }
        Paintable pa = new Paintable();
        pa.type = -1;
        pa.resourceId = resourceId;
        pa.int_1 = 2;
        pa.int_2 = 2;
        res.put(new Integer(resourceId), pa);
        return pa;
    }

    public static Paintable createImage(String name) {
        if (images.get(name) == null) {
            Paintable p = new Paintable();
            p.type = 0;
            p.imgName = name;
            p.int_1 = p.getImage().getWidth();
            p.int_2 = p.getImage().getHeight();
            images.put(name, p);
            return p;
        }
        Paintable p = new Paintable();
        p.type = 0;
        p.img = ((Paintable)images.get(name)).getImage();
        p.imgName = name;
        p.int_1 = p.getImage().getWidth();
        p.int_2 = p.getImage().getHeight();
        return p;
    }

    static Paintable createClippedPaintable(Paintable p2, int left, int up, int right, int down) {
        Paintable p = new Paintable();
        p.intTab_1 = new int[4];
        p.intTab_1[0] = left;
        p.intTab_1[1] = up;
        p.intTab_1[2] = right;
        p.intTab_1[3] = down;
        p.type = 7;
        p.start = p2;
        return p;
    }

    static Paintable createInvisibleRect(int width, int height) {
        Paintable p = new Paintable();
        p.int_1 = width;
        p.int_2 = height;
        p.type = 6;
        return p;
    }

    static Paintable createRect(int width, int height, int rgb) {
        Paintable p = new Paintable();
        p.int_1 = width;
        p.int_2 = height;
        p.int_3 = rgb;
        p.type = 8;
        return p;
    }

    static Paintable createRoundRect(int width, int height, int rgb, int round) {
        Paintable p = new Paintable();
        p.int_1 = width;
        p.int_2 = height;
        p.int_3 = rgb;
        p.int_4 = round;
        p.type = 10;
        return p;
    }

    static Paintable createFilledRoundRect(int width, int height, int rgb, int round) {
        Paintable p = new Paintable();
        p.int_1 = width;
        p.int_2 = height;
        p.int_3 = rgb;
        p.int_4 = round;
        p.type = 11;
        return p;
    }

    static Paintable createFilledRect(int width, int height, int rgb) {
        Paintable p = new Paintable();
        p.int_1 = width;
        p.int_2 = height;
        p.int_3 = rgb;
        p.type = 9;
        return p;
    }

    public int getRgb() {
        return this.int_3;
    }

    public void setRgb(int rgb) {
        this.int_3 = rgb;
    }

    public int getRound() {
        return this.int_4;
    }

    static final Paintable createPaintableWithStartAnim(Paintable start, Paintable cont) {
        Paintable p = new Paintable();
        p.type = 5;
        p.start = start;
        p.cont = cont;
        return p;
    }

    static final Paintable createAnim(Paintable[] frames, int animDuration) {
        Paintable p = new Paintable();
        p.frames = frames;
        p.int_1 = 0;
        p.int_2 = animDuration;
        p.type = 1;
        return p;
    }

    static final Paintable createAnimWithTileSet(TileSet frameSet, int[] frames, int animDuration) {
        Paintable p = new Paintable();
        p.frames = new Paintable[frames.length];
        for (int i = 0; i < frames.length; ++i) {
            p.frames[i] = new Paintable(frameSet, frames[i]);
        }
        p.int_1 = 0;
        p.int_2 = animDuration;
        p.type = 1;
        return p;
    }

    public Paintable(Image img) {
        this.type = 0;
        this.img = img;
        this.int_1 = img.getWidth();
        this.int_2 = img.getHeight();
    }

    public Paintable(int width, int height) {
        this.elements = new Vector();
        this.pos = new Vector();
        this.int_1 = width;
        this.int_2 = height;
        this.type = 2;
        this.setAutoResize(false);
    }

    public static final Paintable createCompositionWithAutoResize() {
        Paintable p = new Paintable();
        p.elements = new Vector();
        p.pos = new Vector();
        p.type = 2;
        p.setAutoResize(true);
        return p;
    }

    Paintable(String text, ImageFont font) {
        this.text = new String[]{text};
        this.font = font;
        this.int_3 = 4;
        this.int_2 = this.int_1 = font.getStringWidth(text);
        this.type = 3;
    }

    Paintable(String text, ImageFont font, int halign, int width) {
        this.text = font.wrap(text, width);
        this.font = font;
        this.int_3 = halign;
        this.int_1 = width;
        if (this.text.length > 0) {
            this.int_2 = font.getStringWidth(this.text[0]);
            for (int i = 1; i < this.text.length; ++i) {
                this.int_2 = Math.max(this.int_2, font.getStringWidth(this.text[0]));
            }
        } else {
            this.text = new String[]{""};
            this.int_2 = 0;
        }
        this.type = 3;
    }

    Paintable(TileSet tileSet, int id) {
        this.tileset = tileSet;
        this.int_1 = id;
        this.type = 4;
    }

    public int getTileId() {
        return this.int_1;
    }

    public int getWidth() {
        switch (this.type) {
            case -1: {
                return this.int_1;
            }
            case 0: {
                return this.int_1;
            }
            case 1: {
                return this.getActualFrame().getWidth();
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return this.int_1;
            }
            case 3: {
                return this.int_1;
            }
            case 4: {
                return this.tileset.pos[this.int_1][2];
            }
            case 5: {
                if (this.start.getAnimationCycles() == 0) {
                    return this.start.getWidth();
                }
                return this.cont.getWidth();
            }
            case 7: {
                return this.start.getWidth() - this.intTab_1[0] - this.intTab_1[2];
            }
        }
        return 0;
    }

    public int getHeight() {
        switch (this.type) {
            case -1: {
                return this.int_2;
            }
            case 0: {
                return this.int_2;
            }
            case 1: {
                return this.getActualFrame().getHeight();
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return this.int_2;
            }
            case 3: {
                return this.text.length * this.font.getHeight();
            }
            case 4: {
                return this.tileset.pos[this.int_1][3];
            }
            case 5: {
                if (this.start.getAnimationCycles() == 0) {
                    return this.start.getHeight();
                }
                return this.cont.getHeight();
            }
            case 7: {
                return this.start.getHeight() - this.intTab_1[1] - this.intTab_1[3];
            }
        }
        return 0;
    }

    public void setWidth(int w) {
        this.int_1 = w;
    }

    public void setHeight(int h) {
        this.int_2 = h;
    }

    public void addElement(int x, int y, Paintable el) {
        this.elements.addElement(el);
        this.pos.addElement(new Point(x, y));
        if (this.getAutoResize()) {
            if (x + el.getWidth() > this.getWidth()) {
                this.int_1 = x + el.getWidth();
            }
            if (y + el.getHeight() > this.getHeight()) {
                this.int_2 = y + el.getHeight();
            }
        }
    }

    public void addElement(int x, int y, Paintable el, int anchor) {
        x = TileSet.transformX(x, el.getWidth(), anchor);
        y = TileSet.transformY(y, el.getHeight(), anchor);
        this.addElement(x, y, el);
    }

    public int getAnimationCycles() {
        switch (this.type) {
            case 1: {
                return this.getAnimationTime() / this.getAnimationDuration();
            }
            case 5: {
                if (this.start.getAnimationCycles() == 0) {
                    return 0;
                }
                return this.cont.getAnimationCycles();
            }
        }
        return Integer.MAX_VALUE;
    }

    public void update(int elapsedTime) {
        switch (this.type) {
            case 1: {
                this.setAnimationTime(this.getAnimationTime() + elapsedTime);
                break;
            }
            case 2: {
                for (int i = 0; i < this.elements.size(); ++i) {
                    ((Paintable)this.elements.elementAt(i)).update(elapsedTime);
                }
                break;
            }
            case 5: {
                if (this.start.getAnimationCycles() == 0) {
                    this.start.update(elapsedTime);
                    break;
                }
                this.cont.update(elapsedTime);
                break;
            }
            case 7: {
                this.start.update(elapsedTime);
            }
        }
    }

    public Paintable copy() {
        switch (this.type) {
            case -1: 
            case 0: {
                if (this.resourceId != -1) {
                    return Paintable.createFromResMan(this.resourceId);
                }
                return Paintable.createImage(this.imgName);
            }
            case 1: {
                Paintable p = new Paintable();
                p.type = this.type;
                p.frames = this.frames;
                p.int_1 = this.int_1;
                p.int_2 = this.int_2;
                return p;
            }
            case 2: {
                Paintable p = new Paintable(this.int_1, this.int_2);
                p.setAutoResize(this.getAutoResize());
                for (int i = 0; i < this.elements.size(); ++i) {
                    Point po = (Point)this.pos.elementAt(i);
                    Paintable pa = (Paintable)this.elements.elementAt(i);
                    p.addElement(po.x, po.y, pa.copy());
                }
                return p;
            }
            case 3: {
                Paintable p = new Paintable();
                p.text = this.text;
                p.font = this.font;
                p.int_1 = this.int_1;
                p.int_2 = this.int_2;
                p.int_3 = this.int_3;
                return p;
            }
            case 4: {
                return new Paintable(this.tileset, this.int_1);
            }
            case 5: {
                return Paintable.createPaintableWithStartAnim(this.start, this.cont);
            }
            case 6: {
                return Paintable.createInvisibleRect(this.getWidth(), this.getHeight());
            }
            case 7: {
                return Paintable.createClippedPaintable(this.start, this.intTab_1[0], this.intTab_1[1], this.intTab_1[2], this.intTab_1[3]);
            }
            case 8: {
                return Paintable.createRect(this.getWidth(), this.getHeight(), this.getRgb());
            }
            case 9: {
                return Paintable.createFilledRect(this.getWidth(), this.getHeight(), this.getRgb());
            }
            case 10: {
                return Paintable.createRoundRect(this.getWidth(), this.getHeight(), this.getRgb(), this.getRound());
            }
            case 11: {
                return Paintable.createFilledRoundRect(this.getWidth(), this.getHeight(), this.getRgb(), this.getRound());
            }
        }
        return null;
    }

    public void paint(Graphics g, int x, int y, int anchor) {
        switch (this.type) {
            case 0: {
                if (this.mirror) {
                    x = TileSet.transformX(x, this.int_1, anchor);
                    y = TileSet.transformY(y, this.int_2, anchor);
                    this.getMirrorImage().setPosition(x, y);
                    this.getMirrorImage().paint(g);
                    break;
                }
                g.drawImage(this.getImage(), x, y, anchor);
                break;
            }
            case 1: {
                this.getActualFrame().paint(g, x, y, anchor);
                break;
            }
            case 2: {
                x = TileSet.transformX(x, this.int_1, anchor);
                y = TileSet.transformY(y, this.int_2, anchor);
                for (int i = 0; i < this.elements.size(); ++i) {
                    ((Paintable)this.elements.elementAt(i)).paint(g, x + ((Point)this.pos.elementAt((int)i)).x, y + ((Point)this.pos.elementAt((int)i)).y, 0x10 | 4);
                }
                break;
            }
            case 3: {
                this.font.write(g, this.text, x, y, anchor, 0, this.text.length, this.int_3, this.int_1);
                break;
            }
            case 4: {
                this.tileset.paint(g, x, y, this.int_1, anchor, this.mirror);
                break;
            }
            case 5: {
                if (this.start.getAnimationCycles() == 0) {
                    this.start.paint(g, x, y, anchor);
                    break;
                }
                this.cont.paint(g, x, y, anchor);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                x = TileSet.transformX(x, this.getWidth(), anchor);
                y = TileSet.transformY(y, this.getHeight(), anchor);
                DispManager.saveClip(g);
                g.clipRect(x, y, this.getWidth(), this.getHeight());
                this.start.paint(g, x - this.intTab_1[0], y - this.intTab_1[1], 0x10 | 4);
                DispManager.loadClip(g);
                break;
            }
            case 8: {
                x = TileSet.transformX(x, this.getWidth(), anchor);
                y = TileSet.transformY(y, this.getHeight(), anchor);
                g.setColor(this.getRgb());
                g.drawRect(x, y, this.getWidth(), this.getHeight());
                break;
            }
            case 9: {
                x = TileSet.transformX(x, this.getWidth(), anchor);
                y = TileSet.transformY(y, this.getHeight(), anchor);
                g.setColor(this.getRgb());
                g.fillRect(x, y, this.getWidth(), this.getHeight());
                break;
            }
            case 11: {
                x = TileSet.transformX(x, this.getWidth(), anchor);
                y = TileSet.transformY(y, this.getHeight(), anchor);
                g.setColor(this.getRgb());
                g.fillRoundRect(x, y, this.getWidth(), this.getHeight(), this.getRound(), this.getRound());
                break;
            }
            case 10: {
                x = TileSet.transformX(x, this.getWidth(), anchor);
                y = TileSet.transformY(y, this.getHeight(), anchor);
                g.setColor(this.getRgb());
                g.drawRoundRect(x, y, this.getWidth(), this.getHeight(), this.getRound(), this.getRound());
            }
        }
    }

    private Image getImage() {
        if (this.img == null) {
            try {
                this.img = Image.createImage((String)("/" + this.imgName + ".png"));
            }
            catch (IOException ex) {
                System.out.println("blad w czasie wczytywania obrazka: " + this.imgName);
            }
        }
        return this.img;
    }

    public Sprite getMirrorImage() {
        if (this.mirrorImage == null) {
            this.mirrorImage = new Sprite(this.getImage());
            this.mirrorImage.setTransform(2);
        }
        return this.mirrorImage;
    }

    public final int getActualFrameNum() {
        return this.getAnimationDuration() == 0 ? 0 : this.getAnimationTime() * this.frames.length / this.getAnimationDuration() % this.frames.length;
    }

    public Paintable getActualFrame() {
        return this.frames[this.getActualFrameNum()];
    }

    public final void setAnimationTime(int a) {
        this.int_1 = a;
    }

    public final int getAnimationTime() {
        return this.int_1;
    }

    public final void setAnimationDuration(int a) {
        this.int_2 = a;
    }

    public final int getAnimationDuration() {
        return this.int_2;
    }

    public final void setAutoResize(boolean resize) {
        this.bool_1 = resize;
    }

    public final boolean getAutoResize() {
        return this.bool_1;
    }

    public static final int halign(int width, int halign, int elementWidth) {
        if ((halign & 1) != 0) {
            return width - elementWidth >> 1;
        }
        if ((halign & 8) != 0) {
            return width - elementWidth;
        }
        return 0;
    }

    public int getResourceId() {
        return this.resourceId;
    }

    public static final void addToLoad(Paintable p) {
        if (p == null) {
            return;
        }
        if (p.resourceId != -1) {
            Paintable.resources[p.resourceId] = p;
            Paintable.toLoad[p.resourceId] = true;
        } else {
            switch (p.type) {
                case 1: {
                    for (int i = 0; i < p.frames.length; ++i) {
                        Paintable.addToLoad(p.frames[i]);
                    }
                    break;
                }
                case 7: {
                    Paintable.addToLoad(p.start);
                    break;
                }
                case 5: {
                    Paintable.addToLoad(p.start);
                    Paintable.addToLoad(p.cont);
                    break;
                }
                case 2: {
                    for (int i = 0; i < p.elements.size(); ++i) {
                        Paintable.addToLoad((Paintable)p.elements.elementAt(i));
                    }
                    break;
                }
                case 4: {
                    Paintable.addToLoad(p.tileset.img);
                }
            }
        }
    }

    public static final Paintable addToLoad(int resourceId) {
        Paintable r = Paintable.createFromResMan(resourceId);
        Paintable.addToLoad(r);
        return r;
    }

    public static void releaseResourceMemory() {
        Enumeration en = res.elements();
        while (en.hasMoreElements()) {
            Object obj = en.nextElement();
            if (!(obj instanceof Paintable)) continue;
            Paintable p = (Paintable)obj;
            if (toLoad[p.resourceId] || p.getType() != 0) continue;
            p.img = null;
            p.type = -1;
        }
    }

    public static void releaseAllResourceMemory() {
        Enumeration en = res.elements();
        while (en.hasMoreElements()) {
            Paintable p;
            Object obj = en.nextElement();
            if (!(obj instanceof Paintable) || (p = (Paintable)obj).getType() != 0) continue;
            p.img = null;
            p.type = -1;
        }
    }

    public static void loadResources(boolean releasePrevious) {
        try {
            while (loading > 0) {
                DispManager.message = "loadResources waiting";
                Thread.sleep(30L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ++loading;
        if (releasePrevious) {
            DispManager.message = "loadResources release resources";
            Paintable.releaseResourceMemory();
            DispManager.message = "/loadResources release resources";
        }
        int maxIndex = 0;
        ResManParser rmp = null;
        loaded = 0;
        toLoadNum = 0;
        for (int i = 0; i < 138; ++i) {
            if (!toLoad[i]) continue;
            Paintable p = (Paintable)resources[i];
            if (p.type != -1) continue;
            ++toLoadNum;
            maxIndex = i;
        }
        isLoading = true;
        if (toLoadNum == 0) {
            resources = new Object[138];
            toLoad = new boolean[138];
            isLoading = false;
            --loading;
            return;
        }
        try {
            DispManager.message = "loadResources init a";
            PartialInputStream pis = new PartialInputStream(PACK_PRE, PACK_POST, 200000);
            DispManager.message = "loadResources init b";
            rmp = new ResManParser(pis);
            DispManager.message = "/loadResources init";
            int lastLoaded = 0;
            block9: for (int i = 0; i <= maxIndex; ++i) {
                if (!toLoad[i]) continue;
                Paintable p = (Paintable)resources[i];
                DispManager.message = "skip " + i;
                rmp.skip(i - lastLoaded);
                DispManager.message = "/skip " + i;
                lastLoaded = i;
                switch (rmp.getActualType()) {
                    case 1: {
                        if (p.type != -1) continue block9;
                        DispManager.message = "getImage " + i;
                        Image img = rmp.getImage();
                        DispManager.message = "/getImage " + i;
                        p.type = 0;
                        p.img = img;
                        p.int_1 = p.getImage().getWidth();
                        p.int_2 = p.getImage().getHeight();
                        ++loaded;
                        continue block9;
                    }
                    default: {
                        System.err.println("Za\u017c\u0105dano wczytania zasobu nieznanego typu.");
                    }
                }
            }
            rmp.close();
            rmp = null;
            System.gc();
        }
        catch (Throwable e) {
            e.printStackTrace();
            DispManager.reportError(new Exception(e + "\nloadResources"));
        }
        for (int i = 0; i < resources.length; ++i) {
            Paintable.resources[i] = null;
            Paintable.toLoad[i] = false;
        }
        isLoading = false;
        DispManager.message = "loadResources ended";
        --loading;
    }

    public void run() {
        loaded = 0;
        try {
            ResManParser rmp = new ResManParser(new PartialInputStream(PACK_PRE, PACK_POST, 200000));
            for (int i = 0; i < 138; ++i) {
                if (rmp.getActualType() == 1) {
                    rmp.parseImageHeader();
                    Paintable p = Paintable.createFromResMan(i);
                    p.int_1 = rmp.width;
                    p.int_2 = rmp.height;
                    rmp.dis.skip(rmp.getResSize(i) - 6);
                    rmp.hasBeenLoaded = true;
                    rmp.parsed = true;
                    rmp.next();
                    continue;
                }
                rmp.next();
            }
            rmp.close();
            rmp = null;
        }
        catch (Exception e) {
            DispManager.reportError(new Exception(e.toString() + "\nloadSizes"));
        }
        isPreloading = false;
        wasPreloaded = true;
    }

    public static void loadSizes() {
        if (wasPreloaded) {
            return;
        }
        isPreloading = true;
        new Thread(new Paintable()).start();
    }

    public Paintable addToLoad() {
        Paintable.addToLoad(this);
        return this;
    }

    public static void paintInOneColor(Graphics g, Image img, int gx, int gy, int gw, int gh, int iX, int iY, int color) {
        int[] data = new int[gw * gh];
        img.getRGB(data, 0, gw, gx, gy, gw, gh);
        g.setColor(color);
        for (int sy = 0; sy < gh; ++sy) {
            int offset = gw * sy;
            int ax = -1;
            for (int x = 0; x < gw; ++x) {
                if ((data[offset + x] & 0xFF000000) != 0) {
                    if (ax != -1) continue;
                    ax = x;
                    continue;
                }
                if (ax == -1) continue;
                g.fillRect(ax + iX, iY + sy, x - ax, 1);
                ax = -1;
            }
        }
    }

    public static Image imageToOneColor(Graphics g, Image img, int scale, int tr, int tg, int tb, int[] px, int x, int y, int w, int h) {
        int[] data = px == null ? new int[w * h] : px;
        img.getRGB(data, 0, w, x, y, w, h);
        for (int i = 0; i < data.length; ++i) {
            int ca = data[i] >> 24;
            int cr = data[i] >> 16 & 0xFF;
            int cg = data[i] >> 8 & 0xFF;
            int cb = data[i] & 0xFF;
            data[i] = ca << 24 | cr * (1024 - scale) + tr * scale >> 10 << 16 | cg * (1024 - scale) + tg * scale >> 10 << 8 | cb * (1024 - scale) + tb * scale >> 10;
        }
        Image im = Image.createRGBImage((int[])data, (int)w, (int)h, (boolean)true);
        return im;
    }

    public static Image imageToGrayScale(Image img) {
        int[] data = new int[img.getWidth() * img.getHeight()];
        img.getRGB(data, 0, img.getWidth(), 0, 0, img.getWidth(), img.getHeight());
        for (int i = 0; i < data.length; ++i) {
            int ca = data[i] >> 24;
            int cr = data[i] >> 16 & 0xFF;
            int cg = data[i] >> 8 & 0xFF;
            int cb = data[i] & 0xFF;
            int g = (cr + cg + cb) / 3;
            data[i] = ca << 24 | g << 16 | g << 8 | g;
        }
        Image im = Image.createRGBImage((int[])data, (int)img.getWidth(), (int)img.getHeight(), (boolean)true);
        return im;
    }

    public static Paintable createFormatedPaintable(String s, ImageFont[] fonts, String[] inputs, int width, int halign, boolean fitSmallContent) {
        DispManager.message = "createFormatedPaintable";
        Paintable p = Paintable.createCompositionWithAutoResize();
        p.addElement(0, 0, Paintable.createInvisibleRect(width, 0));
        for (int i = 0; i < s.length() - 1; ++i) {
            if (s.charAt(i) == '%') {
                if (s.charAt(i + 1) == '%') {
                    s = s.substring(0, i) + s.substring(i + 1, s.length());
                    continue;
                }
                int[] t = Paintable.loadInt(s, i + 1);
                s = s.substring(0, i) + inputs[t[1]] + s.substring(t[0], s.length());
                i = t[0] - 1;
                continue;
            }
            if (s.charAt(i) != '\\') continue;
            if (s.charAt(i + 1) == '\\') {
                s = s.substring(0, i) + s.substring(i + 1, s.length());
            }
            if (s.charAt(i + 1) != 'n') continue;
            s = s.substring(0, i) + '\n' + s.substring(i + 2, s.length());
        }
        ImageFont font = fonts[0];
        ImageFont startFont = fonts[0];
        int lineWidth = 0;
        int lineHeight = 0;
        int lineStart = 0;
        int chars = 0;
        int valign = 2;
        boolean addLine = false;
        for (int i = 0; i < s.length(); ++i) {
            char c;
            if (s.charAt(i) == '#' && i != s.length() - 1 && s.charAt(i + 1) != '#') {
                chars = 0;
                int[] t = Paintable.loadInt(s, i + 1);
                font = fonts[t[1]];
                i = t[0] - 1;
                continue;
            }
            if (s.charAt(i) == '$' && i != s.length() - 1 && s.charAt(i + 1) != '$' && i < s.length() - 1 && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '9') {
                chars = 0;
                int[] t = Paintable.loadInt(s, i + 1);
                Paintable paintable = Paintable.createFromResMan(t[1]);
                if (lineWidth + paintable.getWidth() >= width) {
                    if (4 == halign) {
                        p.addElement(0, p.getHeight(), Paintable.createLine(lineHeight, s, lineStart, i, startFont, fonts, valign, false, addLine));
                    } else if (1 == halign) {
                        p.addElement(width >> 1, p.getHeight(), Paintable.createLine(lineHeight, s, lineStart, i, startFont, fonts, valign, false, addLine), 17);
                    } else {
                        p.addElement(width, p.getHeight(), Paintable.createLine(lineHeight, s, lineStart, i, startFont, fonts, valign, false, addLine), 24);
                    }
                    lineWidth = paintable.getWidth();
                    startFont = font;
                    lineStart = i--;
                    lineHeight = 0;
                } else {
                    lineWidth += paintable.getWidth();
                }
                lineHeight = Math.max(paintable.getHeight(), lineHeight);
                i = t[0] - 1;
                continue;
            }
            if (s.charAt(i) == '@' && i != s.length() - 1 && s.charAt(i + 1) != '@') {
                chars = 0;
                switch (s.charAt(++i)) {
                    case 'C': {
                        valign = 2;
                        break;
                    }
                    case 'T': {
                        valign = 16;
                        break;
                    }
                    case 'B': {
                        valign = 32;
                    }
                }
                continue;
            }
            lineHeight = Math.max(font.getHeight(), lineHeight);
            if ((s.charAt(i) == '$' || s.charAt(i) == '#' || s.charAt(i) == '@') && s.charAt(i) == s.charAt(i + 1)) {
                ++i;
            }
            if (lineWidth + font.getCharWidth(c = s.charAt(i)) >= width || c == '\n') {
                if (c == '\n') {
                    addLine = true;
                }
                int startChars = i - chars;
                startChars = Math.max(0, startChars);
                boolean add = false;
                if (c != '\n') {
                    if (startChars != lineStart) {
                        while (i > startChars && i > 0 && i > lineStart) {
                            lineWidth -= font.getCharWidth(s.charAt(i));
                            --i;
                        }
                    } else {
                        add = true;
                        while (i > startChars && lineWidth + font.getCharWidth('-') > width) {
                            lineWidth -= font.getCharWidth(s.charAt(i));
                            --i;
                        }
                    }
                }
                if (4 == halign) {
                    p.addElement(0, p.getHeight(), Paintable.createLine(lineHeight, s, lineStart, i, startFont, fonts, valign, add, addLine));
                } else if (1 == halign) {
                    p.addElement(width >> 1, p.getHeight(), Paintable.createLine(lineHeight, s, lineStart, i, startFont, fonts, valign, add, addLine), 17);
                } else {
                    p.addElement(width, p.getHeight(), Paintable.createLine(lineHeight, s, lineStart, i, startFont, fonts, valign, add, addLine), 24);
                }
                lineWidth = 0;
                startFont = font;
                if (c == '\n') {
                    lineStart = i + 1;
                } else {
                    for (lineStart = i; lineStart < s.length() && Paintable.isWhiteChar(s.charAt(lineStart)); ++lineStart) {
                    }
                    lineWidth += font.getCharWidth(s.charAt(i));
                }
                lineHeight = 0;
                chars = 1;
                addLine = false;
                continue;
            }
            chars = !Paintable.isWhiteChar(s.charAt(i)) ? ++chars : 0;
            lineWidth += font.getCharWidth(s.charAt(i));
        }
        if (4 == halign) {
            p.addElement(0, p.getHeight(), Paintable.createLine(lineHeight, s, lineStart, s.length(), startFont, fonts, valign, false, addLine));
        } else if (1 == halign) {
            p.addElement(width >> 1, p.getHeight(), Paintable.createLine(lineHeight, s, lineStart, s.length(), startFont, fonts, valign, false, addLine), 17);
        } else {
            p.addElement(width, p.getHeight(), Paintable.createLine(lineHeight, s, lineStart, s.length(), startFont, fonts, valign, false, addLine), 24);
        }
        p.elements.removeElementAt(0);
        p.pos.removeElementAt(0);
        if (fitSmallContent && p.elements.size() == 1) {
            Paintable pa = (Paintable)p.elements.elementAt(0);
            p.setWidth(pa.getWidth());
            p.setHeight(pa.getHeight());
            Point po = (Point)p.pos.elementAt(0);
            po.x = 0;
            po.y = 0;
        }
        DispManager.message = "/createFormatedPaintable";
        return p;
    }

    private static final boolean isWhiteChar(char c) {
        return c == ' ' || c == '\n' || c == '\r' || c == '\t';
    }

    private static Paintable createLine(int height, String s, int spos, int epos, ImageFont font, ImageFont[] fonts, int valign, boolean add, boolean addLine) {
        Paintable p = Paintable.createCompositionWithAutoResize();
        p.addElement(0, 0, Paintable.createInvisibleRect(0, height));
        if (add) {
            if (epos == s.length()) {
                epos += 45;
            }
            ++epos;
        }
        for (int i = spos; i < epos; ++i) {
            int[] t;
            if (s.charAt(i) == '#' && i < s.length() - 1 && s.charAt(i + 1) != '#') {
                t = Paintable.loadInt(s, i + 1);
                font = fonts[t[1]];
                i = t[0] - 1;
                continue;
            }
            if (s.charAt(i) == '@' && i < s.length() - 1 && s.charAt(i + 1) != '@') {
                ++i;
                continue;
            }
            if (s.charAt(i) == '$' && i < s.length() - 1 && s.charAt(i + 1) != '$') {
                t = Paintable.loadInt(s, i + 1);
                Paintable paintable = Paintable.createFromResMan(t[1]).addToLoad();
                switch (valign) {
                    case 2: {
                        p.addElement(p.getWidth(), p.getHeight() / 2, paintable, 6);
                        break;
                    }
                    case 16: {
                        p.addElement(p.getWidth(), 0, paintable, 20);
                        break;
                    }
                    case 32: {
                        p.addElement(p.getWidth(), p.getHeight(), paintable, 36);
                    }
                }
                i = t[0];
                continue;
            }
            String str = "";
            while (!(i >= epos || s.charAt(i) == '$' && s.charAt(i + 1) != '$' || s.charAt(i) == '#' && s.charAt(i + 1) != '#')) {
                if ((s.charAt(i) == '$' || s.charAt(i) == '#') && s.charAt(i) == s.charAt(i + 1)) {
                    ++i;
                }
                str = str + s.charAt(i);
                ++i;
            }
            if (i + 1 < epos && (s.charAt(i) == '$' && s.charAt(i + 1) != '$' || s.charAt(i) == '#' && s.charAt(i + 1) != '#')) {
                --i;
            }
            switch (valign) {
                case 2: {
                    p.addElement(p.getWidth(), p.getHeight() / 2, new Paintable(str, font), 6);
                    break;
                }
                case 16: {
                    p.addElement(p.getWidth(), 0, new Paintable(str, font), 20);
                    break;
                }
                case 32: {
                    p.addElement(p.getWidth(), p.getHeight(), new Paintable(str, font), 36);
                }
            }
            addLine = true;
        }
        if (addLine) {
            return p;
        }
        return Paintable.createInvisibleRect(0, 0);
    }

    private static int[] loadInt(String s, int pos) {
        int c = 48;
        int n = 0;
        while (pos < s.length()) {
            char c2 = s.charAt(pos);
            c = c2;
            if (c2 < '0') break;
            char c3 = s.charAt(pos);
            c = c3;
            if (c3 > '9') break;
            n = n * 10 + c - 48;
            ++pos;
        }
        int[] res = new int[]{pos, n};
        return res;
    }

    static {
        wasPreloaded = false;
    }
}

