/*
 * Decompiled with CFR 0.152.
 */
package com.fazzidice;

import com.fazzidice.Croco;
import com.fazzidice.Disp;
import com.fazzidice.DispManager;
import com.fazzidice.Game;
import com.fazzidice.ImageFont;
import com.fazzidice.MIButton;
import com.fazzidice.MILabel;
import com.fazzidice.MIScrollable;
import com.fazzidice.Main;
import com.fazzidice.MenuItem;
import com.fazzidice.Paintable;
import com.fazzidice.Point;
import com.fazzidice.Saver;
import com.fazzidice.SkyCashClient;
import com.fazzidice.Sprite;
import com.fazzidice.Text;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.TextMessage;

public class Menu
extends Disp
implements CommandListener,
Runnable {
    private static final int SCROLL_TIME = 500;
    private static final int VMARGIN = 3;
    private Vector elements = new Vector();
    protected int selectedPos;
    protected long changeTime;
    protected int offsetY;
    protected int newOffsetY;
    protected int valign = 16;
    protected boolean fixedSize = false;
    protected Paintable bg;
    protected MILabel header;
    protected MILabel footer;
    protected MILabel leftNavi;
    protected MILabel rightNavi;
    private Vector[] keyPressedListeners = new Vector[20];
    private Vector[] keyReleasedListeners = new Vector[20];
    private Vector keyAnyPressedListeners;
    private Vector keyAnyReleasedListeners;
    private int ty = 0;
    private Sprite selectedByPointer;
    Point pressPoint;
    Point actualPoint;
    Point releasePoint;
    private boolean leftSoftKeyPressedByPointer = false;
    private boolean rightSoftKeyPressedByPointer = false;
    int lastY;
    private boolean firstRun = true;
    public static final int TROPHIES = 11;
    public static final int SETTINGS = 10;
    public static final int TEXT_DISP = 9;
    public static final int SKY_CASH = 8;
    public static final int BONUS = 7;
    public static final int HELP = 6;
    public static final int WALLPAPER_BUY = 5;
    public static final int WALLPAPERS = 4;
    public static final int MAIN_MENU = 3;
    public static final int SPLASH = 2;
    public static final int DO_YOU_WANT_SOUND = 1;
    int id;
    public static Paintable[] trophyImgs = new Paintable[]{Paintable.createFromResMan(4), Paintable.createFromResMan(55), Paintable.createFromResMan(127), Paintable.createFromResMan(48), Paintable.createFromResMan(62), Paintable.createFromResMan(75), Paintable.createFromResMan(94), Paintable.createFromResMan(96)};
    private static Paintable[] wallpapers = new Paintable[0];
    Disp next;
    int wallpaperId;
    private static Paintable[] buttonUnfocused = new Paintable[]{Paintable.createFromResMan(8), Paintable.createFromResMan(10), Paintable.createFromResMan(12)};
    private static Paintable[] buttonFocused = new Paintable[]{Paintable.createFromResMan(7), Paintable.createFromResMan(9), Paintable.createFromResMan(11)};
    static Paintable[] clouds = new Paintable[]{Paintable.createFromResMan(25), Paintable.createFromResMan(26), Paintable.createFromResMan(27)};
    private static long firstBgShow = 0L;
    private static long hitBg = 0L;
    private static long lastPhase = -1L;
    private static int chickenSide = 0;
    private static int chickenCoord = 0;
    private static final int BLINK_ANIM = 300;
    private static final int NO_CHICKEN_TIME = 3500;
    private static final int CHICKEN_SHOW = 1500;
    private static final int CHICKEN_BLINK = 1000;
    private static final int CHICKEN_HIDE = 500;
    private static final int CHICKEN_CYCLE = 6500;
    private static final int HIT_TIME = 1250;
    private static final int SHOW_TIME = 600;
    private static Paintable chickenNormal = new Paintable(Main.chicken1);
    private static Paintable[] chickenBlink = new Paintable[]{new Paintable(Main.chicken1), new Paintable(Main.chicken2)};
    private static Paintable[] hitAnim = new Paintable[]{Paintable.createFromResMan(44), Paintable.createFromResMan(44), Paintable.createFromResMan(45), Paintable.createFromResMan(45), Paintable.createFromResMan(46), Paintable.createFromResMan(46), Paintable.createFromResMan(47), Paintable.createFromResMan(47), Paintable.createFromResMan(33), Paintable.createFromResMan(33), Paintable.createFromResMan(34), Paintable.createFromResMan(34), Paintable.createFromResMan(33), Paintable.createFromResMan(33), Paintable.createFromResMan(34), Paintable.createFromResMan(34)};
    Image captcha;
    int payFor;
    String in1 = "";
    String in2 = "";
    String in3 = "";

    public Menu() {
        super(1);
        for (int i = 0; i < 20; ++i) {
            this.keyPressedListeners[i] = new Vector();
            this.keyReleasedListeners[i] = new Vector();
        }
    }

    public void setKeyAnyPressedListeners(Vector keyAnyPressedListeners) {
        this.keyAnyPressedListeners = keyAnyPressedListeners;
    }

    public void setKeyAnyReleasedListeners(Vector keyAnyReleasedListeners) {
        this.keyAnyReleasedListeners = keyAnyReleasedListeners;
    }

    public void addKeyPressedListener(MenuItem mi, int key) {
        this.keyPressedListeners[key].addElement(mi);
    }

    public void addKeyReleasedListener(MenuItem mi, int key) {
        this.keyReleasedListeners[key].addElement(mi);
    }

    private void setOffset() {
        this.offsetY = (int)((long)this.offsetY + (long)(this.newOffsetY - this.offsetY) * ((long)this.gameTime - this.changeTime) / 500L);
    }

    public void centerOn(MenuItem mi, int s) {
        this.setOffset();
        this.newOffsetY = this.toPx(mi.y - mi.getHeight() / 2) - this.getHeightForContent() / 2;
        int h = this.toPx(this.getItem((int)(this.getItemsNum() - 1)).y) - this.getHeightForContent();
        if (this.newOffsetY > h) {
            this.newOffsetY = h;
        }
        if (this.newOffsetY < 0) {
            this.newOffsetY = 0;
        }
        this.changeTime = this.gameTime;
    }

    public void setFixedSize(boolean fixedSize) {
        this.fixedSize = fixedSize;
        if (fixedSize) {
            this.fitSize();
        }
    }

    public boolean isFixedSize() {
        return this.fixedSize;
    }

    public void fitSize() {
        if (this.getItemsNum() <= 0) {
            return;
        }
        int toCut = this.getItem((int)(this.getItemsNum() - 1)).y - this.getHeightForContent();
        if (toCut > 0) {
            int i;
            int s;
            MenuItem mi;
            int i2;
            for (i2 = 0; i2 < this.getItemsNum(); ++i2) {
                mi = this.getItem(i2);
                if (mi.getHeight() <= mi.getPreferredHeight()) continue;
                s = mi.getHeight();
                mi.setHeight(mi.getPreferredHeight());
                toCut -= s - mi.getHeight();
            }
            for (i2 = 0; i2 < this.getItemsNum(); ++i2) {
                mi = this.getItem(i2);
                if (!mi.isResizeable) continue;
                s = mi.getHeight();
                mi.setHeight(Math.max(mi.getHeight() - toCut, mi.getMinimumHeight()));
                toCut -= s - mi.getHeight();
            }
            this.selectedPos = 0;
            Vector<MenuItem> v = new Vector<MenuItem>();
            for (i = 0; i < this.getItemsNum(); ++i) {
                v.addElement(this.getItem(i));
            }
            for (i = this.getItemsNum() - 1; i >= 0; --i) {
                this.removeItem(i);
            }
            this.cleanupRemovedSprites();
            for (i = 0; i < v.size(); ++i) {
                MenuItem mi2 = (MenuItem)v.elementAt(i);
                mi2.y = 0;
                this.addItem(mi2);
            }
        }
    }

    public void setBg(Paintable bg) {
        this.bg = bg;
    }

    public void keyPressed(int keyCode) {
        int key = DispManager.translateKey(keyCode);
        if (!this.getItem(this.selectedPos).keyPressed(keyCode)) {
            int s = this.selectedPos;
            if (DispManager.translateKey(keyCode) == 2) {
                do {
                    this.selectedPos = (this.selectedPos + this.getItemsNum() - 1) % this.getItemsNum();
                } while (this.selectedPos != s && !this.getItem((int)this.selectedPos).isNavigable);
                if (s <= this.selectedPos) {
                    this.setOffset();
                    this.selectedPos = s;
                    this.changeTime = this.gameTime;
                    this.newOffsetY = Math.max(0, this.offsetY - this.height / 4);
                }
            } else if (DispManager.translateKey(keyCode) == 4) {
                do {
                    ++this.selectedPos;
                    this.selectedPos %= this.getItemsNum();
                } while (this.selectedPos != s && !this.getItem((int)this.selectedPos).isNavigable);
                if (s >= this.selectedPos) {
                    this.selectedPos = s;
                    if (this.getContentHeight() > this.getHeightForContent()) {
                        this.setOffset();
                        this.changeTime = this.gameTime;
                        this.newOffsetY = Math.min(this.offsetY + this.height / 4, this.toPx(this.getItem((int)(this.getItemsNum() - 1)).y) - this.getHeightForContent());
                    }
                }
            } else {
                this.proceedKeyPressed(DispManager.translateKey(key));
            }
            if (s != this.selectedPos) {
                this.getItem(s).setIsSelected(false);
                MenuItem sel = this.getItem(this.selectedPos);
                sel.setIsSelected(true);
                this.centerOn(sel, this.selectedPos);
            }
        }
        this.setNaviLabelsBg();
    }

    public void keyReleased(int keyCode) {
        int key = DispManager.translateKey(keyCode);
        if (!this.getItem(this.selectedPos).keyReleased(keyCode)) {
            if (key == 19) {
                this.onChoose(this.getItem(this.selectedPos).getLabel(), this.getItem(this.selectedPos));
                return;
            }
            this.proceedKeyReleased(DispManager.translateKey(keyCode));
        }
        this.setNaviLabelsBg();
    }

    public void setValign(int valign) {
        this.valign = valign;
    }

    public void setHeader(MILabel header) {
        this.header = header;
        header.x = this.fromPx(this.width - header.getWidth() >> 1);
        header.y = this.fromPx(header.getHeight());
        header.parent = this;
    }

    public void setFooter(MILabel footer) {
        this.footer = footer;
        footer.x = this.fromPx(this.width - footer.getWidth() >> 1);
        footer.y = this.fromPx(this.getHeight());
        footer.parent = this;
    }

    public void setLeftNavi(MILabel leftNavi) {
        this.leftNavi = leftNavi;
        leftNavi.x = 0;
        leftNavi.y = this.fromPx(this.getHeight());
        leftNavi.parent = this;
    }

    public void setRightNavi(MILabel rightNavi) {
        this.rightNavi = rightNavi;
        rightNavi.x = this.fromPx(this.width - rightNavi.getWidth());
        rightNavi.y = this.fromPx(this.getHeight());
        rightNavi.parent = this;
    }

    public int getHeightForContent() {
        return this.getHeight() - (this.header != null ? this.header.getHeight() : 0) - this.getFooterHeight();
    }

    public int getFooterHeight() {
        int foot = 0;
        if (this.footer != null) {
            foot = Math.max(this.footer.getHeight(), foot);
        }
        if (this.leftNavi != null) {
            foot = Math.max(this.leftNavi.getHeight(), foot);
        }
        if (this.rightNavi != null) {
            foot = Math.max(this.rightNavi.getHeight(), foot);
        }
        return foot;
    }

    public int getContentHeight() {
        return this.getItemsNum() != 0 ? this.getItem((int)(this.getItemsNum() - 1)).y : 0;
    }

    public void paint(Graphics g) {
        DispManager.message = "paint a";
        if (this.bg != null) {
            this.bg.paint(g, this.width >> 1, this.height >> 1, 3);
        } else {
            DispManager.message = "paint b";
            Menu.paintBg(g, this.id != 2 && this.id != 1);
        }
        if (this.getItemsNum() <= 0) {
            return;
        }
        DispManager.message = "paint c";
        this.ty = 0;
        if (this.getItem((int)(this.getItemsNum() - 1)).y < this.getHeightForContent()) {
            if (this.valign == 2) {
                this.ty = this.getHeightForContent() - this.getItem((int)(this.getItemsNum() - 1)).y >> 1;
            }
            if (this.valign == 32) {
                this.ty = this.getHeightForContent() - this.getItem((int)(this.getItemsNum() - 1)).y;
            }
        }
        DispManager.message = "paint e";
        if (this.header != null) {
            this.ty += this.getHeaderHeight();
        }
        DispManager.message = "paint f";
        g.translate(0, this.ty);
        int t = (long)this.gameTime - this.changeTime >= 500L ? (this.offsetY = this.newOffsetY) : (int)((long)this.offsetY + (long)(this.newOffsetY - this.offsetY) * ((long)this.gameTime - this.changeTime) / 500L);
        DispManager.message = "paint g";
        DispManager.saveClip(g);
        g.setClip(0, 0, this.width, this.getHeightForContent());
        g.translate(0, -t);
        super.paint(g);
        DispManager.message = "paint h";
        g.translate(0, t);
        DispManager.loadClip(g);
        g.translate(0, -this.ty);
        if (this.footer != null) {
            this.footer.paint(g);
        }
        if (this.leftNavi != null) {
            this.leftNavi.paint(g);
        }
        if (this.rightNavi != null) {
            this.rightNavi.paint(g);
        }
        if (this.header != null) {
            this.header.paint(g);
        }
        DispManager.message = "paint i";
        if (this.getContentHeight() > this.getHeightForContent()) {
            MIScrollable.paintScroll(g, this.getWidth() - Paintable.createFromResMan(122).getWidth(), this.getHeaderHeight(), this.getHeightForContent(), this.offsetY, this.getItem((int)(this.getItemsNum() - 1)).y - this.getHeightForContent(), Paintable.createInvisibleRect(0, 0), Paintable.createInvisibleRect(0, 0), Paintable.createFromResMan(108), Paintable.createFromResMan(122));
        }
        DispManager.message = "paint j";
        if (this.id == 2) {
            Main.fonts[0].write(g, "\u00a9 Fazzi Dice", this.getWidth() / 2, this.getHeight(), 33);
        }
        DispManager.message = "/paint";
    }

    public void update(int time) {
        DispManager.message = "update";
        super.update(time);
        DispManager.message = "/update";
    }

    public void addItem(MenuItem mi, int index) {
        this.elements.insertElementAt(mi, index);
        this.addSprite(0, mi);
        mi.x = Paintable.halign(this.width, 1, this.toPx(mi.getWidth()));
        if (index > 0) {
            MenuItem im2 = this.getItem(index - 1);
            mi.y = im2.y + mi.getHeight() + this.fromPx(3);
        } else {
            mi.y = mi.getHeight() + 3;
            if (mi.isNavigable) {
                this.selectedPos = index;
                mi.setIsSelected(true);
            }
        }
        int y = mi.y + this.fromPx(3);
        for (int j = index + 1; j < this.elements.size(); ++j) {
            mi = this.getItem(j);
            mi.y = y + mi.getHeight();
            y += mi.getHeight() + this.fromPx(3);
        }
        if (!this.getItem((int)this.selectedPos).isNavigable && mi.isNavigable) {
            this.selectedPos = index;
            this.getItem(this.selectedPos).setIsSelected(true);
        }
    }

    public void addItem(MenuItem mi) {
        this.addItem(mi, this.elements.size());
    }

    public void addItemWithCoordinate(MenuItem mi, int x) {
        mi.x = x;
        this.addItem(mi, this.elements.size());
    }

    public MenuItem getItem(int i) {
        return (MenuItem)this.elements.elementAt(i);
    }

    public int getItemsNum() {
        return this.elements.size();
    }

    public void removeItem(MenuItem mi) {
        for (int j = 0; j < this.elements.size(); ++j) {
            if (mi != this.getItem(j)) continue;
            this.removeItem(j);
        }
    }

    public void removeItem(int i) {
        MenuItem mi = this.getItem(i);
        mi.remove();
        int y = mi.y - mi.getHeight();
        this.elements.removeElementAt(i);
        for (int j = i; j < this.elements.size(); ++j) {
            mi = this.getItem(j);
            mi.y = y + mi.getHeight();
            y += mi.getHeight() + this.fromPx(3);
        }
    }

    private void proceedWithPointerPosition(int x, int y) {
        Sprite s = this.spriteAt(x, y);
        if (s != this.selectedByPointer) {
            if (this.selectedByPointer instanceof MenuItem) {
                ((MenuItem)this.selectedByPointer).setIsSelected(false);
            }
            if (s instanceof MenuItem) {
                for (int i = 0; i < this.elements.size(); ++i) {
                    if (s != this.getItem(i)) continue;
                    if (this.getItem((int)this.selectedPos).isSelected) {
                        this.getItem(this.selectedPos).setIsSelected(false);
                    }
                    this.selectedPos = i;
                    this.getItem(this.selectedPos).setIsSelected(true);
                    if (!(this.getItem(this.selectedPos) instanceof MenuItem) || Math.abs(x - this.pressPoint.x) >= 2 || Math.abs(y - this.pressPoint.y) >= 2 || this.getItem(this.selectedPos).keyPressed(123456)) continue;
                    this.getItem(this.selectedPos).makePointerPressedAction();
                }
            }
            this.selectedByPointer = s;
        }
    }

    public int getHeaderHeight() {
        return this.header != null ? this.header.getHeight() : 0;
    }

    static int getSoftHeight() {
        return Paintable.createFromResMan(13).getHeight();
    }

    static int getSoftWidth() {
        return Paintable.createFromResMan(13).getWidth();
    }

    public void pointerPressed(int x, int y) {
        if (x <= Menu.getSoftWidth() && y >= this.getHeight() - Menu.getSoftHeight()) {
            DispManager.getManager().keyPressed(234567);
            this.leftSoftKeyPressedByPointer = true;
        }
        if (x >= this.getWidth() - Menu.getSoftWidth() && y >= this.getHeight() - Menu.getSoftHeight()) {
            DispManager.getManager().keyPressed(345678);
            this.rightSoftKeyPressedByPointer = true;
        }
        this.pressPoint = this.actualPoint = new Point(x, y);
        this.proceedWithPointerPosition(x, y -= this.ty - this.offsetY);
        Sprite s = this.spriteAt(x, y);
        if (s instanceof MenuItem) {
            MenuItem mi = (MenuItem)s;
            mi.pointerPressed(x, y);
        }
        this.proceedPointerPressed(x, y);
        this.setNaviLabelsBg();
        if (this.selectedByPointer == null) {
            Menu.checkCrocoHit(this.pressPoint.x, this.pressPoint.y);
        }
    }

    public void pointerDragged(int x, int y) {
        this.changeTime = this.gameTime - 500;
        int tt = this.offsetY;
        this.lastY = this.actualPoint.y;
        this.newOffsetY = this.offsetY = Math.max(0, Math.min(this.getItem((int)(this.getItemsNum() - 1)).y - this.getHeightForContent(), this.offsetY + this.actualPoint.y - y));
        this.actualPoint = new Point(x, y);
        this.proceedWithPointerPosition(x, y -= this.ty - this.offsetY);
        Sprite s = this.spriteAt(x, y);
        if (s instanceof MenuItem) {
            MenuItem mi = (MenuItem)s;
            if (s != this.selectedByPointer) {
                mi.pointerEntered(x, y);
                if (this.selectedByPointer instanceof MenuItem) {
                    MenuItem mi2 = (MenuItem)this.selectedByPointer;
                    mi2.pointerLeft(x, y);
                }
            }
            mi.pointerMoved(x, y);
        }
        if (this.selectedByPointer instanceof MenuItem && s != this.selectedByPointer) {
            MenuItem mi2 = (MenuItem)this.selectedByPointer;
            mi2.pointerLeft(x, y);
        }
        if ((x > Menu.getSoftWidth() || y < this.getHeight() - Menu.getSoftHeight()) && this.leftSoftKeyPressedByPointer) {
            if (DispManager.translateKey(DispManager.keyCode) == 15) {
                DispManager.keyCode = 0;
            }
            this.leftSoftKeyPressedByPointer = false;
        }
        if ((x < this.getWidth() - Menu.getSoftWidth() || y < this.getHeight() - Menu.getSoftHeight()) && this.rightSoftKeyPressedByPointer) {
            if (DispManager.translateKey(DispManager.keyCode) == 16) {
                DispManager.keyCode = 0;
            }
            this.rightSoftKeyPressedByPointer = false;
        }
        this.setNaviLabelsBg();
    }

    public void pointerReleased(int x, int y) {
        MenuItem mi;
        DispManager.keyCode = 0;
        if (x <= Menu.getSoftWidth() && y >= this.getHeight() - Menu.getSoftHeight()) {
            DispManager.getManager().keyReleased(234567);
            this.leftSoftKeyPressedByPointer = false;
        }
        if (x >= this.getWidth() - Menu.getSoftWidth() && y >= this.getHeight() - Menu.getSoftHeight()) {
            DispManager.getManager().keyReleased(345678);
            this.rightSoftKeyPressedByPointer = false;
        }
        Sprite s = this.spriteAt(x, y);
        this.releasePoint = new Point(x, y);
        y -= this.ty - this.offsetY;
        if (s instanceof MenuItem) {
            mi = (MenuItem)s;
            mi.pointerReleased(x, y);
        }
        if (this.selectedByPointer instanceof MenuItem) {
            mi = (MenuItem)this.selectedByPointer;
            if (Math.abs(this.releasePoint.x - this.pressPoint.x) < 8 && Math.abs(this.releasePoint.y - this.pressPoint.y) < 8 && !mi.keyReleased(123456)) {
                this.onChoose(mi.getLabel(), mi);
                ((MenuItem)this.selectedByPointer).makePointerReleasedAction();
            }
            mi.setIsSelected(false);
        }
        this.selectedByPointer = null;
        this.setNaviLabelsBg();
        this.proceedPointerReleased(x, y);
        this.pressPoint = null;
        this.actualPoint = null;
    }

    public void load() {
        DispManager.message = "onShow";
        for (int i = 0; i < this.getItemsNum(); ++i) {
            this.getItem(i).load();
        }
        if (this.header != null) {
            this.header.load();
        }
        if (this.footer != null) {
            this.footer.load();
        }
        if (this.leftNavi != null) {
            this.leftNavi.load();
        }
        if (this.rightNavi != null) {
            this.rightNavi.load();
        }
        if (this.bg != null) {
            this.bg.addToLoad();
        } else {
            Menu.loadBgImages();
        }
        Paintable.loadResources(false);
        if (this.firstRun) {
            this.firstRun = false;
        }
        DispManager.message = "/onShow";
    }

    public static final Menu createDoYouWantSound() {
        int w = DispManager.getManager().getScreenWidth();
        Menu m = new Menu();
        m.setValign(2);
        m.id = 1;
        m.addItem(Menu.createLabel(Text.getText(0)));
        m.setLeftNavi(Menu.createNaviLabel(Text.getText(47)));
        m.setRightNavi(Menu.createNaviLabel(Text.getText(48)));
        return m;
    }

    public static final Menu createSplash() {
        int w = DispManager.getManager().getScreenWidth();
        Menu m = new Menu();
        m.setValign(2);
        m.id = 2;
        Paintable p = Paintable.createCompositionWithAutoResize();
        p.addElement(Paintable.createFromResMan(71).getWidth(), 0, Paintable.createFromResMan(33), 24);
        p.addElement(0, Paintable.createFromResMan(32).getHeight() * 3 / 5, Paintable.createFromResMan(71));
        MILabel l = new MILabel(null);
        l.setImg(p);
        m.addItem(l);
        return m;
    }

    public static final Menu createMainMenu() {
        DispManager.message = "createMainMenu";
        if (Main.reduced) {
            Paintable.releaseAllResourceMemory();
        }
        int w = DispManager.getManager().getScreenWidth();
        Menu m = new Menu();
        m.setValign(16);
        m.id = 3;
        MILabel l = new MILabel(null);
        l.setImg(Paintable.createFromResMan(71));
        m.addItem(l);
        m.addItem(Menu.createButton(Text.getText(46), "graj", 0));
        m.addItem(Menu.createButton(Text.getText(24), "trofea", 0));
        m.addItem(Menu.createButton(Text.getText(53), "ustawienia", 2));
        m.addItem(Menu.createButton(Text.getText(41), "o grze", 0));
        m.addItem(Menu.createButton("#1" + Text.getText(54), "wyj\u015bcie", 1));
        DispManager.message = "/createMainMenu";
        return m;
    }

    public static final Menu createTrophies() {
        int w = DispManager.getManager().getScreenWidth();
        Menu m = new Menu();
        m.setValign(16);
        m.id = 11;
        m.setRightNavi(Menu.createNaviLabel(Text.getText(55)));
        Paintable p = Paintable.createCompositionWithAutoResize();
        p.setWidth(w * 9 / 10);
        p.addElement(p.getWidth() / 2, p.getHeight(), Paintable.createFromResMan(8), 17);
        p.addElement(p.getWidth() / 2, p.getHeight() - Paintable.createFromResMan(8).getHeight() * 2 / 3, Paintable.createFormatedPaintable(Text.getText(21), Main.fonts, null, p.getWidth(), 1, true), 3);
        p.addElement(p.getWidth() / 2, p.getHeight(), Paintable.createFormatedPaintable(Text.getText(22), Main.fonts, new String[]{Saver.bestResult + ""}, p.getWidth(), 1, true), 17);
        p.addElement(p.getWidth() / 2, p.getHeight(), Paintable.createFormatedPaintable(Text.getText(23), Main.fonts, new String[]{Saver.hitsInRow + ""}, p.getWidth(), 1, true), 17);
        p.addElement(p.getWidth() / 2, p.getHeight(), Paintable.createFormatedPaintable(Text.getText(3), Main.fonts, new String[]{Saver.crocoKilled + ""}, p.getWidth(), 1, true), 17);
        p.addElement(p.getWidth() / 2, p.getHeight(), Paintable.createFromResMan(8), 17);
        p.addElement(p.getWidth() / 2, p.getHeight() - Paintable.createFromResMan(8).getHeight() * 2 / 3, Paintable.createFormatedPaintable(Text.getText(24), Main.fonts, null, p.getWidth(), 1, true), 3);
        for (int i = 0; i < 8; ++i) {
            Paintable t = trophyImgs[i];
            if (!Saver.achivments[i]) {
                t = new Paintable(Paintable.imageToGrayScale(t.img));
            }
            p.addElement(0, p.getHeight(), t, 20);
            p.addElement(t.getWidth(), p.getHeight() - t.getHeight(), Paintable.createFormatedPaintable(Text.getText(5 + i) + '\n' + Text.getText(13 + i), Main.fonts, null, p.getWidth() - t.getWidth(), 4, true), 20);
        }
        MIScrollable s = new MIScrollable(null);
        s.setUnFocused(new Paintable(p.getWidth(), Math.min(m.getHeightForContent(), p.getHeight())));
        s.setFormated(p);
        m.addItem(s);
        m.setFixedSize(true);
        return m;
    }

    public static final Menu createTextDisplayerMenu(String text, Disp next, Paintable header) {
        MenuItem l;
        DispManager.message = "createTextDisplayerMenu a";
        System.out.println("createTextDisplayerMenu a");
        int w = DispManager.getManager().getScreenWidth();
        Menu m = new Menu();
        m.setValign(16);
        m.next = next;
        m.id = 9;
        DispManager.message = "createTextDisplayerMenu b";
        System.out.println("createTextDisplayerMenu b");
        if (header != null) {
            l = new MILabel(null);
            ((MILabel)l).setFormated(header);
            m.setHeader((MILabel)l);
        }
        DispManager.message = "createTextDisplayerMenu c";
        System.out.println("createTextDisplayerMenu c");
        m.setRightNavi(Menu.createNaviLabel(Text.getText(55)));
        l = new MIScrollable(null);
        Paintable deska = Paintable.createFromResMan(51);
        DispManager.message = "createTextDisplayerMenu ca";
        System.out.println("createTextDisplayerMenu ca");
        Paintable pText = Paintable.createFormatedPaintable(text, Main.fonts, null, deska.getWidth() * 9 / 10, 4, true);
        DispManager.message = "createTextDisplayerMenu cb";
        System.out.println("createTextDisplayerMenu cb");
        Paintable tdBg = new Paintable(deska.getWidth(), m.getHeightForContent() + m.getFooterHeight() - Paintable.createFromResMan(52).getHeight());
        tdBg.setHeight(Math.min(tdBg.getHeight(), pText.getHeight()));
        DispManager.message = "createTextDisplayerMenu d";
        System.out.println("createTextDisplayerMenu d");
        for (int i = 0; i < (tdBg.getHeight() + deska.getHeight() - 1) / deska.getHeight(); ++i) {
            Paintable t = new Paintable(deska.img);
            t.setMirror((i * 3 + i % 4 + i % 3) % 2 == 0);
            tdBg.addElement(0, i * deska.getHeight(), t);
        }
        DispManager.message = "createTextDisplayerMenu e";
        System.out.println("createTextDisplayerMenu e");
        ((MIScrollable)l).setUnFocused(tdBg);
        if (((MIScrollable)l).unFocused.getHeight() > pText.getHeight()) {
            m.setValign(2);
        }
        DispManager.message = "createTextDisplayerMenu f";
        System.out.println("createTextDisplayerMenu f");
        ((MIScrollable)l).setFormated(pText);
        m.addItem(l);
        DispManager.message = "createTextDisplayerMenu g";
        System.out.println("createTextDisplayerMenu g");
        return m;
    }

    public static final Menu createBonusMenu() {
        int w = DispManager.getManager().getScreenWidth();
        Menu m = new Menu();
        m.setValign(16);
        m.id = 7;
        m.setHeader(Menu.createLabel(Text.getText(49)));
        m.setRightNavi(Menu.createNaviLabel(Text.getText(55)));
        m.setLeftNavi(Menu.createNaviLabel(Text.getText(60)));
        Paintable p = Paintable.createCompositionWithAutoResize();
        p.setWidth(w * 9 / 10);
        p.addElement(p.getWidth() / 2, p.getHeight(), Paintable.createFromResMan(15), 17);
        p.addElement(p.getWidth() / 2, p.getHeight(), Paintable.createFormatedPaintable(Text.getText(61), Main.fonts, null, w * 9 / 10, 1, true), 17);
        MIScrollable s = new MIScrollable(null);
        s.setUnFocused(Paintable.createInvisibleRect(p.getWidth(), p.getHeight()));
        s.setFormated(p);
        m.addItem(s);
        return m;
    }

    public static final Menu createSettingsMenu() {
        int w = DispManager.getManager().getScreenWidth();
        Menu m = new Menu();
        m.setValign(2);
        m.id = 10;
        m.setHeader(Menu.createLabel(Text.getText(53)));
        m.setRightNavi(Menu.createNaviLabel(Text.getText(55)));
        MIButton b = new MIButton("d\u017awi\u0119k");
        b.setUnFocused(Game.createButtonBg());
        b.setFormated(Paintable.createFromResMan(113));
        m.addItem(b);
        b = new MIButton("wibracje");
        b.setUnFocused(Game.createButtonBg());
        b.setFormated(Paintable.createFromResMan(129));
        m.addItem(b);
        m.setSettingsButtonImg();
        return m;
    }

    private void setSettingsButtonImg() {
        for (int i = 0; i < this.getItemsNum(); ++i) {
            ImageFont font;
            MIButton b;
            if (this.getItem(i).getLabel() != null && this.getItem(i).getLabel().equals("d\u017awi\u0119k")) {
                b = (MIButton)this.getItem(i);
                if (Main.reduced) {
                    font = Main.fonts[i == this.selectedPos ? Game.bolded : Game.notbolded];
                    b.setFormated(new Paintable(Text.getText(44) + " " + Text.getText(Saver.getSound() > 0 ? 1 : 2), font));
                } else if (i == this.selectedPos) {
                    b.setFormated(Paintable.createFromResMan(Saver.getSound() == 0 ? 113 : 115));
                } else {
                    b.setFormated(Paintable.createFromResMan(Saver.getSound() == 0 ? 114 : 116));
                }
            }
            if (this.getItem(i).getLabel() == null || !this.getItem(i).getLabel().equals("wibracje")) continue;
            b = (MIButton)this.getItem(i);
            if (Main.reduced) {
                font = Main.fonts[i == this.selectedPos ? Game.bolded : Game.notbolded];
                b.setFormated(new Paintable(Text.getText(45) + " " + Text.getText(Saver.getVibra() ? 1 : 2), font));
                continue;
            }
            if (i == this.selectedPos) {
                b.setFormated(Paintable.createFromResMan(Saver.getVibra() ? 131 : 129));
                continue;
            }
            b.setFormated(Paintable.createFromResMan(Saver.getVibra() ? 132 : 130));
        }
    }

    public static final Menu createWallpapersMenu() {
        int w = DispManager.getManager().getScreenWidth();
        Menu m = new Menu();
        m.setValign(16);
        m.id = 4;
        m.setHeader(Menu.createLabel(Text.getText(51)));
        m.setRightNavi(Menu.createNaviLabel(Text.getText(55)));
        m.setLeftNavi(Menu.createNaviLabel(Text.getText(27)));
        for (int i = 0; i < wallpapers.length; ++i) {
            MIButton b = new MIButton(null);
            b.setFormated(wallpapers[i]);
            int r = 2;
            Paintable bg = new Paintable(wallpapers[i].getWidth() + r * 2, wallpapers[i].getHeight() + r * 2);
            bg.addElement(0, 0, Paintable.createFilledRect(bg.getWidth(), bg.getHeight(), 0));
            bg.addElement(r, r, Paintable.createFilledRect(bg.getWidth() - 2 * r, bg.getHeight() - 2 * r, 3303255));
            b.setUnFocused(bg);
            bg = new Paintable(wallpapers[i].getWidth() + r * 2, wallpapers[i].getHeight() + r * 2);
            bg.addElement(0, 0, Paintable.createFilledRect(bg.getWidth(), bg.getHeight(), 0xFFFFFF));
            bg.addElement(r, r, Paintable.createFilledRect(bg.getWidth() - 2 * r, bg.getHeight() - 2 * r, 3303255));
            b.setFocused(bg);
            m.addItem(b);
        }
        return m;
    }

    public static final Menu createSkyCashMenu(int wallpaperId) {
        int w = DispManager.getManager().getScreenWidth();
        Menu m = new Menu();
        m.wallpaperId = wallpaperId;
        m.setValign(2);
        m.id = 8;
        m.setRightNavi(Menu.createNaviLabel(Text.getText(55)));
        m.setLeftNavi(Menu.createNaviLabel(Text.getText(65)));
        MILabel label = new MILabel(null);
        label.setFormated(Paintable.createFromResMan(112));
        m.addItem(label);
        label = new MILabel(null);
        label.setFormated(Paintable.createFormatedPaintable(Text.getText(74), Main.fonts, null, w * 9 / 10, 1, true));
        m.addItem(label);
        m.addItem(Menu.createInputButton(Saver.skyCashUser, "input user"));
        label = new MILabel(null);
        label.setFormated(Paintable.createFormatedPaintable(Text.getText(73), Main.fonts, null, w * 9 / 10, 1, true));
        m.addItem(label);
        m.addItem(Menu.createInputButton(Saver.skyCashUser, "input passwd"));
        return m;
    }

    public static final Menu createWallpapersBuyMenu(int wallpaperId) {
        int w = DispManager.getManager().getScreenWidth();
        Menu m = new Menu();
        m.wallpaperId = wallpaperId;
        m.setValign(16);
        m.id = 5;
        m.setHeader(Menu.createLabel(Text.getText(50)));
        m.setRightNavi(Menu.createNaviLabel(Text.getText(55)));
        MILabel l = new MILabel(null);
        l.setFormated(wallpapers[wallpaperId]);
        int r = 2;
        Paintable bg = new Paintable(wallpapers[wallpaperId].getWidth() + r * 2, wallpapers[wallpaperId].getHeight() + r * 2);
        bg.addElement(0, 0, Paintable.createFilledRect(bg.getWidth(), bg.getHeight(), 0xFFFFFF));
        bg.addElement(r, r, Paintable.createFilledRect(bg.getWidth() - 2 * r, bg.getHeight() - 2 * r, 3303255));
        l.setImg(bg);
        m.addItem(l);
        l = new MILabel(null);
        l.setFormated(Paintable.createFormatedPaintable(Text.getText(56), Main.fonts, null, w * 9 / 10, 1, true));
        m.addItem(l);
        m.addItem(Menu.createButton(Text.getText(57), "sms", 2));
        return m;
    }

    public void proceedPointerPressed(int x, int y) {
    }

    public void proceedPointerReleased(int x, int y) {
        switch (this.id) {
            case 2: {
                Menu.createMainMenu().display();
            }
        }
    }

    public void proceedKeyPressed(int key) {
        if (this.id == 10) {
            this.setSettingsButtonImg();
        }
    }

    public void proceedKeyReleased(int key) {
        switch (this.id) {
            case 2: {
                Menu.createMainMenu().display();
                break;
            }
            case 1: {
                if (key != 15 && key != 16) break;
                int sound = Saver.getSound();
                if (sound == 0) {
                    sound = 10;
                }
                DispManager.musicFileName = "4fiter.mid";
                if (key == 15) {
                    DispManager.play("4fiter.mid", false);
                }
                Saver.setSound(key == 15 ? sound : 0);
                Menu.createSplash().display();
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                if (key != 16) break;
                DispManager.getManager();
                DispManager.setPreviousDisp();
            }
        }
        switch (this.id) {
            case 7: {
                if (key != 15) break;
                try {
                    Main.getHandle().platformRequest("http://m.bombergeddon.pl");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 8: {
                if (key != 15 || this.in1 == null || this.in1.length() <= 0 || this.in2 == null || this.in2.length() <= 0) break;
                new Thread(this).start();
                break;
            }
            case 4: {
                if (key != 15) break;
                this.onChoose(this.getItem(this.selectedPos).getLabel(), this.getItem(this.selectedPos));
            }
        }
        if (this.id == 10) {
            this.setSettingsButtonImg();
        }
    }

    public void onChoose(String label, MenuItem im) {
        if (label != null) {
            if (label.equals("graj")) {
                DispManager.setDisp(new Game(), true);
            }
            if (label.equals("ustawienia")) {
                Menu.createSettingsMenu().display();
            }
            if (label.equals("sms")) {
                new Thread(this).start();
            }
            if (label.equals("wyj\u015bcie")) {
                Main.getHandle().destroyApp(true);
            }
            if (label.equals("tapety")) {
                Menu.createWallpapersMenu().display();
            }
            if (label.equals("bonus")) {
                Menu.createBonusMenu().display();
            }
            if (label.equals("trofea")) {
                Menu.createTrophies().display();
            }
            if (label.equals("skycash")) {
                Menu.createSkyCashMenu(this.wallpaperId).display();
            }
            if (label.equals("input user")) {
                this.displayTextBox(2);
            }
            if (label.equals("input passwd")) {
                this.displayTextBox(65536);
            }
            if (label.equals("input captcha")) {
                this.displayTextBox(0);
            }
            if (label.equals("wibracje")) {
                Saver.setVibra(!Saver.getVibra());
            }
            if (label.equals("d\u017awi\u0119k")) {
                Saver.setSound(Saver.getSound() == 0 ? 10 : 0);
            }
            if (label.equals("o grze")) {
                Menu m = Menu.createTextDisplayerMenu(Text.getText(42), this, null);
                m.setHeader(Menu.createLabel(Text.getText(41)));
                m.display();
            }
        }
        if (this.id == 4) {
            Menu.createWallpapersBuyMenu(this.selectedPos).display();
        }
        if (this.id == 10) {
            this.setSettingsButtonImg();
        }
        if (this.id == 2) {
            Menu.createMainMenu().display();
        }
    }

    public void setNaviLabelsBg() {
        if (this.leftNavi != null) {
            this.leftNavi.setImg(Paintable.createFromResMan(13));
        }
        if (this.rightNavi != null) {
            this.rightNavi.setImg(Paintable.createFromResMan(13));
        }
        if (this.leftNavi != null && (this.actualPoint != null && this.actualPoint.x < Menu.getSoftWidth() && this.actualPoint.y > this.getHeight() - Menu.getSoftHeight() || DispManager.translateKey(DispManager.keyCode) == 15)) {
            this.leftNavi.setImg(Paintable.createFromResMan(14));
        }
        if (this.rightNavi != null && (this.actualPoint != null && this.actualPoint.x > this.getWidth() - Menu.getSoftWidth() && this.actualPoint.y > this.getHeight() - Menu.getSoftHeight() || DispManager.translateKey(DispManager.keyCode) == 16)) {
            this.rightNavi.setImg(Paintable.createFromResMan(14));
        }
    }

    public static MILabel createNaviLabel(String text) {
        MILabel label = new MILabel(null);
        label.setImg(Paintable.createFromResMan(13));
        label.setFormated(Paintable.createFormatedPaintable(text, Main.fonts, null, DispManager.getManager().getScreenWidth(), 1, true));
        label.formated.setHeight(label.img.getHeight() * 2 / 3);
        return label;
    }

    public static MILabel createLabel(String text) {
        MILabel label = new MILabel(null);
        label.setImg(Paintable.createFromResMan(8));
        label.setFormated(Paintable.createFormatedPaintable(text, Main.fonts, null, DispManager.getManager().getScreenWidth(), 1, true));
        label.formated.setHeight(label.img.getHeight() * 2 / 3);
        return label;
    }

    public static MIButton createButton(String text, String label, int num) {
        MIButton b = new MIButton(label);
        b.setUnFocused(buttonUnfocused[num]);
        b.setFocused(buttonFocused[num]);
        b.setFormated(Paintable.createFormatedPaintable(text, Main.fonts, null, DispManager.getManager().getScreenWidth(), 1, true));
        return b;
    }

    public static MIButton createInputButton(String text, String label) {
        MIButton b = new MIButton(label);
        int r = 2;
        Paintable bg = new Paintable(DispManager.getManager().getScreenWidth() * 9 / 10, Main.fonts[1].getHeight() * 2 + 2);
        bg.addElement(0, 0, Paintable.createFilledRect(bg.getWidth(), bg.getHeight(), 0));
        bg.addElement(r, r, Paintable.createFilledRect(bg.getWidth() - 2 * r, bg.getHeight() - 2 * r, 3303255));
        b.setUnFocused(bg);
        bg = new Paintable(DispManager.getManager().getScreenWidth() * 9 / 10, Main.fonts[1].getHeight() * 2 + 2);
        bg.addElement(0, 0, Paintable.createFilledRect(bg.getWidth(), bg.getHeight(), 0));
        bg.addElement(r, r, Paintable.createFilledRect(bg.getWidth() - 2 * r, bg.getHeight() - 2 * r, 0xFFFF00));
        b.setFocused(bg);
        b.setFormated(Paintable.createFormatedPaintable(text, Main.fontsSwapped, null, DispManager.getManager().getScreenWidth(), 1, true));
        return b;
    }

    public static void loadBgImages() {
        int i;
        for (i = 0; i < clouds.length; ++i) {
            clouds[i].addToLoad();
        }
        Paintable.addToLoad(52);
        if (!Main.reduced) {
            Paintable.addToLoad(66);
            Paintable.addToLoad(67);
            Paintable.addToLoad(44);
            Paintable.addToLoad(45);
            Paintable.addToLoad(46);
            Paintable.addToLoad(47);
            Paintable.addToLoad(29);
            Paintable.addToLoad(30);
            Paintable.addToLoad(31);
            Paintable.addToLoad(32);
            Paintable.addToLoad(33);
            Paintable.addToLoad(34);
        }
        Paintable.addToLoad(13);
        Paintable.addToLoad(14);
        Paintable.addToLoad(51);
        for (i = 0; i < buttonFocused.length; ++i) {
            buttonFocused[i].addToLoad();
            buttonUnfocused[i].addToLoad();
        }
        Paintable.addToLoad(108);
        Paintable.addToLoad(122);
        if (!Main.reduced) {
            Paintable.createFromResMan(129).addToLoad();
            Paintable.createFromResMan(130).addToLoad();
            Paintable.createFromResMan(131).addToLoad();
            Paintable.createFromResMan(132).addToLoad();
            Paintable.createFromResMan(113).addToLoad();
            Paintable.createFromResMan(114).addToLoad();
            Paintable.createFromResMan(115).addToLoad();
            Paintable.createFromResMan(116).addToLoad();
        }
        for (i = 0; i < trophyImgs.length; ++i) {
            trophyImgs[i].addToLoad();
        }
    }

    public static void paintBg(Graphics g, boolean drawCroco) {
        DispManager.message = "paintBg a";
        int w = DispManager.getManager().getScreenWidth();
        int h = DispManager.getManager().getScreenHeight();
        g.setColor(3303255);
        g.fillRect(0, 0, w, h);
        int dy = h - Paintable.createFromResMan(52).getHeight() / 2;
        for (int i = clouds.length - 1; i >= 0; --i) {
            int n;
            for (int y = clouds[0].getHeight() * 2 / 3; y < dy; y += (y % 7 + 5) * clouds[n].getHeight() / 8) {
                n = y % 13 % clouds.length;
                if (n != i) continue;
                long x = (long)(y % 23 * w / 23) + System.currentTimeMillis() * (long)w * (long)(2 + clouds.length - n) / 60000L;
                clouds[n].paint(g, (int)(x %= (long)(w + clouds[n].getWidth())) - clouds[n].getWidth(), y, 36);
            }
        }
        DispManager.message = "paintBg b";
        Paintable.createFromResMan(52).paint(g, 0, h, 36);
        if (!Main.reduced) {
            Paintable.createFromResMan(66).paint(g, 0, 0, 20);
            Paintable.createFromResMan(67).paint(g, w, 0, 24);
        }
        if (drawCroco) {
            DispManager.message = "paintBg c";
            if (firstBgShow == 0L) {
                firstBgShow = System.currentTimeMillis();
                Menu.randChicken();
            }
            int x = Menu.getBgCrocoX();
            Paintable frame = System.currentTimeMillis() / 250L % 2L == 0L ? Paintable.createFromResMan(31) : Paintable.createFromResMan(32);
            DispManager.message = "paintBg ca";
            if (System.currentTimeMillis() - firstBgShow < 600L) {
                int tt = (int)((System.currentTimeMillis() - firstBgShow) * (long)Croco.showAnimNormal.frames.length / 600L);
                frame = Croco.showAnimNormal.frames[Math.max(0, Math.min(tt, Croco.showAnimNormal.frames.length))];
            }
            DispManager.message = "paintBg cb";
            if (System.currentTimeMillis() - hitBg < 1250L) {
                frame = hitAnim[(int)((System.currentTimeMillis() - hitBg) * (long)hitAnim.length / 1250L)];
            }
            DispManager.message = "paintBg cc";
            frame.paint(g, x + frame.getWidth() / 2, Menu.getBgCrocoY(), 33);
            if (Main.samsung) {
                return;
            }
            int t = (int)(System.currentTimeMillis() % 6500L);
            int phase = 0;
            if (t > 3500) {
                ++phase;
                if ((t -= 3500) > 1500) {
                    ++phase;
                    if ((t -= 1500) > 1000) {
                        ++phase;
                        t -= 1000;
                    }
                }
            }
            DispManager.message = "paintBg d";
            if (lastPhase != (long)phase && phase == 0) {
                Menu.randChicken();
            }
            frame = phase == 2 ? chickenBlink[t * chickenBlink.length / 300 % chickenBlink.length] : chickenNormal;
            javax.microedition.lcdui.game.Sprite s = new javax.microedition.lcdui.game.Sprite(frame.img);
            int tt = frame.getHeight() * 2 / 3;
            switch (phase) {
                case 0: {
                    tt = 0;
                    break;
                }
                case 1: {
                    tt = tt * t / 1500;
                    break;
                }
                case 3: {
                    tt -= tt * t / 500;
                }
            }
            DispManager.message = "paintBg e";
            switch (chickenSide) {
                case 0: {
                    s.setPosition(w - tt, chickenCoord);
                    s.setTransform(6);
                    break;
                }
                case 1: {
                    s.setPosition(chickenCoord, h - tt);
                    break;
                }
                case 2: {
                    s.setPosition(tt, chickenCoord);
                    s.setTransform(5);
                    break;
                }
                case 3: {
                    s.setPosition(chickenCoord + frame.getWidth(), tt);
                    s.setTransform(3);
                }
            }
            DispManager.message = "paintBg f";
            lastPhase = phase;
            s.paint(g);
            DispManager.message = "paintBg g";
        }
    }

    private static void randChicken() {
        chickenSide = DispManager.nextRandInt(3);
        chickenCoord = chickenSide % 2 == 0 ? DispManager.nextRandInt(DispManager.getManager().getScreenHeight() - chickenNormal.getWidth()) : DispManager.nextRandInt(DispManager.getManager().getScreenWidth() - chickenNormal.getWidth());
    }

    private static int getBgCrocoX() {
        return DispManager.getManager().getScreenWidth() - 10 - Paintable.createFromResMan(31).getWidth();
    }

    private static int getBgCrocoY() {
        return DispManager.getManager().getScreenHeight() - Paintable.createFromResMan(8).getHeight();
    }

    private static void checkCrocoHit(int x, int y) {
        if (x > Menu.getBgCrocoX() && x < Menu.getBgCrocoX() + Paintable.createFromResMan(31).getWidth() && y <= Menu.getBgCrocoY() && y > Menu.getBgCrocoY() - Paintable.createFromResMan(31).getHeight()) {
            hitBg = System.currentTimeMillis();
        }
    }

    public void run() {
        block23: {
            ++DispManager.pleaseWait;
            System.out.println(this.id + " " + (this.id == 5));
            if (this.id == 8) {
                try {
                    SkyCashClient ssc = new SkyCashClient();
                    ssc.pay("phone:48" + this.in1, this.in2, "", "0", DispManager.getManager(), true, Main.getHandle(), Text.getText(72), "", "", this.captcha == null ? null : this.in3, Text.getText(62), Text.getText(63));
                    while (ssc.isSending()) {
                        Thread.sleep(200L);
                    }
                    if (ssc.getResult() == 1000) {
                        Menu.createTextDisplayerMenu(Text.getText(64), this, null).display();
                        break block23;
                    }
                    System.out.println("error=" + ssc.getServerErrorMessage());
                    String errorMessage = "";
                    if (ssc.getResult() == 1002) {
                        errorMessage = Text.getText(66);
                    } else if (ssc.getResult() == 1004) {
                        errorMessage = Text.getText(67);
                    } else if (ssc.getResult() == 14) {
                        errorMessage = Text.getText(68);
                    } else if (ssc.getResult() == 1003) {
                        errorMessage = Text.getText(69);
                    } else if (ssc.getResult() == 1 || ssc.getResult() == 10 || ssc.getResult() == 5) {
                        errorMessage = Text.getText(70);
                    } else if (ssc.getResult() == 3 || ssc.getResult() == 11 || ssc.getResult() == 6) {
                        errorMessage = Text.getText(71);
                    } else if (ssc.getResult() == 1001) {
                        if (this.captcha == null) {
                            MILabel label = new MILabel(null);
                            label.setFormated(Paintable.createFormatedPaintable(Text.getText(75), Main.fonts, null, this.getWidth() * 9 / 10, 1, true));
                            this.addItem(label);
                            label = new MILabel(null);
                            this.addItem(label);
                            this.addItem(Menu.createInputButton("", "input captcha"));
                        }
                        this.getItem(this.getItemsNum() - 2).setFormated(new Paintable(this.captcha));
                        this.captcha = ssc.getCaptcha();
                    }
                    Menu.createTextDisplayerMenu(errorMessage, this, null).display();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (this.id == 5) {
                try {
                    String address = "7155";
                    String message = this.getSMSMessage();
                    System.out.println(message);
                    MessageConnection connection = (MessageConnection)Connector.open((String)("sms://" + address));
                    TextMessage textMessage = (TextMessage)connection.newMessage("text", "sms://" + address);
                    textMessage.setPayloadText(message);
                    connection.send((Message)textMessage);
                    connection.close();
                    Menu.createTextDisplayerMenu(Text.getText(64), this, null).display();
                    System.out.println("Sms send");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Menu.createTextDisplayerMenu(Text.getText(76), this, null).display();
                }
            }
        }
        --DispManager.pleaseWait;
    }

    private String getSMSMessage() {
        String master;
        String channel = Main.getHandle().getAppProperty("channel");
        if (channel == null || channel.length() == 0) {
            channel = "FD";
        }
        master = (master = Main.getHandle().getAppProperty("master")) == null ? "" : "M" + master;
        return "FZD" + channel + (this.wallpaperId + 2) + master;
    }

    public void commandAction(Command c, Displayable d) {
        if (c.getCommandType() == 4) {
            String s = ((TextBox)d).getString();
            if (this.getItem(this.selectedPos).getLabel().startsWith("input user")) {
                this.in1 = s;
            }
            if (this.getItem(this.selectedPos).getLabel().startsWith("input passwd")) {
                this.in2 = s;
                s = "";
                for (int i = 0; i < this.in2.length(); ++i) {
                    s = s + '*';
                }
            }
            Saver.setSkyCash(this.in1, this.in2);
            if (this.getItem(this.selectedPos).getLabel().startsWith("input captcha")) {
                this.in3 = s;
            }
            this.getItem(this.selectedPos).setFormated(Paintable.createFormatedPaintable(s, Main.fontsSwapped, null, this.toPx(this.getItem(this.selectedPos).getWidth()), 1, true));
        }
        Display.getDisplay((MIDlet)Main.getHandle()).setCurrent((Displayable)DispManager.getManager());
        DispManager.getManager().setFullScreenMode(true);
    }

    private void displayTextBox(int type) {
        String s = "";
        int maxChars = 50;
        if (this.selectedPos == 2) {
            s = this.in1;
            maxChars = 9;
        } else if (this.selectedPos == 4) {
            s = this.in2;
        } else if (this.selectedPos == 7) {
            s = this.in3;
        }
        TextBox tb = new TextBox("", s, maxChars, type);
        Command com = new Command(Text.getText(62), 4, 1);
        Command com2 = new Command(Text.getText(63), 3, 1);
        tb.addCommand(com);
        tb.addCommand(com2);
        tb.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)Main.getHandle()).setCurrent((Displayable)tb);
    }
}

