/*
 * Decompiled with CFR 0.152.
 */
package com.fazzidice;

import com.fazzidice.DispManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;

public class SkyCashClient
implements CommandListener,
Runnable {
    private static final String SKY_CASH_URL = "https://mars.skycash.com/tip/request";
    private MIDlet midlet;
    private Canvas returnCanvas;
    private String enterPINMessage;
    private String PIN;
    private String user;
    private String password;
    private String seesionId;
    private String currency;
    private String toSkyCashId;
    private String payReference;
    private String cmessage;
    private String message;
    private String captchaText;
    private String ok;
    private String cancel;
    private boolean fullCanvas;
    private int action;
    private int result = -1;
    private int screenWidth;
    private int screenHeight;
    private String readableErrorMessage;
    private String serverErrorMessage;
    private boolean sending;
    private Thread thread;
    private Image captcha;
    Exception exc;
    private static final int NON_BASE_64 = -1;
    private static final int NON_BASE_64_PADDING = -3;
    static final byte[] base64Chars;
    protected static final byte[] reverseBase64Chars;
    private static final int ACTION_LOGIN = 0;
    private static final int ACTION_PAY = 1;
    private static final int ACTION_CONFIRM_PAY = 2;
    private static final int NOP = -1;
    public static final int LOGIN_CONNECTION_FAILED = 1;
    public static final int LOGIN_NO_SESSION_ID_OBTAINED = 2;
    public static final int LOGIN_EXCEPTION = 3;
    public static final int NOT_AUTHORIZED = 14;
    public static final int PAY_CONNECTION_FAILED = 5;
    public static final int PAY_EXCEPTION = 6;
    public static final int PAY_NOT_ACCEPTED = 8;
    public static final int CONFIRM_PAY_CONNECTION_FAILED = 10;
    public static final int CONFIRM_PAY_EXCEPTION = 11;
    public static final int CONFIRM_PAY_PIN_NOT_ENTERED = 12;
    public static final int CONFIRM_PAY_NOT_ACCEPTED = 13;
    public static final int OK = 1000;
    public static final int CAPTCHA_REQUIRED = 1001;
    public static final int PAY_LIMIT_EXCEEDED = 1002;
    public static final int NOT_ENOUGH_MONEY = 1003;
    public static final int WRONG_PIN = 1004;

    public boolean pay(String user, String password, String toSkyCashId, String currency, Canvas returnCanvas, boolean fullCanvas, MIDlet midlet, String enterPINMessage, String message, String cmessage, String captchaText, String ok, String cancel) {
        if (this.sending) {
            return false;
        }
        this.sending = true;
        this.action = 0;
        this.toSkyCashId = toSkyCashId;
        if (currency == null) {
            currency = "0";
        }
        this.user = user;
        this.password = password;
        this.currency = currency;
        this.returnCanvas = returnCanvas;
        this.fullCanvas = fullCanvas;
        this.midlet = midlet;
        this.enterPINMessage = enterPINMessage;
        this.message = message;
        this.cmessage = cmessage;
        this.screenWidth = returnCanvas.getWidth();
        this.screenHeight = returnCanvas.getHeight();
        this.captchaText = captchaText;
        this.ok = ok;
        this.cancel = cancel;
        this.thread = new Thread(this);
        this.thread.start();
        return true;
    }

    public boolean isSending() {
        return this.sending;
    }

    public String getReadableErrorMessage() {
        return this.readableErrorMessage;
    }

    public String getServerErrorMessage() {
        return this.serverErrorMessage;
    }

    public void run() {
        String request;
        DataOutputStream dos;
        int endPos;
        int pos;
        int i;
        String s;
        DataInputStream dis;
        int rc;
        byte[] b;
        HttpConnection c;
        if (this.action == 0) {
            try {
                c = (HttpConnection)Connector.open((String)DispManager.convertToUrlForm(SKY_CASH_URL));
                c.setRequestMethod("POST");
                c.setRequestProperty("Content-Type", "application/octet-stream");
                String request2 = "";
                request2 = request2 + "{\n\t\"credentials\":\"" + this.password + "\",\n";
                request2 = request2 + "\t\"applicationType\":\"JAVAME\",\n";
                request2 = request2 + "\t\"locale\":\"PL\",\n";
                request2 = request2 + "\t\"displaySize\":\"" + this.screenWidth + "x" + this.screenHeight + "\",\n";
                request2 = request2 + "\t\"captchaImageSize\":\"" + this.screenWidth * 9 / 10 + "x" + 30 + "\",\n";
                request2 = request2 + "\t\"skyCashId\":\"" + this.user + "\",\n";
                if (this.captchaText != null) {
                    request2 = request2 + "\t\"captchaText\":\"" + this.captchaText + "\",\n";
                }
                request2 = request2 + "\t\"procedureName\":\"loginUser\"\n";
                request2 = request2 + "}";
                DataOutputStream dos2 = c.openDataOutputStream();
                b = request2.getBytes("UTF-8");
                dos2.write(b, 0, b.length);
                dos2.flush();
                dos2.close();
                rc = c.getResponseCode();
                if (rc != 200) {
                    this.result = 1;
                    this.serverErrorMessage = "rc=" + rc;
                    throw new Exception("Connection failed\nResponseCode " + rc);
                }
                dis = c.openDataInputStream();
                s = "";
                i = 0;
                while (i != -1) {
                    i = dis.read();
                    if (i == -1) continue;
                    s = s + (char)i;
                }
                dis.close();
                if (this.isError(s)) {
                    if (this.result != 1001 && this.result != 14) {
                        this.result = 1;
                    }
                    this.sending = false;
                    return;
                }
                String SESSION_MARKER = "\"sessionId\":";
                pos = s.indexOf(SESSION_MARKER);
                if (pos == -1) {
                    this.result = 2;
                    this.sending = false;
                    return;
                }
                endPos = s.indexOf(34, pos += SESSION_MARKER.length() + 1);
                if (endPos == -1) {
                    this.result = 2;
                    this.sending = false;
                    return;
                }
                this.seesionId = s.substring(pos, endPos);
                c.close();
                this.action = 1;
            }
            catch (Exception e) {
                this.result = e instanceof ConnectionNotFoundException ? 1 : 3;
                this.exc = e;
                e.printStackTrace();
                this.sending = false;
                return;
            }
        }
        if (this.action == 1) {
            try {
                c = (HttpConnection)Connector.open((String)DispManager.convertToUrlForm(SKY_CASH_URL));
                c.setRequestMethod("POST");
                c.setRequestProperty("Content-Type", "application/octet-stream");
                dos = c.openDataOutputStream();
                request = "{\n";
                request = request + "\t\"sessionId\":\"" + this.seesionId + "\",\n";
                request = request + "\t\"currency\":\"" + this.currency + "\",\n";
                request = request + "\t\"toSkyCashId\":\"" + this.toSkyCashId + "\",\n";
                request = request + "\t\"fromSkyCashId\":\"" + this.user + "\",\n";
                request = request + "\t\"procedureName\":\"initPay\"\n";
                request = request + "}";
                b = request.getBytes("UTF-8");
                dos.write(b, 0, b.length);
                dos.close();
                rc = c.getResponseCode();
                if (rc != 200) {
                    this.result = 5;
                    this.serverErrorMessage = "rc=" + rc;
                    throw new Exception("Connection failed");
                }
                dis = c.openDataInputStream();
                s = "";
                i = 0;
                while (i != -1) {
                    i = dis.read();
                    if (i == -1) continue;
                    s = s + (char)i;
                }
                dis.close();
                if (this.isError(s)) {
                    if (this.result != 14) {
                        this.result = 5;
                    }
                    this.sending = false;
                    return;
                }
                String PAY_REFERENCE_MARKER = "\"payReference\":";
                pos = s.indexOf(PAY_REFERENCE_MARKER);
                if (pos == -1) {
                    this.result = 6;
                    this.sending = false;
                    return;
                }
                endPos = s.indexOf(34, pos += PAY_REFERENCE_MARKER.length() + 1);
                if (endPos == -1) {
                    this.result = 6;
                    this.sending = false;
                    return;
                }
                this.payReference = s.substring(pos, endPos);
                String ACCEPTED_MARKER = "\"accepted\":";
                pos = s.indexOf(ACCEPTED_MARKER);
                if (pos == -1) {
                    this.result = 6;
                    this.sending = false;
                    return;
                }
                endPos = s.indexOf(10, pos += ACCEPTED_MARKER.length());
                if (endPos == -1) {
                    this.result = 6;
                    this.sending = false;
                    return;
                }
                if (s.substring(pos, endPos).startsWith("false")) {
                    this.result = 8;
                    this.sending = false;
                    return;
                }
                c.close();
                TextBox tb = new TextBox(this.enterPINMessage, "", 4, 65536);
                Command com = new Command(this.ok, 4, 1);
                Command com2 = new Command(this.cancel, 3, 1);
                tb.addCommand(com);
                tb.addCommand(com2);
                tb.setCommandListener((CommandListener)this);
                Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)tb);
            }
            catch (Exception e) {
                this.result = e instanceof ConnectionNotFoundException ? 5 : 6;
                this.exc = e;
                e.printStackTrace();
                this.sending = false;
                return;
            }
        }
        if (this.action == 2) {
            try {
                c = (HttpConnection)Connector.open((String)DispManager.convertToUrlForm(SKY_CASH_URL));
                c.setRequestMethod("POST");
                c.setRequestProperty("Content-Type", "application/octet-stream");
                dos = c.openDataOutputStream();
                request = "{\n";
                request = request + "\t\"userSpecifiedMessage\":\"" + this.message + "\",\n";
                request = request + "\t\"cmessage\":\"" + this.cmessage + "\",\n";
                request = request + "\t\"paymentReference\":\"" + this.payReference + "\",\n";
                request = request + "\t\"credentials\":\"" + this.PIN + "\",\n";
                request = request + "\t\"notify\":false,\n";
                request = request + "\t\"sessionId\":\"" + this.seesionId + "\",\n";
                request = request + "\t\"procedureName\":\"confirmPay\"\n";
                request = request + "}";
                b = request.getBytes("UTF-8");
                dos.write(b, 0, b.length);
                dos.close();
                rc = c.getResponseCode();
                if (rc != 200) {
                    this.result = 10;
                    this.serverErrorMessage = "rc=" + rc;
                    throw new Exception("Connection failed");
                }
                dis = c.openDataInputStream();
                s = "";
                i = 0;
                while (i != -1) {
                    i = dis.read();
                    if (i == -1) continue;
                    s = s + (char)i;
                }
                dis.close();
                if (this.isError(s)) {
                    this.result = this.result != 14 ? 10 : 1004;
                    this.sending = false;
                    return;
                }
                String RESULT_MARKER = "\"result\":";
                pos = s.indexOf(RESULT_MARKER);
                if (pos == -1) {
                    this.result = 6;
                    this.sending = false;
                    return;
                }
                endPos = s.indexOf(10, pos += RESULT_MARKER.length());
                if (endPos == -1) {
                    this.result = 6;
                    this.sending = false;
                    return;
                }
                if (!s.substring(pos, endPos).startsWith("\"ok\"")) {
                    this.result = 13;
                    this.sending = false;
                    return;
                }
                this.result = 1000;
                this.sending = false;
            }
            catch (Exception e) {
                this.result = e instanceof ConnectionNotFoundException ? 10 : 11;
                e.printStackTrace();
                this.exc = e;
                this.sending = false;
                return;
            }
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c.getCommandType() == 4) {
            this.PIN = ((TextBox)d).getString();
            this.action = 2;
            this.thread = new Thread(this);
            this.thread.start();
        } else {
            this.result = 12;
        }
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.returnCanvas);
        this.returnCanvas.setFullScreenMode(this.fullCanvas);
    }

    private boolean isError(String s) {
        System.out.println(s);
        String ERROR_MARKER = "\"errorMessage\":";
        int pos = s.indexOf(ERROR_MARKER);
        if (pos == -1) {
            return false;
        }
        int endPos = s.indexOf(34, pos += ERROR_MARKER.length() + 1);
        if (endPos == -1) {
            return false;
        }
        this.serverErrorMessage = s.substring(pos, endPos);
        boolean isError = endPos > pos;
        String DISPLAYABLE_MESSAGE_MARKER = "\"additionalMessage\"";
        pos = s.indexOf(DISPLAYABLE_MESSAGE_MARKER);
        if (pos != -1 && (endPos = s.indexOf(34, pos += DISPLAYABLE_MESSAGE_MARKER.length() + 1)) != -1) {
            this.readableErrorMessage = s.substring(pos, endPos);
        }
        String CAPTCHA_REQUIRED = "CAPTCHA_REQUIRED_MSG";
        String NOT_ENOUGH_MONEY = "NOT_ENOUGH_MONEY_MSG";
        if (this.serverErrorMessage.equals(NOT_ENOUGH_MONEY)) {
            this.result = 1003;
            return true;
        }
        if (this.serverErrorMessage.equals(CAPTCHA_REQUIRED)) {
            try {
                pos = s.indexOf("[");
                endPos = s.indexOf(34, pos += 2);
                this.captcha = SkyCashClient.base64DecodeImage(s, pos, endPos);
                this.result = 1001;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        if (this.serverErrorMessage.equals("MONTHLY_LIMIT_EXCEEDED_MSG") || this.serverErrorMessage.equals("DAILY_LIMIT_EXCEEDED_MSG")) {
            this.result = 1002;
            return true;
        }
        if (this.serverErrorMessage.equals("NOT_AUTHORIZED_MSG")) {
            this.result = 14;
            return true;
        }
        return isError;
    }

    public Image getCaptcha() {
        return this.captcha;
    }

    private static Image base64DecodeImage(String s, int pos, int endPos) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        try {
            int[] c = new int[4];
            for (int i = pos; i < endPos; i += 4) {
                c[0] = reverseBase64Chars[s.charAt(i)];
                c[1] = reverseBase64Chars[s.charAt(i + 1)];
                c[2] = reverseBase64Chars[s.charAt(i + 2)];
                c[3] = reverseBase64Chars[s.charAt(i + 3)];
                out.write(c[0] << 2 & 0xFF | c[1] >> 4 & 0xFF);
                if (c[2] == -3) continue;
                out.write(c[1] << 4 | c[2] >> 2);
                if (c[3] == -3) continue;
                out.write(c[2] << 6 | c[3]);
            }
            out.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            return Image.createImage((InputStream)bais);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getResult() {
        return this.result;
    }

    static {
        int i;
        base64Chars = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        reverseBase64Chars = new byte[256];
        for (i = 0; i < reverseBase64Chars.length; ++i) {
            SkyCashClient.reverseBase64Chars[i] = -1;
        }
        for (i = 0; i < base64Chars.length; i = (int)((byte)(i + 1))) {
            SkyCashClient.reverseBase64Chars[SkyCashClient.base64Chars[i]] = i;
        }
        SkyCashClient.reverseBase64Chars[61] = -3;
    }
}

