/*
 * Decompiled with CFR 0.152.
 */
package com.fazzidice;

import com.fazzidice.DispManager;
import com.fazzidice.Paintable;
import javax.microedition.lcdui.Graphics;

public class TileSet {
    int[][] pos;
    Paintable img;

    public TileSet(Paintable img, int[][] pos, boolean process) {
        this.img = img;
        this.pos = pos;
        if (process) {
            for (int i = 0; i < pos.length; ++i) {
                pos[i][2] = pos[i][2] - pos[i][0];
                pos[i][3] = pos[i][3] - pos[i][1];
            }
        }
    }

    public TileSet(Paintable img, int[][] pos) {
        this(img, pos, true);
    }

    public TileSet(Paintable img, int width, int height) {
        this.img = img;
        int tileWidth = img.getWidth() / width;
        int tileHeight = img.getHeight() / height;
        this.pos = new int[width * height][];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.pos[x + y * width] = new int[]{x * tileWidth, y * tileHeight, tileWidth, tileHeight};
            }
        }
    }

    public int[][] getPoses() {
        return this.pos;
    }

    public int getWidth(int id) {
        return this.pos[id][2];
    }

    public int getHeight(int id) {
        return this.pos[id][3];
    }

    public void paint(Graphics g, int x, int y, int id, int anchor, boolean mirror) {
        DispManager.saveClip(g);
        y = TileSet.transformY(y, this.getHeight(id), anchor);
        x = TileSet.transformX(x, this.getWidth(id), anchor);
        g.clipRect(x, y, this.pos[id][2], this.pos[id][3]);
        if (!mirror) {
            this.img.paint(g, x - this.pos[id][0], y - this.pos[id][1], 0x10 | 4);
        } else {
            this.img.setMirror(true);
            this.img.paint(g, x - (this.img.getWidth() - this.pos[id][0] - this.getWidth(id)), y - this.pos[id][1], 0x10 | 4);
            this.img.setMirror(false);
        }
        DispManager.loadClip(g);
    }

    public static final int transformY(int y, int height, int anchor) {
        if ((0x20 & anchor) > 0) {
            return y - height + 1;
        }
        if ((2 & anchor) > 0) {
            return y - height / 2;
        }
        return y;
    }

    public static final int transformX(int x, int width, int anchor) {
        if ((8 & anchor) > 0) {
            return x - width;
        }
        if ((1 & anchor) > 0) {
            return x - width / 2;
        }
        return x;
    }
}

