/*
 * Decompiled with CFR 0.152.
 */
package com.fazzidice;

import com.fazzidice.DispManager;
import com.fazzidice.Main;
import java.io.IOException;
import java.io.InputStream;

public class PartialInputStream
extends InputStream {
    private String filePrefix;
    private String fileSufix;
    private int partSize;
    private int currentPart;
    private int byteRead;
    InputStream is;

    public PartialInputStream(String filePrefix, String fileSufix, int partSize) {
        this.filePrefix = filePrefix;
        this.fileSufix = fileSufix;
        this.partSize = partSize;
        this.currentPart = -1;
        this.byteRead = partSize;
    }

    public int read() throws IOException {
        DispManager.message = "PartialInputStream::read() a " + this.currentPart;
        if (this.byteRead == this.partSize) {
            if (this.is != null) {
                this.is.close();
            }
            ++this.currentPart;
            this.byteRead = 0;
            this.is = Main.getResourceAsStream(this.filePrefix + "_" + this.currentPart + this.fileSufix);
        }
        ++this.byteRead;
        DispManager.message = "PartialInputStream::read() b " + this.currentPart;
        return this.is.read();
    }

    public boolean markSupported() {
        return false;
    }

    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
    }

    public long skip(long n) throws IOException {
        DispManager.message = "PartialInputStream::skip()";
        long s = n;
        if (n >= (long)(this.partSize - this.byteRead)) {
            n -= (long)(this.partSize - this.byteRead);
            if (this.is != null) {
                this.is.close();
                this.is = null;
            }
            this.byteRead = 0;
            ++this.currentPart;
            if (n > (long)this.partSize) {
                if (this.is != null) {
                    this.is.close();
                    this.is = null;
                }
                this.currentPart = (int)((long)this.currentPart + n / (long)this.partSize);
                n %= (long)this.partSize;
            }
            DispManager.message = "skip, loading part " + this.currentPart;
            this.is = Main.getResourceAsStream(this.filePrefix + "_" + this.currentPart + this.fileSufix);
            DispManager.message = "skip, loaded part " + this.is;
        }
        this.byteRead = (int)((long)this.byteRead + n);
        while ((n -= this.is.skip(n)) > 0L) {
        }
        DispManager.message = "/PartialInputStream::skip()";
        return s - n;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read;
        int tlen = len;
        if (len >= this.partSize - this.byteRead) {
            int toRead = this.partSize - this.byteRead;
            while (toRead > 0) {
                read = this.is.read(b, off, toRead);
                toRead -= read;
                off += read;
                len -= read;
            }
            if (this.is != null) {
                this.is.close();
                this.is = null;
            }
            this.byteRead = 0;
            ++this.currentPart;
            if (len > this.partSize) {
                int parts = len / this.partSize;
                for (int i = 0; i < parts; ++i) {
                    this.is = this.getClass().getResourceAsStream(this.filePrefix + "_" + this.currentPart + this.fileSufix);
                    toRead = this.partSize;
                    while (toRead > 0) {
                        int read2 = this.is.read(b, off, toRead);
                        toRead -= read2;
                        off += read2;
                        len -= read2;
                    }
                    ++this.currentPart;
                }
                if (this.is != null) {
                    this.is.close();
                    this.is = null;
                }
            }
            this.is = this.getClass().getResourceAsStream(this.filePrefix + "_" + this.currentPart + this.fileSufix);
        }
        while (len > 0) {
            read = this.is.read(b, off, len);
            len -= read;
            off += read;
            this.byteRead += read;
        }
        return tlen;
    }
}

