/*
 * Decompiled with CFR 0.152.
 */
package com.fazzidice;

import com.fazzidice.DispManager;
import com.fazzidice.MenuItem;
import com.fazzidice.Paintable;
import javax.microedition.lcdui.Graphics;

public class MIButton
extends MenuItem {
    Paintable unFocused;
    Paintable focused;
    Paintable pressed;

    public MIButton(String label) {
        super(2, label);
        this.isNavigable = true;
        this.isResizeable = false;
    }

    public void setUnFocused(Paintable img) {
        this.unFocused = img;
        this.width = Math.max(this.width, img.getWidth());
        this.height = Math.max(this.height, img.getHeight());
        this.img = img;
    }

    public void setFocused(Paintable img) {
        this.focused = img;
        this.width = Math.max(this.width, img.getWidth());
        this.height = Math.max(this.height, img.getHeight());
    }

    public void setPressed(Paintable img) {
        this.pressed = img;
        this.width = Math.max(this.width, img.getWidth());
        this.height = Math.max(this.height, img.getHeight());
    }

    public void setFormated(Paintable formated) {
        super.setFormated(formated);
        this.width = Math.max(this.width, formated.getWidth());
        this.height = Math.max(this.height, formated.getHeight());
    }

    public boolean keyPressed(int keyCode) {
        super.keyPressed(keyCode);
        if (DispManager.translateKey(keyCode) == 19 && this.pressed != null) {
            this.img = this.pressed;
        }
        return false;
    }

    public boolean keyReleased(int keyCode) {
        super.keyReleased(keyCode);
        if (DispManager.translateKey(keyCode) == 19) {
            this.img = this.focused != null ? this.focused : this.unFocused;
        }
        return false;
    }

    public void setIsSelected(boolean isSelected) {
        this.img = isSelected && this.focused != null ? this.focused : this.unFocused;
        super.setIsSelected(isSelected);
    }

    public void paint(Graphics g) {
        this.img.paint(g, this.parent.toPx(this.x + this.width / 2), this.parent.toPx(this.y - this.height / 2), 3);
        if (this.formated != null) {
            this.formated.paint(g, this.parent.toPx(this.x + this.width / 2), this.parent.toPx(this.y - this.height / 2), 3);
        }
    }

    public int getWidth() {
        return Math.max(this.width, this.padH * 2 + (this.formated != null ? this.formated.getWidth() : 0));
    }

    public int getHeight() {
        return Math.max(this.height, this.padV * 2 + (this.formated != null ? this.formated.getHeight() : 0));
    }

    public void update(int time) {
    }

    public MenuItem copy() {
        MIButton b = new MIButton(this.getLabel());
        if (this.unFocused != null) {
            b.setUnFocused(this.unFocused.copy());
        }
        if (this.focused != null) {
            b.setFocused(this.focused.copy());
        }
        if (this.pressed != null) {
            b.setPressed(this.pressed.copy());
        }
        this.copySizeParams(b);
        return b;
    }

    public void load() {
        super.load();
        if (this.focused != null) {
            this.focused.addToLoad();
        }
        if (this.unFocused != null) {
            this.unFocused.addToLoad();
        }
        if (this.pressed != null) {
            this.pressed.addToLoad();
        }
    }
}

