/*
 * Decompiled with CFR 0.152.
 */
package com.fazzidice;

import com.fazzidice.Disp;
import com.fazzidice.DispManager;
import com.fazzidice.Paintable;
import javax.microedition.lcdui.Graphics;

public class Sprite {
    public static final int FX = -1;
    public static final int EXIT = 15;
    public static final int VIBRA = 14;
    public static final int SOUND = 13;
    public static final int PAUSE_BG = 12;
    public static final int RANDOM = 11;
    public static final int WEAK = 10;
    public static final int STRONG = 9;
    public static final int MULTI_HIT = 8;
    public static final int ROCKET_FUEL = 7;
    public static final int PANIC_CHICKEN = 6;
    public static final int CROCO = 5;
    public static final int MI_SCROLLABLE = 4;
    public static final int MI_LABEL = 3;
    public static final int MI_BUTTON = 2;
    public static final int MENU_TIME = 1;
    public static final int LIST_GUARD = Integer.MIN_VALUE;
    Sprite next;
    Sprite prev;
    Disp parent;
    boolean physical;
    boolean toRemove;
    int liveTime;
    int moveStart;
    int moveTime;
    int startX;
    int startY;
    int endX;
    int endY;
    int x;
    int y;
    int typeId;
    int oldX;
    int oldY;
    int vx;
    int vy;
    Paintable img;
    protected boolean single;

    public Sprite(int x, int y, int typeId, Paintable img) {
        this.x = x;
        this.y = y;
        this.typeId = typeId;
        this.img = img;
        this.prev = this.next = this;
    }

    public Sprite(int x, int y, int typeId, Paintable img, boolean single) {
        this.x = x;
        this.y = y;
        this.typeId = typeId;
        this.img = img;
        this.single = single;
        this.prev = this.next = this;
    }

    public Sprite() {
        this.typeId = Integer.MIN_VALUE;
        this.prev = this.next = this;
    }

    public void setPaintable(Paintable p) {
        this.img = p;
    }

    public void moveTo(int destX, int destY, int time) {
        this.moveTime = time;
        this.startX = this.x;
        this.startY = this.y;
        this.endX = destX;
        this.endY = destY;
        this.moveStart = this.parent.gameTime;
    }

    public int getWidth() {
        return this.parent.fromPx(this.img.getWidth());
    }

    public int getHeight() {
        return this.parent.fromPx(this.img.getHeight());
    }

    public void paint(Graphics g) {
        DispManager.message = "Sprite paint " + this.typeId;
        this.img.paint(g, this.parent.toPx(this.x), this.parent.toPx(this.y), 0x20 | 4);
        DispManager.message = "/Sprite paint " + this.typeId;
    }

    public final void remove() {
        this.toRemove = true;
    }

    public final void addAfter(Sprite s) {
        this.next = s.next;
        this.prev = s;
        this.prev.next = this;
        this.next.prev = this;
        this.parent = s.parent;
    }

    public void update(int elapsedTime) {
        DispManager.message = "Sprite update " + this.typeId;
        this.oldX = this.x;
        this.oldY = this.y;
        this.x += this.vx * elapsedTime / 1000;
        this.y += this.vy * elapsedTime / 1000;
        this.img.update(elapsedTime);
        if (this.moveTime != 0) {
            int t = this.parent.gameTime - this.moveStart;
            if (t >= this.moveTime) {
                this.moveTime = 0;
                this.x = this.endX;
                this.y = this.endY;
            } else {
                this.x = this.startX + (this.endX - this.startX) * t / this.moveTime;
                this.y = this.startY + (this.endY - this.startY) * t / this.moveTime;
            }
        }
        if (this.liveTime < this.parent.gameTime && this.liveTime != 0 || this.single && this.img.getAnimationCycles() > 0) {
            this.remove();
        }
        DispManager.message = "/Sprite update " + this.typeId;
    }

    public void setLiveTime(int liveTime) {
        this.liveTime = liveTime + this.parent.gameTime;
    }

    public void onAdd() {
    }

    public void onRemove() {
    }

    public void onCollision(Sprite s) {
    }
}

