/*
 * Decompiled with CFR 0.152.
 */
package com.fazzidice;

import com.fazzidice.DispManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.RecordStore;

public class Saver {
    static RecordStore rs;
    static final int ACH_POINTS = 0;
    static final int ACH_HITS_IN_ROW = 1;
    static final int ACH_UBITE_FRANCE = 2;
    static final int ACH_CHIKEN_FARMER = 3;
    static final int ACH_LAPKA_KILLER = 4;
    static final int ACH_LUNCH_BREAKER = 5;
    static final int ACH_POWER_SAVER = 6;
    static final int ACH_PUDLO_MASTER = 7;
    static final int ACH_NUM = 8;
    static final int REC_ACH = 4;
    static final int REC_SKYCASH = 3;
    static final int REC_SOUND = 1;
    static final int REC_VIBRA = 2;
    static boolean[] achivments;
    static boolean vibraOn;
    static int bestResult;
    static int hitsInRow;
    static int crocoKilled;
    static int volume;
    static int sound;
    static String skyCashUser;
    static String skyCashPassword;

    public static void init() {
        try {
            rs = RecordStore.openRecordStore((String)"4fiter", (boolean)true);
            if (rs.getNumRecords() < 4) {
                rs.addRecord(new byte[]{0}, 0, 1);
                rs.addRecord(new byte[]{0}, 0, 1);
                rs.addRecord(new byte[]{0}, 0, 1);
                rs.addRecord(new byte[]{0}, 0, 1);
                Saver.setSound(5);
                Saver.setVibra(true);
                Saver.setSkyCash("", "");
                Saver.saveAchievements();
            }
            Saver.loadSkyCash();
            volume = sound = Saver.loadSound();
            vibraOn = Saver.loadVibra();
            Saver.loadAch();
        }
        catch (Throwable e) {
            e.printStackTrace();
            DispManager.reportError(e);
        }
    }

    public static void setSound(int sound) {
        if (sound == 0) {
            DispManager.stopMusic();
        }
        try {
            ByteArrayOutputStream bais = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bais);
            out.writeInt(sound);
            rs.setRecord(1, bais.toByteArray(), 0, bais.toByteArray().length);
            Saver.sound = sound;
            if (sound != 0) {
                volume = sound;
            }
            DispManager.play(DispManager.musicFileName, false);
        }
        catch (Throwable e) {
            e.printStackTrace();
            DispManager.reportError(e);
        }
    }

    public static int getSound() {
        return sound;
    }

    private static int loadSound() {
        try {
            DataInputStream in = null;
            in = new DataInputStream(new ByteArrayInputStream(rs.getRecord(1)));
            return in.readInt();
        }
        catch (Throwable e) {
            e.printStackTrace();
            DispManager.reportError(e);
            return 0;
        }
    }

    public static void loadAch() {
        try {
            DataInputStream in = null;
            in = new DataInputStream(new ByteArrayInputStream(rs.getRecord(4)));
            crocoKilled = in.readInt();
            bestResult = in.readInt();
            hitsInRow = in.readInt();
            for (int i = 0; i < 8; ++i) {
                Saver.achivments[i] = in.readBoolean();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            DispManager.reportError(e);
        }
    }

    public static void setAch(int i) {
        Saver.achivments[i] = true;
        Saver.saveAchievements();
    }

    public static void setBestResult(int bestResult) {
        if (bestResult > Saver.bestResult) {
            Saver.bestResult = bestResult;
            Saver.saveAchievements();
        }
    }

    public static void setHitsInRow(int hitsInRow) {
        if (hitsInRow > Saver.hitsInRow) {
            Saver.hitsInRow = hitsInRow;
            Saver.saveAchievements();
        }
    }

    public static void addCrocoKilled(int i) {
        crocoKilled += i;
        Saver.saveAchievements();
    }

    public static void saveAchievements() {
        try {
            ByteArrayOutputStream bais = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bais);
            out.writeInt(crocoKilled);
            out.writeInt(bestResult);
            out.writeInt(hitsInRow);
            for (int j = 0; j < 8; ++j) {
                out.writeBoolean(achivments[j]);
            }
            rs.setRecord(4, bais.toByteArray(), 0, bais.toByteArray().length);
        }
        catch (Throwable e) {
            e.printStackTrace();
            DispManager.reportError(e);
        }
    }

    public static void setVibra(boolean on) {
        try {
            ByteArrayOutputStream bais = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bais);
            out.writeByte(on ? 1 : 0);
            rs.setRecord(2, bais.toByteArray(), 0, bais.toByteArray().length);
            vibraOn = on;
        }
        catch (Throwable e) {
            e.printStackTrace();
            DispManager.reportError(e);
        }
    }

    public static boolean getVibra() {
        return vibraOn;
    }

    private static boolean loadVibra() {
        try {
            DataInputStream in = null;
            in = new DataInputStream(new ByteArrayInputStream(rs.getRecord(2)));
            return in.readByte() == 1;
        }
        catch (Throwable e) {
            e.printStackTrace();
            DispManager.reportError(e);
            return false;
        }
    }

    public static void setSkyCash(String login, String password) {
        try {
            ByteArrayOutputStream bais = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bais);
            System.out.println(login + " " + password);
            skyCashUser = login;
            skyCashPassword = password;
            out.writeUTF(skyCashUser);
            out.writeUTF(skyCashPassword);
            rs.setRecord(3, bais.toByteArray(), 0, bais.toByteArray().length);
        }
        catch (Throwable e) {
            e.printStackTrace();
            DispManager.reportError(e);
        }
    }

    public static void loadSkyCash() {
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(rs.getRecord(3)));
            skyCashUser = in.readUTF();
            skyCashPassword = in.readUTF();
        }
        catch (Throwable e) {
            e.printStackTrace();
            DispManager.reportError(e);
        }
    }

    static {
        achivments = new boolean[8];
        skyCashUser = "";
        skyCashPassword = "";
    }
}

