/*
 * Decompiled with CFR 0.152.
 */
package com.fazzidice;

import com.fazzidice.DispManager;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class ResManParser {
    public static final int TYPE_DIR = 0;
    public static final int TYPE_IMAGE = 1;
    public static final int FORMAT_ARGB8888 = 0;
    public static final int FORMAT_RGB888 = 1;
    public static final int FORMAT_ARGB1555 = 2;
    public static final int FORMAT_RGB565 = 3;
    public static final int FORMAT_PALETTE = 4;
    public static final int FORMAT_GRAYSCALE = 5;
    DataInputStream dis;
    private int version;
    private int resNum;
    private int[] resSize;
    private int actual = -1;
    private int actualType;
    boolean parsed = false;
    boolean hasBeenLoaded = true;
    byte format;
    short width;
    short height;
    int[] pixels;

    public ResManParser(InputStream is) {
        DispManager.message = "ResManParser a";
        this.dis = new DataInputStream(is);
        DispManager.message = "ResManParser b";
        try {
            this.version = this.dis.readInt();
            this.resNum = this.dis.readInt();
            this.resSize = new int[this.resNum];
            for (int i = 0; i < this.resNum; ++i) {
                this.resSize[i] = this.dis.readInt();
            }
            this.next();
        }
        catch (Throwable e) {
            e.printStackTrace();
            DispManager.reportError(new Exception(e.toString() + "\ncreate ResManParser"));
        }
    }

    public int getResNum() {
        return this.resNum;
    }

    public void close() throws IOException {
        this.dis.close();
    }

    public int getResSize(int i) {
        return this.resSize[i];
    }

    public int getVersion() {
        return this.version;
    }

    public int getActual() {
        return this.actual;
    }

    public int getActualType() {
        return this.actualType;
    }

    public boolean hasNext() {
        return this.actual < this.resNum - 1;
    }

    public void next() throws IOException {
        if (!this.hasNext()) {
            return;
        }
        this.parsed = false;
        if (!this.hasBeenLoaded) {
            int toSkip = this.resSize[this.actual] - 1;
            while (toSkip > 0) {
                long n = this.dis.skip(toSkip);
                toSkip = (int)((long)toSkip - n);
            }
        }
        ++this.actual;
        this.actualType = this.dis.readByte();
        this.hasBeenLoaded = false;
    }

    public void skip(int n) throws IOException {
        if (n <= 0) {
            return;
        }
        int toSkip = 0;
        DispManager.message = "skipping a " + n + " " + this.resSize;
        if (!this.hasBeenLoaded) {
            toSkip = this.resSize[this.actual] - 1;
        }
        ++this.actual;
        --n;
        while (n > 0) {
            toSkip += this.resSize[this.actual];
            --n;
            ++this.actual;
        }
        DispManager.message = "skipping b " + this.dis;
        this.dis.skip(toSkip);
        DispManager.message = "skipping c";
        this.parsed = false;
        this.hasBeenLoaded = false;
        this.actualType = this.dis.readByte();
    }

    private void parse() throws IOException {
        if (this.parsed) {
            return;
        }
        switch (this.actualType) {
            case 1: {
                this.parseImage();
                break;
            }
            default: {
                System.out.println("unknown type to parse");
            }
        }
        this.hasBeenLoaded = true;
        this.parsed = true;
    }

    public void parseImageHeader() throws IOException {
        this.format = this.dis.readByte();
        this.width = this.dis.readShort();
        this.height = this.dis.readShort();
    }

    private void parseImage() throws IOException {
        this.parseImageHeader();
        this.pixels = new int[this.width * this.height];
        switch (this.format) {
            case 0: {
                byte[] b = new byte[4 * this.width * this.height];
                this.dis.read(b);
                DataInputStream di = new DataInputStream(new ByteArrayInputStream(b));
                for (int i = 0; i < this.pixels.length; ++i) {
                    this.pixels[i] = di.readInt();
                }
                break;
            }
            case 1: {
                byte[] b = new byte[3 * this.width * this.height];
                this.dis.read(b);
                DataInputStream di = new DataInputStream(new ByteArrayInputStream(b));
                for (int i = 0; i < this.pixels.length; ++i) {
                    this.pixels[i] = 0xFF000000 | di.readUnsignedByte() << 16 | di.readUnsignedByte() << 8 | di.readUnsignedByte();
                }
                break;
            }
            case 2: {
                byte[] b = new byte[2 * this.width * this.height];
                this.dis.read(b);
                DataInputStream di = new DataInputStream(new ByteArrayInputStream(b));
                int i = 0;
                while (i < this.pixels.length) {
                    int p = di.readUnsignedShort();
                    if ((p & 0x8000) != 0) {
                        this.pixels[i] = -16777216;
                    }
                    int n = i;
                    this.pixels[n] = this.pixels[n] | (p & 0x1F) << 3;
                    int n2 = i;
                    this.pixels[n2] = this.pixels[n2] | ((p >>= 5) & 0x1F) << 11;
                    int n3 = i++;
                    this.pixels[n3] = this.pixels[n3] | ((p >>= 5) & 0x1F) << 19;
                }
                break;
            }
            case 3: {
                byte[] b = new byte[2 * this.width * this.height];
                this.dis.read(b);
                DataInputStream di = new DataInputStream(new ByteArrayInputStream(b));
                int i = 0;
                while (i < this.pixels.length) {
                    int p = di.readUnsignedShort();
                    this.pixels[i] = -16777216;
                    int n = i;
                    this.pixels[n] = this.pixels[n] | (p & 0x1F) << 3;
                    int n4 = i;
                    this.pixels[n4] = this.pixels[n4] | ((p >>= 5) & 0x3F) << 10;
                    int n5 = i++;
                    this.pixels[n5] = this.pixels[n5] | ((p >>= 6) & 0x1F) << 19;
                }
                break;
            }
            case 5: {
                byte[] b = new byte[2 * this.width * this.height];
                this.dis.read(b);
                DataInputStream di = new DataInputStream(new ByteArrayInputStream(b));
                int i = 0;
                while (i < this.pixels.length) {
                    int p = di.readUnsignedByte();
                    this.pixels[i] = -16777216;
                    int n = i;
                    this.pixels[n] = this.pixels[n] | p << 16;
                    int n6 = i;
                    this.pixels[n6] = this.pixels[n6] | p << 8;
                    int n7 = i++;
                    this.pixels[n7] = this.pixels[n7] | p;
                }
                break;
            }
            case 4: {
                byte p;
                int i;
                byte[] b = new byte[this.resSize[this.actual] - 6];
                this.dis.read(b);
                DataInputStream di = new DataInputStream(new ByteArrayInputStream(b));
                short colorNum = di.readShort();
                int a = di.readShort();
                int[] palette = new int[colorNum];
                for (i = 0; i < a; ++i) {
                    palette[i] = di.readInt();
                }
                for (i = a; i < colorNum; ++i) {
                    palette[i] = 0xFF000000 | di.readUnsignedByte() << 16 | di.readUnsignedByte() << 8 | di.readUnsignedByte();
                }
                DispManager.message = "PALETTE actual=" + this.actual + " colors=" + colorNum;
                int bitsPerPixel = 1;
                bitsPerPixel = colorNum <= 2 ? 1 : (colorNum <= 4 ? 2 : (colorNum <= 16 ? 4 : 8));
                int pixelsInByte = 8 / bitsPerPixel;
                int mask = (1 << bitsPerPixel) - 1;
                for (int i2 = 0; i2 < this.pixels.length / pixelsInByte; ++i2) {
                    p = di.readByte();
                    for (int j = 0; j < pixelsInByte; ++j) {
                        this.pixels[i2 * pixelsInByte + j] = palette[p >> j * bitsPerPixel & mask];
                    }
                }
                int m = this.width * this.height % pixelsInByte;
                if (m == 0) break;
                p = di.readByte();
                int i3 = this.width * this.height - m;
                for (int j = 0; j < m; ++j) {
                    this.pixels[i3 + j] = palette[p >> j & mask];
                }
                break;
            }
        }
    }

    public Image getImage() throws IOException {
        if (this.actualType != 1) {
            return null;
        }
        if (!this.parsed) {
            this.parse();
        }
        Image img = Image.createRGBImage((int[])this.pixels, (int)this.width, (int)this.height, (boolean)true);
        if (this.actual == 109) {
            DispManager.message2 = this.width + " " + this.height + " " + img.getWidth() + " " + img.getHeight() + " " + System.currentTimeMillis();
        }
        this.pixels = null;
        return img;
    }
}

