/*
 * Decompiled with CFR 0.152.
 */
package com.fazzidice;

import com.fazzidice.DispManager;
import com.fazzidice.Paintable;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageFont {
    private static final int BMF_CHAR_ID = 0;
    private static final int BMF_CHAR_X = 1;
    private static final int BMF_CHAR_Y = 2;
    private static final int BMF_CHAR_WIDTH = 3;
    private static final int BMF_CHAR_HEIGHT = 4;
    private static final int BMF_CHAR_XOFFSET = 5;
    private static final int BMF_CHAR_YOFFSET = 6;
    private static final int BMF_CHAR_XADVANCE = 7;
    private static final int BMF_CHAR_PAGE = 8;
    private static final int BMF_CHAR_CHNL = 9;
    protected int width_;
    protected int hSpacing_;
    protected int vSpacing_;
    private int outlineWidth;
    private int bmfFontSize;
    private int bmfBitField;
    private int bmfCharSet;
    private int bmfStrechtH;
    private int bmfaa;
    private int bmfPaddingUp;
    private int bmfPaddingRight;
    private int bmfPaddingDown;
    private int bmfPaddingLeft;
    private int bmfSpacingHoriz;
    private int bmfSpacingVert;
    private int bmfOutline;
    private int bmfLineHeight;
    private int bmfBase;
    private int bmfScaleW;
    private int bmfScaleH;
    private int bmfPages;
    private int bmfCommonBitField;
    private int bmfAlphaChannel;
    private int bmfRedChannel;
    private int bmfGreenChannel;
    private int bmfBlueChannel;
    private int[][] bmfChars;
    private int[] charMapping;
    private String bmfFontName;
    private Image bmfBitmap;
    int height;
    int[] charsWidth;
    int[][] pxPos;
    int[] charPos;

    public ImageFont(Image image, String fontFileName) {
        this.outlineWidth = this.outlineWidth;
        try {
            int i;
            char c;
            InputStream is = this.getClass().getResourceAsStream("/" + fontFileName + ".fnt");
            this.bmfBitmap = image;
            this.bmfFontName = "";
            DataInputStream dis = new DataInputStream(is);
            dis.readInt();
            dis.read();
            dis.readInt();
            this.bmfFontSize = dis.readShort();
            this.bmfBitField = dis.read();
            this.bmfCharSet = dis.read();
            this.bmfStrechtH = dis.read() | dis.read() << 16;
            this.bmfaa = dis.read();
            this.bmfPaddingUp = dis.read();
            this.bmfPaddingRight = dis.read();
            this.bmfPaddingDown = dis.read();
            this.bmfPaddingLeft = dis.read();
            this.bmfSpacingHoriz = dis.read();
            this.bmfSpacingVert = dis.read();
            this.outlineWidth = this.bmfOutline = dis.read();
            while ((c = (char)dis.read()) != '\u0000') {
                this.bmfFontName = this.bmfFontName + c;
            }
            dis.read();
            dis.readInt();
            this.bmfLineHeight = dis.read() | dis.read() << 8;
            this.bmfBase = dis.read() | dis.read() << 8;
            this.bmfScaleW = dis.read() | dis.read() << 8;
            this.bmfScaleH = dis.read() | dis.read() << 8;
            this.bmfPages = dis.read() | dis.read() << 8;
            this.bmfCommonBitField = dis.read();
            this.bmfAlphaChannel = dis.read();
            this.bmfRedChannel = dis.read();
            this.bmfGreenChannel = dis.read();
            this.bmfBlueChannel = dis.read();
            dis.read();
            int n = dis.read() | dis.read() << 8 | dis.read() << 16 | dis.read() << 24;
            for (int i2 = 0; i2 < n; ++i2) {
                dis.read();
            }
            dis.read();
            n = dis.read() | dis.read() << 8 | dis.read() << 16 | dis.read() << 24;
            int maxCharId = 0;
            this.bmfChars = new int[n /= 20][10];
            for (i = 0; i < n; ++i) {
                this.bmfChars[i][0] = dis.read() | dis.read() << 8 | dis.read() << 16 | dis.read() << 24;
                maxCharId = Math.max(maxCharId, this.bmfChars[i][0]);
                this.bmfChars[i][1] = dis.read() | dis.read() << 8;
                this.bmfChars[i][2] = dis.read() | dis.read() << 8;
                this.bmfChars[i][3] = dis.read() | dis.read() << 8;
                this.bmfChars[i][4] = dis.read() | dis.read() << 8;
                this.bmfChars[i][5] = this.convertFrom16Bit(dis.read() | dis.read() << 8);
                this.bmfChars[i][6] = this.convertFrom16Bit(dis.read() | dis.read() << 8);
                if (this.bmfChars[i][0] == 346 || this.bmfChars[i][0] == 377 || this.bmfChars[i][0] == 379) {
                    int[] nArray = this.bmfChars[i];
                    nArray[4] = nArray[4] + this.outlineWidth;
                    int[] nArray2 = this.bmfChars[i];
                    nArray2[2] = nArray2[2] - this.outlineWidth;
                    int[] nArray3 = this.bmfChars[i];
                    nArray3[6] = nArray3[6] - this.outlineWidth;
                }
                this.bmfChars[i][7] = (dis.read() | dis.read() << 8) + this.outlineWidth + 1;
                this.bmfChars[i][8] = dis.read();
                this.bmfChars[i][9] = dis.read();
            }
            this.charMapping = new int[maxCharId + 1];
            for (i = 0; i < maxCharId + 1; ++i) {
                this.charMapping[i] = -1;
            }
            for (i = 0; i < n; ++i) {
                this.charMapping[this.bmfChars[i][0]] = i;
            }
            this.height = this.bmfLineHeight;
            this.width_ = this.getCharWidth('W');
            this.hSpacing_ = this.bmfSpacingHoriz;
            this.vSpacing_ = this.bmfSpacingVert;
        }
        catch (Throwable e) {
            e.printStackTrace();
            DispManager.reportError(new Exception(e.toString() + "\nImageFont create " + image + " " + this.getClass().getResourceAsStream("/" + fontFileName + ".fnt")));
        }
    }

    int convertFrom16Bit(int value) {
        if (value >= 32768) {
            return value - 65536;
        }
        return value;
    }

    public int getHeight() {
        return this.height;
    }

    public int getCharWidth(char c) {
        int index = -1;
        if (c < this.charMapping.length) {
            index = this.charMapping[c];
        }
        if (index == -1) {
            index = this.charMapping[32];
            return index;
        }
        return this.bmfChars[index][7];
    }

    public void write(Graphics g, String s, int x, int y, int anchor) {
        DispManager.saveClip(g);
        if ((8 & anchor) == 8) {
            x -= this.getStringWidth(s);
        }
        if ((1 & anchor) == 1) {
            x -= this.getStringWidth(s) / 2;
        }
        if ((0x20 & anchor) == 32) {
            y -= this.getHeight() - 1;
        }
        if ((2 & anchor) == 2) {
            y -= this.getHeight() / 2;
        }
        for (int i = 0; i < s.length(); ++i) {
            int index = -1;
            if (s.charAt(i) < this.charMapping.length) {
                index = this.charMapping[s.charAt(i)];
            }
            if (index != -1) {
                g.clipRect(x + this.bmfChars[index][5], y + this.bmfChars[index][6], this.bmfChars[index][3], this.bmfChars[index][4]);
                g.drawImage(this.bmfBitmap, x - this.bmfChars[index][1] + this.bmfChars[index][5], y - this.bmfChars[index][2] + this.bmfChars[index][6], 0x10 | 4);
                DispManager.peekClip(g);
            }
            x += this.getCharWidth(s.charAt(i));
        }
        DispManager.loadClip(g);
    }

    public int getStringWidth(String s) {
        int x = 0;
        for (int i = 0; i < s.length(); ++i) {
            x += this.getCharWidth(s.charAt(i));
        }
        return x;
    }

    ImageFont() {
    }

    public void write(Graphics g, String[] s, int x, int y, int anchor, int offset, int num) {
        if ((0x20 & anchor) > 0) {
            y -= this.height * s.length;
        }
        if ((2 & anchor) > 0) {
            y -= this.height * s.length / 2;
        }
        if (num == 0) {
            num = s.length - offset;
        }
        for (int i = offset; i < offset + num; ++i) {
            this.write(g, s[i], x, y + (i - offset) * this.getHeight(), anchor);
        }
    }

    public String[] wrap(String s, int width) {
        if (s == null) {
            return new String[0];
        }
        Vector<String> v = new Vector<String>();
        String line = "";
        int pos = 0;
        while (pos < s.length()) {
            int wordStart;
            while (this.getStringWidth(line) < width && pos < s.length()) {
                char c = s.charAt(pos);
                ++pos;
                if (c == '\n') {
                    v.addElement(line);
                    line = "";
                    continue;
                }
                line = line + c;
            }
            if (pos == s.length()) break;
            for (wordStart = line.length() - 1; wordStart >= 0 && line.charAt(wordStart) != ' ' && line.charAt(wordStart) != '\n' && line.charAt(wordStart) != '\r' && line.charAt(wordStart) != '\t'; --wordStart) {
            }
            if (wordStart > 0) {
                v.addElement(line.substring(0, wordStart));
                line = line.substring(wordStart).trim();
                continue;
            }
            v.addElement(line.substring(0, line.length() - 2) + '-');
            line = line.substring(line.length() - 2, line.length());
        }
        if (line.length() > 0) {
            v.addElement(line);
        }
        String[] w = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            w[i] = (String)v.elementAt(i);
        }
        return w;
    }

    public void write(Graphics g, String[] s, int x, int y, int anchor, int offset, int num, int halign, int w) {
        if (num == 0) {
            num = s.length - offset;
        }
        if ((0x20 & anchor) > 0) {
            y -= this.height * num;
        }
        if ((2 & anchor) > 0) {
            y -= this.height * num / 2;
        }
        if ((8 & anchor) == 8) {
            x -= w;
        }
        if ((1 & anchor) == 1) {
            x -= w / 2;
        }
        anchor = anchor & 0xD | 0x10;
        int i = offset;
        while (i < offset + num) {
            if (y > g.getClipY() + g.getClipHeight()) {
                return;
            }
            if (y + this.getHeight() > g.getClipY()) {
                int tx = Paintable.halign(w, halign, this.getStringWidth(s[i]));
                this.write(g, s[i], x + tx, y, 20);
            }
            ++i;
            y += this.getHeight();
        }
    }
}

