/*
 * Decompiled with CFR 0.152.
 */
package com.fazzidice;

import com.fazzidice.DispManager;
import com.fazzidice.MenuItem;
import com.fazzidice.Paintable;
import javax.microedition.lcdui.Graphics;

public class MIScrollable
extends MenuItem {
    Paintable unFocused;
    Paintable focused;
    private int preferredHeight;
    private int minHeight;
    private int yOffset;
    private boolean isUpPressed;
    private boolean isDownPressed;
    private static final int SCROLL_SPEED = 81920;
    Paintable scrollBarTop = Paintable.createInvisibleRect(0, 0);
    Paintable scrollBarBottom = Paintable.createInvisibleRect(0, 0);
    Paintable scrollBarMid = Paintable.createFromResMan(93);
    Paintable scrollSelector = Paintable.createFromResMan(103);
    private int px;
    private int py;

    public MIScrollable(String label) {
        super(4, label);
        this.isNavigable = true;
        this.isResizeable = true;
    }

    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }

    public void setHeight(int height) {
        this.height = height;
        this.yOffset = 0;
        if (this.focused != null) {
            MIScrollable.rescaleLook(this.width, height, this.focused);
        }
        if (this.unFocused != null) {
            MIScrollable.rescaleLook(this.width, height, this.unFocused);
        }
    }

    public void setUnFocused(Paintable img) {
        this.unFocused = img;
        this.width = Math.max(this.width, img.getWidth());
        this.height = Math.max(this.height, img.getHeight());
        this.img = img;
    }

    public void setFocused(Paintable img) {
        this.focused = img;
        this.width = Math.max(this.width, img.getWidth());
        this.height = Math.max(this.height, img.getHeight());
        if (this.preferredHeight == 0) {
            this.preferredHeight = img.getHeight();
        }
    }

    public void setFormated(Paintable scrollable) {
        this.formated = scrollable;
        this.yOffset = 0;
    }

    public int getMinimumHeight() {
        return this.minHeight;
    }

    public int getPreferredHeight() {
        return this.img.getWidth() + this.padV * 2;
    }

    public int getMaximumHeight() {
        return this.img.getWidth() + this.padV * 2;
    }

    public boolean keyPressed(int keyCode) {
        super.keyPressed(keyCode);
        if (DispManager.translateKey(keyCode) == 2) {
            if (this.yOffset == 0) {
                return false;
            }
            this.isUpPressed = true;
            return true;
        }
        if (DispManager.translateKey(keyCode) == 4) {
            if (this.img.getHeight() < this.getHeight() || this.yOffset >= this.formated.getHeight() - this.img.getHeight() + 2 * this.padV << 10) {
                return false;
            }
            this.isDownPressed = true;
            return true;
        }
        return false;
    }

    public boolean keyReleased(int keyCode) {
        super.keyReleased(keyCode);
        if (DispManager.translateKey(keyCode) == 4) {
            this.isDownPressed = false;
            return true;
        }
        if (DispManager.translateKey(keyCode) == 2) {
            this.isUpPressed = false;
            return true;
        }
        return false;
    }

    public void update(int time) {
        if (this.isUpPressed) {
            this.yOffset = Math.max(0, this.yOffset - time * 81920 / 1000);
        }
        if (this.isDownPressed) {
            this.yOffset = Math.min(this.formated.getHeight() - this.img.getHeight() + 2 * this.padV << 10, this.yOffset + time * 81920 / 1000);
        }
    }

    public void pointerMoved(int x, int y) {
        super.pointerMoved(x, y);
        this.yOffset = Math.max(0, Math.min(this.formated.getHeight() - this.img.getHeight() + 2 * this.padV << 10, this.yOffset + (this.py - y << 10)));
        this.px = x;
        this.py = y;
    }

    public void pointerEntered(int x, int y) {
        this.pointerPressed(x, y);
    }

    public void pointerPressed(int x, int y) {
        this.px = x;
        this.py = y;
    }

    public void paint(Graphics g) {
        if (this.img != null) {
            this.img.paint(g, this.parent.toPx(this.x), this.parent.toPx(this.y), 36);
        }
        if (this.formated != null) {
            DispManager.saveClip(g);
            g.setClip(0, this.parent.toPx(this.y - this.getHeight()) + this.padV, DispManager.getManager().getScreenWidth(), this.parent.toPx(this.getHeight()) - this.padV * 2);
            this.formated.paint(g, this.parent.toPx(this.x + this.getWidth() / 2) - this.padH, this.parent.toPx(this.y - this.getHeight()) - (this.yOffset >> 10) + this.padV, 17);
            DispManager.loadClip(g);
            if (this.formated.getHeight() > this.parent.toPx(this.getHeight()) - this.padV * 2) {
                MIScrollable.paintScroll(g, this.parent.toPx(this.x + this.getWidth()) - this.scrollBarTop.getWidth() * 3 / 2, this.parent.toPx(this.y - this.img.getHeight()) + this.padV, this.parent.toPx(this.getHeight()) - this.padV * 2, this.yOffset >> 10, this.formated.getHeight() - (this.parent.toPx(this.getHeight()) - this.padV * 2), this.scrollBarTop, this.scrollBarBottom, this.scrollBarMid, this.scrollSelector);
            }
        }
    }

    public void setIsSelected(boolean isSelected) {
        this.img = isSelected && this.focused != null ? this.focused : this.unFocused;
        super.setIsSelected(isSelected);
    }

    public MenuItem copy() {
        MIScrollable b = new MIScrollable(this.getLabel());
        this.copySizeParams(b);
        b.minHeight = this.minHeight;
        b.isNavigable = this.isNavigable;
        b.isResizeable = this.isResizeable;
        b.scrollBarBottom = this.scrollBarBottom;
        b.scrollBarMid = this.scrollBarMid;
        b.scrollBarTop = this.scrollBarTop;
        b.scrollSelector = this.scrollSelector;
        if (this.focused != null) {
            b.setFocused(this.focused.copy());
        }
        if (this.unFocused != null) {
            b.setUnFocused(this.unFocused.copy());
        }
        b.minHeight = this.minHeight;
        if (this.formated != null) {
            b.setFormated(this.formated.copy());
        }
        return b;
    }

    public static void paintScroll(Graphics g, int x, int y, int h, int a, int max, Paintable scrollBarTop, Paintable scrollBarBottom, Paintable scrollBarMid, Paintable scrollSelector) {
        int th = h - scrollBarTop.getHeight() - scrollBarBottom.getHeight();
        scrollBarTop.paint(g, x, y, 0x10 | 4);
        DispManager.saveClip(g);
        g.setClip(x, y + scrollBarTop.getHeight(), scrollBarMid.getWidth(), th);
        for (int i = 0; i < (th + scrollBarMid.getHeight() - 1) / scrollBarMid.getHeight(); ++i) {
            scrollBarMid.paint(g, x, y + scrollBarTop.getHeight() + i * scrollBarMid.getHeight(), 0x10 | 4);
        }
        DispManager.loadClip(g);
        scrollBarBottom.paint(g, x, y + th, 0x10 | 4);
        scrollSelector.paint(g, x + scrollBarTop.getWidth() / 2, y + scrollSelector.getHeight() / 2 + Math.min(h, (h - scrollSelector.getHeight()) * a / max), 1 | 2);
    }

    public void load() {
        super.load();
        if (this.img != null) {
            this.img.addToLoad();
        }
        if (this.formated != null) {
            this.formated.addToLoad();
        }
        if (this.scrollBarBottom != null) {
            this.scrollBarBottom.addToLoad();
        }
        if (this.scrollBarMid != null) {
            this.scrollBarMid.addToLoad();
        }
        if (this.scrollBarTop != null) {
            this.scrollBarTop.addToLoad();
        }
        if (this.scrollSelector != null) {
            this.scrollSelector.addToLoad();
        }
    }
}

