/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class InputColumnManager {
    private Image[] arrowImage;
    private Image[] headerArrowImage;
    private static final int arrowImageCount = 4;
    private String[] arrowImageName = new String[]{"/RedArrow.png", "/BlueArrow.png", "/GreenArrow.png", "/YellowArrow.png"};
    private String[] headArrowImageName = new String[]{"/RedArrow23.png", "/BlueArrow23.png", "/GreenArrow23.png", "/YellowArrow23.png"};
    private Sprite[] arrowSprite;
    int[] badNotes = new int[]{61, 56};
    int cBadTone = 0;
    int[] goodNotes = new int[]{72, 79, 76};
    int cnote = 0;
    private static final int TOT_TONES = 5;
    String[] toneFiles = new String[]{"/snake_best.mid", "/snake_good.mid", "snake_average.mid", "/snake_bad.mid", "/snake_worst.mid"};
    private Player[] gameTones;
    VolumeControl vControl;
    private InputColumn[] columns = new InputColumn[4];
    private int columnCount = 0;
    private MyCanvas parent;
    private LayerManager manager;
    private int arrowDelay = 0;
    private int score;
    private int totalArrowsCreated;
    private int maxArrowCount;
    private boolean stopSpawning;
    private Sprite[] headerArrows = new Sprite[4];
    private boolean[] headerArrowsActive = new boolean[4];
    private int spawnDelay;
    private int movementSpeed;
    private int count0;
    private int count1;
    private int count2;
    private int count3;
    private int count4;
    public boolean keypressf = false;
    private int maxCombo;
    private int curCombo;

    public InputColumnManager(MyCanvas parent) {
        this.parent = parent;
        this.manager = parent.getManager();
    }

    public void start() {
        try {
            this.totalArrowsCreated = 0;
            this.headerArrowImage = new Image[4];
            this.arrowImage = new Image[4];
            this.arrowSprite = new Sprite[4];
            int[] keys = new int[]{4, 64, 2, 32};
            for (int i = 0; i < this.columns.length; ++i) {
                this.headerArrowImage[i] = Image.createImage((String)this.headArrowImageName[i]);
                this.arrowImage[i] = Image.createImage((String)this.arrowImageName[i]);
                this.columns[i] = new InputColumn(this, i * 24 + 2, i, keys[i], i);
                this.arrowSprite[i] = new Sprite(this.arrowImage[i], 15, 15);
                this.arrowSprite[i].defineReferencePixel(this.arrowSprite[i].getWidth() / 2, this.arrowSprite[i].getHeight() / 2);
                this.arrowSprite[i].setPosition(i * 24 + 3, this.getHeaderY());
                this.headerArrows[i] = this.arrowSprite[i];
                this.getManager().insert((Layer)this.arrowSprite[i], 0);
            }
            this.restart();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }

    public void restart() {
        this.count0 = 0;
        this.count1 = 0;
        this.count2 = 0;
        this.count3 = 0;
        this.count4 = 0;
        this.maxCombo = 0;
        this.curCombo = 0;
        this.arrowDelay = 0;
        this.totalArrowsCreated = 0;
        this.stopSpawning = false;
        this.score = 0;
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i].restart();
            this.headerArrows[i].setFrame(0);
            this.headerArrowsActive[i] = false;
        }
    }

    public void restart1() {
        for (int i = 0; i < this.columns.length; ++i) {
            this.headerArrows[i].setFrame(0);
            this.headerArrowsActive[i] = false;
        }
    }

    public void tick() {
        boolean allowMultipleSpawns = false;
        boolean resetDelay = false;
        int spawnedThisRound = 0;
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.getCanvas().justPressed(this.columns[i].getActionKey()) && this.parent.gameState != 21) {
                this.columns[i].onKeyDown();
                this.headerArrows[i].setFrame(0);
            }
            if (this.headerArrowsActive[i]) {
                this.headerArrows[i].nextFrame();
                if (this.headerArrows[i].getFrame() == 3) {
                    this.headerArrows[i].setFrame(0);
                    this.headerArrowsActive[i] = false;
                }
            }
            if (!this.columns[i].tick()) continue;
            resetDelay = true;
            if (allowMultipleSpawns && ++spawnedThisRound <= 1) continue;
            this.arrowDelay = this.getSpawnDelay();
        }
        if (this.arrowDelay > 0) {
            --this.arrowDelay;
        }
        if (resetDelay) {
            this.arrowDelay = this.getSpawnDelay();
        }
    }

    public void paint(Graphics g) {
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i].paint(g);
        }
    }

    public void onCreateArrow() {
        ++this.totalArrowsCreated;
    }

    public void updateScoring(int delta, InputColumn column) {
        boolean keepComboCounting = false;
        if (delta < 4) {
            this.score += 10;
            if (this.parent.languageType == 0) {
                column.displayFeedback("\u5b8c\u7f8e", -16711936);
            } else if (this.parent.languageType == 1) {
                column.displayFeedback("\u5b8c\u7f8e", -16711936);
            } else {
                column.displayFeedback("Perfect!", -16711936);
            }
            ++this.count0;
            keepComboCounting = true;
        } else if (delta < 9) {
            this.score += 6;
            if (this.parent.languageType == 0) {
                column.displayFeedback("\u5049\u5927\u7684", -11154347);
            } else if (this.parent.languageType == 1) {
                column.displayFeedback("\u4f1f\u5927\u7684", -11154347);
            } else {
                column.displayFeedback("Great!", -11154347);
            }
            ++this.count1;
            keepComboCounting = true;
        } else if (delta < 14) {
            this.score += 4;
            if (this.parent.languageType == 0) {
                column.displayFeedback("\u5049\u5927\u7684", -256);
            } else if (this.parent.languageType == 1) {
                column.displayFeedback("\u826f\u597d\u7684", -256);
            } else {
                column.displayFeedback("Good", -256);
            }
            ++this.count2;
        } else if (delta < 20) {
            this.score += 2;
            if (this.parent.languageType == 0) {
                column.displayFeedback("\u5967\u51f1", -16776961);
            } else if (this.parent.languageType == 1) {
                column.displayFeedback("\u5965\u51ef", -16776961);
            } else {
                column.displayFeedback("Okay", -16776961);
            }
            ++this.count3;
        } else {
            this.score = this.score >= 5 ? (this.score -= 5) : (this.score += 0);
            if (this.parent.languageType == 0) {
                column.displayFeedback("\u932f\u904e", -65536);
            } else if (this.parent.languageType == 1) {
                column.displayFeedback("\u9519\u8fc7", -65536);
            } else {
                column.displayFeedback("Missed", -65536);
            }
            ++this.count4;
        }
        if (keepComboCounting) {
            ++this.curCombo;
        } else {
            if (this.curCombo > this.maxCombo) {
                this.maxCombo = this.curCombo;
            }
            this.curCombo = 0;
        }
    }

    public int getMaxCombo() {
        if (this.curCombo > this.maxCombo) {
            this.maxCombo = this.curCombo;
        }
        return this.maxCombo;
    }

    public int getCurCombo() {
        return this.curCombo;
    }

    public int getScore() {
        return this.score;
    }

    public int getPerfectScore() {
        return this.maxArrowCount * 10;
    }

    public int getPercentageScore() {
        return FP.Div(FP.intToFP(this.getScore()), FP.intToFP(this.getPerfectScore()));
    }

    public int arrowsAlive() {
        int arrowsAlive = 0;
        for (int i = 0; i < this.columns.length; ++i) {
            arrowsAlive += this.columns[i].arrowsAlive();
        }
        return arrowsAlive;
    }

    public void stopSpawning() {
        this.stopSpawning = true;
    }

    public boolean allowNewArrow() {
        return this.arrowDelay == 0 && !this.stopSpawning && !this.maxArrowsSpawned();
    }

    public boolean maxArrowsSpawned() {
        return this.maxArrowCount <= this.totalArrowsCreated;
    }

    public int totalArrowsSpawned() {
        return this.totalArrowsCreated;
    }

    public LayerManager getManager() {
        return this.manager;
    }

    public MyCanvas getCanvas() {
        return this.parent;
    }

    public Image getArrowImage(int i) {
        return this.headerArrowImage[i];
    }

    public int getHeaderY() {
        return 23;
    }

    public int getMovementSpeed() {
        return this.movementSpeed;
    }

    public int getSpawnDelay() {
        return this.spawnDelay;
    }

    public void setMovementSpeed(int speed) {
        this.movementSpeed = speed;
    }

    public void setSpawnDelay(int delay) {
        this.spawnDelay = delay;
    }

    public void setMaxArrowCount(int max) {
        this.maxArrowCount = max;
    }

    public int getScoreCount0() {
        return this.count0;
    }

    public int getScoreCount1() {
        return this.count1;
    }

    public int getScoreCount2() {
        return this.count2;
    }

    public int getScoreCount3() {
        return this.count3;
    }

    public int getScoreCount4() {
        return this.count4;
    }
}

