/*
 * Decompiled with CFR 0.152.
 */
public class FP {
    public static final int PI = 205887;
    public static final int PI_OVER_2 = 102943;
    public static final int E = 178145;
    public static final int HALF = 65536;
    static final int SK1 = 498;
    static final int SK2 = 10882;
    static final int CK1 = 2328;
    static final int CK2 = 32551;
    static final int TK1 = 13323;
    static final int TK2 = 20810;
    static final int AS1 = -1228;
    static final int AS2 = 4866;
    static final int AS3 = 13901;
    static final int AS4 = 102939;
    static int[] log2arr = new int[]{26573, 14624, 7719, 3973, 2017, 1016, 510, 256, 128, 64, 32, 16, 8, 4, 2, 1, 0, 0, 0};
    static int[] lnscale = new int[]{0, 45426, 90852, 136278, 181704, 227130, 272557, 317983, 363409, 408835, 454261, 499687, 545113, 590539, 635965, 681391, 726817};
    public static int xIntersect;
    public static int yIntersect;

    public static int toInt(int x) {
        return x >> 16;
    }

    public static int intToFP(int x) {
        return x << 16;
    }

    public static int Mul(int x, int y) {
        long z = (long)x * (long)y;
        return (int)(z >> 16);
    }

    public static int Div(int x, int y) {
        long z = (long)x << 32;
        return (int)(z / (long)y >> 16);
    }

    public static int Sqrt(int n) {
        int s = n + 65536 >> 1;
        for (int i = 0; i < 8; ++i) {
            s = s + FP.Div(n, s) >> 1;
        }
        return s;
    }

    public static int round(int n) {
        if (n > 0) {
            if ((n & 0x8000) != 0) {
                return n + 65536 >> 16 << 16;
            }
            return n >> 16 << 16;
        }
        int k = ((n = -n) & 0x8000) != 0 ? n + 65536 >> 16 << 16 : n >> 16 << 16;
        return -k;
    }

    public static int Sin(int f) {
        int sign = 1;
        if (f > 102943 && f <= 205887) {
            f = 205887 - f;
        } else if (f > 205887 && f <= 308830) {
            f -= 205887;
            sign = -1;
        } else if (f > 308830) {
            f = 411774 - f;
            sign = -1;
        }
        int sqr = FP.Mul(f, f);
        int result = 498;
        result = FP.Mul(result, sqr);
        result -= 10882;
        result = FP.Mul(result, sqr);
        result += 65536;
        result = FP.Mul(result, f);
        return sign * result;
    }

    public static int Cos(int f) {
        int sign = 1;
        if (f > 102943 && f <= 205887) {
            f = 205887 - f;
            sign = -1;
        } else if (f > 102943 && f <= 308830) {
            f -= 205887;
            sign = -1;
        } else if (f > 308830) {
            f = 411774 - f;
        }
        int sqr = FP.Mul(f, f);
        int result = 2328;
        result = FP.Mul(result, sqr);
        result -= 32551;
        result = FP.Mul(result, sqr);
        return (result += 65536) * sign;
    }

    public static int Tan(int f) {
        int sqr = FP.Mul(f, f);
        int result = 13323;
        result = FP.Mul(result, sqr);
        result += 20810;
        result = FP.Mul(result, sqr);
        result += 65536;
        result = FP.Mul(result, f);
        return result;
    }

    public static int ArcTan(int f) {
        int sqr = FP.Mul(f, f);
        int result = 1365;
        result = FP.Mul(result, sqr);
        result -= 5579;
        result = FP.Mul(result, sqr);
        result += 11805;
        result = FP.Mul(result, sqr);
        result -= 21646;
        result = FP.Mul(result, sqr);
        result += 65527;
        result = FP.Mul(result, f);
        return result;
    }

    public static int ArcSin(int f) {
        int fRoot = FP.Sqrt(65536 - f);
        int result = -1228;
        result = FP.Mul(result, f);
        result += 4866;
        result = FP.Mul(result, f);
        result -= 13901;
        result = FP.Mul(result, f);
        result += 102939;
        result = 102943 - FP.Mul(fRoot, result);
        return result;
    }

    public static int ArcCos(int f) {
        int fRoot = FP.Sqrt(65536 - f);
        int result = -1228;
        result = FP.Mul(result, f);
        result += 4866;
        result = FP.Mul(result, f);
        result -= 13901;
        result = FP.Mul(result, f);
        result += 102939;
        result = FP.Mul(fRoot, result);
        return result;
    }

    public static int Ln(int x) {
        int shift = 0;
        while (x > 131072) {
            ++shift;
            x >>= 1;
        }
        int g = 0;
        int d = 65536;
        for (int i = 1; i < 16; ++i) {
            if (x > 65536 + d) {
                x = FP.Div(x, 65536 + d);
                g += log2arr[i - 1];
            }
            d >>= 1;
        }
        return g + lnscale[shift];
    }

    public static boolean intersects(int ax0, int ay0, int ax1, int ay1, int bx0, int by0, int bx1, int by1) {
        int adx = (ax1 <<= 16) - (ax0 <<= 16);
        int ady = (ay1 <<= 16) - (ay0 <<= 16);
        int bdx = (bx1 <<= 16) - (bx0 <<= 16);
        int bdy = (by1 <<= 16) - (by0 <<= 16);
        int TWO = 131072;
        if (adx == 0 && bdx == 0) {
            int dist = Math.abs(FP.Div(ax0 + ax1 - (bx0 + bx1), TWO));
            return dist == 0;
        }
        if (adx == 0) {
            int xa = FP.Div(ax0 + ax1, TWO);
            int xmb = FP.Div(bdy, bdx);
            int xbb = by0 - FP.Mul(bx0, xmb);
            xIntersect = xa;
            yIntersect = FP.Mul(xmb, xIntersect) + xbb;
        } else if (bdx == 0) {
            int xb = FP.Div(bx0 + bx1, TWO);
            int xma = FP.Div(ady, adx);
            int xba = ay0 - FP.Mul(ax0, xma);
            xIntersect = xb;
            yIntersect = FP.Mul(xma, xIntersect) + xba;
        } else {
            int xma = FP.Div(ady, adx);
            int xba = ay0 - FP.Mul(ax0, xma);
            int xmb = FP.Div(bdy, bdx);
            int xbb = by0 - FP.Mul(bx0, xmb);
            if (xma == xmb) {
                int dist = Math.abs(FP.Mul(xba - xbb, FP.Cos(FP.ArcTan(FP.Div(xma + xmb, TWO)))));
                return dist < 65536;
            }
            if (xma - xmb == 0) {
                return false;
            }
            xIntersect = FP.Div(xbb - xba, xma - xmb);
            yIntersect = FP.Mul(xma, xIntersect) + xba;
        }
        int minxa = Math.min(ax0, ax1);
        int maxxa = Math.max(ax0, ax1);
        int minya = Math.min(ay0, ay1);
        int maxya = Math.max(ay0, ay1);
        int minxb = Math.min(bx0, bx1);
        int maxxb = Math.max(bx0, bx1);
        int minyb = Math.min(by0, by1);
        int maxyb = Math.max(by0, by1);
        return xIntersect >= minxa && xIntersect <= maxxa && yIntersect >= minya && yIntersect <= maxya && xIntersect >= minxb && xIntersect <= maxxb && yIntersect >= minyb && yIntersect <= maxyb;
    }
}

