/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.Sprite;

public class InputColumn {
    private int columnColor;
    private InputColumnManager parent;
    private int columnX;
    private int arrowRotation;
    private int actionKey;
    private Vector arrows = new Vector();
    private Clock feedbackClock = new Clock(0);
    private String feedbackText = new String();
    private int feedbackColor;
    private int messageCount = 0;

    public InputColumn(InputColumnManager parent, int columnX, int index, int key, int color) {
        this.parent = parent;
        this.columnX = columnX;
        this.actionKey = key;
        this.columnColor = color;
    }

    public void restart() {
        for (int i = 0; i < this.arrows.size(); ++i) {
            Arrow current = (Arrow)this.arrows.elementAt(i);
            this.getParent().getManager().remove((Layer)current.getSprite());
        }
        this.arrows.removeAllElements();
        this.feedbackClock.resetStatus();
    }

    public boolean tick() {
        boolean createdArrow = false;
        if (this.parent.allowNewArrow()) {
            this.parent.getCanvas();
            if (MyCanvas.rand(6) == 0) {
                Sprite arrowSprite = new Sprite(this.parent.getArrowImage(this.columnColor), 17, 20);
                arrowSprite.defineReferencePixel(arrowSprite.getWidth() / 2, arrowSprite.getHeight() / 2);
                arrowSprite.setPosition(this.columnX, this.parent.getCanvas().getHeight());
                this.parent.getManager().insert((Layer)arrowSprite, 0);
                this.arrows.addElement(new Arrow(arrowSprite, this));
                this.parent.onCreateArrow();
                createdArrow = true;
            }
        }
        for (int i = 0; i < this.arrows.size(); ++i) {
            Arrow current = (Arrow)this.arrows.elementAt(i);
            current.tick();
            if (current.getSprite().getY() + current.getSprite().getHeight() >= this.parent.getHeaderY()) continue;
            this.parent.updateScoring(500, this);
            this.getParent().getManager().remove((Layer)current.getSprite());
            this.arrows.removeElementAt(i);
        }
        this.feedbackClock.run();
        return createdArrow;
    }

    public int getActionKey() {
        return this.actionKey;
    }

    public void onKeyDown() {
        try {
            int count = 0;
            for (int i = 0; i < this.arrows.size(); ++i) {
                ++count;
                if (this.arrows.isEmpty()) continue;
                Arrow arrow = (Arrow)this.arrows.elementAt(i);
                int distance = Math.abs(arrow.getSprite().getY() - this.parent.getHeaderY());
                if (distance < 50) {
                    this.parent.updateScoring(distance, this);
                    arrow.activate();
                    if (distance < 4) {
                        arrow.perfectShot();
                    }
                }
                if (distance < 25) {
                    count = 10;
                }
                if (count != 10 && count != 2) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("  exception is " + e.getMessage());
        }
    }

    public void displayFeedback(String text, int color) {
        this.feedbackClock.reset(10);
        this.feedbackText = text;
        this.feedbackColor = color;
    }

    public void paint(Graphics g) {
        if (this.feedbackClock.getTimeLeft() != 0 && this.messageCount < 20) {
            g.setColor(this.feedbackColor);
            this.messageCount = this.messageCount < 20 ? ++this.messageCount : 0;
            if (this.feedbackColor == -65536) {
                g.drawString(this.feedbackText, this.columnX, this.parent.getHeaderY() - this.messageCount - 20, 0);
            } else {
                g.drawString(this.feedbackText, this.columnX, this.parent.getHeaderY() - 10 - this.messageCount, 0);
            }
        } else {
            this.messageCount = 0;
        }
    }

    public int arrowsAlive() {
        return this.arrows.size();
    }

    public InputColumnManager getParent() {
        return this.parent;
    }

    private class Arrow {
        private InputColumn parent;
        private Sprite sprite;
        private boolean activated;
        private boolean perfectShot;

        Arrow(Sprite sprite, InputColumn parent) {
            this.sprite = sprite;
            this.parent = parent;
            this.activated = false;
        }

        public void tick() {
            if (this.activated) {
                if (this.perfectShot) {
                    this.sprite.nextFrame();
                    if (this.sprite.getFrame() == 5) {
                        this.parent.getParent().getManager().remove((Layer)this.sprite);
                        this.parent.arrows.removeElement(this);
                        this.perfectShot = false;
                    }
                } else if (this.sprite.getFrame() == 0) {
                    this.parent.getParent().getManager().remove((Layer)this.sprite);
                    this.parent.arrows.removeElement(this);
                }
            } else {
                this.sprite.move(0, -this.parent.getParent().getMovementSpeed());
            }
        }

        public void activate() {
            this.activated = true;
        }

        public void perfectShot() {
            this.sprite.setFrame(0);
            this.perfectShot = true;
        }

        public Sprite getSprite() {
            return this.sprite;
        }
    }
}

