/*
 * Decompiled with CFR 0.152.
 */
package z.playw.DragonGuardian;

import javax.microedition.lcdui.Graphics;
import z.playw.DragonGuardian.CMath;
import z.playw.DragonGuardian.EnemyBase;
import z.playw.DragonGuardian.GameActor;
import z.playw.DragonGuardian.GameBullet;
import z.playw.DragonGuardian.GameCommands;
import z.playw.DragonGuardian.GameEngine;
import z.playw.DragonGuardian.MainCanvas;
import z.playw.DragonGuardian.Path;
import z.playw.DragonGuardian.Player;
import z.playw.j2me.graphics.ColRect;
import z.playw.j2me.graphics.PWPifLifeAnimations;

public class Enemy
extends EnemyBase {
    public void process(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (gameTime - this.stateStartTime > 6000L) {
            this.endNotify(gameTime, 6);
        }
        if (this.isStopProcessing()) {
            this.stateStartTime += MainCanvas.getGameEngine().getCurFrameTime();
            return;
        }
        switch (this.getSubType()) {
            case 42: {
                EnemyBase.uiBoss = this;
                this.processBossSword(gameTime, actorPool, gameEngine);
                break;
            }
            case 14: {
                this.processMagicAtt1(gameTime, actorPool, gameEngine);
                break;
            }
            case 16: {
                this.processMagicAttWhileRun1(gameTime, actorPool, gameEngine);
                break;
            }
            case 20: 
            case 21: {
                this.processNormalAttWhileRun(gameTime, actorPool, gameEngine);
                break;
            }
            case 17: {
                this.processMagicAttWhileRun2(gameTime, actorPool, gameEngine);
                break;
            }
            case 15: {
                this.processMagicAtt2(gameTime, actorPool, gameEngine);
                break;
            }
            case 31: {
                this.processFire(gameTime, actorPool, gameEngine);
                break;
            }
            case 24: {
                this.processCorbie(gameTime, actorPool, gameEngine);
                break;
            }
            case 25: {
                this.processDemon(gameTime, actorPool, gameEngine);
                break;
            }
            case 28: {
                this.processDemon2(gameTime, actorPool, gameEngine);
                break;
            }
            case 29: {
                this.processDemon3(gameTime, actorPool, gameEngine);
                break;
            }
            case 30: {
                this.processDemon4(gameTime, actorPool, gameEngine);
                break;
            }
            default: {
                this.processUnderling(gameTime, actorPool, gameEngine);
            }
        }
    }

    public void processCannibalPlant(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        switch (this.getState()) {
            case 15: {
                this.processRetreat(gameTime, gameEngine);
                break;
            }
            case 0: {
                this.setState((byte)1, gameTime);
                break;
            }
            case 4: {
                this.setState((byte)1, gameTime);
                break;
            }
            case 1: {
                this.processTrackCannibalPlant(gameTime, gameEngine);
                break;
            }
            case 18: {
                int spd;
                int n2 = spd = this.isBeatedBack ? 3 : 12;
                if (!this.moveToPos(this.getX(), this.BossHeadBackPosy, spd, gameTime, false)) break;
                this.setState((byte)1, gameTime);
                break;
            }
            case 2: {
                this.processCannibalPlantAtt(gameTime, gameEngine);
                break;
            }
            case 17: {
                if (this.getRelatePlayer() == null) break;
                if (this.getRelatePlayer().getType() == 0 && ((Player)this.getRelatePlayer()).isPlayerDead() || this.getRelatePlayer().getType() == 1 && ((Enemy)this.getRelatePlayer()).isDead()) {
                    if (this.getRelatePlayer().getType() == 1) {
                        this.getRelatePlayer().endNotify(gameTime, 7);
                    }
                    this.getRelatePlayer().setRelatePlayer(null);
                    this.setRelatePlayer(null);
                    gameEngine.setStopScrollBG(false);
                    break;
                }
                if (gameTime - this.stateStartTime > this.mWaitTime || this.getPowerNewton() <= 0) {
                    this.getRelatePlayer().endNotify(gameTime, 9);
                    this.getRelatePlayer().reduceLife(10, 11, null, gameTime);
                    this.getRelatePlayer().setRelatePlayer(null);
                    this.setRelatePlayer(null);
                    gameEngine.setStopScrollBG(false);
                    this.setState((byte)18, gameTime);
                    break;
                }
                this.getRelatePlayer().setX(this.getX());
                this.getRelatePlayer().setY(this.getY());
                if (gameTime % 100L >= 10L) break;
                this.getRelatePlayer().reduceLife(this.getAttdamage1(), 5, null, gameTime);
                break;
            }
            case 5: {
                if (!this.isAnimationOver(gameTime)) break;
                gameEngine.setStopScrollBG(false);
                if (this.getRelatePlayer() != null) {
                    if (this.getRelatePlayer().getType() == 0 && ((Player)this.getRelatePlayer()).isPlayerDead() || this.getRelatePlayer().getType() == 1 && !((Enemy)this.getRelatePlayer()).isAlive()) {
                        if (this.getRelatePlayer().getType() == 1) {
                            this.getRelatePlayer().endNotify(gameTime, 7);
                        }
                        this.getRelatePlayer().setRelatePlayer(null);
                        this.setRelatePlayer(null);
                        gameEngine.setStopScrollBG(false);
                    } else {
                        this.getRelatePlayer().endNotify(gameTime, 9);
                        this.getRelatePlayer().setRelatePlayer(null);
                        this.setRelatePlayer(null);
                    }
                }
                this.setInUse(false);
            }
        }
        this.followMapSpeedPlant(gameTime, gameEngine);
    }

    public void processCaneUp(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        switch (this.getState()) {
            case 4: {
                this.setState((byte)0, gameTime);
                break;
            }
            case 0: {
                if (this.isReachedGoal) {
                    this.setState((byte)2, gameTime);
                    break;
                }
                this.setState((byte)1, gameTime);
                break;
            }
            case 1: {
                if (this.moveToPos(this.getX(), this.EndY, this.speed, gameTime, false) && gameTime - this.stateStartTime > this.mWaitTime) {
                    this.isReachedGoal = true;
                    this.setState((byte)0, gameTime);
                }
                ColRect crself = this.getColRect(gameTime, 0);
                crself.h = 444;
                crself.y = -crself.h;
                break;
            }
            case 2: {
                ColRect cratt = this.getColRect2(gameTime, 3, 6);
                ColRect cratt2 = this.getColRect2(gameTime, 3, 7);
                int tmpw = cratt.w;
                cratt.w = cratt2.w << 1;
                int tmph = cratt.h;
                cratt.h = 444;
                int tmpy = cratt.y;
                cratt.y = -cratt.h;
                this.BossHeadPosx = this.getX();
                this.BossHeadPosy = this.getY() - cratt2.h;
                if (this.IsCollision2(gameTime, gameEngine.getPlayer(), 3, 0, 6)) {
                    gameEngine.getPlayer().reduceLife(this.getAttdamage1(), 5, null, gameTime);
                }
                ColRect crself2 = this.getColRect(gameTime, 0);
                crself2.h = 444;
                crself2.y = -crself2.h;
                cratt.w = tmpw;
                cratt.h = tmph;
                cratt.y = tmpy;
                break;
            }
            case 5: {
                if (!this.moveToPos(this.getX(), 36, this.speed, gameTime, false)) break;
                this.setInUse(false);
            }
        }
        this.followMapSpeed(gameTime, gameEngine);
    }

    private void followMapSpeed(long gameTime, GameEngine gameEngine) {
        ColRect crself3;
        if (!gameEngine.isStopScrollBG()) {
            this.x -= gameEngine.getXMapFrontOffsetSpeed();
        }
        if ((crself3 = this.getColRect(gameTime, 0)) != null) {
            if (this.getX() + crself3.w < 0) {
                this.setInUse(false);
            }
        } else if (this.getX() < 0) {
            this.setInUse(false);
        }
    }

    private void followMapSpeedPlant(long gameTime, GameEngine gameEngine) {
        ColRect crself3;
        if (!gameEngine.isStopScrollBG()) {
            this.x -= gameEngine.getXMapFrontOffsetSpeed();
        }
        if ((crself3 = this.getColRect(gameTime, 0)) != null) {
            if (this.getX() + crself3.w < 0) {
                if (this.getRelatePlayer() != null) {
                    if (this.getRelatePlayer().getType() == 0 && ((Player)this.getRelatePlayer()).isPlayerDead() || this.getRelatePlayer().getType() == 1 && !((Enemy)this.getRelatePlayer()).isAlive()) {
                        if (this.getRelatePlayer().getType() == 1) {
                            this.getRelatePlayer().endNotify(gameTime, 7);
                        }
                        this.getRelatePlayer().setRelatePlayer(null);
                        this.setRelatePlayer(null);
                    } else {
                        this.getRelatePlayer().endNotify(gameTime, 9);
                        this.getRelatePlayer().setRelatePlayer(null);
                        this.setRelatePlayer(null);
                    }
                }
                this.setInUse(false);
            }
        } else if (this.getX() < 0) {
            if (this.getRelatePlayer() != null) {
                if (this.getRelatePlayer().getType() == 0 && ((Player)this.getRelatePlayer()).isPlayerDead() || this.getRelatePlayer().getType() == 1 && !((Enemy)this.getRelatePlayer()).isAlive()) {
                    if (this.getRelatePlayer().getType() == 1) {
                        this.getRelatePlayer().endNotify(gameTime, 7);
                    }
                    this.getRelatePlayer().setRelatePlayer(null);
                    this.setRelatePlayer(null);
                } else {
                    this.getRelatePlayer().endNotify(gameTime, 9);
                    this.getRelatePlayer().setRelatePlayer(null);
                    this.setRelatePlayer(null);
                }
            }
            this.setInUse(false);
        }
    }

    public void processCaneButtom(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        switch (this.getState()) {
            case 4: {
                this.setState((byte)0, gameTime);
                break;
            }
            case 0: {
                if (this.isReachedGoal) {
                    this.setState((byte)2, gameTime);
                    break;
                }
                this.setState((byte)1, gameTime);
                break;
            }
            case 1: {
                if (this.moveToPos(this.getX(), this.EndY, this.speed, gameTime, false) && gameTime - this.stateStartTime > this.mWaitTime) {
                    this.isReachedGoal = true;
                    this.setState((byte)0, gameTime);
                }
                ColRect crself = this.getColRect(gameTime, 0);
                crself.h = 444;
                break;
            }
            case 2: {
                ColRect cratt = this.getColRect2(gameTime, 3, 6);
                ColRect cratt2 = this.getColRect2(gameTime, 3, 7);
                int tmpw = cratt.w;
                cratt.w = cratt2.w << 1;
                int tmph = cratt.h;
                cratt.h = 444;
                this.BossHeadPosx = this.getX();
                this.BossHeadPosy = this.getY() + cratt2.h;
                if (this.IsCollision2(gameTime, gameEngine.getPlayer(), 3, 0, 6)) {
                    gameEngine.getPlayer().reduceLife(this.getAttdamage1(), 5, null, gameTime);
                }
                ColRect crself2 = this.getColRect(gameTime, 0);
                crself2.h = 444;
                cratt.w = tmpw;
                cratt.h = tmph;
                break;
            }
            case 5: {
                if (!this.moveToPos(this.getX(), 480, this.speed, gameTime, false)) break;
                this.setInUse(false);
            }
        }
        this.followMapSpeed(gameTime, gameEngine);
    }

    public void processSpiderII(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        switch (this.getState()) {
            case 15: {
                if (!this.moveToPos(this.getX(), this.EndY, this.speed, gameTime, false)) break;
                this.setInUse(false);
                break;
            }
            case 4: {
                if (!this.moveToPos(this.getX(), this.EndY, this.speed, gameTime, false)) break;
                this.setState((byte)0, gameTime);
                break;
            }
            case 0: {
                if (this.isInSupperAtt) {
                    this.mStayStartTime = gameTime;
                }
                if (gameTime - this.mStayStartTime <= this.mWaitTime) break;
                this.selectAttackTypeSpiderII(gameTime);
                break;
            }
            case 1: {
                this.processSpiderIITrack(gameTime, gameEngine);
                break;
            }
            case 2: {
                if (this.isAnimationOver(gameTime)) {
                    this.setState((byte)0, gameTime);
                    break;
                }
                ColRect bulletRect = this.getColRect(gameTime, 1);
                if (bulletRect != null) {
                    if (!this.addBullet) break;
                    this.callOfOpenFire(gameTime, actorPool, gameEngine, this.getX() + bulletRect.x, this.getY() + bulletRect.y, 21, 1);
                    this.addBullet = false;
                    ++this.attCount;
                    this.attCount %= 3;
                    break;
                }
                this.addBullet = true;
                break;
            }
            case 16: {
                if (!this.isAnimationOver(gameTime)) break;
                this.setState((byte)0, gameTime);
                break;
            }
            case 17: {
                if (this.isAnimationOver(gameTime)) {
                    this.setState((byte)0, gameTime);
                    break;
                }
                this.openFire(gameTime, gameEngine);
                break;
            }
            case 5: {
                this.proDead(gameTime);
                break;
            }
            case 7: {
                if (!this.isAnimationOver(gameTime)) break;
                this.setInUse(false);
            }
        }
    }

    public void processSpider(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        if (this.getRelatePlayer() != null && (this.getRelatePlayer().getType() == 0 && ((Player)this.getRelatePlayer()).isPlayerDead() || this.getRelatePlayer().getType() == 1 && !((Enemy)this.getRelatePlayer()).isAlive())) {
            if (this.getRelatePlayer().getType() == 1) {
                this.getRelatePlayer().endNotify(gameTime, 7);
            }
            this.getRelatePlayer().setRelatePlayer(null);
            this.setRelatePlayer(null);
            return;
        }
        switch (this.getState()) {
            case 15: {
                if (!this.moveToPos(this.getX(), 0, this.speed, gameTime, false)) break;
                if (this.getRelatePlayer() != null) {
                    if (this.getRelatePlayer().getType() == 0 && ((Player)this.getRelatePlayer()).isPlayerDead() || this.getRelatePlayer().getType() == 1 && !((Enemy)this.getRelatePlayer()).isAlive()) {
                        if (this.getRelatePlayer().getType() == 1) {
                            this.getRelatePlayer().endNotify(gameTime, 7);
                        }
                        this.getRelatePlayer().setRelatePlayer(null);
                        this.setRelatePlayer(null);
                    } else {
                        this.getRelatePlayer().endNotify(gameTime, 7);
                        this.getRelatePlayer().setRelatePlayer(null);
                        this.setRelatePlayer(null);
                    }
                }
                this.setInUse(false);
                break;
            }
            case 0: {
                if (gameTime - this.stateStartTime <= this.mWaitTime) break;
                this.setX(CMath.getRandNumber(0, 360));
                this.setState((byte)1, gameTime);
                break;
            }
            case 4: {
                this.setState((byte)1, gameTime);
                break;
            }
            case 1: {
                this.processSpiderTrack(gameTime, gameEngine);
                break;
            }
            case 2: {
                this.processSpiderAtt(gameTime, gameEngine);
                break;
            }
            case 17: {
                if (!this.isAnimationOver(gameTime)) break;
                this.setAnimation(gameEngine.enemy05Pif);
                this.setState((byte)0, gameTime);
                break;
            }
            case 6: {
                this.processSuperAtt(gameTime, gameEngine);
            }
        }
    }

    private void proEndBossAtt(long gameTime) {
        if (this.isAnimationOver(gameTime)) {
            this.mToPosition = (byte)-1;
            this.setState((byte)0, gameTime);
        }
    }

    public void processBossSword(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        switch (this.getState()) {
            case 4: {
                if (this.moveToPos(this.EndX, this.EndY, this.speed, gameTime, false)) {
                    if (this.isDrawAlartOver(gameTime)) {
                        this.setState((byte)0, gameTime);
                        this.mStayStartTime = gameTime;
                    }
                    this.drawAlarm = true;
                }
                this.proInitAlarm(gameTime);
                break;
            }
            case 5: {
                if (gameTime - this.stateStartTime > 5000L) {
                    this.bossDead(gameTime);
                    break;
                }
                this.randomBossBoom(gameTime);
                break;
            }
            case 7: {
                if (!this.isAnimationOver(gameTime)) break;
                this.setInUse(false);
                break;
            }
            case 0: {
                this.processWait(gameTime, gameEngine);
                break;
            }
            case 16: {
                this.processUnderlingHurt(gameTime);
                break;
            }
            case 1: {
                this.processTrackBossSword(gameTime, gameEngine, this.mToPosition);
                break;
            }
            case 8: {
                ColRect bulletRect2 = this.getColRect(gameTime, 1);
                if (bulletRect2 != null) {
                    if (this.addBullet) {
                        this.callOfOpenFire(gameTime, actorPool, gameEngine, this.getX(), this.getY(), 31, 8);
                        this.addBullet = false;
                    }
                } else {
                    this.addBullet = true;
                }
                this.proEndBossAtt(gameTime);
                break;
            }
            case 9: {
                this.setX(this.getX() + this.getVx());
                this.setY(this.getY() + this.getVy());
                if (this.getX() > 360 || this.getX() < 0) {
                    ++this.attCount;
                    this.selectAttackType(gameTime);
                }
                if (this.getY() > 480 || this.getY() < 36) {
                    ++this.attCount;
                    this.selectAttackType(gameTime);
                }
                if (!this.isCollide(gameTime, gameEngine.getPlayer(), 0, 0)) break;
                gameEngine.getPlayer().reduceLife(this.getFarattdamage2(), 5, this.getIntersectRect(gameTime, gameEngine.getPlayer(), 0, 0), gameTime);
                break;
            }
            case 10: {
                if (!this.isAnimationOver(gameTime)) break;
                this.setX(gameEngine.getPlayer().getX() + 30);
                this.setY(gameEngine.getPlayer().getY() - CMath.getRandNumber(0, 30));
                this.setState((byte)13, gameTime);
                break;
            }
            case 13: {
                if (this.isAnimationOver(gameTime)) {
                    this.setX(0 + CMath.getRandNumber(0, 360));
                    this.setY(36 + CMath.getRandNumber(0, 444));
                    this.setState((byte)14, gameTime);
                }
                this.proBossNearAtt(gameTime, gameEngine);
                break;
            }
            case 14: {
                this.proEndBossAtt(gameTime);
            }
        }
    }

    private void proBossNearAtt(long gameTime, GameEngine gameEngine) {
        if (this.isCollide(gameTime, gameEngine.getPlayer(), 3, 0)) {
            gameEngine.getPlayer().reduceLife(this.getAttdamage1(), 5, this.getIntersectRect(gameTime, gameEngine.getPlayer(), 3, 0), gameTime);
        }
    }

    private void proBossGeneralAtt2(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (gameTime - this.stateStartTime > 5000L) {
            this.mToPosition = (byte)-1;
            this.setState((byte)0, gameTime);
        } else {
            ColRect bulletRect2 = this.getColRect(gameTime, 1);
            if (bulletRect2 != null) {
                if (this.addBullet) {
                    this.BossHeadBackPosx = CMath.getRandNumber(0, 70);
                    this.callOfOpenFire(gameTime, actorPool, gameEngine, this.getX() + bulletRect2.x + (bulletRect2.w >> 1), this.getY() + bulletRect2.y + (bulletRect2.h >> 1), 29, 1);
                    this.addBullet = false;
                }
            } else {
                this.addBullet = true;
            }
        }
    }

    public void processBossDracula(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        switch (this.getState()) {
            case 4: {
                if (this.moveToPos(this.EndX, this.EndY, this.speed, gameTime, false)) {
                    if (this.isDrawAlartOver(gameTime)) {
                        this.setState((byte)0, gameTime);
                        this.mStayStartTime = gameTime;
                    }
                    this.drawAlarm = true;
                }
                this.proInitAlarm(gameTime);
                break;
            }
            case 5: {
                if (gameTime - this.stateStartTime > 5000L) {
                    this.bossDead(gameTime);
                    break;
                }
                this.randomBossBoom(gameTime);
                break;
            }
            case 7: {
                if (!this.isAnimationOver(gameTime)) break;
                this.setInUse(false);
                break;
            }
            case 0: {
                this.processWait(gameTime, gameEngine);
                break;
            }
            case 16: {
                this.processUnderlingHurt(gameTime);
                break;
            }
            case 1: {
                this.processTrackBossDracula(gameTime, gameEngine, this.mToPosition);
                break;
            }
            case 8: {
                if (this.isCollide(gameTime, gameEngine.getPlayer(), 3, 0)) {
                    gameEngine.getPlayer().reduceLife(this.getAttdamage1(), 7, this.getIntersectRect(gameTime, gameEngine.getPlayer(), 3, 0), gameTime);
                }
                if (!this.isAnimationOver(gameTime)) break;
                this.mToPosition = (byte)-1;
                this.bossHurtTime = 0;
                this.setState((byte)0, gameTime);
                break;
            }
            case 9: {
                if (this.animID == 3) {
                    if (!this.isAnimationOver(gameTime)) break;
                    this.setRenderContent(8, true, gameTime);
                    break;
                }
                ColRect bulletRect = this.getColRect(gameTime, 1);
                if (bulletRect != null) {
                    this.lineLaserAtt(gameTime, gameEngine, bulletRect);
                    this.BossHeadGoalPosy = this.getY() + (bulletRect.y << 1);
                }
                this.proEndBossAtt(gameTime);
                break;
            }
            case 10: {
                if (gameTime - this.stateStartTime > 5000L) {
                    this.mToPosition = (byte)-1;
                    this.setState((byte)0, gameTime);
                    break;
                }
                this.proBossDraculaAtt3(gameTime, actorPool, gameEngine);
                break;
            }
            case 11: {
                if (!this.isAnimationOver(gameTime)) break;
                this.setState((byte)21, gameTime);
                break;
            }
            case 21: {
                if (this.isAnimationOver(gameTime)) {
                    this.setPowerNewton(50);
                    this.setState((byte)22, gameTime);
                }
                if (this.getRelatePlayer() == null) break;
                if (this.getRelatePlayer().getType() == 0 && ((Player)this.getRelatePlayer()).isPlayerDead()) {
                    this.getRelatePlayer().setRelatePlayer(null);
                    this.setRelatePlayer(null);
                    break;
                }
                this.getRelatePlayer().setX(this.getX());
                this.getRelatePlayer().setY(this.getY());
                break;
            }
            case 22: {
                if (this.animID == 10) {
                    if (gameTime - this.stateStartTime > 1500L) {
                        this.setRenderContent(9, true, gameTime);
                    } else if (this.getPowerNewton() <= 0) {
                        this.bossDraculaEndBloodAtt(gameTime);
                    }
                } else if (this.isAnimationOver(gameTime)) {
                    this.getRelatePlayer().reduceLife(this.getFarattdamage3(), 5, null, gameTime);
                    this.setLife(this.getFarattdamage3() + this.getLife());
                    if (this.getLife() >= this.getMaxlife()) {
                        this.setLife(this.getMaxlife());
                    }
                    this.bossDraculaEndBloodAtt(gameTime);
                }
                if (this.getRelatePlayer() == null || this.getRelatePlayer().getType() != 0 || !((Player)this.getRelatePlayer()).isPlayerDead()) break;
                this.getRelatePlayer().setRelatePlayer(null);
                this.setRelatePlayer(null);
                this.setState((byte)23, gameTime);
                break;
            }
            case 23: {
                this.proEndBossAtt(gameTime);
            }
        }
    }

    private void bossDraculaEndBloodAtt(long gameTime) {
        if (this.getRelatePlayer() != null) {
            if (this.getRelatePlayer().getType() == 0 && ((Player)this.getRelatePlayer()).isPlayerDead()) {
                this.setRelatePlayer(null);
                this.setState((byte)23, gameTime);
            } else {
                this.getRelatePlayer().endNotify(gameTime, 9);
                this.getRelatePlayer().setRelatePlayer(null);
                this.setRelatePlayer(null);
                this.setState((byte)23, gameTime);
            }
        } else {
            this.setState((byte)23, gameTime);
        }
    }

    private void proBossDraculaAtt3(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        ColRect bulletRect2 = this.getColRect(gameTime, 1);
        if (bulletRect2 != null) {
            if (this.addBullet) {
                this.BossHeadBackPosx = CMath.getRandNumber(0, 70);
                this.callOfOpenFire(gameTime, actorPool, gameEngine, this.getX() + bulletRect2.x + CMath.getRandNumber(0, bulletRect2.w), this.getY() + bulletRect2.y + CMath.getRandNumber(0, bulletRect2.h), 28, 1);
                this.addBullet = false;
            }
        } else {
            this.addBullet = true;
        }
    }

    public void processBossCyclops(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        switch (this.getState()) {
            case 4: {
                if (this.moveToPos(this.EndX, this.EndY, this.speed, gameTime, false)) {
                    if (this.isDrawAlartOver(gameTime)) {
                        this.setState((byte)0, gameTime);
                    } else {
                        this.drawAlarm = true;
                    }
                }
                this.proInitAlarm(gameTime);
                break;
            }
            case 5: {
                if (gameTime - this.stateStartTime > 5000L) {
                    this.bossDead(gameTime);
                    break;
                }
                this.randomBossBoom(gameTime);
                break;
            }
            case 7: {
                if (!this.isAnimationOver(gameTime)) break;
                this.setInUse(false);
                break;
            }
            case 0: {
                this.processWait(gameTime, gameEngine);
                break;
            }
            case 16: {
                this.processUnderlingHurt(gameTime);
                break;
            }
            case 1: {
                this.processTrackBossCyclops(gameTime, gameEngine, this.mToPosition);
                break;
            }
            case 8: {
                if (this.isCollide(gameTime, gameEngine.getPlayer(), 3, 0)) {
                    gameEngine.getPlayer().reduceLife(this.getAttdamage1(), 8, this.getIntersectRect(gameTime, gameEngine.getPlayer(), 3, 0), gameTime);
                }
                if (!this.isAnimationOver(gameTime)) break;
                this.mToPosition = (byte)-1;
                this.bossHurtTime = 0;
                this.setState((byte)0, gameTime);
                break;
            }
            case 9: {
                ColRect bulletRect = this.getColRect(gameTime, 1);
                if (bulletRect != null) {
                    this.BossHeadGoalPosx = this.getX() + bulletRect.x + (bulletRect.w >> 1) + 3;
                    this.BossHeadGoalPosy = CMath.F2I(CMath.tan(this.BossLaserAngel) * this.BossHeadGoalPosx);
                    if (Enemy.LineRectIntersect(this.getX() + bulletRect.x + (bulletRect.w >> 1), this.getY() + bulletRect.y + (bulletRect.h >> 1), -3, this.BossHeadGoalPosy, gameEngine.getPlayer(), gameEngine.getPlayer().getColRect(gameTime, 0))) {
                        gameEngine.getPlayer().reduceLife(this.getFarattdamage1(), 0, null, gameTime);
                    }
                    --this.BossLaserAngel;
                    if (this.BossLaserAngel <= 120) {
                        this.BossLaserAngel = 120;
                    }
                    this.BossLaserAngel += 360;
                    this.BossLaserAngel %= 360;
                }
                this.proEndBossAtt(gameTime);
                break;
            }
            case 10: {
                ColRect bulletRect2 = this.getColRect(gameTime, 1);
                if (bulletRect2 != null) {
                    if (this.addBullet) {
                        int lasernum = 5;
                        this.BossHeadBackPosx = CMath.getRandNumber(0, 70);
                        this.callOfOpenFire(gameTime, actorPool, gameEngine, this.getX() + bulletRect2.x, this.getY() + bulletRect2.y, 27, lasernum);
                        this.addBullet = false;
                    }
                } else {
                    this.addBullet = true;
                }
                this.proEndBossAtt(gameTime);
                break;
            }
            case 11: {
                if (this.isAnimationOver(gameTime)) {
                    this.mToPosition = (byte)-1;
                    this.setState((byte)0, gameTime);
                    break;
                }
                this.proBossCyclopsStoneAtt(gameTime, actorPool);
            }
        }
    }

    private void proBossCyclopsStoneAtt(long gameTime, GameActor[] actorPool) {
        ColRect bulletRect4 = this.getColRect(gameTime, 1);
        if (bulletRect4 != null) {
            if (this.addBullet) {
                for (int i2 = 0; i2 < actorPool.length; ++i2) {
                    if (actorPool[i2] != null && actorPool[i2].inUse()) continue;
                    if (actorPool[i2] == null) {
                        actorPool[i2] = new Enemy();
                    }
                    EnemyBase enemy = (EnemyBase)actorPool[i2];
                    enemy.setAnimation(MainCanvas.getGameEngine().stonePif);
                    enemy.setSubType(5);
                    enemy.init(gameTime, 1);
                    enemy.setState((byte)2, gameTime);
                    enemy.setRenderContent(0, true, gameTime);
                    enemy.setX(this.getX() + bulletRect4.x + (bulletRect4.w >> 2));
                    enemy.setY(this.getY() + bulletRect4.y + bulletRect4.h + (enemy.getAnimation().GetAniFrameHeight(0, 0) >> 1));
                    enemy.speed = 9;
                    enemy.setAttdamage1(this.getFarattdamage3());
                    this.setRockVxy(enemy);
                    break;
                }
                this.addBullet = false;
                ++this.attCount;
            }
        } else {
            this.addBullet = true;
        }
    }

    private void setRockVxy(EnemyBase enemy) {
        int vy;
        int vx;
        int xDiff = MainCanvas.getGameEngine().getPlayer().getX() - this.getX();
        int yDiff = MainCanvas.getGameEngine().getPlayer().getY() - this.getY();
        int absdifx = Math.abs(xDiff);
        int absdify = Math.abs(yDiff);
        if (absdify != 0 || absdifx != 0) {
            if (absdify > absdifx) {
                vx = enemy.speed * absdifx / absdify;
                vy = enemy.speed;
            } else if (absdify < absdifx) {
                vx = enemy.speed;
                vy = enemy.speed * absdify / absdifx;
            } else {
                vx = enemy.speed;
                vy = enemy.speed;
            }
        } else {
            vx = enemy.speed;
            vy = 0;
        }
        enemy.setVx(xDiff > 0 ? vx : -vx);
        enemy.setVy(yDiff > 0 ? vy : -vy);
    }

    public void processBossFireLord(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        switch (this.getState()) {
            case 4: {
                if (this.animID == 0 && this.isAnimationOver(gameTime)) {
                    this.setRenderContent(1, true, gameTime);
                    this.drawAlarm = true;
                    this.mStayStartTime = gameTime;
                } else if (this.animID == 1) {
                    int movx;
                    if (this.isDrawAlartOver(gameTime)) {
                        this.mToPosition = (byte)-1;
                        this.selectAttackTypeBossFireLord(gameTime);
                    }
                    if ((movx = CMath.F2I(CMath.cos((int)(gameTime - this.mStayStartTime) / this.alarmOfSpeed) << this.alarmOfNumber)) > 0) {
                        this.alarmOffset = movx;
                    } else {
                        this.alarmOfNumber = 2;
                        this.alarmOffset = 0;
                        this.alarmOfSpeed = 1;
                    }
                }
                if (this.drawAlarm) break;
                this.mStayStartTime = gameTime;
                break;
            }
            case 5: {
                if (gameTime - this.stateStartTime > 5000L) {
                    this.setState((byte)18, gameTime);
                    break;
                }
                this.randomBossBoom(gameTime);
                break;
            }
            case 18: {
                if (!this.isAnimationOver(gameTime)) break;
                this.bossDead(gameTime);
                break;
            }
            case 7: {
                if (!this.isAnimationOver(gameTime)) break;
                this.setInUse(false);
                break;
            }
            case 15: {
                this.processRetreat(gameTime, gameEngine);
                break;
            }
            case 0: {
                this.processWaitBossFireLord(gameTime, gameEngine);
                break;
            }
            case 16: {
                this.processUnderlingHurt(gameTime);
                break;
            }
            case 1: {
                this.processTrackBossFireLord(gameTime, gameEngine, this.mToPosition);
                break;
            }
            case 8: {
                if (this.animID == 7) {
                    ColRect bulletRect = this.getColRect(gameTime, 1);
                    if (bulletRect != null) {
                        if (this.addBullet) {
                            this.callOfOpenFire(gameTime, actorPool, gameEngine, this.getX() + bulletRect.x, this.getY() + bulletRect.y, 24, 5);
                            this.addBullet = false;
                        }
                    } else {
                        this.addBullet = true;
                    }
                    if (!this.isAnimationOver(gameTime)) break;
                    this.setRenderContent(1, true, gameTime);
                    this.mStayStartTime = gameTime;
                    break;
                }
                if (gameTime - this.mStayStartTime < 2000L) break;
                this.mToPosition = (byte)-1;
                this.selectAttackTypeBossFireLord(gameTime);
                break;
            }
            case 9: {
                if (this.isCollide(gameTime, gameEngine.getPlayer(), 3, 0)) {
                    gameEngine.getPlayer().reduceLife(this.getAttdamage1(), 8, this.getIntersectRect(gameTime, gameEngine.getPlayer(), 3, 0), gameTime);
                }
                if (!this.isAnimationOver(gameTime)) break;
                this.mToPosition = (byte)-1;
                this.bossHurtTime = 0;
                this.selectAttackTypeBossFireLord(gameTime);
                break;
            }
            case 10: {
                if (this.animID == 8) {
                    ColRect bulletRect2 = this.getColRect(gameTime, 1);
                    if (bulletRect2 != null) {
                        if (!this.addBullet) break;
                        this.BossHeadPosx = this.getX() + bulletRect2.x;
                        this.BossHeadPosy = this.getY() + bulletRect2.y;
                        this.BossHeadGoalPosx = 18;
                        this.BossHeadGoalPosy = this.BossHeadPosy;
                        this.BossHeadBackPosx = this.BossHeadPosx;
                        this.BossHeadBackPosy = this.BossHeadPosy;
                        this.isReachedGoal = false;
                        this.isBeatedBack = false;
                        this.setState((byte)13, gameTime);
                        this.addBullet = false;
                        break;
                    }
                    this.addBullet = true;
                    break;
                }
                if (this.getY() < this.getLastY() && this.animID != 2) {
                    this.setRenderContent(2, true, gameTime);
                } else if (this.getY() > this.getLastY() && this.animID != 3) {
                    this.setRenderContent(3, true, gameTime);
                }
                if (this.isReachedGoal) {
                    if (gameTime - this.mStayStartTime >= 2000L) {
                        this.setRenderContent(8, false, gameTime);
                        break;
                    }
                    this.setRenderContent(1, true, gameTime);
                    break;
                }
                if (!this.moveToArea(this.FarPositionX, gameEngine.getPlayer().getY(), this.speed, 0, 60, true, gameTime, true)) break;
                this.isReachedGoal = true;
                break;
            }
            case 13: {
                if (this.isReachedGoal) {
                    if (this.moveToArea2(this.BossHeadBackPosx, this.BossHeadBackPosy, this.speed, 0, 0)) {
                        this.setState((byte)14, gameTime);
                    }
                } else if (this.moveToArea2(this.BossHeadGoalPosx, this.BossHeadGoalPosy, this.speed, 0, 0)) {
                    this.isReachedGoal = true;
                }
                if (!this.IsCollision2(gameTime, gameEngine.getPlayer(), 0, 0, 11)) break;
                gameEngine.getPlayer().reduceLife(this.getFarattdamage3(), 7, this.getIntersectRect(gameTime, gameEngine.getPlayer(), 3, 0), gameTime);
                break;
            }
            case 14: {
                if (!this.isAnimationOver(gameTime)) break;
                this.mToPosition = (byte)-1;
                this.selectAttackTypeBossFireLord(gameTime);
            }
        }
    }

    private int getRockPosition(int posIndex, boolean useWidth, int totalLength) {
        PWPifLifeAnimations stoneAnim = MainCanvas.getGameEngine().stonePif;
        if (posIndex == 2) {
            return totalLength >> 1;
        }
        int remainLenght = 0;
        remainLenght = useWidth ? totalLength - stoneAnim.GetAniFrameWidth(0, 0) >> 1 : totalLength - stoneAnim.GetAniFrameHeight(0, 0) >> 1;
        return posIndex == 1 ? remainLenght >> 1 : totalLength - (remainLenght >> 1);
    }

    public void processFire(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        this.followMapSpeed(gameTime, gameEngine);
        switch (this.getState()) {
            case 4: {
                this.setState((byte)0, gameTime);
                break;
            }
            case 0: {
                if (!this.isCollide(gameTime, gameEngine.getPlayer(), 0, 0)) break;
                gameEngine.getPlayer().reduceLife(this.getAttdamage1(), 0, this.getIntersectRect(gameTime, gameEngine.getPlayer(), 0, 0), gameTime);
                this.setInUse(false);
            }
        }
        ColRect crself = this.getColRect(gameTime, 0);
        if (crself != null) {
            if (this.getX() + crself.x + crself.w < 0) {
                this.setInUse(false);
            }
        } else if (this.getX() < 0) {
            this.setInUse(false);
        }
    }

    public void processSkullWall(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        this.followMapSpeed(gameTime, gameEngine);
        switch (this.getState()) {
            case 4: {
                if (!this.isAnimationOver(gameTime)) break;
                this.setState((byte)0, gameTime);
                break;
            }
            case 0: {
                if (!this.isCollide(gameTime, gameEngine.getPlayer(), 0, 0)) break;
                gameEngine.getPlayer().reduceLife(this.getAttdamage1(), 0, this.getIntersectRect(gameTime, gameEngine.getPlayer(), 0, 0), gameTime);
                this.setState((byte)5, gameTime);
                break;
            }
            case 5: {
                if (!this.isAnimationOver(gameTime)) break;
                this.setInUse(false);
            }
        }
        ColRect crself = this.getColRect(gameTime, 0);
        if (crself != null) {
            if (this.getX() + crself.x + crself.w < 0) {
                this.setInUse(false);
            }
        } else if (this.getX() < 0) {
            this.setInUse(false);
        }
    }

    public void processRock(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        switch (this.getState()) {
            case 4: {
                if (this.getSubType() == 6 && GameCommands.commandInfo != null && GameCommands.commandInfo != this) {
                    boolean top = GameCommands.commandInfo.getY() == this.getAnimation().GetAniFrameHeight(this.animID, 0) >> 1;
                    int position = CMath.getRandNumber(1, 3);
                    if (top) {
                        while (this.getRockPosition(position, top, 360) == GameCommands.commandInfo.getX()) {
                            position = CMath.getRandNumber(1, 3);
                        }
                        this.setX(0 + this.getRockPosition(position, top, 360));
                        this.setY(36 + (this.getAnimation().GetAniFrameHeight(this.animID, 0) >> 1));
                    } else {
                        while (this.getRockPosition(position, top, 444) == GameCommands.commandInfo.getY()) {
                            position = CMath.getRandNumber(1, 3);
                        }
                        this.setX(360 - (this.getAnimation().GetAniFrameWidth(this.animID, 0) >> 1));
                        this.setY(36 + this.getRockPosition(position, top, 444));
                    }
                    GameCommands.commandInfo = null;
                } else {
                    boolean top = CMath.getRandNumber(0, 804) < 360;
                    int position = CMath.getRandNumber(1, 3);
                    if (top) {
                        this.setX(0 + this.getRockPosition(position, top, 360));
                        this.setY(36 + (this.getAnimation().GetAniFrameHeight(this.animID, 0) >> 1));
                    } else {
                        this.setX(360 - (this.getAnimation().GetAniFrameWidth(this.animID, 0) >> 1));
                        this.setY(36 + this.getRockPosition(position, top, 444));
                    }
                }
                this.setState((byte)0, gameTime);
                break;
            }
            case 0: {
                if (gameTime - this.stateStartTime <= 500L) break;
                if (this.getY() == 36 + (this.getAnimation().GetAniFrameHeight(this.animID, 0) >> 1)) {
                    this.setAnimation(MainCanvas.getGameEngine().stonePif);
                    this.setRenderContent(0, true, gameTime);
                    this.setY(this.getAnimation().GetAniFrameHeight(0, 0) >> 1);
                    this.setVx(0);
                    this.setVy(this.speed);
                } else {
                    this.setAnimation(MainCanvas.getGameEngine().stonePif);
                    this.setRenderContent(0, true, gameTime);
                    this.setX(360 + (this.getAnimation().GetAniFrameWidth(0, 0) >> 1));
                    this.setVx(-this.speed);
                    this.setVy(0);
                }
                this.setState((byte)2, gameTime);
                break;
            }
            case 2: {
                if (this.getX() < 0 || this.getY() > 480) {
                    this.setInUse(false);
                    break;
                }
                if (this.isCollide(gameTime, gameEngine.getPlayer(), 0, 0)) {
                    int collisionType = this.getVy() > 0 ? 8 : 7;
                    gameEngine.getPlayer().reduceLife(this.getAttdamage1(), collisionType, this.getIntersectRect(gameTime, gameEngine.getPlayer(), 0, 0), gameTime);
                    this.setState((byte)7, gameTime);
                    break;
                }
                this.setX(this.getX() + this.getVx());
                this.setY(this.getY() + this.getVy());
                break;
            }
            case 7: {
                if (this.isAnimationOver(gameTime)) {
                    this.setInUse(false);
                    break;
                }
                this.setX(this.getX() + this.getVx());
                this.setY(this.getY() + this.getVy());
            }
        }
    }

    public void processHitRunMagic(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        switch (this.getState()) {
            case 0: {
                if (!this.isInSupperAtt && this.isRetreat) {
                    this.setState((byte)15, gameTime);
                }
                this.reelUpDown(gameTime);
                break;
            }
            case 15: {
                this.processRetreat(gameTime, gameEngine);
                break;
            }
            case 16: {
                this.processUnderlingHurt(gameTime);
                break;
            }
            case 3: {
                this.reelUpDown(gameTime);
                this.openFire(gameTime, gameEngine);
                if (!this.isAnimationOver(gameTime)) break;
                this.setState((byte)0, gameTime);
                break;
            }
            case 4: {
                this.processInit(gameTime, gameEngine);
                break;
            }
            case 5: {
                this.proDead(gameTime);
                break;
            }
            case 7: {
                if (!this.isAnimationOver(gameTime)) break;
                this.setInUse(false);
                break;
            }
            case 6: {
                this.processSuperAtt(gameTime, gameEngine);
            }
        }
    }

    private void underAddSpirit(long gameTime, ColRect rect) {
        if (this.causeOfDeath == 0) {
            this.setState((byte)7, gameTime);
            this.setRenderContent(12, false, gameTime);
        } else {
            this.setState((byte)7, gameTime);
            this.setRenderContent(2, false, gameTime);
        }
        this.addBonus(gameTime, rect);
    }

    public void processMagicAtt1(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        switch (this.getState()) {
            case 0: {
                this.processWait(gameTime, gameEngine);
                break;
            }
            case 16: {
                this.processUnderlingHurt(gameTime);
                break;
            }
            case 15: {
                this.processRetreat(gameTime, gameEngine);
                break;
            }
            case 1: {
                this.processTrack(gameTime, gameEngine, this.mToPosition);
                break;
            }
            case 3: {
                this.processAttFar(gameTime, gameEngine);
                break;
            }
            case 4: {
                this.processInit(gameTime, gameEngine);
                break;
            }
            case 5: {
                this.proDead(gameTime);
                break;
            }
            case 7: {
                if (!this.isAnimationOver(gameTime)) break;
                this.setInUse(false);
                break;
            }
            case 6: {
                this.processSuperAtt(gameTime, gameEngine);
            }
        }
    }

    public void processMagicAtt2(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        switch (this.getState()) {
            case 0: {
                this.processWait(gameTime, gameEngine);
                break;
            }
            case 16: {
                this.processUnderlingHurt(gameTime);
                break;
            }
            case 15: {
                this.processRetreat(gameTime, gameEngine);
                break;
            }
            case 1: {
                this.processTrack(gameTime, gameEngine, this.mToPosition);
                break;
            }
            case 19: {
                if (this.isFarAtted) {
                    if (gameTime - this.mStayStartTime >= this.mFarAttStayTime) {
                        this.isFarAtted = false;
                        this.selectAttackType(gameTime);
                        break;
                    }
                    this.reelUpDown(gameTime);
                    break;
                }
                this.reelUpDown(gameTime);
                this.openFire(gameTime, gameEngine);
                if (!this.isAnimationOver(gameTime)) break;
                ++this.attackCount;
                this.isFarAtted = true;
                this.mStayStartTime = gameTime;
                this.setRenderContent(0, true, gameTime);
                break;
            }
            case 4: {
                this.processInit(gameTime, gameEngine);
                break;
            }
            case 5: {
                this.proDead(gameTime);
                break;
            }
            case 7: {
                if (!this.isAnimationOver(gameTime)) break;
                this.setInUse(false);
                break;
            }
            case 6: {
                this.processSuperAtt(gameTime, gameEngine);
            }
        }
    }

    public void processMagicAttWhileRun2(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        switch (this.getState()) {
            case 0: {
                this.processWait(gameTime, gameEngine);
                break;
            }
            case 16: {
                this.processUnderlingHurt(gameTime);
                break;
            }
            case 15: {
                this.processRetreat(gameTime, gameEngine);
                break;
            }
            case 1: {
                this.processTrack(gameTime, gameEngine, this.mToPosition);
                break;
            }
            case 2: {
                this.processAtt(gameTime, gameEngine);
                break;
            }
            case 3: {
                this.processAttFar(gameTime, gameEngine);
                break;
            }
            case 19: {
                if (this.isFarAtted) {
                    if (gameTime - this.mStayStartTime >= this.mFarAttStayTime) {
                        this.isFarAtted = false;
                        this.selectAttackType(gameTime);
                        break;
                    }
                    this.reelUpDown(gameTime);
                    break;
                }
                this.reelUpDown(gameTime);
                this.openFire(gameTime, gameEngine);
                if (!this.isAnimationOver(gameTime)) break;
                ++this.attackCount;
                this.isFarAtted = true;
                this.mStayStartTime = gameTime;
                this.setRenderContent(0, true, gameTime);
                break;
            }
            case 4: {
                this.processInitMagicAttWhileRun2(gameTime, gameEngine, actorPool);
                break;
            }
            case 5: {
                this.proDead(gameTime);
                break;
            }
            case 7: {
                if (!this.isAnimationOver(gameTime)) break;
                this.setInUse(false);
                break;
            }
            case 6: {
                this.processSuperAtt(gameTime, gameEngine);
                break;
            }
        }
    }

    public void processMagicAttWhileRun1(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        switch (this.getState()) {
            case 0: {
                this.processWait(gameTime, gameEngine);
                break;
            }
            case 16: {
                this.processUnderlingHurt(gameTime);
                break;
            }
            case 15: {
                this.processRetreat(gameTime, gameEngine);
                break;
            }
            case 1: {
                this.processTrack(gameTime, gameEngine, this.mToPosition);
                break;
            }
            case 2: {
                this.processAtt(gameTime, gameEngine);
                break;
            }
            case 3: {
                this.processAttFar(gameTime, gameEngine);
                break;
            }
            case 19: {
                if (this.isFarAtted) {
                    if (gameTime - this.mStayStartTime >= this.mFarAttStayTime) {
                        this.isFarAtted = false;
                        this.selectAttackType(gameTime);
                        break;
                    }
                    this.reelUpDown(gameTime);
                    break;
                }
                this.reelUpDown(gameTime);
                this.openFire(gameTime, gameEngine);
                if (!this.isAnimationOver(gameTime)) break;
                ++this.attackCount;
                this.isFarAtted = true;
                this.mStayStartTime = gameTime;
                this.setRenderContent(0, true, gameTime);
                break;
            }
            case 4: {
                this.processInitMagicAttWhileRun1(gameTime, gameEngine, actorPool);
                break;
            }
            case 5: {
                this.proDead(gameTime);
                break;
            }
            case 7: {
                if (!this.isAnimationOver(gameTime)) break;
                this.setInUse(false);
                break;
            }
            case 6: {
                this.processSuperAtt(gameTime, gameEngine);
                break;
            }
        }
    }

    public void processNormalAttWhileRun(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        switch (this.getState()) {
            case 0: {
                this.processWait(gameTime, gameEngine);
                break;
            }
            case 16: {
                this.processUnderlingHurt(gameTime);
                break;
            }
            case 15: {
                this.processRetreat(gameTime, gameEngine);
                break;
            }
            case 1: {
                this.processTrack(gameTime, gameEngine, this.mToPosition);
                break;
            }
            case 2: {
                this.processAtt(gameTime, gameEngine);
                break;
            }
            case 3: {
                this.processAttFar(gameTime, gameEngine);
                break;
            }
            case 19: {
                if (this.isFarAtted) {
                    if (gameTime - this.mStayStartTime >= this.mFarAttStayTime) {
                        this.isFarAtted = false;
                        this.selectAttackType(gameTime);
                        break;
                    }
                    this.reelUpDown(gameTime);
                    break;
                }
                this.reelUpDown(gameTime);
                this.openFire(gameTime, gameEngine);
                if (!this.isAnimationOver(gameTime)) break;
                ++this.attackCount;
                this.isFarAtted = true;
                this.mStayStartTime = gameTime;
                this.setRenderContent(0, true, gameTime);
                break;
            }
            case 4: {
                this.processInitNormalAttWhileRun(gameTime, gameEngine, actorPool);
                break;
            }
            case 5: {
                this.proDead(gameTime);
                break;
            }
            case 7: {
                if (!this.isAnimationOver(gameTime)) break;
                this.setInUse(false);
                break;
            }
            case 6: {
                this.processSuperAtt(gameTime, gameEngine);
                break;
            }
        }
    }

    public void processFishermanSprint(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        switch (this.getState()) {
            case 2: {
                this.setX(this.getX() + this.getVx());
                this.setY(this.getY() + this.getVy());
                if (this.getX() < 0) {
                    this.setInUse(false);
                }
                if (this.getY() > 480 || this.getY() < 36) {
                    this.setInUse(false);
                }
                if (this.isFarAtted || !this.isCollide(gameTime, gameEngine.getPlayer(), 3, 0)) break;
                gameEngine.getPlayer().reduceLife(this.getAttdamage1(), 5, this.getIntersectRect(gameTime, gameEngine.getPlayer(), 3, 0), gameTime);
                this.isFarAtted = true;
                break;
            }
            default: {
                this.processNormalAttWhileRun(gameTime, actorPool, gameEngine);
            }
        }
    }

    public void processEye2(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        switch (this.getState()) {
            case 3: {
                if (this.isFarAtted) {
                    if (gameTime - this.mStayStartTime >= this.mFarAttStayTime) {
                        this.isFarAtted = false;
                        this.selectAttackType(gameTime);
                        break;
                    }
                    this.reelUpDown(gameTime);
                    break;
                }
                if (this.animID == 0) {
                    if (!this.moveToArea(this.getX(), gameEngine.getPlayer().getY(), this.speed, 0, 60, true, gameTime, true)) break;
                    this.setRenderContent(4, false, gameTime);
                    break;
                }
                if (this.isAnimationOver(gameTime)) {
                    ++this.attackCount;
                    this.isFarAtted = true;
                    this.mStayStartTime = gameTime;
                    this.setRenderContent(0, true, gameTime);
                    ++this.attackCount;
                    break;
                }
                this.moveToArea(this.getX(), gameEngine.getPlayer().getY(), this.speed, 0, 60, true, gameTime, true);
                ColRect bulletRect = this.getColRect(gameTime, 1);
                if (bulletRect == null) break;
                this.BossHeadGoalPosy = this.getY() + bulletRect.y + (bulletRect.h >> 1);
                this.lineLaserAtt(gameTime, gameEngine, bulletRect);
                break;
            }
            case 4: {
                this.processInitEyeAttWhileRun(gameTime, gameEngine, actorPool);
                break;
            }
            default: {
                this.processNormalAttWhileRun(gameTime, actorPool, gameEngine);
            }
        }
    }

    public void processDemon3(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        switch (this.getState()) {
            case 2: {
                this.reelUpDown(gameTime);
                break;
            }
            case 4: {
                this.processInitDemon(gameTime, gameEngine, actorPool);
                break;
            }
            default: {
                this.processMagicAttWhileRun1(gameTime, actorPool, gameEngine);
            }
        }
    }

    public void processDemon4(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        switch (this.getState()) {
            case 3: 
            case 19: {
                if (this.isFarAtted) {
                    if (gameTime - this.mStayStartTime >= this.mFarAttStayTime) {
                        this.isFarAtted = false;
                        this.selectAttackType(gameTime);
                        break;
                    }
                    this.reelUpDown(gameTime);
                    break;
                }
                ColRect bulletRect = this.getColRect(gameTime, 1);
                if (bulletRect != null) {
                    if (this.addBullet) {
                        this.callOfOpenFire(gameTime, actorPool, gameEngine, this.getX() + bulletRect.x, this.getY() + bulletRect.y, 26, 12);
                        this.addBullet = false;
                    }
                } else {
                    this.addBullet = true;
                }
                if (!this.isAnimationOver(gameTime)) break;
                ++this.attackCount;
                this.isFarAtted = true;
                this.mStayStartTime = gameTime;
                this.setRenderContent(0, true, gameTime);
                break;
            }
            case 4: {
                this.processInitDemon(gameTime, gameEngine, actorPool);
                break;
            }
            default: {
                this.processMagicAttWhileRun1(gameTime, actorPool, gameEngine);
            }
        }
    }

    public void processDemon2(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        switch (this.getState()) {
            case 2: {
                ColRect bombRect = this.getColRect(gameTime, 4);
                if (bombRect != null) {
                    int movy;
                    int movx;
                    ColRect otherRc = gameEngine.getPlayer().getColRect(gameTime, 0);
                    if (otherRc != null) {
                        movx = gameEngine.getPlayer().getX() + otherRc.x + otherRc.w;
                        movy = gameEngine.getPlayer().getY() + otherRc.y + (otherRc.h >> 1);
                    } else {
                        movx = gameEngine.getPlayer().getX() + 30;
                        movy = gameEngine.getPlayer().getY();
                    }
                    this.moveToArea(movx, movy, this.speed, 3 * (bombRect.w >> 2), bombRect.h, false, gameTime, false);
                } else {
                    int movx = gameEngine.getPlayer().getX() + 30;
                    this.moveToArea(movx, gameEngine.getPlayer().getY(), this.speed, 10, 30, false, gameTime, false);
                }
                if (this.isCollide(gameTime, gameEngine.getPlayer(), 4, 0)) {
                    if (!this.isFarAtted) {
                        this.isFarAtted = true;
                        this.mStayStartTime = gameTime;
                    }
                } else if (!this.isFarAtted) {
                    this.mStayStartTime = gameTime;
                }
                if (gameTime - this.mStayStartTime < 3000L) break;
                if (this.isCollide(gameTime, gameEngine.getPlayer(), 4, 0)) {
                    gameEngine.getPlayer().reduceLife(this.getAttdamage1(), 7, this.getIntersectRect(gameTime, gameEngine.getPlayer(), 0, 0), gameTime);
                }
                this.setState((byte)5, gameTime);
                this.isDeadSelf = true;
                break;
            }
            case 4: {
                this.processInitDemon(gameTime, gameEngine, actorPool);
                break;
            }
            default: {
                this.processMagicAttWhileRun1(gameTime, actorPool, gameEngine);
            }
        }
    }

    public void processDemon(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        switch (this.getState()) {
            case 2: {
                this.setX(this.getX() + this.getVx());
                this.setY(this.getY() + this.getVy());
                if (this.getX() > 360 || this.getX() < 0) {
                    this.setInUse(false);
                }
                if (this.getY() > 480 || this.getY() < 36) {
                    this.setInUse(false);
                }
                if (!this.isCollide(gameTime, gameEngine.getPlayer(), 0, 0)) break;
                gameEngine.getPlayer().reduceLife(this.getAttdamage1(), 7, this.getIntersectRect(gameTime, gameEngine.getPlayer(), 0, 0), gameTime);
                this.setState((byte)5, gameTime);
                this.isDeadSelf = true;
                break;
            }
            case 4: {
                this.processInitDemon(gameTime, gameEngine, actorPool);
                break;
            }
            default: {
                this.processMagicAttWhileRun1(gameTime, actorPool, gameEngine);
            }
        }
    }

    public void processCorbie(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        switch (this.getState()) {
            case 2: {
                this.setX(this.getX() + this.getVx());
                this.setY(this.getY() + this.getVy());
                if (this.getX() > 360 || this.getX() < 0) {
                    this.setInUse(false);
                }
                if (this.getY() > 480 || this.getY() < 36) {
                    this.setInUse(false);
                }
                if (!this.isCollide(gameTime, gameEngine.getPlayer(), 0, 0)) break;
                gameEngine.getPlayer().reduceLife(this.getAttdamage1(), 7, this.getIntersectRect(gameTime, gameEngine.getPlayer(), 0, 0), gameTime);
                this.setState((byte)5, gameTime);
                this.isDeadSelf = true;
                break;
            }
            default: {
                this.processMagicAttWhileRun1(gameTime, actorPool, gameEngine);
            }
        }
    }

    public void processGriffin(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        this.processNormalAttWhileRun(gameTime, actorPool, gameEngine);
    }

    public void processSummoner(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        switch (this.getState()) {
            case 0: {
                this.processWait(gameTime, gameEngine);
                break;
            }
            case 16: {
                this.processUnderlingHurt(gameTime);
                break;
            }
            case 15: {
                this.processRetreat(gameTime, gameEngine);
                break;
            }
            case 1: {
                this.processTrack(gameTime, gameEngine, this.mToPosition);
                break;
            }
            case 20: {
                this.processSummon(gameTime, gameEngine, actorPool);
                break;
            }
            case 2: {
                this.processAtt(gameTime, gameEngine);
                break;
            }
            case 3: {
                this.processAttFar(gameTime, gameEngine);
                break;
            }
            case 19: {
                if (this.isFarAtted) {
                    if (gameTime - this.mStayStartTime >= this.mFarAttStayTime) {
                        this.isFarAtted = false;
                        this.selectAttackType(gameTime);
                        break;
                    }
                    this.reelUpDown(gameTime);
                    break;
                }
                this.reelUpDown(gameTime);
                this.openFire(gameTime, gameEngine);
                if (!this.isAnimationOver(gameTime)) break;
                ++this.attackCount;
                this.isFarAtted = true;
                this.mStayStartTime = gameTime;
                this.setRenderContent(0, true, gameTime);
                break;
            }
            case 4: {
                this.processInit(gameTime, gameEngine);
                break;
            }
            case 5: {
                this.proDead(gameTime);
                break;
            }
            case 7: {
                if (!this.isAnimationOver(gameTime)) break;
                this.setInUse(false);
                break;
            }
            case 6: {
                this.processSuperAtt(gameTime, gameEngine);
                break;
            }
        }
    }

    public void processUnderling(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        switch (this.getState()) {
            case 0: {
                this.processWait(gameTime, gameEngine);
                break;
            }
            case 16: {
                this.processUnderlingHurt(gameTime);
                break;
            }
            case 15: {
                this.processRetreat(gameTime, gameEngine);
                break;
            }
            case 1: {
                this.processTrack(gameTime, gameEngine, this.mToPosition);
                break;
            }
            case 2: {
                this.processAtt(gameTime, gameEngine);
                break;
            }
            case 3: {
                this.processAttFar(gameTime, gameEngine);
                break;
            }
            case 19: {
                if (this.isFarAtted) {
                    if (gameTime - this.mStayStartTime >= this.mFarAttStayTime) {
                        this.isFarAtted = false;
                        this.selectAttackType(gameTime);
                        break;
                    }
                    this.reelUpDown(gameTime);
                    break;
                }
                this.reelUpDown(gameTime);
                this.openFire(gameTime, gameEngine);
                if (!this.isAnimationOver(gameTime)) break;
                ++this.attackCount;
                this.isFarAtted = true;
                this.mStayStartTime = gameTime;
                this.setRenderContent(0, true, gameTime);
                break;
            }
            case 4: {
                this.processInit(gameTime, gameEngine);
                break;
            }
            case 5: {
                this.proDead(gameTime);
                break;
            }
            case 7: {
                if (!this.isAnimationOver(gameTime)) break;
                this.setInUse(false);
                break;
            }
            case 6: {
                this.processSuperAtt(gameTime, gameEngine);
                break;
            }
        }
    }

    private void proDead(long gameTime) {
        if (this.isAnimationOver(gameTime)) {
            ColRect rect = this.getColRect(gameTime, 0);
            this.addBonus(gameTime, rect);
            this.setInUse(false);
            if (!this.isDeadSelf) {
                MainCanvas.getGameEngine().getPlayer().increaseKilledEnemy(this.getBombsoul());
            }
        }
    }

    private void processUnderlingHurt(long gameTime) {
        int movx = CMath.cos((int)((gameTime - this.mStayStartTime) / 2L)) << this.BeatBackSpeed;
        if (movx >= 0 && !this.isInSupperAtt) {
            this.x += movx;
            ColRect crself = this.getColRect(gameTime, 0);
            if (this.getX() + (crself.w >> 1) >= 360) {
                this.setX(360 - (crself.w >> 1));
            }
            this.moveToPos(this.getX(), this.BeatBackY, this.speed, gameTime, true);
        } else if (this.isAnimationOver(gameTime)) {
            this.mStayStartTime = gameTime;
            this.setState((byte)0, gameTime);
        }
    }

    public void beginNotify(long gameTime, int type) {
        if (this.getState() == 5 || this.getState() == 7) {
            return;
        }
        this.superAttType = type;
        this.isInSupperAtt = true;
        this.setSuperAttEff(gameTime, type);
        if (type != 5 && type != 6 && this.getSubType() != 5 && this.getSubType() != 6) {
            this.setState((byte)0, gameTime);
        }
    }

    private void setSuperAttEff(long gameTime, int type) {
    }

    public void endNotify(long gameTime, int type) {
        this.superAttType = -1;
        switch (type) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                this.isAddCycleBullet = false;
                this.reduceLife(MainCanvas.getGameEngine().getPlayer().getSuperAttackDamage(), 9, null, gameTime);
            }
        }
        this.isInSupperAtt = false;
        this.setBeenAttacked(true);
    }

    private void openFire(long gameTime, GameEngine gameEngine) {
        ColRect bulletRect = this.getColRect(gameTime, 1);
        if (bulletRect != null) {
            if (this.addBullet) {
                GameActor[] bulletPool = GameEngine.getBulletPool();
                for (int i2 = 0; i2 < bulletPool.length; ++i2) {
                    if (bulletPool[i2] != null && bulletPool[i2].inUse()) continue;
                    if (bulletPool[i2] == null) {
                        bulletPool[i2] = new GameBullet();
                    }
                    switch (this.getSubType()) {
                        case 0: 
                        case 13: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 27: {
                            if (this.lineatt) {
                                bulletPool[i2].setAnimation(gameEngine.enemy03BulletPif);
                                bulletPool[i2].init(gameTime, 1);
                                ((GameBullet)bulletPool[i2]).mDamage = this.getFarattdamage1();
                                break;
                            }
                            this.callOfOpenFire(gameTime, bulletPool, gameEngine, this.getX() + bulletRect.x, this.getY() + bulletRect.y, 20, 4);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 16: 
                        case 17: 
                        case 24: {
                            if (this.getState() == 3) {
                                this.lineFire(gameEngine.enemy02BulletPif, gameTime, gameEngine, bulletPool[i2], 4, 14);
                                break;
                            }
                            if (this.getState() != 19) break;
                            this.callTailBullet(gameEngine.enemyTailBulletPif, gameTime, gameEngine, bulletPool[i2]);
                            break;
                        }
                        case 14: {
                            this.lineFire(gameEngine.enemy02BulletPif, gameTime, gameEngine, bulletPool[i2], 4, 14);
                            break;
                        }
                        case 15: {
                            this.callTailBullet(gameEngine.enemyTailBulletPif, gameTime, gameEngine, bulletPool[i2]);
                            break;
                        }
                        case 8: {
                            this.lineFire(gameEngine.enemy02BulletPif, gameTime, gameEngine, bulletPool[i2], 4, 14);
                        }
                    }
                    bulletPool[i2].setX(this.getX() + bulletRect.x + (bulletRect.w >> 1));
                    bulletPool[i2].setY(this.getY() + bulletRect.y + (bulletRect.h >> 1));
                    break;
                }
                this.addBullet = false;
                ++this.attCount;
            }
        } else {
            this.addBullet = true;
        }
    }

    private void processInit(long gameTime, GameEngine gameEngine) {
        this.changeFrontage(gameTime);
        int wayPointIndex = this.EndX;
        if (this.moveToPos(Path.getWayPoints()[wayPointIndex][this.wayPointsStep][0] * 360 / 100, 36 + Path.getWayPoints()[wayPointIndex][this.wayPointsStep][1] * 444 / 100, this.speed, gameTime, false)) {
            this.wayPointsStep = (short)(this.wayPointsStep + 1);
            if (this.wayPointsStep >= Path.getWayPoints()[wayPointIndex].length) {
                this.setMPosition((byte)0);
                if (this.getSubType() == 14) {
                    this.setState((byte)3, gameTime);
                } else if (this.getSubType() == 15) {
                    this.setState((byte)19, gameTime);
                } else if (this.getSubType() == 18 || this.getSubType() == 19 || this.getSubType() == 8) {
                    this.setState((byte)3, gameTime);
                } else {
                    this.selectAttackType(gameTime);
                }
            }
        }
    }

    private void processInitEyeAttWhileRun(long gameTime, GameEngine gameEngine, GameActor[] actorPool) {
        if (this.animID != 4) {
            this.changeFrontage(gameTime);
        }
        int wayPointIndex = this.EndX;
        if (this.moveToPos(Path.getWayPoints()[wayPointIndex][this.wayPointsStep][0] * 360 / 100, 36 + Path.getWayPoints()[wayPointIndex][this.wayPointsStep][1] * 444 / 100, this.speed, gameTime, false)) {
            if (Path.getWayPoints()[wayPointIndex][this.wayPointsStep].length == 3 && Path.getWayPoints()[wayPointIndex][this.wayPointsStep][2] == 1) {
                this.attCount = 0;
                this.setRenderContent(4, false, gameTime);
            }
            this.wayPointsStep = (short)(this.wayPointsStep + 1);
            if (this.wayPointsStep >= Path.getWayPoints()[wayPointIndex].length) {
                if (this.getSubType() == 41) {
                    this.mStayStartTime = gameTime;
                    this.setState((byte)3, gameTime);
                } else {
                    this.setMPosition((byte)0);
                    this.selectAttackType(gameTime);
                }
            }
        }
        if (this.animID == 4) {
            if (this.isAnimationOver(gameTime)) {
                this.attCount = 0;
                this.setRenderContent(0, true, gameTime);
            } else {
                ColRect bulletRect = this.getColRect(gameTime, 1);
                if (bulletRect != null) {
                    this.lineLaserAtt(gameTime, gameEngine, bulletRect);
                    this.BossHeadGoalPosy = this.getY() + (bulletRect.y << 1);
                }
            }
        }
    }

    private void lineLaserAtt(long gameTime, GameEngine gameEngine, ColRect bulletRect) {
        if (Enemy.LineRectIntersect(this.getX() + bulletRect.x + (bulletRect.w >> 1), this.getY() + bulletRect.y + (bulletRect.h >> 1), -3, this.getY() + bulletRect.y + (bulletRect.h >> 1), gameEngine.getPlayer(), gameEngine.getPlayer().getColRect(gameTime, 0))) {
            gameEngine.getPlayer().reduceLife(this.getFarattdamage1(), 0, null, gameTime);
        }
    }

    private void processInitNormalAttWhileRun(long gameTime, GameEngine gameEngine, GameActor[] actorPool) {
        if (this.animID != 4) {
            this.changeFrontage(gameTime);
        }
        int wayPointIndex = this.EndX;
        if (this.moveToPos(Path.getWayPoints()[wayPointIndex][this.wayPointsStep][0] * 360 / 100, 36 + Path.getWayPoints()[wayPointIndex][this.wayPointsStep][1] * 444 / 100, this.speed, gameTime, false)) {
            if (Path.getWayPoints()[wayPointIndex][this.wayPointsStep].length == 3 && Path.getWayPoints()[wayPointIndex][this.wayPointsStep][2] == 1 && !this.isReachedGoal) {
                this.attCount = 0;
                this.setRenderContent(4, false, gameTime);
            }
            this.wayPointsStep = (short)(this.wayPointsStep + 1);
            if (this.wayPointsStep >= Path.getWayPoints()[wayPointIndex].length) {
                this.isReachedGoal = true;
                this.wayPointsStep = (short)(Path.getWayPoints()[wayPointIndex].length - 1);
                if (this.animID == 4) {
                    if (this.isAnimationOver(gameTime)) {
                        this.setMPosition((byte)0);
                        this.selectAttackType(gameTime);
                        this.isReachedGoal = false;
                    }
                } else {
                    this.setMPosition((byte)0);
                    this.selectAttackType(gameTime);
                    this.isReachedGoal = false;
                }
            }
        }
        if (this.animID == 4) {
            if (this.isAnimationOver(gameTime)) {
                this.attCount = 0;
                this.setRenderContent(0, true, gameTime);
            } else {
                this.openFire(gameTime, gameEngine);
            }
        }
    }

    private void processInitDemon(long gameTime, GameEngine gameEngine, GameActor[] actorPool) {
        int wayPointIndex = this.EndX;
        if (this.moveToPos(Path.getWayPoints()[wayPointIndex][this.wayPointsStep][0] * 360 / 100, 36 + Path.getWayPoints()[wayPointIndex][this.wayPointsStep][1] * 444 / 100, this.getSpeed2(), gameTime, false)) {
            if (Path.getWayPoints()[wayPointIndex][this.wayPointsStep].length == 3 && Path.getWayPoints()[wayPointIndex][this.wayPointsStep][2] == 1) {
                this.attCount = 0;
                this.addAfire(gameTime, gameEngine, actorPool);
            }
            this.wayPointsStep = (short)(this.wayPointsStep + 1);
            if (this.wayPointsStep >= Path.getWayPoints()[wayPointIndex].length) {
                this.setMPosition((byte)0);
                this.selectAttackType(gameTime);
            }
        }
    }

    private void processInitMagicAttWhileRun1(long gameTime, GameEngine gameEngine, GameActor[] actorPool) {
        if (this.animID != 4) {
            this.changeFrontage(gameTime);
        }
        int wayPointIndex = this.EndX;
        if (this.moveToPos(Path.getWayPoints()[wayPointIndex][this.wayPointsStep][0] * 360 / 100, 36 + Path.getWayPoints()[wayPointIndex][this.wayPointsStep][1] * 444 / 100, this.speed, gameTime, false)) {
            if (Path.getWayPoints()[wayPointIndex][this.wayPointsStep].length == 3 && Path.getWayPoints()[wayPointIndex][this.wayPointsStep][2] == 1) {
                this.attCount = 0;
                this.setRenderContent(4, false, gameTime);
            }
            this.wayPointsStep = (short)(this.wayPointsStep + 1);
            if (this.wayPointsStep >= Path.getWayPoints()[wayPointIndex].length) {
                this.setMPosition((byte)0);
                this.selectAttackType(gameTime);
            }
        }
        if (this.animID == 4) {
            if (this.isAnimationOver(gameTime)) {
                this.attCount = 0;
                this.setRenderContent(0, true, gameTime);
            } else {
                ColRect bulletRect = this.getColRect(gameTime, 1);
                if (bulletRect != null) {
                    if (this.addBullet) {
                        this.callOfOpenFire(gameTime, actorPool, gameEngine, this.getX() + bulletRect.x, this.getY() + bulletRect.y, 23, 1);
                        ++this.attCount;
                        this.addBullet = false;
                    }
                } else {
                    this.addBullet = true;
                }
            }
        }
    }

    private void processInitMagicAttWhileRun2(long gameTime, GameEngine gameEngine, GameActor[] actorPool) {
        if (this.animID != 3) {
            this.changeFrontage(gameTime);
        }
        int wayPointIndex = this.EndX;
        if (this.moveToPos(Path.getWayPoints()[wayPointIndex][this.wayPointsStep][0] * 360 / 100, 36 + Path.getWayPoints()[wayPointIndex][this.wayPointsStep][1] * 444 / 100, this.speed, gameTime, false)) {
            if (Path.getWayPoints()[wayPointIndex][this.wayPointsStep].length == 3 && Path.getWayPoints()[wayPointIndex][this.wayPointsStep][2] == 1) {
                this.attCount = 0;
                this.setRenderContent(3, false, gameTime);
            }
            this.wayPointsStep = (short)(this.wayPointsStep + 1);
            if (this.wayPointsStep >= Path.getWayPoints()[wayPointIndex].length) {
                this.setMPosition((byte)0);
                this.selectAttackType(gameTime);
            }
        }
        if (this.animID == 3) {
            if (this.isAnimationOver(gameTime)) {
                this.attCount = 0;
                this.setRenderContent(3, true, gameTime);
            } else {
                ColRect bulletRect = this.getColRect(gameTime, 1);
                if (bulletRect != null) {
                    if (this.addBullet) {
                        this.callOfOpenFire(gameTime, actorPool, gameEngine, this.getX() + bulletRect.x, this.getY() + bulletRect.y, 19, 1);
                        ++this.attCount;
                        this.addBullet = false;
                    }
                } else {
                    this.addBullet = true;
                }
            }
        }
    }

    private void processWaitBossFireLord(long gameTime, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            this.mStayStartTime = gameTime;
        }
        if (gameTime - this.mStayStartTime > this.mWaitTime) {
            if (this.isRetreat) {
                this.setState((byte)15, gameTime);
            } else {
                this.mToPosition = 1;
                this.setState((byte)1, gameTime);
            }
        }
        this.reelUpDown(gameTime);
    }

    private void processWait(long gameTime, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            this.mStayStartTime = gameTime;
        }
        if (gameTime - this.mStayStartTime > this.mWaitTime) {
            if (this.isRetreat) {
                this.setState((byte)15, gameTime);
            } else {
                this.selectAttackType(gameTime);
            }
        }
        this.reelUpDown(gameTime);
    }

    private void processAtt(long gameTime, GameEngine gameEngine) {
        if (this.isAnimationOver(gameTime)) {
            this.mToPosition = 1;
            this.setState((byte)1, gameTime);
            ++this.attackCount;
        } else if (this.isCollide(gameTime, gameEngine.getPlayer(), 3, 0)) {
            gameEngine.getPlayer().reduceLife(this.getAttdamage1(), 5, this.getIntersectRect(gameTime, gameEngine.getPlayer(), 3, 0), gameTime);
        }
    }

    private void processSummon(long gameTime, GameEngine gameEngine, GameActor[] actorpool) {
        if (this.isFarAtted) {
            if (gameTime - this.mStayStartTime >= this.mFarAttStayTime) {
                this.isFarAtted = false;
                this.selectAttackType(gameTime);
            } else {
                this.reelUpDown(gameTime);
            }
        } else {
            this.summon(gameTime, gameEngine, actorpool);
            if (this.isAnimationOver(gameTime)) {
                ++this.attackCount;
                this.isFarAtted = true;
                this.mStayStartTime = gameTime;
                this.setRenderContent(0, true, gameTime);
            }
        }
    }

    private void summon(long gameTime, GameEngine gameEngine, GameActor[] actorpool) {
        ColRect bulletRect = this.getColRect(gameTime, 1);
        if (bulletRect != null) {
            if (this.addBullet) {
                for (int i2 = 0; i2 < actorpool.length; ++i2) {
                    if (actorpool[i2] != null && actorpool[i2].inUse()) continue;
                    if (actorpool[i2] == null) {
                        actorpool[i2] = new Enemy();
                    }
                    EnemyBase enemy = (EnemyBase)actorpool[i2];
                    enemy.setAnimation(gameEngine.enemy09Pif);
                    enemy.setSubType(35);
                    enemy.init(gameTime, 1);
                    enemy.setState((byte)0, gameTime);
                    enemy.setX(this.getX() + bulletRect.x + (bulletRect.w >> 2));
                    enemy.setY(this.getY() + bulletRect.y + bulletRect.h);
                    enemy.speed = this.speed;
                    enemy.lv = this.lv;
                    enemy.findAttribute((short)17, (short)enemy.lv);
                    this.setRelatePlayer(enemy);
                    break;
                }
                this.addBullet = false;
                ++this.attCount;
            }
        } else {
            this.addBullet = true;
        }
    }

    private void summonSkullWall(long gameTime, GameEngine gameEngine, GameActor[] actorpool, int startx, int starty, int bulletnumber, int disy, int stat) {
        int addCount = 0;
        for (int i2 = 0; i2 < actorpool.length; ++i2) {
            if (actorpool[i2] != null && actorpool[i2].inUse()) continue;
            if (actorpool[i2] == null) {
                actorpool[i2] = new Enemy();
            }
            EnemyBase enemy = (EnemyBase)actorpool[i2];
            enemy.setAnimation(gameEngine.bossGeneralPif);
            enemy.setSubType(47);
            enemy.init(gameTime, 1);
            if (stat == 0) {
                enemy.setState((byte)0, gameTime);
            }
            enemy.setX(startx);
            enemy.setY(starty + addCount * disy);
            enemy.setAttdamage1(this.getFarattdamage1());
            if (++addCount <= bulletnumber - 1) continue;
            ++this.attCount;
            this.mStayStartTime = gameTime;
            break;
        }
    }

    private void summonCobie(long gameTime, GameEngine gameEngine, GameActor[] actorpool, int bulletnumber) {
        int addCount = 0;
        for (int i2 = 0; i2 < actorpool.length; ++i2) {
            if (actorpool[i2] != null && actorpool[i2].inUse()) continue;
            if (actorpool[i2] == null) {
                actorpool[i2] = new Enemy();
            }
            EnemyBase enemy = (EnemyBase)actorpool[i2];
            enemy.setAnimation(gameEngine.enemy04Pif);
            enemy.setSubType(24);
            enemy.init(gameTime, 1);
            enemy.setState((byte)0, gameTime);
            if (this.attCount == 0) {
                enemy.setX(342);
                enemy.setY(58);
            } else if (this.attCount == 1) {
                enemy.setX(342);
                enemy.setY(457);
            } else if (this.attCount == 2) {
                if (addCount == 0) {
                    enemy.setX(342);
                    enemy.setY(58);
                } else {
                    enemy.setX(342);
                    enemy.setY(457);
                }
            }
            enemy.speed = 9;
            enemy.lv = 2;
            enemy.findAttribute((short)13, (short)enemy.lv);
            if (++addCount <= bulletnumber - 1) continue;
            ++this.attCount;
            this.mStayStartTime = gameTime;
            break;
        }
    }

    private void addAfire(long gameTime, GameEngine gameEngine, GameActor[] actorpool) {
        for (int i2 = 0; i2 < actorpool.length; ++i2) {
            if (actorpool[i2] != null && actorpool[i2].inUse()) continue;
            if (actorpool[i2] == null) {
                actorpool[i2] = new Enemy();
            }
            EnemyBase enemy = (EnemyBase)actorpool[i2];
            enemy.setAnimation(gameEngine.bossBullet01Pif);
            enemy.init(gameTime, 1);
            enemy.setSubType(31);
            enemy.setState((byte)0, gameTime);
            enemy.setX(this.getX());
            enemy.setY(this.getY());
            enemy.setAttdamage1(this.getAttdamage1());
            break;
        }
    }

    private void processAttFar(long gameTime, GameEngine gameEngine) {
        if (this.isFarAtted) {
            if (gameTime - this.mStayStartTime >= this.mFarAttStayTime) {
                this.isFarAtted = false;
                this.selectAttackType(gameTime);
            } else {
                this.reelUpDown(gameTime);
            }
        } else if (this.animID == 0) {
            if (this.moveToArea(this.getX(), gameEngine.getPlayer().getY(), this.speed, 0, 60, true, gameTime, true)) {
                this.setRenderContent(4, false, gameTime);
            }
        } else {
            this.reelUpDown(gameTime);
            this.openFire(gameTime, gameEngine);
            if (this.isAnimationOver(gameTime)) {
                ++this.attackCount;
                this.isFarAtted = true;
                this.mStayStartTime = gameTime;
                this.setRenderContent(0, true, gameTime);
            }
        }
    }

    private void reelUpDown(long gameTime) {
        this.y += CMath.sin((int)(gameTime - this.mStayStartTime >> 2));
    }

    private void processTrackToNearNormal(long gameTime, GameEngine gameEngine, byte toposition) {
        int movx;
        if (this.isBeenAttacked()) {
            if (this.moveToPos(this.FarPositionX, this.FarPositionY, this.getSpeed2(), gameTime, true)) {
                this.setBeenAttacked(false);
                this.setMPosition((byte)0);
                this.selectAttackType(gameTime);
            }
        } else if (gameEngine.getPlayer().getColRect(gameTime, 0) != null && this.moveToArea(movx = gameEngine.getPlayer().getX() + 30, gameEngine.getPlayer().getY(), this.getSpeed2(), 10, 60, false, gameTime, true)) {
            if (gameTime - this.mStayStartTime > 2000L) {
                this.setMPosition((byte)1);
                this.selectAttackType(gameTime);
            } else {
                this.setRenderContent(0, true, gameTime);
            }
        }
    }

    private void processTrackToNearMagician(long gameTime, GameEngine gameEngine, byte toposition) {
        if (gameEngine.getPlayer().getColRect(gameTime, 0) != null && this.moveToPos(this.FarPositionX, this.getY(), this.getSpeed2(), gameTime, true)) {
            if (gameTime - this.mStayStartTime > 2000L) {
                this.selectAttackType(gameTime);
            } else {
                this.setRenderContent(0, true, gameTime);
            }
        }
    }

    private void processTrackBossCyclops(long gameTime, GameEngine gameEngine, byte toposition) {
        if (toposition == 1) {
            int movx = gameEngine.getPlayer().getX() + 40;
            if (this.moveToArea(movx, gameEngine.getPlayer().getY() - 10, this.getSpeed2(), 40, 20, false, gameTime, true)) {
                if (gameTime - this.mStayStartTime > 2000L) {
                    this.setMPosition(toposition);
                    this.selectAttackType(gameTime);
                } else {
                    this.setRenderContent(0, true, gameTime);
                }
            }
        } else if (this.moveToArea(this.FarPositionX, this.FarPositionY, this.getSpeed2(), 0, 60, true, gameTime, true)) {
            this.setMPosition(toposition);
            this.selectAttackType(gameTime);
        }
    }

    private void processTrackBossDracula(long gameTime, GameEngine gameEngine, byte toposition) {
        if (toposition == 1) {
            int movx = gameEngine.getPlayer().getX() + 20;
            if (this.moveToArea(movx, gameEngine.getPlayer().getY(), this.getSpeed2(), 40, 10, false, gameTime, true)) {
                if (gameTime - this.mStayStartTime > 2000L) {
                    this.setMPosition(toposition);
                    this.selectAttackType(gameTime);
                } else {
                    this.setRenderContent(0, true, gameTime);
                }
            }
        } else if (this.moveToArea(this.FarPositionX, this.FarPositionY, this.getSpeed2(), 0, 60, true, gameTime, true)) {
            this.setMPosition(toposition);
            this.selectAttackType(gameTime);
        }
    }

    private void processTrackBossGE1(long gameTime, GameEngine gameEngine, byte toposition) {
        if (this.moveToArea(this.FarPositionX, this.FarPositionY, this.getSpeed2(), 0, 0, true, gameTime, false)) {
            this.setMPosition(toposition);
            this.selectAttackType(gameTime);
        }
    }

    private void processTrackBossSword(long gameTime, GameEngine gameEngine, byte toposition) {
        if (toposition == 1) {
            int movx = gameEngine.getPlayer().getX() + 20;
            if (this.moveToArea(movx, gameEngine.getPlayer().getY(), this.getSpeed2(), 40, 10, false, gameTime, true)) {
                if (gameTime - this.mStayStartTime > 2000L) {
                    this.setMPosition(toposition);
                    this.selectAttackType(gameTime);
                } else {
                    this.setRenderContent(5, true, gameTime);
                }
            }
        } else if (this.moveToArea(this.FarPositionX, this.FarPositionY, this.getSpeed2(), 0, 60, true, gameTime, true)) {
            this.setMPosition(toposition);
            this.selectAttackType(gameTime);
        }
    }

    private void processTrackBossKing(long gameTime, GameEngine gameEngine, byte toposition) {
        if (toposition == 1) {
            int movx = gameEngine.getPlayer().getX() + 20;
            if (this.moveToArea(movx, gameEngine.getPlayer().getY(), this.getSpeed2(), 40, 10, false, gameTime, true)) {
                if (gameTime - this.mStayStartTime > 2000L) {
                    this.setMPosition(toposition);
                    this.selectAttackType(gameTime);
                } else {
                    this.setRenderContent(0, true, gameTime);
                }
            }
        } else if (this.moveToArea(this.FarPositionX, this.FarPositionY, this.getSpeed2(), 0, 0, true, gameTime, true)) {
            this.setMPosition(toposition);
            this.selectAttackType(gameTime);
        }
    }

    private void processTrackBossGeneral(long gameTime, GameEngine gameEngine, byte toposition) {
        if (toposition == 1) {
            int movx = gameEngine.getPlayer().getX() + 20;
            if (this.moveToArea(movx, gameEngine.getPlayer().getY(), this.getSpeed2(), 40, 10, false, gameTime, true)) {
                if (gameTime - this.mStayStartTime > 2000L) {
                    this.setMPosition(toposition);
                    this.selectAttackType(gameTime);
                } else {
                    this.setRenderContent(0, true, gameTime);
                }
            }
        } else if (this.moveToArea(this.FarPositionX, this.FarPositionY, this.getSpeed2(), 0, 60, true, gameTime, true)) {
            this.setMPosition(toposition);
            this.selectAttackType(gameTime);
        }
    }

    private void processTrackBossFireLord(long gameTime, GameEngine gameEngine, byte toposition) {
        if (this.getX() < this.getLastX() && this.animID != 2) {
            this.setRenderContent(2, true, gameTime);
        } else if (this.getX() > this.getLastX() && this.animID != 3) {
            this.setRenderContent(3, true, gameTime);
        }
        if (this.getY() < this.getLastY() && this.animID != 2) {
            this.setRenderContent(2, true, gameTime);
        } else if (this.getY() > this.getLastY() && this.animID != 3) {
            this.setRenderContent(3, true, gameTime);
        }
        if ((long)Math.abs(this.fireLordEggOffx - this.getX()) >= 20L || (long)Math.abs(this.fireLordEggOffy - this.getY()) >= 20L) {
            this.fireLordEggOffx = this.getX();
            this.fireLordEggOffy = this.getY();
            this.callOfOpenFire(gameTime, null, gameEngine, this.getX(), this.getY(), 18, 1);
        }
        if (toposition == 1) {
            int movx = gameEngine.getPlayer().getX() + 30;
            if (this.moveToArea(movx, gameEngine.getPlayer().getY() - 60, this.getSpeed2(), 150, 120, false, gameTime, true)) {
                if (gameTime - this.mStayStartTime > 2000L) {
                    this.setMPosition(toposition);
                    this.selectAttackType(gameTime);
                } else {
                    this.setRenderContent(1, true, gameTime);
                }
            }
        } else if (this.moveToArea(this.getX(), gameEngine.getPlayer().getY(), this.getSpeed2(), 0, 60, true, gameTime, true)) {
            this.setMPosition(toposition);
            this.selectAttackType(gameTime);
        }
    }

    private void processTrack(long gameTime, GameEngine gameEngine, byte toposition) {
        this.changeFrontage(gameTime);
        if (toposition == 1) {
            if (this.getSubType() == 0 || this.getSubType() == 20 || this.getSubType() == 21 || this.getSubType() == 22 || this.getSubType() == 23 || this.getSubType() == 34 || this.getSubType() == 35 || this.getSubType() == 37 || this.getSubType() == 38) {
                this.processTrackToNearNormal(gameTime, gameEngine, toposition);
            } else {
                this.processTrackToNearMagician(gameTime, gameEngine, toposition);
            }
        } else if (this.moveToPos(this.FarPositionX, this.FarPositionY, this.getSpeed2(), gameTime, true)) {
            this.setMPosition((byte)0);
            this.selectAttackType(gameTime);
        }
    }

    private void processSuperAtt(long gameTime, GameEngine gameEngine) {
    }

    private void processSpiderIITrack(long gameTime, GameEngine gameEngine) {
        switch (this.getMPosition()) {
            case 0: {
                if (!this.moveToArea(this.getX(), gameEngine.getPlayer().getY(), this.speed, 0, 60, true, gameTime, true)) break;
                this.setState((byte)2, gameTime);
                break;
            }
            case 2: {
                if (!this.moveToPos(this.getX(), this.BossHeadGoalPosy, this.speed, gameTime, false)) break;
                this.setState((byte)2, gameTime);
                break;
            }
            case 1: {
                if (!this.moveToArea(this.getX(), gameEngine.getPlayer().getY(), this.speed, 0, 60, true, gameTime, true)) break;
                this.setState((byte)17, gameTime);
            }
        }
    }

    private void processSpiderTrack(long gameTime, GameEngine gameEngine) {
        this.moveToPos(gameEngine.getPlayer().getX(), this.getY(), this.speed, gameTime, false);
        ColRect crAtt = this.getColRect(gameTime, 3);
        crAtt.h = 444;
        if (this.isCollide(gameTime, gameEngine.getPlayer(), 3, 0) && gameEngine.getPlayer().getState() != 5) {
            this.BossHeadGoalPosx = this.getX();
            this.BossHeadGoalPosy = gameEngine.getPlayer().getY();
            this.BossHeadBackPosx = this.getX();
            this.BossHeadBackPosy = this.getY();
            this.isReachedGoal = false;
            this.isBeatedBack = false;
            this.setState((byte)2, gameTime);
            return;
        }
        GameActor[] actorPool = GameEngine.actorPool;
        if (actorPool != null) {
            for (int i2 = 0; i2 < actorPool.length; ++i2) {
                if (actorPool[i2] == null || actorPool[i2].getType() != 1 || actorPool[i2].getSubType() == 7 || actorPool[i2].getSubType() == 9 || actorPool[i2].getSubType() == 10 || actorPool[i2].getSubType() == 11 || actorPool[i2].getSubType() == 5 || actorPool[i2].getSubType() == 6 || actorPool[i2].getSubType() == 12 || actorPool[i2].getSubType() == 31 || !this.isCollide(gameTime, actorPool[i2], 3, 0) || !((Enemy)actorPool[i2]).isAlive()) continue;
                this.BossHeadGoalPosx = this.getX();
                this.BossHeadGoalPosy = actorPool[i2].getY();
                this.BossHeadBackPosx = this.getX();
                this.BossHeadBackPosy = this.getY();
                this.isReachedGoal = false;
                this.isBeatedBack = false;
                this.setState((byte)2, gameTime);
            }
        }
    }

    private void processTrackCannibalPlant(long gameTime, GameEngine gameEngine) {
        if (this.animID == 1) {
            if (this.isAnimationOver(gameTime)) {
                this.setState((byte)2, gameTime);
            }
        } else {
            ColRect crAtt = this.getColRect(gameTime, 3);
            crAtt.h = 444;
            crAtt.y = -crAtt.h;
            if (this.isCollide(gameTime, gameEngine.getPlayer(), 3, 0) && gameEngine.getPlayer().getState() != 5) {
                this.BossHeadGoalPosx = this.getX();
                this.BossHeadGoalPosy = gameEngine.getPlayer().getY();
                this.BossHeadBackPosx = this.getX();
                this.BossHeadBackPosy = this.getY();
                this.isReachedGoal = false;
                this.isBeatedBack = false;
                this.setRenderContent(1, false, gameTime);
                return;
            }
            GameActor[] actorPool = GameEngine.actorPool;
            if (actorPool != null) {
                for (int i2 = 0; i2 < actorPool.length; ++i2) {
                    if (actorPool[i2] == null || actorPool[i2].getType() != 1 || actorPool[i2].getSubType() == 7 || actorPool[i2].getSubType() == 9 || actorPool[i2].getSubType() == 10 || actorPool[i2].getSubType() == 11 || actorPool[i2].getSubType() == 5 || actorPool[i2].getSubType() == 6 || actorPool[i2].getSubType() == 12 || actorPool[i2].getSubType() == 31 || !this.isCollide(gameTime, actorPool[i2], 3, 0) || !((Enemy)actorPool[i2]).isAlive()) continue;
                    this.BossHeadGoalPosx = this.getX();
                    this.BossHeadGoalPosy = actorPool[i2].getY();
                    this.BossHeadBackPosx = this.getX();
                    this.BossHeadBackPosy = this.getY();
                    this.isReachedGoal = false;
                    this.isBeatedBack = false;
                    this.setRenderContent(1, false, gameTime);
                }
            }
        }
    }

    private void processSpiderAtt(long gameTime, GameEngine gameEngine) {
        block11: {
            block10: {
                block13: {
                    block12: {
                        int spd;
                        if (!this.isReachedGoal) break block10;
                        if (!this.isAnimationOver(gameTime)) break block11;
                        int n2 = spd = this.isBeatedBack ? 3 : 12;
                        if (!this.moveToPos(this.BossHeadBackPosx, this.BossHeadBackPosy, spd, gameTime, false)) break block12;
                        if (this.isBeatedBack) {
                            if (this.getRelatePlayer() != null) {
                                if (this.getRelatePlayer().getType() == 0 && ((Player)this.getRelatePlayer()).isPlayerDead() || this.getRelatePlayer().getType() == 1 && !((Enemy)this.getRelatePlayer()).isAlive()) {
                                    if (this.getRelatePlayer().getType() == 1) {
                                        this.getRelatePlayer().endNotify(gameTime, 7);
                                    }
                                    this.isBeatedBack = false;
                                    this.getRelatePlayer().reduceLife(0, 0, null, gameTime);
                                    this.getRelatePlayer().setRelatePlayer(null);
                                    this.setRelatePlayer(null);
                                } else {
                                    this.getRelatePlayer().reduceLife(this.getAttdamage1(), 10, null, gameTime);
                                    this.getRelatePlayer().endNotify(gameTime, 7);
                                    this.getRelatePlayer().setRelatePlayer(null);
                                    this.setRelatePlayer(null);
                                    this.setState((byte)17, gameTime);
                                }
                            }
                        } else {
                            this.setState((byte)1, gameTime);
                        }
                        this.isReachedGoal = false;
                        this.isBeatedBack = false;
                        break block11;
                    }
                    if (!this.isBeatedBack || this.getRelatePlayer() == null) break block11;
                    this.getRelatePlayer().setX(this.getX());
                    this.getRelatePlayer().setY(this.getY());
                    if ((this.getRelatePlayer().getType() != 0 || !((Player)this.getRelatePlayer()).isPlayerDead()) && (this.getRelatePlayer().getType() != 1 || ((Enemy)this.getRelatePlayer()).isAlive())) break block13;
                    if (this.getRelatePlayer().getType() == 1) {
                        this.getRelatePlayer().endNotify(gameTime, 7);
                    }
                    this.isBeatedBack = false;
                    this.getRelatePlayer().setRelatePlayer(null);
                    this.setRelatePlayer(null);
                    break block11;
                }
                if (this.getPowerNewton() > 0) break block11;
                this.getRelatePlayer().reduceLife(this.getAttdamage1() >> 1, 10, null, gameTime);
                this.getRelatePlayer().endNotify(gameTime, 7);
                this.getRelatePlayer().setRelatePlayer(null);
                this.setRelatePlayer(null);
                break block11;
            }
            if (this.moveToPos(this.BossHeadGoalPosx, this.BossHeadGoalPosy, 12, gameTime, false)) {
                this.isReachedGoal = true;
                this.setRenderContent(6, false, gameTime);
            }
            if (this.isCollide(gameTime, gameEngine.getPlayer(), 3, 0) && gameEngine.getPlayer().getState() != 5 && !gameEngine.getPlayer().isPlayerDead()) {
                this.isReachedGoal = true;
                this.isBeatedBack = true;
                this.setRenderContent(0, false, gameTime);
                this.setRelatePlayer(gameEngine.getPlayer());
                gameEngine.getPlayer().setRelatePlayer(this);
                this.getRelatePlayer().beginNotify(gameTime, 7);
                this.setPowerNewton(50);
                return;
            }
            GameActor[] actorPool = GameEngine.actorPool;
            for (int i2 = 0; i2 < actorPool.length; ++i2) {
                if (actorPool[i2] == null || actorPool[i2].getType() != 1 || actorPool[i2].getSubType() == 7 || actorPool[i2].getSubType() == 9 || actorPool[i2].getSubType() == 10 || actorPool[i2].getSubType() == 11 || actorPool[i2].getSubType() == 5 || actorPool[i2].getSubType() == 6 || actorPool[i2].getSubType() == 12 || actorPool[i2].getSubType() == 31 || !this.isCollide(gameTime, actorPool[i2], 3, 0) || !((Enemy)actorPool[i2]).isAlive()) continue;
                this.isReachedGoal = true;
                this.isBeatedBack = true;
                this.setPowerNewton(50);
                this.setRenderContent(0, false, gameTime);
                this.setRelatePlayer(actorPool[i2]);
                actorPool[i2].setRelatePlayer(this);
                this.getRelatePlayer().beginNotify(gameTime, 7);
                break;
            }
        }
    }

    private void processCannibalPlantAtt(long gameTime, GameEngine gameEngine) {
        block7: {
            block6: {
                if (!this.isReachedGoal) break block6;
                if (this.isBeatedBack) {
                    this.getRelatePlayer().setX(this.getX());
                    this.getRelatePlayer().setY(this.getY());
                }
                if (!this.isAnimationOver(gameTime)) break block7;
                if (this.isBeatedBack) {
                    this.setState((byte)17, gameTime);
                } else {
                    this.setState((byte)18, gameTime);
                }
                break block7;
            }
            if (this.moveToPos(this.getX(), this.BossHeadGoalPosy, 12, gameTime, false)) {
                this.isReachedGoal = true;
                this.setRenderContent(2, false, gameTime);
            }
            if (this.isCollide(gameTime, gameEngine.getPlayer(), 3, 0) && gameEngine.getPlayer().getState() != 5 && !gameEngine.getPlayer().isPlayerDead()) {
                this.isReachedGoal = true;
                this.isBeatedBack = true;
                this.setRenderContent(2, false, gameTime);
                this.setPowerNewton(50);
                this.setRelatePlayer(gameEngine.getPlayer());
                gameEngine.getPlayer().setRelatePlayer(this);
                this.getRelatePlayer().beginNotify(gameTime, 9);
                gameEngine.setStopScrollBG(true);
                return;
            }
            GameActor[] actorPool = GameEngine.actorPool;
            for (int i2 = 0; i2 < actorPool.length; ++i2) {
                if (actorPool[i2] == null || actorPool[i2].getType() != 1 || actorPool[i2].getSubType() == 7 || actorPool[i2].getSubType() == 9 || actorPool[i2].getSubType() == 10 || actorPool[i2].getSubType() == 11 || actorPool[i2].getSubType() == 12 || actorPool[i2].getSubType() == 5 || actorPool[i2].getSubType() == 6 || actorPool[i2].getSubType() == 3 || !this.isCollide(gameTime, actorPool[i2], 3, 0) || !((Enemy)actorPool[i2]).isAlive()) continue;
                this.setPowerNewton(50);
                this.isReachedGoal = true;
                this.isBeatedBack = true;
                this.setRenderContent(2, false, gameTime);
                this.setRelatePlayer(actorPool[i2]);
                actorPool[i2].setRelatePlayer(this);
                this.getRelatePlayer().beginNotify(gameTime, 9);
                break;
            }
        }
    }

    public void setState(byte newState, long time) {
        switch (this.getSubType()) {
            case 31: {
                this.setStateFire(newState, time);
                break;
            }
            case 42: 
            case 44: {
                this.setStateBossSword(newState, time);
                break;
            }
            default: {
                this.setStateUnderling(newState, time);
            }
        }
    }

    public void setStateCaneUp(byte newState, long time) {
        switch (newState) {
            case 6: 
            case 16: {
                break;
            }
            case 4: {
                super.setState(newState, time);
                this.BossHeadBackPosy = this.getY();
                this.setRenderContent(0, true, time);
                break;
            }
            case 0: {
                super.setState(newState, time);
                this.stateStartTime = time;
                break;
            }
            case 2: {
                super.setState(newState, time);
                this.setRenderContent(0, false, time);
                break;
            }
            default: {
                super.setState(newState, time);
                this.setRenderContent(0, true, time);
            }
        }
    }

    public void setStateCaneButtom(byte newState, long time) {
        switch (newState) {
            case 6: 
            case 16: {
                break;
            }
            case 4: {
                super.setState(newState, time);
                this.BossHeadBackPosy = this.getY();
                this.setRenderContent(3, true, time);
                break;
            }
            case 0: {
                super.setState(newState, time);
                this.stateStartTime = time;
                break;
            }
            case 2: {
                super.setState(newState, time);
                this.setRenderContent(3, false, time);
                break;
            }
            default: {
                super.setState(newState, time);
                this.setRenderContent(3, true, time);
            }
        }
    }

    public void setStateSpiderII(byte newState, long time) {
        this.stateStartTime = time;
        switch (newState) {
            case 15: {
                if (!this.isAlive()) break;
                super.setState(newState, time);
                this.isRetreat = true;
                this.setRenderContent(1, true, time);
                break;
            }
            case 4: {
                super.setState(newState, time);
                this.BossHeadBackPosy = this.getY();
                this.setRenderContent(1, true, time);
                break;
            }
            case 0: {
                this.setRenderContent(1, true, time);
                this.mStayStartTime = time;
                this.attCount = 0;
                super.setState(newState, time);
                break;
            }
            case 16: {
                super.setState(newState, time);
                this.bloodStartTime = time;
                this.setRenderContent(7, false, time);
                break;
            }
            case 5: {
                System.out.println("stat " + this.getState());
                if (!this.isAlive()) break;
                super.setState(newState, time);
                this.setRenderContent(7, false, time);
                this.boomStartTime = time;
                this.boomDiffX = 0;
                this.boomDiffY = this.getAnimation().GetAniFrameHeight(this.animID, 0) >> 1;
                break;
            }
            case 7: {
                super.setState(newState, time);
                this.setExplode(time);
                break;
            }
            case 2: 
            case 3: {
                super.setState(newState, time);
                this.attCount = CMath.getRandNumber(0, 2);
                this.setRenderContent(8, false, time);
                break;
            }
            case 17: {
                super.setState(newState, time);
                this.setRenderContent(2, false, time);
                break;
            }
            case 6: {
                break;
            }
            default: {
                super.setState(newState, time);
                this.setRenderContent(1, true, time);
            }
        }
    }

    public void setStateCannibalPlant(byte newState, long time) {
        this.stateStartTime = time;
        switch (newState) {
            case 15: {
                if (!this.isAlive()) break;
                super.setState(newState, time);
                this.isRetreat = true;
                if (this.getRelatePlayer() == null) break;
                if (this.getRelatePlayer().getType() == 0 && ((Player)this.getRelatePlayer()).isPlayerDead() || this.getRelatePlayer().getType() == 1 && !((Enemy)this.getRelatePlayer()).isAlive()) {
                    if (this.getRelatePlayer().getType() == 1) {
                        this.getRelatePlayer().endNotify(time, 7);
                    }
                    this.getRelatePlayer().setRelatePlayer(null);
                    this.setRelatePlayer(null);
                    break;
                }
                this.getRelatePlayer().reduceLife(this.getAttdamage1(), 10, null, time);
                this.getRelatePlayer().endNotify(time, 7);
                this.getRelatePlayer().setRelatePlayer(null);
                this.setRelatePlayer(null);
                break;
            }
            case 4: {
                super.setState(newState, time);
                break;
            }
            case 0: {
                super.setState(newState, time);
                this.setRenderContent(5, true, time);
                break;
            }
            case 1: {
                super.setState(newState, time);
                this.setRenderContent(5, true, time);
                this.isReachedGoal = false;
                this.isBeatedBack = false;
                break;
            }
            case 2: {
                super.setState(newState, time);
                this.setRenderContent(4, false, time);
                break;
            }
            case 18: {
                super.setState(newState, time);
                this.setRenderContent(5, false, time);
                break;
            }
            case 17: {
                super.setState(newState, time);
                this.setRenderContent(3, true, time);
                break;
            }
            case 5: {
                super.setState(newState, time);
                this.setRenderContent(1, false, time);
                break;
            }
        }
    }

    public void setStateSpider(byte newState, long time) {
        this.stateStartTime = time;
        switch (newState) {
            case 15: {
                if (!this.isAlive()) break;
                super.setState(newState, time);
                this.isRetreat = true;
                if (this.getRelatePlayer() == null) break;
                if (this.getRelatePlayer().getType() == 0 && ((Player)this.getRelatePlayer()).isPlayerDead() || this.getRelatePlayer().getType() == 1 && !((Enemy)this.getRelatePlayer()).isAlive()) {
                    if (this.getRelatePlayer().getType() == 1) {
                        this.getRelatePlayer().endNotify(time, 7);
                    }
                    this.getRelatePlayer().setRelatePlayer(null);
                    this.setRelatePlayer(null);
                    break;
                }
                this.getRelatePlayer().reduceLife(this.getAttdamage1(), 10, null, time);
                this.getRelatePlayer().endNotify(time, 7);
                this.getRelatePlayer().setRelatePlayer(null);
                this.setRelatePlayer(null);
                break;
            }
            case 0: {
                if (this.isInSupperAtt) {
                    return;
                }
                super.setState(newState, time);
                this.setRenderContent(5, true, time);
                break;
            }
            case 4: {
                super.setState(newState, time);
                this.setRenderContent(5, true, time);
                break;
            }
            case 1: {
                super.setState(newState, time);
                this.setY(36);
                this.setRenderContent(5, true, time);
                break;
            }
            case 17: {
                super.setState(newState, time);
                this.setAnimation(this.bloodEff2Pif);
                this.setRenderContent(0, false, time);
                break;
            }
            case 2: {
                super.setState(newState, time);
                this.setRenderContent(3, false, time);
                break;
            }
            case 6: {
                break;
            }
            default: {
                super.setState(newState, time);
                this.setRenderContent(5, true, time);
            }
        }
    }

    public void setStateBossCyclops(byte newState, long time) {
        switch (newState) {
            case 0: {
                super.setState(newState, time);
                this.setRenderContent(0, false, time);
                this.mStayStartTime = time;
                break;
            }
            case 16: {
                super.setState(newState, time);
                this.bloodStartTime = time;
                this.setRenderContent(0, false, time);
                break;
            }
            case 15: {
                this.setEnemyRetreat(newState, time);
                break;
            }
            case 1: {
                super.setState(newState, time);
                this.mStayStartTime = time;
                this.setRenderContent(0, true, time);
                break;
            }
            case 4: {
                super.setState(newState, time);
                this.alarmOfNumber = 7;
                this.alarmOfSpeed = 10;
                this.drawAlarm = false;
                this.lastAttStatus = (byte)11;
                this.initBossUI();
                this.setRenderContent(0, true, time);
                break;
            }
            case 5: {
                if (!this.isAlive()) break;
                super.setState(newState, time);
                this.stateStartTime = time;
                this.setRenderContent(0, false, time);
                this.setBossDeadBoom(time);
                break;
            }
            case 7: {
                super.setState(newState, time);
                this.setExplode(time);
                break;
            }
            case 8: {
                super.setState(newState, time);
                this.setRenderContent(1, false, time);
                break;
            }
            case 9: {
                super.setState(newState, time);
                this.setRenderContent(2, false, time);
                this.BossLaserAngel = 240;
                break;
            }
            case 10: {
                super.setState(newState, time);
                this.setRenderContent(4, false, time);
                break;
            }
            case 11: {
                super.setState(newState, time);
                this.setRenderContent(3, false, time);
                break;
            }
            case 6: {
                break;
            }
            default: {
                super.setState(newState, time);
                this.setRenderContent(0, true, time);
            }
        }
    }

    public void setStateBossGeneral(byte newState, long time) {
        switch (newState) {
            case 0: {
                super.setState(newState, time);
                this.setRenderContent(0, true, time);
                this.mStayStartTime = time;
                break;
            }
            case 16: {
                super.setState(newState, time);
                this.bloodStartTime = time;
                this.setRenderContent(3, false, time);
                break;
            }
            case 15: {
                this.setEnemyRetreat(newState, time);
                break;
            }
            case 1: {
                super.setState(newState, time);
                this.mStayStartTime = time;
                this.setRenderContent(0, true, time);
                break;
            }
            case 4: {
                super.setState(newState, time);
                this.alarmOfNumber = 7;
                this.alarmOfSpeed = 10;
                this.drawAlarm = false;
                this.lastAttStatus = (byte)10;
                this.initBossUI();
                this.setRenderContent(0, true, time);
                break;
            }
            case 5: {
                if (!this.isAlive()) break;
                super.setState(newState, time);
                this.stateStartTime = time;
                this.setRenderContent(3, false, time);
                this.setBossDeadBoom(time);
                break;
            }
            case 7: {
                super.setState(newState, time);
                this.setExplode(time);
                break;
            }
            case 8: {
                super.setState(newState, time);
                this.setRenderContent(4, false, time);
                break;
            }
            case 9: {
                super.setState(newState, time);
                this.setRenderContent(14, false, time);
                this.BossHeadGoalPosy = this.getY();
                break;
            }
            case 10: {
                super.setState(newState, time);
                this.setRenderContent(6, false, time);
                break;
            }
            case 6: {
                break;
            }
            default: {
                super.setState(newState, time);
                this.setRenderContent(0, true, time);
            }
        }
    }

    public void setStateBossGeneral1(byte newState, long time) {
        switch (newState) {
            case 0: {
                super.setState(newState, time);
                this.setRenderContent(0, true, time);
                this.mStayStartTime = time;
                break;
            }
            case 16: {
                super.setState(newState, time);
                this.bloodStartTime = time;
                this.setRenderContent(3, false, time);
                break;
            }
            case 15: {
                this.setEnemyRetreat(newState, time);
                break;
            }
            case 1: {
                super.setState(newState, time);
                this.mStayStartTime = time;
                this.setRenderContent(0, true, time);
                break;
            }
            case 4: {
                super.setState(newState, time);
                this.alarmOfNumber = 7;
                this.alarmOfSpeed = 10;
                this.drawAlarm = false;
                this.lastAttStatus = (byte)10;
                this.initBossUI();
                this.setRenderContent(0, true, time);
                break;
            }
            case 5: {
                if (!this.isAlive()) break;
                super.setState(newState, time);
                this.stateStartTime = time;
                ColRect rect = this.getColRect(time, 0);
                this.addBonus(time, rect);
                this.setRenderContent(0, true, time);
                this.setBossDeadBoom(time);
                break;
            }
            case 8: {
                super.setState(newState, time);
                this.setRenderContent(8, false, time);
                break;
            }
            case 9: {
                super.setState(newState, time);
                this.setRenderContent(8, false, time);
                break;
            }
            case 10: {
                super.setState(newState, time);
                this.setRenderContent(8, false, time);
                break;
            }
            case 11: {
                super.setState(newState, time);
                this.setRenderContent(8, false, time);
                break;
            }
            case 12: {
                super.setState(newState, time);
                this.setRenderContent(7, false, time);
                break;
            }
            case 6: {
                break;
            }
            default: {
                super.setState(newState, time);
                this.setRenderContent(0, true, time);
            }
        }
    }

    public void setStateBossGeneral2(byte newState, long time) {
        switch (newState) {
            case 0: {
                super.setState(newState, time);
                this.setRenderContent(9, true, time);
                this.mStayStartTime = time;
                break;
            }
            case 16: {
                super.setState(newState, time);
                this.bloodStartTime = time;
                this.setRenderContent(9, false, time);
                break;
            }
            case 15: {
                this.setEnemyRetreat(newState, time);
                break;
            }
            case 1: {
                super.setState(newState, time);
                this.mStayStartTime = time;
                this.setRenderContent(9, true, time);
                break;
            }
            case 4: {
                super.setState(newState, time);
                this.alarmOfNumber = 7;
                this.alarmOfSpeed = 10;
                this.drawAlarm = false;
                this.lastAttStatus = (byte)10;
                this.initBossUI();
                this.setRenderContent(9, true, time);
                break;
            }
            case 5: {
                if (!this.isAlive()) break;
                super.setState(newState, time);
                this.stateStartTime = time;
                ColRect rect = this.getColRect(time, 0);
                this.addBonus(time, rect);
                this.setRenderContent(9, true, time);
                break;
            }
            case 8: {
                super.setState(newState, time);
                this.setRenderContent(11, false, time);
                break;
            }
            case 9: {
                super.setState(newState, time);
                this.setRenderContent(18, false, time);
            }
        }
    }

    public void setStateBossKing(byte newState, long time) {
        switch (newState) {
            case 0: {
                super.setState(newState, time);
                this.setRenderContent(0, true, time);
                this.mStayStartTime = time;
                break;
            }
            case 16: {
                super.setState(newState, time);
                this.bloodStartTime = time;
                this.setRenderContent(0, false, time);
                break;
            }
            case 15: {
                this.setEnemyRetreat(newState, time);
                break;
            }
            case 1: {
                super.setState(newState, time);
                this.mStayStartTime = time;
                this.setRenderContent(0, true, time);
                break;
            }
            case 4: {
                super.setState(newState, time);
                this.alarmOfNumber = 7;
                this.alarmOfSpeed = 10;
                this.drawAlarm = false;
                this.lastAttStatus = (byte)10;
                this.initBossUI();
                this.setRenderContent(0, true, time);
                break;
            }
            case 5: {
                if (!this.isAlive()) break;
                super.setState(newState, time);
                this.stateStartTime = time;
                this.setRenderContent(0, false, time);
                this.setBossDeadBoom(time);
                break;
            }
            case 7: {
                super.setState(newState, time);
                this.setExplode(time);
                break;
            }
            case 8: {
                super.setState(newState, time);
                this.setRenderContent(3, false, time);
                break;
            }
            case 9: {
                super.setState(newState, time);
                this.setRenderContent(1, false, time);
                break;
            }
            case 10: {
                super.setState(newState, time);
                this.setRenderContent(7, false, time);
                break;
            }
            case 13: {
                super.setState(newState, time);
                this.setRenderContent(2, false, time);
                break;
            }
            case 14: {
                super.setState(newState, time);
                this.setRenderContent(8, false, time);
                break;
            }
            case 11: {
                super.setState(newState, time);
                this.setRenderContent(9, false, time);
                break;
            }
            case 21: {
                super.setState(newState, time);
                this.setRenderContent(10, false, time);
            }
        }
    }

    public void setStateBossSword(byte newState, long time) {
        switch (newState) {
            case 0: {
                super.setState(newState, time);
                this.setRenderContent(5, true, time);
                this.mStayStartTime = time;
                break;
            }
            case 16: {
                super.setState(newState, time);
                this.bloodStartTime = time;
                this.setRenderContent(5, false, time);
                break;
            }
            case 15: {
                this.setEnemyRetreat(newState, time);
                break;
            }
            case 1: {
                super.setState(newState, time);
                this.mStayStartTime = time;
                this.setRenderContent(5, true, time);
                break;
            }
            case 4: {
                super.setState(newState, time);
                this.alarmOfNumber = 7;
                this.alarmOfSpeed = 10;
                this.drawAlarm = false;
                this.lastAttStatus = (byte)10;
                if (this.getSubType() != 44) {
                    this.initBossUI();
                }
                this.setRenderContent(5, true, time);
                break;
            }
            case 5: {
                if (!this.isAlive()) break;
                super.setState(newState, time);
                this.stateStartTime = time;
                this.setRenderContent(5, false, time);
                this.setBossDeadBoom(time);
                break;
            }
            case 7: {
                super.setState(newState, time);
                this.setExplode(time);
                break;
            }
            case 8: {
                super.setState(newState, time);
                this.setRenderContent(6, false, time);
                break;
            }
            case 9: {
                super.setState(newState, time);
                this.setRenderContent(15, true, time);
                this.BossHeadGoalPosy = this.getY();
                break;
            }
            case 10: {
                super.setState(newState, time);
                this.setRenderContent(0, false, time);
                break;
            }
            case 13: {
                super.setState(newState, time);
                this.setRenderContent(1, false, time);
                break;
            }
            case 14: {
                super.setState(newState, time);
                this.setRenderContent(2, false, time);
                break;
            }
            case 6: {
                break;
            }
            default: {
                super.setState(newState, time);
                this.setRenderContent(5, false, time);
            }
        }
    }

    public void setStateBossDracula(byte newState, long time) {
        switch (newState) {
            case 0: {
                super.setState(newState, time);
                this.setRenderContent(0, true, time);
                this.mStayStartTime = time;
                break;
            }
            case 16: {
                super.setState(newState, time);
                this.bloodStartTime = time;
                this.setRenderContent(6, false, time);
                break;
            }
            case 15: {
                this.setEnemyRetreat(newState, time);
                break;
            }
            case 1: {
                super.setState(newState, time);
                this.mStayStartTime = time;
                this.setRenderContent(0, true, time);
                break;
            }
            case 4: {
                super.setState(newState, time);
                this.alarmOfNumber = 7;
                this.alarmOfSpeed = 10;
                this.drawAlarm = false;
                this.lastAttStatus = (byte)11;
                this.initBossUI();
                this.setRenderContent(0, false, time);
                break;
            }
            case 5: {
                if (!this.isAlive()) break;
                super.setState(newState, time);
                this.stateStartTime = time;
                this.setRenderContent(0, false, time);
                this.setBossDeadBoom(time);
                break;
            }
            case 7: {
                super.setState(newState, time);
                this.setExplode(time);
                break;
            }
            case 8: {
                super.setState(newState, time);
                this.setRenderContent(2, false, time);
                break;
            }
            case 9: {
                super.setState(newState, time);
                this.setRenderContent(3, false, time);
                this.BossHeadGoalPosy = this.getY();
                break;
            }
            case 10: {
                super.setState(newState, time);
                this.setRenderContent(4, true, time);
                break;
            }
            case 11: {
                super.setState(newState, time);
                this.setRenderContent(7, false, time);
                break;
            }
            case 21: {
                super.setState(newState, time);
                this.setRelatePlayer(MainCanvas.getGameEngine().getPlayer());
                this.getRelatePlayer().beginNotify(time, 9);
                this.getRelatePlayer().setRelatePlayer(this);
                this.setX(this.getRelatePlayer().getX());
                this.setY(this.getRelatePlayer().getY());
                this.setRenderContent(5, false, time);
                break;
            }
            case 22: {
                super.setState(newState, time);
                this.setRenderContent(10, true, time);
                break;
            }
            case 23: {
                super.setState(newState, time);
                this.setRenderContent(11, false, time);
                break;
            }
            case 6: {
                break;
            }
            default: {
                super.setState(newState, time);
                this.setRenderContent(0, true, time);
            }
        }
    }

    public void setStateBossFireLord(byte newState, long time) {
        switch (newState) {
            case 0: {
                super.setState(newState, time);
                this.setRenderContent(1, true, time);
                break;
            }
            case 16: {
                super.setState(newState, time);
                this.setRenderContent(4, false, time);
                break;
            }
            case 15: {
                this.setEnemyRetreat(newState, time);
                break;
            }
            case 1: {
                super.setState(newState, time);
                this.mStayStartTime = time;
                this.fireLordEggOffx = this.getX();
                this.fireLordEggOffy = this.getY();
                break;
            }
            case 18: {
                super.setState(newState, time);
                this.setRenderContent(5, false, time);
                break;
            }
            case 4: {
                super.setState(newState, time);
                this.setX(this.EndX);
                this.setY(this.EndY);
                this.alarmOfNumber = 7;
                this.alarmOfSpeed = 10;
                this.drawAlarm = false;
                this.setRenderContent(0, false, time);
                this.initBossUI();
                break;
            }
            case 5: {
                if (this.getState() == 5 || this.getState() == 18 || this.getState() == 7) break;
                super.setState(newState, time);
                this.stateStartTime = time;
                this.setRenderContent(4, false, time);
                this.setBossDeadBoom(time);
                break;
            }
            case 7: {
                super.setState(newState, time);
                this.setExplode(time);
                break;
            }
            case 8: {
                super.setState(newState, time);
                this.setRenderContent(7, false, time);
                break;
            }
            case 9: {
                super.setState(newState, time);
                this.setRenderContent(6, false, time);
                break;
            }
            case 10: {
                super.setState(newState, time);
                this.setRenderContent(1, true, time);
                this.mStayStartTime = time;
                this.isReachedGoal = false;
                break;
            }
            case 13: {
                super.setState(newState, time);
                this.setRenderContent(9, true, time);
                break;
            }
            case 14: {
                super.setState(newState, time);
                this.setRenderContent(10, false, time);
                break;
            }
            case 6: {
                break;
            }
            default: {
                super.setState(newState, time);
                this.setRenderContent(1, true, time);
            }
        }
    }

    private void setBossDeadBoom(long time) {
        this.setRamdomBossBoomTime(time);
        for (int i2 = 0; i2 < this.boomStartTime2.length; ++i2) {
            this.setRandomBossBoomPos(time, i2);
        }
    }

    public void setStateBossThreeHead(byte newState, long time) {
        switch (newState) {
            case 0: {
                super.setState(newState, time);
                this.setRenderContent(0, true, time);
                this.attackCount = 0;
                break;
            }
            case 16: {
                super.setState(newState, time);
                this.bloodStartTime = time;
                this.setRenderContent(1, false, time);
                break;
            }
            case 15: {
                this.setEnemyRetreat(newState, time);
                break;
            }
            case 4: {
                super.setState(newState, time);
                this.setRenderContent(0, true, time);
                this.alarmOfNumber = 7;
                this.alarmOfSpeed = 10;
                this.drawAlarm = false;
                this.initBossUI();
                break;
            }
            case 5: {
                if (!this.isAlive()) break;
                MainCanvas.getGameEngine().getPlayer().endNotify(time, 2);
                super.setState(newState, time);
                this.setRenderContent(1, false, time);
                this.setBossDeadBoom(time);
                break;
            }
            case 7: {
                super.setState(newState, time);
                this.setExplode(time);
                break;
            }
            case 8: {
                super.setState(newState, time);
                this.setRenderContent(2, false, time);
                break;
            }
            case 12: {
                super.setState(newState, time);
                this.setRenderContent(3, true, time);
                break;
            }
            case 9: {
                super.setState(newState, time);
                this.setRenderContent(4, false, time);
                break;
            }
            case 10: {
                super.setState(newState, time);
                MainCanvas.getGameEngine().getPlayer().beginNotify(time, 2);
                this.setRenderContent(5, false, time);
                break;
            }
            case 11: {
                super.setState(newState, time);
                this.setRenderContent(6, false, time);
                break;
            }
            case 6: {
                break;
            }
            default: {
                super.setState(newState, time);
                this.setRenderContent(0, true, time);
            }
        }
    }

    private void initBossUI() {
        MainCanvas.getGameEngine().setBossLifeWidth(0);
        MainCanvas.getGameEngine().setBossLifeBGWidth(0);
        MainCanvas.getGameEngine().isBossUiUpdated = false;
    }

    public void setStateRock(byte newState, long time) {
        if (newState == 6) {
            return;
        }
        this.stateStartTime = time;
        super.setState(newState, time);
        switch (newState) {
            case 4: {
                this.setRenderContent(0, true, time);
                break;
            }
            case 7: {
                this.setRenderContent(1, true, time);
            }
        }
    }

    public void setStateFire(byte newState, long time) {
        if (newState == 6) {
            return;
        }
        super.setState(newState, time);
        this.setRenderContent(0, true, time);
    }

    public void setStateSkullWall(byte newState, long time) {
        if (newState == 6) {
            return;
        }
        switch (newState) {
            case 4: {
                super.setState(newState, time);
                this.setRenderContent(15, false, time);
                break;
            }
            case 5: {
                if (this.getState() == 5) break;
                super.setState(newState, time);
                this.setRenderContent(16, false, time);
                break;
            }
            default: {
                super.setState(newState, time);
                this.setRenderContent(17, true, time);
            }
        }
    }

    public void setStateFishermanSprint(byte newState, long time) {
        switch (newState) {
            case 2: {
                super.setState(newState, time);
                this.setRenderContent(8, true, time);
                this.isFarAtted = false;
                break;
            }
            case 16: {
                this.bloodStartTime = time;
                break;
            }
            default: {
                this.setStateUnderling(newState, time);
            }
        }
    }

    public void setStateUnderling(byte newState, long time) {
        switch (newState) {
            case 0: {
                super.setState(newState, time);
                this.setRenderContent(0, true, time);
                this.attackCount = 0;
                break;
            }
            case 16: {
                if (!this.isAlive()) break;
                super.setState(newState, time);
                this.bloodStartTime = time;
                if (this.BeatBackSpeed == 1) {
                    this.setRenderContent(5, false, time);
                    break;
                }
                if (this.BeatBackSpeed != 4) break;
                this.setRenderContent(6, false, time);
                break;
            }
            case 15: {
                this.setEnemyRetreat(newState, time);
                break;
            }
            case 1: {
                super.setState(newState, time);
                this.mStayStartTime = time;
                break;
            }
            case 19: {
                super.setState(newState, time);
                this.setRenderContent(3, false, time);
                break;
            }
            case 2: {
                super.setState(newState, time);
                this.setRenderContent(3, false, time);
                break;
            }
            case 3: {
                super.setState(newState, time);
                this.attCount = 0;
                this.setUnderlingFarAtt(time);
                break;
            }
            case 4: {
                this.attackCount = this.getSubType() == 22 || this.getSubType() == 34 || this.getSubType() == 37 ? 3 : 0;
                this.lineatt = this.getSubType() == 20;
                super.setState(newState, time);
                this.setRenderContent(0, true, time);
                break;
            }
            case 5: {
                if (!this.isAlive()) break;
                super.setState(newState, time);
                switch (this.causeOfDeath) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 9: {
                        this.bloodStartTime = time;
                        this.setRenderContent(7, false, time);
                        break;
                    }
                    default: {
                        this.setRenderContent(5, false, time);
                    }
                }
                this.boomStartTime = time;
                this.boomDiffX = 0;
                this.boomDiffY = this.getAnimation().GetAniFrameHeight(this.animID, 0) >> 1;
                break;
            }
            case 6: {
                if (this.getLife() <= 0) break;
                break;
            }
            case 7: {
                super.setState(newState, time);
                this.setExplode(time);
                break;
            }
            case 17: {
                break;
            }
            case 20: {
                super.setState(newState, time);
                this.setRenderContent(8, false, time);
                break;
            }
            default: {
                super.setState(newState, time);
                this.setRenderContent(0, true, time);
            }
        }
    }

    private void setEnemyRetreat(byte newState, long time) {
        if (this.isAlive()) {
            super.setState(newState, time);
            this.isRetreat = true;
        }
    }

    private boolean isAlive() {
        return this.getState() != 5 && this.getState() != 7;
    }

    private boolean isDead() {
        return this.getState() == 5 && this.getState() == 7;
    }

    private void setExplode(long time) {
    }

    private void setUnderlingFarAtt(long time) {
        if (this.getSubType() == 0 || this.getSubType() == 13 || this.getSubType() == 20 || this.getSubType() == 21 || this.getSubType() == 22) {
            if (CMath.getRandNumber(0, 10) > 3) {
                this.lineatt = true;
                this.setRenderContent(0, true, time);
            } else {
                this.lineatt = false;
                this.setRenderContent(4, false, time);
            }
        } else if (this.getSubType() == 18 || this.getSubType() == 38 || this.getSubType() == 40) {
            this.lineatt = true;
            this.setRenderContent(0, true, time);
        } else if (this.getSubType() == 19) {
            this.lineatt = false;
            this.setRenderContent(4, false, time);
        } else {
            this.setRenderContent(4, false, time);
        }
    }

    private void selectAttackTypeSpiderII(long gameTime) {
        if (CMath.getRandNumber(0, 10) >= 5) {
            if (MainCanvas.getGameEngine().getPlayer().getState() != 5) {
                this.setMPosition((byte)1);
                this.setState((byte)1, gameTime);
            } else {
                this.selectTrackTypeSpiderII(gameTime);
            }
        } else {
            this.selectTrackTypeSpiderII(gameTime);
        }
    }

    private void selectTrackTypeSpiderII(long gameTime) {
        if (CMath.getRandNumber(0, 10) >= 5) {
            this.setMPosition((byte)0);
        } else {
            this.BossHeadGoalPosy = MainCanvas.getGameEngine().getPlayer().getY() >> 1;
            this.setMPosition((byte)2);
        }
        this.setState((byte)1, gameTime);
    }

    public void init(long gameTime, int type) {
        this.causeOfDeath = -1;
        this.SetInstanceId(-1);
        this.setType(type);
        this.aniPal = 0;
        this.setDropID(0);
        this.stopProcessing = false;
        this.mAlarmStayTime = 0L;
        switch (this.getSubType()) {
            case 42: {
                this.mWaitTime = 1000L;
                this.lastAttStatus = (byte)10;
                this.setLife(1200);
                this.isBeatedBack = false;
                this.bossHurtTime = 0;
                this.initBossBoom(gameTime);
                break;
            }
            case 24: {
                this.setLife(30);
                this.mWaitTime = 500L;
                this.mFarAttStayTime = 2000L;
                this.isFarAtted = false;
                this.attCount = 0;
                this.boom02Pif = MainCanvas.getGameEngine().boom02Pif;
                this.boomAnid = 0;
                break;
            }
            default: {
                this.setLife(150);
                this.mHurtStartTime = -1L;
                this.mWaitTime = 500L;
                this.mFarAttStayTime = 2000L;
                this.isFarAtted = false;
                this.attCount = 0;
                this.boom02Pif = MainCanvas.getGameEngine().boom02Pif;
                this.boomAnid = 0;
            }
        }
        this.bloodEffPif = MainCanvas.getGameEngine().bloodEffPif;
        this.bloodEff2Pif = MainCanvas.getGameEngine().bloodEff2Pif;
        this.bloodAnid = 1;
        this.setMaxlife(this.getLife());
        this.isReachedGoal = false;
        this.isDeadSelf = false;
        this.hitDamage = 4;
        this.isInSupperAtt = false;
        this.mToPosition = (byte)-1;
        this.isRetreat = false;
        this.wayPointsStep = 0;
        this.setBeenAttacked(false);
        this.setInUse(true);
        this.setState((byte)4, gameTime);
        this.setRelatePlayer(null);
    }

    private void initBossBoom(long gametime) {
        this.boom02Pif = MainCanvas.getGameEngine().boom02Pif;
        this.boomAnid = 0;
        this.boomStartTime2 = new long[5];
        this.bossBoomDiffX = new int[5];
        this.bossBoomDiffY = new int[5];
    }

    public void setRamdomBossBoomTime(long gametime) {
        for (int i2 = 0; i2 < this.boomStartTime2.length; ++i2) {
            this.boomStartTime2[i2] = gametime + (long)CMath.getRandNumber(-500, 500);
        }
    }

    public void drawBossBoom(Graphics g2, long gameTime) {
        for (int i2 = 0; i2 < this.boomStartTime2.length; ++i2) {
            this.boom02Pif.drawAnimation(g2, this.boomAnid, gameTime - this.boomStartTime2[i2], this.getX() - this.bossBoomDiffX[i2], this.getY() - this.bossBoomDiffY[i2], false);
        }
    }

    public static void resetEnemyUI() {
        EnemyBase.mUIUpdateTime = -1L;
        EnemyBase.mUILifeUpdateLevel = 0;
        EnemyBase.mUILifePercent = 10000;
    }

    private void updateUI(long gameTime) {
        if (gameTime - EnemyBase.mUIUpdateTime >= 1000L || EnemyBase.mUILifeUpdateLevel == 0) {
            EnemyBase.mUILifePercent = this.getLife() * 100 / this.getMaxlife();
            EnemyBase.mUILifeUpdateLevel = this.getLife() <= 0 ? (byte)1 : 0;
            EnemyBase.mUIUpdateTime = gameTime;
        }
    }

    public void setStartEndPos(int stx, int sty, int edx, int edy, int spd) {
        this.StartX = stx * 360 / 100;
        this.StartY = 36 + sty * 444 / 100;
        if (this.getSubType() == 0 || this.getSubType() == 1 || this.getSubType() == 16 || this.getSubType() == 14 || this.getSubType() == 15 || this.getSubType() == 17 || this.getSubType() == 18 || this.getSubType() == 19 || this.getSubType() == 8 || this.getSubType() == 13 || this.getSubType() == 20 || this.getSubType() == 21 || this.getSubType() == 22 || this.getSubType() == 2 || this.getSubType() == 24 || this.getSubType() == 27 || this.getSubType() == 25 || this.getSubType() == 28 || this.getSubType() == 29 || this.getSubType() == 30 || this.getSubType() == 23 || this.getSubType() == 33 || this.getSubType() == 34 || this.getSubType() == 35 || this.getSubType() == 36 || this.getSubType() == 37 || this.getSubType() == 38 || this.getSubType() == 40 || this.getSubType() == 41) {
            this.EndX = edx;
            this.EndY = edy;
        } else {
            this.EndX = edx * 360 / 100;
            this.EndY = 36 + edy * 444 / 100;
        }
        this.speed = spd;
        this.setX(this.StartX);
        this.setY(this.StartY);
    }

    public void setMPosition(byte position) {
        this.mPosition = position;
    }

    public void renderGameActor(Graphics g2, long gameTime) {
        if (this.getRelatePlayer() != null && this.getSubType() != 7 && this.getSubType() != 12 && (this.getRelatePlayer().getSubType() == 7 || this.getRelatePlayer().getSubType() == 12)) {
            return;
        }
        int oldPal = this.getAnimation().getPalette();
        this.getAnimation().setPalette(this.getAniPal());
        switch (this.getSubType()) {
            case 42: 
            case 44: {
                this.renderGameBossSword(g2, gameTime);
                break;
            }
            default: {
                this.renderGameUnderling(g2, gameTime);
            }
        }
        this.getAnimation().setPalette(oldPal);
    }

    public void renderGameBossDracula(Graphics g2, long gameTime) {
        switch (this.getState()) {
            case 9: {
                this.drawDirectLine(g2, gameTime);
                break;
            }
            default: {
                if (this.isOutHurtTime(gameTime)) {
                    this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
                    break;
                }
                if (gameTime % 1000L <= 50L) break;
                this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
            }
        }
        if (this.getState() == 4 && this.drawAlarm) {
            this.drawAlarm(g2, gameTime);
        }
        this.drawHitEffe(g2, gameTime);
        this.drawBlood2(g2, gameTime);
        if (this.getState() == 5) {
            this.drawBossBoom(g2, gameTime);
        }
    }

    private void drawDirectLine(Graphics g2, long gameTime) {
        ColRect bulletRect;
        this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
        if (this.animID != 3 && (bulletRect = this.getColRect(gameTime, 1)) != null) {
            int lx = this.getX() + bulletRect.x + (bulletRect.w >> 1);
            int ly = this.getY() + bulletRect.y + (bulletRect.h >> 1);
            this.drawLaser(g2, lx, ly, -3, ly);
        }
    }

    private void drawLaser(Graphics g2, int x1, int y1, int x2, int y2) {
        g2.setColor(16745472);
        g2.drawLine(x1, y1 - 3, x2, y2 - 3);
        g2.setColor(16745472);
        g2.drawLine(x1, y1 - 2, x2, y2 - 2);
        g2.setColor(0xFFFF00);
        g2.drawLine(x1, y1 - 1, x2, y2 - 1);
        g2.setColor(0xFFFF00);
        g2.drawLine(x1, y1, x2, y2);
        g2.setColor(0xFFFF00);
        g2.drawLine(x1, y1 + 1, x2, y2 + 1);
        g2.setColor(16745472);
        g2.drawLine(x1, y1 + 2, x2, y2 + 2);
        g2.setColor(16745472);
        g2.drawLine(x1, y1 + 3, x2, y2 + 3);
    }

    public void renderGameBossCyclops(Graphics g2, long gameTime) {
        switch (this.getState()) {
            case 9: {
                this.drawLineLaser(g2, gameTime);
                break;
            }
            default: {
                if (this.isOutHurtTime(gameTime)) {
                    this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
                    break;
                }
                if (gameTime % 1000L <= 50L) break;
                this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
            }
        }
        if (this.getState() == 4 && this.drawAlarm) {
            this.drawAlarm(g2, gameTime);
        }
        this.drawHitEffe(g2, gameTime);
        this.drawBlood2(g2, gameTime);
        if (this.getState() == 5) {
            this.drawBossBoom(g2, gameTime);
        }
    }

    private boolean isOutHurtTime(long gameTime) {
        return gameTime - this.mHurtStartTime > 1000L || this.mHurtStartTime == -1L;
    }

    public void renderGameBossGeneral(Graphics g2, long gameTime) {
        switch (this.getState()) {
            default: 
        }
        if (this.isOutHurtTime(gameTime)) {
            this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
        } else if (gameTime % 1000L > 50L) {
            this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
        }
        if (this.getState() == 4 && this.drawAlarm) {
            this.drawAlarm(g2, gameTime);
        }
        this.drawHitEffe(g2, gameTime);
        this.drawBlood2(g2, gameTime);
        if (this.getState() == 5) {
            this.drawBossBoom(g2, gameTime);
        }
    }

    public void renderGameBossGeneral1_2(Graphics g2, long gameTime) {
        switch (this.getState()) {
            default: 
        }
        if (this.isOutHurtTime(gameTime)) {
            this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
        } else if (gameTime % 1000L > 50L) {
            this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
        }
        if (this.getState() == 4 && this.drawAlarm) {
            this.drawAlarm(g2, gameTime);
        }
        this.drawHitEffe(g2, gameTime);
        this.drawBlood2(g2, gameTime);
    }

    public void renderGameBossSword(Graphics g2, long gameTime) {
        switch (this.getState()) {
            default: 
        }
        if (this.isOutHurtTime(gameTime)) {
            this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
        } else if (gameTime % 1000L > 50L) {
            this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
        }
        if (this.getState() == 4 && this.drawAlarm) {
            this.drawAlarm(g2, gameTime);
        }
        this.drawHitEffe(g2, gameTime);
        this.drawBlood2(g2, gameTime);
        if (this.getState() == 5) {
            this.drawBossBoom(g2, gameTime);
        }
    }

    public void renderGameBossFireLord(Graphics g2, long gameTime) {
        switch (this.getState()) {
            case 13: {
                this.animation.drawAnimation(g2, 11, gameTime - this.stateStartTime, this.BossHeadPosx, this.BossHeadPosy, true);
                this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
                break;
            }
            default: {
                if (this.isOutHurtTime(gameTime)) {
                    this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
                    break;
                }
                if (gameTime % 1000L <= 50L) break;
                this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
            }
        }
        if (this.getState() == 4 && this.animID == 1) {
            this.drawAlarm(g2, gameTime);
        }
        this.drawHitEffe(g2, gameTime);
        this.drawBlood2(g2, gameTime);
        if (this.getState() == 5) {
            this.drawBossBoom(g2, gameTime);
        }
    }

    private void drawboom(Graphics g2, long gameTime) {
        this.boom02Pif.drawAnimation(g2, this.boomAnid, gameTime - this.boomStartTime, this.getX() - this.boomDiffX, this.getY() - this.boomDiffY, false);
    }

    private void drawAlarm(Graphics g2, long gameTime) {
    }

    public void renderSpider(Graphics g2, long gameTime) {
        if (this.getRelatePlayer() != null) {
            this.getRelatePlayer().basicRenderGameActor(g2, gameTime);
        }
        this.drawSpiderLine(g2);
        this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
    }

    private void drawSpiderLine(Graphics g2) {
        g2.setColor(0xFFFFFF);
        g2.drawLine(this.getX(), 36, this.getX(), this.getY() - 10);
        g2.drawLine(this.getX() + 1, 36, this.getX() + 1, this.getY() - 10);
    }

    public void renderSpiderII(Graphics g2, long gameTime) {
        this.drawSpiderLine(g2);
        this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
        this.drawHitEffe(g2, gameTime);
        this.drawBlood2(g2, gameTime);
        if (this.getState() == 5) {
            this.drawboom(g2, gameTime);
        }
        this.drawIceEff(g2, gameTime);
    }

    private void drawHitEffe(Graphics g2, long gameTime) {
        if (!this.isBloodAnimationOver(gameTime)) {
            this.bloodEffPif.drawAnimation(g2, this.bloodAnid, gameTime - this.bloodStartTime, this.bloodX, this.bloodY, false);
        }
    }

    private void drawBlood2(Graphics g2, long gameTime) {
        if (!this.isBlood2AnimationOver(gameTime)) {
            this.bloodEff2Pif.drawAnimation(g2, 1, gameTime - this.bloodStartTime, this.bloodX, this.bloodY, false);
        }
    }

    public void renderCannibalPlant(Graphics g2, long gameTime) {
        if (this.getRelatePlayer() != null) {
            this.getRelatePlayer().basicRenderGameActor(g2, gameTime);
        }
        int midh = this.animation.GetAniFrameHeight(0, 0);
        for (int midy = this.getY() + midh; midy <= 480 + midh; midy += midh) {
            this.animation.drawAnimation(g2, 0, gameTime - this.stateStartTime, this.getX(), midy, this.animCyclic);
        }
        this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
    }

    public void renderGameBossThreeHead(Graphics g2, long gameTime) {
        switch (this.getState()) {
            case 12: {
                if (this.animID != 10) {
                    for (int i2 = 0; i2 < this.BossNeckPosx.length; ++i2) {
                        this.animation.drawAnimation(g2, 9, gameTime - this.stateStartTime, this.BossNeckPosx[i2], this.BossNeckPosy[i2], true);
                    }
                    this.animation.drawAnimation(g2, 8, gameTime - this.stateStartTime, this.BossHeadPosx, this.BossHeadPosy, true);
                }
                this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
                break;
            }
            default: {
                if (this.isOutHurtTime(gameTime)) {
                    this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
                    break;
                }
                if (gameTime % 1000L <= 50L) break;
                this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
            }
        }
        if (this.getState() == 4 && this.drawAlarm) {
            this.drawAlarm(g2, gameTime);
        }
        this.drawHitEffe(g2, gameTime);
        this.drawBlood2(g2, gameTime);
        if (this.getState() == 5) {
            this.drawBossBoom(g2, gameTime);
        }
    }

    public void renderGameCaneUp(Graphics g2, long gameTime) {
        int headh = this.animation.GetAniFrameHeight(0, 0);
        int midh = this.animation.GetAniFrameHeight(1, 0);
        int lefth = this.animation.GetAniFrameWidth(6, 0);
        if (this.getState() == 2) {
            for (int leftoffy = this.getY() - lefth; leftoffy > 36; leftoffy -= lefth) {
                this.animation.drawAnimation(g2, 6, gameTime, this.getX(), leftoffy, this.animCyclic);
                this.animation.drawAnimation(g2, 7, gameTime, this.getX(), leftoffy, this.animCyclic);
            }
        }
        for (int midoffy = this.getY() - headh; midoffy > 36; midoffy -= midh) {
            this.animation.drawAnimation(g2, 1, gameTime, this.getX(), midoffy, this.animCyclic);
        }
        this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
    }

    public void renderGameEye(Graphics g2, long gameTime) {
        switch (this.getState()) {
            case 3: {
                this.drawDirectLine(g2, gameTime);
                break;
            }
            case 4: {
                this.drawDirectLine(g2, gameTime);
                break;
            }
            default: {
                if (this.isOutHurtTime(gameTime)) {
                    this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
                    break;
                }
                if (gameTime % 1000L <= 50L) break;
                this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
            }
        }
        this.drawHitEffe(g2, gameTime);
        this.drawBlood2(g2, gameTime);
        if (this.getState() == 5 && this.animID != 7) {
            this.drawboom(g2, gameTime);
        }
        this.drawIceEff(g2, gameTime);
    }

    private void drawLineLaser(Graphics g2, long gameTime) {
        ColRect bulletRect = this.getColRect(gameTime, 1);
        if (bulletRect != null) {
            int lx = this.getX() + bulletRect.x + (bulletRect.w >> 1);
            int ly = this.getY() + bulletRect.y + (bulletRect.h >> 1);
            this.drawLaser(g2, lx, ly, -3, this.BossHeadGoalPosy);
        }
        this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
    }

    public void renderGameCaneButtom(Graphics g2, long gameTime) {
        int headh = this.animation.GetAniFrameHeight(3, 0);
        int midh = this.animation.GetAniFrameHeight(4, 0);
        int lefth = this.animation.GetAniFrameWidth(6, 0);
        if (this.getState() == 2) {
            for (int leftoffy = this.getY() + lefth; leftoffy < 480; leftoffy += lefth) {
                this.animation.drawAnimation(g2, 6, gameTime, this.getX(), leftoffy, this.animCyclic);
                this.animation.drawAnimation(g2, 7, gameTime, this.getX(), leftoffy, this.animCyclic);
            }
        }
        for (int midoffy = this.getY() + headh; midoffy < 480; midoffy += midh) {
            this.animation.drawAnimation(g2, 4, gameTime, this.getX(), midoffy, this.animCyclic);
        }
        this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
    }

    public void renderGameUnderling(Graphics g2, long gameTime) {
        if (this.isOutHurtTime(gameTime)) {
            this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
        } else if (gameTime % 1000L > 50L) {
            this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
        }
        this.drawHitEffe(g2, gameTime);
        this.drawBlood2(g2, gameTime);
        if (this.getState() == 5 && this.animID != 7) {
            this.drawboom(g2, gameTime);
        }
        this.drawIceEff(g2, gameTime);
    }

    private void drawIceEff(Graphics g2, long gameTime) {
    }

    public void reduceLife(int reducePoint, int type, ColRect rc, long gametime) {
        if (this.getSubType() == 5 || this.getSubType() == 6 || this.getSubType() == 7) {
            return;
        }
        if (this.getSubType() == 31) {
            if (type == 1 || type == 2 || type == 3 || type == 4) {
                this.setInUse(false);
            }
            return;
        }
        if (this.getState() == 4 && (this.getSubType() == 4 || this.getSubType() == 3 || this.getSubType() == 26 || this.getSubType() == 32 || this.getSubType() == 42 || this.getSubType() == 39 || this.getSubType() == 43 || this.getSubType() == 45 || this.getSubType() == 46)) {
            return;
        }
        if (this.getSubType() == 3 && (this.getState() == 5 || this.getState() == 7 || this.getState() == 18)) {
            return;
        }
        if (this.getState() == 5 || this.getState() == 7) {
            return;
        }
        if (this.getSubType() != 44) {
            this.setLife(this.getLife() - reducePoint);
        }
        if (this.getLife() <= 0) {
            this.setLife(0);
            this.causeOfDeath = type;
            this.setState((byte)5, gametime);
        } else {
            this.mHurtStartTime = gametime;
            switch (this.getSubType()) {
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: {
                    this.setNoHurtBoss(gametime, type, rc);
                    break;
                }
                default: {
                    this.setHurtUnderling(gametime, type, rc);
                }
            }
        }
        switch (this.getSubType()) {
            case 3: 
            case 4: 
            case 26: 
            case 32: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                break;
            }
            default: {
                this.updateUI(gametime);
            }
        }
    }

    private void setHurtBossThreeHeead(long gametime, int type, ColRect rc) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (this.getState() == 0) {
                    this.setBeenAttacked(true);
                    this.isBeatedBack = true;
                    this.setState((byte)16, gametime);
                }
                if (rc != null) {
                    this.bloodX = this.getX() + rc.x + (rc.w >> 1);
                    this.bloodY = this.getY() + rc.y + (rc.h >> 1);
                } else {
                    this.bloodX = this.getX();
                    this.bloodY = this.getY();
                }
                this.bloodStartTime = gametime;
                break;
            }
            case 9: {
                if (this.getState() != 0) break;
                this.setBeenAttacked(true);
                this.isBeatedBack = true;
                this.setState((byte)16, gametime);
            }
        }
        if (this.isAlive() && this.getState() != 11 && this.getLife() * 100 / this.getMaxlife() <= 30) {
            this.setState((byte)11, gametime);
        }
    }

    private void setHurtBossFireLord(long gametime, int type, ColRect rc) {
        int beatbackoffx = 0;
        int beatbackoffy = 0;
        this.BeatBackSpeed = 1;
        switch (type) {
            case 1: {
                beatbackoffx = 3;
                this.BeatBackSpeed = 1;
                this.bloodAnid = 1;
                break;
            }
            case 2: {
                beatbackoffx = 3;
                this.BeatBackSpeed = 1;
                this.bloodAnid = 1;
                break;
            }
            case 3: {
                beatbackoffx = 3;
                this.BeatBackSpeed = 1;
                this.bloodAnid = 1;
                break;
            }
            case 4: {
                beatbackoffx = 72;
                beatbackoffy = CMath.getRandNumber(-20, 20);
                this.BeatBackSpeed = 4;
                this.bloodAnid = 1;
            }
        }
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                ++this.bossHurtTime;
                this.setNormalBeenHitted(gametime, rc, beatbackoffx, beatbackoffy);
                if (this.bossHurtTime >= 12) break;
                this.mStayStartTime = gametime;
                this.setState((byte)16, gametime);
                break;
            }
            case 9: {
                this.setBeenAttacked(true);
                this.FarPositionX = this.getX();
                this.BeatBackX = this.getX() + beatbackoffx;
                this.BeatBackY = this.getY() + beatbackoffy;
                ColRect selfrc = this.getColRect(gametime, 0);
                if (selfrc != null) {
                    this.bloodX = this.getX() + selfrc.x + (selfrc.w >> 1);
                    this.bloodY = this.getY() + selfrc.y + (selfrc.h >> 1);
                } else {
                    this.bloodX = this.getX();
                    this.bloodY = this.getY();
                }
                this.mStayStartTime = gametime;
                this.setState((byte)16, gametime);
            }
        }
    }

    private void setNoHurtBoss(long gametime, int type, ColRect rc) {
        int beatbackoffx = 0;
        int beatbackoffy = 0;
        this.BeatBackSpeed = 1;
        switch (type) {
            case 1: {
                beatbackoffx = 3;
                this.BeatBackSpeed = 1;
                this.bloodAnid = 1;
                break;
            }
            case 2: {
                beatbackoffx = 3;
                this.BeatBackSpeed = 1;
                this.bloodAnid = 1;
                break;
            }
            case 3: {
                beatbackoffx = 3;
                this.BeatBackSpeed = 1;
                this.bloodAnid = 1;
                break;
            }
            case 4: {
                beatbackoffx = 72;
                beatbackoffy = CMath.getRandNumber(-20, 20);
                this.BeatBackSpeed = 4;
                this.bloodAnid = 1;
            }
        }
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.setBeenAttacked(true);
                if (rc != null) {
                    this.bloodX = rc.x + (rc.w >> 1);
                    this.bloodY = rc.y + (rc.h >> 1);
                } else {
                    ColRect selfrc = this.getColRect(gametime, 0);
                    if (selfrc != null) {
                        this.bloodX = this.getX() + selfrc.x + (selfrc.w >> 1);
                        this.bloodY = this.getY() + selfrc.y + (selfrc.h >> 1);
                    } else {
                        this.bloodX = this.getX();
                        this.bloodY = this.getY();
                    }
                }
                this.BeatBackX = this.getX() + beatbackoffx;
                this.BeatBackY = this.getY() + beatbackoffy;
                this.bloodStartTime = gametime;
                break;
            }
            case 9: {
                this.setBeenAttacked(true);
                ColRect selfrc = this.getColRect(gametime, 0);
                if (selfrc != null) {
                    this.bloodX = this.getX() + selfrc.x + (selfrc.w >> 1);
                    this.bloodY = this.getY() + selfrc.y + (selfrc.h >> 1);
                } else {
                    this.bloodX = this.getX();
                    this.bloodY = this.getY();
                }
                this.bloodStartTime = gametime;
            }
        }
    }

    private void setHurtUnderling(long gametime, int type, ColRect rc) {
        int beatbackoffx = 0;
        int beatbackoffy = 0;
        this.BeatBackSpeed = 1;
        switch (type) {
            case 1: {
                beatbackoffx = 3;
                this.BeatBackSpeed = 1;
                this.bloodAnid = 1;
                break;
            }
            case 2: {
                beatbackoffx = 3;
                this.BeatBackSpeed = 1;
                this.bloodAnid = 1;
                break;
            }
            case 3: {
                beatbackoffx = 3;
                this.BeatBackSpeed = 1;
                this.bloodAnid = 1;
                break;
            }
            case 4: {
                beatbackoffx = 72;
                beatbackoffy = CMath.getRandNumber(-20, 20);
                this.BeatBackSpeed = 4;
                this.bloodAnid = 1;
            }
        }
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.setNormalBeenHitted(gametime, rc, beatbackoffx, beatbackoffy);
                this.mStayStartTime = gametime;
                this.setState((byte)16, gametime);
                break;
            }
            case 9: {
                this.setBeenAttacked(true);
                this.FarPositionX = this.getX();
                this.BeatBackX = this.getX() + beatbackoffx;
                this.BeatBackY = this.getY() + beatbackoffy;
                ColRect selfrc = this.getColRect(gametime, 0);
                if (selfrc != null) {
                    this.bloodX = this.getX() + selfrc.x + (selfrc.w >> 1);
                    this.bloodY = this.getY() + selfrc.y + (selfrc.h >> 1);
                } else {
                    this.bloodX = this.getX();
                    this.bloodY = this.getY();
                }
                this.mStayStartTime = gametime;
                this.setState((byte)16, gametime);
            }
        }
    }

    private void setNormalBeenHitted(long gametime, ColRect rc, int beatbackoffx, int beatbackoffy) {
        ColRect selfrc;
        this.setBeenAttacked(true);
        if (rc != null) {
            this.FarPositionX = this.getX() + rc.w * CMath.getRandNumber(1, 3);
            this.bloodX = rc.x + (rc.w >> 1);
            this.bloodY = rc.y + (rc.h >> 1);
        } else {
            this.FarPositionX = this.getX();
            selfrc = this.getColRect(gametime, 0);
            if (selfrc != null) {
                this.bloodX = this.getX() + selfrc.x + (selfrc.w >> 1);
                this.bloodY = this.getY() + selfrc.y + (selfrc.h >> 1);
            } else {
                this.bloodX = this.getX();
                this.bloodY = this.getY();
            }
        }
        this.BeatBackX = this.getX() + beatbackoffx;
        this.BeatBackY = this.getY() + beatbackoffy;
        selfrc = this.getColRect(gametime, 0);
        this.FarPositionY = selfrc != null && rc != null ? this.getY() + (this.getY() + selfrc.y + (selfrc.h >> 1) - (rc.y + (rc.h >> 1))) : this.getY();
    }

    public void setRetreat(long gameTime, int edx, int edy) {
        this.setState((byte)15, gameTime);
        this.EndX = edx;
        this.EndY = edy;
        this.isRetreat = true;
    }

    protected boolean isBloodAnimationOver(long gameTime) {
        return this.bloodEffPif.animationIsOver(this.bloodAnid, (int)(gameTime - this.bloodStartTime));
    }

    protected boolean isBlood2AnimationOver(long gameTime) {
        return this.bloodEff2Pif.animationIsOver(1, (int)(gameTime - this.bloodStartTime));
    }

    protected boolean isBoomAnimationOver(long gameTime) {
        return this.boom02Pif.animationIsOver(this.boomAnid, (int)(gameTime - this.boomStartTime));
    }

    public static boolean LineRectIntersect(int x1, int y1, int x2, int y2, GameActor actor, ColRect cr) {
        int res1 = ColRect.LineIntersect(x1, y1, x2, y2, actor.getX() + cr.x, actor.getY() + cr.y, actor.getX() + cr.x + cr.w, actor.getY() + cr.y);
        int res2 = ColRect.LineIntersect(x1, y1, x2, y2, actor.getX() + cr.x + cr.w, actor.getY() + cr.y, actor.getX() + cr.x + cr.w, actor.getY() + cr.y + cr.h);
        int res3 = ColRect.LineIntersect(x1, y1, x2, y2, actor.getX() + cr.x, actor.getY() + cr.y + cr.h, actor.getX() + cr.x + cr.w, actor.getY() + cr.y + cr.h);
        int res4 = ColRect.LineIntersect(x1, y1, x2, y2, actor.getX() + cr.x, actor.getY() + cr.y, actor.getX() + cr.x, actor.getY() + cr.y + cr.h);
        if (2 == res1 && 2 == res2 && 2 == res3 && 2 == res4) {
            return actor.getX() + cr.x < x1 && x1 < actor.getX() + cr.x + cr.w && actor.getY() + cr.y < y1 && y1 < actor.getY() + cr.y + cr.h && actor.getX() + cr.x < x2 && x2 < actor.getX() + cr.x + cr.w && actor.getY() + cr.y < y2 && y2 < actor.getY() + cr.y + cr.h;
        }
        return true;
    }

    public int getSpeed2() {
        if (this.speed2 > 0) {
            return this.speed2;
        }
        return this.speed;
    }

    public int getAniPal() {
        if (this.lv - 1 <= 0) {
            return 0;
        }
        return this.lv - 1;
    }

    public void setAniPal(int aniPal) {
        this.aniPal = aniPal;
    }

    public void setDropID(int dropID) {
        this.dropID = dropID;
    }
}

