/*
 * Decompiled with CFR 0.152.
 */
package z.playw.DragonGuardian;

import java.util.Random;

public class CMath {
    private static Random rnd = new Random(System.currentTimeMillis());
    public static final int[] SIN_TABLE = new int[]{0, 1143, 2287, 3429, 4571, 5711, 6850, 7986, 9120, 10252, 11380, 12504, 13625, 14742, 15854, 16961, 18064, 19160, 20251, 21336, 22414, 23486, 24550, 25606, 26655, 27696, 28729, 29752, 30767, 31772, Short.MAX_VALUE, 33753, 34728, 35693, 36647, 37589, 38521, 39440, 40347, 41243, 42125, 42995, 43852, 44695, 45525, 46340, 47142, 47929, 48702, 49460, 50203, 50931, 51643, 52339, 53019, 53683, 54331, 54963, 55577, 56175, 56755, 57319, 57864, 58393, 58903, 59395, 59870, 60326, 60763, 61183, 61583, 61965, 62328, 62672, 62997, 63302, 63589, 63856, 64103, 64331, 64540, 64729, 64898, 65047, 65176, 65286, 65376, 65446, 65496, 65526, 65536};
    public static final int[] COS_TABLE = new int[]{65536, 65526, 65496, 65446, 65376, 65286, 65176, 65047, 64898, 64729, 64540, 64331, 64103, 63856, 63589, 63302, 62997, 62672, 62328, 61965, 61583, 61183, 60763, 60326, 59870, 59395, 58903, 58393, 57864, 57319, 56755, 56175, 55577, 54963, 54331, 53683, 53019, 52339, 51643, 50931, 50203, 49460, 48702, 47929, 47142, 46340, 45525, 44695, 43852, 42995, 42125, 41243, 40347, 39440, 38521, 37589, 36647, 35693, 34728, 33753, 32768, 31772, 30767, 29752, 28729, 27696, 26655, 25606, 24550, 23486, 22414, 21336, 20251, 19160, 18064, 16961, 15854, 14742, 13625, 12504, 11380, 10252, 9120, 7986, 6850, 5711, 4571, 3429, 2287, 1143, 0};
    public static final int[] TAN_TABLE = new int[]{0, 1143, 2288, 3434, 4582, 5733, 6888, 8046, 9210, 10379, 11555, 12738, 13930, 15130, 16339, 17560, 18792, 20036, 21293, 22565, 23853, 25156, 26478, 27818, 29178, 30559, 31964, 33392, 34846, 36327, 37837, 39378, 40951, 42559, 44204, 45888, 47614, 49384, 51202, 53070, 54991, 56969, 59008, 61113, 63287, 65535, 67864, 70278, 72785, 75390, 78102, 80930, 83882, 86969, 90202, 93595, 97161, 100916, 104879, 109070, 113511, 118230, 123255, 128621, 134368, 140542, 147196, 154393, 162207, 170727, 180058, 190330, 201699, 214358, 228551, 244583, 262850, 283867, 308322, 337153, 371673, 413778, 466312, 533747, 623533, 749079, 937208, 1250501, 1876705, 3754554, -1};

    public static int I2F(int x2) {
        return x2 << 16;
    }

    public static int F2I(int x2) {
        return x2 >> 16;
    }

    public static final int getRandNumber(int min, int max) {
        int r2 = Math.abs(rnd.nextInt());
        return r2 % (max - min + 1) + min;
    }

    public static long fastDivBy2(long aValue, int n2) {
        long value = aValue >> n2;
        return value;
    }

    public static long fastMultBy2(long aValue, int n2) {
        long value = aValue << n2;
        return value;
    }

    public static int sin(int degreeP) {
        int sig = 1;
        if ((degreeP %= 360) < 0) {
            degreeP = 360 + degreeP;
        }
        if (degreeP > 90 && degreeP <= 180) {
            sig = 1;
            degreeP = 180 - degreeP;
        } else if (degreeP > 180 && degreeP <= 270) {
            sig = -1;
            degreeP -= 180;
        } else if (degreeP > 270 && degreeP <= 360) {
            degreeP = 360 - degreeP;
            sig = -1;
        }
        return sig * SIN_TABLE[degreeP];
    }

    public static int cos(int degreeP) {
        int sig = 1;
        if ((degreeP %= 360) < 0) {
            degreeP = 360 + degreeP;
        }
        if (degreeP > 90 && degreeP <= 180) {
            sig = -1;
            degreeP = 180 - degreeP;
        } else if (degreeP > 180 && degreeP <= 270) {
            sig = -1;
            degreeP -= 180;
        } else if (degreeP > 270 && degreeP <= 360) {
            sig = 1;
            degreeP = 360 - degreeP;
        }
        return sig * COS_TABLE[degreeP];
    }

    public static int tan(int degreeP) {
        int sig = 1;
        if ((degreeP %= 360) < 0) {
            degreeP = 360 + degreeP;
        }
        if (degreeP > 90 && degreeP <= 180) {
            sig = -1;
            degreeP = 180 - degreeP;
        } else if (degreeP > 180 && degreeP <= 270) {
            sig = 1;
            degreeP -= 180;
        } else if (degreeP > 270 && degreeP <= 360) {
            sig = -1;
            degreeP = 360 - degreeP;
        }
        if (degreeP > 88) {
            return -1;
        }
        return sig * TAN_TABLE[degreeP];
    }

    public static int atan(long difY, long difX) {
        int result = 0;
        result = difY == 0L ? 0 : (difX == 0L ? 90 : CMath.atan((Math.abs(difY) << 16) / Math.abs(difX)));
        if (difY > 0L) {
            if (difX > 0L) {
                return result;
            }
            return 180 - result;
        }
        if (difX > 0L) {
            return 360 - result;
        }
        return 180 + result;
    }

    private static int atan(long tan) {
        for (int l2 = 0; l2 < 89; ++l2) {
            if (tan < (long)TAN_TABLE[l2] || tan >= (long)TAN_TABLE[l2 + 1]) continue;
            return l2;
        }
        if (tan >= (long)TAN_TABLE[89]) {
            return 89;
        }
        return 45;
    }

    public static final long sqrt(long val) {
        long g2 = 0L;
        long b2 = 32768L;
        long bshft = 15L;
        do {
            long temp;
            if (val < (temp = (g2 << 1) + b2 << (int)bshft--)) continue;
            g2 += b2;
            val -= temp;
        } while ((b2 >>= 1) > 0L);
        return (int)g2;
    }

    public static long newtonSqrt(long input) {
        int n2 = 5;
        int digitLength = String.valueOf(input).length();
        int digitOut = digitLength - n2;
        long mul = 1L;
        long div = 1L;
        if (digitOut > 1) {
            if (digitOut % 2 != 0) {
                ++digitOut;
            }
            div = CMath.getExp(digitOut);
            mul = CMath.getExp(digitOut / 2);
        }
        long x2 = 1L;
        long fx = x2 * x2 - (input /= div);
        for (int i2 = 0; i2 < 10; ++i2) {
            x2 -= fx / (2L * x2);
            fx = x2 * x2 - input;
        }
        return x2 * mul;
    }

    public static long module(long x2, long y2) {
        boolean digitOut = false;
        long sumSqr = x2 * x2 + y2 * y2;
        if (sumSqr == 0L) {
            return 0L;
        }
        return CMath.newtonSqrt(x2 * x2 + y2 * y2);
    }

    public static long getExp(int digitNumber) {
        long exp = 1L;
        for (int i2 = 1; i2 < digitNumber + 1; ++i2) {
            exp *= 10L;
        }
        return exp;
    }
}

