/*
 * Decompiled with CFR 0.152.
 */
package z.playw.j2me.graphics;

import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import z.playw.j2me.graphics.ColRectType;

public class ColRect {
    public static final byte PARALLEL = 0;
    public static final byte COINCIDENT = 1;
    public static final byte NOT_INTERESECTING = 2;
    public static final byte INTERESECTING = 3;
    public static final byte FACE_LEFT = 0;
    public static final byte FACE_RIGHT = 1;
    public static final byte CORE_INSIDE = 0;
    public static final byte CORE_INTERSECT = 1;
    public static final byte CORE_OUTSIDE = 2;
    private byte val;
    public int x;
    public int y;
    public int w;
    public int h;
    public byte line_or_rect;
    public static final int COLLISION_NUM = 10;
    private static int CRASH_X_OFFSET = 0;

    public static int LineIntersect(int line1_x1, int line1_y1, int line1_x2, int line1_y2, int line2_x1, int line2_y1, int line2_x2, int line2_y2) {
        int denom = (line2_y2 - line2_y1) * (line1_x2 - line1_x1) - (line2_x2 - line2_x1) * (line1_y2 - line1_y1);
        int nume_a = (line2_x2 - line2_x1) * (line1_y1 - line2_y1) - (line2_y2 - line2_y1) * (line1_x1 - line2_x1);
        int nume_b = (line1_x2 - line1_x1) * (line1_y1 - line2_y1) - (line1_y2 - line1_y1) * (line1_x1 - line2_x1);
        if (0 == denom) {
            if (0 == nume_a && 0 == nume_b) {
                return 3;
            }
            return 2;
        }
        if (0 == nume_a && 0 == nume_b) {
            return 3;
        }
        if (0 == nume_a) {
            int ubd = denom / nume_b;
            if (ubd >= 1) {
                return 3;
            }
            return 2;
        }
        if (0 == nume_b) {
            int uad = denom / nume_a;
            if (uad >= 1) {
                return 3;
            }
            return 2;
        }
        int ubd = denom / nume_b;
        int uad = denom / nume_a;
        if (uad >= 1 && ubd >= 1) {
            return 3;
        }
        return 2;
    }

    public static boolean LineRectIntersect(int x1, int y1, int x2, int y2, ColRect cr) {
        int res1 = ColRect.LineIntersect(x1, y1, x2, y2, cr.x, cr.y, cr.x + cr.w, cr.y);
        int res2 = ColRect.LineIntersect(x1, y1, x2, y2, cr.x + cr.w, cr.y, cr.x + cr.w, cr.y + cr.h);
        int res3 = ColRect.LineIntersect(x1, y1, x2, y2, cr.x, cr.y + cr.h, cr.x + cr.w, cr.y + cr.h);
        int res4 = ColRect.LineIntersect(x1, y1, x2, y2, cr.x, cr.y, cr.x, cr.y + cr.h);
        if (2 == res1 && 2 == res2 && 2 == res3 && 2 == res4) {
            return cr.x < x1 && x1 < cr.x + cr.w && cr.y < y1 && y1 < cr.y + cr.h && cr.x < x2 && x2 < cr.x + cr.w && cr.y < y2 && y2 < cr.y + cr.h;
        }
        return true;
    }

    public static boolean RectIntersect(ColRect cr1, ColRect cr2) {
        ColRect max_y_col_rect;
        if (cr1 == null || cr2 == null || cr1.w == 0 || cr2.w == 0) {
            return false;
        }
        ColRect min_x_col_rect = cr1.x < cr2.x ? cr1 : cr2;
        ColRect max_x_col_rect = cr1.x > cr2.x ? cr1 : cr2;
        ColRect min_y_col_rect = cr1.y < cr2.y ? cr1 : cr2;
        ColRect colRect = max_y_col_rect = cr1.y > cr2.y ? cr1 : cr2;
        if (max_x_col_rect.x > min_x_col_rect.x + min_x_col_rect.w) {
            return false;
        }
        return max_y_col_rect.y <= min_y_col_rect.y + min_y_col_rect.h;
    }

    public static int GetLineFace(ColRect line) {
        if (line.line_or_rect != 0) {
            return -1;
        }
        if (line.x < line.w) {
            if (line.y < line.h) {
                return 1;
            }
            return 0;
        }
        if (line.y < line.h) {
            return 0;
        }
        return 1;
    }

    public static int GetXTouchArea(ColRect up, ColRect down) {
        int lx = up.x < down.x ? down.x : up.x;
        int rx = up.x + up.w < down.x + down.w ? up.x + up.w : down.x + down.w;
        return rx - lx + 1;
    }

    public static int GetIntersectPos(ColRect cr, int line_x1, int line_x2) {
        if (cr.x > line_x1 && cr.x + cr.w < line_x2) {
            return 0;
        }
        if (cr.x > line_x2 || cr.x + cr.w < line_x1) {
            return 2;
        }
        return 1;
    }

    public static int GetLineY(int x1, int y1, int x2, int y2, int x3) {
        if (x1 == x2) {
            return y1;
        }
        return (y2 - y1) / (x2 - x1) * (x3 - x1) + y1;
    }

    public void ReadData(DataInputStream dis) {
        try {
            this.x = dis.readShort();
            this.y = dis.readShort();
            this.w = dis.readShort();
            this.h = dis.readShort();
            this.val = dis.readByte();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public int GetVal() {
        return this.val;
    }

    public void Copy(int x_, int y_, int w_, int h_) {
        this.x = (short)x_;
        this.y = (short)y_;
        this.w = (short)w_;
        this.h = (short)h_;
    }

    public void Copy(int ox, int oy, ColRect cr) {
        if (cr == null) {
            this.x = -1;
            this.y = -1;
            this.w = 0;
            this.h = 0;
            this.val = 0;
            this.line_or_rect = 0;
        } else {
            this.x = ox + cr.x;
            this.y = oy + cr.y;
            if (0 == cr.line_or_rect) {
                this.w = (short)(ox + cr.w);
                this.h = (short)(oy + cr.h);
            } else {
                this.w = cr.w;
                this.h = cr.h;
            }
            this.val = cr.val;
            this.line_or_rect = cr.line_or_rect;
        }
    }

    public boolean IsCrash(ColRect cr) {
        if (0 == this.line_or_rect) {
            if (1 == cr.line_or_rect) {
                return ColRect.LineRectIntersect(this.x, this.y, this.w, this.h, cr);
            }
        } else {
            if (0 == cr.line_or_rect) {
                return ColRect.LineRectIntersect(cr.x, cr.y, cr.w, cr.h, this);
            }
            return ColRect.RectIntersect(this, cr);
        }
        return false;
    }

    public boolean IsCrash(ColRect cr, int vx1, int vy1, int vx2, int vy2) {
        CRASH_X_OFFSET = 0;
        int x_save = this.x;
        int y_save = this.y;
        int w_save = this.w;
        int h_save = this.h;
        int cr_x_save = cr.x;
        int cr_y_save = cr.y;
        int cr_w_save = cr.w;
        int cr_h_save = cr.h;
        boolean res = false;
        vx1 *= 10;
        vy1 *= 10;
        vx2 *= 10;
        vy2 *= 10;
        this.x *= 10;
        this.y *= 10;
        this.w *= 10;
        this.h *= 10;
        cr.x *= 10;
        cr.y *= 10;
        cr.w *= 10;
        cr.h *= 10;
        for (int i2 = 0; i2 < 10; ++i2) {
            this.x += vx1 / 10;
            this.y += vy1 / 10;
            cr.x += vx2 / 10;
            cr.y += vy2 / 10;
            CRASH_X_OFFSET += vx1 / 10;
            if (!this.IsCrash(cr)) continue;
            res = true;
            break;
        }
        this.x = x_save;
        this.y = y_save;
        this.w = w_save;
        this.h = h_save;
        cr.x = cr_x_save;
        cr.y = cr_y_save;
        cr.w = cr_w_save;
        cr.h = cr_h_save;
        return res;
    }

    public int GetCrashXOffset(ColRect cr, int vx1, int vy1, int vx2, int vy2) {
        return CRASH_X_OFFSET / 10;
    }

    public void Draw(Graphics g2, int x_, int y_) {
        g2.setColor(ColRectType.COL_RECT_TYPE_COL[this.val]);
        if (0 == this.line_or_rect) {
            int min_x = this.x < this.w ? this.x : this.w;
            int min_y = this.y < this.h ? this.y : this.h;
            int max_x = this.x > this.w ? this.x : this.w;
            int max_y = this.y > this.h ? this.y : this.h;
            g2.drawLine(x_ + this.x, y_ + this.y, x_ + this.w, y_ + this.h);
        } else {
            g2.drawRect(x_ + this.x, y_ + this.y, this.w, this.h);
        }
    }

    public void DebugOutput() {
        System.out.println("------------------------Col Rect Debug Output----------------------");
        if (0 == this.line_or_rect) {
            System.out.println("------------------------------Line---------------------------------");
            System.out.println("x1: " + this.x);
            System.out.println("y1: " + this.y);
            System.out.println("x2: " + this.w);
            System.out.println("y2: " + this.h);
        } else {
            System.out.println("------------------------------Rect---------------------------------");
            System.out.println("x: " + this.x);
            System.out.println("y: " + this.y);
            System.out.println("w: " + this.w);
            System.out.println("h: " + this.h);
        }
        System.out.println("val: " + this.val);
        System.out.println("-------------------------------------------------------------------");
    }
}

