/*
 * Decompiled with CFR 0.152.
 */
package z.playw.DragonGuardian;

import javax.microedition.lcdui.Graphics;
import z.playw.DragonGuardian.CMath;
import z.playw.DragonGuardian.GameBonus;
import z.playw.DragonGuardian.GameEngine;
import z.playw.DragonGuardian.MainCanvas;
import z.playw.j2me.graphics.ColRect;
import z.playw.j2me.graphics.PWPifLifeAnimations;

public abstract class GameActor {
    protected int type;
    public static final int UNKNOWN = -1;
    public static final int PLAYER = 0;
    public static final int ENEMY = 1;
    public static final int BOSS_THREE_HEAD_BURN = 2;
    public static final int BOSS_THREE_HEAD_NORMAL = 3;
    public static final int BULLET_BIG_BOMB = 4;
    public static final int BULLET_STAY_BURN = 5;
    public static final int BULLET_SHORTGUN_VENOM = 6;
    public static final int BULLET_SPIDER_WEB = 7;
    public static final int BULLET_BOSSS_BAT = 8;
    public static final int BULLET_BOSS_SWORD_ATT = 9;
    public static final int HURT_BY_THROW = 0;
    public static final int HURT_BY_PLAYER_HIT0 = 1;
    public static final int HURT_BY_PLAYER_HIT1 = 2;
    public static final int HURT_BY_PLAYER_HIT2 = 3;
    public static final int HURT_BY_PLAYER_HIT3 = 4;
    public static final int HURT_BY_ENEMY_HIT = 5;
    public static final int HURT_BY_BOSS_THREE_HEAD_ATTRACT = 6;
    public static final int HURT_BY_ROCK_RIGHT = 7;
    public static final int HURT_BY_ROCK_TOP = 8;
    public static final int HURT_BY_SUPER_ATT = 9;
    public static final int HURT_BY_SPIDER_HIT = 10;
    public static final int HURT_BY_CANNIBALPLANT = 11;
    public static final int HURT_BY_VENOM = 12;
    public static final int HURT_BY_ATT_DEAD = 13;
    public static final int SUPER_ATTACK_PLAYER_FIRE_STONE_STORM = 0;
    public static final int SUPER_ATTACK_PLAYER_SPLITTER = 1;
    public static final int SUPER_ATTACK_BOSS_THREE_HEAD = 2;
    public static final int SUPER_ATTACK_PLAYER_ICE_STORM = 3;
    public static final int SUPER_ATTACK_PLAYER_LIGHT_DRAGON = 4;
    public static final int SUPER_ATTACK_PLAYER_LEVEL_UP = 5;
    public static final int SUPER_ATTACK_PLAYER_DEAD = 6;
    public static final int SUPER_ATTACK_SPIDER_CATCH = 7;
    public static final int SUPER_ATTACK_SPIDER_WEB_CATCH = 8;
    public static final int SUPER_ATTACK_CANNIBALPLANT_CATCH = 9;
    protected int x;
    protected int y;
    protected int lastX;
    protected int lastY;
    protected int vx;
    protected int vy;
    protected int ax;
    protected int ay;
    private int life;
    private int maxlife;
    protected boolean inUse;
    protected byte state;
    protected long stateStartTime;
    protected PWPifLifeAnimations animation;
    protected int animID;
    protected boolean animCyclic;
    protected int lastStateId;
    protected byte lastState;
    protected boolean lastStateAnimCyclic;
    public PWPifLifeAnimations hitfontPif;
    public int[] hitNumber;
    public long hitNumberStartTime;
    protected short mInstanceId = (short)-1;
    protected int subType;
    protected GameActor relatePlayer;
    protected int powerNewton;
    public boolean stopProcessing;
    public static long stopProcessingTime;
    public static int playerHitLevel;
    public static ColRect crSelf;
    public static ColRect crOther;

    public int GetInstanceId() {
        return this.mInstanceId;
    }

    public void SetInstanceId(int id) {
        this.mInstanceId = (short)id;
    }

    public byte getState() {
        return this.state;
    }

    public void setState(byte newState, long time) {
        this.state = newState;
        this.stateStartTime = time;
    }

    public ColRect getColRect(long gameTime, int type) {
        return this.getAnimation().GetColRect(this.animID, gameTime - this.stateStartTime, this.animCyclic, type);
    }

    public boolean isCollide(long gameTime, GameActor other, int typeSelf, int typeOther) {
        try {
            return this.isCollide(gameTime, other, typeSelf, typeOther, 0, 0);
        }
        catch (Exception e2) {
            return false;
        }
    }

    public boolean isCollide(long gameTime, GameActor other, int typeSelf, int typeOther, int offsetX, int offsetY) {
        crSelf.Copy(this.getX() + offsetX, this.getY() + offsetY, this.getColRect(gameTime, typeSelf));
        crOther.Copy(other.getX(), other.getY(), other.getColRect(gameTime, typeOther));
        return ColRect.RectIntersect(crSelf, crOther);
    }

    public ColRect getIntersectRect(long gameTime, GameActor other, int typeSelf, int typeOther) {
        this.getIntersectRect(gameTime, other, typeSelf, typeOther, 0, 0);
        return crSelf;
    }

    public ColRect getIntersectRect(long gameTime, GameActor other, int typeSelf, int typeOther, int offsetX, int offsetY) {
        crSelf.Copy(this.getX() + offsetX, this.getY() + offsetY, this.getColRect(gameTime, typeSelf));
        crOther.Copy(other.getX(), other.getY(), other.getColRect(gameTime, typeOther));
        return this.getIntersectRect(crSelf, crOther);
    }

    public ColRect getIntersectRect(ColRect cr1, ColRect cr2) {
        ColRect min_x_col_rect = cr1.x < cr2.x ? cr1 : cr2;
        ColRect max_x_col_rect = cr1.x > cr2.x ? cr1 : cr2;
        ColRect min_y_col_rect = cr1.y < cr2.y ? cr1 : cr2;
        ColRect max_y_col_rect = cr1.y > cr2.y ? cr1 : cr2;
        cr1.x = max_x_col_rect.x;
        cr1.y = max_y_col_rect.y;
        cr1.w = min_x_col_rect.x + min_x_col_rect.w < max_x_col_rect.x + max_x_col_rect.w ? min_x_col_rect.x + min_x_col_rect.w - cr1.x : max_x_col_rect.w;
        cr1.h = min_y_col_rect.y + min_y_col_rect.h < max_y_col_rect.y + max_y_col_rect.h ? min_y_col_rect.y + min_y_col_rect.h - cr1.y : max_y_col_rect.h;
        return cr1;
    }

    public void saveLastState() {
        this.lastState = this.state;
        this.lastStateId = this.animID;
        this.lastStateAnimCyclic = this.animCyclic;
    }

    public void recoveryLastState(long time) {
        this.setState(this.lastState, time);
        this.setRenderContent(this.lastStateId, this.lastStateAnimCyclic, time);
    }

    public boolean inUse() {
        return this.inUse;
    }

    public void setInUse(boolean aValue) {
        this.inUse = aValue;
    }

    public int getX() {
        return CMath.F2I(this.x);
    }

    public int getY() {
        return CMath.F2I(this.y);
    }

    public int getLastX() {
        return CMath.F2I(this.lastX);
    }

    public int getLastY() {
        return CMath.F2I(this.lastY);
    }

    public void setX(int aValue) {
        this.lastX = this.x;
        this.x = CMath.I2F(aValue);
    }

    public void setY(int aValue) {
        this.lastY = this.y;
        this.y = CMath.I2F(aValue);
    }

    public void setRenderContent(int anId, boolean loop, long time) {
        this.getAnimation().resetAnimation(anId);
        this.animID = anId;
        this.animCyclic = loop;
        this.stateStartTime = time;
    }

    public abstract void process(long var1, GameActor[] var3, GameEngine var4);

    public abstract void init(long var1, int var3);

    public abstract void beginNotify(long var1, int var3);

    public abstract void endNotify(long var1, int var3);

    public void renderGameActor(Graphics g2, long gameTime) {
        this.basicRenderGameActor(g2, gameTime);
    }

    public final void basicRenderGameActor(Graphics g2, long gameTime) {
        this.animation.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
    }

    public void setLife(int life) {
        this.life = life;
    }

    public int getLife() {
        return this.life;
    }

    public abstract void reduceLife(int var1, int var2, ColRect var3, long var4);

    protected void setAnimation(PWPifLifeAnimations animation) {
        this.animation = animation;
    }

    protected PWPifLifeAnimations getAnimation() {
        return this.animation;
    }

    protected void setType(int type) {
        this.type = type;
    }

    protected int getType() {
        return this.type;
    }

    public int getVx() {
        return CMath.F2I(this.vx);
    }

    public void setVx(int vx) {
        this.vx = CMath.I2F(vx);
    }

    public void setRawVx(int vx) {
        this.vx = vx;
    }

    public int getVy() {
        return CMath.F2I(this.vy);
    }

    public void setVy(int vy) {
        this.vy = CMath.I2F(vy);
    }

    public void setRawVy(int vy) {
        this.vy = vy;
    }

    public int getSubType() {
        return this.subType;
    }

    public void setSubType(int subType) {
        this.subType = subType;
    }

    protected boolean isAnimationOver(long gameTime) {
        return this.getAnimation().animationIsOver(this.animID, (int)(gameTime - this.stateStartTime));
    }

    public int getAx() {
        return CMath.F2I(this.ax);
    }

    public void setAx(int ax) {
        this.ax = CMath.I2F(ax);
    }

    public int getAy() {
        return CMath.F2I(this.ay);
    }

    public void setAy(int ay) {
        this.ay = CMath.I2F(ay);
    }

    protected boolean moveToArea(int endx, int endy, int v2, int areaw, int areah, boolean explictDES, long gameTime, boolean nooutscreen) {
        int vy;
        int vx;
        if (nooutscreen) {
            ColRect crself = this.getColRect(gameTime, 0);
            int newEndX = endx;
            int newEndY = endy;
            if (endx != this.getX()) {
                if (endx < 0 + (crself.w >> 1)) {
                    newEndX = 0 + (crself.w >> 1);
                    endy = (endy - this.getY()) * (newEndX - this.getX()) / (endx - this.getX()) + this.getY();
                    endx = newEndX;
                } else if (endx > 360 - (crself.w >> 1)) {
                    newEndX = 360 - (crself.w >> 1);
                    endy = (endy - this.getY()) * (newEndX - this.getX()) / (endx - this.getX()) + this.getY();
                    endx = newEndX;
                }
            }
            if (endy != this.getY()) {
                if (endy < 36 + crself.h) {
                    newEndY = 36 + crself.h;
                    endx = (endx - this.getX()) * (newEndY - this.getY()) / (endy - this.getY()) + this.getX();
                    endy = newEndY;
                } else if (endy > 480) {
                    newEndY = 480;
                    endx = (endx - this.getX()) * (newEndY - this.getY()) / (endy - this.getY()) + this.getX();
                    endy = newEndY;
                }
            }
        }
        int xDiff = endx - this.getX();
        int yDiff = endy - this.getY();
        int absdifx = Math.abs(xDiff);
        int absdify = Math.abs(yDiff);
        if (absdify != 0 || absdifx != 0) {
            if (absdify > absdifx) {
                vx = v2 * absdifx / absdify;
                if (!explictDES && vx == 0) {
                    vx = 1;
                }
                vy = v2;
            } else if (absdify < absdifx) {
                vx = v2;
                vy = v2 * absdify / absdifx;
                if (!explictDES && vy == 0) {
                    vy = 1;
                }
            } else {
                vx = v2;
                vy = v2;
            }
        } else {
            return true;
        }
        boolean retx = false;
        if (endx - (areaw >> 1) <= this.getX() && endx + (areaw >> 1) >= this.getX()) {
            retx = true;
        }
        boolean rety = false;
        if (endy - (areah >> 1) <= this.getY() && endy + (areah >> 1) >= this.getY()) {
            rety = true;
        }
        if (!retx || explictDES) {
            if (xDiff != 0) {
                if (Math.abs(xDiff) <= vx) {
                    this.setX(endx);
                } else {
                    this.setX(this.getX() + (xDiff > 0 ? vx : -vx));
                }
            }
            if (nooutscreen && this.checkIsOutScreenX(gameTime)) {
                xDiff = 0;
            }
        }
        if (!rety || explictDES) {
            if (yDiff != 0) {
                if (Math.abs(yDiff) <= vy) {
                    this.setY(endy);
                } else {
                    this.setY(this.getY() + (yDiff > 0 ? vy : -vy));
                }
            }
            if (nooutscreen && this.checkIsOutScreenY(gameTime)) {
                yDiff = 0;
            }
        }
        if (retx && rety) {
            return true;
        }
        return yDiff == 0 && xDiff == 0;
    }

    protected boolean checkIsOutScreenX(long gameTime) {
        ColRect crself = this.getColRect(gameTime, 0);
        if (this.getX() - (crself.w >> 1) <= 0) {
            this.setX(crself.w >> 1);
            return true;
        }
        if (this.getX() + (crself.w >> 1) >= 360) {
            this.setX(360 - (crself.w >> 1));
            return true;
        }
        return false;
    }

    protected boolean checkIsOutScreenY(long gameTime) {
        ColRect crself = this.getColRect(gameTime, 0);
        if (this.getY() - crself.h <= 36) {
            this.setY(36 + crself.h);
            return true;
        }
        if (this.getY() >= 480) {
            this.setY(480);
            return true;
        }
        return false;
    }

    public void setMaxlife(int maxlife) {
        this.maxlife = maxlife;
    }

    public int getMaxlife() {
        return this.maxlife;
    }

    public void setRelatePlayer(GameActor relatePlayer) {
        this.relatePlayer = relatePlayer;
    }

    public GameActor getRelatePlayer() {
        return this.relatePlayer;
    }

    public void setPowerNewton(int powerNewton) {
        this.powerNewton = powerNewton;
        if (this.powerNewton >= 100) {
            this.powerNewton = 100;
        }
        if (this.powerNewton <= 0) {
            this.powerNewton = 0;
        }
    }

    public int getPowerNewton() {
        return this.powerNewton;
    }

    protected GameActor getABonus() {
        MainCanvas.getGameEngine();
        GameActor[] bonusPool = GameEngine.bonusPool;
        for (int i2 = 0; i2 < bonusPool.length; ++i2) {
            if (bonusPool[i2] != null && bonusPool[i2].inUse()) continue;
            if (bonusPool[i2] == null) {
                bonusPool[i2] = new GameBonus();
            }
            return bonusPool[i2];
        }
        return null;
    }

    public void setStopProcessing(boolean stopProcessing, long time) {
        if (stopProcessing) {
            if (time - stopProcessingTime > 80L) {
                stopProcessingTime = time;
            }
            this.stopProcessing = true;
        } else {
            this.stopProcessing = false;
        }
    }

    public boolean isStopProcessing() {
        return this.stopProcessing;
    }

    static {
        crSelf = new ColRect();
        crOther = new ColRect();
    }
}

