/*
 * Decompiled with CFR 0.152.
 */
package z.playw.DragonGuardian;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import z.playw.DragonGuardian.CMath;
import z.playw.DragonGuardian.CONSTANT;
import z.playw.DragonGuardian.Enemy;
import z.playw.DragonGuardian.EnemyBase;
import z.playw.DragonGuardian.GameActor;
import z.playw.DragonGuardian.GameCommands;
import z.playw.DragonGuardian.GraphicSet;
import z.playw.DragonGuardian.MainCanvas;
import z.playw.DragonGuardian.Path;
import z.playw.DragonGuardian.Player;
import z.playw.j2me.graphics.ColRect;
import z.playw.j2me.graphics.PWPifLifeAnimations;
import z.playw.j2me.util.PWScreenToolbox;

public class GameEngine {
    public static final String LEVEL_DEF_PREFIX = "level";
    public static final String LEVEL_DEF_SUFIX = ".map";
    public static final String TILESET_PREFIX = "tileset";
    public static final String TILESET_SUFIX = ".png";
    public static final String GRAPHICSET_PREFIX = "graphicSet";
    public static final String GRAPHICSET_SUFIX = ".nfo";
    private boolean shakeScreen;
    private boolean darkScreen;
    private boolean lightScreen;
    private boolean lightScreenOverlapEnemy;
    private boolean levelFinished;
    public GameCommands commands = new GameCommands();
    public static GraphicSet[] graphicSets;
    public static Image levelMap;
    public PWPifLifeAnimations pifBG;
    public long pifBGTime;
    public int pifBGWidth;
    public PWPifLifeAnimations mUIPif;
    private int bossLifeWidth;
    private int bossLifeBGWidth;
    public boolean isBossUiUpdated;
    public static GameActor[] actorPool;
    public static GameActor[] bulletPool;
    public static GameActor[] spiritPool;
    public static GameActor[] bonusPool;
    public PWPifLifeAnimations playerPif;
    public PWPifLifeAnimations playerWeaponPif;
    public PWPifLifeAnimations playerBladeShadowPif;
    public PWPifLifeAnimations enemy01Pif;
    public PWPifLifeAnimations enemy02Pif;
    public PWPifLifeAnimations enemy03Pif;
    public PWPifLifeAnimations enemy04Pif;
    public PWPifLifeAnimations enemy04_1Pif;
    public PWPifLifeAnimations enemy05Pif;
    public PWPifLifeAnimations enemy06Pif;
    public PWPifLifeAnimations enemy07Pif;
    public PWPifLifeAnimations enemy08Pif;
    public PWPifLifeAnimations enemy09Pif;
    public PWPifLifeAnimations enemy10Pif;
    public PWPifLifeAnimations enemy12Pif;
    public PWPifLifeAnimations hitFontPif;
    public PWPifLifeAnimations boss01Pif;
    public PWPifLifeAnimations bossBullet01Pif;
    public PWPifLifeAnimations bossFireLordPif;
    public PWPifLifeAnimations bossCyclops;
    public PWPifLifeAnimations bossDracula;
    public PWPifLifeAnimations bossSwordPif;
    public PWPifLifeAnimations bossGeneralPif;
    public PWPifLifeAnimations bossKingPif;
    public PWPifLifeAnimations bulletPif;
    public PWPifLifeAnimations bulletSpiderPif;
    public PWPifLifeAnimations enemy01BulletPif;
    public PWPifLifeAnimations enemy02BulletPif;
    public PWPifLifeAnimations enemy03BulletPif;
    public PWPifLifeAnimations enemyTailBulletPif;
    public PWPifLifeAnimations bossBulletBat;
    public PWPifLifeAnimations bossKingBullet;
    public PWPifLifeAnimations superAttackFireStoneStormPif;
    public PWPifLifeAnimations superAttackIceStormPif;
    public PWPifLifeAnimations boom00Pif;
    public PWPifLifeAnimations boom01Pif;
    public PWPifLifeAnimations boom02Pif;
    public PWPifLifeAnimations bosszdPif;
    public PWPifLifeAnimations spiritPif;
    public PWPifLifeAnimations lightDragonPif;
    public PWPifLifeAnimations iceEffPif;
    public PWPifLifeAnimations fireEffPif;
    public PWPifLifeAnimations lightEffPif;
    public PWPifLifeAnimations bloodEffPif;
    public PWPifLifeAnimations bloodEff2Pif;
    public PWPifLifeAnimations warningPif;
    public PWPifLifeAnimations stonePif;
    public PWPifLifeAnimations bossAlarmPif;
    public PWPifLifeAnimations leveluplinePif;
    public PWPifLifeAnimations continuousHitsPif;
    public PWPifLifeAnimations bonusPif;
    public PWPifLifeAnimations powerUpPif;
    public PWPifLifeAnimations skillsPif;
    public PWPifLifeAnimations shieldPif;
    public PWPifLifeAnimations shieldEnemyPif;
    public PWPifLifeAnimations dialogPif;
    public int bgEnenyX;
    public int bgEnenyY;
    public int bgEnenyAnimID;
    public MainCanvas mainCanvas = null;
    private int xMapFrontOffset = 0;
    public int yMapFrontOffset = 0;
    private int xMapFrontOffsetSpeed = 0;
    private int xMapBackOffset = 0;
    public int yMapBackOffset = 0;
    private int xMapBackOffsetSpeed = 0;
    private int xPifBGOffset = 0;
    public int yPifBGOffset = 360;
    private int xPifBGOffsetSpeed = 0;
    private boolean stopScrollBG;
    public static int curKey;
    public static int keyPressed;
    public static int keyReleased;
    public boolean isReleasedOnce = true;
    private long curFrameTime = 0L;
    private int playerIndex = 0;
    public static Graphics gg;
    public static Image img;
    public static Graphics img_g;
    public static int[][] specialEffect;
    private boolean inDialog = false;
    private int dialogIndex = -1;
    private int dialogCurSentence = -1;
    private short[][] lines;
    private int linesIndex = 0;

    public static GameActor[] getBulletPool() {
        return bulletPool;
    }

    public GameEngine(MainCanvas canvas) {
        this.mainCanvas = canvas;
    }

    public void loadLevel(int levelID, int step) {
        switch (step) {
            case 0: {
                actorPool = new GameActor[50];
                bulletPool = new GameActor[50];
                spiritPool = new GameActor[50];
                bonusPool = new GameActor[50];
                break;
            }
            case 23: {
                int lvid = levelID;
                if (lvid == 6) {
                    lvid = 2;
                }
                levelMap = PWScreenToolbox.get().getImage("map0" + lvid % 3 + TILESET_SUFIX);
                break;
            }
            case 24: {
                break;
            }
            case 29: {
                this.mUIPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("PlayerUI.aej"), 0, false);
                Enemy.resetEnemyUI();
                break;
            }
            case 21: {
                if (levelID == 0) {
                    this.pifBG = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("lv" + levelID + "bottom.aej"), 0, false);
                    this.pifBGWidth = this.pifBG.GetAniFrameWidth(0, 0);
                    break;
                }
                if (levelID != 5 && levelID != 6) break;
                this.pifBG = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("zhuzi.aej"), 0, false);
                this.pifBGWidth = 960;
                break;
            }
            case 5: {
                this.playerPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("heroBody.aej"), 0, false);
                this.playerWeaponPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("heroWeapon" + MainCanvas.weaponStore[Player.curWeapon][8] + ".aej"), 0, false);
                this.playerBladeShadowPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("hero1.trans"));
                GameEngine.actorPool[0] = new Player();
                actorPool[0].setType(0);
                actorPool[0].setAnimation(this.playerPif);
                break;
            }
            case 6: {
                this.bulletPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("bullet.aej"), 0, false);
                this.bulletSpiderPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("enemy05_fire.aej"), 0, false);
                this.enemy01BulletPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("fire01.aej"), 0, false);
                this.enemy02BulletPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("fire02.aej"), 0, false);
                this.enemy03BulletPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("fire03.aej"), 0, false);
                this.enemyTailBulletPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("dandan.aej"), 0, false);
                break;
            }
            case 7: {
                this.bloodEffPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("TS.aej"), 0, false);
                this.bloodEff2Pif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("blood.aej"), 0, false);
                break;
            }
            case 8: {
                this.hitFontPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("enemy_font.aej"), 0, false);
                this.bossBullet01Pif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("boss_fire.aej"), 0, false);
                break;
            }
            case 9: {
                this.boom00Pif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("boom00.aej"), 0, false);
                this.boom01Pif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("boom01.trans"));
                this.boom02Pif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("boom02.aej"), 0, false);
                break;
            }
            case 10: {
                this.commands.loadCommands(PWScreenToolbox.get().getResource("lv" + levelID + ".dat"));
                break;
            }
            case 11: {
                this.spiritPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("hun.trans"));
                break;
            }
            case 12: {
                if (Player.curMagic == 0) {
                    this.superAttackFireStoneStormPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("mofa.aej"), 0, false);
                    this.fireEffPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("enemy_fire.aej"), 0, false);
                }
                if (Player.curMagic == 1) {
                    this.superAttackIceStormPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("xue.aej"), 0, false);
                    this.iceEffPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("bing.aej"), 0, false);
                    this.skillsPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("skills.aej"), 0, false);
                }
                if (Player.curMagic != 3) break;
                this.lightDragonPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("lei.aej"), 0, false);
                this.lightEffPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("enemy_lei.aej"), 0, false);
                break;
            }
            case 13: {
                if (this.shouldLoadTheRes(levelID, "Stone.aej")) {
                    this.stonePif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("Stone.aej"), 0, false);
                    this.warningPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("TanHao.aej"), 0, false);
                }
                this.bossAlarmPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("kuang.aej"), 0, false);
                break;
            }
            case 14: {
                this.leveluplinePif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("Levelup_line.aej"), 0, false);
                break;
            }
            case 15: {
                this.continuousHitsPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("Hits.aej"), 0, false);
                break;
            }
            case 16: {
                this.bonusPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("BONUS.aej"), 0, false);
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                break;
            }
            case 20: {
                this.shieldPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("dun.aej"), 0, false);
                this.shieldEnemyPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("dun_enemy.aej"), 0, false);
                break;
            }
            case 3: {
                if (this.shouldLoadTheRes(levelID, "enemy01.aej")) {
                    this.enemy01Pif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("enemy01.aej"), 0, false);
                }
                if (this.shouldLoadTheRes(levelID, "enemy02.aej")) {
                    this.enemy02Pif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("enemy02.aej"), 0, false);
                }
                if (this.shouldLoadTheRes(levelID, "enemy03.aej")) {
                    this.enemy03Pif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("enemy03.aej"), 0, false);
                }
                if (this.shouldLoadTheRes(levelID, "enemy04.aej")) {
                    this.enemy04Pif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("enemy04.aej"), 0, false);
                }
                if (!this.shouldLoadTheRes(levelID, "enemy04_1.aej")) break;
                this.enemy04_1Pif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("enemy04_1.aej"), 0, false);
                break;
            }
            case 4: {
                if (this.shouldLoadTheRes(levelID, "enemy05.aej")) {
                    this.enemy05Pif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("enemy05.aej"), 0, false);
                }
                if (this.shouldLoadTheRes(levelID, "enemy06.aej")) {
                    this.enemy06Pif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("enemy06.aej"), 0, false);
                }
                if (this.shouldLoadTheRes(levelID, "enemy07.aej")) {
                    this.enemy07Pif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("enemy07.aej"), 0, false);
                }
                if (!this.shouldLoadTheRes(levelID, "enemy08.aej")) break;
                this.enemy08Pif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("enemy08.aej"), 0, false);
                break;
            }
            case 22: {
                if (this.shouldLoadTheRes(levelID, "enemy09.aej")) {
                    this.enemy09Pif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("enemy09.aej"), 0, false);
                }
                if (this.shouldLoadTheRes(levelID, "enemy10.aej")) {
                    this.enemy10Pif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("enemy10.aej"), 0, false);
                }
                if (!this.shouldLoadTheRes(levelID, "enemy12.aej")) break;
                this.enemy12Pif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("enemy12.aej"), 0, false);
                break;
            }
            case 1: {
                if (this.shouldLoadTheRes(levelID, "boss3.aej")) {
                    this.bossFireLordPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("boss3.aej"), 0, false);
                    this.bosszdPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("bosszd.aej"), 0, false);
                }
                if (this.shouldLoadTheRes(levelID, "boss1.aej")) {
                    this.boss01Pif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("boss1.aej"), 0, false);
                }
                if (this.shouldLoadTheRes(levelID, "boss4.aej")) {
                    this.bossCyclops = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("boss4.aej"), 0, false);
                }
                if (!this.shouldLoadTheRes(levelID, "boss5.aej")) break;
                this.bossDracula = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("boss5.aej"), 0, false);
                this.bossBulletBat = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("boss5_1.aej"), 0, false);
                break;
            }
            case 2: {
                if (this.shouldLoadTheRes(levelID, "boss6.aej")) {
                    this.bossSwordPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("boss6.aej"), 0, false);
                }
                if (this.shouldLoadTheRes(levelID, "boss2.aej")) {
                    this.bossGeneralPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("boss2.aej"), 0, false);
                }
                if (!this.shouldLoadTheRes(levelID, "boss7.aej")) break;
                this.bossKingPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("boss7.aej"), 0, false);
                this.bossKingBullet = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("boss7_fire.aej"), 0, false);
                break;
            }
            case 25: {
                this.dialogPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("kuang1.aej"), 0, false);
                this.mainCanvas.menuPif = new PWPifLifeAnimations(PWScreenToolbox.get().getResource("menu.aej"), 0, false);
            }
        }
        EnemyBase.uiBoss = null;
    }

    public void unloadLevel() {
        actorPool = null;
        bulletPool = null;
        spiritPool = null;
        bonusPool = null;
        levelMap = null;
        this.mUIPif = null;
        this.pifBG = null;
        this.playerPif = null;
        this.playerWeaponPif = null;
        this.playerBladeShadowPif = null;
        this.bulletPif = null;
        this.bulletSpiderPif = null;
        this.enemy01BulletPif = null;
        this.enemy02BulletPif = null;
        this.enemy03BulletPif = null;
        this.enemyTailBulletPif = null;
        this.bloodEffPif = null;
        this.bloodEff2Pif = null;
        this.hitFontPif = null;
        this.bossBullet01Pif = null;
        this.boom00Pif = null;
        this.boom01Pif = null;
        this.boom02Pif = null;
        this.commands.unloadCommand();
        this.spiritPif = null;
        this.superAttackFireStoneStormPif = null;
        this.fireEffPif = null;
        this.superAttackIceStormPif = null;
        this.iceEffPif = null;
        this.lightDragonPif = null;
        this.lightEffPif = null;
        this.stonePif = null;
        this.warningPif = null;
        this.bossAlarmPif = null;
        this.leveluplinePif = null;
        this.continuousHitsPif = null;
        this.bonusPif = null;
        this.skillsPif = null;
        this.shieldPif = null;
        this.shieldEnemyPif = null;
        this.enemy01Pif = null;
        this.enemy02Pif = null;
        this.enemy03Pif = null;
        this.enemy04Pif = null;
        this.enemy04_1Pif = null;
        this.enemy05Pif = null;
        this.enemy06Pif = null;
        this.enemy07Pif = null;
        this.enemy08Pif = null;
        this.enemy09Pif = null;
        this.enemy10Pif = null;
        this.enemy12Pif = null;
        this.bossFireLordPif = null;
        this.bosszdPif = null;
        this.boss01Pif = null;
        this.bossCyclops = null;
        this.bossDracula = null;
        this.bossBulletBat = null;
        this.bossSwordPif = null;
        this.bossGeneralPif = null;
        this.bossKingPif = null;
        this.bossKingBullet = null;
        EnemyBase.uiBoss = null;
    }

    public static void clearKey() {
        curKey = -1;
        keyPressed = 0;
        keyReleased = 0;
    }

    public void processKeysReleasedGame(char c2) {
        if (!this.isReleasedOnce) {
            keyPressed = 0;
            keyReleased = 0;
            this.isReleasedOnce = true;
            return;
        }
        switch (c2) {
            case '\u0003': 
            case '4': {
                keyPressed &= 0xFFFFFEFF;
                keyReleased = 256;
                break;
            }
            case '\u0004': 
            case '6': {
                keyPressed &= 0xFFFFFBFF;
                keyReleased = 1024;
                break;
            }
            case '\u0005': 
            case '2': {
                keyPressed &= 0xFFFFFFBF;
                keyReleased = 64;
                break;
            }
            case '\u0006': 
            case '8': {
                keyPressed &= 0xFFFFEFFF;
                keyReleased = 4096;
                break;
            }
            case '3': {
                keyPressed &= 0xFFFFFF7F;
                keyReleased = 128;
                break;
            }
            case '9': {
                keyPressed &= 0xFFFFDFFF;
                keyReleased = 8192;
                break;
            }
            case '1': {
                keyPressed &= 0xFFFFFFDF;
                keyReleased = 32;
                break;
            }
            case '7': {
                keyPressed &= 0xFFFFF7FF;
                keyReleased = 2048;
                break;
            }
            case '\u0002': 
            case '5': {
                keyPressed &= 0xFFFFFDFF;
                keyReleased = 512;
                break;
            }
            case '0': {
                keyPressed &= 0xFFFFFFEF;
                keyReleased = 16;
                break;
            }
            case '*': {
                keyPressed &= 0xFFFDFFFF;
                keyReleased = 131072;
                break;
            }
            case '#': {
                keyPressed &= 0xFFFEFFFF;
                keyReleased = 65536;
                break;
            }
            case '\u0001': {
                keyPressed &= 0xFFFFBFFF;
                keyReleased = 16384;
                break;
            }
            case '\u0000': {
                keyPressed &= 0xFFFF7FFF;
                keyReleased = 32768;
            }
        }
        if (keyPressed != 0) {
            if ((keyPressed & 0x100) != 0) {
                curKey = 256;
            } else if ((keyPressed & 0x400) != 0) {
                curKey = 1024;
            } else if ((keyPressed & 0x40) != 0) {
                curKey = 64;
            } else if ((keyPressed & 0x1000) != 0) {
                curKey = 4096;
            } else if ((keyPressed & 0x200) != 0) {
                curKey = 512;
            } else if ((keyPressed & 0x10) != 0) {
                curKey = 16;
            }
        } else {
            curKey = -1;
        }
    }

    public void processKeyPressedGame(char c2) {
        switch (c2) {
            case '\u0003': 
            case '4': {
                curKey = 256;
                keyPressed |= 0x100;
                break;
            }
            case '\u0004': 
            case '6': {
                curKey = 1024;
                keyPressed |= 0x400;
                break;
            }
            case '\u0005': 
            case '2': {
                curKey = 64;
                keyPressed |= 0x40;
                break;
            }
            case '\u0006': 
            case '8': {
                curKey = 4096;
                keyPressed |= 0x1000;
                break;
            }
            case '3': {
                curKey = 128;
                keyPressed |= 0x80;
                break;
            }
            case '9': {
                curKey = 8192;
                keyPressed |= 0x2000;
                break;
            }
            case '1': {
                curKey = 32;
                keyPressed |= 0x20;
                break;
            }
            case '7': {
                curKey = 2048;
                keyPressed |= 0x800;
                break;
            }
            case '\u0002': 
            case '5': {
                curKey = 512;
                keyPressed |= 0x200;
                break;
            }
            case '0': {
                curKey = 16;
                keyPressed |= 0x10;
                break;
            }
            case '*': {
                curKey = 131072;
                keyPressed |= 0x20000;
                break;
            }
            case '#': {
                curKey = 65536;
                keyPressed |= 0x10000;
                break;
            }
            case '\u0000': {
                curKey = 32768;
                keyPressed |= 0x8000;
                break;
            }
            case '\u0001': {
                curKey = 16384;
                keyPressed |= 0x4000;
            }
        }
    }

    public void init() {
        int i2;
        long time = this.getInGameStartedTime();
        for (i2 = 0; i2 < actorPool.length; ++i2) {
            if (actorPool[i2] == null) continue;
            actorPool[i2].init(time, actorPool[i2].getType());
        }
        for (i2 = 0; i2 < MainCanvas.weaponCurLevel.length; ++i2) {
            for (int j2 = 0; j2 < MainCanvas.weaponCurLevel[i2].length; ++j2) {
                MainCanvas.weaponCurLevel[i2][j2] = -1;
            }
        }
        this.setLevelFinished(false);
        this.setXMapBackOffset(0);
        this.setXMapBackOffsetSpeed(0);
        this.setXMapFrontOffset(0);
        this.setXMapFrontOffsetSpeed(0);
        this.setXPifBGOffset(0);
        this.setXPifBGOffsetSpeed(0);
        GameEngine.clearKey();
        this.setStopScrollBG(false);
        this.shakeScreen = false;
        this.darkScreen = false;
        this.lightScreen = false;
        this.setInDialog(false, time);
        this.setDialogIndex(-1);
        this.setDialogCurSentence(-1);
        this.setLightScreenOverlapEnemy(false);
        MainCanvas.gameState = 1;
    }

    public void process(long curFrameTime) {
        int i2;
        this.setCurFrameTime(curFrameTime);
        if (curKey == 16384) {
            this.mainCanvas.pauseGame();
            return;
        }
        long time = this.getInGameStartedTime();
        if (this.isInDialog()) {
            if (keyReleased == 512) {
                if (this.linesIndex < this.lines.length - 2) {
                    this.linesIndex += 2;
                } else {
                    this.setDialogCurSentence(this.getDialogCurSentence() + 1);
                    if (this.getDialogCurSentence() >= Path.dialog[this.getDialogIndex()].length) {
                        this.setInDialog(false, time);
                    } else {
                        ColRect cr = this.dialogPif.GetColRect(0, 0L, false, 0);
                        this.lines = MainCanvas.font1.getLineData(MainCanvas.lang[Path.dialog[this.getDialogIndex()][this.getDialogCurSentence()][1]].toCharArray(), 480 - cr.x * 2);
                        this.linesIndex = 0;
                    }
                }
            }
        } else {
            Player.increaseTotalTime(this.getCurFrameTime());
        }
        this.commands.process(this.getCurFrameTime(), time, actorPool, this);
        for (i2 = 0; i2 < actorPool.length; ++i2) {
            if (actorPool[i2] == null || !actorPool[i2].inUse()) continue;
            actorPool[i2].process(time, actorPool, this);
        }
        for (i2 = 0; i2 < bulletPool.length; ++i2) {
            if (bulletPool[i2] == null || !bulletPool[i2].inUse()) continue;
            bulletPool[i2].process(time, actorPool, this);
        }
        for (i2 = 0; i2 < bonusPool.length; ++i2) {
            if (bonusPool[i2] == null || !bonusPool[i2].inUse()) continue;
            bonusPool[i2].process(time, actorPool, this);
        }
        for (i2 = 0; i2 < spiritPool.length; ++i2) {
            if (spiritPool[i2] == null || !spiritPool[i2].inUse()) continue;
            spiritPool[i2].process(time, actorPool, this);
        }
        this.getPlayer().adjustPosition(time, actorPool);
        if (this.isLevelFinished()) {
            if (MainCanvas.indexOfLevel != 5) {
                this.mainCanvas.unloadGameResources(true);
                this.mainCanvas.loadMenuResources();
                this.mainCanvas.gotoAppState((byte)8);
                this.mainCanvas.menuOffset = 0;
                MainCanvas.buttons = 1;
            } else {
                this.mainCanvas.savePlayerProperty();
                this.mainCanvas.saveGame();
                MainCanvas.indexOfLevel = 6;
                this.mainCanvas.playerLife = this.getPlayer().getLife();
                this.mainCanvas.playerMana = this.getPlayer().getMana();
                this.mainCanvas.unloadGameResources(true);
                this.mainCanvas.loadGameResources();
                this.mainCanvas.gotoAppState((byte)2);
                this.mainCanvas.goToGameSubState((byte)0, MainCanvas.processTime);
            }
        }
        keyReleased = 0;
    }

    public Player getPlayer() {
        if (actorPool == null) {
            return null;
        }
        if (actorPool[this.playerIndex] != null && actorPool[this.playerIndex].inUse() && actorPool[this.playerIndex].getType() == 0) {
            return (Player)actorPool[this.playerIndex];
        }
        for (int i2 = actorPool.length - 1; i2 >= 0; --i2) {
            if (actorPool[i2] == null || !actorPool[i2].inUse() || actorPool[i2].getType() != 0) continue;
            this.playerIndex = i2;
            return (Player)actorPool[i2];
        }
        return null;
    }

    public long getInGameStartedTime() {
        return MainCanvas.processTime - this.mainCanvas.gameStateTime;
    }

    public int changeColor(int color, int levelR, int levelG, int levelB) {
        int r2 = ((color & 0xFF0000) >> 16) + levelR;
        int g2 = ((color & 0xFF00) >> 8) + levelG;
        int b2 = (color & 0xFF) + levelB;
        if (r2 > 255) {
            r2 = 255;
        } else if (r2 < 0) {
            r2 = 0;
        }
        if (g2 > 255) {
            g2 = 255;
        } else if (g2 < 0) {
            g2 = 0;
        }
        if (b2 > 255) {
            b2 = 255;
        } else if (b2 < 0) {
            b2 = 0;
        }
        int retColor = 0xFF000000 | r2 << 16 | g2 << 8 | b2;
        return retColor;
    }

    public void zoomedImage(int[] arr, int type) {
        for (int i2 = 0; i2 < specialEffect.length; ++i2) {
            int level2;
            int posX;
            int posY;
            int drawH;
            int x = specialEffect[i2][0];
            int y = specialEffect[i2][1];
            int w2 = specialEffect[i2][2];
            int h2 = specialEffect[i2][3];
            int life = specialEffect[i2][4];
            if (x + w2 > 479) {
                w2 = 479 - x;
            }
            if (w2 <= 0 || x < 0) {
                GameEngine.specialEffect[i2][4] = 0;
                continue;
            }
            if (y + h2 > 359) {
                h2 = 360 - y - 1;
            }
            if (h2 <= 0 || y < 0) {
                GameEngine.specialEffect[i2][4] = 0;
                continue;
            }
            if (life == 0) continue;
            int levelMax = 35;
            int levelMin = 0;
            int step = (levelMax - levelMin) / h2;
            int level = levelMin;
            if (life > 0) {
                drawH = h2 >> 1;
                for (posY = y; posY <= y + drawH; ++posY) {
                    for (posX = x + w2 - 1; posX >= x; --posX) {
                        if (level > levelMax) {
                            level = levelMax;
                        }
                        arr[posY * 480 + posX] = this.changeColor(arr[(posY + 1) * 480 + posX - 1], level << 1, level >> 1, level);
                        level2 = level;
                        arr[(2 * y + h2 - posY) * 480 + posX] = this.changeColor(arr[(2 * y + h2 - posY - 1) * 480 + posX - 1], level2 << 1, level2 >> 1, level2);
                    }
                    level += step;
                }
                int[] nArray = specialEffect[i2];
                nArray[0] = nArray[0] + 1;
                int[] nArray2 = specialEffect[i2];
                nArray2[1] = nArray2[1] - 2;
                int[] nArray3 = specialEffect[i2];
                nArray3[3] = nArray3[3] + 4;
                int[] nArray4 = specialEffect[i2];
                nArray4[4] = nArray4[4] - 6;
                continue;
            }
            if (life >= 0) continue;
            levelMax = 10;
            levelMin = 0;
            int[] nArray = specialEffect[i2];
            nArray[0] = nArray[0] + 0;
            int[] nArray5 = specialEffect[i2];
            nArray5[1] = nArray5[1] + 4;
            int[] nArray6 = specialEffect[i2];
            nArray6[3] = nArray6[3] - 8;
            int[] nArray7 = specialEffect[i2];
            nArray7[4] = nArray7[4] - 8;
            x = specialEffect[i2][0];
            y = specialEffect[i2][1];
            w2 = specialEffect[i2][2];
            h2 = specialEffect[i2][3];
            life = specialEffect[i2][4];
            if (x + w2 > 479) {
                w2 = 479 - x;
            }
            if (w2 <= 0 || x < 0) {
                GameEngine.specialEffect[i2][4] = 0;
                continue;
            }
            if (y + h2 > 359) {
                h2 = 360 - y - 1;
            }
            if (h2 <= 0 || y < 0) {
                GameEngine.specialEffect[i2][4] = 0;
                continue;
            }
            drawH = h2 >> 1;
            for (posY = y; posY <= y + drawH; ++posY) {
                for (posX = x + w2; posX >= x; --posX) {
                    if (level > levelMax) {
                        level = levelMax;
                    }
                    arr[posY * 480 + posX] = this.changeColor(arr[(posY + 1) * 480 + posX - 1], level, level, level);
                    level2 = level;
                    arr[(2 * y + h2 - posY) * 480 + posX] = this.changeColor(arr[(2 * y + h2 - posY - 1) * 480 + posX - 1], level2, level2, level2);
                }
                level += step;
            }
            if (specialEffect[i2][4] >= -24) continue;
            GameEngine.specialEffect[i2][4] = 0;
        }
    }

    public void drawUI(Graphics g2, long gameTime) {
        this.drawPlayerUIandBG(g2, gameTime);
    }

    private void drawBossUI(Graphics g2, long gameTime) {
        if (EnemyBase.uiBoss != null && EnemyBase.uiBoss.inUse()) {
            int uibossrightposx;
            ColRect uiRect1 = this.mUIPif.GetColRect(3, 0L, true, 3);
            ColRect uiRect2 = this.mUIPif.GetColRect(4, 0L, true, 3);
            int onelinemaxlife = EnemyBase.uiBoss.getMaxlife() / 3;
            int lifelines = EnemyBase.uiBoss.getLife() / onelinemaxlife;
            int lifepercentDES = EnemyBase.uiBoss.getLife() % onelinemaxlife * 420 / onelinemaxlife;
            int lifeBGDES2 = 420;
            if (this.getBossLifeWidth() < lifepercentDES && !this.isBossUiUpdated) {
                this.setBossLifeWidth(this.getBossLifeWidth() + 5);
                if (this.getBossLifeWidth() >= lifepercentDES) {
                    this.setBossLifeWidth(lifepercentDES);
                }
            } else {
                this.setBossLifeWidth(lifepercentDES);
            }
            if (this.getBossLifeBGWidth() < lifeBGDES2) {
                this.setBossLifeBGWidth(this.getBossLifeBGWidth() + 5);
                if (this.getBossLifeBGWidth() >= lifeBGDES2) {
                    this.setBossLifeBGWidth(lifeBGDES2);
                }
            } else {
                this.isBossUiUpdated = true;
                this.setBossLifeBGWidth(lifeBGDES2);
            }
            if ((uibossrightposx = this.getBossLifeBGWidth()) < uiRect1.w + uiRect2.w) {
                uibossrightposx = uiRect1.w + uiRect2.w;
            }
            int uimidoffx = this.mUIPif.GetAniFrameWidth(5, 0);
            if (lifelines > 0) {
                g2.setColor(CONSTANT.BOSS_LIFE_UI_COLOR[lifelines - 1]);
                g2.fillRect(30 + uiRect1.x, 335 + uiRect1.y, uibossrightposx, uiRect1.h);
            }
            if (lifelines >= CONSTANT.BOSS_LIFE_UI_COLOR.length - 1) {
                lifelines = CONSTANT.BOSS_LIFE_UI_COLOR.length - 1;
            }
            g2.setColor(CONSTANT.BOSS_LIFE_UI_COLOR[lifelines]);
            g2.fillRect(30 + uiRect1.x, 335 + uiRect1.y, this.getBossLifeWidth(), uiRect1.h);
            for (int midoffx = 0; midoffx < uibossrightposx - (uiRect1.w + uiRect2.w); midoffx += uimidoffx) {
                this.mUIPif.drawAnimation(g2, 5, gameTime, 30 + uiRect1.w + midoffx, 335, true);
            }
            this.mUIPif.drawAnimation(g2, 3, gameTime, 30, 335, true);
            this.mUIPif.drawAnimation(g2, 4, gameTime, 30 + uibossrightposx, 335, true);
        }
    }

    private void drawEnemyUI(Graphics g2, long gameTime) {
        if (EnemyBase.mUIUpdateTime != -1L && gameTime - EnemyBase.mUIUpdateTime <= 1000L) {
            int anid = 0;
            anid = EnemyBase.mUILifeUpdateLevel == 0 ? 1 : 2;
            int posX = 480 - this.mUIPif.GetAniFrameWidth(1, 0) - 2;
            this.mUIPif.drawAnimation(g2, anid, gameTime, posX, 38, true);
            ColRect uiRect = this.mUIPif.GetColRect(1, 0L, true, 2);
            int lifepercentDES = EnemyBase.mUILifePercent * uiRect.w / 100;
            g2.setColor(0xFFFF00);
            g2.fillRect(posX + uiRect.x, 38 + uiRect.y, lifepercentDES, uiRect.h);
        }
    }

    private void drawPlayerUIandBG(Graphics g2, long gameTime) {
        this.mUIPif.drawAnimation(g2, 0, gameTime, 0, 0, true);
        int posX = this.mUIPif.GetAniFrameWidth(0, 0);
        int bgUIRightWidht = this.mUIPif.GetAniFrameWidth(31, 0);
        this.mainCanvas.drawCombineAnimHorizon(g2, this.mUIPif, 30, posX, 0, 480 - posX - bgUIRightWidht, true);
        this.mUIPif.drawAnimation(g2, 31, gameTime, 480 - bgUIRightWidht, 0, true);
        int bigNumberWidth = this.mUIPif.GetAniFrameWidth(8, 0);
        int lvWidth = this.mUIPif.GetAniFrameWidth(28, 0) + bigNumberWidth * 2 + 2;
        int smallNumberWidth = this.mUIPif.GetAniFrameWidth(18, 0);
        int experienceWidth = this.mUIPif.GetAniFrameWidth(7, 0) + smallNumberWidth * 5 + (bgUIRightWidht >> 1);
        int bgSlotRightWidht = this.mUIPif.GetAniFrameWidth(33, 0);
        int endSlotX = 480 - lvWidth - experienceWidth - bgSlotRightWidht;
        int slotWidth = endSlotX - posX;
        this.mainCanvas.drawCombineAnimHorizon(g2, this.mUIPif, 32, posX, 0, slotWidth, true);
        ColRect uiRect1 = this.mUIPif.GetColRect(32, 0L, true, 0);
        ColRect uiRect2 = this.mUIPif.GetColRect(32, 0L, true, 1);
        int lifepercentDES = this.getPlayer().getLife() * slotWidth / this.getPlayer().getMaxlife();
        g2.setColor(0xFFFF00);
        g2.fillRect(0 + uiRect1.x + posX, 0 + uiRect1.y, lifepercentDES, uiRect1.h);
        lifepercentDES = this.getPlayer().getMana() * slotWidth / 100;
        g2.setColor(255);
        g2.fillRect(0 + uiRect2.x + posX, 0 + uiRect2.y, lifepercentDES, uiRect2.h);
        this.mUIPif.drawAnimation(g2, 33, gameTime, endSlotX, 0, true);
        posX = endSlotX + bgSlotRightWidht + 1;
        int posY = 19;
        int numberX = posX += this.mUIPif.GetAniFrameWidth(28, 0);
        this.getPlayer();
        this.mainCanvas.drawNumber(g2, Player.getPlayerLevel() + 1, numberX, posY - (this.mUIPif.GetAniFrameHeight(8, 0) >> 1), 0, this.mUIPif, 8, true, true);
        posX -= this.mUIPif.GetAniFrameWidth(28, 0);
        if (this.getPlayer().getState() == 8) {
            this.mUIPif.drawAnimation(g2, 29, gameTime, posX, posY - (this.mUIPif.GetAniFrameHeight(28, 0) >> 1), true);
        } else {
            this.mUIPif.drawAnimation(g2, 28, gameTime, posX, posY - (this.mUIPif.GetAniFrameHeight(28, 0) >> 1), true);
        }
        posX = 480 - experienceWidth;
        int hollowOffset = 2;
        this.mUIPif.drawAnimation(g2, 6, gameTime, posX, posY + (posY - this.mUIPif.GetAniFrameHeight(6, 0) >> 1) - hollowOffset, true);
        numberX = 480 - (bgUIRightWidht >> 1) - smallNumberWidth * 5;
        this.getPlayer();
        this.mainCanvas.drawNumber(g2, Player.getPlayerLevel_next(), numberX, posY + (posY - this.mUIPif.GetAniFrameHeight(18, 0) >> 1) - hollowOffset, 0, this.mUIPif, 18, true, true);
        this.mUIPif.drawAnimation(g2, 7, gameTime, posX, (posY - this.mUIPif.GetAniFrameHeight(7, 0) >> 1) + hollowOffset, true);
        numberX = 480 - (bgUIRightWidht >> 1) - smallNumberWidth * 5;
        this.getPlayer();
        this.mainCanvas.drawNumber(g2, Player.getPlayerSouls(), numberX, (posY - this.mUIPif.GetAniFrameHeight(18, 0) >> 1) + hollowOffset, 0, this.mUIPif, 18, true, true);
    }

    public void paint(Graphics g2) {
        int i2;
        long gameTime = this.getInGameStartedTime();
        int xOffset = 0;
        int yOffset = 0;
        if (this.isShakeScreen()) {
            xOffset = CMath.getRandNumber(-1, 1);
            yOffset = CMath.getRandNumber(-1, 1);
            xOffset = xOffset < 0 ? (xOffset -= 2) : (xOffset += 2);
            yOffset = yOffset < 0 ? (yOffset -= 2) : (yOffset += 2);
            g2.translate(xOffset, yOffset);
        }
        gg = g2;
        this.paint();
        if (this.isDarkScreen()) {
            g2.setColor(0);
            g2.fillRect(0, 0, 480, 360);
            for (i2 = actorPool.length - 1; i2 >= 0; --i2) {
                if (actorPool[i2] == null || !actorPool[i2].inUse()) continue;
                actorPool[i2].renderGameActor(g2, gameTime);
            }
        }
        if (this.isLightScreen() || this.isLightScreenOverlapEnemy()) {
            g2.setColor(0xFFFFFF);
            if (this.isLightScreen()) {
                g2.fillRect(0, 0, 480, 360);
            }
            for (i2 = actorPool.length - 1; i2 >= 0; --i2) {
                if (actorPool[i2] == null || !actorPool[i2].inUse()) continue;
                actorPool[i2].renderGameActor(g2, gameTime);
            }
            if (this.isLightScreenOverlapEnemy()) {
                g2.fillRect(0, 0, 480, 360);
            }
            this.setLightScreen(false);
            this.setLightScreenOverlapEnemy(false);
        }
        for (i2 = 0; i2 < bulletPool.length; ++i2) {
            if (bulletPool[i2] == null || !bulletPool[i2].inUse() || bulletPool[i2].getSubType() != 30 && bulletPool[i2].getSubType() != 29 && bulletPool[i2].getSubType() != 19) continue;
            bulletPool[i2].renderGameActor(g2, gameTime);
        }
        for (i2 = 0; i2 < spiritPool.length; ++i2) {
            if (spiritPool[i2] == null || !spiritPool[i2].inUse()) continue;
            spiritPool[i2].renderGameActor(g2, gameTime);
        }
        this.drawUI(g2, gameTime);
        this.getPlayer().renderGameActor(g2, gameTime);
        for (i2 = 0; i2 < bulletPool.length; ++i2) {
            if (bulletPool[i2] == null || !bulletPool[i2].inUse() || bulletPool[i2].getSubType() == 30 && bulletPool[i2].getSubType() == 29 && bulletPool[i2].getSubType() == 19) continue;
            g2.setClip(0, 38, 480, 322);
            bulletPool[i2].renderGameActor(g2, gameTime);
        }
        for (i2 = 0; i2 < bonusPool.length; ++i2) {
            if (bonusPool[i2] == null || !bonusPool[i2].inUse()) continue;
            g2.setClip(0, 38, 480, 322);
            bonusPool[i2].renderGameActor(g2, gameTime);
        }
        int hits = this.getPlayer().getContinuousHits();
        if (hits > 0) {
            int bgWidth = this.continuousHitsPif.GetAniFrameWidth(0, 0);
            long elapsedTime = gameTime - this.getPlayer().getLastHitTime();
            int posBackGroundX = 0;
            posBackGroundX = this.getPlayer().getContinuousHits() == 1 ? (elapsedTime > 200L ? bgWidth : (int)((long)bgWidth * elapsedTime / 200L)) : bgWidth;
            g2.setClip(0, 38, 480, 322);
            this.continuousHitsPif.drawAnimation(g2, 0, gameTime, posBackGroundX, 38, true);
            ColRect rcDigital = this.continuousHitsPif.GetColRect(0, 0L, true, 5);
            int posOneDigitalX = posBackGroundX + rcDigital.x + (rcDigital.w >> 1);
            int posOneDigitalY = 38 + rcDigital.y + (rcDigital.h >> 1);
            rcDigital = this.continuousHitsPif.GetColRect(0, 0L, true, 4);
            int posTensDigitalX = posBackGroundX + rcDigital.x + (rcDigital.w >> 1);
            int posTensDigitalY = 38 + rcDigital.y + (rcDigital.h >> 1);
            int digital = hits % 10;
            this.continuousHitsPif.drawAnimation(g2, digital + 1, elapsedTime, posOneDigitalX, posOneDigitalY, false);
            digital = hits / 10;
            if (digital > 0) {
                if (digital > 9) {
                    digital = 9;
                }
                g2.setClip(0, 38, 480, 322);
                this.continuousHitsPif.drawAnimation(g2, digital + 1, elapsedTime, posTensDigitalX, posTensDigitalY, false);
            }
        }
        if (this.isInDialog()) {
            g2.setClip(0, 0, 480, 360);
            this.mainCanvas.drawCombineAnimHorizon(g2, this.dialogPif, 1, 0, 0, 480, true);
            this.dialogPif.drawAnimation(g2, 0, 0, 0, 0, true);
            this.dialogPif.drawAnimation(g2, 2, 0, 480 - this.dialogPif.GetAniFrameWidth(2, 0), 0, true);
            ColRect cr = this.dialogPif.GetColRect(0, 0L, false, 0);
            MainCanvas.font2.drawFastString(g2, MainCanvas.lang[Path.dialog[this.getDialogIndex()][this.getDialogCurSentence()][1]].toCharArray(), this.lines, cr.x, cr.y + 2, 480 - cr.x * 2, 4, this.linesIndex, 2);
            cr = this.dialogPif.GetColRect(2, 0L, false, 0);
            this.dialogPif.drawAnimation(g2, 4, gameTime, cr.x + 480 - this.dialogPif.GetAniFrameWidth(2, 0), cr.y + 2, true);
            cr = this.dialogPif.GetColRect(3, 0L, false, 0);
            if (Path.dialog[this.getDialogIndex()][this.getDialogCurSentence()][0] == 83) {
                this.dialogPif.drawAnimation(g2, 3, 0, 0, this.dialogPif.GetAniFrameHeight(0, 0), false);
                MainCanvas.font2.drawString(g2, MainCanvas.lang[Path.dialog[this.getDialogIndex()][this.getDialogCurSentence()][0]], cr.x, cr.y + this.dialogPif.GetAniFrameHeight(0, 0) + MainCanvas.font2.fontHeight / 2, cr.w, cr.h, 17);
            } else {
                this.dialogPif.drawAnimation(g2, 3, 0, 480 - this.dialogPif.GetAniFrameWidth(3, 0), this.dialogPif.GetAniFrameHeight(2, 0), false);
                MainCanvas.font2.drawString(g2, MainCanvas.lang[Path.dialog[this.getDialogIndex()][this.getDialogCurSentence()][0]], cr.x + 480 - this.dialogPif.GetAniFrameWidth(3, 0), cr.y + this.dialogPif.GetAniFrameHeight(2, 0) + MainCanvas.font2.fontHeight / 2, cr.w, cr.h, 17);
            }
        }
        if (this.isShakeScreen()) {
            g2.translate(-xOffset, -yOffset);
        }
    }

    private void paint() {
        long gameTime = this.getInGameStartedTime();
        int[] clip = new int[4];
        MainCanvas.PushClip(gg, clip);
        this.drawMap(gg, -this.getXMapBackOffset(), 38);
        MainCanvas.PopClip(gg, clip);
        this.drawBossUI(gg, gameTime);
        for (int i2 = actorPool.length - 1; i2 >= 0; --i2) {
            if (actorPool[i2] == null || !actorPool[i2].inUse()) continue;
            gg.setClip(0, 0, 480, 360);
            actorPool[i2].renderGameActor(gg, gameTime);
        }
        clip = null;
        if (!this.isStopScrollBG()) {
            this.xMapBackOffset += this.xMapBackOffsetSpeed;
            while (this.getXMapBackOffset() < 0) {
                this.setXMapBackOffset(this.getXMapBackOffset() + this.getBG_W());
            }
            if (this.getXMapBackOffset() % this.getBG_W() != this.getXMapBackOffset()) {
                this.setXMapBackOffset(this.getXMapBackOffset() % this.getBG_W());
            }
        }
    }

    public int getBG_W() {
        return levelMap.getWidth();
    }

    public boolean isShakeScreen() {
        return this.shakeScreen;
    }

    public void setShakeScreen(boolean shakeScreen) {
        this.shakeScreen = shakeScreen;
    }

    public boolean isDarkScreen() {
        return this.darkScreen;
    }

    public void setDarkScreen(boolean darkScreen) {
        this.darkScreen = darkScreen;
    }

    public void resetBulletPool() {
        for (int i2 = 0; i2 < bulletPool.length; ++i2) {
            if (bulletPool[i2] == null || !bulletPool[i2].inUse()) continue;
            bulletPool[i2].setInUse(false);
        }
    }

    public boolean isLightScreen() {
        return this.lightScreen;
    }

    public void setLightScreen(boolean lightScreen) {
        this.lightScreen = lightScreen;
    }

    public void setBossLifeWidth(int bossLifeWidth) {
        this.bossLifeWidth = bossLifeWidth;
    }

    public int getBossLifeWidth() {
        return this.bossLifeWidth;
    }

    public void setBossLifeBGWidth(int bossLifeBGWidth) {
        this.bossLifeBGWidth = bossLifeBGWidth;
    }

    public int getBossLifeBGWidth() {
        return this.bossLifeBGWidth;
    }

    public void setXMapFrontOffset(int xMapOffset) {
        this.xMapFrontOffset = CMath.I2F(xMapOffset);
    }

    public int getXMapFrontOffset() {
        return CMath.F2I(this.xMapFrontOffset);
    }

    public void setXMapBackOffset(int xMapOffset) {
        this.xMapBackOffset = CMath.I2F(xMapOffset);
    }

    public int getXMapBackOffset() {
        return CMath.F2I(this.xMapBackOffset);
    }

    public void setXPifBGOffset(int xPifBGOffset) {
        this.xPifBGOffset = CMath.I2F(xPifBGOffset);
    }

    public int getXPifBGOffset() {
        return CMath.F2I(this.xPifBGOffset);
    }

    public void setXMapFrontOffsetSpeed(int xMapOffsetSpeed) {
        this.xMapFrontOffsetSpeed = xMapOffsetSpeed;
    }

    public int getXMapFrontOffsetSpeed() {
        return this.isStopScrollBG() ? 0 : this.xMapFrontOffsetSpeed;
    }

    public void setXMapBackOffsetSpeed(int xMapOffsetSpeed) {
        this.xMapBackOffsetSpeed = xMapOffsetSpeed;
    }

    public int getXMapBackOffsetSpeed() {
        return this.isStopScrollBG() ? 0 : this.xMapBackOffsetSpeed;
    }

    public void setXPifBGOffsetSpeed(int xPifBGOffsetSpeed) {
        this.xPifBGOffsetSpeed = xPifBGOffsetSpeed;
    }

    public int getXPifBGOffsetSpeed() {
        return this.isStopScrollBG() ? 0 : this.xPifBGOffsetSpeed;
    }

    public void setStopScrollBG(boolean stopScrollBG) {
        this.stopScrollBG = stopScrollBG;
    }

    public boolean isStopScrollBG() {
        return this.stopScrollBG;
    }

    public void drawMap(Graphics g2, int x, int y) {
        g2.setClip(0, 0, 480, 360);
        for (int drawx = x % this.getBG_W(); drawx < 480; drawx += this.getBG_W()) {
            g2.drawImage(levelMap, drawx, y, 20);
        }
    }

    public void setCurFrameTime(long curFrameTime) {
        this.curFrameTime = curFrameTime;
    }

    public long getCurFrameTime() {
        return this.curFrameTime;
    }

    public void setLightScreenOverlapEnemy(boolean lightScreenOverlapEnemy) {
        this.lightScreenOverlapEnemy = lightScreenOverlapEnemy;
    }

    public boolean isLightScreenOverlapEnemy() {
        return this.lightScreenOverlapEnemy;
    }

    public void setLevelFinished(boolean levelFinished) {
        this.levelFinished = levelFinished;
    }

    public boolean isLevelFinished() {
        return this.levelFinished;
    }

    private boolean shouldLoadTheRes(int levelID, String resName) {
        for (int i2 = 0; i2 < CONSTANT.resourceSpecial_EachLevel[levelID].length; ++i2) {
            if (!resName.equals(CONSTANT.resourceSpecial_EachLevel[levelID][i2])) continue;
            return true;
        }
        return false;
    }

    public void initDialog(int dialogIndex, long gameTime) {
        this.setInDialog(true, gameTime);
        this.setDialogIndex(dialogIndex);
        this.setDialogCurSentence(0);
        ColRect cr = this.dialogPif.GetColRect(0, 0L, false, 0);
        this.lines = MainCanvas.font1.getLineData(MainCanvas.lang[Path.dialog[this.getDialogIndex()][this.getDialogCurSentence()][1]].toCharArray(), 480 - cr.x * 2);
        this.linesIndex = 0;
    }

    public void setInDialog(boolean inDialog, long gameTime) {
        this.inDialog = inDialog;
        if (this.inDialog) {
            MainCanvas.getGameEngine().resetBulletPool();
            this.getPlayer().setGlobalStopProcessing(true, gameTime);
        } else {
            MainCanvas.getGameEngine().resetBulletPool();
            this.getPlayer().setGlobalStopProcessing(false, gameTime);
        }
    }

    public boolean isInDialog() {
        return this.inDialog;
    }

    public void setDialogIndex(int dialogIndex) {
        this.dialogIndex = dialogIndex;
    }

    public int getDialogIndex() {
        return this.dialogIndex;
    }

    public void setDialogCurSentence(int dialogCurSentence) {
        this.dialogCurSentence = dialogCurSentence;
    }

    public int getDialogCurSentence() {
        return this.dialogCurSentence;
    }

    static {
        curKey = -1;
        keyPressed = 0;
        keyReleased = 0;
        img = null;
        img_g = null;
        specialEffect = new int[30][5];
    }
}

