/*
 * Decompiled with CFR 0.152.
 */
package z.playw.j2me.graphics;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import z.playw.DragonGuardian.MainCanvas;
import z.playw.j2me.graphics.ColRect;
import z.playw.j2me.util.PWScreenToolbox;

public class PWPifLifeAnimations {
    public static final byte TRANSFORM_NONE = 0;
    public static final byte TRANSFORM_FLIP_HORIZONTAL = 1;
    public Vector mColRects = new Vector();
    public static final int POOL_DEFAULT_SIZE = 220;
    public static final int POOL_FONT_SIZE = 50;
    int m_precalImagesOffset;
    int m_precalImagesPoolID = -1;
    public static final int POOL_DEFAULT = 0;
    public static final int POOL_FONT = 1;
    public static final int POOLS_COUNT = 2;
    static Image[][] s_precalcImages = new Image[2][];
    static short[][] s_precalcImageId = new short[2][];
    static short[][] s_precalcStack = new short[2][];
    static short[] s_precalcImagesCount = new short[2];
    static short[] s_precalcImageLast = new short[2];
    boolean staticCache = false;
    int bufferSize;
    int[] bufferTmp = null;
    int[] bufferTmpStatic = null;
    int[] bufferToUse;
    int[] beginSprite;
    static int lastPositionBufferStatic;
    int lastPositionBuffer;
    int[] palettes;
    int[] pixelsStartIndex;
    byte[] pixels;
    byte numBitsIndex;
    int indexMask;
    public int paletteNumColors;
    public int numBitsPalette;
    public int numRepetitions;
    byte[] cachePalettes = null;
    public Image[] images;
    public byte numPalettes;
    public byte currentPalette = 0;
    public int numSprites;
    short[] spritesXYDim;
    byte[] spritesDim;
    short[] frameBegins;
    byte[] frames;
    public short[] animationsBegins;
    public byte[] animations;
    public int[] animationLengths;
    public short numAnimations;
    boolean animFinish;
    int framePainted;
    public static final int PIF = 0;
    public static final int PNG = 1;
    public static final int FOREIGN_PNG = 2;
    byte pngMode;
    boolean isLongFormatted;
    Image[] sprImg;
    boolean isNMSF = false;
    Image imgSrc;
    private static int[] crc_table;

    private Vector ReadDataChunk(DataInputStream dis, Vector vec, int v2) {
        try {
            int col_rect_num = dis.readByte();
            for (int n2 = 0; n2 < col_rect_num; ++n2) {
                ColRect col_rect = new ColRect();
                col_rect.line_or_rect = (byte)v2;
                col_rect.ReadData(dis);
                if (col_rect.w > 0 && col_rect.h > 0) {
                    vec.addElement(col_rect);
                    continue;
                }
                col_rect = null;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return vec;
    }

    private void ReadColData(DataInputStream dis) {
        try {
            if (dis.available() == 0) {
                return;
            }
            int num_frms = dis.readShort();
            for (int m2 = 0; m2 < num_frms; ++m2) {
                Vector v_buf = new Vector();
                v_buf = this.ReadDataChunk(dis, v_buf, 1);
                v_buf = this.ReadDataChunk(dis, v_buf, 0);
                this.mColRects.addElement(v_buf);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void SetPrecalcImagePoolSize(int poolID) {
        PWPifLifeAnimations.s_precalcStack[poolID] = new short[s_precalcImagesCount[poolID]];
        for (int i2 = 0; i2 < s_precalcStack[poolID].length; ++i2) {
            PWPifLifeAnimations.s_precalcStack[poolID][i2] = -1;
        }
        switch (poolID) {
            case 1: {
                PWPifLifeAnimations.s_precalcImages[1] = new Image[50];
                PWPifLifeAnimations.s_precalcImageId[1] = new short[50];
                break;
            }
            default: {
                PWPifLifeAnimations.s_precalcImages[0] = new Image[220];
                PWPifLifeAnimations.s_precalcImageId[0] = new short[220];
            }
        }
    }

    public static void FreePrecalcImagePool(int poolID) {
        int i2;
        PWPifLifeAnimations.s_precalcImageLast[poolID] = 0;
        switch (poolID) {
            default: 
        }
        if (s_precalcStack[0] != null) {
            for (i2 = 0; i2 < s_precalcStack[0].length; ++i2) {
                PWPifLifeAnimations.s_precalcStack[0][i2] = -1;
            }
        }
        if (s_precalcImages[0] != null) {
            for (i2 = 0; i2 < s_precalcImages[0].length; ++i2) {
                PWPifLifeAnimations.s_precalcImages[0][i2] = null;
            }
        }
        PWPifLifeAnimations.s_precalcImagesCount[poolID] = 0;
        System.gc();
    }

    public void EnablePrecalcImage(int poolID) {
        this.m_precalImagesOffset = s_precalcImagesCount[poolID];
        int n2 = poolID;
        s_precalcImagesCount[n2] = (short)(s_precalcImagesCount[n2] + this.numPalettes * this.numSprites);
        this.m_precalImagesPoolID = poolID;
    }

    public Image buildSprImage(int sprIndex, int palIndex) {
        int bitsCount = 0;
        int width = this.getSpriteW(sprIndex);
        int height = this.getSpriteH(sprIndex);
        if (width == 1 && height == 1) {
            return null;
        }
        int[] bufferSpr = new int[width * height];
        for (int i2 = this.pixelsStartIndex[sprIndex]; i2 < this.pixelsStartIndex[sprIndex + 1]; ++i2) {
            int index = this.indexMask & this.pixels[i2];
            int rep = ((0xFF & this.pixels[i2]) >>> this.numBitsIndex) + 1;
            System.arraycopy(this.palettes, palIndex * this.numRepetitions * this.paletteNumColors + index * this.numRepetitions, bufferSpr, bitsCount, rep);
            bitsCount += rep;
        }
        return Image.createRGBImage((int[])bufferSpr, (int)width, (int)height, (boolean)true);
    }

    public PWPifLifeAnimations(byte[] data, boolean staticCache) {
        this(data, 0, null, false, -1, false, false, staticCache);
    }

    public PWPifLifeAnimations(byte[] data, int PoolID, boolean staticCache) {
        this(data, 0, null, false, -1, false, false, staticCache);
        if (!staticCache) {
            this.EnablePrecalcImage(PoolID);
        }
    }

    public PWPifLifeAnimations(byte[] data, int offset, int[] palettesToLoad, boolean cachePalettes, int sizeBuffer, boolean staticCache) {
        this(data, offset, palettesToLoad, cachePalettes, sizeBuffer, false, false, staticCache);
    }

    public PWPifLifeAnimations(byte[] data, int offset, int[] palettesToLoad, boolean cachePalettes, int sizeBuffer, boolean groupMode, boolean isNMSF, boolean staticCache) {
        this.isNMSF = isNMSF;
        this.staticCache = staticCache;
        try {
            int k2;
            int j2;
            int k3;
            int elementId;
            ByteArrayInputStream bais = new ByteArrayInputStream(data, offset, data.length - offset);
            DataInputStream dis = new DataInputStream(bais);
            this.pngMode = 0;
            int minBufferSize = 0;
            byte version = dis.readByte();
            if (version == 1) {
                this.isLongFormatted = dis.readByte() == 1;
            }
            int numSprites = dis.readShort();
            this.numSprites = numSprites;
            this.spritesDim = this.isLongFormatted ? new byte[numSprites << 2] : new byte[numSprites << 1];
            for (int j3 = 0; j3 < numSprites; ++j3) {
                elementId = j3 << 1;
                this.updateArray(dis, this.spritesDim, elementId);
                this.updateArray(dis, this.spritesDim, elementId + 1);
                int dim = this.getUnsignedIntValueFromArray(this.spritesDim, elementId) * this.getUnsignedIntValueFromArray(this.spritesDim, elementId + 1);
                minBufferSize = dim > minBufferSize ? dim : minBufferSize;
            }
            int maxPalettes = dis.readByte();
            this.paletteNumColors = 0xFF & dis.readByte();
            this.numBitsPalette = 0xFF & dis.readByte();
            int n2 = this.numRepetitions = this.numBitsPalette == 0 ? 1 : 2 << this.numBitsPalette - 1;
            if (palettesToLoad == null) {
                palettesToLoad = new int[maxPalettes];
                for (int k4 = 0; k4 < maxPalettes; ++k4) {
                    palettesToLoad[k4] = k4;
                }
            }
            this.numPalettes = (byte)palettesToLoad.length;
            this.palettes = new int[this.numPalettes * this.paletteNumColors * this.numRepetitions];
            this.sprImg = new Image[(numSprites + 1) * this.numPalettes];
            byte[] arrayAux = new byte[maxPalettes * this.paletteNumColors * 2];
            dis.read(arrayAux);
            if (palettesToLoad != null) {
                for (int pal = 0; pal < palettesToLoad.length; ++pal) {
                    int pos = palettesToLoad[pal] * this.paletteNumColors * 2;
                    int c2 = 0;
                    while (c2 < this.paletteNumColors) {
                        int color = PWPifLifeAnimations.toIntRGBA(arrayAux, pos);
                        for (k3 = 0; k3 < this.numRepetitions; ++k3) {
                            this.palettes[this.numRepetitions * this.paletteNumColors * pal + this.numRepetitions * c2 + k3] = color;
                        }
                        ++c2;
                        pos += 2;
                    }
                }
            }
            if (cachePalettes) {
                this.cachePalettes = new byte[maxPalettes * (this.paletteNumColors << 1)];
                System.arraycopy(arrayAux, 0, this.cachePalettes, 0, maxPalettes * (this.paletteNumColors << 1));
            }
            this.beginSprite = new int[numSprites * this.numPalettes << 1];
            this.initBeginSpriteArray();
            int numPixels = dis.readInt();
            this.pixelsStartIndex = new int[numSprites + 1];
            for (int n3 = 0; n3 < numSprites; ++n3) {
                this.pixelsStartIndex[n3] = dis.readInt();
            }
            this.pixelsStartIndex[numSprites] = numPixels;
            this.pixels = new byte[numPixels];
            for (int j4 = 0; j4 < numPixels; ++j4) {
                this.pixels[j4] = dis.readByte();
            }
            this.numBitsIndex = (byte)(8 - this.numBitsPalette);
            this.indexMask = 255 >>> this.numBitsPalette;
            int numFrames = dis.readShort();
            this.frameBegins = new short[numFrames + 1];
            this.frameBegins[0] = 0;
            for (j2 = 0; j2 < numFrames; ++j2) {
                this.frameBegins[j2 + 1] = (short)(dis.readShort() * 3);
            }
            if (this.isLongFormatted) {
                this.frames = new byte[this.frameBegins[j2] << 1];
                for (k2 = 0; k2 < this.frames.length / 6; ++k2) {
                    elementId = k2 * 3;
                    this.updateArray(dis, this.frames, elementId);
                    this.updateArray(dis, this.frames, elementId + 1);
                    this.updateArray(dis, this.frames, elementId + 2);
                }
            } else {
                this.frames = new byte[this.frameBegins[j2]];
                for (k2 = 0; k2 < this.frames.length / 3; ++k2) {
                    elementId = k2 * 3;
                    this.updateArray(dis, this.frames, elementId);
                    this.updateArray(dis, this.frames, elementId + 1);
                    this.updateArray(dis, this.frames, elementId + 2);
                }
            }
            this.numAnimations = dis.readShort();
            this.animationsBegins = new short[this.numAnimations + 1];
            this.animationsBegins[0] = 0;
            for (j2 = 0; j2 < this.numAnimations; ++j2) {
                this.animationsBegins[j2 + 1] = (short)(dis.readShort() * 3);
            }
            this.animations = new byte[this.animationsBegins[j2]];
            dis.read(this.animations);
            this.ReadColData(dis);
            this.animationLengths = new int[this.animationsBegins.length - 1];
            for (j2 = 0; j2 < this.animationLengths.length; ++j2) {
                this.animationLengths[j2] = 0;
                int n4 = (this.animationsBegins[j2 + 1] - this.animationsBegins[j2]) / 3;
                for (k3 = 0; k3 < n4; ++k3) {
                    int n5 = j2;
                    this.animationLengths[n5] = this.animationLengths[n5] + (0xFF & this.animations[this.animationsBegins[j2] + k3 * 3 + 1]);
                }
            }
            this.bufferSize = minBufferSize;
            if (this.staticCache) {
                for (int palIndex = 0; palIndex < this.numPalettes; ++palIndex) {
                    for (int sprIndex = 0; sprIndex < numSprites; ++sprIndex) {
                        this.sprImg[sprIndex + numSprites * palIndex] = this.buildSprImage(sprIndex, palIndex);
                    }
                }
                this.pixels = null;
                this.beginSprite = null;
                this.pixelsStartIndex = null;
                this.palettes = null;
            }
            this.beginSprite = null;
            System.gc();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    static final int isPaletteToLoad(int[] palettesToLoad, int palette) {
        for (int i2 = 0; i2 < palettesToLoad.length; ++i2) {
            if (palettesToLoad[i2] != palette) continue;
            return i2;
        }
        return -1;
    }

    public void resetBeginSpriteArray() {
        this.initBeginSpriteArray();
        this.lastPositionBuffer = 0;
    }

    public void initBeginSpriteArray() {
        int numSprites = this.beginSprite.length;
        for (int i2 = 0; i2 < numSprites; ++i2) {
            this.beginSprite[i2] = -1;
        }
    }

    public void setPalette(int palette) {
        if (palette >= this.numPalettes) {
            return;
        }
        this.currentPalette = (byte)palette;
    }

    public int getPalette() {
        return this.currentPalette;
    }

    final void changePaletteColors(short[] colors, int paletteID) {
        if (paletteID < this.palettes.length / (this.paletteNumColors * this.numRepetitions)) {
            for (int j2 = 0; j2 < this.paletteNumColors; ++j2) {
                int color = 0;
                if (colors.length <= j2 + 1) {
                    color = colors[j2];
                }
                for (int k2 = 0; k2 < this.numRepetitions; ++k2) {
                    this.palettes[this.paletteNumColors * this.numRepetitions * paletteID + this.numRepetitions * j2 + k2] = color;
                }
            }
        }
    }

    public final void changePalettes(int[] palettesToLoad) {
        if (this.palettes == null || this.palettes.length < palettesToLoad.length * this.paletteNumColors * this.numRepetitions) {
            this.palettes = new int[palettesToLoad.length * this.paletteNumColors * this.numRepetitions];
        }
        for (int pal = 0; pal < palettesToLoad.length; ++pal) {
            int i2 = palettesToLoad[pal] * this.paletteNumColors << 1;
            for (int j2 = 0; j2 < this.paletteNumColors; ++j2) {
                int color = PWPifLifeAnimations.toIntRGBA(this.cachePalettes, i2);
                i2 += 2;
                for (int k2 = 0; k2 < this.numRepetitions; ++k2) {
                    this.palettes[pal * this.numRepetitions * this.paletteNumColors + j2 * this.numRepetitions + k2] = color;
                }
            }
        }
        this.numPalettes = (byte)palettesToLoad.length;
        this.setPalette(0);
        this.initBeginSpriteArray();
    }

    public int getPaletteColor(int palette, int colorIndex) {
        int color = this.palettes[palette * this.paletteNumColors * this.numRepetitions + this.numRepetitions * colorIndex];
        return color;
    }

    public void changePaletteColor(int palette, int colorIndex, int newColor) {
        for (int i2 = 0; i2 < this.numRepetitions; ++i2) {
            this.palettes[palette * this.paletteNumColors * this.numRepetitions + this.numRepetitions * colorIndex + i2] = newColor;
        }
    }

    public final void drawSpritePIF(Graphics g2, int sprite, int x, int y, byte transformation) {
        Image img = null;
        if (this.staticCache) {
            img = this.sprImg[sprite + this.currentPalette * this.numSprites];
        } else {
            try {
                int stackId = sprite;
                if (this.m_precalImagesPoolID >= 0) {
                    stackId += this.m_precalImagesOffset;
                    short imagePos = s_precalcStack[this.m_precalImagesPoolID][stackId += this.currentPalette * this.numSprites];
                    if (imagePos < 0) {
                        imagePos = s_precalcImageLast[this.m_precalImagesPoolID];
                        if (s_precalcImages[this.m_precalImagesPoolID][imagePos] != null) {
                            PWPifLifeAnimations.s_precalcImages[this.m_precalImagesPoolID][imagePos] = null;
                            PWPifLifeAnimations.s_precalcStack[this.m_precalImagesPoolID][PWPifLifeAnimations.s_precalcImageId[this.m_precalImagesPoolID][imagePos]] = -1;
                        }
                        PWPifLifeAnimations.s_precalcStack[this.m_precalImagesPoolID][stackId] = imagePos;
                        PWPifLifeAnimations.s_precalcImageId[this.m_precalImagesPoolID][imagePos] = (short)stackId;
                        PWPifLifeAnimations.s_precalcImages[this.m_precalImagesPoolID][imagePos] = this.buildSprImage(sprite, this.currentPalette);
                        PWPifLifeAnimations.s_precalcImageLast[this.m_precalImagesPoolID] = (short)((imagePos + 1) % s_precalcImages[this.m_precalImagesPoolID].length);
                    }
                    img = s_precalcImages[this.m_precalImagesPoolID][imagePos];
                }
            }
            catch (Exception e2) {
                System.out.println("load build image error");
            }
        }
        if (transformation == 0) {
            g2.drawImage(img, x, y, 0);
        } else {
            g2.drawRegion(img, 0, 0, this.getSpriteW(sprite), this.getSpriteH(sprite), (int)transformation, x, y, 0);
        }
    }

    public void drawSpritePIF(Graphics g2, int sprite, int x, int y, byte transformation, int anchor) {
        int width = this.getSpriteW(sprite);
        int height = this.getSpriteH(sprite);
        if ((1 & anchor) != 0) {
            x -= width >> 1;
        } else if ((8 & anchor) != 0) {
            x -= width;
        }
        if ((2 & anchor) != 0) {
            y -= height >> 1;
        } else if ((0x20 & anchor) != 0) {
            y -= height;
        }
        this.drawSpritePIF(g2, sprite, x, y, transformation);
    }

    public PWPifLifeAnimations(byte[] data) {
        int i2 = 0;
        this.pngMode = (byte)2;
        try {
            int j2;
            ByteArrayInputStream bais = new ByteArrayInputStream(data, 0, data.length);
            DataInputStream dis = new DataInputStream(bais);
            byte version = dis.readByte();
            if (version == 1) {
                boolean bl = this.isLongFormatted = dis.readByte() == 1;
            }
            if (version == 2) {
                byte srcImgNameLength = dis.readByte();
                byte[] srcImgName = new byte[srcImgNameLength];
                dis.read(srcImgName);
                String strImgName = new String(srcImgName);
                this.imgSrc = PWScreenToolbox.get().getImage(strImgName + ".png");
                strImgName = null;
                srcImgName = null;
            }
            this.numSprites = dis.readShort();
            if (this.isLongFormatted) {
                this.spritesDim = new byte[this.numSprites << 3];
            } else {
                this.spritesDim = new byte[this.numSprites << 1];
                this.spritesXYDim = new short[this.numSprites << 1];
            }
            int elementId = 0;
            for (int j3 = 0; j3 < this.numSprites; ++j3) {
                elementId = j3 << 1;
                this.spritesXYDim[elementId] = dis.readShort();
                this.spritesXYDim[elementId + 1] = dis.readShort();
                this.updateArray(dis, this.spritesDim, elementId);
                this.updateArray(dis, this.spritesDim, elementId + 1);
            }
            int numFrames = dis.readShort();
            i2 += 2;
            this.frameBegins = new short[numFrames + 1];
            this.frameBegins[0] = 0;
            for (j2 = 0; j2 < numFrames; ++j2) {
                this.frameBegins[j2 + 1] = (short)(dis.readShort() * 3);
                i2 += 2;
            }
            this.frames = this.isLongFormatted ? new byte[this.frameBegins[j2] << 1] : new byte[this.frameBegins[j2]];
            dis.read(this.frames);
            this.numAnimations = dis.readShort();
            i2 += 2;
            this.animationsBegins = new short[this.numAnimations + 1];
            this.animationsBegins[0] = 0;
            for (j2 = 0; j2 < this.numAnimations; ++j2) {
                this.animationsBegins[j2 + 1] = (short)(dis.readShort() * 3);
                i2 += 2;
            }
            this.animations = new byte[this.animationsBegins[j2]];
            dis.read(this.animations);
            this.ReadColData(dis);
            i2 += this.animations.length;
            this.animationLengths = new int[this.animationsBegins.length - 1];
            for (j2 = 0; j2 < this.animationLengths.length; ++j2) {
                this.animationLengths[j2] = 0;
                int n2 = (this.animationsBegins[j2 + 1] - this.animationsBegins[j2]) / 3;
                for (int k2 = 0; k2 < n2; ++k2) {
                    int n3 = j2;
                    this.animationLengths[n3] = this.animationLengths[n3] + (0xFF & this.animations[this.animationsBegins[j2] + k2 * 3 + 1]);
                }
            }
            this.numPalettes = 1;
            this.currentPalette = 0;
            System.gc();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public PWPifLifeAnimations(byte[] data, int offset) {
        int i2 = 0;
        this.pngMode = 1;
        try {
            int j2;
            ByteArrayInputStream bais = new ByteArrayInputStream(data, offset, data.length - offset);
            DataInputStream dis = new DataInputStream(bais);
            byte version = dis.readByte();
            if (version == 1) {
                this.isLongFormatted = dis.readByte() == 1;
            }
            this.numSprites = dis.readShort();
            this.spritesDim = this.isLongFormatted ? new byte[this.numSprites << 2] : new byte[this.numSprites << 1];
            int elementId = 0;
            for (int j3 = 0; j3 < this.numSprites; ++j3) {
                elementId = j3 << 1;
                this.updateArray(dis, this.spritesDim, elementId);
                this.updateArray(dis, this.spritesDim, elementId + 1);
            }
            this.images = new Image[this.numSprites << 1];
            byte[] header = new byte[dis.readInt()];
            dis.read(header);
            byte[] palette = new byte[dis.readInt()];
            dis.read(palette);
            byte[] end = new byte[dis.readInt()];
            dis.read(end);
            byte[] tempArrayImage = new byte[dis.readInt() + header.length + palette.length + end.length];
            System.arraycopy(header, 0, tempArrayImage, 0, header.length);
            System.arraycopy(palette, 0, tempArrayImage, header.length, palette.length);
            for (int j4 = 0; j4 < this.numSprites; ++j4) {
                elementId = j4 << 1;
                this.images[j4] = this.readImageDat(dis, tempArrayImage, header, palette, end, this.getUnsignedIntValueFromArray(this.spritesDim, elementId), this.getUnsignedIntValueFromArray(this.spritesDim, elementId + 1));
            }
            int numMirrors = 0xFF & dis.readByte();
            for (int j5 = 0; j5 < numMirrors; ++j5) {
                int id = 0xFF & dis.readByte();
                this.images[id + this.numSprites] = this.readImageDat(dis, tempArrayImage, header, palette, end, this.getSpriteW(id), this.getSpriteH(id));
            }
            tempArrayImage = null;
            int numFrames = dis.readShort();
            i2 += 2;
            this.frameBegins = new short[numFrames + 1];
            this.frameBegins[0] = 0;
            for (j2 = 0; j2 < numFrames; ++j2) {
                this.frameBegins[j2 + 1] = (short)(dis.readShort() * 3);
                i2 += 2;
            }
            this.frames = this.isLongFormatted ? new byte[this.frameBegins[j2] << 1] : new byte[this.frameBegins[j2]];
            dis.read(this.frames);
            this.numAnimations = dis.readShort();
            i2 += 2;
            this.animationsBegins = new short[this.numAnimations + 1];
            this.animationsBegins[0] = 0;
            for (j2 = 0; j2 < this.numAnimations; ++j2) {
                this.animationsBegins[j2 + 1] = (short)(dis.readShort() * 3);
                i2 += 2;
            }
            this.animations = new byte[this.animationsBegins[j2]];
            dis.read(this.animations);
            this.ReadColData(dis);
            i2 += this.animations.length;
            this.animationLengths = new int[this.animationsBegins.length - 1];
            for (j2 = 0; j2 < this.animationLengths.length; ++j2) {
                this.animationLengths[j2] = 0;
                int n2 = (this.animationsBegins[j2 + 1] - this.animationsBegins[j2]) / 3;
                for (int k2 = 0; k2 < n2; ++k2) {
                    int n3 = j2;
                    this.animationLengths[n3] = this.animationLengths[n3] + (0xFF & this.animations[this.animationsBegins[j2] + k2 * 3 + 1]);
                }
            }
            this.numPalettes = 1;
            this.currentPalette = 0;
            System.gc();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private Image readImageDat(DataInputStream dis, byte[] tempArrayImage, byte[] header, byte[] palette, byte[] end, int w2, int h2) throws IOException {
        int posData = header.length + palette.length;
        int length = dis.readInt();
        dis.read(tempArrayImage, posData, length);
        System.arraycopy(end, 0, tempArrayImage, posData + length, end.length);
        PWPifLifeAnimations.toBytes(w2, tempArrayImage, 16);
        PWPifLifeAnimations.toBytes(h2, tempArrayImage, 20);
        long crc = PWPifLifeAnimations.getCRC32(tempArrayImage, 12, 17);
        PWPifLifeAnimations.toBytes((int)crc, tempArrayImage, 29);
        return Image.createImage((byte[])tempArrayImage, (int)0, (int)(length + posData + end.length));
    }

    public void drawSpritePNG(Graphics g2, int sprite, int x, int y, byte transformation) {
        if (transformation == 1 && this.images[sprite + this.numSprites] != null) {
            sprite += this.numSprites;
        }
        g2.drawImage(this.images[sprite], x, y, 20);
    }

    public void drawSpriteForeignPNG(Graphics g2, int sprite, int x, int y, byte transformation) {
        if (transformation == 1) {
            // empty if block
        }
        int[] clip = new int[4];
        MainCanvas.PushClip(g2, clip);
        int spriteX = this.getSpriteX(sprite);
        int spriteY = this.getSpriteY(sprite);
        int spriteW = this.getSpriteW(sprite);
        int spriteH = this.getSpriteH(sprite);
        g2.setClip(x, y, spriteW, spriteH);
        g2.drawImage(this.imgSrc, x - spriteX, y - spriteY, 20);
        MainCanvas.PopClip(g2, clip);
    }

    public void drawSpritePNG(Graphics g2, int sprite, int x, int y, byte transformation, int anchor) {
        if ((1 & anchor) != 0) {
            x -= this.images[sprite].getWidth() >> 1;
        } else if ((8 & anchor) != 0) {
            x -= this.images[sprite].getWidth();
        }
        if ((2 & anchor) != 0) {
            y -= this.images[sprite].getHeight() >> 1;
        } else if ((0x20 & anchor) != 0) {
            y -= this.images[sprite].getHeight();
        }
        this.drawSpritePNG(g2, sprite, x, y, transformation);
    }

    public static long getCRC32(byte[] buf, int off, int len) {
        int c2;
        if (crc_table == null) {
            crc_table = new int[256];
            for (int n2 = 0; n2 < 256; ++n2) {
                c2 = n2;
                int k2 = 8;
                while (--k2 >= 0) {
                    if ((c2 & 1) != 0) {
                        c2 = 0xEDB88320 ^ c2 >>> 1;
                        continue;
                    }
                    c2 >>>= 1;
                }
                PWPifLifeAnimations.crc_table[n2] = c2;
            }
        }
        int crc = 0;
        c2 = ~crc;
        while (--len >= 0) {
            c2 = crc_table[(c2 ^ buf[off++]) & 0xFF] ^ c2 >>> 8;
        }
        crc = ~c2;
        return (long)crc & 0xFFFFFFFFL;
    }

    static final short toShort(byte[] data, int i2) {
        return (short)((0xFF & data[i2]) << 8 | 0xFF & data[i2 + 1]);
    }

    final int updateArray(DataInputStream dis, byte[] array, int idx) {
        try {
            if (this.isLongFormatted) {
                array[idx <<= 1] = dis.readByte();
                array[idx + 1] = dis.readByte();
                return 2;
            }
            array[idx] = dis.readByte();
            return 1;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return 0;
        }
    }

    static final int toInt(byte[] data, int start) {
        return (0xFF & data[start]) << 24 | (0xFF & data[start + 1]) << 16 | (0xFF & data[start + 2]) << 8 | 0xFF & data[start + 3];
    }

    static final void toBytes(int num, byte[] data, int start) {
        data[start] = (byte)((num & 0xFF000000) >> 24);
        data[start + 1] = (byte)((num & 0xFF0000) >> 16);
        data[start + 2] = (byte)((num & 0xFF00) >> 8);
        data[start + 3] = (byte)(num & 0xFF);
    }

    static final short intColortoShortColor(int color) {
        short a2 = (short)((0xFF & color >> 24) / 16);
        short r2 = (short)((0xFF & color >> 16) / 16);
        short g2 = (short)((0xFF & color >> 8) / 16);
        short b2 = (short)((0xFF & color) / 16);
        return (short)(a2 << 12 | r2 << 8 | g2 << 4 | b2);
    }

    static final int shortColorToIntColor(short color) {
        int a2 = (0xF & color >> 12) * 16;
        int r2 = (0xF & color >> 8) * 16;
        int g2 = (0xF & color >> 4) * 16;
        int b2 = (0xF & color) * 16;
        return a2 << 24 | r2 << 16 | g2 << 8 | b2;
    }

    static final int toIntRGBA(byte[] data, int start) {
        return (0xF0 & data[start]) * 17 << 20 | (0xF & data[start]) * 17 << 16 | (0xF0 & data[start + 1]) * 17 << 4 | (0xF & data[start + 1]) * 17;
    }

    public void arraycopy(int color, int[] dst, int dst_position, int length) {
        switch (length) {
            case 1: {
                dst[dst_position] = color;
                break;
            }
            case 2: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                break;
            }
            case 3: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                break;
            }
            case 4: {
                int n2 = color;
                dst[dst_position + 1] = n2;
                dst[dst_position] = n2;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                break;
            }
            case 5: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                break;
            }
            case 6: {
                int n3 = color;
                dst[dst_position + 1] = n3;
                dst[dst_position] = n3;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                break;
            }
            case 7: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                break;
            }
            case 8: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                break;
            }
            case 9: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                break;
            }
            case 10: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                break;
            }
            case 11: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                dst[dst_position + 10] = color;
                break;
            }
            case 12: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                dst[dst_position + 10] = color;
                dst[dst_position + 11] = color;
                break;
            }
            case 13: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                dst[dst_position + 10] = color;
                dst[dst_position + 11] = color;
                dst[dst_position + 12] = color;
                break;
            }
            case 14: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                dst[dst_position + 10] = color;
                dst[dst_position + 11] = color;
                dst[dst_position + 12] = color;
                dst[dst_position + 13] = color;
                break;
            }
            case 15: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                dst[dst_position + 10] = color;
                dst[dst_position + 11] = color;
                dst[dst_position + 12] = color;
                dst[dst_position + 13] = color;
                dst[dst_position + 14] = color;
                break;
            }
            case 16: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                dst[dst_position + 10] = color;
                dst[dst_position + 11] = color;
                dst[dst_position + 12] = color;
                dst[dst_position + 13] = color;
                dst[dst_position + 14] = color;
                dst[dst_position + 15] = color;
                break;
            }
            default: {
                this.arraycopy(color, dst, dst_position, 16);
                this.arraycopy(color, dst, dst_position + 16, length - 16);
            }
        }
    }

    public final int getSpriteX(int sprite) {
        if (this.pngMode == 2) {
            return this.spritesXYDim[sprite << 1];
        }
        return -1;
    }

    public final int getSpriteY(int sprite) {
        if (this.pngMode == 2) {
            return this.spritesXYDim[(sprite << 1) + 1];
        }
        return -1;
    }

    public final int getSpriteW(int sprite) {
        return this.getUnsignedIntValueFromArray(this.spritesDim, sprite << 1);
    }

    public final int getSpriteH(int sprite) {
        return this.getUnsignedIntValueFromArray(this.spritesDim, (sprite << 1) + 1);
    }

    public int getFrameWidth(int frame) {
        int p0X = Integer.MAX_VALUE;
        int p1X = Integer.MIN_VALUE;
        for (int i2 = this.frameBegins[frame]; i2 < this.frameBegins[frame + 1]; i2 += 3) {
            int despX = this.getIntValueFromArray(this.frames, i2 + 1);
            int w2 = this.getSpriteW(this.getUnsignedIntValueFromArray(this.frames, i2));
            p0X = Math.min(p0X, despX);
            p1X = Math.max(p1X, despX + w2);
        }
        return p1X - p0X;
    }

    private int getIntValueFromArray(byte[] array, int offset) {
        if (this.isLongFormatted) {
            return array[offset <<= 1] << 8 | array[offset + 1];
        }
        return array[offset];
    }

    private int getUnsignedIntValueFromArray(byte[] array, int offset) {
        if (this.isLongFormatted) {
            return 0xFFFF & (array[offset <<= 1] << 8 | array[offset + 1]);
        }
        return 0xFF & array[offset];
    }

    public int getFrameHeight(int frame) {
        int p0Y = Integer.MAX_VALUE;
        int p1Y = Integer.MIN_VALUE;
        for (int i2 = this.frameBegins[frame]; i2 < this.frameBegins[frame + 1]; i2 += 3) {
            int despY = this.getIntValueFromArray(this.frames, i2 + 2);
            int h2 = this.getSpriteH(this.getUnsignedIntValueFromArray(this.frames, i2));
            p0Y = Math.min(p0Y, despY);
            p1Y = Math.max(p1Y, despY + h2);
        }
        return p1Y - p0Y;
    }

    public void drawSprite(Graphics g2, int sprite, int x, int y, byte transformation) {
        if (this.pngMode == 1) {
            this.drawSpritePNG(g2, sprite, x, y, transformation);
        }
        if (this.pngMode == 2) {
            this.drawSpriteForeignPNG(g2, sprite, x, y, transformation);
        }
        if (this.pngMode == 0 && this.getSpriteW(sprite) > 1 && this.getSpriteH(sprite) > 1) {
            this.drawSpritePIF(g2, sprite, x, y, transformation);
        }
    }

    public void drawSprite(Graphics g2, int sprite, int x, int y, byte transformation, int anchor) {
        if (this.pngMode == 1) {
            this.drawSpritePNG(g2, sprite, x, y, transformation, anchor);
        }
        if (this.pngMode == 2) {
            this.drawSpriteForeignPNG(g2, sprite, x, y, transformation);
        }
        if (this.pngMode == 0) {
            this.drawSpritePIF(g2, sprite, x, y, transformation, anchor);
        }
    }

    public final void drawFrame(Graphics g2, int frame, int x, int y, byte transformation) {
        for (int i2 = this.frameBegins[frame]; i2 < this.frameBegins[frame + 1]; i2 += 3) {
            int spr = this.getIntValueFromArray(this.frames, i2);
            transformation = 0;
            int posX = x + this.getIntValueFromArray(this.frames, i2 + 1);
            int posY = y + this.getIntValueFromArray(this.frames, i2 + 2);
            int spriteW = this.getSpriteW(spr);
            int spriteH = this.getSpriteH(spr);
            if (posX < -spriteW || posX > 480 + spriteW || posY < -spriteH || posY > 360 + spriteH) continue;
            this.drawSprite(g2, spr, posX, posY, transformation);
        }
    }

    public void resetAnimation(int animationID) {
    }

    public final int drawAnimation(Graphics g2, int animation, long time, int x, int y, byte globalTransformation, boolean cyclical) {
        int frp = this.getFramePos(animation, time, cyclical);
        this.drawFrame(g2, this.animations[frp] & 0xFF, x, y, (byte)0);
        return this.animFinish ? -1 : this.framePainted;
    }

    public int drawAnimation(Graphics g2, int animation, long time, int x, int y, byte globalTransformation) {
        return this.drawAnimation(g2, animation, time, x, y, globalTransformation, true);
    }

    public int drawAnimation(Graphics g2, int animation, int time, int x, int y, boolean cyclical) {
        return this.drawAnimation(g2, animation, time, x, y, (byte)0, cyclical);
    }

    public int drawAnimation(Graphics g2, int animation, long time, int x, int y, boolean cyclical) {
        return this.drawAnimation(g2, animation, time, x, y, (byte)0, cyclical);
    }

    public final int getFramePos(int animId, long time, boolean cyclical) {
        this.animFinish = false;
        time /= 10L;
        if (cyclical) {
            time %= (long)this.animationLengths[animId];
        } else if (time >= (long)this.animationLengths[animId]) {
            this.animFinish = true;
            time = this.animationLengths[animId];
        }
        int t2 = 0;
        int frame = 0;
        while ((long)t2 < time) {
            if ((long)(t2 += this.animations[this.animationsBegins[animId] + frame * 3 + 1] & 0xFF) >= time) continue;
            ++frame;
        }
        this.framePainted = frame;
        return this.animationsBegins[animId] + frame * 3;
    }

    public boolean animationIsOver(int animId, int time) {
        return time / 10 >= this.animationLengths[animId];
    }

    public final int getFrameId(int animationId, int index) {
        int frp = this.animationsBegins[animationId] + index * 3;
        if (frp >= this.animationsBegins[animationId + 1]) {
            return -1;
        }
        return this.animations[frp];
    }

    public int GetFrameNum(int animationId) {
        int i2 = 0;
        while (this.getFrameId(animationId, i2) != -1) {
            ++i2;
        }
        return i2;
    }

    public int GetAniFrameWidth(int ani_id, int idx) {
        return this.getFrameWidth(this.getFrameId(ani_id, idx));
    }

    public int GetAniFrameHeight(int ani_id, int idx) {
        return this.getFrameHeight(this.getFrameId(ani_id, idx));
    }

    public Vector GetColRects(int ani_id, int frm_id) {
        return (Vector)this.mColRects.elementAt(this.getFrameId(ani_id, frm_id));
    }

    public Vector GetColRects(int ani_id, long game_time, boolean ani_is_loop) {
        return (Vector)this.mColRects.elementAt(this.animations[this.getFramePos(ani_id, game_time, ani_is_loop)]);
    }

    public Vector GetColRectsByFrameID(int ani_id, int frameID) {
        return (Vector)this.mColRects.elementAt(this.animations[frameID]);
    }

    public ColRect GetColRect(int ani_id, long game_time, boolean ani_is_loop, int val) {
        Vector col_rects = this.GetColRects(ani_id, game_time, ani_is_loop);
        for (int i2 = 0; i2 < col_rects.size(); ++i2) {
            ColRect cr = (ColRect)col_rects.elementAt(i2);
            if (val != cr.GetVal()) continue;
            return cr;
        }
        return null;
    }

    public ColRect GetColRect(int total_frame_id, int val) {
        Vector col_rects = (Vector)this.mColRects.elementAt(total_frame_id);
        for (int i2 = 0; i2 < col_rects.size(); ++i2) {
            ColRect cr = (ColRect)col_rects.elementAt(i2);
            if (val != cr.GetVal()) continue;
            return cr;
        }
        return null;
    }

    public int GetAniFrameWidth(int ani_id, long game_time, boolean ani_is_loop) {
        return this.getFrameWidth(this.animations[this.getFramePos(ani_id, game_time, ani_is_loop)]);
    }

    public int GetAniFrameHeight(int ani_id, long game_time, boolean ani_is_loop) {
        return this.getFrameHeight(this.animations[this.getFramePos(ani_id, game_time, ani_is_loop)]);
    }
}

