/*
 * Decompiled with CFR 0.152.
 */
package z.playw.DragonGuardian;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import z.playw.j2me.util.PWScreenToolbox;

public class GraphicSet {
    public static final byte FirstValidInfo = 0;
    public static final byte Info_WITHOUT_INFO = 0;
    public static final byte Info_FLOOR = 1;
    public static final byte Info_PLATFORM = 2;
    public static final byte Info_PLATFORM_END = 3;
    public static final byte Info_STAIRS = 4;
    public static final byte Info_PIPE1 = 5;
    public static final byte Info_PIPE1_SE = 6;
    public static final byte Info_PIPE2 = 7;
    public static final byte Info_PIPE2_SE = 8;
    public static final byte Info_PIPE3 = 9;
    public static final byte Info_PIPE3_SE = 10;
    public static final byte Info_OBJECT = 11;
    public static final byte Info_WALL = 12;
    public static final byte Info_HOLLOW = 13;
    public static final byte LastValidInfo = 13;
    private int nElements;
    private byte tileW;
    private byte tileH;
    private byte tilesWide;
    private byte tilesHigh;
    private byte[] tilesInfo;
    private Image tiles;

    public GraphicSet(String file, byte tileWidth, byte tileHeight) {
        this.tileW = tileWidth;
        this.tileH = tileHeight;
        this.tiles = PWScreenToolbox.get().getImage(file);
        this.tilesWide = (byte)(this.tiles.getWidth() / this.tileW);
        this.tilesHigh = (byte)(this.tiles.getHeight() / this.tileH);
        this.nElements = this.tilesWide * this.tilesHigh;
        this.tilesInfo = new byte[this.nElements];
    }

    public final void setTileInfo(int tileId, byte info) {
        if (info < 0) {
            System.out.println("Informaci\u00f3n no v\u00e1lida");
        }
        this.tilesInfo[tileId] = info;
    }

    public final byte getTileInfo(int tileId) {
        if (tileId < this.tilesInfo.length) {
            return this.tilesInfo[tileId];
        }
        return 0;
    }

    public final int getNElements() {
        return this.nElements;
    }

    public final void renderTile(Graphics g2, int x, int y, int tileId, byte mirrorInfo) {
        int i2 = tileId / this.tilesWide;
        int j2 = tileId % this.tilesWide;
        int realX = x - j2 * this.tileW;
        int realY = y - i2 * this.tileH;
        g2.setClip(x, y, (int)this.tileW, (int)this.tileH);
        if (mirrorInfo == 0) {
            g2.drawImage(this.tiles, realX, realY, 20);
        } else {
            g2.drawRegion(this.tiles, j2 * this.tileW, i2 * this.tileH, (int)this.tileW, (int)this.tileH, (int)mirrorInfo, x, y, 20);
        }
    }

    public static final void loadTileInfo(String filename, GraphicSet set) {
        try {
            ByteArrayInputStream bytes = new ByteArrayInputStream(PWScreenToolbox.get().getResource(filename));
            DataInputStream dis = new DataInputStream(bytes);
            for (int i2 = 0; i2 < set.getNElements(); ++i2) {
                set.setTileInfo(i2, dis.readByte());
            }
            dis.close();
            return;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return;
        }
    }
}

