/*
 * Decompiled with CFR 0.152.
 */
package z.playw.DragonGuardian;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import z.playw.DragonGuardian.CMath;
import z.playw.DragonGuardian.GameActor;
import z.playw.DragonGuardian.GameEngine;
import z.playw.DragonGuardian.MainCanvas;
import z.playw.DragonGuardian.Player;
import z.playw.j2me.graphics.ColRect;

public class GameBullet
extends GameActor {
    public static final byte STATUS_FLY = 0;
    public static final byte STATUS_BOOM = 1;
    public static final byte STATUS_CATCH = 2;
    public static final byte STATUS_BORN = 3;
    public static final int SUBTYPE_PLAYER_LEVEL_0 = 0;
    public static final int SUBTYPE_PLAYER_LEVEL_1 = 1;
    public static final int SUBTYPE_PLAYER_LEVEL_2_0 = 2;
    public static final int SUBTYPE_PLAYER_LEVEL_2_1 = 3;
    public static final int SUBTYPE_PLAYER_LEVEL_2_2 = 4;
    public static final int SUBTYPE_PLAYER_LEVEL_3_0 = 5;
    public static final int SUBTYPE_PLAYER_LEVEL_3_1 = 6;
    public static final int SUBTYPE_PLAYER_LEVEL_3_2 = 7;
    public static final int SUBTYPE_PLAYER_LEVEL_4_0 = 8;
    public static final int SUBTYPE_PLAYER_LEVEL_4_1 = 9;
    public static final int SUBTYPE_PLAYER_LEVEL_4_2 = 10;
    public static final int SUBTYPE_SUPER_ATTACK_FIRE_STONE_STORM = 11;
    public static final int SUBTYPE_BOSS_SUPER_ATTACK = 12;
    public static final int SUBTYPE_BOSS_NORMAL_ATTACK = 13;
    public static final int SUBTYPE_BOMB_SMALL = 14;
    public static final int SUBTYPE_SUPER_ATTACK_ICE_STORM = 15;
    public static final int SUBTYPE_BURN_FIRE = 16;
    public static final int SUBTYPE_BOMB_BIG = 17;
    public static final int SUBTYPE_STAY_BURN = 18;
    public static final int SUBTYPE_TAIL = 19;
    public static final int SUBTYPE_SHORTGUN = 20;
    public static final int SUBTYPE_SHORTGUN_VENOM = 21;
    public static final int SUBTYPE_SPIDER_WEB = 22;
    public static final int SUBTYPE_MAGIC_LINE_FIRE = 23;
    public static final int SUBTYPE_BOSS_SHORT_GUN_2 = 24;
    public static final int SUBTYPE_BOSS_BLASTER = 25;
    public static final int SUBTYPE_SHORT_GUN_3 = 26;
    public static final int SUBTYPE_BOSS_LASER = 27;
    public static final int SUBTYPE_BOSS_BAT = 28;
    public static final int SUBTYPE_BOSS_GENERAL_TAIL = 29;
    public static final int SUBTYPE_BOSS_CIRCLE = 30;
    public static final int SUBTYPE_BOSS_SWORD_GUN = 31;
    public static final int SUBTYPE_BOSS_CALLED_SKULL = 32;
    public static final int SUBTYPE_BOSS_SWORD_ATT = 33;
    public static final int SUBTYPE_BOSS_SHOOT_LINE = 34;
    public static final int SUBTYPE_BOSS_SUPER_ICE = 35;
    public static final int SUBTYPE_BOSS_SMALL_ICE = 36;
    public static final int SUBTYPE_BOSS_SWORD_EDGE = 37;
    public static final int SUBTYPE_BOSS_KING_SHORT_GUN = 38;
    private int goalX;
    private int goalY;
    public int mDamage;
    public long mStayTime;
    public int mCycleRadius;
    public int mCycleAngel;

    public void init(long gameTime, int type) {
        this.setType(type);
        this.setSubType(0);
        this.setState((byte)0, gameTime);
        this.setInUse(true);
        this.mDamage = 4;
        this.mStayTime = -1L;
        this.mCycleRadius = 40;
        this.mCycleAngel = 0;
    }

    public void setState(byte newState, long time) {
        switch (this.getType()) {
            case 2: {
                this.setStateBurnFire(newState, time);
                break;
            }
            case 3: {
                this.setStateBossNormalAtt(newState, time);
                break;
            }
            case 4: {
                this.setStateBigBomb(newState, time);
                break;
            }
            case 5: {
                this.setStateStayBurn(newState, time);
                break;
            }
            case 6: {
                this.setStateShortGunVenmo(newState, time);
                break;
            }
            case 7: {
                this.setStateSpiderWeb(newState, time);
                break;
            }
            case 8: {
                this.setStateBat(newState, time);
                break;
            }
            case 9: {
                this.setStateSword(newState, time);
                break;
            }
            default: {
                this.setStateNormal(newState, time);
            }
        }
    }

    public void setStateShortGunVenmo(byte newState, long time) {
        this.stateStartTime = time;
        super.setState(newState, time);
        switch (newState) {
            case 0: {
                this.setRenderContent(0, true, time);
                break;
            }
            case 1: {
                this.setRenderContent(1, false, time);
                break;
            }
            default: {
                this.setRenderContent(0, true, time);
            }
        }
    }

    public void setStateSpiderWeb(byte newState, long time) {
        this.stateStartTime = time;
        super.setState(newState, time);
        switch (newState) {
            case 0: {
                this.setRenderContent(3, true, time);
                break;
            }
            case 1: {
                this.setRenderContent(2, false, time);
                break;
            }
            case 2: {
                this.setRenderContent(2, false, time);
                break;
            }
            default: {
                this.setRenderContent(3, true, time);
            }
        }
    }

    public void setStateBat(byte newState, long time) {
        this.stateStartTime = time;
        super.setState(newState, time);
        switch (newState) {
            case 0: {
                this.setRenderContent(0, true, time);
                break;
            }
            case 3: {
                this.setRenderContent(1, false, time);
                break;
            }
            default: {
                this.setRenderContent(0, true, time);
            }
        }
    }

    public void setStateSword(byte newState, long time) {
        this.stateStartTime = time;
        super.setState(newState, time);
        switch (newState) {
            case 0: {
                this.setRenderContent(6, true, time);
                break;
            }
            case 3: {
                this.setRenderContent(5, false, time);
                break;
            }
            case 1: {
                this.setRenderContent(0, false, time);
            }
        }
    }

    public void setStateStayBurn(byte newState, long time) {
        this.stateStartTime = time;
        super.setState(newState, time);
        switch (newState) {
            case 0: {
                this.setRenderContent(12, true, time);
                break;
            }
            default: {
                this.setRenderContent(12, true, time);
            }
        }
    }

    public void setStateBigBomb(byte newState, long time) {
        super.setState(newState, time);
        switch (newState) {
            case 0: {
                this.setRenderContent(3, true, time);
                break;
            }
            case 1: {
                this.setRenderContent(0, false, time);
                break;
            }
            default: {
                this.setRenderContent(3, true, time);
            }
        }
    }

    public void setStateBossNormalAtt(byte newState, long time) {
        super.setState(newState, time);
        switch (newState) {
            case 0: {
                this.setRenderContent(3, true, time);
                break;
            }
            case 1: {
                this.setRenderContent(0, false, time);
                break;
            }
            default: {
                this.setRenderContent(3, true, time);
            }
        }
    }

    public void setStateBurnFire(byte newState, long time) {
        super.setState(newState, time);
        switch (newState) {
            case 0: {
                this.setRenderContent(1, true, time);
                break;
            }
            case 1: {
                this.setRenderContent(0, false, time);
                break;
            }
            default: {
                this.setRenderContent(1, true, time);
            }
        }
    }

    public void setStateNormal(byte newState, long time) {
        super.setState(newState, time);
        switch (newState) {
            case 0: {
                this.setRenderContent(0 + this.getSubType() - 0, true, time);
                break;
            }
            case 1: {
                this.setRenderContent(0, false, time);
            }
            default: {
                this.setRenderContent(0, true, time);
            }
        }
    }

    private void bombBullet(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        GameActor[] bulletPool = GameEngine.getBulletPool();
        int addCount = 0;
        for (int i2 = 0; i2 < bulletPool.length; ++i2) {
            if (bulletPool[i2] != null && bulletPool[i2].inUse()) continue;
            if (bulletPool[i2] == null) {
                bulletPool[i2] = new GameBullet();
            }
            bulletPool[i2].setAnimation(gameEngine.enemy01BulletPif);
            bulletPool[i2].init(gameTime, 1);
            bulletPool[i2].setSubType(14);
            bulletPool[i2].setX(this.getX());
            bulletPool[i2].setY(this.getY());
            if (addCount == 0) {
                bulletPool[i2].setVy(3);
                bulletPool[i2].setVx(3);
            } else if (addCount == 1) {
                bulletPool[i2].setVy(-3);
                bulletPool[i2].setVx(3);
            } else if (addCount == 2) {
                bulletPool[i2].setVy(3);
                bulletPool[i2].setVx(-3);
            } else if (addCount == 3) {
                bulletPool[i2].setVy(-3);
                bulletPool[i2].setVx(-3);
            }
            if (++addCount > 3) break;
        }
    }

    private void bombSmallIce(long gameTime, GameActor[] actorPool, GameEngine gameEngine, int bulletnum) {
        GameActor[] bulletPool = GameEngine.getBulletPool();
        int addCount = 0;
        for (int i2 = 0; i2 < bulletPool.length; ++i2) {
            if (bulletPool[i2] != null && bulletPool[i2].inUse()) continue;
            if (bulletPool[i2] == null) {
                bulletPool[i2] = new GameBullet();
            }
            bulletPool[i2].setAnimation(gameEngine.enemy01BulletPif);
            bulletPool[i2].init(gameTime, 1);
            bulletPool[i2].setSubType(36);
            bulletPool[i2].setX(this.getX());
            bulletPool[i2].setY(this.getY());
            int shootAngel = CMath.getRandNumber(0, 360);
            bulletPool[i2].setRawVy(CMath.sin(shootAngel) * 3);
            bulletPool[i2].setRawVx(CMath.cos(shootAngel) * 3);
            ((GameBullet)bulletPool[i2]).mDamage = this.mDamage;
            if (++addCount > bulletnum - 1) break;
        }
    }

    public void process(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isStopProcessing()) {
            return;
        }
        block0 : switch (this.getState()) {
            case 0: {
                this.updatePosition();
                this.processFly(gameTime, actorPool, gameEngine);
                if (this.getType() == 0) {
                    if (this.getSubType() == 11) {
                        if (this.getX() <= 120 || this.getY() <= 199) break;
                        this.setState((byte)1, gameTime);
                        MainCanvas.getGameEngine().setLightScreenOverlapEnemy(true);
                        this.setRenderContent(4, false, gameTime);
                        this.setVx(1);
                        this.setVy(1);
                        break;
                    }
                    for (int i2 = 0; i2 < actorPool.length; ++i2) {
                        if (actorPool[i2] == null || !actorPool[i2].inUse() || actorPool[i2].getType() != 1 || actorPool[i2].getSubType() == 31) continue;
                        if (actorPool[i2].getSubType() == 4) {
                            Vector col_rects = actorPool[i2].getAnimation().GetColRects(actorPool[i2].animID, gameTime, actorPool[i2].animCyclic);
                            ColRect crSelf = new ColRect();
                            ColRect crOther = new ColRect();
                            crSelf.Copy(this.getX(), this.getY(), this.getColRect(gameTime, 0));
                            for (int index = 0; index < col_rects.size(); ++index) {
                                ColRect cr = (ColRect)col_rects.elementAt(index);
                                if (0 != cr.GetVal()) continue;
                                crOther.Copy(actorPool[i2].getX(), actorPool[i2].getY(), cr);
                                if (!ColRect.RectIntersect(crOther, crSelf)) continue;
                                if (this.getSubType() != 15) {
                                    actorPool[i2].reduceLife(MainCanvas.getGameEngine().getPlayer().getPlayerATL(), 0, crOther, gameTime);
                                }
                                this.setState((byte)1, gameTime);
                                switch (this.getSubType()) {
                                    case 15: {
                                        this.setRenderContent(3 + CMath.getRandNumber(0, 1), false, gameTime);
                                        this.setVx(1);
                                        this.setVy(-1);
                                        break;
                                    }
                                    default: {
                                        this.setAnimation(gameEngine.boom01Pif);
                                        break;
                                    }
                                }
                                break;
                            }
                            crSelf = null;
                            crOther = null;
                            continue;
                        }
                        if (actorPool[i2].IsCollideWithShield(gameTime, this)) {
                            this.setState((byte)1, gameTime);
                            this.setVx(1);
                            switch (this.getSubType()) {
                                case 15: {
                                    this.setRenderContent(3 + CMath.getRandNumber(0, 1), false, gameTime);
                                    this.setVx(1);
                                    this.setVy(-1);
                                    break;
                                }
                                default: {
                                    this.setAnimation(gameEngine.boom01Pif);
                                }
                            }
                            if (this.getSubType() == 15) break block0;
                            actorPool[i2].reduceShieldLife(4);
                            break block0;
                        }
                        if (!this.isCollide(gameTime, actorPool[i2], 0, 0)) continue;
                        this.setState((byte)1, gameTime);
                        if (this.getSubType() != 15) {
                            actorPool[i2].reduceLife(MainCanvas.getGameEngine().getPlayer().getPlayerATL(), 0, this.getIntersectRect(gameTime, actorPool[i2], 0, 0), gameTime);
                        }
                        this.setVx(1);
                        switch (this.getSubType()) {
                            case 15: {
                                this.setRenderContent(3 + CMath.getRandNumber(0, 1), false, gameTime);
                                this.setVx(1);
                                this.setVy(-1);
                                break block0;
                            }
                        }
                        this.setAnimation(gameEngine.boom01Pif);
                        break block0;
                    }
                    break;
                }
                boolean continueProcess = true;
                if (this.getSubType() != 18 && this.getSubType() != 22 && this.getSubType() != 33 && this.getSubType() != 30 && gameEngine.getPlayer().IsCollideWithShield(gameTime, this)) {
                    switch (this.getSubType()) {
                        case 16: {
                            if (this.getState() != 1) {
                                this.setState((byte)1, gameTime);
                            }
                            gameEngine.getPlayer().reduceShieldLife(4);
                            continueProcess = false;
                            break;
                        }
                        case 21: {
                            this.setState((byte)1, gameTime);
                            this.setVx(-1);
                            this.setVy(0);
                            gameEngine.getPlayer().reduceShieldLife(4);
                            continueProcess = false;
                            break;
                        }
                        case 25: {
                            this.setState((byte)1, gameTime);
                            this.setVx(-1);
                            this.setVy(0);
                            this.setRenderContent(1, false, gameTime);
                            gameEngine.getPlayer().reduceShieldLife(4);
                            continueProcess = false;
                            break;
                        }
                        case 18: {
                            continueProcess = true;
                            break;
                        }
                        case 22: {
                            continueProcess = true;
                            break;
                        }
                        default: {
                            this.setState((byte)1, gameTime);
                            this.setVx(-1);
                            this.setVy(0);
                            this.setAnimation(gameEngine.boom00Pif);
                            gameEngine.getPlayer().reduceShieldLife(4);
                            continueProcess = false;
                        }
                    }
                }
                if (!continueProcess || !this.isCollide(gameTime, gameEngine.getPlayer(), 0, 0)) break;
                switch (this.getSubType()) {
                    case 16: {
                        if (this.getState() != 1) {
                            this.setState((byte)1, gameTime);
                        }
                        gameEngine.getPlayer().reduceLife(this.mDamage, 0, this.getIntersectRect(gameTime, gameEngine.getPlayer(), 0, 0), gameTime);
                        break block0;
                    }
                    case 21: {
                        this.setState((byte)1, gameTime);
                        this.setVx(-1);
                        this.setVy(0);
                        gameEngine.getPlayer().reduceLife(this.mDamage, 12, this.getIntersectRect(gameTime, gameEngine.getPlayer(), 0, 0), gameTime);
                        break block0;
                    }
                    case 25: {
                        this.setState((byte)1, gameTime);
                        this.setVx(-1);
                        this.setVy(0);
                        this.setRenderContent(1, false, gameTime);
                        gameEngine.getPlayer().reduceLife(this.mDamage, 0, this.getIntersectRect(gameTime, gameEngine.getPlayer(), 0, 0), gameTime);
                        break block0;
                    }
                    case 30: {
                        gameEngine.getPlayer().reduceLife(this.mDamage, 0, this.getIntersectRect(gameTime, gameEngine.getPlayer(), 0, 0), gameTime);
                        break block0;
                    }
                    case 18: {
                        gameEngine.getPlayer().reduceLife(this.mDamage, 0, this.getIntersectRect(gameTime, gameEngine.getPlayer(), 0, 0), gameTime);
                        break block0;
                    }
                    case 22: {
                        if (gameEngine.getPlayer().getState() == 9 || gameEngine.getPlayer().isPlayerDead()) break block0;
                        this.setState((byte)2, gameTime);
                        this.setRelatePlayer(gameEngine.getPlayer());
                        this.setX(gameEngine.getPlayer().getX());
                        this.setY(gameEngine.getPlayer().getY());
                        gameEngine.getPlayer().setRelatePlayer(this);
                        this.getRelatePlayer().beginNotify(gameTime, 8);
                        this.setPowerNewton(this.mDamage);
                        break block0;
                    }
                    case 35: {
                        this.setState((byte)1, gameTime);
                        this.setVx(-1);
                        this.setVy(0);
                        this.setAnimation(gameEngine.boom00Pif);
                        gameEngine.getPlayer().reduceLife(this.mDamage << 2, 0, this.getIntersectRect(gameTime, gameEngine.getPlayer(), 0, 0), gameTime);
                        break block0;
                    }
                    default: {
                        this.setState((byte)1, gameTime);
                        this.setVx(-1);
                        this.setVy(0);
                        this.setAnimation(gameEngine.boom00Pif);
                        gameEngine.getPlayer().reduceLife(this.mDamage, 0, this.getIntersectRect(gameTime, gameEngine.getPlayer(), 0, 0), gameTime);
                    }
                }
                break;
            }
            case 1: {
                this.processBomb(gameTime, actorPool, gameEngine);
                break;
            }
            case 3: {
                if (this.getSubType() == 33) {
                    if (!this.isAnimationOver(gameTime)) break;
                    this.setState((byte)0, gameTime);
                    break;
                }
                this.proBatBorn(gameTime);
                break;
            }
            case 2: {
                if (this.getRelatePlayer() == null) break;
                if (((Player)this.getRelatePlayer()).isPlayerDead()) {
                    this.getRelatePlayer().setRelatePlayer(null);
                    this.setRelatePlayer(null);
                    this.setInUse(false);
                    break;
                }
                if (gameTime - this.stateStartTime > 5000L || this.getPowerNewton() <= 0) {
                    this.getRelatePlayer().endNotify(gameTime, 8);
                    this.getRelatePlayer().setRelatePlayer(null);
                    this.setRelatePlayer(null);
                    this.setInUse(false);
                    break;
                }
                this.getRelatePlayer().setX(this.getX());
                this.getRelatePlayer().setY(this.getY());
                break;
            }
        }
    }

    private void proBatBorn(long gameTime) {
        if (this.isAnimationOver(gameTime)) {
            int xDiff = MainCanvas.getGameEngine().getPlayer().getX() - this.getX();
            int yDiff = MainCanvas.getGameEngine().getPlayer().getY() - this.getY();
            int absdifx = Math.abs(xDiff);
            int absdify = Math.abs(yDiff);
            int speed = Math.abs(this.vx);
            if (absdify != 0 || absdifx != 0) {
                if (absdify > absdifx) {
                    this.vx = speed * absdifx / absdify;
                    this.vy = speed;
                } else if (absdify < absdifx) {
                    this.vx = speed;
                    this.vy = speed * absdify / absdifx;
                } else {
                    this.vx = speed;
                    this.vy = speed;
                }
            } else {
                this.vx = speed;
                this.vy = 0;
            }
            this.vx = xDiff > 0 ? this.vx : -this.vx;
            this.vy = yDiff > 0 ? this.vy : -this.vy;
            this.setState((byte)0, gameTime);
        }
    }

    private void processBomb(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        switch (this.getSubType()) {
            case 16: {
                if (this.animID == 0) {
                    if (this.isAnimationOver(gameTime)) {
                        this.setRenderContent(2, false, gameTime);
                    }
                } else if (this.animID == 2 && this.isAnimationOver(gameTime)) {
                    this.setInUse(false);
                }
                if (!this.isCollide(gameTime, gameEngine.getPlayer(), 0, 0)) break;
                gameEngine.getPlayer().reduceLife(this.mDamage, 0, this.getIntersectRect(gameTime, gameEngine.getPlayer(), 0, 0), gameTime);
                break;
            }
            default: {
                if (this.isAnimationOver(gameTime)) {
                    this.setInUse(false);
                    break;
                }
                this.setX(this.getX() + this.getVx());
            }
        }
    }

    private void processFly(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        switch (this.getSubType()) {
            case 11: {
                if (this.getX() <= 480 && this.getY() <= 360) break;
                this.setInUse(false);
                break;
            }
            case 15: {
                if (this.getX() <= 480 && (this.getY() >= 38 || this.getVy() >= 0)) break;
                this.setInUse(false);
                break;
            }
            case 19: {
                this.proTail(gameTime, gameEngine);
                break;
            }
            case 35: {
                this.proTail(gameTime, gameEngine);
                if ((gameTime - this.stateStartTime) % 1000L >= 100L) break;
                this.bombSmallIce(gameTime, actorPool, gameEngine, 3);
                break;
            }
            case 16: {
                if (!this.moveToArea(this.goalX, this.goalY, this.getVx(), 0, 0, true, gameTime, false)) break;
                this.setState((byte)1, gameTime);
                break;
            }
            case 30: {
                int ty;
                int tx;
                if (this.getRelatePlayer() == null || !this.getRelatePlayer().inUse()) {
                    this.setRelatePlayer(null);
                    this.setInUse(false);
                    return;
                }
                if (this.mStayTime != -1L && gameTime - this.stateStartTime >= this.mStayTime) {
                    this.setSubType(28);
                    this.vy = 6 * CMath.sin(this.mCycleAngel);
                    this.vx = 6 * CMath.cos(this.mCycleAngel);
                    this.setRelatePlayer(null);
                    return;
                }
                this.mCycleAngel += 15;
                this.mCycleAngel %= 360;
                ColRect selfRect = this.getRelatePlayer().getColRect(gameTime, 0);
                if (selfRect != null) {
                    tx = this.getRelatePlayer().getX() + selfRect.x + (selfRect.w >> 1) + CMath.F2I(this.mCycleRadius * CMath.cos(this.mCycleAngel));
                    ty = this.getRelatePlayer().getY() + selfRect.y + (selfRect.h >> 1) + CMath.F2I(this.mCycleRadius * CMath.sin(this.mCycleAngel));
                } else {
                    tx = this.getRelatePlayer().getX() + CMath.F2I(this.mCycleRadius * CMath.cos(this.mCycleAngel));
                    ty = this.getRelatePlayer().getY() + CMath.F2I(this.mCycleRadius * CMath.sin(this.mCycleAngel));
                }
                this.setX(tx);
                this.setY(ty);
                break;
            }
            case 18: {
                ColRect crself3;
                if (gameTime - this.stateStartTime > 5000L) {
                    this.setInUse(false);
                }
                if (!gameEngine.isStopScrollBG()) {
                    this.x -= gameEngine.getXMapFrontOffsetSpeed();
                }
                if ((crself3 = this.getColRect(gameTime, 0)) != null) {
                    if (this.getX() + crself3.w >= 0) break;
                    this.setInUse(false);
                    break;
                }
                if (this.getX() >= 0) break;
                this.setInUse(false);
                break;
            }
            case 17: {
                if (!this.moveToArea(this.goalX, this.goalY, this.getVx(), 0, 0, true, gameTime, false)) break;
                this.bombBullet(gameTime, actorPool, gameEngine);
                this.setInUse(false);
                break;
            }
            case 13: {
                if (this.getX() >= 0) break;
                this.setInUse(false);
                break;
            }
            case 27: {
                if (this.getY() <= 360) break;
                this.setInUse(false);
                break;
            }
            default: {
                if (this.getX() > 480 || this.getX() < 0) {
                    this.setInUse(false);
                }
                if (this.getY() <= 360 && this.getY() >= 38) break;
                this.setInUse(false);
            }
        }
    }

    private void proTail(long gameTime, GameEngine gameEngine) {
        if (gameTime - this.stateStartTime < 2000L) {
            Player player = gameEngine.getPlayer();
            ColRect rect = player.getColRect(gameTime, 0);
            if (rect != null) {
                this.moveToArea(player.getX(), player.getY() - (rect.h >> 1), 3, rect.w >> 1, rect.h >> 1, true, gameTime, false);
            }
        } else {
            if (this.getVx() == 0) {
                this.vx = this.x - this.lastX == 0 ? CMath.I2F(1) : this.x - this.lastX;
                this.vy = this.y - this.lastY;
            } else {
                this.x += this.vx;
                this.y += this.vy;
            }
            if (this.getX() > 480 || this.getX() < 0) {
                this.setInUse(false);
            }
            if (this.getY() > 360 || this.getY() < 38) {
                this.setInUse(false);
            }
        }
    }

    private void updatePosition() {
        if (this.getType() == 0) {
            if (this.getSubType() == 11) {
                this.setX(this.getX() + this.getVx());
                this.setY(this.getY() + this.getVy());
            } else if (this.getSubType() == 15) {
                this.setVy(this.getVy() + this.getAy());
                this.setVx(this.getVx() + this.getAx());
                this.setX(this.getX() + this.getVx());
                this.setY(this.getY() + this.getVy());
            } else {
                this.x += this.vx;
                this.y += this.vy;
            }
        } else {
            switch (this.getSubType()) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 30: 
                case 35: {
                    break;
                }
                case 13: 
                case 14: 
                case 25: 
                case 27: {
                    this.setX(this.getX() + this.getVx());
                    this.setY(this.getY() + this.getVy());
                    break;
                }
                case 21: 
                case 28: 
                case 31: 
                case 33: 
                case 34: 
                case 36: {
                    this.x += this.vx;
                    this.y += this.vy;
                    break;
                }
                default: {
                    this.setX(this.getX() - 5);
                }
            }
        }
    }

    public static byte getSTATUS_FLY() {
        return 0;
    }

    public void reduceLife(int reducePoint, int type, ColRect rc, long gametime) {
    }

    public void beginNotify(long gameTime, int type) {
        this.setInUse(false);
    }

    public void endNotify(long gameTime, int type) {
    }

    public void setGoalX(int goalX) {
        this.goalX = goalX;
    }

    public int getGoalX() {
        return this.goalX;
    }

    public void setGoalY(int goalY) {
        this.goalY = goalY;
    }

    public int getGoalY() {
        return this.goalY;
    }

    public void renderGameActor(Graphics g2, long gameTime) {
        if (this.getSubType() == 22 && this.getRelatePlayer() != null) {
            this.getRelatePlayer().basicRenderGameActor(g2, gameTime);
        }
        super.renderGameActor(g2, gameTime);
    }
}

