/*
 * Decompiled with CFR 0.152.
 */
package z.playw.DragonGuardian;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import z.playw.DragonGuardian.CMath;
import z.playw.DragonGuardian.GameActor;
import z.playw.DragonGuardian.GameBonus;
import z.playw.DragonGuardian.GameBullet;
import z.playw.DragonGuardian.GameEngine;
import z.playw.DragonGuardian.MainCanvas;
import z.playw.j2me.graphics.ColRect;
import z.playw.j2me.graphics.PWPifLifeAnimations;

public class Player
extends GameActor {
    public static final byte STATUS_WAIT = 0;
    public static final byte STATUS_ATTACK = 1;
    public static final byte STATUS_SUPER_ATTACK_FIRE_STONE_STORM = 2;
    public static final byte STATUS_SUPER_ATTACK_ICE_STORM = 3;
    public static final byte STATUS_SUPER_ATTACK_SPLITTER = 4;
    public static final byte STATUS_SUPER_ATTACK_LIGHT_DRAGON = 5;
    public static final byte STATUS_HURT = 6;
    public static final byte STATUS_EJECT = 7;
    public static final byte STATUS_LEVEL_UP = 8;
    public static final byte STATUS_CAUGHT = 9;
    public static final byte STATUS_DEAD = 10;
    public static final byte STATUS_REVIVAL = 11;
    public static final byte SUB_STATUS_NORMAL = 0;
    public static final byte SUB_STATUS_ATTRACT_BY_BOSS_THREE_HEAD = 1;
    public static final byte SUB_STATUS_EJECTING_RIGHT = 2;
    public static final byte SUB_STATUS_EJECTED_RIGHT = 3;
    public static final byte SUB_STATUS_EJECTING_TOP = 4;
    public static final byte SUB_STATUS_EJECTED_TOP = 5;
    public static final byte SUB_STATUS_LEVEL_UP_BEGIN = 6;
    public static final byte SUB_STATUS_LEVEL_UP_END = 7;
    public static byte curWeapon = 0;
    public static byte curMagic = 0;
    public static byte[] magicManaCost = new byte[]{30, 35, 40, 50};
    public static final int MAGIC_LEVEL_REQUIRE = 0;
    public static final int MAGIC_LEVEL0_POINT = 1;
    public static final int MAGIC_LEVEL1_POINT = 2;
    public static final int MAGIC_LEVEL2_POINT = 3;
    private static short[][] magicLevelRequirement = new short[][]{{0, 0, 1000, 3000}, {4, 0, 1000, 4000}, {9, 0, 3000, 11000}, {14, 0, 10000, 30000}};
    public static short[][] magicDamage = new short[][]{{200, 400, 600}, {400, 600, 800}, {600, 800, 1000}, {1000, 1300, 1920}};
    public static char[] experience = new char[]{'\u0000', 'x', '\u0168', '\u02d0', '\u04b0', '\u0708', '\u09d8', '\u0d20', '\u10e0', '\u1518', '\u19c8', '\u1ef0', '\u25bc', '\u2aa8', '\u3138', '\u3840', '\u3fc0', '\u47b8', '\u5028', '\u5910', '\u6270', '\u6bd0', '\u7530', '\u7e90', '\u87f0', '\u9150', '\u9ab0', '\ua410', '\uad70', '\ub6d0'};
    private static int playerSouls = 0;
    private static int playerLevel = 0;
    private static int playerLevel_next = 0;
    private static int playerHP = 0;
    private static int playerPoint = 0;
    private static char[] playerProperty = new char[]{'\u00d8', '\b', '\u0000', '\u0006', '\f', '\u0006', '\u0007', '\u0003', '\u0000', 'x', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    private static final int iceStormVyMin = (int)CMath.sqrt(160L);
    private static final int iceStormVyMax = (int)CMath.sqrt(644L);
    private int IceStormSkillsSpeed = CMath.I2F(8);
    private int skillsAnimID;
    private long skillsAnimTime;
    private int skillsAnimX;
    private int skillsAnimY;
    private long poisonTime = 0L;
    private int playerAttackClose = 0;
    public int playerAttackFarAway = 6;
    private int playerLife = 216;
    private int playerMagicDamage = 8;
    private int playerDefenceClose = 12;
    private int playerDefenceFarAway = 6;
    private int playerFlySpeed = 7;
    private int playerLeanFlySpeed = 5;
    private int playerSpirit = 3;
    private static int totalKilledEnemy = 0;
    private static int deadCount = 0;
    private static int maxContinuousHits = 0;
    private static long totalPlayedTime = 0L;
    private static int bulletLevel = 0;
    private boolean addBullet = true;
    private int lastEffectX = 0;
    private int continuousHits = 0;
    private long lastHitTime = 0L;
    private int attackAnim = 0;
    private long invincibleTime = 0L;
    private int mana = 0;
    private long manaRestoreTime = 0L;
    private long renderPowerUpTime;
    private int[][] splitterInfo = new int[50][5];
    private final int SPLITTER_SHADOW_INFO_COUNT;
    private int[][][] splitterShadowInfo = new int[this.splitterInfo.length][10][3];
    private long[][] lightDragonPosition = new long[][]{{0L, -1L, 0L, 0L}, {0L, -1L, 0L, 0L}, {0L, -1L, 0L, 0L}};

    public Player() {
        this.SPLITTER_SHADOW_INFO_COUNT = 10;
    }

    public static boolean isMagicLocked(int magic) {
        return Player.getPlayerPropertyArray()[8] < magicLevelRequirement[magic][0];
    }

    public static int getMagicLevel(int magic) {
        int level = 0;
        if ((short)Player.getPlayerPropertyArray()[13 + magic] >= Player.getMagicLevelRequirement()[magic][2]) {
            level = 1;
        }
        if ((short)Player.getPlayerPropertyArray()[13 + magic] >= Player.getMagicLevelRequirement()[magic][3]) {
            level = 2;
        }
        return level;
    }

    public static int getMagicLevel() {
        return Player.getMagicLevel(curMagic);
    }

    public int getSuperAttackDamage() {
        return magicDamage[curMagic][Player.getMagicLevel()] + this.playerMagicDamage;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void process(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        int level;
        if (this.isStopProcessing()) {
            if (!MainCanvas.getGameEngine().isInDialog() && gameTime - GameActor.stopProcessingTime > (long)(80 * GameActor.playerHitLevel)) {
                this.setGlobalStopProcessing(false, gameTime);
                MainCanvas.getGameEngine().setShakeScreen(false);
            }
            if (!MainCanvas.getGameEngine().isInDialog()) {
                this.stateStartTime += MainCanvas.getGameEngine().getCurFrameTime();
            }
            return;
        }
        if (this.manaRestoreTime > 5000L) {
            this.setMana(this.getMana() + this.playerSpirit);
            if (this.getMana() > 100) {
                this.setMana(100);
            }
            this.manaRestoreTime = 0L;
        } else {
            this.manaRestoreTime += MainCanvas.getGameEngine().getCurFrameTime();
        }
        if (this.getInvincibleTime() > 0L) {
            long newTime = this.getInvincibleTime() - gameEngine.getCurFrameTime();
            this.setInvincibleTime(newTime > 0L ? newTime : 0L);
        }
        if (this.getPoisonTime() > 0L) {
            long oldTime = this.getPoisonTime() / 1000L;
            this.setPoisonTime(this.getPoisonTime() - gameEngine.getCurFrameTime());
            if (this.getPoisonTime() < 0L) {
                this.setPoisonTime(0L);
            }
            if (this.getPoisonTime() / 1000L != oldTime) {
                if (this.getPoisonTime() > 0L) {
                    this.setLife(this.getLife() - 4);
                }
                if (this.getLife() <= 0) {
                    this.setLife(0);
                    this.setState((byte)10, gameTime);
                }
            }
            MainCanvas.getGameEngine().playerPif.setPalette(1);
        } else {
            MainCanvas.getGameEngine().playerPif.setPalette(0);
        }
        if (Player.getPlayerLevel_next() == 0 && !this.isPlayerDead() && this.getRelatePlayer() == null && (level = Player.getPlayerLevel()) < experience.length - 1) {
            this.setState((byte)8, gameTime);
            Player.setPlayerLevel(Player.getPlayerLevel() + 1);
            Player.setPlayerLevel_next(experience[level + 1] - experience[level]);
            Player.setPlayerHP(Player.getPlayerHP() + 10);
            this.setMaxlife(this.getMaxlife() + 10);
            this.setLife(this.getLife() + 10);
            Player.setPlayerPoint(Player.getPlayerPoint() + 4);
        }
        switch (this.getState()) {
            case 0: {
                this.processWait(gameTime, gameEngine);
                break;
            }
            case 9: {
                if (GameEngine.keyReleased != 512 || this.getRelatePlayer() == null) break;
                this.getRelatePlayer().setPowerNewton(this.getRelatePlayer().getPowerNewton() + -10);
                break;
            }
            case 1: {
                this.processAttack(gameTime, actorPool);
                break;
            }
            case 10: {
                this.x += this.vx;
                this.y += this.vy;
                this.vy += this.ay;
                break;
            }
            case 11: {
                this.setX(this.getX() + 3);
                break;
            }
            case 6: {
                this.processKey(gameTime);
                if (this.isAnimationOver(gameTime)) {
                    this.setX(this.getX() - 14);
                    this.setState((byte)0, gameTime);
                    break;
                }
                if (this.getColRect(gameTime, 0) == null) break;
                break;
            }
            case 7: {
                if (this.getSubType() == 2) {
                    if (this.canMove(gameTime, -28, 0)) {
                        this.setX(this.getX() - 28);
                        break;
                    }
                    this.setSubType(3);
                    break;
                }
                if (this.getSubType() == 4) {
                    if (this.canMove(gameTime, 0, 28)) {
                        this.setY(this.getY() + 28);
                        break;
                    }
                    this.setSubType(5);
                    break;
                }
                if (this.getSubType() == 3) {
                    if (this.getX() < 28) {
                        MainCanvas.getGameEngine().setShakeScreen(true);
                        if (this.canMove(gameTime, 7, 0)) {
                            this.setX(this.getX() + 7);
                            break;
                        }
                        MainCanvas.getGameEngine().setShakeScreen(false);
                        this.setState((byte)0, gameTime);
                        break;
                    }
                    MainCanvas.getGameEngine().setShakeScreen(false);
                    this.setState((byte)0, gameTime);
                    break;
                }
                if (this.getSubType() != 5) break;
                if (this.getY() > 332) {
                    MainCanvas.getGameEngine().setShakeScreen(true);
                    if (this.canMove(gameTime, 0, -7)) {
                        this.setY(this.getY() - 7);
                        break;
                    }
                    MainCanvas.getGameEngine().setShakeScreen(false);
                    this.setState((byte)0, gameTime);
                    break;
                }
                MainCanvas.getGameEngine().setShakeScreen(false);
                this.setState((byte)0, gameTime);
                break;
            }
            case 2: {
                this.processFireStoneStorm(gameTime, gameEngine);
                break;
            }
            case 3: {
                this.processIceStorm(gameTime, gameEngine);
                break;
            }
            case 5: {
                this.processLightDragon(gameTime, gameEngine);
                break;
            }
            case 4: {
                this.processSplitter(gameTime, actorPool);
                break;
            }
            case 8: {
                if (this.getSubType() == 6) {
                    if (!this.isAnimationOver(gameTime)) break;
                    this.setRenderContent(17, true, gameTime);
                    this.setSubType(7);
                    break;
                }
                PWPifLifeAnimations levelUpLineAnim = MainCanvas.getGameEngine().leveluplinePif;
                if (!levelUpLineAnim.animationIsOver(2, (int)(gameTime - this.stateStartTime))) break;
                MainCanvas.getGameEngine().setDarkScreen(false);
                this.setState((byte)0, gameTime);
                this.invokeEndSuperAttack(gameTime, 5);
                break;
            }
        }
        if (this.getContinuousHits() > 0 && gameTime - this.getLastHitTime() > 2000L) {
            this.setContinuousHits(0);
            this.setLastHitTime(0L);
        }
        if (this.getSubType() == 1) {
            ColRect crBoss = null;
            GameActor boss = null;
            for (int i2 = 0; i2 < GameEngine.actorPool.length; ++i2) {
                if (GameEngine.actorPool[i2] == null) continue;
                if (!GameEngine.actorPool[i2].inUse()) continue;
                if (GameEngine.actorPool[i2].getSubType() != 4) continue;
                boss = GameEngine.actorPool[i2];
                crBoss = GameEngine.actorPool[i2].getColRect(gameTime, 3);
                break;
            }
            if (crBoss != null) {
                ColRect crSelf = this.getColRect(gameTime, 0);
                if (!this.moveToArea(crBoss.x + (crBoss.w >> 1) + boss.getX(), crBoss.y + boss.getY() + (crSelf.h >> 1), 7, crBoss.w, crBoss.h, true, gameTime, false)) {
                    // empty if block
                }
            } else {
                this.setSubType(0);
            }
        }
        this.processShield(gameTime);
    }

    private void invokeEndSuperAttack(long gameTime, int type) {
        GameEngine gameEngine = MainCanvas.getGameEngine();
        int i2 = 0;
        while (true) {
            if (i2 >= GameEngine.actorPool.length) break;
            if (GameEngine.actorPool[i2] != null) {
                MainCanvas.getGameEngine();
                if (GameEngine.actorPool[i2].inUse()) {
                    GameEngine.actorPool[i2].endNotify(gameTime, type);
                }
            }
            ++i2;
        }
        i2 = 0;
        while (true) {
            if (i2 >= GameEngine.bonusPool.length) break;
            if (GameEngine.bonusPool[i2] != null) {
                MainCanvas.getGameEngine();
                if (GameEngine.bonusPool[i2].inUse()) {
                    GameEngine.bonusPool[i2].endNotify(gameTime, type);
                }
            }
            ++i2;
        }
    }

    private void processFireStoneStorm(long gameTime, GameEngine gameEngine) {
        block8: {
            block9: {
                block7: {
                    if (this.animID != 9) break block7;
                    if (!this.isAnimationOver(gameTime)) break block8;
                    MainCanvas.getGameEngine().setDarkScreen(false);
                    MainCanvas.getGameEngine().setShakeScreen(true);
                    this.setRenderContent(++this.animID, false, gameTime);
                    break block8;
                }
                if (!this.isAnimationOver(gameTime)) break block9;
                boolean superAttackEnd = true;
                int bulletIndex = 0;
                while (true) {
                    if (bulletIndex >= GameEngine.bulletPool.length) break;
                    if (GameEngine.bulletPool[bulletIndex] != null) {
                        if (GameEngine.bulletPool[bulletIndex].inUse()) {
                            if (GameEngine.bulletPool[bulletIndex].getSubType() == 11) {
                                superAttackEnd = false;
                                break;
                            }
                        }
                    }
                    ++bulletIndex;
                }
                if (!superAttackEnd) break block8;
                this.setState((byte)0, gameTime);
                this.invokeEndSuperAttack(gameTime, 0);
                break block8;
            }
            int i2 = 0;
            GameActor[] bulletPool = GameEngine.getBulletPool();
            if (i2 >= bulletPool.length || bulletPool[i2] != null && bulletPool[i2].inUse() && bulletPool[i2].getSubType() == 11) break block8;
            if (bulletPool[i2] == null) {
                bulletPool[i2] = new GameBullet();
            }
            bulletPool[i2].setAnimation(gameEngine.superAttackFireStoneStormPif);
            bulletPool[i2].init(gameTime, 0);
            bulletPool[i2].setSubType(11);
            bulletPool[i2].setRenderContent(0, true, gameTime);
            ColRect rcFireStorm = bulletPool[i2].getColRect(gameTime, 0);
            int totalWidth = rcFireStorm.x + rcFireStorm.w + 120;
            int totalHeight = rcFireStorm.y + rcFireStorm.h + 161;
            int posX = 0;
            int posY = 0;
            if (totalWidth < totalHeight) {
                posX = -rcFireStorm.x - rcFireStorm.w;
                posY = 199 - (120 - posX);
            } else {
                posY = -rcFireStorm.y - rcFireStorm.h;
                posX = 120 - (161 - posY);
            }
            bulletPool[i2].setX(posX);
            bulletPool[i2].setY(posY);
            bulletPool[i2].setVx(8);
            bulletPool[i2].setVy(bulletPool[i2].getVx());
        }
    }

    private void processIceStorm(long gameTime, GameEngine gameEngine) {
        if (this.animID == 11) {
            if (this.isAnimationOver(gameTime)) {
                MainCanvas.getGameEngine().setDarkScreen(false);
                MainCanvas.getGameEngine().setShakeScreen(true);
                this.setRenderContent(++this.animID, false, gameTime);
                this.skillsAnimID = 0;
                this.skillsAnimTime = gameTime;
                ColRect rc = MainCanvas.getGameEngine().skillsPif.GetColRect(this.skillsAnimID, gameTime, false, 0);
                this.skillsAnimX = CMath.I2F(-rc.x - rc.w);
                this.skillsAnimY = CMath.I2F(38 - rc.y);
            }
        } else if (this.skillsAnimID != -1) {
            ColRect rc = MainCanvas.getGameEngine().skillsPif.GetColRect(this.skillsAnimID, gameTime - this.skillsAnimTime, false, 0);
            if (this.skillsAnimID == 0) {
                this.skillsAnimX += this.IceStormSkillsSpeed;
                if (CMath.F2I(this.skillsAnimX) + rc.x > 0) {
                    this.skillsAnimX = CMath.I2F(-rc.x);
                    this.skillsAnimID = 1;
                    this.skillsAnimTime = gameTime;
                }
            } else if (MainCanvas.getGameEngine().skillsPif.animationIsOver(this.skillsAnimID, (int)(gameTime - this.skillsAnimTime))) {
                this.skillsAnimX -= this.IceStormSkillsSpeed;
                if (CMath.F2I(this.skillsAnimX) + rc.x + rc.w < 0) {
                    this.skillsAnimID = -1;
                } else {
                    GameActor[] bulletPool = GameEngine.getBulletPool();
                    int addCount = 0;
                    for (int i2 = 0; i2 < bulletPool.length; ++i2) {
                        if (bulletPool[i2] != null && bulletPool[i2].inUse() && bulletPool[i2].getSubType() == 15) continue;
                        if (bulletPool[i2] == null) {
                            bulletPool[i2] = new GameBullet();
                        }
                        bulletPool[i2].setAnimation(gameEngine.superAttackIceStormPif);
                        bulletPool[i2].init(gameTime, 0);
                        bulletPool[i2].setSubType(15);
                        bulletPool[i2].setX(CMath.getRandNumber(-120, 120));
                        bulletPool[i2].setY(CMath.getRandNumber(-41, 161));
                        int iceType = CMath.getRandNumber(0, 2);
                        bulletPool[i2].setRenderContent(iceType, true, gameTime);
                        int vy = CMath.getRandNumber(iceStormVyMin, iceStormVyMax);
                        int t2 = 2 * vy / 1;
                        int vx = CMath.getRandNumber(240 / t2, 720 / t2);
                        bulletPool[i2].setVx(vx);
                        bulletPool[i2].setVy(vy);
                        bulletPool[i2].setAx(0);
                        bulletPool[i2].setAy(-1);
                        if (++addCount <= 2) {
                            continue;
                        }
                        break;
                    }
                }
            }
        } else if (this.isAnimationOver(gameTime)) {
            boolean superAttackEnd = true;
            int bulletIndex = 0;
            while (true) {
                if (bulletIndex >= GameEngine.bulletPool.length) break;
                if (GameEngine.bulletPool[bulletIndex] != null) {
                    if (GameEngine.bulletPool[bulletIndex].inUse()) {
                        if (GameEngine.bulletPool[bulletIndex].getSubType() == 15) {
                            superAttackEnd = false;
                            break;
                        }
                    }
                }
                ++bulletIndex;
            }
            if (superAttackEnd) {
                this.setState((byte)0, gameTime);
                this.invokeEndSuperAttack(gameTime, 3);
            }
        }
    }

    private void processLightDragon(long gameTime, GameEngine gameEngine) {
        if (this.animID == 13) {
            if (this.isAnimationOver(gameTime)) {
                MainCanvas.getGameEngine().setDarkScreen(false);
                MainCanvas.getGameEngine().setShakeScreen(true);
                this.setRenderContent(++this.animID, false, gameTime);
            }
        } else {
            if (this.lightDragonPosition[0][1] == -1L) {
                this.lightDragonPosition[0][0] = this.getLightDragonXPosition();
                this.lightDragonPosition[0][1] = 38L;
                this.lightDragonPosition[0][2] = CMath.getRandNumber(0, 1000);
            }
            if (this.lightDragonPosition[0][1] - 38L > 161L && this.lightDragonPosition[1][1] == -1L) {
                this.lightDragonPosition[1][0] = this.getLightDragonXPosition();
                this.lightDragonPosition[1][1] = 38L;
                this.lightDragonPosition[0][2] = CMath.getRandNumber(0, 1000);
            }
            if (this.lightDragonPosition[1][1] - 38L > 161L && this.lightDragonPosition[2][1] == -1L) {
                this.lightDragonPosition[2][0] = this.getLightDragonXPosition();
                this.lightDragonPosition[2][1] = 38L;
                this.lightDragonPosition[0][2] = CMath.getRandNumber(0, 1000);
            }
            PWPifLifeAnimations animationLightDragon = MainCanvas.getGameEngine().lightDragonPif;
            for (int i2 = 0; i2 < this.lightDragonPosition.length; ++i2) {
                if (this.lightDragonPosition[i2][1] < 0L) continue;
                if (this.lightDragonPosition[i2][1] - (long)animationLightDragon.GetAniFrameHeight(0, 0) < 322L) {
                    long[] lArray = this.lightDragonPosition[i2];
                    lArray[1] = lArray[1] + 10L;
                    if (this.lightDragonPosition[i2][1] >= 78L && (this.lightDragonPosition[i2][1] <= 319L || this.lightDragonPosition[i2][1] >= 360L)) continue;
                    MainCanvas.getGameEngine().setLightScreen(true);
                    continue;
                }
                long[] lArray = this.lightDragonPosition[i2];
                lArray[3] = lArray[3] + 1L;
            }
            if (this.isAnimationOver(gameTime)) {
                boolean superAttackEnd = true;
                for (int i3 = 0; i3 < this.lightDragonPosition.length; ++i3) {
                    if (this.lightDragonPosition[i3][3] >= 5L) continue;
                    superAttackEnd = false;
                    break;
                }
                if (superAttackEnd) {
                    this.setState((byte)0, gameTime);
                    this.invokeEndSuperAttack(gameTime, 4);
                }
            }
        }
    }

    private void initSplitterShadowInfo() {
        for (int i2 = 0; i2 < this.splitterShadowInfo.length; ++i2) {
            for (int j2 = 0; j2 < this.splitterShadowInfo[i2].length; ++j2) {
                for (int k2 = 0; k2 < this.splitterShadowInfo[i2][j2].length; ++k2) {
                    this.splitterShadowInfo[i2][j2][k2] = -1;
                }
            }
        }
    }

    private void pushSplitterShadowInfo(int splitterIndex, int frameID, int x, int y) {
        for (int i2 = this.splitterShadowInfo[splitterIndex].length - 1; i2 > 0; --i2) {
            for (int j2 = 0; j2 < this.splitterShadowInfo[splitterIndex][i2].length; ++j2) {
                this.splitterShadowInfo[splitterIndex][i2][j2] = this.splitterShadowInfo[splitterIndex][i2 - 1][j2];
            }
        }
        this.splitterShadowInfo[splitterIndex][0][0] = frameID;
        this.splitterShadowInfo[splitterIndex][0][1] = x;
        this.splitterShadowInfo[splitterIndex][0][2] = y;
    }

    private void initSplitterInfo(long gameTime, GameActor[] actorPool) {
        for (int i2 = 0; i2 < this.splitterInfo.length; ++i2) {
            this.splitterInfo[i2][0] = 0;
            this.splitterInfo[i2][1] = (int)gameTime;
            this.splitterInfo[i2][2] = this.getX();
            this.splitterInfo[i2][3] = this.getY();
            this.splitterInfo[i2][4] = -1;
        }
        int splitterIndex = 0;
        for (int i3 = 0; i3 < actorPool.length; ++i3) {
            if (actorPool[i3] == null || !actorPool[i3].inUse() || actorPool[i3].getType() != 1 || actorPool[i3].getSubType() == 7) continue;
            this.splitterInfo[splitterIndex][4] = i3;
            ++splitterIndex;
        }
    }

    private void processSplitter(long gameTime, GameActor[] actorPool) {
        if (this.animID == 9) {
            if (this.isAnimationOver(gameTime)) {
                this.initSplitterInfo(gameTime, actorPool);
                MainCanvas.getGameEngine().setDarkScreen(false);
                MainCanvas.getGameEngine().setShakeScreen(true);
                this.setRenderContent(++this.animID, false, gameTime);
            }
        } else if (this.isAnimationOver(gameTime)) {
            int i2;
            boolean superAttackEnd = true;
            for (i2 = 0; i2 < this.splitterInfo.length; ++i2) {
                if (this.splitterInfo[i2][4] == -1 || this.splitterInfo[i2][0] > 7) continue;
                superAttackEnd = false;
            }
            if (superAttackEnd) {
                this.setState((byte)0, gameTime);
                this.invokeEndSuperAttack(gameTime, 1);
            } else {
                for (i2 = 0; i2 < this.splitterInfo.length; ++i2) {
                    if (this.splitterInfo[i2][4] == -1) continue;
                    if (this.splitterInfo[i2][0] == 0) {
                        GameActor.crSelf.Copy(this.getX(), this.getY(), this.getAnimation().GetColRect(this.splitterInfo[i2][0], gameTime - (long)this.splitterInfo[i2][1], true, 0));
                        GameActor.crOther.Copy(actorPool[this.splitterInfo[i2][4]].getX(), actorPool[this.splitterInfo[i2][4]].getY(), actorPool[this.splitterInfo[i2][4]].getColRect(gameTime, 0));
                        int diffX = GameActor.crOther.x - (GameActor.crOther.w >> 1) - this.splitterInfo[i2][2] - (GameActor.crSelf.w >> 1);
                        int diffY = GameActor.crOther.y + GameActor.crOther.h - this.splitterInfo[i2][3];
                        if (diffX == 0 && diffY == 0) {
                            this.splitterInfo[i2][0] = 4;
                            this.splitterInfo[i2][1] = (int)gameTime;
                            continue;
                        }
                        int absDiffX = Math.abs(diffX);
                        int absDiffY = Math.abs(diffY);
                        if (absDiffX > 14 || absDiffY > 14) {
                            if (absDiffX > absDiffY) {
                                int[] nArray = this.splitterInfo[i2];
                                nArray[2] = nArray[2] + (diffX > 0 ? 14 : -14);
                                int[] nArray2 = this.splitterInfo[i2];
                                nArray2[3] = nArray2[3] + (diffY > 0 ? 14 * absDiffY / absDiffX : -14 * absDiffY / absDiffX);
                                continue;
                            }
                            int[] nArray = this.splitterInfo[i2];
                            nArray[2] = nArray[2] + (diffX > 0 ? 14 * absDiffX / absDiffY : -14 * absDiffX / absDiffY);
                            int[] nArray3 = this.splitterInfo[i2];
                            nArray3[3] = nArray3[3] + (diffY > 0 ? 14 : -14);
                            continue;
                        }
                        int[] nArray = this.splitterInfo[i2];
                        nArray[2] = nArray[2] + diffX;
                        int[] nArray4 = this.splitterInfo[i2];
                        nArray4[3] = nArray4[3] + diffY;
                        continue;
                    }
                    if (!this.getAnimation().animationIsOver(this.splitterInfo[i2][0], (int)(gameTime - (long)this.splitterInfo[i2][1]))) continue;
                    GameActor.crOther.Copy(actorPool[this.splitterInfo[i2][4]].getX(), actorPool[this.splitterInfo[i2][4]].getY(), actorPool[this.splitterInfo[i2][4]].getColRect(gameTime, 0));
                    actorPool[this.splitterInfo[i2][4]].reduceLife(0, 1, GameActor.crOther, gameTime);
                    int[] nArray = this.splitterInfo[i2];
                    nArray[0] = nArray[0] + 1;
                    this.splitterInfo[i2][1] = (int)gameTime;
                }
            }
        }
    }

    private void processAttack(long gameTime, GameActor[] actorPool) {
        if (this.isAnimationOver(gameTime)) {
            if (this.attackAnim > this.animID) {
                if (this.attackAnim == 7) {
                    MainCanvas.getGameEngine().setDarkScreen(true);
                }
                this.setRenderContent(this.attackAnim, false, gameTime);
            } else {
                MainCanvas.getGameEngine().setDarkScreen(false);
                this.setState((byte)0, gameTime);
            }
        } else if (GameEngine.keyReleased == 512 && this.attackAnim < 7) {
            this.attackAnim = this.animID + 1;
        }
        ColRect specialEffectRect = this.getColRect(gameTime, 2);
        if (specialEffectRect != null) {
            for (int i2 = 0; i2 < GameEngine.specialEffect.length; ++i2) {
                if (GameEngine.specialEffect[i2][4] != 0) continue;
                GameEngine.specialEffect[i2][0] = this.getX() + specialEffectRect.x + this.lastEffectX;
                GameEngine.specialEffect[i2][1] = this.getY() + specialEffectRect.y;
                GameEngine.specialEffect[i2][2] = specialEffectRect.w - (this.lastEffectX >> 2);
                GameEngine.specialEffect[i2][3] = specialEffectRect.h | 1;
                GameEngine.specialEffect[i2][4] = specialEffectRect.h << 2;
                this.lastEffectX += specialEffectRect.w >> 3;
                break;
            }
        }
        boolean hitEnemy = false;
        int hitLevel = 0;
        for (int i3 = 0; i3 < actorPool.length; ++i3) {
            if (actorPool[i3] == null || !actorPool[i3].inUse() || actorPool[i3].getType() != 1) continue;
            if (actorPool[i3].getSubType() == 4) {
                Vector col_rects = actorPool[i3].getAnimation().GetColRects(actorPool[i3].animID, gameTime, actorPool[i3].animCyclic);
                ColRect crSelf = new ColRect();
                ColRect crOther = new ColRect();
                crSelf.Copy(this.getX(), this.getY(), this.getColRect(gameTime, 3));
                for (int index = 0; index < col_rects.size(); ++index) {
                    ColRect cr = (ColRect)col_rects.elementAt(index);
                    if (0 != cr.GetVal()) continue;
                    crOther.Copy(actorPool[i3].getX(), actorPool[i3].getY(), cr);
                    if (!ColRect.RectIntersect(crOther, crSelf)) continue;
                    hitEnemy = true;
                    hitLevel = this.animID - 4;
                    int damage = this.getPlayerATS(hitLevel);
                    actorPool[i3].reduceLife(damage, 1 + hitLevel, cr, gameTime);
                    if (hitLevel == 3) {
                        hitLevel = 4;
                    }
                    if (gameTime - GameActor.stopProcessingTime <= 1000L && GameActor.playerHitLevel == hitLevel + 1) break;
                    actorPool[i3].setStopProcessing(true, gameTime);
                    this.setStopProcessing(true, gameTime);
                    MainCanvas.getGameEngine().setShakeScreen(true);
                    GameActor.playerHitLevel = hitLevel + 1;
                    break;
                }
                crSelf = null;
                crOther = null;
                continue;
            }
            if (!this.isCollide(gameTime, actorPool[i3], 3, 0)) continue;
            hitEnemy = true;
            hitLevel = this.animID - 4;
            int damage = this.getPlayerATS(hitLevel);
            actorPool[i3].reduceLife(damage, 1 + hitLevel, this.getIntersectRect(gameTime, actorPool[i3], 3, 0), gameTime);
            if (hitLevel == 3) {
                hitLevel = 4;
            }
            if (gameTime - GameActor.stopProcessingTime <= 1000L && GameActor.playerHitLevel == hitLevel + 1) continue;
            actorPool[i3].setStopProcessing(true, gameTime);
            this.setStopProcessing(true, gameTime);
            MainCanvas.getGameEngine().setShakeScreen(true);
            GameActor.playerHitLevel = hitLevel + 1;
        }
        if (hitEnemy && gameTime - this.getLastHitTime() > 500L) {
            this.setLastHitTime(gameTime);
            this.increaseContinuousHits();
        }
        if (this.getColRect(gameTime, 3) != null && this.canMove(gameTime, 2, 0)) {
            this.setX(this.getX() + 2);
        }
        if (this.processKey(gameTime)) {
            this.setState((byte)0, gameTime);
        }
    }

    public int getPlayerATS(int hitLevel) {
        return MainCanvas.weaponDamageValue[MainCanvas.weaponStore[curWeapon][8]][hitLevel] + this.playerAttackClose;
    }

    public int getPlayerATL() {
        return this.playerAttackFarAway * 1;
    }

    public void setGlobalStopProcessing(boolean stop, long gameTime) {
        int i2 = 0;
        while (true) {
            MainCanvas.getGameEngine();
            if (i2 >= GameEngine.actorPool.length) break;
            MainCanvas.getGameEngine();
            if (GameEngine.actorPool[i2] != null) {
                MainCanvas.getGameEngine();
                if (GameEngine.actorPool[i2].inUse()) {
                    MainCanvas.getGameEngine();
                    GameEngine.actorPool[i2].setStopProcessing(stop, gameTime);
                }
            }
            ++i2;
        }
    }

    private GameActor getABullet(long gameTime, ColRect bulletRect) {
        GameActor[] bulletPool = GameEngine.getBulletPool();
        for (int i2 = 0; i2 < bulletPool.length; ++i2) {
            if (bulletPool[i2] != null && bulletPool[i2].inUse()) continue;
            if (bulletPool[i2] == null) {
                bulletPool[i2] = new GameBullet();
            }
            return bulletPool[i2];
        }
        return null;
    }

    private void processWait(long gameTime, GameEngine gameEngine) {
        if (GameEngine.curKey == 256 || GameEngine.curKey == 32 || GameEngine.curKey == 2048) {
            if (this.animID != 2 && this.animID != 1) {
                this.setRenderContent(1, false, gameTime);
            } else if (this.animID == 1 && this.isAnimationOver(gameTime)) {
                this.setRenderContent(2, true, gameTime);
            }
        } else if (this.animID != 3) {
            this.setRenderContent(3, true, gameTime);
        }
        this.processKey(gameTime);
        ColRect bulletRect = this.getColRect(gameTime, 1);
        if (bulletRect != null) {
            if (this.addBullet) {
                GameActor bullet2;
                if (Player.getBulletLevel() == 0) {
                    bullet2 = this.getABullet(gameTime, bulletRect);
                    this.adjustBullet(gameTime, bulletRect, bullet2, 0);
                } else if (Player.getBulletLevel() == 1) {
                    bullet2 = this.getABullet(gameTime, bulletRect);
                    this.adjustBullet(gameTime, bulletRect, bullet2, 1);
                }
                if (Player.getBulletLevel() == 2) {
                    for (int bulletCount = 0; bulletCount < 3; ++bulletCount) {
                        GameActor bullet3 = this.getABullet(gameTime, bulletRect);
                        this.adjustBullet(gameTime, bulletRect, bullet3, 2 + bulletCount);
                        if (bulletCount == 0) {
                            bullet3.setVx(8);
                            bullet3.setVy(-4);
                            continue;
                        }
                        if (bulletCount != 2) continue;
                        bullet3.setVx(8);
                        bullet3.setVy(4);
                    }
                } else if (Player.getBulletLevel() == 3) {
                    for (int bulletCount = 0; bulletCount < 3; ++bulletCount) {
                        GameActor bullet4 = this.getABullet(gameTime, bulletRect);
                        this.adjustBullet(gameTime, bulletRect, bullet4, 5 + bulletCount);
                        if (bulletCount == 0) {
                            bullet4.setVx(8);
                            bullet4.setVy(-4);
                            continue;
                        }
                        if (bulletCount != 2) continue;
                        bullet4.setVx(8);
                        bullet4.setVy(4);
                    }
                } else if (Player.getBulletLevel() == 4) {
                    for (int bulletCount = 0; bulletCount < 3; ++bulletCount) {
                        GameActor bullet5 = this.getABullet(gameTime, bulletRect);
                        this.adjustBullet(gameTime, bulletRect, bullet5, 8 + bulletCount);
                        if (bulletCount == 0) {
                            bullet5.setVx(8);
                            bullet5.setVy(-4);
                            continue;
                        }
                        if (bulletCount != 2) continue;
                        bullet5.setVx(8);
                        bullet5.setVy(4);
                    }
                }
                this.addBullet = false;
            }
        } else {
            this.addBullet = true;
        }
    }

    private void adjustBullet(long gameTime, ColRect bulletRect, GameActor bullet2, int subType) {
        bullet2.setAnimation(MainCanvas.getGameEngine().bulletPif);
        bullet2.init(gameTime, 0);
        bullet2.setSubType(subType);
        bullet2.setState((byte)0, gameTime);
        bullet2.setX(this.getX() + bulletRect.x + (bulletRect.w >> 1));
        bullet2.setY(this.getY() + bulletRect.y + (bulletRect.h >> 1));
        bullet2.setVx(10);
        bullet2.setVy(0);
    }

    private boolean canMove(long gameTime, int offsetX, int offsetY) {
        GameEngine engine = MainCanvas.getGameEngine();
        boolean ret = true;
        ColRect crHero = this.getColRect(gameTime, 0);
        if (this.getX() - (crHero.w >> 1) <= 0 && offsetX < 0 || this.getX() + (crHero.w >> 1) >= 480 && offsetX > 0 || this.getY() - crHero.h <= 38 && offsetY < 0 || this.getY() >= 360 && offsetY > 0) {
            ret = false;
        }
        return ret;
    }

    private boolean processKey(long gameTime) {
        boolean ret = false;
        if (this.getState() == 8) {
            return false;
        }
        switch (GameEngine.curKey) {
            case 256: {
                if (!this.canMove(gameTime, -this.playerFlySpeed, 0)) break;
                this.setX(this.getX() - this.playerFlySpeed);
                ret = true;
                break;
            }
            case 1024: {
                if (!this.canMove(gameTime, this.playerFlySpeed, 0)) break;
                this.setX(this.getX() + this.playerFlySpeed);
                ret = true;
                break;
            }
            case 64: {
                if (!this.canMove(gameTime, 0, -this.playerFlySpeed)) break;
                this.setY(this.getY() - this.playerFlySpeed);
                ret = true;
                break;
            }
            case 4096: {
                if (!this.canMove(gameTime, 0, this.playerFlySpeed)) break;
                this.setY(this.getY() + this.playerFlySpeed);
                ret = true;
                break;
            }
            case 128: {
                if (!this.canMove(gameTime, this.playerLeanFlySpeed, -this.playerLeanFlySpeed)) break;
                this.setX(this.getX() + this.playerLeanFlySpeed);
                this.setY(this.getY() - this.playerLeanFlySpeed);
                ret = true;
                break;
            }
            case 8192: {
                if (!this.canMove(gameTime, this.playerLeanFlySpeed, this.playerLeanFlySpeed)) break;
                this.setX(this.getX() + this.playerLeanFlySpeed);
                this.setY(this.getY() + this.playerLeanFlySpeed);
                ret = true;
                break;
            }
            case 32: {
                if (!this.canMove(gameTime, -this.playerLeanFlySpeed, -this.playerLeanFlySpeed)) break;
                this.setX(this.getX() - this.playerLeanFlySpeed);
                this.setY(this.getY() - this.playerLeanFlySpeed);
                ret = true;
                break;
            }
            case 2048: {
                if (!this.canMove(gameTime, -this.playerLeanFlySpeed, this.playerLeanFlySpeed)) break;
                this.setX(this.getX() - this.playerLeanFlySpeed);
                this.setY(this.getY() + this.playerLeanFlySpeed);
                ret = true;
                break;
            }
            case 16: {
                if (this.getMana() >= magicManaCost[curMagic]) {
                    this.setState((byte)(2 + curMagic), gameTime);
                    this.setMana(this.getMana() - magicManaCost[curMagic]);
                }
                ret = false;
                GameEngine.clearKey();
            }
        }
        if (GameEngine.keyReleased == 512 && this.getState() != 6 && this.getState() != 1) {
            this.setState((byte)1, gameTime);
            ret = false;
        }
        return ret;
    }

    public void setState(byte newState, long time) {
        MainCanvas.getGameEngine().setDarkScreen(false);
        MainCanvas.getGameEngine().setShakeScreen(false);
        switch (newState) {
            case 0: {
                super.setState(newState, time);
                this.setRenderContent(3, true, time);
                break;
            }
            case 9: {
                super.setState(newState, time);
                this.setRenderContent(15, true, time);
                break;
            }
            case 1: {
                if (this.animID >= 4 && this.animID <= 7) break;
                this.lastEffectX = 0;
                this.attackAnim = 4;
                super.setState(newState, time);
                this.setRenderContent(this.attackAnim, false, time);
                break;
            }
            case 2: {
                this.setSubType(0);
                super.setState(newState, time);
                this.setRenderContent(9, false, time);
                MainCanvas.getGameEngine().setDarkScreen(true);
                MainCanvas.getGameEngine().resetBulletPool();
                this.invokeBeginSuperAttack(time, 0);
                break;
            }
            case 4: {
                this.setSubType(0);
                this.initSplitterShadowInfo();
                super.setState(newState, time);
                this.setRenderContent(9, false, time);
                MainCanvas.getGameEngine().setDarkScreen(true);
                MainCanvas.getGameEngine().resetBulletPool();
                this.invokeBeginSuperAttack(time, 1);
                break;
            }
            case 3: {
                this.setSubType(0);
                super.setState(newState, time);
                MainCanvas.getGameEngine().setDarkScreen(true);
                this.setRenderContent(11, false, time);
                MainCanvas.getGameEngine().resetBulletPool();
                this.invokeBeginSuperAttack(time, 3);
                break;
            }
            case 5: {
                this.setSubType(0);
                super.setState(newState, time);
                MainCanvas.getGameEngine().setDarkScreen(true);
                this.setRenderContent(13, false, time);
                MainCanvas.getGameEngine().resetBulletPool();
                this.invokeBeginSuperAttack(time, 4);
                this.initLightDragonPosition();
                break;
            }
            case 8: {
                if (this.getState() == 8 || this.isPlayerDead()) break;
                MainCanvas.getGameEngine().setDarkScreen(true);
                MainCanvas.getGameEngine().resetBulletPool();
                this.invokeBeginSuperAttack(time, 5);
                this.setSubType(6);
                super.setState(newState, time);
                this.setRenderContent(16, false, time);
                break;
            }
            case 6: {
                super.setState(newState, time);
                this.setRenderContent(8, false, time);
                this.setX(this.getX() - 7);
                break;
            }
            case 10: {
                if (this.isPlayerDead()) break;
                this.setRelatePlayer(null);
                this.invokeBeginSuperAttack(time, 6);
                MainCanvas.getGameEngine().setStopScrollBG(true);
                GameBonus bonus2 = (GameBonus)this.getABonus();
                bonus2.init(time, 0);
                ColRect rect = this.getColRect(time, 0);
                bonus2.setX(this.getX() + (rect.w >> 1));
                bonus2.setY(this.getY() - (rect.h >> 1));
                super.setState(newState, time);
                this.setRenderContent(8, false, time);
                this.vx = this.x - this.lastX >> 2;
                this.vy = this.y - this.lastY;
                if (this.vy > -CMath.I2F(1) >> 1) {
                    this.vy = -CMath.I2F(1) >> 1;
                }
                this.ax = 0;
                this.ay = CMath.I2F(1) >> 1;
                break;
            }
            case 11: {
                this.init(time, this.type);
                ColRect crHero = this.getColRect(time, 0);
                super.setState(newState, time);
                this.setX(-crHero.w);
                this.setY(279);
                break;
            }
            case 7: {
                super.setState(newState, time);
                this.setRenderContent(15, true, time);
                break;
            }
            default: {
                super.setState(newState, time);
                this.setRenderContent(3, true, time);
            }
        }
    }

    private void invokeBeginSuperAttack(long time, int type) {
        int i2 = 0;
        while (true) {
            MainCanvas.getGameEngine();
            if (i2 >= GameEngine.actorPool.length) break;
            MainCanvas.getGameEngine();
            if (GameEngine.actorPool[i2] != null) {
                MainCanvas.getGameEngine();
                if (GameEngine.actorPool[i2].inUse()) {
                    MainCanvas.getGameEngine();
                    GameEngine.actorPool[i2].beginNotify(time, type);
                }
            }
            ++i2;
        }
        i2 = 0;
        while (true) {
            MainCanvas.getGameEngine();
            if (i2 >= GameEngine.bonusPool.length) break;
            MainCanvas.getGameEngine();
            if (GameEngine.bonusPool[i2] != null) {
                MainCanvas.getGameEngine();
                if (GameEngine.bonusPool[i2].inUse()) {
                    MainCanvas.getGameEngine();
                    GameEngine.bonusPool[i2].beginNotify(time, type);
                }
            }
            ++i2;
        }
    }

    public void init(long gameTime, int type) {
        this.playerLife = Player.getPlayerPropertyArray()[0] + (MainCanvas.weaponStore[curWeapon][0] > 0 ? MainCanvas.weaponStore[curWeapon][0] : 0);
        this.playerMagicDamage = Player.getPlayerPropertyArray()[1] + (MainCanvas.weaponStore[curWeapon][1] > 0 ? MainCanvas.weaponStore[curWeapon][1] : 0);
        this.playerMagicDamage <<= 1;
        this.playerAttackClose = Player.getPlayerPropertyArray()[2] + (MainCanvas.weaponStore[curWeapon][3] > 0 ? MainCanvas.weaponStore[curWeapon][3] : 0) + MainCanvas.weaponStore[curWeapon][9];
        this.playerAttackFarAway = Player.getPlayerPropertyArray()[3] + (MainCanvas.weaponStore[curWeapon][2] > 0 ? MainCanvas.weaponStore[curWeapon][2] : 0);
        this.playerDefenceClose = Player.getPlayerPropertyArray()[4] + (MainCanvas.weaponStore[curWeapon][5] > 0 ? MainCanvas.weaponStore[curWeapon][5] : 0);
        this.playerDefenceFarAway = Player.getPlayerPropertyArray()[5] + (MainCanvas.weaponStore[curWeapon][4] > 0 ? MainCanvas.weaponStore[curWeapon][4] : 0);
        this.playerFlySpeed = 7 + (Player.getPlayerPropertyArray()[6] + (MainCanvas.weaponStore[curWeapon][6] > 0 ? MainCanvas.weaponStore[curWeapon][6] : 0)) / 10;
        this.playerLeanFlySpeed = (short)((this.playerFlySpeed * 10 + 7) / 14);
        this.playerSpirit = 1 + (Player.getPlayerPropertyArray()[7] + (MainCanvas.weaponStore[curWeapon][7] > 0 ? MainCanvas.weaponStore[curWeapon][7] : 0)) / 10;
        this.skillsAnimID = -1;
        this.skillsAnimTime = 0L;
        this.setPoisonTime(0L);
        this.initSplitterShadowInfo();
        if (!this.isPlayerDead()) {
            Player.setKilledEnemy(0);
            Player.setDeadCount(0);
            Player.setMaxContinuousHits(0);
            Player.setTotalPlayedTime(0L);
            Player.setPlayerSouls(0);
            Player.setPlayerLevel(Player.getPlayerPropertyArray()[8]);
            Player.setPlayerLevel_next(Player.getPlayerPropertyArray()[9]);
            Player.setPlayerHP(Player.getPlayerPropertyArray()[0]);
            Player.setPlayerPoint(Player.getPlayerPropertyArray()[12]);
            Player.setBulletLevel(Player.getPlayerPropertyArray()[17]);
        } else {
            Player.setBulletLevel(0);
        }
        this.stopProcessing = false;
        GameActor.stopProcessingTime = 0L;
        GameActor.playerHitLevel = 0;
        this.manaRestoreTime = 0L;
        this.setRenderPowerUpTime(0L);
        this.setInvincibleTime(0L);
        this.setLife(this.playerLife);
        this.setMaxlife(this.getLife());
        this.setMana(100);
        this.setX(240);
        this.setY(279);
        this.setRelatePlayer(null);
        if (!this.isPlayerDead() && MainCanvas.indexOfLevel == 6) {
            this.setLife(MainCanvas.getGameEngine().mainCanvas.playerLife);
            this.setMana(MainCanvas.getGameEngine().mainCanvas.playerMana);
        }
        this.setSubType(0);
        this.setState((byte)0, gameTime);
        this.setInUse(true);
    }

    public void reduceLife(int reducePoint, int type, ColRect rc, long gametime) {
        if (this.getLife() <= 0 || this.getState() == 8 || this.isPlayerDead()) {
            return;
        }
        this.setContinuousHits(0);
        this.setLastHitTime(0L);
        if (reducePoint > 1) {
            reducePoint = type == 0 ? (reducePoint -= this.playerDefenceFarAway) : (reducePoint -= this.playerDefenceClose);
            if (reducePoint < 1) {
                reducePoint = 1;
            }
        }
        if (this.getInvincibleTime() <= 0L) {
            this.setLife(this.getLife() - reducePoint);
        }
        if (this.getLife() <= 0) {
            this.setLife(0);
            this.setState((byte)10, gametime);
        } else if ((type == 6 || type == 7 || type == 8) && this.getRelatePlayer() == null) {
            if (this.getState() != 7) {
                this.setState((byte)7, gametime);
                this.setSubType(2);
            }
            if (type == 8) {
                this.setSubType(4);
            } else {
                this.setSubType(2);
            }
        } else if (type == 10) {
            if (this.getState() != 7) {
                this.setState((byte)7, gametime);
            }
            this.setSubType(4);
        } else if (type == 12) {
            this.setPoisonTime(3000L);
        } else if (this.getState() != 9 && this.getState() != 6) {
            this.setState((byte)6, gametime);
        }
    }

    public void beginNotify(long gameTime, int type) {
        if (type == 2 && this.getState() != 7) {
            this.setSubType(1);
        }
        if (this.getLife() > 0 && (type == 7 || type == 8 || type == 9)) {
            this.setState((byte)9, gameTime);
        }
        if (type == 0 || type == 3 || type == 4 || type == 5 || type == 1) {
            MainCanvas.getGameEngine().setStopScrollBG(true);
            if (this.getContinuousHits() > 0) {
                this.setLastHitTime(gameTime);
            }
        }
    }

    public void endNotify(long gameTime, int type) {
        if (type != 7) {
            if (type == 8 || type == 9 && !this.isPlayerDead()) {
                this.setState((byte)0, gameTime);
            }
            if (type != 2) {
                this.setSubType(0);
            }
            MainCanvas.getGameEngine().setShakeScreen(false);
        }
        MainCanvas.getGameEngine().setStopScrollBG(false);
    }

    public void drawLevelUpLine(Graphics g2, long gameTime, int animID) {
        PWPifLifeAnimations levelUpLineAnim = MainCanvas.getGameEngine().leveluplinePif;
        int lineHeight = levelUpLineAnim.GetAniFrameHeight(animID, 0);
        for (int y = 360; y >= 0; y -= lineHeight) {
            levelUpLineAnim.drawAnimation(g2, animID, gameTime, this.getX(), y, animID != 0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void renderGameActor(Graphics g2, long gameTime) {
        PWPifLifeAnimations levelUpLineAnim;
        if (this.getRelatePlayer() != null) {
            return;
        }
        if (this.getInvincibleTime() > 0L && gameTime % 3L > 1L) {
            return;
        }
        if (this.getState() == 8) {
            levelUpLineAnim = MainCanvas.getGameEngine().leveluplinePif;
            if (this.getSubType() == 6) {
                if (levelUpLineAnim.animationIsOver(0, (int)(gameTime - this.stateStartTime))) {
                    this.drawLevelUpLine(g2, gameTime - this.stateStartTime, 1);
                } else {
                    this.drawLevelUpLine(g2, gameTime - this.stateStartTime, 0);
                }
            } else {
                this.drawLevelUpLine(g2, gameTime - this.stateStartTime, 2);
            }
        }
        super.renderGameActor(g2, gameTime);
        MainCanvas.getGameEngine().playerWeaponPif.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
        MainCanvas.getGameEngine().playerBladeShadowPif.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
        if (this.getPoisonTime() > 0L) {
            ColRect crHero = this.getColRect(gameTime, 0);
            int height = (int)(1000L - this.getPoisonTime() % 1000L);
            MainCanvas.font1.drawString(g2, "-4", this.getX() + (crHero.w >> 1), this.getY() - crHero.h - (height >>= 5), 33);
        }
        if (this.getState() == 5 && this.animID == 14) {
            this.drawLightDragon(g2, gameTime);
        }
        if (this.getState() == 8) {
            levelUpLineAnim = MainCanvas.getGameEngine().leveluplinePif;
            if (this.getSubType() != 6) return;
        }
        if (this.getState() == 4) {
            int i2;
            int oldPal = this.getAnimation().getPalette();
            this.getAnimation().setPalette(3);
            for (i2 = 0; i2 < this.splitterShadowInfo.length; ++i2) {
                if (this.splitterShadowInfo[i2][9][0] != -1) {
                    this.getAnimation().drawFrame(g2, this.getAnimation().animations[this.splitterShadowInfo[i2][9][0]] & 0xFF, this.splitterShadowInfo[i2][9][1], this.splitterShadowInfo[i2][9][2], (byte)0);
                }
                if (this.splitterShadowInfo[i2][5][0] == -1) continue;
                this.getAnimation().drawFrame(g2, this.getAnimation().animations[this.splitterShadowInfo[i2][5][0]] & 0xFF, this.splitterShadowInfo[i2][5][1], this.splitterShadowInfo[i2][5][2], (byte)0);
            }
            this.getAnimation().setPalette(2);
            for (i2 = 0; i2 < this.splitterInfo.length; ++i2) {
                if (this.splitterInfo[i2][4] == -1 || this.splitterInfo[i2][0] > 7) continue;
                this.getAnimation().drawAnimation(g2, this.splitterInfo[i2][0], gameTime - (long)this.splitterInfo[i2][1], this.splitterInfo[i2][2], this.splitterInfo[i2][3], true);
                MainCanvas.getGameEngine().playerWeaponPif.drawAnimation(g2, this.splitterInfo[i2][0], gameTime - (long)this.splitterInfo[i2][1], this.splitterInfo[i2][2], this.splitterInfo[i2][3], true);
                MainCanvas.getGameEngine().playerBladeShadowPif.drawAnimation(g2, this.splitterInfo[i2][0], gameTime - (long)this.splitterInfo[i2][1], this.splitterInfo[i2][2], this.splitterInfo[i2][3], true);
                this.pushSplitterShadowInfo(i2, this.getAnimation().getFramePos(this.splitterInfo[i2][0], gameTime - (long)this.splitterInfo[i2][1], true), this.splitterInfo[i2][2], this.splitterInfo[i2][3]);
            }
            this.getAnimation().setPalette(oldPal);
            return;
        } else if (this.getState() == 3) {
            if (this.skillsAnimID == -1) return;
            MainCanvas.getGameEngine().skillsPif.drawAnimation(g2, this.skillsAnimID, gameTime - this.skillsAnimTime, CMath.F2I(this.skillsAnimX), CMath.F2I(this.skillsAnimY), this.skillsAnimID == 0);
            return;
        } else {
            if (this.getRenderPowerUpTime() == 0L) return;
            this.setRenderPowerUpTime(0L);
        }
    }

    private void initLightDragonPosition() {
        for (int i2 = 0; i2 < this.lightDragonPosition.length; ++i2) {
            this.lightDragonPosition[i2][0] = 0L;
            this.lightDragonPosition[i2][1] = -1L;
            this.lightDragonPosition[i2][2] = 0L;
            this.lightDragonPosition[i2][3] = 0L;
        }
    }

    private int getLightDragonXPosition() {
        boolean seekNext = true;
        int xPosition = 0;
        block0: while (seekNext) {
            xPosition = CMath.getRandNumber(1, 3);
            if (xPosition == 2) {
                xPosition = 4;
            } else if (xPosition == 3) {
                xPosition = 7;
            }
            xPosition = 480 * xPosition >> 3;
            seekNext = false;
            for (int i2 = 0; i2 < this.lightDragonPosition.length; ++i2) {
                if (this.lightDragonPosition[i2][0] != (long)xPosition) continue;
                seekNext = true;
                continue block0;
            }
        }
        return xPosition;
    }

    private void drawLightDragon(Graphics g2, long gameTime) {
        PWPifLifeAnimations animationLightDragon = MainCanvas.getGameEngine().lightDragonPif;
        for (int i2 = 0; i2 < this.lightDragonPosition.length; ++i2) {
            if (this.lightDragonPosition[i2][3] >= 5L) continue;
            int y = (int)this.lightDragonPosition[i2][1];
            animationLightDragon.drawAnimation(g2, 0, gameTime - this.lightDragonPosition[i2][2], (int)this.lightDragonPosition[i2][0], y, true);
            y -= animationLightDragon.GetAniFrameHeight(0, 0);
            while (y > 0) {
                animationLightDragon.drawAnimation(g2, 1, gameTime - this.lightDragonPosition[i2][2], (int)this.lightDragonPosition[i2][0], y, true);
                animationLightDragon.drawAnimation(g2, 2, gameTime - this.lightDragonPosition[i2][2], (int)this.lightDragonPosition[i2][0], y -= animationLightDragon.GetAniFrameHeight(1, 0), true);
                y -= animationLightDragon.GetAniFrameHeight(2, 0);
            }
        }
    }

    public int getContinuousHits() {
        return this.continuousHits;
    }

    public void setContinuousHits(int continuousHits2) {
        this.continuousHits = continuousHits2;
    }

    public void increaseContinuousHits() {
        ++this.continuousHits;
        if (this.continuousHits > Player.getMaxContinuousHits()) {
            Player.setMaxContinuousHits(this.continuousHits);
        }
    }

    public boolean isPlayerDead() {
        return this.getState() >= 10;
    }

    public void adjustPosition(long time, GameActor[] actorPool) {
        ColRect crHero = this.getColRect(time, 0);
        if (!this.isPlayerDead() && this.getState() != 9) {
            for (int i2 = 0; i2 < actorPool.length; ++i2) {
                if (actorPool[i2] == null || !actorPool[i2].inUse() || actorPool[i2] == this || !this.isCollide(time, actorPool[i2], 0, 0)) continue;
                this.setX(this.getX() - this.playerFlySpeed);
            }
            if (this.getX() - (crHero.w >> 1) < 0) {
                this.setX(0 + (crHero.w >> 1));
            } else if (this.getX() + (crHero.w >> 1) > 480) {
                this.setX(480 - (crHero.w >> 1));
            }
            if (this.getY() - crHero.h < 38) {
                this.setY(38 + crHero.h);
            } else if (this.getY() > 360) {
                this.setY(360);
            }
        } else if (this.getState() == 10) {
            boolean outOfScren = false;
            if (this.getX() + (crHero.w >> 1) < 0) {
                outOfScren = true;
            } else if (this.getX() - (crHero.w >> 1) > 480) {
                outOfScren = true;
            }
            if (this.getY() < 38) {
                outOfScren = true;
            } else if (this.getY() - crHero.h > 360) {
                outOfScren = true;
            }
            if (outOfScren) {
                MainCanvas.getGameEngine().mainCanvas.pauseGame();
            }
        } else if (this.getState() == 11) {
            boolean outOfScreen = false;
            if (this.getX() + (crHero.w >> 1) < 0) {
                outOfScreen = true;
            } else if (this.getX() - (crHero.w >> 1) > 480) {
                outOfScreen = true;
            }
            if (this.getY() < 38) {
                outOfScreen = true;
            } else if (this.getY() - crHero.h > 360) {
                outOfScreen = true;
            }
            if (!outOfScreen) {
                this.invokeEndSuperAttack(time, 6);
                MainCanvas.getGameEngine().setStopScrollBG(false);
                this.setState((byte)0, time);
                this.setInvincibleTime(3000L);
            }
        }
    }

    public static final int getKilledEnemy() {
        return totalKilledEnemy;
    }

    public static final void setKilledEnemy(int killedEnemy) {
        totalKilledEnemy = killedEnemy > 9999 ? 9999 : killedEnemy;
    }

    public static final void setPlayerSouls(int playerSouls) {
    }

    public static final int getPlayerSouls() {
        return playerSouls;
    }

    public void increaseKilledEnemy(int experience) {
        ++totalKilledEnemy;
        if (!this.isPlayerDead()) {
            if (Player.getPlayerLevel_next() > experience) {
                Player.setPlayerLevel_next(Player.getPlayerLevel_next() - experience);
            } else {
                Player.setPlayerLevel_next(0);
            }
        }
    }

    private void setPoisonTime(long poisonTime) {
        this.poisonTime = poisonTime;
    }

    private long getPoisonTime() {
        return this.poisonTime;
    }

    public static final char[] getPlayerPropertyArray() {
        return playerProperty;
    }

    public static final short[][] getMagicLevelRequirement() {
        return magicLevelRequirement;
    }

    public static final void setPlayerLevel(int playerLevelPara) {
        playerLevel = playerLevelPara;
    }

    public static final int getPlayerLevel() {
        return playerLevel;
    }

    public static final void setPlayerLevel_next(int playerLevel_nextPara) {
        playerLevel_next = playerLevel_nextPara;
    }

    public static final int getPlayerLevel_next() {
        return playerLevel_next;
    }

    public static final void setPlayerHP(int playerHPPara) {
        playerHP = playerHPPara;
    }

    public static final int getPlayerHP() {
        return playerHP;
    }

    public static final void setPlayerPoint(int playerPointPara) {
        playerPoint = playerPointPara;
    }

    public static final int getPlayerPoint() {
        return playerPoint;
    }

    public void setLastHitTime(long lastHitTime) {
        this.lastHitTime = lastHitTime;
    }

    public long getLastHitTime() {
        return this.lastHitTime;
    }

    public static final void setBulletLevel(int bulletLevelPara) {
        bulletLevel = bulletLevelPara;
    }

    public void increaseBulletLevel(long gameTime) {
        this.setRenderPowerUpTime(gameTime);
        if (bulletLevel < 4) {
            ++bulletLevel;
        }
    }

    public static final int getBulletLevel() {
        return bulletLevel;
    }

    private void setRenderPowerUpTime(long renderPowerUpTime) {
        this.renderPowerUpTime = renderPowerUpTime;
    }

    private long getRenderPowerUpTime() {
        return this.renderPowerUpTime;
    }

    public void setMana(int mana) {
        this.mana = mana;
    }

    public int getMana() {
        return this.mana;
    }

    public static final void setDeadCount(int deadCount) {
        Player.deadCount = deadCount;
    }

    public static final int getDeadCount() {
        return deadCount;
    }

    public static final void increaseDeadCount() {
        ++deadCount;
    }

    public static final void setMaxContinuousHits(int maxContinuousHits) {
        Player.maxContinuousHits = maxContinuousHits;
    }

    public static final int getMaxContinuousHits() {
        return maxContinuousHits;
    }

    public static final void setTotalPlayedTime(long totalPlayedTime) {
        Player.totalPlayedTime = totalPlayedTime;
    }

    public static final long getTotalPlayedTime() {
        return totalPlayedTime;
    }

    public static final void increaseTotalTime(long time) {
        totalPlayedTime += time;
    }

    public void setInvincibleTime(long invincibleTime) {
        this.invincibleTime = invincibleTime;
    }

    public long getInvincibleTime() {
        return this.invincibleTime;
    }
}

