/*
 * Decompiled with CFR 0.152.
 */
package z.playw.j2me.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import z.playw.j2me.util.PWScreenToolbox;

public class PWSoundbox4 {
    private static final String _CTYPE_MIDI_ = "audio/midi";
    private static final String _CTYPE_WAV_ = "audio/wav";
    private static final String _CTYPE_MP3_ = "audio/mp3";
    private static final String _CTYPE_AMR_ = "audio/amr";
    private static final String _CTYPE_MP4_ = "audio/mp4";
    public static final int MAX_ELEMENTS = 12;
    public static final int NO_SOUND = -1;
    private static PWSoundbox4 instance;
    private boolean musicActive;
    private static byte lastSoundIndex;
    private static byte actualSoundIndex;
    private static Player[] players;
    private boolean[] supported = new boolean[]{false, false, false, false};
    private String[] mediaTypesSupported;
    public static long lastTimePlayWasDone;

    private PWSoundbox4() {
        players = new Player[12];
        this.mediaTypesSupported = Manager.getSupportedContentTypes(null);
        actualSoundIndex = (byte)-1;
        lastSoundIndex = (byte)-1;
        lastTimePlayWasDone = -1L;
        this.musicActive = true;
    }

    public static PWSoundbox4 get() {
        if (instance == null) {
            instance = new PWSoundbox4();
        }
        return instance;
    }

    private final boolean contentTypeSupported(String cType) {
        int nTypes = this.mediaTypesSupported.length;
        for (int i2 = 0; i2 < nTypes; ++i2) {
            if (!cType.equals(this.mediaTypesSupported[i2])) continue;
            return true;
        }
        return false;
    }

    private final void determineSupportedFormats() {
        for (int i2 = 0; i2 < 4; ++i2) {
            String type;
            switch (i2) {
                case 0: {
                    type = _CTYPE_MIDI_;
                    break;
                }
                case 1: {
                    type = _CTYPE_WAV_;
                    break;
                }
                case 2: {
                    type = _CTYPE_MP3_;
                    break;
                }
                default: {
                    type = _CTYPE_AMR_;
                }
            }
            this.supported[i2] = this.contentTypeSupported(type);
        }
    }

    private final String determineContentType(String fn) {
        String ext = fn.substring(fn.lastIndexOf(46)).toLowerCase();
        if (ext.equals(".mid")) {
            return _CTYPE_MIDI_;
        }
        if (ext.equals(".wav")) {
            return _CTYPE_WAV_;
        }
        if (ext.equals(".amr")) {
            return _CTYPE_AMR_;
        }
        if (ext.equals(".mp3")) {
            return _CTYPE_MP3_;
        }
        if (ext.equals(".mp4")) {
            return _CTYPE_MP4_;
        }
        return null;
    }

    public final byte loadSound(String fileName) {
        Player p;
        String ctype;
        byte value = -1;
        if (fileName != null && (ctype = this.determineContentType(fileName)) != null && this.contentTypeSupported(ctype) && (p = this.createAPlayer(fileName, ctype)) != null && (lastSoundIndex = (byte)(lastSoundIndex + 1)) < 12) {
            PWSoundbox4.players[PWSoundbox4.lastSoundIndex] = p;
            players[lastSoundIndex].setLoopCount(1);
            value = lastSoundIndex;
        }
        return value;
    }

    public final Player createAPlayer(String location, String cType) {
        Player p;
        block2: {
            p = null;
            try {
                byte[] aux = PWScreenToolbox.get().getResource(location);
                ByteArrayInputStream in = new ByteArrayInputStream(aux);
                p = Manager.createPlayer((InputStream)in, (String)cType);
                p.realize();
            }
            catch (Exception ex) {
                if (p == null) break block2;
                p.close();
                p = null;
            }
        }
        return p;
    }

    public final void play(byte playerId) {
        if (this.musicActive) {
            actualSoundIndex = playerId;
            this.playSound(players[playerId]);
        }
    }

    private final void playSound(Player p) {
        if (p != null) {
            try {
                switch (p.getState()) {
                    case 300: {
                        break;
                    }
                    case 200: {
                        p.prefetch();
                        break;
                    }
                    case 100: {
                        p.realize();
                        p.prefetch();
                        break;
                    }
                }
                p.start();
                lastTimePlayWasDone = System.currentTimeMillis();
            }
            catch (Exception ex) {
                actualSoundIndex = (byte)-1;
            }
        }
    }

    public int getActualPlayingSound() {
        if (actualSoundIndex != -1 && players[actualSoundIndex].getState() != 400) {
            actualSoundIndex = (byte)-1;
        }
        return actualSoundIndex;
    }

    public void stopAll() {
        for (byte i2 = 0; i2 < 12; i2 = (byte)(i2 + 1)) {
            this.stop(i2);
        }
    }

    public void stop(byte aSoundId) {
        if (aSoundId < 0 || aSoundId >= 12 || players[aSoundId] == null) {
            return;
        }
        while (players[aSoundId].getState() == 400) {
            try {
                players[aSoundId].stop();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        actualSoundIndex = (byte)-1;
    }

    public void unloadAll() {
        for (int i2 = 0; i2 <= lastSoundIndex; ++i2) {
            this.unload(i2);
        }
        lastSoundIndex = (byte)-1;
    }

    private void unload(int aSoundId) {
        if (players[aSoundId] != null) {
            players[aSoundId].close();
        }
    }
}

