/*
 * Decompiled with CFR 0.152.
 */
package z.playw.j2me.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import z.playw.j2me.util.PWScreenToolbox;

public class PWSoundbox3 {
    public static final int MAX_ELEMENTS = 12;
    public static final int NO_SOUND = -1;
    public static int MAX_VOLUME = 100;
    private static PWSoundbox3 instance;
    public static int volume;
    private static Player[] players;
    private static int lastSoundIndex;
    private static int actualSoundIndex;
    public static long lastTimePlayWasDone;

    private PWSoundbox3() {
        players = new Player[12];
        actualSoundIndex = -1;
        lastSoundIndex = -1;
        lastTimePlayWasDone = -1L;
        volume = MAX_VOLUME;
    }

    public static PWSoundbox3 get() {
        if (instance == null) {
            instance = new PWSoundbox3();
        }
        return instance;
    }

    public boolean play(int aSoundId) {
        return this.play(aSoundId, false);
    }

    public boolean play(int aSoundId, boolean loop) {
        if (aSoundId < 0 || aSoundId >= 12) {
            return false;
        }
        if (this.getActualPlayingSound() != -1) {
            this.stop(actualSoundIndex);
        }
        boolean playing = false;
        int n = 0;
        while (!playing && n < 1) {
            try {
                players[aSoundId].start();
                actualSoundIndex = aSoundId;
                playing = true;
                lastTimePlayWasDone = System.currentTimeMillis();
            }
            catch (MediaException e2) {
                e2.printStackTrace();
                ++n;
            }
        }
        return playing;
    }

    public int getActualPlayingSound() {
        if (actualSoundIndex != -1 && players[actualSoundIndex].getState() != 400) {
            actualSoundIndex = -1;
        }
        return actualSoundIndex;
    }

    public void stopAll() {
        for (int i2 = 0; i2 <= lastSoundIndex; ++i2) {
            this.stop(i2);
        }
    }

    public void stop(int aSoundId) {
        if (aSoundId < 0 || aSoundId >= 12) {
            return;
        }
        boolean stopped = false;
        while (!stopped) {
            try {
                players[aSoundId].stop();
                stopped = true;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        actualSoundIndex = -1;
    }

    public int load(String aSoundFile) {
        byte[] aux;
        this.unloadAll();
        ++lastSoundIndex;
        if (aSoundFile == null) {
            return -1;
        }
        if (lastSoundIndex == 12) {
            return -1;
        }
        String ext = aSoundFile.substring(aSoundFile.lastIndexOf(46)).toLowerCase();
        if ((ext.equals(".wav") || ext.equals(".amr") || ext.equals(".mid")) && (aux = PWScreenToolbox.get().getResource(aSoundFile)) != null) {
            try {
                Player p;
                ByteArrayInputStream i2 = new ByteArrayInputStream(aux);
                Player player = p = ext.equals(".mid") ? Manager.createPlayer((InputStream)i2, (String)"audio/midi") : Manager.createPlayer((InputStream)i2, (String)("audio/" + ext.substring(1)));
                if (p == null) {
                    // empty if block
                }
                p.realize();
                PWSoundbox3.players[PWSoundbox3.lastSoundIndex] = p;
                return lastSoundIndex;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return -1;
    }

    public void unloadAll() {
        for (int i2 = 0; i2 <= lastSoundIndex; ++i2) {
            this.unload(i2);
        }
        lastSoundIndex = -1;
    }

    private void unload(int aSoundId) {
        if (players[aSoundId] != null) {
            players[aSoundId].close();
        }
    }

    static {
        lastTimePlayWasDone = -1L;
    }
}

