/*
 * Decompiled with CFR 0.152.
 */
package z.playw.DragonGuardian;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import z.playw.DragonGuardian.CMath;
import z.playw.DragonGuardian.CONSTANT;
import z.playw.DragonGuardian.Enemy;
import z.playw.DragonGuardian.GameActor;
import z.playw.DragonGuardian.GameBonus;
import z.playw.DragonGuardian.GameBullet;
import z.playw.DragonGuardian.GameEngine;
import z.playw.DragonGuardian.MainCanvas;
import z.playw.j2me.graphics.ColRect;
import z.playw.j2me.graphics.PWPifLifeAnimations;

public class EnemyBase
extends GameActor {
    public PWPifLifeAnimations bloodEffPif;
    public PWPifLifeAnimations bloodEff2Pif;
    public PWPifLifeAnimations boom02Pif;
    public PWPifLifeAnimations superAttEff;
    public long superAttEffStartTime;
    public boolean isEffC;
    public int boomAnid;
    public long boomStartTime;
    public long[] boomStartTime2;
    public int[] bossBoomDiffX;
    public int[] bossBoomDiffY;
    public int bloodAnid;
    public int bloodX;
    public int bloodY;
    public long bloodStartTime;
    public int boomDiffX;
    public int boomDiffY;
    public static final byte STATUS_WAIT = 0;
    public static final byte STATUS_TRACE = 1;
    public static final byte STATUS_ATTACK = 2;
    public static final byte STATUS_ATTACK_FAR = 3;
    public static final byte STATUS_INIT = 4;
    public static final byte STATUS_DEAD = 5;
    public static final byte STATUS_IN_SUPER_ATT = 6;
    public static final byte STATUS_EXPLODE = 7;
    public static final byte STATUS_BOSS_ATT_1 = 8;
    public static final byte STATUS_BOSS_ATT_2 = 9;
    public static final byte STATUS_BOSS_ATT_3 = 10;
    public static final byte STATUS_BOSS_ATT_4 = 11;
    public static final byte STATUS_BOSS_THREE_HEAD_ATT_1_1 = 12;
    public static final byte STATUS_BOSS_FIRE_LORD_ATT_3_1 = 13;
    public static final byte STATUS_BOSS_FIRE_LORD_ATT_3_2 = 14;
    public static final byte STATUS_RETREAT = 15;
    public static final byte STATUS_HURT = 16;
    public static final byte STATUS_SPIDER_HIT = 17;
    public static final byte STATUS_BACK = 18;
    public static final byte STATUS_ATTACK_FAR2 = 19;
    public static final byte STATUS_SUMMON = 20;
    public static final byte STATUS_BOSS_ATT_4_1 = 21;
    public static final byte STATUS_BOSS_ATT_4_2 = 22;
    public static final byte STATUS_BOSS_ATT_4_3 = 23;
    protected int causeOfDeath;
    protected int BossHeadPosx;
    protected int BossHeadPosy;
    protected boolean isDeadSelf;
    protected int BossHeadGoalPosx;
    protected int BossHeadGoalPosy;
    protected int BossHeadBackPosx;
    protected int BossHeadBackPosy;
    protected boolean isReachedGoal;
    protected int[] BossNeckPosx;
    protected int[] BossNeckPosy;
    protected byte lastAttStatus;
    protected int superAttType;
    protected int bossHurtTime;
    public static final int SUBTYPE_NORMAL = 0;
    public static final int SUBTYPE_MAGICIAN = 1;
    public static final int SUBTYPE_SUMMONER = 2;
    public static final int SUBTYPE_BOSS_FIRE_LORD = 3;
    public static final int SUBTYPE_BOSS_THREE_HEAD = 4;
    public static final int SUBTYPE_ROCK = 5;
    public static final int SUBTYPE_TWO_ROCK = 6;
    public static final int SUBTYPE_SPIDER = 7;
    public static final int SUBTYPE_HIT_RUN_SUBTYPE_MAGICIAN = 8;
    public static final int SUBTYPE_CANE_UP = 9;
    public static final int SUBTYPE_CANE_BUTTOM = 10;
    public static final int SUBTYPE_SPIDER_II = 11;
    public static final int SUBTYPE_CANNIBALPLANT = 12;
    public static final int SUBTYPE_FAR_ATT_NORMAL = 13;
    public static final int SUBTYPE_MAGICIAN_ATT_1 = 14;
    public static final int SUBTYPE_MAGICIAN_ATT_2 = 15;
    public static final int SUBTYPE_MAGICIAN_ATT_WHILE_RUN_1 = 16;
    public static final int SUBTYPE_MAGICIAN_ATT_WHILE_RUN_2 = 17;
    public static final int SUBTYPE_NORMAL_ATT_1 = 18;
    public static final int SUBTYPE_NORMAL_ATT_2 = 19;
    public static final int SUBTYPE_NORMAL_ATT_WHILE_RUN_1 = 20;
    public static final int SUBTYPE_NORMAL_ATT_WHILE_RUN_2 = 21;
    public static final int SUBTYPE_NORMAL_NO_FIRST_FAR_ATT = 22;
    public static final int SUBTYPE_GRIFFIN = 23;
    public static final int SUBTYPE_CORBIE = 24;
    public static final int SUBTYPE_DEMON = 25;
    public static final int SUBTYPE_BOSS_CYCLOPS = 26;
    public static final int SUBTYPE_FISHERMAN_SPRINT = 27;
    public static final int SUBTYPE_DEMON_II = 28;
    public static final int SUBTYPE_DEMON_3 = 29;
    public static final int SUBTYPE_DEMON_4 = 30;
    public static final int SUBTYPE_FIRE = 31;
    public static final int SUBTYPE_BOSS_DRACULA = 32;
    public static final int SUBTYPE_FAR_ATT_GRIFFIN = 33;
    public static final int SUBTYPE_GRIFFIN_NO_FIRST_FAR_ATT = 34;
    public static final int SUBTYPE_SKULL = 35;
    public static final int SUBTYPE_FAR_ATT_SKULL = 36;
    public static final int SUBTYPE_SKULL_NO_FIRST_FAR_ATT = 37;
    public static final int SUBTYPE_EYE = 38;
    public static final int SUBTYPE_BOSS_GENERAL = 39;
    public static final int SUBTYPE_EYE_ONLY_FAR = 40;
    public static final int SUBTYPE_EYE_ONLY_FAR2 = 41;
    public static final int SUBTYPE_BOSS_SWORD = 42;
    public static final int SUBTYPE_BOSS_KING = 43;
    public static final int SUBTYPE_BOSS_KINGS_SWORD = 44;
    public static final int SUBTYPE_BOSS_GENERAL1 = 45;
    public static final int SUBTYPE_BOSS_GENERAL2 = 46;
    public static final int SUBTYPE_SKULL_WALL = 47;
    public int hitDamage;
    public static final long TRACK_MIN_TIME = 2000L;
    public static final long TRACK_MAX_TIME = 5000L;
    public long mStayStartTime;
    public long mHurtStartTime;
    public long mWaitTime = 300L;
    public long mFarAttStayTime;
    boolean isFarAtted;
    public long mAlarmStayTime;
    boolean lineatt = false;
    public int fireLordEggOffx;
    public int fireLordEggOffy;
    public static final long FIRELORD_EGG_DES = 20L;
    public static final byte POSITION_FAR = 0;
    public static final byte POSITION_NEAR = 1;
    public static final byte POSITION_FAR2 = 2;
    public static final byte POSITION_FAR3 = 3;
    protected byte mPosition = (byte)-1;
    protected byte mToPosition = 0;
    protected int FarPositionX;
    protected int FarPositionY;
    protected int BeatBackX;
    protected int BeatBackY;
    protected int BeatBackSpeed;
    protected int BossLaserAngel;
    protected boolean addBullet = true;
    protected boolean isBeenAttacked = false;
    protected boolean isInSupperAtt = false;
    protected boolean isBeatedBack = false;
    protected boolean isAddCycleBullet = false;
    protected boolean isAimed = false;
    protected int AimAngle;
    protected int lastAimAngle;
    protected int lastPos;
    protected int aniPal;
    protected int lv;
    protected int bombsoul;
    protected int bombHP;
    protected int bombMP;
    protected int attdamage1;
    protected int attdamage2;
    protected int attdamage3;
    protected int attdamage4;
    protected int farattdamage1;
    protected int farattdamage2;
    protected int farattdamage3;
    protected int farattdamage4;
    protected int speed2;
    protected int dropID;
    public static int DROP_ID_NULL = 0;
    public static int DROP_ID_P = 1;
    public static int DROP_ID_S = 2;
    public static int DROP_ID_WEAPON = 4;
    protected int speed;
    protected int StartX;
    protected int StartY;
    protected int EndX;
    protected int EndY;
    public static long mUIUpdateTime;
    public static byte mUILifeUpdateLevel;
    public static int mUILifePercent;
    public static final byte UI_UPDATE_LV_NORMAL = 0;
    public static final byte UI_UPDATE_LV_DEAD = 1;
    public static final long LEVEL_UPDATE_TIME = 1000L;
    public static GameActor uiBoss;
    boolean isRetreat;
    protected GameActor mKingsSword;
    protected int alarmOffset;
    protected int alarmOfNumber;
    protected int alarmOfSpeed;
    protected boolean drawAlarm;
    protected short wayPointsStep;
    protected int attackCount = 0;
    protected int attCount = 0;
    public static short[][] mEnemyAttribute;
    public static final int ENEMY_ATTR_PARAMETER_COUNT = 15;

    public static void loadEnemyAttribute(byte[] data) {
        if (mEnemyAttribute != null) {
            return;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data, 0, data.length);
            DataInputStream dis = new DataInputStream(bais);
            int length = dis.readShort();
            mEnemyAttribute = new short[length][];
            for (int i2 = 0; i2 < length; ++i2) {
                EnemyBase.mEnemyAttribute[i2] = new short[15];
                for (int j2 = 0; j2 < 15; ++j2) {
                    EnemyBase.mEnemyAttribute[i2][j2] = dis.readShort();
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void beginNotify(long gameTime, int type) {
    }

    public void endNotify(long gameTime, int type) {
    }

    public void init(long gameTime, int type) {
    }

    public boolean isDrawAlartOver(long gameTime) {
        this.mAlarmStayTime += MainCanvas.getGameEngine().getCurFrameTime();
        return this.mAlarmStayTime > 4000L;
    }

    protected void bossDead(long gameTime) {
        MainCanvas.getGameEngine().getPlayer().increaseKilledEnemy(this.getBombsoul());
        this.setInUse(false);
        uiBoss = null;
    }

    protected void proInitAlarm(long gameTime) {
        int movx;
        if (!this.drawAlarm) {
            this.mStayStartTime = gameTime;
        }
        if ((movx = CMath.F2I(CMath.cos((int)(gameTime - this.mStayStartTime) / this.alarmOfSpeed) << this.alarmOfNumber)) > 0) {
            this.alarmOffset = movx;
        } else {
            this.alarmOfNumber = 2;
            this.alarmOffset = 0;
            this.alarmOfSpeed = 1;
        }
    }

    protected void randomBossBoom(long gameTime) {
        this.updateBossBoom(gameTime);
    }

    public void processBossThreeHead(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            return;
        }
        switch (this.getState()) {
            case 0: {
                this.processWaitBoss(gameTime, gameEngine);
                break;
            }
            case 16: {
                if (!this.isAnimationOver(gameTime)) break;
                this.setBeenAttacked(false);
                this.setState((byte)0, gameTime);
                break;
            }
            case 15: {
                this.processRetreat(gameTime, gameEngine);
                break;
            }
            case 8: {
                ColRect mRect = this.getColRect(gameTime, 0);
                if (mRect != null) {
                    ColRect mRect2 = this.getAnimation().GetColRect(8, 0L, true, 0);
                    this.BossHeadPosx = this.getX() + mRect.x - mRect2.x;
                    this.BossHeadPosy = this.getY() + mRect.y - mRect2.y;
                    this.BossHeadGoalPosx = gameEngine.getPlayer().getX();
                    this.BossHeadGoalPosy = gameEngine.getPlayer().getY();
                    this.BossHeadBackPosx = this.BossHeadPosx;
                    this.BossHeadBackPosy = this.BossHeadPosy;
                    this.isReachedGoal = false;
                }
                if (!this.isAnimationOver(gameTime)) break;
                this.setState((byte)12, gameTime);
                break;
            }
            case 12: {
                if (this.isReachedGoal) {
                    if (this.animID == 10) {
                        if (this.isAnimationOver(gameTime)) {
                            this.setState((byte)0, gameTime);
                            this.mStayStartTime = gameTime;
                        }
                    } else if (this.moveToArea2(this.BossHeadBackPosx, this.BossHeadBackPosy, 10, 0, 0)) {
                        this.setRenderContent(10, false, gameTime);
                    }
                } else if (this.moveToArea2(this.BossHeadGoalPosx, this.BossHeadGoalPosy, 20, 0, 0)) {
                    this.isReachedGoal = true;
                }
                int difx = (this.BossHeadPosx - this.BossHeadBackPosx) / this.BossNeckPosx.length;
                int dify = (this.BossHeadPosy - this.BossHeadBackPosy) / this.BossNeckPosy.length;
                for (int i2 = 0; i2 < this.BossNeckPosx.length; ++i2) {
                    this.BossNeckPosx[i2] = this.BossHeadBackPosx + i2 * difx;
                    this.BossNeckPosy[i2] = this.BossHeadBackPosy + i2 * dify;
                }
                if (!this.IsCollision2(gameTime, gameEngine.getPlayer(), 3, 0, 8)) break;
                gameEngine.getPlayer().reduceLife(this.getAttdamage1(), 7, this.getIntersectRect(gameTime, gameEngine.getPlayer(), 3, 0), gameTime);
                break;
            }
            case 9: {
                ColRect bulletRect = this.getColRect(gameTime, 1);
                if (bulletRect != null) {
                    if (this.addBullet) {
                        this.callOfOpenFire(gameTime, actorPool, gameEngine, this.getX() + bulletRect.x, this.getY() + bulletRect.y, 16, 3);
                        this.addBullet = false;
                    }
                } else {
                    this.addBullet = true;
                }
                if (!this.isAnimationOver(gameTime)) break;
                this.setState((byte)0, gameTime);
                this.mStayStartTime = gameTime;
                break;
            }
            case 10: {
                if (this.isCollide(gameTime, gameEngine.getPlayer(), 3, 0)) {
                    gameEngine.getPlayer().reduceLife(this.getFarattdamage2(), 6, this.getIntersectRect(gameTime, gameEngine.getPlayer(), 3, 0), gameTime);
                    this.setRenderContent(11, false, gameTime);
                } else {
                    MainCanvas.getGameEngine().getPlayer().beginNotify(gameTime, 2);
                }
                if (!this.isAnimationOver(gameTime)) break;
                gameEngine.getPlayer().endNotify(gameTime, 2);
                this.setState((byte)0, gameTime);
                this.mStayStartTime = gameTime;
                break;
            }
            case 11: {
                if (this.animID == 6 && this.isAnimationOver(gameTime)) {
                    this.setRenderContent(7, true, gameTime);
                    gameEngine.getPlayer().beginNotify(gameTime, 2);
                    break;
                }
                if (this.animID != 7) break;
                ColRect bulletRect2 = this.getColRect(gameTime, 1);
                if (bulletRect2 != null) {
                    if (!this.addBullet) break;
                    this.callOfOpenFire(gameTime, actorPool, gameEngine, 0, 0, 13, 1);
                    this.addBullet = false;
                    break;
                }
                this.addBullet = true;
                break;
            }
            case 4: {
                if (this.moveToPos(this.EndX, this.EndY, this.speed, gameTime, false)) {
                    if (this.isDrawAlartOver(gameTime)) {
                        this.setState((byte)0, gameTime);
                        this.mStayStartTime = gameTime;
                    }
                    this.drawAlarm = true;
                }
                this.proInitAlarm(gameTime);
                break;
            }
            case 5: {
                if (gameTime - this.stateStartTime > 5000L) {
                    this.bossDead(gameTime);
                    this.setInUse(false);
                    break;
                }
                this.randomBossBoom(gameTime);
                break;
            }
            case 7: {
                if (!this.isAnimationOver(gameTime)) break;
                this.setInUse(false);
            }
        }
    }

    protected void addBonus(long gameTime, ColRect rect) {
        if ((this.getDropID() & DROP_ID_P) != 0) {
            GameBonus bonus2 = (GameBonus)this.getABonus();
            bonus2.init(gameTime, 0);
            bonus2.setX(this.getX() + (rect.w >> 1));
            bonus2.setY(this.getY() - (rect.h >> 1));
        }
    }

    protected void changeFrontage(long gameTime) {
        if (this.getX() < this.getLastX() && this.animID != 1) {
            this.setRenderContent(1, true, gameTime);
        } else if (this.getX() > this.getLastX() && this.animID != 2) {
            this.setRenderContent(2, true, gameTime);
        }
    }

    public ColRect getColRect2(long gameTime, int type, int anid) {
        return this.getAnimation().GetColRect(anid, gameTime - this.stateStartTime, this.animCyclic, type);
    }

    public boolean IsCollision2(long gameTime, GameActor other, int typeSelf, int typeOther, int anid) {
        ColRect cr1 = new ColRect();
        ColRect cr2 = new ColRect();
        cr1.Copy(this.BossHeadPosx, this.BossHeadPosy, this.getColRect2(gameTime, typeSelf, anid));
        cr2.Copy(other.getX(), other.getY(), other.getColRect(gameTime, typeOther));
        return ColRect.RectIntersect(cr1, cr2);
    }

    protected boolean moveToPos(int endx, int endy, int v, long gameTime, boolean nooutscreen) {
        return this.moveToArea(endx, endy, v, 0, 0, true, gameTime, nooutscreen);
    }

    protected boolean moveToArea2(int endx, int endy, int v, int areaw, int areah) {
        int vy;
        int vx;
        if (endx <= this.BossHeadPosx && endx + areaw >= this.BossHeadPosx && endy <= this.BossHeadPosy && endy + areah >= this.BossHeadPosy) {
            return true;
        }
        int xDiff = endx - this.BossHeadPosx;
        int yDiff = endy - this.BossHeadPosy;
        int absdifx = Math.abs(xDiff);
        int absdify = Math.abs(yDiff);
        if (absdify > absdifx) {
            vx = v * absdifx / absdify;
            vy = v;
        } else {
            vx = v;
            vy = v * absdify / absdifx;
        }
        if (yDiff != 0 || xDiff != 0) {
            if (yDiff != 0) {
                this.BossHeadPosy = Math.abs(yDiff) <= vy ? endy : (this.BossHeadPosy += yDiff > 0 ? vy : -vy);
            }
            if (xDiff != 0) {
                this.BossHeadPosx = Math.abs(xDiff) <= vx ? endx : (this.BossHeadPosx += xDiff > 0 ? vx : -vx);
            }
            return false;
        }
        return true;
    }

    protected void callTailBullet(PWPifLifeAnimations anim, long gameTime, GameEngine gameEngine, GameActor bulletPool) {
        bulletPool.setAnimation(anim);
        bulletPool.init(gameTime, 1);
        bulletPool.setSubType(19);
        bulletPool.setVx(0);
        bulletPool.setVy(0);
        ((GameBullet)bulletPool).mDamage = this.getFarattdamage2();
    }

    private void callSuperIceBullet(PWPifLifeAnimations anim, long gameTime, GameEngine gameEngine, GameActor bulletPool) {
        bulletPool.setAnimation(anim);
        bulletPool.init(gameTime, 1);
        bulletPool.setSubType(35);
        bulletPool.setVx(0);
        bulletPool.setVy(0);
        ((GameBullet)bulletPool).mDamage = this.getFarattdamage2();
    }

    private void callBossTailBullet(PWPifLifeAnimations anim, long gameTime, GameEngine gameEngine, GameActor bulletPool) {
        bulletPool.setAnimation(anim);
        bulletPool.init(gameTime, 1);
        bulletPool.setSubType(19);
        bulletPool.setRenderContent(13, true, gameTime);
        bulletPool.setVx(0);
        bulletPool.setVy(0);
        ((GameBullet)bulletPool).mDamage = this.getFarattdamage2();
    }

    protected void lineFire(PWPifLifeAnimations anim, long gameTime, GameEngine gameEngine, GameActor bulletPool, int v, int bullettype) {
        int vy;
        int vx;
        int yDiff;
        bulletPool.setAnimation(anim);
        bulletPool.init(gameTime, 1);
        bulletPool.setSubType(bullettype);
        int xDiff = gameEngine.getPlayer().getX() - this.getX();
        switch (this.attCount) {
            case 0: {
                yDiff = gameEngine.getPlayer().getY() - gameEngine.getPlayer().getColRect((long)gameTime, (int)0).h - this.getY();
                break;
            }
            case 1: {
                yDiff = gameEngine.getPlayer().getY() - this.getY();
                break;
            }
            case 2: {
                yDiff = gameEngine.getPlayer().getY() + gameEngine.getPlayer().getColRect((long)gameTime, (int)0).h - this.getY();
                break;
            }
            default: {
                yDiff = gameEngine.getPlayer().getY() - gameEngine.getPlayer().getColRect((long)gameTime, (int)0).h - this.getY();
            }
        }
        int absdifx = Math.abs(xDiff);
        int absdify = Math.abs(yDiff);
        if (absdify != 0 || absdifx != 0) {
            if (absdify > absdifx) {
                vx = v * absdifx / absdify;
                vy = v;
            } else if (absdify < absdifx) {
                vx = v;
                vy = v * absdify / absdifx;
            } else {
                vx = v;
                vy = v;
            }
        } else {
            vx = v;
            vy = 0;
        }
        bulletPool.setVx(xDiff > 0 ? vx : -vx);
        bulletPool.setVy(yDiff > 0 ? vy : -vy);
        ((GameBullet)bulletPool).mDamage = this.getFarattdamage1();
    }

    public void process(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
    }

    public void reduceLife(int reducePoint, int type, ColRect rc, long gametime) {
    }

    private void processWaitBoss(long gameTime, GameEngine gameEngine) {
        if (this.isInSupperAtt) {
            this.mStayStartTime = gameTime;
        }
        if (gameTime - this.mStayStartTime > this.mWaitTime) {
            if (this.isRetreat) {
                this.setState((byte)15, gameTime);
            } else {
                this.selectAttackType(gameTime);
            }
        }
    }

    protected void processRetreat(long gameTime, GameEngine gameEngine) {
        this.changeFrontage(gameTime);
        if (this.moveToPos(this.EndX, this.EndY, this.speed, gameTime, false)) {
            this.setInUse(false);
        }
    }

    private void summonSword(long gameTime, GameEngine gameEngine, GameActor[] actorpool) {
        for (int i2 = 0; i2 < actorpool.length; ++i2) {
            if (actorpool[i2] != null && actorpool[i2].inUse()) continue;
            if (actorpool[i2] == null) {
                actorpool[i2] = new Enemy();
            }
            Enemy enemy = (Enemy)actorpool[i2];
            enemy.setAnimation(gameEngine.bossSwordPif);
            enemy.setSubType(44);
            enemy.init(gameTime, 1);
            enemy.setState((byte)10, gameTime);
            enemy.lastAttStatus = (byte)10;
            enemy.setX(this.getX());
            enemy.setY(this.getY());
            enemy.speed = this.speed;
            enemy.lv = this.lv;
            enemy.findAttribute((short)24, (short)enemy.lv);
            this.mKingsSword = enemy;
            break;
        }
    }

    protected void selectAttackType(long gameTime) {
        switch (this.getSubType()) {
            case 42: 
            case 44: {
                this.selectAttackTypeBossSword(gameTime);
                break;
            }
            case 0: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 34: 
            case 35: 
            case 37: 
            case 38: {
                this.selectAttackTypeNormal(gameTime);
                break;
            }
            case 1: 
            case 16: 
            case 17: 
            case 30: {
                this.selectAttackTypeMagicain(gameTime);
                break;
            }
            case 14: {
                this.selectAttackTypeMagicain1(gameTime);
                break;
            }
            case 13: 
            case 18: 
            case 19: 
            case 33: 
            case 36: 
            case 40: 
            case 41: {
                this.selectAttackTypeNormalAtt1(gameTime);
                break;
            }
            case 24: 
            case 25: {
                this.selectAttackTypeCorbie(gameTime);
                break;
            }
            case 28: {
                this.selectAttackTypeDemon2(gameTime);
                break;
            }
            case 29: {
                this.selectAttackTypeDemon3(gameTime);
                break;
            }
            case 15: {
                this.selectAttackTypeMagicain2(gameTime);
            }
        }
    }

    private void selectAttackTypeBossDracula(long gameTime) {
        if (this.mToPosition == -1) {
            if (this.lastAttStatus == 10) {
                this.mToPosition = 1;
                this.lastAttStatus = (byte)8;
            } else if (this.lastAttStatus == 8) {
                this.mToPosition = 0;
                this.FarPositionX = 224;
                this.FarPositionY = (this.getY() + 36 + CMath.getRandNumber(1, 3) * 204 / 4) % 204;
                this.BossHeadGoalPosy = this.getY();
                this.lastAttStatus = (byte)9;
            } else {
                if (this.lastAttStatus == 9) {
                    this.mToPosition = (byte)-1;
                    this.setState((byte)11, gameTime);
                    this.lastAttStatus = (byte)11;
                    return;
                }
                if (this.lastAttStatus == 11) {
                    this.mToPosition = (byte)3;
                    this.FarPositionX = 0 + CMath.getRandNumber(85, 90) * 320 / 100;
                    this.FarPositionY = 138;
                    this.lastAttStatus = (byte)10;
                }
            }
            this.setState((byte)1, gameTime);
        } else if (this.getMPosition() == 1) {
            this.setState((byte)8, gameTime);
        } else if (this.getMPosition() == 0) {
            this.setState((byte)9, gameTime);
        } else if (this.getMPosition() == 3) {
            this.setState((byte)10, gameTime);
        }
    }

    private void selectAttackTypeBossCyclops(long gameTime) {
        if (this.mToPosition == -1) {
            if (this.lastAttStatus == 11) {
                this.mToPosition = 1;
                this.lastAttStatus = (byte)8;
            } else if (this.lastAttStatus == 8) {
                this.mToPosition = 0;
                this.FarPositionX = CMath.getRandNumber(80, 90) * 320 / 100;
                this.FarPositionY = (this.getY() + 36 + CMath.getRandNumber(1, 3) * 204 / 4) % 204;
                this.BossHeadGoalPosy = this.getY();
                this.lastAttStatus = (byte)9;
            } else if (this.lastAttStatus == 9) {
                this.mToPosition = (byte)2;
                this.FarPositionX = CMath.getRandNumber(80, 90) * 320 / 100;
                this.FarPositionY = (this.getY() + 36 + CMath.getRandNumber(1, 3) * 204 / 4) % 204;
                this.lastAttStatus = (byte)10;
            } else if (this.lastAttStatus == 10) {
                this.mToPosition = (byte)3;
                this.FarPositionX = CMath.getRandNumber(80, 90) * 320 / 100;
                this.FarPositionY = (this.getY() + 36 + CMath.getRandNumber(1, 3) * 204 / 4) % 204;
                this.lastAttStatus = (byte)11;
            }
            this.setState((byte)1, gameTime);
        } else if (this.getMPosition() == 1) {
            this.setState((byte)8, gameTime);
        } else if (this.getMPosition() == 0) {
            this.setState((byte)9, gameTime);
        } else if (this.getMPosition() == 2) {
            this.setState((byte)10, gameTime);
        } else {
            this.setState((byte)11, gameTime);
        }
    }

    private void selectAttackTypeBossKing(long gameTime) {
        if (this.getLife() <= this.getMaxlife() / 3 && this.mKingsSword == null) {
            GameEngine gameEngine = MainCanvas.getGameEngine();
            MainCanvas.getGameEngine();
            this.summonSword(gameTime, gameEngine, GameEngine.actorPool);
        }
        if (this.mToPosition == -1) {
            if (this.lastAttStatus == 10) {
                this.mToPosition = 1;
                this.lastAttStatus = (byte)11;
            } else if (this.lastAttStatus == 11) {
                this.mToPosition = 0;
                this.FarPositionX = CMath.getRandNumber(50, 90) * 320 / 100;
                this.FarPositionY = 36 + CMath.getRandNumber(5, 90) * 204 / 100;
                this.lastAttStatus = (byte)8;
            } else if (this.lastAttStatus == 8) {
                this.mToPosition = (byte)2;
                this.FarPositionX = CMath.getRandNumber(50, 90) * 320 / 100;
                this.FarPositionY = 36 + CMath.getRandNumber(5, 90) * 204 / 100;
                this.lastAttStatus = (byte)9;
            } else if (this.lastAttStatus == 9) {
                this.mToPosition = (byte)3;
                this.FarPositionX = CMath.getRandNumber(50, 90) * 320 / 100;
                this.FarPositionY = 36 + CMath.getRandNumber(5, 90) * 204 / 100;
                this.lastAttStatus = (byte)10;
            }
            this.setState((byte)1, gameTime);
        } else if (this.getMPosition() == 1) {
            this.setState((byte)11, gameTime);
        } else if (this.getMPosition() == 0) {
            this.setState((byte)8, gameTime);
        } else if (this.getMPosition() == 2) {
            this.setState((byte)9, gameTime);
        } else {
            this.setState((byte)10, gameTime);
        }
    }

    private void selectAttackTypeBossGeneral(long gameTime) {
        if (this.mToPosition == -1) {
            if (this.lastAttStatus == 10) {
                this.mToPosition = 1;
                this.lastAttStatus = (byte)8;
            } else if (this.lastAttStatus == 8) {
                this.mToPosition = 0;
                this.FarPositionX = CMath.getRandNumber(80, 90) * 320 / 100;
                this.FarPositionY = (this.getY() + 36 + CMath.getRandNumber(1, 3) * 204 / 4) % 204;
                this.lastAttStatus = (byte)9;
            } else if (this.lastAttStatus == 9) {
                this.mToPosition = (byte)2;
                this.FarPositionX = 0 + CMath.getRandNumber(85, 90) * 320 / 100;
                this.FarPositionY = 138;
                this.lastAttStatus = (byte)10;
            }
            this.setState((byte)1, gameTime);
        } else if (this.getMPosition() == 1) {
            this.setState((byte)8, gameTime);
        } else if (this.getMPosition() == 0) {
            this.setState((byte)9, gameTime);
        } else if (this.getMPosition() == 2) {
            this.setState((byte)10, gameTime);
        }
    }

    private void selectAttackTypeBossGeneral1(long gameTime) {
        if (!this.isAddCycleBullet) {
            this.setState((byte)12, gameTime);
            return;
        }
        if (this.mToPosition == -1) {
            if (this.lastAttStatus == 11) {
                this.mToPosition = 1;
                this.FarPositionX = 288;
                this.FarPositionY = 36 + CMath.getRandNumber(1, 3) * 51;
                this.attCount = 0;
                this.lastAttStatus = (byte)8;
            } else if (this.lastAttStatus == 8) {
                this.mToPosition = 0;
                this.FarPositionX = 400;
                this.FarPositionY = this.getY();
                this.isFarAtted = false;
                this.lastAttStatus = (byte)9;
            } else if (this.lastAttStatus == 9) {
                this.mToPosition = (byte)2;
                this.FarPositionX = 288;
                this.FarPositionY = 36 + CMath.getRandNumber(1, 3) * 51;
                this.attCount = 0;
                this.lastAttStatus = (byte)10;
            } else if (this.lastAttStatus == 10) {
                this.mToPosition = (byte)3;
                this.FarPositionX = 400;
                this.FarPositionY = this.getY();
                this.attCount = 0;
                this.lastAttStatus = (byte)11;
            }
            this.setState((byte)1, gameTime);
        } else if (this.getMPosition() == 1) {
            this.setState((byte)8, gameTime);
        } else if (this.getMPosition() == 0) {
            this.setState((byte)9, gameTime);
        } else if (this.getMPosition() == 2) {
            this.setState((byte)10, gameTime);
        } else if (this.getMPosition() == 3) {
            this.mStayStartTime = gameTime;
            this.setState((byte)11, gameTime);
        }
    }

    private void selectAttackTypeBossGeneral2(long gameTime) {
        int toPos = -1;
        boolean ret = true;
        if (this.mToPosition == -1) {
            if (this.lastAttStatus == 10) {
                this.mToPosition = 1;
                this.attCount = 0;
                this.lastAttStatus = (byte)8;
            } else if (this.lastAttStatus == 8) {
                this.mToPosition = 0;
                this.attCount = 0;
                this.lastAttStatus = (byte)9;
            } else if (this.lastAttStatus == 9) {
                this.mToPosition = (byte)2;
                this.attCount = 0;
                this.lastAttStatus = (byte)10;
            }
            while (ret) {
                toPos = CMath.getRandNumber(0, 10) > 4 ? CMath.getRandNumber(2, CONSTANT.BOSS_GENERAL_POS.length - 1) : CMath.getRandNumber(0, 2);
                if (toPos == this.lastPos) continue;
                this.lastPos = toPos;
                ret = false;
            }
            this.FarPositionX = 0 + CONSTANT.BOSS_GENERAL_POS[toPos][0] * 320 / 100;
            this.FarPositionY = 36 + CONSTANT.BOSS_GENERAL_POS[toPos][1] * 204 / 100;
            this.setState((byte)1, gameTime);
        } else if (this.getMPosition() == 1) {
            this.setState((byte)8, gameTime);
        } else if (this.getMPosition() == 0) {
            this.setState((byte)8, gameTime);
        } else if (this.getMPosition() == 2) {
            this.setState((byte)9, gameTime);
        }
    }

    private void selectAttackTypeBossSword(long gameTime) {
        if (this.mToPosition == -1) {
            if (this.lastAttStatus == 9) {
                this.mToPosition = 0;
                this.FarPositionX = 160;
                this.FarPositionY = 102;
                this.lastAttStatus = (byte)8;
                this.setState((byte)1, gameTime);
            } else if (this.lastAttStatus == 10) {
                if (this.attCount > 5) {
                    this.lastAttStatus = (byte)9;
                    this.mToPosition = (byte)-1;
                    this.setState((byte)0, gameTime);
                    this.attCount = 0;
                } else {
                    this.suicidalAttbefore();
                    this.setState((byte)9, gameTime);
                }
            } else if (this.lastAttStatus == 8) {
                this.lastAttStatus = (byte)10;
                this.mToPosition = (byte)-1;
                this.setState((byte)10, gameTime);
            }
        } else if (this.getMPosition() == 0) {
            this.setState((byte)8, gameTime);
        }
    }

    protected void selectAttackTypeBossFireLord(long gameTime) {
        if (this.mToPosition == -1) {
            if (this.lastAttStatus == 10) {
                this.mToPosition = 0;
                this.FarPositionX = CMath.getRandNumber(80, 90) * 320 / 100;
                this.FarPositionY = (this.getY() + CMath.getRandNumber(1, 3) * 204 / 4) % 204;
                this.lastAttStatus = (byte)8;
            } else if (this.lastAttStatus == 8) {
                this.mToPosition = 1;
                this.lastAttStatus = (byte)9;
            } else if (this.lastAttStatus == 9) {
                this.mToPosition = (byte)2;
                this.FarPositionX = CMath.getRandNumber(80, 90) * 320 / 100;
                this.FarPositionY = (this.getY() + CMath.getRandNumber(1, 3) * 204 / 4) % 204;
                this.lastAttStatus = (byte)10;
            }
            this.setState((byte)1, gameTime);
        } else if (this.getMPosition() == 0) {
            this.setState((byte)8, gameTime);
        } else if (this.getMPosition() == 1) {
            this.setState((byte)9, gameTime);
        } else {
            this.setState((byte)10, gameTime);
        }
    }

    private void selectAttackTypeBossThreeHead(long gameTime) {
        if (this.lastAttStatus == 10) {
            this.setState((byte)9, gameTime);
            this.lastAttStatus = (byte)9;
        } else if (this.lastAttStatus == 8) {
            this.setState((byte)10, gameTime);
            this.lastAttStatus = (byte)10;
        } else if (this.lastAttStatus == 9) {
            this.setState((byte)8, gameTime);
            this.lastAttStatus = (byte)8;
        }
    }

    private void selectAttackTypeMagicain(long gameTime) {
        if (this.isBeenAttacked()) {
            this.setFarPosition();
            this.setState((byte)1, gameTime);
            this.setBeenAttacked(false);
        } else if (this.attackCount >= 5) {
            this.setNearPosition();
            this.setState((byte)1, gameTime);
            this.attackCount = 0;
        } else if (this.attackCount >= 2) {
            if (CMath.getRandNumber(0, 100) > 30) {
                this.randomMagicianAtt(gameTime);
            } else {
                this.setFarPosition();
                this.setState((byte)1, gameTime);
                this.attackCount = 0;
            }
        } else if (CMath.getRandNumber(0, 100) > 10) {
            this.randomMagicianAtt(gameTime);
        } else {
            this.setNearPosition();
            this.setState((byte)1, gameTime);
            this.attackCount = 0;
        }
    }

    private void randomMagicianAtt(long gameTime) {
        if (CMath.getRandNumber(0, 10) > 5) {
            this.setState((byte)19, gameTime);
        } else {
            this.setState((byte)3, gameTime);
        }
    }

    private void selectAttackTypeMagicain1(long gameTime) {
        if (this.isBeenAttacked()) {
            this.setFarPosition();
            this.setState((byte)1, gameTime);
            this.setBeenAttacked(false);
        } else if (this.attackCount >= 5) {
            this.setNearPosition();
            this.setState((byte)1, gameTime);
            this.attackCount = 0;
        } else if (this.attackCount >= 2) {
            if (CMath.getRandNumber(0, 100) > 30) {
                this.setState((byte)3, gameTime);
            } else {
                this.setFarPosition();
                this.setState((byte)1, gameTime);
                this.attackCount = 0;
            }
        } else if (CMath.getRandNumber(0, 100) > 10) {
            this.setState((byte)3, gameTime);
        } else {
            this.setNearPosition();
            this.setState((byte)1, gameTime);
            this.attackCount = 0;
        }
    }

    private void selectAttackTypeSummoner(long gameTime) {
        if (this.isBeenAttacked()) {
            this.setFarPosition();
            this.setState((byte)1, gameTime);
            this.setBeenAttacked(false);
        } else if (this.getRelatePlayer() == null || !this.getRelatePlayer().inUse()) {
            this.setState((byte)20, gameTime);
        } else if (this.attackCount >= 5) {
            this.setNearPosition();
            this.setState((byte)1, gameTime);
            this.attackCount = 0;
        } else if (this.attackCount >= 2) {
            if (CMath.getRandNumber(0, 100) > 30) {
                this.setState((byte)3, gameTime);
            } else {
                this.setFarPosition();
                this.setState((byte)1, gameTime);
                this.attackCount = 0;
            }
        } else if (CMath.getRandNumber(0, 100) > 10) {
            this.setState((byte)3, gameTime);
        } else {
            this.setNearPosition();
            this.setState((byte)1, gameTime);
            this.attackCount = 0;
        }
    }

    private void selectAttackTypeMagicain2(long gameTime) {
        if (this.isBeenAttacked()) {
            this.setFarPosition();
            this.setState((byte)1, gameTime);
            this.setBeenAttacked(false);
        } else if (this.attackCount >= 5) {
            this.setNearPosition();
            this.setState((byte)1, gameTime);
            this.attackCount = 0;
        } else if (this.attackCount >= 2) {
            if (CMath.getRandNumber(0, 100) > 30) {
                this.setState((byte)19, gameTime);
            } else {
                this.setFarPosition();
                this.setState((byte)1, gameTime);
                this.attackCount = 0;
            }
        } else if (CMath.getRandNumber(0, 100) > 10) {
            this.setState((byte)19, gameTime);
        } else {
            this.setNearPosition();
            this.setState((byte)1, gameTime);
            this.attackCount = 0;
        }
    }

    private void selectAttackTypeNormal(long gameTime) {
        if (this.getMPosition() == 0) {
            if (this.isBeenAttacked()) {
                this.setNearPosition();
                this.setState((byte)1, gameTime);
            } else if (this.attackCount > 1) {
                this.mToPosition = 1;
                this.setState((byte)1, gameTime);
                this.attackCount = 0;
            } else if (CMath.getRandNumber(0, 100) > 20) {
                if (CMath.getRandNumber(0, 100) > 50) {
                    this.mStayStartTime = gameTime;
                    this.isFarAtted = true;
                }
                this.setState((byte)3, gameTime);
            } else {
                this.mToPosition = 1;
                this.setState((byte)1, gameTime);
                this.attackCount = 0;
            }
        } else if (this.isBeenAttacked()) {
            this.setNearPosition();
            this.setState((byte)1, gameTime);
        } else if (CMath.getRandNumber(0, 100) > 20) {
            if (CMath.getRandNumber(0, 100) > 50) {
                this.mToPosition = 1;
                this.setState((byte)1, gameTime);
                this.attackCount = 0;
            } else {
                this.setState((byte)2, gameTime);
            }
        } else {
            if (CMath.getRandNumber(0, 100) > 50) {
                this.mStayStartTime = gameTime;
                this.isFarAtted = true;
            }
            this.setState((byte)3, gameTime);
        }
    }

    private void selectAttackTypeFishermanSprint(long gameTime) {
        this.setState((byte)2, gameTime);
        this.animCyclic = true;
        this.suicidalAttbefore();
    }

    private void selectAttackTypeDemon2(long gameTime) {
        this.setState((byte)2, gameTime);
        this.setRenderContent(4, true, gameTime);
        this.mStayStartTime = gameTime;
        this.isFarAtted = false;
    }

    private void selectAttackTypeDemon3(long gameTime) {
        this.setState((byte)2, gameTime);
        this.setRenderContent(3, true, gameTime);
        this.mStayStartTime = gameTime;
        this.isFarAtted = false;
    }

    private void selectAttackTypeCorbie(long gameTime) {
        this.setState((byte)2, gameTime);
        this.setRenderContent(3, true, gameTime);
        this.suicidalAttbefore();
    }

    private void suicidalAttbefore() {
        int vy;
        int vx;
        int xDiff = MainCanvas.getGameEngine().getPlayer().getX() - this.getX();
        int yDiff = MainCanvas.getGameEngine().getPlayer().getY() - this.getY();
        int absdifx = Math.abs(xDiff);
        int absdify = Math.abs(yDiff);
        if (absdify != 0 || absdifx != 0) {
            if (absdify > absdifx) {
                vx = this.speed * absdifx / absdify;
                vy = this.speed;
            } else if (absdify < absdifx) {
                vx = this.speed;
                vy = this.speed * absdify / absdifx;
            } else {
                vx = this.speed;
                vy = this.speed;
            }
        } else {
            vx = this.speed;
            vy = 0;
        }
        this.setVx(xDiff > 0 ? vx : -vx);
        this.setVy(yDiff > 0 ? vy : -vy);
    }

    private void selectAttackTypeNormalAtt1(long gameTime) {
        if (this.isBeenAttacked()) {
            this.setFarPosition();
            this.setState((byte)1, gameTime);
            this.setBeenAttacked(false);
        } else if (this.attackCount >= 5) {
            this.setNearPosition();
            this.setState((byte)1, gameTime);
            this.attackCount = 0;
        } else if (this.attackCount >= 2) {
            if (CMath.getRandNumber(0, 100) > 30) {
                this.mStayStartTime = gameTime;
                this.setState((byte)3, gameTime);
            } else {
                this.setFarPosition();
                this.setState((byte)1, gameTime);
                this.attackCount = 0;
            }
        } else if (CMath.getRandNumber(0, 100) > 10) {
            this.mStayStartTime = gameTime;
            this.setState((byte)3, gameTime);
        } else {
            this.setNearPosition();
            this.setState((byte)1, gameTime);
            this.attackCount = 0;
        }
    }

    private void setFarPosition() {
        this.mToPosition = 0;
        this.FarPositionX = 0 + CMath.getRandNumber(70, 90) * 320 / 100;
        this.FarPositionY = 36 + CMath.getRandNumber(1, 3) * 204 / 4;
    }

    private void setNearPosition() {
        this.mToPosition = 1;
        this.FarPositionX = this.getSubType() == 0 || this.getSubType() == 20 || this.getSubType() == 21 || this.getSubType() == 22 || this.getSubType() == 23 || this.getSubType() == 34 || this.getSubType() == 35 || this.getSubType() == 37 || this.getSubType() == 38 ? this.getX() + 20 : this.getX() - CMath.getRandNumber(0, 20) * 320 / 100;
    }

    private void updateBossBoom(long gametime) {
        if (this.boomStartTime2 != null) {
            for (int i2 = 0; i2 < this.boomStartTime2.length; ++i2) {
                if (!this.checkAniOver(this.boom02Pif, this.boomAnid, gametime, this.boomStartTime2[i2])) continue;
                this.boomStartTime2[i2] = gametime;
                this.setRandomBossBoomPos(gametime, i2);
            }
        }
    }

    public void setRandomBossBoomPos(long gametime, int i2) {
        if (this.getSubType() == 4) {
            this.bossBoomDiffX[i2] = CMath.getRandNumber(-7, 60);
            this.bossBoomDiffY[i2] = CMath.getRandNumber(-53, 53);
        } else {
            this.bossBoomDiffX[i2] = CMath.getRandNumber(-37, 37);
            this.bossBoomDiffY[i2] = CMath.getRandNumber(-53, 53);
        }
    }

    public boolean checkAniOver(PWPifLifeAnimations anim, int anid, long gametime, long starttime) {
        return anim.animationIsOver(anid, (int)(gametime - starttime));
    }

    protected void callOfOpenFire(long gameTime, GameActor[] actorPool, GameEngine gameEngine, int startx, int starty, int type, int bulletnumber) {
        GameActor[] bulletPool = GameEngine.getBulletPool();
        int addCount = 0;
        for (int i2 = 0; i2 < bulletPool.length; ++i2) {
            if (bulletPool[i2] != null && bulletPool[i2].inUse()) continue;
            if (bulletPool[i2] == null) {
                bulletPool[i2] = new GameBullet();
            }
            switch (type) {
                case 31: {
                    this.callBulletBossSwords(gameEngine.bossSwordPif, gameTime, gameEngine, startx, starty, bulletPool[i2], addCount);
                    break;
                }
                case 20: {
                    this.callBulletShortGun(gameEngine.enemy03BulletPif, gameTime, gameEngine, startx, starty, bulletPool[i2], addCount);
                    break;
                }
                case 26: {
                    this.callBulletShortGun3(gameEngine.bossBullet01Pif, gameTime, gameEngine, startx, starty, bulletPool[i2], addCount);
                    ((GameBullet)bulletPool[i2]).mDamage = this.getFarattdamage1();
                    break;
                }
                case 23: {
                    this.lineFire(gameEngine.enemy02BulletPif, gameTime, gameEngine, bulletPool[i2], 4, 14);
                    bulletPool[i2].setX(startx);
                    bulletPool[i2].setY(starty);
                    break;
                }
                case 19: {
                    this.callTailBullet(gameEngine.enemyTailBulletPif, gameTime, gameEngine, bulletPool[i2]);
                    bulletPool[i2].setX(startx);
                    bulletPool[i2].setY(starty);
                }
            }
            if (++addCount > bulletnumber - 1) break;
        }
    }

    private void callBulletBossThreeHeadNormal(long gameTime, GameEngine gameEngine, GameActor bulletPool) {
        bulletPool.setAnimation(gameEngine.bossBullet01Pif);
        bulletPool.init(gameTime, 3);
        bulletPool.setSubType(13);
        bulletPool.setVx(-1 * CMath.getRandNumber(5, 10));
        bulletPool.setX(CMath.getRandNumber(320, 160));
        bulletPool.setY(36 + CMath.getRandNumber(25, 178));
        bulletPool.setVy(0);
        ((GameBullet)bulletPool).mDamage = this.getFarattdamage3();
    }

    private void callBulletStayBurn(long gameTime, GameEngine gameEngine, int startx, int starty, GameActor bulletPool) {
        bulletPool.setAnimation(gameEngine.bossFireLordPif);
        bulletPool.init(gameTime, 5);
        bulletPool.setSubType(18);
        bulletPool.setX(startx);
        bulletPool.setY(starty);
        bulletPool.setVy(0);
        ((GameBullet)bulletPool).mDamage = this.getFarattdamage4();
    }

    private void callBulletBigBomb(long gameTime, GameEngine gameEngine, int startx, int starty, GameActor bulletPool) {
        bulletPool.setAnimation(gameEngine.bossBullet01Pif);
        bulletPool.init(gameTime, 4);
        bulletPool.setSubType(17);
        ((GameBullet)bulletPool).setGoalX(gameEngine.getPlayer().getX());
        ((GameBullet)bulletPool).setGoalY(gameEngine.getPlayer().getY());
        bulletPool.setVx(6);
        bulletPool.setX(startx);
        bulletPool.setY(starty);
        bulletPool.setVy(0);
    }

    private void callBulletBurnFire(long gameTime, GameEngine gameEngine, int startx, int starty, GameActor bulletPool, int addCount) {
        bulletPool.setAnimation(gameEngine.bossBullet01Pif);
        bulletPool.init(gameTime, 2);
        bulletPool.setSubType(16);
        ((GameBullet)bulletPool).setGoalX(0 + CMath.getRandNumber(64, 120));
        ((GameBullet)bulletPool).setGoalY(36 + (addCount + 1) * 204 / 4);
        bulletPool.setVx(CMath.getRandNumber(5, 10));
        bulletPool.setX(startx);
        bulletPool.setY(starty);
        bulletPool.setVy(0);
        ((GameBullet)bulletPool).mDamage = this.getFarattdamage1();
    }

    private void callBulletShortGunVenom(long gameTime, GameEngine gameEngine, int startx, int starty, GameActor bulletPool, int addCount) {
        bulletPool.setAnimation(gameEngine.bulletSpiderPif);
        bulletPool.setRenderContent(0, true, gameTime);
        bulletPool.init(gameTime, 6);
        bulletPool.setSubType(21);
        bulletPool.setX(startx);
        bulletPool.setY(starty);
        if (addCount == 0) {
            bulletPool.setRawVy(-(CMath.sin(15) * 2));
            bulletPool.setVx(-2);
        } else if (addCount == 1) {
            bulletPool.setVy(0);
            bulletPool.setVx(-2);
        } else if (addCount == 2) {
            bulletPool.setRawVy(CMath.sin(15) * 2);
            bulletPool.setVx(-2);
        }
        ((GameBullet)bulletPool).mDamage = this.getFarattdamage1();
    }

    private void callBulletShootLine(long gameTime, GameEngine gameEngine, int startx, int starty, GameActor bulletPool, int addCount) {
        int currentAngle;
        boolean ret = false;
        bulletPool.setAnimation(gameEngine.enemy03BulletPif);
        bulletPool.init(gameTime, 1);
        bulletPool.setSubType(34);
        bulletPool.setX(startx);
        bulletPool.setY(starty);
        int offAimAngle = 0;
        if (this.attCount == 0) {
            currentAngle = this.AimAngle;
        } else if (this.attCount == 1) {
            while (offAimAngle == 0) {
                offAimAngle = CMath.getRandNumber(-2, 2);
            }
            this.lastAimAngle = offAimAngle;
            currentAngle = this.AimAngle + offAimAngle * 15;
        } else {
            while (!ret) {
                offAimAngle = CMath.getRandNumber(-2, 2);
                if (offAimAngle == 0 || offAimAngle == this.lastAimAngle) continue;
                ret = true;
            }
            currentAngle = this.AimAngle + offAimAngle * 15;
        }
        int spd = this.getLife() < this.getMaxlife() / 3 ? 7 : (this.getLife() < 2 * this.getMaxlife() / 3 ? 5 : 2);
        bulletPool.setRawVy(CMath.sin(currentAngle) * spd);
        bulletPool.setRawVx(CMath.cos(currentAngle) * spd);
        ((GameBullet)bulletPool).mDamage = this.getFarattdamage1();
    }

    private void callBulletBossBat(long gameTime, GameEngine gameEngine, int startx, int starty, GameActor bulletPool, int addCount) {
        bulletPool.setAnimation(gameEngine.bossBulletBat);
        bulletPool.init(gameTime, 8);
        bulletPool.setSubType(28);
        bulletPool.setState((byte)3, gameTime);
        bulletPool.setX(startx);
        bulletPool.setY(starty);
        bulletPool.setVx(-2);
        ((GameBullet)bulletPool).mDamage = this.getFarattdamage2();
    }

    private void callBulletBossSword(long gameTime, GameEngine gameEngine, int startx, int starty, GameActor bulletPool, int addCount) {
        bulletPool.setAnimation(gameEngine.bossKingPif);
        bulletPool.init(gameTime, 9);
        bulletPool.setSubType(33);
        bulletPool.setState((byte)3, gameTime);
        bulletPool.setX(startx);
        bulletPool.setY(starty);
        bulletPool.setVx(-8);
        bulletPool.setVy(0);
        ((GameBullet)bulletPool).mDamage = this.getFarattdamage1();
    }

    private void callBulletBossBlaster(PWPifLifeAnimations anim, long gameTime, GameEngine gameEngine, int startx, int starty, GameActor bulletPool, int addCount) {
        bulletPool.setAnimation(anim);
        bulletPool.init(gameTime, 1);
        bulletPool.setSubType(25);
        bulletPool.setVx(-10);
        bulletPool.setVy(0);
        bulletPool.setX(startx);
        bulletPool.setY(starty);
        ((GameBullet)bulletPool).mDamage = this.getFarattdamage2();
    }

    private void callBulletBossSwordEdge(PWPifLifeAnimations anim, long gameTime, GameEngine gameEngine, int startx, int starty, GameActor bulletPool, int addCount) {
        bulletPool.setAnimation(anim);
        bulletPool.init(gameTime, 1);
        bulletPool.setSubType(25);
        bulletPool.setVx(-10);
        bulletPool.setVy(0);
        bulletPool.setX(startx);
        bulletPool.setY(starty);
        bulletPool.setRenderContent(1, true, gameTime);
        ((GameBullet)bulletPool).mDamage = this.getFarattdamage2();
    }

    private void callBulletBossSwords(PWPifLifeAnimations anim, long gameTime, GameEngine gameEngine, int startx, int starty, GameActor bulletPool, int addCount) {
        bulletPool.setAnimation(anim);
        bulletPool.init(gameTime, 1);
        bulletPool.setSubType(31);
        bulletPool.setX(startx);
        bulletPool.setY(starty);
        bulletPool.setRenderContent(7 + (addCount + 9 - 7) % 8, true, gameTime);
        ((GameBullet)bulletPool).vx = 13 * CMath.cos(addCount * 45);
        ((GameBullet)bulletPool).vy = 13 * CMath.sin(addCount * 45);
        ((GameBullet)bulletPool).mDamage = this.getFarattdamage1();
    }

    private void callBulletBossLaser(PWPifLifeAnimations anim, long gameTime, GameEngine gameEngine, int startx, int starty, GameActor bulletPool, int addCount) {
        bulletPool.setAnimation(anim);
        bulletPool.init(gameTime, 1);
        bulletPool.setSubType(27);
        bulletPool.setY(-28);
        bulletPool.setVx(0);
        bulletPool.setVy(4);
        int x = (0 + this.BossHeadBackPosx + 70 * addCount) % 320;
        bulletPool.setX(x);
        bulletPool.setRenderContent(5, true, gameTime);
        ((GameBullet)bulletPool).mDamage = this.getFarattdamage2();
    }

    private void callBulletShortGun3(PWPifLifeAnimations anim, long gameTime, GameEngine gameEngine, int startx, int starty, GameActor bulletPool, int addCount) {
        bulletPool.setAnimation(anim);
        bulletPool.init(gameTime, 1);
        bulletPool.setSubType(14);
        bulletPool.setX(startx);
        bulletPool.setY(starty);
        if (addCount == 0) {
            bulletPool.setVy(0);
            bulletPool.setVx(-6);
        } else if (addCount == 1) {
            bulletPool.setVy(-2);
            bulletPool.setVx(-4);
        } else if (addCount == 2) {
            bulletPool.setVy(-4);
            bulletPool.setVx(-2);
        } else if (addCount == 3) {
            bulletPool.setVy(-6);
            bulletPool.setVx(0);
        } else if (addCount == 4) {
            bulletPool.setVy(-4);
            bulletPool.setVx(2);
        } else if (addCount == 5) {
            bulletPool.setVy(-2);
            bulletPool.setVx(-4);
        } else if (addCount == 6) {
            bulletPool.setVy(0);
            bulletPool.setVx(6);
        } else if (addCount == 7) {
            bulletPool.setVy(2);
            bulletPool.setVx(4);
        } else if (addCount == 8) {
            bulletPool.setVy(4);
            bulletPool.setVx(2);
        } else if (addCount == 9) {
            bulletPool.setVy(6);
            bulletPool.setVx(0);
        } else if (addCount == 10) {
            bulletPool.setVy(4);
            bulletPool.setVx(-2);
        } else if (addCount == 11) {
            bulletPool.setVy(2);
            bulletPool.setVx(-4);
        }
        bulletPool.setRenderContent(0, true, gameTime);
    }

    private void callBulletShortGun(PWPifLifeAnimations anim, long gameTime, GameEngine gameEngine, int startx, int starty, GameActor bulletPool, int addCount) {
        bulletPool.setAnimation(anim);
        bulletPool.init(gameTime, 1);
        bulletPool.setSubType(14);
        bulletPool.setX(startx);
        bulletPool.setY(starty);
        if (addCount == 0) {
            bulletPool.setVy(-4);
            bulletPool.setVx(-2);
        } else if (addCount == 1) {
            bulletPool.setVy(-2);
            bulletPool.setVx(-4);
        } else if (addCount == 2) {
            bulletPool.setVy(4);
            bulletPool.setVx(-2);
        } else if (addCount == 3) {
            bulletPool.setVy(2);
            bulletPool.setVx(-4);
        } else if (addCount == 4) {
            bulletPool.setVy(0);
            bulletPool.setVx(-6);
        }
        bulletPool.setRenderContent(0, true, gameTime);
        ((GameBullet)bulletPool).mDamage = this.getFarattdamage1();
    }

    private void callBulletCycle(PWPifLifeAnimations anim, long gameTime, GameEngine gameEngine, int startx, int starty, GameActor bulletPool, int addCount) {
        bulletPool.setAnimation(anim);
        bulletPool.init(gameTime, 1);
        bulletPool.setSubType(30);
        bulletPool.setX(startx);
        bulletPool.setY(starty);
        bulletPool.setRenderContent(12, true, gameTime);
        bulletPool.setRelatePlayer(this);
        ((GameBullet)bulletPool).mStayTime = -1L;
        ((GameBullet)bulletPool).mCycleAngel = addCount * 90;
        ColRect selfRect = this.getColRect(gameTime, 0);
        ((GameBullet)bulletPool).mCycleRadius = selfRect.h;
        ((GameBullet)bulletPool).mDamage = this.getFarattdamage2();
    }

    public byte getMPosition() {
        return this.mPosition;
    }

    protected void setBeenAttacked(boolean isAttacked) {
        this.isBeenAttacked = isAttacked;
    }

    protected boolean isBeenAttacked() {
        return this.isBeenAttacked;
    }

    public void findAttribute(short idx, short lv) {
        for (int i2 = 0; i2 < mEnemyAttribute.length; ++i2) {
            if (mEnemyAttribute[i2][0] != idx || mEnemyAttribute[i2][1] != lv) continue;
            this.setAttribute(mEnemyAttribute[i2]);
        }
    }

    public void setAttribute(short[] attributes) {
        this.lv = attributes[1];
        this.setBombsoul(attributes[2]);
        this.setBombHP(attributes[3]);
        this.setBombMP(attributes[4]);
        this.setAttdamage1(attributes[5]);
        this.attdamage2 = attributes[6];
        this.attdamage3 = attributes[7];
        this.attdamage4 = attributes[8];
        this.setFarattdamage1(attributes[9]);
        this.setFarattdamage2(attributes[10]);
        this.setFarattdamage3(attributes[11]);
        this.setFarattdamage4(attributes[12]);
        this.setSpeed2(attributes[13]);
        this.setLifeOfAtt(attributes[14]);
    }

    private void setLifeOfAtt(short attributes) {
        if (attributes > 0) {
            this.setLife(attributes);
            this.setMaxlife(this.getLife());
        }
    }

    public int getAttdamage1() {
        if (this.attdamage1 > 0) {
            return this.attdamage1;
        }
        return 4;
    }

    public void setAttdamage1(int attdamage1) {
        this.attdamage1 = attdamage1;
    }

    public int getFarattdamage1() {
        if (this.farattdamage1 > 0) {
            return this.farattdamage1;
        }
        return 4;
    }

    public void setFarattdamage1(int farattdamage1) {
        this.farattdamage1 = farattdamage1;
    }

    public void setSpeed2(int speed2) {
        this.speed2 = speed2;
    }

    public int getFarattdamage2() {
        if (this.farattdamage2 > 0) {
            return this.farattdamage2;
        }
        return 4;
    }

    public void setFarattdamage2(int farattdamage2) {
        this.farattdamage2 = farattdamage2;
    }

    public int getFarattdamage3() {
        if (this.farattdamage3 > 0) {
            return this.farattdamage3;
        }
        return 4;
    }

    public void setFarattdamage3(int farattdamage3) {
        this.farattdamage3 = farattdamage3;
    }

    public int getFarattdamage4() {
        if (this.farattdamage4 > 0) {
            return this.farattdamage4;
        }
        return 4;
    }

    public void setFarattdamage4(int farattdamage4) {
        this.farattdamage4 = farattdamage4;
    }

    public int getBombsoul() {
        if (this.bombsoul > 0) {
            int gamelevel = MainCanvas.indexOfLevel;
            if (CONSTANT.LEVEL_MAX_LEVEL[gamelevel] == -1) {
                return this.bombsoul;
            }
            return 1;
        }
        return 0;
    }

    public void setBombsoul(int bombsoul) {
        this.bombsoul = bombsoul;
    }

    public int getBombHP() {
        if (this.bombHP > 0) {
            return this.bombHP;
        }
        return 0;
    }

    public void setBombHP(int bombHP) {
        this.bombHP = bombHP;
    }

    public int getBombMP() {
        if (this.bombMP > 0) {
            return this.bombMP;
        }
        return 0;
    }

    public void setBombMP(int bombMP) {
        this.bombMP = bombMP;
    }

    public int getDropID() {
        return this.dropID;
    }
}

