/*
 * Decompiled with CFR 0.152.
 */
package z.playw.DragonGuardian;

import javax.microedition.lcdui.Graphics;
import z.playw.DragonGuardian.CMath;
import z.playw.DragonGuardian.GameActor;
import z.playw.DragonGuardian.GameEngine;
import z.playw.DragonGuardian.MainCanvas;
import z.playw.DragonGuardian.Player;
import z.playw.j2me.graphics.ColRect;

public class Spirit
extends GameActor {
    public static final int SPIRIT_HEALTH = 0;
    public static final int SPIRIT_MAGIC = 1;
    public static final int SPIRIT_SOUL = 2;
    public static final byte STATUS_FLY = 0;
    public static final byte STATUS_EAT = 1;
    public static int traceSpeed = 0;
    private int[][] trailPosition = new int[][]{{-1, -1}, {-1, -1}, {-1, -1}};

    public void beginNotify(long gameTime, int type) {
    }

    public void endNotify(long gameTime, int type) {
    }

    public void init(long gameTime, int type) {
        this.setInUse(true);
        this.setType(type);
        this.setAnimation(MainCanvas.getGameEngine().spiritPif);
        traceSpeed = 0;
        for (int i2 = 0; i2 < this.trailPosition.length; ++i2) {
            this.trailPosition[i2][0] = -1;
            this.trailPosition[i2][1] = -1;
        }
        this.setState((byte)0, gameTime);
    }

    public void process(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.getState() == 0) {
            Player player;
            ColRect rect;
            int oldSign;
            int lastFrameX = this.getX();
            int lastFrameY = this.getY();
            if (this.ax != 0) {
                this.x += this.vx;
                oldSign = this.vx > 0 ? 1 : -1;
                this.vx += this.ax;
                if (oldSign * this.vx <= 0) {
                    this.ax = 0;
                }
            }
            if (this.ay != 0) {
                this.y += this.vy;
                oldSign = this.vy > 0 ? 1 : -1;
                this.vy += this.ay;
                if (oldSign * this.vy <= 0) {
                    this.ay = 0;
                }
            }
            if ((rect = (player = gameEngine.getPlayer()).getColRect(gameTime, 0)) != null && this.moveToArea(player.getX(), player.getY() - (rect.h >> 1), CMath.F2I(traceSpeed), rect.w >> 1, rect.h >> 1, true, gameTime, false)) {
                this.setState((byte)1, gameTime);
            } else {
                if ((traceSpeed += 8192) > CMath.I2F(10)) {
                    traceSpeed = CMath.I2F(10);
                }
                if (this.trailPosition[0][0] != lastFrameX || this.trailPosition[0][1] != lastFrameY) {
                    for (int i2 = this.trailPosition.length - 1; i2 > 0; --i2) {
                        this.trailPosition[i2][0] = this.trailPosition[i2 - 1][0];
                        this.trailPosition[i2][1] = this.trailPosition[i2 - 1][1];
                    }
                    this.trailPosition[0][0] = lastFrameX;
                    this.trailPosition[0][1] = lastFrameY;
                }
            }
        } else if (this.getState() == 1) {
            Player player = gameEngine.getPlayer();
            if (this.isAnimationOver(gameTime) && !player.isPlayerDead()) {
                this.setInUse(false);
                if (this.getType() == 0) {
                    player.setLife(player.getLife() + this.getLife());
                    if (player.getLife() > player.getMaxlife()) {
                        player.setLife(player.getMaxlife());
                    }
                } else if (this.getType() == 1) {
                    player.setMana(player.getMana() + this.getLife());
                    if (player.getMana() > 100) {
                        player.setMana(100);
                    }
                } else if (this.getType() == 2) {
                    Player.setPlayerSouls(player.getPlayerSouls() + this.getLife());
                }
            }
        }
    }

    public void renderGameActor(Graphics g2, long gameTime) {
        for (int i2 = this.trailPosition.length - 1; i2 > -1; --i2) {
            if (this.trailPosition[i2][0] == -1) continue;
            this.animation.drawAnimation(g2, this.animID + i2 + 1, gameTime - this.stateStartTime, this.trailPosition[i2][0], this.trailPosition[i2][1], this.animCyclic);
        }
        super.renderGameActor(g2, gameTime);
    }

    public void reduceLife(int reducePoint, int type, ColRect rc, long gametime) {
    }

    public void setState(byte newState, long time) {
        super.setState(newState, time);
        if (this.getType() == 0) {
            if (this.getState() == 0) {
                this.setRenderContent(4, true, time);
            } else if (this.getState() == 1) {
                for (int i2 = 0; i2 < this.trailPosition.length; ++i2) {
                    this.trailPosition[i2][0] = -1;
                    this.trailPosition[i2][1] = -1;
                }
                this.setRenderContent(1, false, time);
            }
        } else if (this.getType() == 1) {
            if (this.getState() == 0) {
                this.setRenderContent(8, true, time);
            } else if (this.getState() == 1) {
                this.setRenderContent(3, false, time);
            }
        } else if (this.getState() == 0) {
            this.setRenderContent(14, true, time);
        } else if (this.getState() == 1) {
            this.setRenderContent(13, false, time);
        }
    }
}

