/*
 * Decompiled with CFR 0.152.
 */
package z.playw.DragonGuardian;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import z.playw.j2me.util.PWScreenToolbox;

public class Map {
    private int tileWidth;
    private int tileHeight;
    private int tilesWide;
    private int tilesHigh;
    private int[] lgraphicSetsUsedayers;
    short[][] levelDef;
    byte[][] levelDefTrans;
    public Image mapBufferImg = null;
    public Graphics gMapBuffer = null;
    public int mapBufferWidth = 0;
    public int mapBufferHeight = 0;
    public int mapBufferOffsetX = -1;
    public int mapBufferStartX = -1;
    Image[] tileImages;
    public static final int LAYERS = 2;

    public void gainBufferFromOtherMap(Map map) {
        this.mapBufferImg = map.mapBufferImg;
        this.gMapBuffer = map.gMapBuffer;
        this.mapBufferWidth = map.mapBufferWidth;
        this.mapBufferHeight = map.mapBufferHeight;
        this.mapBufferOffsetX = -1;
        this.mapBufferStartX = -1;
    }

    public Map(int mapID) {
        this(mapID, false);
    }

    public Map(int mapID, boolean useBuffer) {
        try {
            ByteArrayInputStream bytes = new ByteArrayInputStream(PWScreenToolbox.get().getResource("level" + mapID + ".map"));
            DataInputStream dis = new DataInputStream(bytes);
            this.tilesWide = dis.readShort();
            this.tilesHigh = dis.readShort();
            this.tileWidth = dis.readByte();
            this.tileHeight = dis.readByte();
            this.lgraphicSetsUsedayers = new int[2];
            for (int i2 = 0; i2 < 2; ++i2) {
                this.lgraphicSetsUsedayers[i2] = dis.readByte();
            }
            int tilesLen = this.tilesWide * this.tilesHigh;
            this.levelDef = new short[2][tilesLen];
            this.levelDefTrans = new byte[2][tilesLen];
            for (int i3 = 0; i3 < 2; i3 = (int)((byte)(i3 + 1))) {
                for (int j2 = 0; j2 < tilesLen; ++j2) {
                    short levelInfo = dis.readShort();
                    this.levelDef[i3][j2] = (short)((levelInfo & 0xFFF) - 1);
                    this.levelDefTrans[i3][j2] = (byte)(levelInfo >> 12 & 0xF);
                }
            }
            dis.close();
            System.gc();
            this.extractTiles();
            if (useBuffer) {
                this.mapBufferWidth = (240 / this.tileWidth + 1) * this.tileWidth;
                this.mapBufferHeight = 248;
                this.mapBufferImg = Image.createImage((int)this.mapBufferWidth, (int)this.mapBufferHeight);
                this.gMapBuffer = this.mapBufferImg.getGraphics();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        try {
            Thread.sleep(30L);
        }
        catch (Exception e3) {
            // empty catch block
        }
    }

    int getTileWidth() {
        return this.tileWidth;
    }

    int getTilesWide() {
        return this.tilesWide;
    }

    int getTileHeight() {
        return this.tileHeight;
    }

    private void extractTiles() {
        this.tileImages = new Image[2];
        for (int i2 = 0; i2 < 2; ++i2) {
            this.tileImages[i2] = PWScreenToolbox.get().getImage("tileSet0" + this.lgraphicSetsUsedayers[i2] + "_" + this.tileWidth + "X" + this.tileHeight + ".png");
        }
    }

    public void drawMap(Graphics g2, int offsetX, int offsetY) {
        if (this.mapBufferImg != null) {
            offsetX *= -1;
            offsetY *= -1;
            if (this.mapBufferStartX == -1) {
                this.initBuffer(offsetX, offsetY);
            } else {
                int newTilePosX = offsetX / this.tileWidth;
                int oldTilePosX = this.mapBufferOffsetX / this.tileWidth;
                if (newTilePosX < oldTilePosX) {
                    newTilePosX += this.tilesWide;
                }
                if (oldTilePosX != newTilePosX) {
                    int startX = this.mapBufferStartX / this.tileWidth * this.tileWidth;
                    for (int i2 = oldTilePosX + 1; i2 <= newTilePosX; ++i2) {
                        int posIndex = i2 % this.tilesWide;
                        for (int j2 = 0; j2 < this.tilesHigh; ++j2) {
                            for (int k2 = 0; k2 < 2; ++k2) {
                                short info = this.levelDef[k2][j2 * this.tilesWide + posIndex];
                                int src_width = this.tileImages[k2].getWidth() / this.tileWidth;
                                if (info < 0) continue;
                                int x_src = info % src_width * this.tileWidth;
                                int y_src = info / src_width * this.tileHeight;
                                this.gMapBuffer.drawRegion(this.tileImages[k2], x_src, y_src, this.tileWidth, this.tileHeight, (int)this.levelDefTrans[k2][j2 * this.tilesWide + posIndex], startX, j2 * this.tileHeight, 0);
                            }
                        }
                        startX += this.tileWidth;
                        startX %= this.mapBufferWidth;
                    }
                }
                this.mapBufferStartX += (offsetX >= this.mapBufferOffsetX ? offsetX : offsetX + this.tileWidth * this.tilesWide) - this.mapBufferOffsetX;
                this.mapBufferStartX %= this.mapBufferWidth;
                this.mapBufferOffsetX = offsetX;
            }
            g2.drawRegion(this.mapBufferImg, this.mapBufferStartX, 0, this.mapBufferWidth - this.mapBufferStartX, this.mapBufferHeight, 0, 0, 0, 0);
            g2.drawRegion(this.mapBufferImg, 0, 0, this.mapBufferStartX, this.mapBufferHeight, 0, this.mapBufferWidth - this.mapBufferStartX, 0, 0);
        } else {
            for (int i3 = 0; i3 < this.tilesWide; ++i3) {
                for (int j3 = 0; j3 < this.tilesHigh; ++j3) {
                    int x = i3 * this.tileWidth + offsetX;
                    int y = j3 * this.tileHeight + offsetY;
                    if (x + this.tileWidth < 0 || x > 240 || y + this.tileHeight < 0 || y > 248) continue;
                    for (int k3 = 0; k3 < 2; ++k3) {
                        short info = this.levelDef[k3][j3 * this.tilesWide + i3];
                        int src_width = this.tileImages[k3].getWidth() / this.tileWidth;
                        if (info < 0) continue;
                        int x_src = info % src_width * this.tileWidth;
                        int y_src = info / src_width * this.tileHeight;
                        g2.drawRegion(this.tileImages[k3], x_src, y_src, this.tileWidth, this.tileHeight, (int)this.levelDefTrans[k3][j3 * this.tilesWide + i3], x, y, 0);
                    }
                }
            }
        }
    }

    public void initBuffer(int offsetX, int offsetY) {
        this.mapBufferStartX = 0;
        this.mapBufferOffsetX = offsetX;
        for (int i2 = 0; i2 < this.tilesWide; ++i2) {
            for (int j2 = 0; j2 < this.tilesHigh; ++j2) {
                int x = i2 * this.tileWidth + offsetX;
                int y = j2 * this.tileHeight + offsetY;
                if (x + this.tileWidth < 0 || x > this.mapBufferWidth || y + this.tileHeight < 0 || y > this.mapBufferHeight) continue;
                for (int k2 = 0; k2 < 2; ++k2) {
                    short info = this.levelDef[k2][j2 * this.tilesWide + i2];
                    int src_width = this.tileImages[k2].getWidth() / this.tileWidth;
                    if (info < 0) continue;
                    int x_src = info % src_width * this.tileWidth;
                    int y_src = info / src_width * this.tileHeight;
                    this.gMapBuffer.drawRegion(this.tileImages[k2], x_src, y_src, this.tileWidth, this.tileHeight, (int)this.levelDefTrans[k2][j2 * this.tilesWide + i2], x, y, 0);
                }
            }
        }
    }
}

