/*
 * Decompiled with CFR 0.152.
 */
package z.playw.DragonGuardian;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import z.playw.DragonGuardian.CMath;
import z.playw.DragonGuardian.Enemy;
import z.playw.DragonGuardian.GameActor;
import z.playw.DragonGuardian.GameEngine;
import z.playw.DragonGuardian.MainCanvas;

public class GameCommands {
    private static final int CMD_TIME = 0;
    private static final int CMD_CMDTYPE = 1;
    private static final int CMD_ENEMY_ID = 2;
    private static final int CMD_ENEMY_TYPE = 3;
    private static final int CMD_ENEMY_LEVEL = 4;
    private static final int CMD_SPEED = 5;
    private static final int CMD_SRC_X = 6;
    private static final int CMD_SRC_Y = 7;
    private static final int CMD_DES_X = 8;
    private static final int CMD_DES_Y = 9;
    private static final int CMD_MUST_DIE_ID_0 = 10;
    private static final int CMD_MUST_DIE_ID_1 = 11;
    private static final int CMD_MUST_DIE_ID_2 = 12;
    private static final int CMD_MUST_DIE_ID_3 = 13;
    private static final int CMD_MUST_DIE_ID_4 = 14;
    private static final int CMD_DROP_ID = 15;
    private static final int CMD_STATUS = 16;
    private static final int CMD_PARAMETER_COUNT = 17;
    private static final int ENEMY_TYPE_SWORD = 0;
    private static final int ENEMY_TYPE_MAGICIAN = 1;
    private static final int ENEMY_TYPE_CAVE_MAN = 2;
    private static final int ENEMY_TYPE_CROW = 3;
    private static final int ENEMY_TYPE_ROCK = 4;
    private static final int ENEMY_TYPE_TWO_ROCK = 5;
    private static final int ENEMY_TYPE_SPIDER = 6;
    private static final int ENEMY_TYPE_HIT_RUN_MAGICAN = 7;
    private static final int ENEMY_TYPE_CANE_UP = 8;
    private static final int ENEMY_TYPE_CANE_BUTTOM = 9;
    private static final int ENEMY_TYPE_SPIDER_II = 10;
    private static final int ENEMY_TYPE_CANNIBALPLANT = 11;
    private static final int ENEMY_TYPE_SUMMONER = 12;
    public static final int ENEMY_TYPE_CORBIE = 13;
    private static final int ENEMY_TYPE_DEMON = 14;
    private static final int ENEMY_TYPE_FIRE = 15;
    private static final int ENEMY_TYPE_GRIFFIN = 16;
    public static final int ENEMY_TYPE_SKULL = 17;
    private static final int ENEMY_TYPE_EYE = 18;
    private static final int ENEMY_TYPE_LEFT_CORBIE = 19;
    private static final int ENEMY_TYPE_MAGICIAN_ONLY_ATT_1 = 31;
    private static final int ENEMY_TYPE_MAGICIAN_ONLY_ATT_2 = 32;
    private static final int ENEMY_TYPE_MAGICIAN_ATT_WHILE_RUN_1 = 33;
    private static final int ENEMY_TYPE_MAGICIAN_ATT_WHILE_RUN_2 = 34;
    private static final int ENEMY_TYPE_NORMAL_ONLY_ATT_1 = 35;
    private static final int ENEMY_TYPE_NORMAL_ONLY_ATT_2 = 36;
    private static final int ENEMY_TYPE_NORMAL_ATT_WHILE_RUN_1 = 37;
    private static final int ENEMY_TYPE_NORMAL_ATT_WHILE_RUN_2 = 38;
    private static final int ENEMY_TYPE_NORMAL_ONLY_FAR_ATT = 39;
    private static final int ENEMY_TYPE_NORMAL_NO_FIRST_FAR = 40;
    private static final int ENEMY_TYPE_CORBIE_ATT_WHILE_RUN_1 = 41;
    private static final int ENEMY_TYPE_CORBIE_ATT_WHILE_RUN_2 = 42;
    private static final int ENEMY_TYPE_CAVE_MAN_SPRINT = 43;
    private static final int ENEMY_TYPE__DEMON2 = 44;
    private static final int ENEMY_TYPE__DEMON3 = 45;
    private static final int ENEMY_TYPE_CAVE_MAN_ONLY_ATT_1 = 46;
    private static final int ENEMY_TYPE_CAVE_MAN_ONLY_ATT_2 = 47;
    private static final int ENEMY_TYPE_CAVE_MAN_ATT_WHILE_RUN_1 = 48;
    private static final int ENEMY_TYPE_CAVE_MAN_ATT_WHILE_RUN_2 = 49;
    private static final int ENEMY_TYPE_CAVE_MAN_ONLY_FAR_ATT = 50;
    private static final int ENEMY_TYPE_CAVE_MAN_NO_FIRST_FAR = 51;
    private static final int ENEMY_TYPE__DEMON4 = 52;
    private static final int ENEMY_TYPE_FAR_ATT_GRIFFIN = 53;
    private static final int ENEMY_TYPE_NO_FIRST_FAR_ATT_GRIFFIN = 54;
    private static final int ENEMY_TYPE_FAR_ATT_SKULL = 55;
    private static final int ENEMY_TYPE_NO_FIRST_FAR_ATT_SKULL = 56;
    private static final int ENEMY_TYPE_CORBIE_ATT_WHILE_RUN_1_LEFT = 57;
    private static final int ENEMY_TYPE_EYE_ONLY_FAR = 58;
    private static final int ENEMY_TYPE_EYE_ONLY_FAR2 = 59;
    private static final int ENEMY_TYPE_BOSS_THREEHEAD = 20;
    private static final int ENEMY_TYPE_BOSS_FIRELORD = 21;
    private static final int ENEMY_TYPE_BOSS_CYCLOPS = 22;
    private static final int ENEMY_TYPE_BOSS_DRACULA = 23;
    public static final int ENEMY_TYPE_BOSS_SWORD = 24;
    private static final int ENEMY_TYPE_BOSS_GENERAL = 25;
    private static final int ENEMY_TYPE_BOSS_KING = 26;
    private static final int ENEMY_TYPE_BOSS_GENERAL1 = 27;
    private static final int ENEMY_TYPE_BOSS_GENERAL2 = 28;
    private static final int CMD_TYPE_ADD_ENEMY = 0;
    private static final int CMD_TYPE_WAIT_KILLED_ALL_ENEMY = 1;
    private static final int CMD_TYPE_CHANGE_BG_SCROLL_SPEED = 2;
    private static final int CMD_TYPE_SET_ENEMY_RETREAT = 3;
    private static final int CMD_TYPE_CHANGE_BG = 4;
    private static final int CMD_TYPE_LEVEL_FINISHED = 5;
    private static final int CMD_TYPE_DIALOG = 6;
    private static final int CMD_NOT_PROCESS = 0;
    private static final int CMD_PROCESSED = 1;
    private static final int CMD_HOLD = 2;
    private static final int CMD_SHOULD_BE_STOP_PROCESSING = 3;
    public static GameActor commandInfo;
    private long totalTime = 0L;
    private int curIndex = 0;
    private short[][] commands;

    public void loadCommands(byte[] data) {
        try {
            this.totalTime = 0L;
            this.curIndex = 0;
            ByteArrayInputStream bais = new ByteArrayInputStream(data, 0, data.length);
            DataInputStream dis = new DataInputStream(bais);
            int length = dis.readShort();
            this.commands = new short[length][];
            for (int i2 = 0; i2 < length; ++i2) {
                this.commands[i2] = new short[17];
                for (int j2 = 0; j2 < 16; ++j2) {
                    this.commands[i2][j2] = dis.readShort();
                }
                this.commands[i2][16] = 0;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void unloadCommand() {
        if (this.commands != null) {
            for (int i2 = 0; i2 < this.commands.length; ++i2) {
                this.commands[i2] = null;
            }
            this.commands = null;
        }
    }

    private GameActor getAnActor(GameActor[] actorPool) {
        for (int i2 = 0; i2 < actorPool.length; ++i2) {
            if (actorPool[i2] != null && actorPool[i2].inUse()) continue;
            if (actorPool[i2] == null) {
                actorPool[i2] = new Enemy();
            }
            return actorPool[i2];
        }
        return null;
    }

    public void process(long curFrameTime, long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (MainCanvas.getGameEngine().isShakeScreen() || MainCanvas.getGameEngine().isDarkScreen() || MainCanvas.getGameEngine().isLightScreen() || MainCanvas.getGameEngine().isLightScreenOverlapEnemy() || MainCanvas.getGameEngine().getPlayer().isStopProcessing() || MainCanvas.getGameEngine().getPlayer().isPlayerDead() || MainCanvas.getGameEngine().isStopScrollBG()) {
            return;
        }
        this.totalTime += curFrameTime;
        if (this.commands != null) {
            for (int i2 = this.curIndex; i2 < this.commands.length; ++i2) {
                long curTime = this.totalTime / 1000L;
                if (this.commands[i2][16] == 1) {
                    if (this.curIndex != i2) continue;
                    ++this.curIndex;
                    continue;
                }
                if ((long)this.commands[i2][0] > curTime && this.commands[i2][1] != 1) continue;
                int cmdStatus = 0;
                switch (this.commands[i2][1]) {
                    case 0: {
                        cmdStatus = this.processAddEnemyCommand(gameTime, actorPool, gameEngine, i2);
                        break;
                    }
                    case 1: {
                        cmdStatus = this.processWaitKilledAllEnemyCommand(gameTime, actorPool, gameEngine, i2);
                        break;
                    }
                    case 2: {
                        cmdStatus = this.processChangeBGScrollSpeedCommand(gameTime, actorPool, gameEngine, i2);
                        break;
                    }
                    case 3: {
                        cmdStatus = this.processSetEnemyRetreatCommand(gameTime, actorPool, gameEngine, i2);
                        break;
                    }
                    case 4: {
                        this.commands[i2][16] = 1;
                        cmdStatus = 1;
                        break;
                    }
                    case 5: {
                        if (this.checkMustDieIDs(actorPool, i2) == 2) {
                            cmdStatus = 2;
                            break;
                        }
                        MainCanvas.getGameEngine().setLevelFinished(true);
                        this.commands[i2][16] = 1;
                        cmdStatus = 1;
                        break;
                    }
                    default: {
                        System.out.println("unknown command!!!!!!!!!!!!!!!!!!");
                    }
                }
                if (cmdStatus == 3) break;
            }
        }
    }

    private int processChangeBGScrollSpeedCommand(long gameTime, GameActor[] actorPool, GameEngine gameEngine, int cmdIndex) {
        if (this.checkMustDieIDs(actorPool, cmdIndex) == 2) {
            return 2;
        }
        gameEngine.setXPifBGOffsetSpeed(CMath.I2F(this.commands[cmdIndex][6]) >> 1);
        gameEngine.setXMapFrontOffsetSpeed(CMath.I2F(this.commands[cmdIndex][7]) >> 1);
        gameEngine.setXMapBackOffsetSpeed(CMath.I2F(this.commands[cmdIndex][8]) >> 1);
        this.commands[cmdIndex][16] = 1;
        return 1;
    }

    private int processSetEnemyRetreatCommand(long gameTime, GameActor[] actorPool, GameEngine gameEngine, int cmdIndex) {
        for (int i2 = 0; i2 < actorPool.length; ++i2) {
            if (actorPool[i2] == null || !actorPool[i2].inUse() || actorPool[i2].getType() != 1 || actorPool[i2].GetInstanceId() == -1 || actorPool[i2].GetInstanceId() != this.commands[cmdIndex][10] && actorPool[i2].GetInstanceId() != this.commands[cmdIndex][11] && actorPool[i2].GetInstanceId() != this.commands[cmdIndex][12] && actorPool[i2].GetInstanceId() != this.commands[cmdIndex][13] && actorPool[i2].GetInstanceId() != this.commands[cmdIndex][14]) continue;
            ((Enemy)actorPool[i2]).setRetreat(gameTime, this.commands[cmdIndex][8] * 320 / 100, 36 + this.commands[cmdIndex][9] * 204 / 100);
        }
        this.commands[cmdIndex][16] = 1;
        return 1;
    }

    private int processWaitKilledAllEnemyCommand(long gameTime, GameActor[] actorPool, GameEngine gameEngine, int cmdIndex) {
        if ((long)this.commands[cmdIndex][0] >= this.totalTime / 1000L) {
            return 3;
        }
        for (int i2 = 0; i2 < actorPool.length; ++i2) {
            if (actorPool[i2] == null || !actorPool[i2].inUse() || actorPool[i2].getType() != 1 || actorPool[i2].getSubType() == 12 || actorPool[i2].getSubType() == 7 || actorPool[i2].getSubType() == 31 || actorPool[i2].getSubType() == 47) continue;
            return 3;
        }
        this.commands[cmdIndex][16] = 1;
        this.totalTime = 0L;
        return 1;
    }

    private int processAddEnemyCommand(long gameTime, GameActor[] actorPool, GameEngine gameEngine, int cmdIndex) {
        if (this.checkMustDieIDs(actorPool, cmdIndex) == 2) {
            return 2;
        }
        Enemy enemy = (Enemy)this.getAnActor(actorPool);
        if (enemy == null) {
            return 0;
        }
        switch (this.commands[cmdIndex][3]) {
            case 13: {
                enemy.setAnimation(gameEngine.enemy04Pif);
                enemy.setSubType(24);
                break;
            }
            case 14: {
                enemy.setAnimation(gameEngine.enemy04Pif);
                enemy.setSubType(25);
                break;
            }
            case 44: {
                enemy.setAnimation(gameEngine.enemy04Pif);
                enemy.setSubType(28);
                break;
            }
            case 45: {
                enemy.setAnimation(gameEngine.enemy04Pif);
                enemy.setSubType(29);
                break;
            }
            case 52: {
                enemy.setAnimation(gameEngine.enemy04Pif);
                enemy.setSubType(30);
                break;
            }
            case 43: {
                enemy.setAnimation(gameEngine.enemy03Pif);
                enemy.setSubType(27);
                break;
            }
            case 41: {
                enemy.setAnimation(gameEngine.enemy04Pif);
                enemy.setSubType(16);
                break;
            }
            case 57: {
                enemy.setAnimation(gameEngine.enemy04_1Pif);
                enemy.setSubType(16);
                break;
            }
            case 19: {
                enemy.setAnimation(gameEngine.enemy04_1Pif);
                enemy.setSubType(24);
                break;
            }
            case 18: {
                enemy.setAnimation(gameEngine.enemy10Pif);
                enemy.setSubType(38);
                break;
            }
            case 58: {
                enemy.setAnimation(gameEngine.enemy10Pif);
                enemy.setSubType(40);
                break;
            }
            case 59: {
                enemy.setAnimation(gameEngine.enemy10Pif);
                enemy.setSubType(41);
                break;
            }
            case 17: {
                enemy.setAnimation(gameEngine.enemy09Pif);
                enemy.setSubType(35);
                break;
            }
            case 55: {
                enemy.setAnimation(gameEngine.enemy09Pif);
                enemy.setSubType(36);
                break;
            }
            case 56: {
                enemy.setAnimation(gameEngine.enemy09Pif);
                enemy.setSubType(37);
                break;
            }
            case 16: {
                enemy.setAnimation(gameEngine.enemy12Pif);
                enemy.setSubType(23);
                break;
            }
            case 53: {
                enemy.setAnimation(gameEngine.enemy12Pif);
                enemy.setSubType(33);
                break;
            }
            case 54: {
                enemy.setAnimation(gameEngine.enemy12Pif);
                enemy.setSubType(34);
                break;
            }
            case 12: {
                enemy.setAnimation(gameEngine.enemy08Pif);
                enemy.setSubType(2);
                break;
            }
            case 0: {
                enemy.setAnimation(gameEngine.enemy01Pif);
                enemy.setSubType(0);
                break;
            }
            case 37: {
                enemy.setAnimation(gameEngine.enemy01Pif);
                enemy.setSubType(20);
                break;
            }
            case 38: {
                enemy.setAnimation(gameEngine.enemy01Pif);
                enemy.setSubType(21);
                break;
            }
            case 39: {
                enemy.setAnimation(gameEngine.enemy01Pif);
                enemy.setSubType(13);
                break;
            }
            case 35: {
                enemy.setAnimation(gameEngine.enemy01Pif);
                enemy.setSubType(18);
                break;
            }
            case 36: {
                enemy.setAnimation(gameEngine.enemy01Pif);
                enemy.setSubType(19);
                break;
            }
            case 40: {
                enemy.setAnimation(gameEngine.enemy01Pif);
                enemy.setSubType(22);
                break;
            }
            case 48: {
                enemy.setAnimation(gameEngine.enemy03Pif);
                enemy.setSubType(20);
                break;
            }
            case 49: {
                enemy.setAnimation(gameEngine.enemy03Pif);
                enemy.setSubType(21);
                break;
            }
            case 50: {
                enemy.setAnimation(gameEngine.enemy03Pif);
                enemy.setSubType(13);
                break;
            }
            case 46: {
                enemy.setAnimation(gameEngine.enemy03Pif);
                enemy.setSubType(18);
                break;
            }
            case 47: {
                enemy.setAnimation(gameEngine.enemy03Pif);
                enemy.setSubType(19);
                break;
            }
            case 51: {
                enemy.setAnimation(gameEngine.enemy03Pif);
                enemy.setSubType(22);
                break;
            }
            case 1: {
                enemy.setAnimation(gameEngine.enemy02Pif);
                enemy.setSubType(1);
                break;
            }
            case 31: {
                enemy.setAnimation(gameEngine.enemy02Pif);
                enemy.setSubType(14);
                break;
            }
            case 33: {
                enemy.setAnimation(gameEngine.enemy02Pif);
                enemy.setSubType(16);
                break;
            }
            case 34: {
                enemy.setAnimation(gameEngine.enemy02Pif);
                enemy.setSubType(17);
                break;
            }
            case 32: {
                enemy.setAnimation(gameEngine.enemy02Pif);
                enemy.setSubType(15);
                break;
            }
            case 7: {
                enemy.setAnimation(gameEngine.enemy02Pif);
                enemy.setSubType(8);
                break;
            }
            case 2: {
                enemy.setAnimation(gameEngine.enemy03Pif);
                enemy.setSubType(0);
                break;
            }
            case 3: {
                enemy.setAnimation(gameEngine.enemy04Pif);
                enemy.setSubType(1);
                break;
            }
            case 20: {
                enemy.setAnimation(gameEngine.boss01Pif);
                enemy.setSubType(4);
                break;
            }
            case 21: {
                enemy.setAnimation(gameEngine.bossFireLordPif);
                enemy.setSubType(3);
                break;
            }
            case 24: {
                enemy.setAnimation(gameEngine.bossSwordPif);
                enemy.setSubType(42);
                break;
            }
            case 25: {
                enemy.setAnimation(gameEngine.bossGeneralPif);
                enemy.setSubType(39);
                break;
            }
            case 27: {
                enemy.setAnimation(gameEngine.bossGeneralPif);
                enemy.setSubType(45);
                break;
            }
            case 28: {
                enemy.setAnimation(gameEngine.bossGeneralPif);
                enemy.setSubType(46);
                break;
            }
            case 26: {
                enemy.setAnimation(gameEngine.bossKingPif);
                enemy.setSubType(43);
                break;
            }
            case 22: {
                enemy.setAnimation(gameEngine.bossCyclops);
                enemy.setSubType(26);
                break;
            }
            case 23: {
                enemy.setAnimation(gameEngine.bossDracula);
                enemy.setSubType(32);
                break;
            }
            case 4: {
                enemy.setAnimation(gameEngine.warningPif);
                enemy.setSubType(5);
                break;
            }
            case 15: {
                enemy.setAnimation(gameEngine.bossBullet01Pif);
                enemy.setSubType(31);
                break;
            }
            case 5: {
                commandInfo = null;
                enemy.setAnimation(gameEngine.warningPif);
                enemy.setSubType(6);
                enemy.init(gameTime, 1);
                enemy.SetInstanceId(this.commands[cmdIndex][2]);
                enemy.setStartEndPos(this.commands[cmdIndex][6], this.commands[cmdIndex][7], this.commands[cmdIndex][8], this.commands[cmdIndex][9], this.commands[cmdIndex][5]);
                commandInfo = enemy;
                enemy = (Enemy)this.getAnActor(actorPool);
                if (enemy == null) {
                    return 0;
                }
                enemy.setAnimation(gameEngine.warningPif);
                enemy.setSubType(6);
                break;
            }
            case 6: {
                enemy.setAnimation(gameEngine.enemy05Pif);
                enemy.setSubType(7);
                break;
            }
            case 10: {
                enemy.setAnimation(gameEngine.enemy05Pif);
                enemy.setSubType(11);
                break;
            }
            case 8: {
                enemy.setAnimation(gameEngine.enemy06Pif);
                enemy.setSubType(9);
                break;
            }
            case 9: {
                enemy.setAnimation(gameEngine.enemy06Pif);
                enemy.setSubType(10);
                break;
            }
            case 11: {
                enemy.setAnimation(gameEngine.enemy07Pif);
                enemy.setSubType(12);
            }
        }
        enemy.init(gameTime, 1);
        enemy.SetInstanceId(this.commands[cmdIndex][2]);
        enemy.setStartEndPos(this.commands[cmdIndex][6], this.commands[cmdIndex][7], this.commands[cmdIndex][8], this.commands[cmdIndex][9], this.commands[cmdIndex][5]);
        enemy.findAttribute(this.commands[cmdIndex][3], this.commands[cmdIndex][4]);
        enemy.setDropID(this.commands[cmdIndex][15]);
        this.commands[cmdIndex][16] = 1;
        return 1;
    }

    private int checkMustDieIDs(GameActor[] actorPool, int cmdIndex) {
        for (int i2 = 0; i2 < actorPool.length; ++i2) {
            if (actorPool[i2] == null || !actorPool[i2].inUse() || actorPool[i2].getType() != 1) continue;
            for (int j2 = 10; j2 <= 14; ++j2) {
                if (actorPool[i2].GetInstanceId() != this.commands[cmdIndex][j2] || this.commands[cmdIndex][j2] == -1) continue;
                this.commands[cmdIndex][16] = 2;
                return 2;
            }
        }
        return 0;
    }
}

