/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;

abstract class Tank
extends Sprite {
    protected int speed;
    public static final int WIDTH = 16;
    public static final int HEIGHT = 16;
    private static final Image TANKS_IMAGE = BattleTankMIDlet.createImage("/Objects.png");
    private final int[][] animation = this.getAnimation();
    static final int POOL_SIZE = 4;
    private static Tank[] TANK_POOL = new Tank[4];
    private static int enemiesToSpawn;
    private static String enemyString;
    protected int pool_pos;
    protected boolean isAlive = true;
    protected boolean isShooting = false;
    protected int direction = 0;
    protected int animationTick;
    protected static int[] spawnPoints;
    protected static int numSpawns;
    protected static Random rand;
    private int spawningTicks = 0;
    static Battleground battleground;
    private static int immobilizedTicks;
    private static int enemiesSpawned;
    protected static LayerManager layerManager;

    static void addSpawnPoint(int n, int n2) {
        if (numSpawns < 8) {
            Tank.spawnPoints[Tank.numSpawns - 1] = n2 * 13 + n;
            ++numSpawns;
        }
    }

    Tank() {
        super(TANKS_IMAGE, 16, 16);
        this.defineReferencePixel(8, 8);
    }

    public void tick() {
        if (!this.isVisible()) {
            return;
        }
        ++this.animationTick;
        if (this.spawningTicks > 0) {
            this.nextFrame();
            --this.spawningTicks;
            return;
        }
    }

    void drive() {
        switch (this.direction) {
            case 0: {
                if (this.getY() <= 0 || battleground.containsImpassableArea(this.getX(), this.getY() - this.speed, this.getWidth(), this.speed)) break;
                this.tryMove(0, -this.speed);
                break;
            }
            case 1: {
                if (this.getX() >= battleground.getWidth() - this.getWidth() || battleground.containsImpassableArea(this.getX() + this.getWidth(), this.getY(), this.speed, this.getHeight())) break;
                this.tryMove(this.speed, 0);
                break;
            }
            case 2: {
                if (this.getY() >= battleground.getHeight() - this.getHeight() || battleground.containsImpassableArea(this.getX(), this.getY() + this.getHeight(), this.getWidth(), this.speed)) break;
                this.tryMove(0, this.speed);
                break;
            }
            case 3: {
                if (this.getX() <= 0 || battleground.containsImpassableArea(this.getX() - this.speed, this.getY(), this.speed, this.getHeight())) break;
                this.tryMove(-this.speed, 0);
            }
        }
    }

    void tryMove(int n, int n2) {
        this.move(n, n2);
        if (Tank.overlapsTank(this)) {
            this.move(-n, -n2);
        }
    }

    public void changeDirection(int n) {
        if (n == this.direction) {
            return;
        }
        if (n == -1) {
            return;
        }
        this.direction = n;
        if (n == 0 || n == 2) {
            this.setPosition(this.getX() + 2 & 0xFFFFFFF8, this.getY());
        } else {
            this.setPosition(this.getX(), this.getY() + 2 & 0xFFFFFFF8);
        }
        this.setFrame(this.animation[n][0]);
    }

    static void appendToLayerManager(LayerManager layerManager) {
        Tank.layerManager = layerManager;
    }

    private static void reappendToLayerManager() {
        if (layerManager == null) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            layerManager.append((Layer)TANK_POOL[i]);
        }
    }

    static void tickEnemies() {
        if (immobilizedTicks > 0) {
            --immobilizedTicks;
            return;
        }
        for (int i = 1; i < 4; ++i) {
            if (TANK_POOL[i] == null) continue;
            ((EnemyTank)TANK_POOL[i]).tick();
        }
    }

    static boolean overlapsTank(Sprite sprite) {
        for (int i = 0; i < 4; ++i) {
            if (TANK_POOL[i] == null || sprite == TANK_POOL[i] || !sprite.collidesWith((Sprite)TANK_POOL[i], false)) continue;
            return true;
        }
        return false;
    }

    static HeroTank getHero() {
        return (HeroTank)TANK_POOL[0];
    }

    static EnemyTank getEnemy(int n) {
        if (TANK_POOL[n] != null) {
            return (EnemyTank)TANK_POOL[n];
        }
        return null;
    }

    protected void explode() {
        Explosion.explode(this.getRefPixelX(), this.getRefPixelY(), 1);
        this.setVisible(false);
        layerManager.remove((Layer)this);
    }

    protected abstract int[][] getAnimation();

    public abstract void shoot();

    public abstract void hit();

    public void doneExploding() {
    }

    public static void immobilizeEnemies() {
        immobilizedTicks = 100;
    }

    public static void explodeAllEmenies() {
        for (int i = 1; i < 4; ++i) {
            Tank tank = TANK_POOL[i];
            if (!tank.isVisible()) continue;
            tank.explode();
        }
    }

    public static void removeAllEnemies() {
        for (int i = 1; i < 4; ++i) {
            if (TANK_POOL[i] == null) continue;
            layerManager.remove((Layer)TANK_POOL[i]);
        }
    }

    public static void initEnemyPool(String string) {
        enemiesToSpawn = string.length();
        enemyString = string;
    }

    public static void spawnNextEnemy(int n) {
        if (enemiesSpawned < enemiesToSpawn) {
            boolean bl = false;
            Tank tank = TankFactory.createTank(enemyString.charAt(enemiesSpawned++));
            for (int i = 20; !bl && i > 0; --i) {
                int n2 = spawnPoints[rand.nextInt(numSpawns)];
                int n3 = n2 % 13 * 16;
                int n4 = n2 / 13 * 16;
                tank.setPosition(n3, n4);
                tank.setVisible(true);
                if (!Tank.overlapsTank(tank)) {
                    bl = true;
                    tank.changeDirection(2);
                    tank.spawn();
                    continue;
                }
                System.out.println("tank overlapped, trying to place again");
            }
            if (bl) {
                tank.pool_pos = n;
                Tank.TANK_POOL[n] = tank;
                layerManager.append((Layer)tank);
            }
        } else {
            System.out.println("enemies all spawned...");
            for (int i = 1; i < 4; ++i) {
                if (!TANK_POOL[i].isVisible()) continue;
                return;
            }
            enemiesSpawned = 0;
            BattleTankMIDlet.nextLevel();
        }
    }

    public void spawn() {
        this.setVisible(true);
    }

    public static void spawnHero() {
        Tank.getHero().spawn();
        layerManager.append((Layer)Tank.getHero());
    }

    public static void restart() {
        Tank.removeAllEnemies();
        enemiesSpawned = 0;
        TANK_POOL = new Tank[4];
        Tank.TANK_POOL[0] = new HeroTank();
        Tank.initEnemyPool("");
    }

    static {
        Tank.TANK_POOL[0] = new HeroTank();
        Tank.initEnemyPool("");
        spawnPoints = new int[8];
        numSpawns = 1;
        rand = new Random();
        immobilizedTicks = 0;
    }
}

