/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;

class Bullet
extends Sprite {
    public static final int WIDTH = 3;
    public static final int HEIGHT = 5;
    public static final int SLOW = 6;
    public static final int FAST = 8;
    private static final Image BULLET_IMAGE = BattleTankMIDlet.createImage("/Bullet.png");
    private static final int POOL_SIZE = 10;
    private final int id;
    private int dx;
    private int dy;
    private int strength;
    private boolean friendly;
    static Battleground battleground;
    private static Bullet[] BULLET_POOL;

    Bullet(int n) {
        super(BULLET_IMAGE, 3, 5);
        this.id = n;
        this.defineReferencePixel(1, 0);
        this.setVisible(false);
    }

    static Bullet shoot(int n, int n2, int n3, int n4, boolean bl, int n5) {
        Bullet bullet = null;
        for (int i = 0; i < 10; ++i) {
            if (BULLET_POOL[i].isVisible()) continue;
            bullet = BULLET_POOL[i];
            break;
        }
        if (bullet == null) {
            return null;
        }
        bullet.friendly = bl;
        bullet.strength = n5;
        switch (n3) {
            case 0: {
                bullet.dx = 0;
                bullet.dy = -n4;
                bullet.setTransform(0);
                break;
            }
            case 1: {
                bullet.dx = n4;
                bullet.dy = 0;
                bullet.setTransform(5);
                break;
            }
            case 2: {
                bullet.dx = 0;
                bullet.dy = n4;
                bullet.setTransform(3);
                break;
            }
            case 3: {
                bullet.dx = -n4;
                bullet.dy = 0;
                bullet.setTransform(6);
            }
        }
        bullet.setRefPixelPosition(n, n2);
        bullet.setVisible(true);
        return bullet;
    }

    static void appendToLayerManager(LayerManager layerManager) {
        for (int i = 0; i < 10; ++i) {
            layerManager.append((Layer)BULLET_POOL[i]);
        }
    }

    static void tickBullets() {
        for (int i = 0; i < 10; ++i) {
            BULLET_POOL[i].tick();
        }
    }

    void tick() {
        int n;
        if (!this.isVisible()) {
            return;
        }
        this.move(this.dx, this.dy);
        int n2 = this.getRefPixelX();
        int n3 = this.getRefPixelY();
        if (n2 < 0 || n2 >= battleground.getWidth() || n3 < 0 || n3 >= battleground.getHeight()) {
            this.explode();
            return;
        }
        if (this.friendly) {
            for (n = 1; n < 4; ++n) {
                EnemyTank enemyTank = Tank.getEnemy(n);
                if (enemyTank == null || !this.collidesWith(enemyTank, false)) continue;
                enemyTank.hit();
                this.explode();
                return;
            }
        } else {
            HeroTank heroTank = Tank.getHero();
            if (this.collidesWith(heroTank, false)) {
                heroTank.hit();
                this.explode();
                return;
            }
        }
        if (battleground.hitWall(n2, n3, this.strength)) {
            this.explode();
            return;
        }
        for (n = this.id + 1; n < 10; ++n) {
            if (!this.collidesWith(BULLET_POOL[n], false)) continue;
            this.explode();
            BULLET_POOL[n].explode();
            return;
        }
    }

    void explode() {
        this.setVisible(false);
        Explosion.explode(this.getRefPixelX(), this.getRefPixelY(), 0);
    }

    public static void stopAllBullets() {
        for (int i = 0; i < 10; ++i) {
            BULLET_POOL[i].setVisible(false);
        }
    }

    static {
        BULLET_POOL = new Bullet[10];
        for (int i = 0; i < 10; ++i) {
            Bullet.BULLET_POOL[i] = new Bullet(i);
        }
    }
}

