/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.midlet.MIDlet;

class BattlegroundScreen
extends Canvas
implements Runnable,
CommandListener {
    public static final int NONE = -1;
    public static final int NORTH = 0;
    public static final int EAST = 1;
    public static final int SOUTH = 2;
    public static final int WEST = 3;
    private static final int MILLIS_PER_TICK = 100;
    private final BattleTankMIDlet midlet;
    private final Battleground battleground;
    private HeroTank hero;
    private final LayerManager layerManager;
    private static final Font bigBoldFont = Font.getFont((int)0, (int)1, (int)16);
    private volatile Thread animationThread = null;
    private int direction = -1;
    private boolean shoot = false;
    private boolean gameOver = false;
    private int countdown = 10;
    private boolean levelSplash = false;
    private int currentLevel = 0;
    private int liveenemies = 0;
    private TouchScreen touchscreen;
    boolean bFirstTime = true;
    private Command help;
    long timeTaken = 0L;

    BattlegroundScreen(BattleTankMIDlet battleTankMIDlet) {
        this.midlet = battleTankMIDlet;
        this.layerManager = new LayerManager();
        Tank.battleground = this.battleground = new Battleground();
        Bullet.battleground = this.battleground;
        Explosion.appendToLayerManager(this.layerManager);
        Bullet.appendToLayerManager(this.layerManager);
        this.layerManager.append((Layer)this.battleground);
        Tank.appendToLayerManager(this.layerManager);
        this.hero = Tank.getHero();
        this.nextLevel();
        this.help = new Command("Help", 8, 3);
        this.addCommand(new Command("About", 5, 1));
        this.addCommand(new Command("Exit", 7, 2));
        this.addCommand(this.help);
        this.setCommandListener(this);
        this.touchscreen = new TouchScreen((Displayable)this);
    }

    void nextLevel() {
        this.readLevel(++this.currentLevel);
        Bullet.stopAllBullets();
        Explosion.stopAllExplosions();
        Tank.spawnHero();
        for (int i = 1; i < 4; ++i) {
            Tank.spawnNextEnemy(i);
        }
        this.levelSplash = true;
        this.countdown = 10;
    }

    private boolean readLevel(int n) {
        if (n > 0) {
            InputStream inputStream = null;
            try {
                inputStream = this.getClass().getResourceAsStream(n + ".txt");
                if (inputStream == null) {
                    System.out.println("Could not find the game board for level " + n);
                    return false;
                }
                this.battleground.read(inputStream, n);
                inputStream.close();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    public synchronized void start() {
        this.animationThread = new Thread(this);
        this.animationThread.start();
    }

    public synchronized void stop() {
        this.animationThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Thread thread = Thread.currentThread();
        try {
            while (thread == this.animationThread) {
                long l = System.currentTimeMillis();
                if (this.isShown()) {
                    this.tick();
                    this.repaint();
                }
                this.timeTaken = (System.currentTimeMillis() - l) / 100L;
                if (this.timeTaken < 100L) {
                    BattlegroundScreen battlegroundScreen = this;
                    synchronized (battlegroundScreen) {
                        if (100L > this.timeTaken) {
                            this.wait(100L - this.timeTaken);
                            this.timeTaken = System.currentTimeMillis() - l;
                        }
                        continue;
                    }
                }
                Thread.yield();
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void tick() {
        if (!this.gameOver && !this.levelSplash) {
            this.hero.getUserInput(this.direction, this.shoot);
            this.hero.tick();
        } else {
            --this.countdown;
        }
        if (!this.levelSplash) {
            Explosion.tickExplosions();
            Bullet.tickBullets();
            Tank.tickEnemies();
            this.battleground.tick();
        }
    }

    public void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Graphics graphics2 = graphics;
        graphics2.setColor(0);
        graphics2.fillRect(0, 0, n, n2);
        int n3 = this.origin(this.hero.getX() + this.hero.getWidth() / 2, this.battleground.getWidth(), n);
        int n4 = this.origin(this.hero.getY() + this.hero.getHeight() / 2, this.battleground.getHeight(), n2);
        graphics2.setClip(n3, n4, this.battleground.getWidth(), this.battleground.getHeight());
        graphics2.translate(n3, n4);
        this.layerManager.paint(graphics2, 0, 0);
        graphics2.translate(-n3, -n4);
        graphics2.setClip(0, 0, n, n2);
        graphics2.setColor(0xFFFFFF);
        graphics2.drawString(Integer.toString(this.hero.score), this.getWidth() - 2, 1, 24);
        this.drawGameOver(graphics2);
        if (this.hasPointerEvents()) {
            this.touchscreen.draw(graphics2);
        }
    }

    private void drawFPS(Graphics graphics) {
        if (this.timeTaken == 0L) {
            this.timeTaken = 1L;
        }
        graphics.drawString(Long.toString(1000L / this.timeTaken) + "SPF", this.getWidth() - 2, 1, 24);
    }

    private void drawGameOver(Graphics graphics) {
        if (this.gameOver) {
            graphics.setFont(bigBoldFont);
            int n = this.getWidth() / 2;
            int n2 = this.getHeight() / 2;
            int n3 = graphics.getFont().getHeight();
            graphics.drawString("GAME OVER", n - 1, n2 - 1, 65);
            graphics.drawString("GAME OVER", n + 1, n2 - 1, 65);
            graphics.drawString("GAME OVER", n - 1, n2 + 1, 65);
            graphics.drawString("GAME OVER", n + 1, n2 + 1, 65);
            graphics.drawString("Press 5 To Continue", n - 1, n2 + n3 * 3 - 1, 65);
            graphics.drawString("Press 5 To Continue", n + 1, n2 + n3 * 3 - 1, 65);
            graphics.drawString("Press 5 To Continue", n - 1, n2 + n3 * 3 + 1, 65);
            graphics.drawString("Press 5 To Continue", n + 1, n2 + n3 * 3 + 1, 65);
            graphics.setColor(0xFF0000);
            graphics.drawString("GAME OVER", n, n2, 65);
            graphics.drawString("Press 5 To Continue", n, n2 + n3 * 3, 65);
            graphics.setFont(Font.getDefaultFont());
        } else if (this.levelSplash) {
            graphics.setFont(bigBoldFont);
            int n = this.getWidth() / 2;
            int n4 = this.getHeight() / 2;
            int n5 = graphics.getFont().getHeight();
            String string = "LEVEL " + this.currentLevel;
            graphics.drawString(string, n - 1, n4 - 1, 65);
            graphics.drawString(string, n + 1, n4 - 1, 65);
            graphics.drawString(string, n - 1, n4 + 1, 65);
            graphics.drawString(string, n + 1, n4 + 1, 65);
            graphics.setColor(255);
            graphics.drawString(string, n, n4, 65);
        } else {
            graphics.setColor(0xFFFFFF);
            graphics.drawString(String.valueOf(this.hero.livesLeft), 0, 0, 20);
        }
    }

    private int origin(int n, int n2, int n3) {
        int n4 = n3 >= n2 ? (n3 - n2) / 2 : (n <= n3 / 2 ? 0 : (n >= n2 - n3 / 2 ? n3 - n2 : n3 / 2 - n));
        return n4;
    }

    protected void pointerReleased(int n, int n2) {
        this.direction = -1;
        this.shoot = false;
    }

    protected void pointerPressed(int n, int n2) {
        int n3 = this.touchscreen.input(n, n2);
        if (this.levelSplash && this.countdown < 0) {
            this.levelSplash = false;
            return;
        }
        if (n3 == 0) {
            this.direction = 0;
            return;
        }
        if (n3 == 1) {
            this.direction = 1;
            return;
        }
        if (n3 == 3) {
            this.direction = 3;
            return;
        }
        if (n3 == 2) {
            this.direction = 2;
            return;
        }
        if (n3 == 5) {
            this.shoot = true;
            return;
        }
        if (n3 == 4) {
            this.midlet.exitRequested();
            return;
        }
    }

    protected void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        if (this.levelSplash && this.countdown < 0) {
            this.levelSplash = false;
            return;
        }
        if (this.gameOver && this.countdown < 0) {
            this.restartGame();
            return;
        }
        if (n2 == 1) {
            this.direction = 0;
        } else if (n2 == 5) {
            this.direction = 1;
        } else if (n2 == 2) {
            this.direction = 3;
        } else if (n2 == 6) {
            this.direction = 2;
        } else if (n2 == 8 || n2 == 9 || n2 == 10 || n2 == 11 || n2 == 12) {
            this.shoot = true;
        } else if (n == -8) {
            this.midlet.exitRequested();
        }
    }

    protected void keyReleased(int n) {
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 1: {
                if (this.direction == 0) {
                    this.direction = -1;
                    break;
                }
            }
            case 6: {
                if (this.direction == 2) {
                    this.direction = -1;
                    break;
                }
            }
            case 2: {
                if (this.direction == 3) {
                    this.direction = -1;
                    break;
                }
            }
            case 5: {
                if (this.direction == 1) {
                    this.direction = -1;
                    break;
                }
            }
            case 8: {
                this.shoot = false;
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        Alert alert;
        String string;
        if (command == this.help) {
            string = "Your goal is to destroy all enemy tanks. Use the touchscreen arrows, the joystick or keyboard arrows to move the tank. Press the joystick, the spacebar or simply tap middle of the touchscreen to fire. When you destroy all enemy tanks you will proceed to next level.";
            alert = new Alert("Information", string, null, null);
            alert.setTimeout(-2);
            alert.setType(AlertType.INFO);
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)alert);
        }
        if (command.getCommandType() == 5) {
            string = "BattleTank 1.0 (c) 2011 Arclite Systems";
            alert = new Alert("Information", string, null, null);
            alert.setTimeout(-2);
            alert.setType(AlertType.INFO);
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)alert);
        } else if (command.getCommandType() == 7) {
            this.midlet.exitRequested();
        }
    }

    public void gameOver() {
        this.gameOver = true;
        this.countdown = 10;
    }

    public HeroTank getHero() {
        return this.hero;
    }

    private void restartGame() {
        this.gameOver = false;
        this.direction = -1;
        this.shoot = false;
        this.currentLevel = 0;
        this.liveenemies = 0;
        Tank.restart();
        this.hero = Tank.getHero();
        this.nextLevel();
    }

    protected void hideNotify() {
        this.levelSplash = true;
    }

    protected void showNotify() {
    }
}

