/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.game.Layer;

abstract class EnemyTank
extends Tank {
    protected Bullet bullet = null;
    private boolean hasPrize;

    EnemyTank() {
        this.setVisible(false);
        this.speed = this.getSpeed();
    }

    public void tick() {
        super.tick();
        if (!this.isVisible()) {
            return;
        }
        this.think();
        this.drive();
        if (this.bullet != null && !this.bullet.isVisible()) {
            this.bullet = null;
        }
    }

    protected void think() {
        if ((this.animationTick & 7) == 0 && BattleTankMIDlet.random(5) == 0) {
            this.changeDirection(BattleTankMIDlet.random(4));
        }
        if (BattleTankMIDlet.random(20) == 0) {
            this.shoot();
        }
    }

    public void hit() {
        this.explode();
    }

    protected void explode() {
        Explosion explosion = Explosion.explode(this.getRefPixelX(), this.getRefPixelY(), 1);
        this.setVisible(false);
        layerManager.remove((Layer)this);
        explosion.toCallBack = this;
        if (this.hasPrize) {
            Powerup.issuePowerup();
        }
        Tank.getHero().score += this.getScore();
    }

    public void doneExploding() {
        Tank.spawnNextEnemy(this.pool_pos);
    }

    public void shoot() {
        if (this.bullet != null) {
            return;
        }
        int n = this.getRefPixelX();
        int n2 = this.getRefPixelY();
        switch (this.direction) {
            case 0: {
                n2 -= 8;
                break;
            }
            case 1: {
                n += 8;
                break;
            }
            case 2: {
                n2 += 8;
                break;
            }
            case 3: {
                n -= 8;
            }
        }
        this.bullet = Bullet.shoot(n, n2, this.direction, this.getBulletSpeed(), false, this.getBulletStrength());
    }

    protected abstract int getSpeed();

    protected abstract int getBulletSpeed();

    protected abstract int getBulletStrength();

    protected abstract int getScore();
}

