/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.game.Layer;

public class HeroTank
extends Tank {
    private static final int INITIAL_LIVES = 2;
    protected int livesLeft = 2;
    public int score;
    private Bullet bullet1;
    private Bullet bullet2;
    private int invulnerabilityTicks;
    private Explosion explodingHero;
    private boolean shouldDrive;
    private boolean shouldShoot;
    private static final int[][] ANIMATION = new int[][]{{0}, {1}, {2}, {3}};

    HeroTank() {
        this.speed = 3;
        this.bullet2 = null;
        this.bullet1 = null;
    }

    protected int[][] getAnimation() {
        return ANIMATION;
    }

    public void tick() {
        super.tick();
        if (this.shouldDrive) {
            this.drive();
        }
        if (this.invulnerabilityTicks > 0) {
            --this.invulnerabilityTicks;
        }
        if (this.shouldShoot) {
            if (!this.isShooting) {
                this.isShooting = true;
                this.shoot();
            }
        } else {
            this.isShooting = false;
        }
        if (this.bullet1 != null && !this.bullet1.isVisible()) {
            this.bullet1 = null;
        }
        if (this.bullet2 != null && !this.bullet2.isVisible()) {
            this.bullet2 = null;
        }
    }

    public void shoot() {
        if (this.bullet1 != null && this.bullet2 != null) {
            return;
        }
        int n = this.getRefPixelX();
        int n2 = this.getRefPixelY();
        switch (this.direction) {
            case 0: {
                n2 -= 8;
                break;
            }
            case 1: {
                n += 8;
                break;
            }
            case 2: {
                n2 += 8;
                break;
            }
            case 3: {
                n -= 8;
            }
        }
        if (this.bullet1 == null) {
            this.bullet1 = Bullet.shoot(n, n2, this.direction, 6, true, 1);
            return;
        }
        this.bullet2 = Bullet.shoot(n, n2, this.direction, 8, true, 1);
    }

    public void hit() {
        if (this.invulnerabilityTicks > 0) {
            return;
        }
        this.explode();
    }

    protected void explode() {
        this.explodingHero = Explosion.explode(this.getRefPixelX(), this.getRefPixelY(), 1);
        this.setVisible(false);
        if (--this.livesLeft < 0) {
            BattleTankMIDlet.gameOver();
        } else {
            this.explodingHero.toCallBack = this;
        }
    }

    public void doneExploding() {
        this.spawn();
        layerManager.append((Layer)this);
    }

    public void upgrade() {
    }

    public void becomeInvulnerable() {
        this.invulnerabilityTicks = 100;
    }

    public void spawn() {
        this.setPosition(96, 160);
        this.becomeInvulnerable();
        this.changeDirection(0);
        this.setVisible(true);
    }

    public void getUserInput(int n, boolean bl) {
        this.changeDirection(n);
        this.shouldDrive = n != -1;
        this.shouldShoot = bl;
    }
}

