/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;

class Explosion
extends Sprite {
    public static final int SMALL = 0;
    public static final int BIG = 1;
    public static final int WIDTH = 32;
    public static final int HEIGHT = 32;
    private static final int[][] FRAME_SEQ = new int[][]{{0, 1, 1}, {0, 1, 1, 2, 2, 3, 3, 1}};
    private static final Image EXPLOSION_IMAGE = BattleTankMIDlet.createImage("/Explosion.png");
    private static final int POOL_SIZE = 5;
    private static Explosion[] EXPLOSIONS_POOL = new Explosion[5];
    public Tank toCallBack;

    private Explosion(int n) {
        super(EXPLOSION_IMAGE, 32, 32);
        this.defineReferencePixel(16, 16);
        this.setVisible(false);
    }

    private void setStrength(int n) {
        this.setFrameSequence(FRAME_SEQ[n]);
    }

    public static Explosion explode(int n, int n2, int n3) {
        for (int i = 0; i < 5; ++i) {
            Explosion explosion = EXPLOSIONS_POOL[i];
            if (explosion.isVisible()) continue;
            explosion.setRefPixelPosition(n, n2);
            explosion.setFrame(0);
            explosion.setStrength(n3);
            explosion.setVisible(true);
            return explosion;
        }
        return null;
    }

    public static void tickExplosions() {
        for (int i = 0; i < 5; ++i) {
            Explosion explosion = EXPLOSIONS_POOL[i];
            explosion.tick();
        }
    }

    private void tick() {
        if (!this.isVisible()) {
            return;
        }
        this.nextFrame();
        if (this.getFrame() == 0) {
            this.setVisible(false);
            if (this.toCallBack != null) {
                this.toCallBack.doneExploding();
                this.toCallBack = null;
            }
        }
    }

    static void appendToLayerManager(LayerManager layerManager) {
        for (int i = 0; i < 5; ++i) {
            layerManager.append((Layer)EXPLOSIONS_POOL[i]);
        }
    }

    public static void stopAllExplosions() {
        for (int i = 0; i < 5; ++i) {
            EXPLOSIONS_POOL[i].setVisible(false);
        }
    }

    static {
        for (int i = 0; i < 5; ++i) {
            Explosion.EXPLOSIONS_POOL[i] = new Explosion(0);
        }
    }
}

