/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.game.TiledLayer;

class Battleground
extends TiledLayer {
    public static final int WIDTH_IN_TILES = 13;
    public static final int HEIGHT_IN_TILES = 13;
    public static final int TILE_WIDTH = 16;
    public static final int TILE_HEIGHT = 16;
    private static final int BRICK_WALL = 21;
    private static final int CONCRETE_WALL = 22;
    private static final int FOREST = 29;
    private static int[][] waterFrames = new int[][]{{23, 24}, {24, 23}};
    private int tickCount = 0;

    public Battleground() {
        super(13, 13, BattleTankMIDlet.createImage("/Objects.png"), 16, 16);
        this.createAnimatedTile(waterFrames[0][0]);
        this.createAnimatedTile(waterFrames[1][0]);
    }

    public synchronized void read(InputStream inputStream, int n) {
        try {
            this.readBattleground(inputStream);
            this.readEnemies(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void readBattleground(InputStream inputStream) throws IOException {
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        block9: while ((n = inputStream.read()) != -1 && n3 < 13) {
            switch (n) {
                case 10: {
                    ++n3;
                    n2 = 0;
                    continue block9;
                }
                case 43: {
                    this.setCell(n2++, n3, 21);
                    continue block9;
                }
                case 35: {
                    this.setCell(n2++, n3, 22);
                    continue block9;
                }
                case 42: {
                    this.setCell(n2++, n3, 29);
                    continue block9;
                }
                case 126: {
                    this.setCell(n2++, n3, -1 - ((n2 ^ n3) & 1));
                    continue block9;
                }
                case 36: {
                    Tank.addSpawnPoint(n2, n3);
                    this.setCell(n2, n3, 0);
                    ++n2;
                    continue block9;
                }
                case 32: 
                case 33: 
                case 46: 
                case 64: {
                    this.setCell(n2++, n3, 0);
                    continue block9;
                }
            }
        }
    }

    private void readEnemies(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStream.read()) != -1) {
            if (n <= 48) continue;
            stringBuffer.append((char)n);
        }
        String string = stringBuffer.toString();
        System.out.println(string);
        Tank.initEnemyPool(string);
    }

    void tick() {
        int n = this.tickCount++ / 100;
        int n2 = n % 2;
        this.setAnimatedTile(-1 - n2, waterFrames[n2][n % 4 / 2]);
    }

    public boolean containsImpassableArea(int n, int n2, int n3, int n4) {
        int n5 = n2 / 16;
        int n6 = (n2 + n4 - 1) / 16;
        if (n6 >= 13) {
            n6 = 12;
        }
        int n7 = n / 16;
        if (n < 0 || n2 < 0 || n7 > 12 || n5 > 12) {
            return true;
        }
        int n8 = (n + n3 - 1) / 16;
        if (n8 >= 13) {
            n8 = 12;
        }
        for (int i = n5; i <= n6; ++i) {
            for (int j = n7; j <= n8; ++j) {
                int n9 = this.getCell(j, i);
                if (n9 >= 0 && n9 != 21 && n9 != 22) continue;
                return true;
            }
        }
        return false;
    }

    boolean hitWall(int n, int n2, int n3) {
        int n4 = n / 16;
        int n5 = n2 / 16;
        int n6 = this.getCell(n4, n5);
        if (n6 == 21 && n3 > 0) {
            this.setCell(n4, n5, 0);
            return true;
        }
        if (n6 == 22) {
            if (n3 > 1) {
                this.setCell(n4, n5, 0);
            }
            return true;
        }
        return false;
    }
}

