/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class GameObject
implements Constants {
    public static int currentId;
    public int id;
    public int state;
    public int type;
    public int x;
    public int y;
    public int xVel;
    public int yVel;
    public int row = -1;
    public int col = -1;
    public boolean isOnScreen;
    public static GameWorld gameWorld;
    public boolean removeWhenAnimationWrapped;
    public byte[] bytes;
    public int[] ints;
    public int[][] ints2;
    public boolean[] booleans;
    public GameObject[] objects;
    public static final int ATTACK_STAGE_1 = 0;
    public static final int ATTACK_STAGE_2 = 1;
    public static final int SPRITE_ANIMATION_ONCE = 0;
    public static final int SPRITE_ANIMATION_LOOP = 1;
    public int spriteId = -1;
    public int spriteAnimationSequence = -1;
    public int spriteAnimationIndex = -1;
    public int spriteAnimationCountdown = -1;
    public int spritePalette;
    public boolean animate;

    public GameObject(int n, int n2) {
        this.id = n;
        this.type = n2;
        this.initArrays();
    }

    public GameObject(int n) {
        this.id = currentId++;
        this.type = n;
        this.initArrays();
    }

    public GameObject(int n, int n2, int n3) {
        this(n);
        this.setPosition(n2 << 8, n3 << 8);
    }

    public byte[] toBytes() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeShort(this.id);
            dataOutputStream.writeByte(this.type);
            dataOutputStream.writeByte(this.state);
            dataOutputStream.writeInt(this.x);
            dataOutputStream.writeInt(this.y);
            dataOutputStream.writeInt(this.xVel);
            dataOutputStream.writeInt(this.yVel);
            dataOutputStream.writeShort(this.row);
            dataOutputStream.writeShort(this.col);
            dataOutputStream.writeBoolean(this.removeWhenAnimationWrapped);
            dataOutputStream.writeByte(this.spriteId);
            dataOutputStream.writeByte(this.spriteAnimationSequence);
            dataOutputStream.writeByte(this.spritePalette);
            dataOutputStream.writeByte(this.spriteAnimationIndex);
            dataOutputStream.writeByte(this.spriteAnimationCountdown);
            dataOutputStream.writeBoolean(this.animate);
            Engine.writeByteArray(this.bytes, dataOutputStream);
            Engine.writeIntArray(this.ints, dataOutputStream);
            Engine.writeInt2Array(this.ints2, dataOutputStream);
            Engine.writeBooleanArray(this.booleans, dataOutputStream);
            Engine.writeObjectArray(this.objects, dataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static GameObject fromStream(DataInputStream dataInputStream) {
        try {
            short s = dataInputStream.readShort();
            byte by = dataInputStream.readByte();
            GameObject gameObject = new GameObject(s, by);
            gameObject.state = dataInputStream.readByte();
            gameObject.x = dataInputStream.readInt();
            gameObject.y = dataInputStream.readInt();
            gameObject.xVel = dataInputStream.readInt();
            gameObject.yVel = dataInputStream.readInt();
            gameObject.row = dataInputStream.readShort();
            gameObject.col = dataInputStream.readShort();
            gameObject.removeWhenAnimationWrapped = dataInputStream.readBoolean();
            gameObject.spriteId = dataInputStream.readByte();
            gameObject.spriteAnimationSequence = dataInputStream.readByte();
            gameObject.spritePalette = dataInputStream.readByte();
            gameObject.spriteAnimationIndex = dataInputStream.readByte();
            gameObject.spriteAnimationCountdown = dataInputStream.readByte();
            gameObject.animate = dataInputStream.readBoolean();
            gameObject.bytes = Engine.readByteArray(dataInputStream);
            gameObject.ints = Engine.readIntArray(dataInputStream);
            gameObject.ints2 = Engine.readInt2Array(dataInputStream);
            gameObject.booleans = Engine.readBooleanArray(dataInputStream);
            gameObject.objects = Engine.readObjectArray(dataInputStream);
            return gameObject;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static GameObject createUnit(int n, int n2, int n3, int n4) {
        GameObject gameObject = new GameObject(2, n4 * 48, n3 * 48);
        gameObject.bytes[12] = (byte)n;
        gameObject.bytes[0] = (byte)n2;
        int n5 = n2;
        if (n == 7) {
            n5 += 3;
        }
        gameObject.setSprite(GameWorld.UNIT_SPRITES[n], n5);
        gameObject.bytes[16] = -1;
        gameObject.bytes[17] = -1;
        gameObject.bytes[19] = -1;
        gameObject.bytes[14] = -1;
        gameObject.bytes[15] = -1;
        gameObject.ints[4] = -1;
        gameObject.ints[1] = -1;
        gameWorld.getClass();
        if (n2 != 0) {
            gameObject.booleans[1] = true;
        }
        gameObject.ints[0] = gameObject.getHitPoints();
        return gameObject;
    }

    public static GameObject createBuilding(int n, int n2) {
        GameObject gameObject = new GameObject(3);
        gameObject.bytes[4] = (byte)n;
        gameObject.bytes[0] = (byte)n2;
        if (GameWorld.BUILDING_PANEL_ICONS[n] != null) {
            gameObject.ints2[0] = new int[0];
        }
        gameObject.ints[1] = -1;
        return gameObject;
    }

    public void placeBuilding(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.side();
        byte by = this.bytes[4];
        if (!GameWorld.loadingSavedGame) {
            this.setX(n2 * 48 << 8);
            this.setY(n * 48 << 8);
        }
        int n6 = this.getHitPoints();
        int n7 = n;
        int n8 = n2;
        byte[] byArray = gameWorld.getBuildingTiles(n5, by);
        for (n4 = 0; n4 < byArray.length; n4 += 3) {
            n3 = n + byArray[n4];
            int n9 = n2 + byArray[n4 + 1];
            gameWorld.getClass();
            if (this.isSameTeamAs(0)) {
                gameWorld.setTileProperty(2, 1, n3, n9, 1, false);
                gameWorld.addTileProperty(508, 2, n3, n9, 1, false);
            }
            gameWorld.setTile(n3, n9, 33);
            gameWorld.setTileProperty(1, 0, n3, n9, 1, false);
            gameWorld.setTileProperty(512, 9, n3, n9, 1, false);
            n7 = Math.max(n7, n3);
            n8 = Math.max(n8, n9);
        }
        this.bytes[5] = (byte)n7;
        this.bytes[6] = (byte)n8;
        if (!GameWorld.loadingSavedGame) {
            n4 = n + GameWorld.BUILDING_EXITS[2 * by];
            n3 = n2 + GameWorld.BUILDING_EXITS[2 * by + 1];
            this.bytes[7] = (byte)n4;
            this.bytes[8] = (byte)n3;
            this.state = 0;
        }
        GameObject.gameWorld.updateCursorPosition = true;
    }

    public void updateBuildingTileMap(boolean bl) {
        int n = this.side();
        boolean bl2 = this.anyBuildingTileVisible();
        byte by = this.bytes[4];
        byte[] byArray = gameWorld.getBuildingTiles(n, by);
        for (int i = 0; i < byArray.length; i += 3) {
            int n2 = this.row + byArray[i];
            int n3 = this.col + byArray[i + 1];
            byte by2 = byArray[i + 2];
            if (bl) {
                gameWorld.getClass();
                if (this.isSameTeamAs(0)) {
                    gameWorld.addTileProperty(508, 2, n2, n3, -1);
                    gameWorld.explore(n2, n3, GameWorld.BUILDING_VIEW_DISTANCE[by], true);
                }
            }
            gameWorld.setTile(n2, n3, by2);
            if (!bl2) continue;
            gameWorld.copyPerceivedTile(n2, n3);
        }
    }

    public void completeBuilding(boolean bl) {
        int n = this.side();
        this.updateBuildingTileMap(true);
        if (!GameWorld.loadingSavedGame) {
            if (GameWorld.BUILDING_ATTACK_POINTS[this.bytes[4]] > 0) {
                this.bytes[3] = 60;
            }
            this.state = 1;
            if (bl) {
                gameWorld.getClass();
                if (n == 0) {
                    gameWorld.message(Engine.getText(144, new String[]{gameWorld.getBuildingName(n, this.bytes[4])}), this.row, this.col);
                }
                gameWorld.getClass();
                if (n == 0) {
                    GameObject.gameWorld.statistics[1] = (short)(GameObject.gameWorld.statistics[1] + 1);
                }
            } else if (!GameWorld.loadingSavedGame) {
                this.ints[0] = GameWorld.BUILDING_HIT_POINTS[this.bytes[4]];
            }
        }
        if (this.bytes[4] == 1) {
            gameWorld.addHousingMax(n, 10);
            GameObject.gameWorld.hasTownCenter[n] = true;
            gameWorld.getClass();
            if (n == 0 && GameObject.gameWorld.showBuildingPanel && GameObject.gameWorld.selectedBuildingType == 0) {
                gameWorld.refreshBuildingPanel();
            }
        } else if (this.bytes[4] == 2) {
            gameWorld.addHousingMax(n, 5);
        }
        gameWorld.getClass();
        if (n != 0) {
            GameObject.gameWorld.ais[n].buildingBuilt(this);
        }
        byte by = this.bytes[4];
        GameObject.gameWorld.nBuildingsPerType[by] = (byte)(GameObject.gameWorld.nBuildingsPerType[by] + 1);
        this.bytes[9] = (byte)(25 + Engine.rndPositive(15));
    }

    public boolean anyBuildingTileVisible() {
        int n = this.side();
        byte by = this.bytes[4];
        byte[] byArray = gameWorld.getBuildingTiles(n, by);
        for (int i = 0; i < byArray.length; i += 3) {
            int n2 = this.row + byArray[i];
            int n3 = this.col + byArray[i + 1];
            if (!gameWorld.isTileProperty(508, 2, n2, n3, false)) continue;
            return true;
        }
        return false;
    }

    public boolean tryQueueBuilding(int n) {
        short[] sArray = GameWorld.BUILD_ICON_RESOURCES[n];
        byte by = GameWorld.BUILD_ICON_TYPES[n];
        if (by == 2 || by == 4) {
            gameWorld.removeResources(this.side(), sArray);
            this.ints2[0] = Engine.addToArray(this.ints2[0], new int[]{n, 1}, false);
            return true;
        }
        if (GameObject.gameWorld.housing[this.side()] < GameObject.gameWorld.housingMax[this.side()]) {
            gameWorld.removeResources(this.side(), sArray);
            gameWorld.addHousing(this.side(), 1);
            boolean bl = false;
            for (int i = 0; i < this.ints2[0].length; i += 2) {
                if (this.ints2[0][i] != n) continue;
                if (by == 0) {
                    int n2 = this.ints2[0][i + 1];
                    int n3 = n - 8;
                    if (n2 == GameWorld.UNIT_PRODUCTION_STACKS[n3]) continue;
                    int[] nArray = this.ints2[0];
                    int n4 = i + 1;
                    nArray[n4] = nArray[n4] + 1;
                }
                bl = true;
                break;
            }
            if (!bl) {
                this.ints2[0] = Engine.addToArray(this.ints2[0], new int[]{n, 1}, false);
            }
            return true;
        }
        gameWorld.getClass();
        if (this.isSide(0)) {
            gameWorld.message(Engine.getText(135));
        }
        return false;
    }

    public void removeFromBuildQueue(int n, int n2) {
        if (this.ints2[0][2 * n + 1] == n2) {
            this.ints2[0] = Engine.removeFromArray(this.ints2[0], 2 * n, 2 * n + 1);
            if (n == 0) {
                this.state = 1;
            }
        } else {
            int[] nArray = this.ints2[0];
            int n3 = 2 * n + 1;
            nArray[n3] = nArray[n3] - n2;
        }
        if (GameObject.gameWorld.showBuildingPanel && GameObject.gameWorld.buildPanelQueue && this == GameObject.gameWorld.selectedBuildingObject) {
            if (this.ints2[0].length == 0) {
                GameObject.gameWorld.buildPanelQueue = false;
                gameWorld.refreshBuildingPanel();
            } else {
                gameWorld.checkBuildingPanelEdges(false);
                gameWorld.updateBuildPanelName();
            }
        }
    }

    public static GameObject createSprite(int n) {
        GameObject gameObject = new GameObject(5, 0, 0);
        gameObject.setSprite(n);
        return gameObject;
    }

    public static void createExplosion(int n, int n2, boolean bl, boolean bl2, int n3) {
        GameObject gameObject = new GameObject(5, n, n2);
        gameObject.setSprite(14);
        gameObject.startAnimation(n3);
        gameObject.removeWhenAnimationWrapped = true;
        GameObject.createDebris(15, n, n2, 12800, bl ? 1 + Engine.rndPositive(2) : Engine.rndPositive(2));
        if (bl2 || gameWorld.isTileBuilding(gameObject.row, gameObject.col, false)) {
            GameObject.createDebris(16, n, n2, 0, bl ? 1 + Engine.rndPositive(2) : Engine.rndPositive(2));
            GameObject.createDebris(17, n, n2, 0, bl ? 1 + Engine.rndPositive(2) : Engine.rndPositive(2));
        } else {
            GameObject.createDebris(18, n, n2, 0, bl ? 3 + Engine.rndPositive(2) : 1 + Engine.rndPositive(2));
        }
        gameWorld.addObject(gameObject);
        if (gameObject.isOnScreen(true)) {
            Device.vibrate(50);
        }
    }

    public static GameObject createText(int n, int n2, int n3, int n4) {
        GameObject gameObject = new GameObject(6, n, n2);
        gameObject.ints[3] = n4;
        gameObject.ints[0] = n3;
        gameObject.ints[4] = n3;
        gameObject.ints[1] = 512;
        return gameObject;
    }

    public static GameObject createDebris(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        GameObject gameObject = new GameObject(5, n2, n3);
        gameObject.setSprite(n);
        gameObject.spriteAnimationIndex = Engine.rndPositive(GameWorld.spriteAnimationSequences[n][0].length);
        if (n == 15) {
            gameObject.bytes[0] = 4;
        }
        gameObject.xVel = n4;
        gameObject.yVel = n5;
        gameObject.ints[1] = n6;
        gameObject.ints[2] = n7;
        return gameObject;
    }

    public static void createDebris(int n, int n2, int n3, int n4, int n5) {
        for (int i = 0; i < n5; ++i) {
            int n6 = n == 18 ? Engine.rnd(256) : Engine.rnd(768);
            int n7 = n == 18 ? Engine.rnd(256) : Engine.rnd(768);
            int n8 = n == 18 ? 1536 + Engine.rndPositive(1024) : 1280 + Engine.rndPositive(2);
            GameObject gameObject = GameObject.createDebris(n, n2 + Engine.rnd(12), n3 + Engine.rnd(12), n6, n7, n8, -128);
            gameObject.ints[0] = n4;
            gameWorld.addObject(gameObject);
        }
    }

    public static GameObject createSmoke(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        GameObject gameObject = new GameObject(5, n, n2);
        gameObject.setSprite(20, n8);
        gameObject.startAnimation(n7);
        gameObject.xVel = n3;
        gameObject.yVel = n4;
        gameObject.ints[1] = n5;
        gameObject.ints[0] = n6;
        gameObject.removeWhenAnimationWrapped = true;
        return gameObject;
    }

    public byte[] getFireOffsets(int n) {
        int n2;
        int n3 = this.getAttackCategory();
        int n4 = n == 0 ? 0 : (n == 4 ? 1 : (n2 = n == 6 ? 2 : 3));
        byte[] byArray = n3 == 2 ? GameWorld.ARTILLERY_FIRE_OFFSETS : (n3 == 1 ? GameWorld.CAVALRY_FIRE_OFFSETS : GameWorld.INFANTRY_FIRE_OFFSETS);
        byte by = byArray[3 * n2];
        byte by2 = byArray[3 * n2 + 1];
        byte by3 = byArray[3 * n2 + 2];
        return new byte[]{by, by2, by3};
    }

    public void spawnWeaponFire(boolean bl) {
        byte by = this.bytes[18];
        int n = by == 0 || by == 4 ? 0 : 1;
        byte[] byArray = this.getFireOffsets(by);
        GameObject gameObject = new GameObject(5, (this.x >> 8) + byArray[0], (this.y >> 8) + byArray[1]);
        gameObject.setSprite(by == 0 || by == 6 ? 22 : 23);
        gameObject.startAnimation(n);
        if (bl) {
            gameObject.spriteAnimationIndex = 1;
        }
        gameObject.removeWhenAnimationWrapped = true;
        gameObject.ints[0] = byArray[2] << 8;
        gameWorld.addObject(gameObject);
    }

    public void spawnBuildingBurningSmoke(int n) {
        byte[] byArray = GameWorld.BUILDING_WINDOW_OFFSETS[this.bytes[4]];
        for (int i = 0; i < Math.min(byArray.length, 3 * n); i += 3) {
            byte by = byArray[i];
            byte by2 = byArray[i + 1];
            int n2 = byArray[i + 2] << 8;
            GameObject gameObject = GameObject.createSmoke(this.col * 48 - 24 + by, this.row * 48 - 24 + by2, Engine.rnd(128), Engine.rnd(128), 384, n2, 1, 1);
            gameWorld.addObject(gameObject);
        }
    }

    public void spawnCannonBusySmoke() {
        byte[] byArray = this.getFireOffsets(this.bytes[18]);
        for (int i = 0; i < 3; ++i) {
            byte by = byArray[0];
            byte by2 = byArray[1];
            int n = byArray[2] + 6;
            if (this.state == 2) {
                n += 14;
            }
            GameObject gameObject = GameObject.createSmoke((this.x >> 8) + by, (this.y >> 8) + by2, Engine.rnd(64), Engine.rnd(64), 384, n << 8, 1, 1);
            gameWorld.addObject(gameObject);
        }
    }

    public static GameObject createMarker() {
        GameObject gameObject = new GameObject(5);
        gameObject.setSprite(19);
        gameObject.removeWhenAnimationWrapped = true;
        return gameObject;
    }

    public void setX(int n) {
        this.x = n;
        this.col = this.getCol();
    }

    public void setY(int n) {
        this.y = n;
        this.row = this.getRow();
    }

    public int getRow() {
        return this.getRow(0);
    }

    public int getCol() {
        return this.getCol(0);
    }

    public int getRow(int n) {
        return ((this.y >> 8) + n + 24) / 48;
    }

    public int getCol(int n) {
        return ((this.x >> 8) + n + 24) / 48;
    }

    public void setRow(int n) {
        this.setY(n * 48 << 8);
    }

    public void setCol(int n) {
        this.setX(n * 48 << 8);
    }

    public void setTile(int n, int n2) {
        this.setRow(n);
        this.setCol(n2);
    }

    public boolean isOnTile(int n, int n2) {
        return this.row == n && this.col == n2;
    }

    public void setPosition(int n, int n2) {
        this.setX(n);
        this.setY(n2);
    }

    public void moveX(int n) {
        this.setX(this.x + n);
    }

    public void moveY(int n) {
        this.setY(this.y + n);
    }

    public void initArrays() {
        if (GameWorld.N_TYPE_BYTES[this.type] > 0) {
            this.bytes = new byte[GameWorld.N_TYPE_BYTES[this.type]];
        }
        if (GameWorld.N_TYPE_INTS[this.type] > 0) {
            this.ints = new int[GameWorld.N_TYPE_INTS[this.type]];
        }
        if (GameWorld.N_TYPE_INTS2[this.type] > 0) {
            this.ints2 = new int[GameWorld.N_TYPE_INTS2[this.type]][];
        }
        if (GameWorld.N_TYPE_BOOLEANS[this.type] > 0) {
            this.booleans = new boolean[GameWorld.N_TYPE_BOOLEANS[this.type]];
        }
        if (GameWorld.N_TYPE_OBJECTS[this.type] > 0) {
            this.objects = new GameObject[GameWorld.N_TYPE_OBJECTS[this.type]];
        }
    }

    public boolean isEntity() {
        return this.type == 2 || this.type == 3;
    }

    public boolean isSide(int n) {
        return this.side() == n;
    }

    public int side() {
        return this.bytes[0];
    }

    public boolean isSameTeamAs(GameObject gameObject) {
        return this.isSameTeamAs(gameObject.side());
    }

    public boolean isSameTeamAs(int n) {
        return Engine.gameCurrentTeams[this.side()] == Engine.gameCurrentTeams[n];
    }

    public int getBonus() {
        return GameObject.getBonus(this.side(), this.bytes[12], false);
    }

    public static int getBonus(int n, int n2, boolean bl) {
        byte by = GameWorld.UNIT_ATTACK_CATEGORY[n2];
        int n3 = bl ? 3 : GameObject.gameWorld.upgrades[n][by];
        return GameObject.getBonus(n3, n2);
    }

    public static int getBonus(int n, int n2) {
        byte by = GameWorld.UNIT_LEVELS[n2][n];
        if (by == 0) {
            return 100;
        }
        return 100 + by * 10;
    }

    public int getHitPoints() {
        return GameObject.getHitPoints(this.side(), this.type, this.type == 2 ? this.bytes[12] : this.bytes[4], false);
    }

    public static int getHitPoints(int n, int n2, int n3, boolean bl) {
        if (n2 == 2) {
            short s = GameWorld.UNIT_HIT_POINTS[n3];
            return GameObject.getBonus(n, n3, bl) * s / 100;
        }
        int n4 = GameWorld.BUILDING_HIT_POINTS[n3];
        if (Engine.gameCurrentDifficulty == 0) {
            gameWorld.getClass();
            if (n != 0) {
                n4 = 75 * n4 / 100;
            }
        }
        return n4;
    }

    public int getAttackPoints() {
        return GameObject.getAttackPoints(this.side(), this.type, this.type == 2 ? this.bytes[12] : this.bytes[4], false);
    }

    public static int getAttackPoints(int n, int n2, int n3, boolean bl) {
        int n4;
        if (n2 == 2) {
            n4 = GameObject.getBonus(n, n3, bl) * GameWorld.UNIT_ATTACK_POINTS[n3] / 100;
        } else {
            n4 = GameWorld.BUILDING_ATTACK_POINTS[n3];
            if (n3 == 3 && GameObject.gameWorld.age[n] == 2) {
                n4 = 150 * n4 / 100;
            }
        }
        if (Engine.gameCurrentDifficulty == 0) {
            gameWorld.getClass();
            if (n != 0) {
                n4 = 75 * n4 / 100;
            }
        }
        return n4;
    }

    public int getMoveSpeed() {
        return this.getBonus() * GameWorld.UNIT_MOVE_SPEED[this.bytes[12]] / 100;
    }

    public int getInteractInterval() {
        return this.getBonus() * GameWorld.UNIT_INTERACTION_INTERVAL[this.bytes[12]] / 100;
    }

    public void tick() {
        if (this.spriteId >= 0 && this.animate && (!GameObject.gameWorld.paused && Engine.debugMode != 1 || this.spriteId == 19)) {
            this.tickSprite();
            if (!this.animate && this.removeWhenAnimationWrapped) {
                this.removeObject();
            }
        }
        if (Engine.debugMode == 1 || GameObject.gameWorld.paused) {
            return;
        }
        if (this.xVel != 0 || this.yVel != 0) {
            int n = this.row;
            int n2 = this.col;
            this.moveX(this.xVel);
            this.moveY(this.yVel);
            int n3 = this.row;
            int n4 = this.col;
            if (this.type != 2 && !gameWorld.isOnMap(n3, n4)) {
                this.removeObject();
            } else if (n3 != n || n4 != n2) {
                if (this.type == 2) {
                    gameWorld.getClass();
                    if (this.isSameTeamAs(0)) {
                        gameWorld.explore(n, n2, GameWorld.UNIT_VIEW_DISTANCE[this.bytes[12]], false);
                        gameWorld.explore(n3, n4, GameWorld.UNIT_VIEW_DISTANCE[this.bytes[12]], true);
                    }
                    if (this.bytes[23] == n && this.bytes[24] == n2) {
                        gameWorld.addTileProperty(7168, 10, n, n2, -1);
                    }
                    gameWorld.addTileProperty(7168, 10, n3, n4, 1);
                    this.bytes[23] = (byte)n3;
                    this.bytes[24] = (byte)n4;
                }
                if (n3 == GameObject.gameWorld.cursor.row && n4 == GameObject.gameWorld.cursor.col || n == GameObject.gameWorld.cursor.row && n2 == GameObject.gameWorld.cursor.col) {
                    GameObject.gameWorld.updateCursorPosition = true;
                }
                if (this.type == 2) {
                    this.checkTileOffsets();
                }
            }
        }
        this.tickState();
        if (gameWorld.getTile(this.row, this.col) == 0 || gameWorld.getTile(this.row, this.col) == 1) {
            Engine.echo("unit on tree at " + this.row + ", " + this.col);
        }
    }

    public void checkTileOffsets() {
        if (GameWorld.UNIT_INTERACTION_RANGE[this.bytes[12]] == 1 && this.bytes[16] != -1 && this.ints2[0] != null && this.bytes[10] == this.ints2[0].length / 2 - 1) {
            int n = GameWorld.getDirection(this.bytes[4], this.bytes[5], this.bytes[16], this.bytes[17]);
            int n2 = 12;
            this.bytes[21] = (byte)(n2 * GameWorld.DIRECTION_OFFSETS[2 * n + 1]);
            this.bytes[22] = (byte)(n2 * GameWorld.DIRECTION_OFFSETS[2 * n]);
        } else {
            int n = Math.max(0, (gameWorld.getTileProperty(7168, 10, this.row, this.col) - 1) % (GameWorld.CROWDED_TILE_OFFSETS.length / 2));
            this.bytes[21] = GameWorld.CROWDED_TILE_OFFSETS[2 * n];
            this.bytes[22] = GameWorld.CROWDED_TILE_OFFSETS[2 * n + 1];
        }
    }

    public void tickState() {
        int n;
        if (this.type == 2) {
            if (this.state == 2) {
                n = this.bytes[5] * 48 + this.bytes[21] << 8;
                int n2 = this.bytes[4] * 48 + this.bytes[22] << 8;
                if ((this.xVel < 0 && this.x <= n || this.xVel > 0 && this.x >= n || this.x == n) && (this.yVel < 0 && this.y <= n2 || this.yVel > 0 && this.y >= n2 || this.y == n2)) {
                    this.nextPathStep();
                    if (this.ints2[0] != null) {
                        n = this.bytes[5] * 48 + this.bytes[21] << 8;
                        n2 = this.bytes[4] * 48 + this.bytes[22] << 8;
                        this.updateUnitSpeed(n, n2);
                    }
                } else {
                    this.updateUnitSpeed(n, n2);
                }
            } else if (this.state == 3 && this.ints[3] <= 0) {
                if (this.bytes[12] == 0) {
                    n = gameWorld.getTile(this.bytes[16], this.bytes[17]);
                    int n3 = Engine.getMapping(GameWorld.TILE_TO_RESOURCE_MAPPING, n);
                    if (n3 != -1) {
                        int n4 = 1;
                        gameWorld.getClass();
                        if (this.isSide(0)) {
                            if (n3 == 0) {
                                if (GameObject.gameWorld.statistics[6] < 29999) {
                                    GameObject.gameWorld.statistics[6] = (short)(GameObject.gameWorld.statistics[6] + n4);
                                }
                            } else if (n3 == 1) {
                                if (GameObject.gameWorld.statistics[7] < 29999) {
                                    GameObject.gameWorld.statistics[7] = (short)(GameObject.gameWorld.statistics[7] + n4);
                                }
                            } else if (GameObject.gameWorld.statistics[8] < 29999) {
                                GameObject.gameWorld.statistics[8] = (short)(GameObject.gameWorld.statistics[8] + n4);
                            }
                        } else {
                            GameObject.gameWorld.ais[this.side()].resourceGathered(this, n3, n4);
                        }
                        gameWorld.getClass();
                        if (this.isSide(0)) {
                            gameWorld.addResource(this.side(), n3, n4);
                        }
                        gameWorld.addTileProperty(536739840, 17, this.bytes[16], this.bytes[17], -n4);
                        if (GameObject.gameWorld.cursor.row == this.bytes[16] && GameObject.gameWorld.cursor.col == this.bytes[17] && gameWorld.isTileProperty(508, 2, GameObject.gameWorld.cursor.row, GameObject.gameWorld.cursor.col, false)) {
                            GameObject.gameWorld.selectionInfoString = "" + gameWorld.getTileProperty(536739840, 17, GameObject.gameWorld.cursor.row, GameObject.gameWorld.cursor.col);
                        }
                        if ((n4 = gameWorld.getTileProperty(536739840, 17, this.bytes[16], this.bytes[17])) <= 0) {
                            byte by = this.bytes[16];
                            byte by2 = this.bytes[17];
                            gameWorld.setTile(by, by2, Engine.getMapping(GameWorld.TILE_RESOURCE_TO_TILE_REGULAR_MAPPING, n));
                            gameWorld.setTileProperty(0x20000000, 29, by, by2, 1, false);
                            if (GameObject.gameWorld.cursor.row == by && GameObject.gameWorld.cursor.col == by2 && gameWorld.isTileProperty(2, 1, by, by2, false)) {
                                gameWorld.clearSelectionInfo();
                            }
                        }
                    } else {
                        this.clearInteractionTile();
                        this.stop();
                    }
                    if (this.state == 3) {
                        this.ints[3] = this.getInteractInterval();
                    }
                } else if (this.ensureTarget()) {
                    this.attack(this.objects[0], 0);
                }
            }
            if (this.state != 4) {
                if (this.ints[3] > 0) {
                    this.ints[3] = this.ints[3] - 1;
                }
                if (this.bytes[25] > 0) {
                    this.bytes[25] = (byte)(this.bytes[25] - 1);
                    if (this.bytes[25] <= 0) {
                        this.attack(this.objects[0], 1);
                    }
                }
                if (this.bytes[26] > 0) {
                    this.bytes[26] = (byte)(this.bytes[26] - 1);
                    if (this.isOnScreen && this.bytes[26] % 8 == 0) {
                        this.spawnCannonBusySmoke();
                    }
                }
            }
        } else if (this.type == 3) {
            int n5;
            int n6;
            n = this.bytes[4];
            if (this.state == 0) {
                n6 = this.getHitPoints();
                this.ints[2] = this.ints[2] + 8;
                this.ints[0] = this.ints[0] + 8;
                if (this.ints[2] >= n6) {
                    this.ints[0] = Math.min(this.ints[0], n6);
                    this.completeBuilding(true);
                }
            } else if (this.state == 1) {
                if (GameWorld.BUILDING_PANEL_ICONS[n] != null && this.ints2[0].length > 0) {
                    n6 = this.ints2[0][0];
                    n5 = GameWorld.BUILD_ICON_TYPES[n6];
                    this.ints[3] = 0;
                    if (n5 == 0) {
                        int n7 = n6 - 8;
                        this.ints[4] = GameWorld.UNIT_BUILD_TIMES[n7];
                    } else if (n5 == 2) {
                        this.ints[4] = GameWorld.AGE_BUILD_TIMES[n6 - 16];
                    } else if (n5 == 4) {
                        this.ints[4] = GameWorld.UPGRADE_BUILD_TIMES[n6 - 24];
                    }
                    this.state = 2;
                }
            } else if (this.state == 2) {
                this.ints[3] = this.ints[3] + 1;
                if (this.ints[3] >= this.ints[4]) {
                    n6 = this.side();
                    n5 = this.ints2[0][0];
                    byte by = GameWorld.BUILD_ICON_TYPES[n5];
                    int n8 = this.ints2[0][1];
                    if (by == 0) {
                        int n9 = n5 - 8;
                        int n10 = this.row + GameWorld.BUILDING_EXITS[2 * n];
                        int n11 = this.col + GameWorld.BUILDING_EXITS[2 * n + 1];
                        Vector<GameObject> vector = new Vector<GameObject>();
                        for (int i = 0; i < n8; ++i) {
                            GameObject gameObject = GameObject.createUnit(n9, this.side(), n10, n11);
                            if (gameWorld.isTileProperty(1, 0, n10, n11, false)) {
                                int[] nArray = gameWorld.getClosestBuildingTile(gameObject, this, true);
                                if (nArray[0] == -1) {
                                    nArray = gameWorld.getTileSpiral(n10, n11, 1, -1, 99, null);
                                }
                                if (nArray != null) {
                                    gameObject.setTile(nArray[0], nArray[1]);
                                } else {
                                    gameObject.setTile(n10, n11);
                                }
                            }
                            gameWorld.addObject(gameObject, true);
                            gameWorld.getClass();
                            if (this.isSide(0)) {
                                GameObject.gameWorld.statistics[0] = (short)(GameObject.gameWorld.statistics[0] + 1);
                            }
                            vector.addElement(gameObject);
                        }
                        if (n10 != this.bytes[7] || n11 != this.bytes[8]) {
                            Vector vector2 = GameObject.gameWorld.selectedUnits[n6];
                            GameObject.gameWorld.selectedUnits[n6] = vector;
                            gameWorld.order(vector, this.bytes[7], this.bytes[8], false);
                            GameObject.gameWorld.selectedUnits[n6] = vector2;
                        }
                        gameWorld.getClass();
                        if (this.isSide(0)) {
                            GameObject gameObject = (GameObject)vector.elementAt(vector.size() - 1);
                            gameWorld.message(Engine.getText(143, new String[]{gameWorld.getUnitName(gameObject.side(), gameObject.bytes[12])}), gameObject);
                        }
                    } else if (by == 2) {
                        gameWorld.nextAge(this.side());
                    } else if (by == 4) {
                        int n12 = Engine.getMapping(GameWorld.BUILDING_TYPE_TO_ATTACK_CATEGORY_MAPPING, n);
                        int n13 = Engine.getMapping(GameWorld.BUILD_ICON_TO_UPGRADE_LEVEL_MAPPING, n5);
                        gameWorld.nextUpgrade(this, n12, n13, n5);
                    }
                    this.removeFromBuildQueue(0, n8);
                    this.state = 1;
                }
            }
            if (this.isOnScreen) {
                byte[] byArray;
                byte[] byArray2 = byArray = GameObject.gameWorld.age[this.side()] == 0 ? GameWorld.BUILDING_CHIMNEY_OFFSETS_DISCOVERY : GameWorld.BUILDING_CHIMNEY_OFFSETS_COLONIAL;
                if (byArray[3 * n] != -1 && this.state != 0) {
                    this.bytes[9] = (byte)(this.bytes[9] - 1);
                    if (this.bytes[9] <= 0) {
                        GameObject gameObject = GameObject.createSmoke(0 + (this.x >> 8) + byArray[3 * n], 0 + (this.y >> 8) + byArray[3 * n + 1], 0, 0, 384, 2 * byArray[3 * n + 2] << 8, 1, 0);
                        gameWorld.addObject(gameObject);
                        this.bytes[9] = (byte)(25 + Engine.rndPositive(15));
                    }
                }
                if (this.state != 0) {
                    int n14 = this.ints[0];
                    short s = GameWorld.BUILDING_HIT_POINTS[this.bytes[4]];
                    if (this.bytes[10] > 0) {
                        this.bytes[10] = (byte)(this.bytes[10] - 1);
                        if (this.bytes[10] <= 0) {
                            this.spawnBuildingBurningSmoke(n14 < s / 3 ? 3 : 1);
                        }
                    } else if (n14 < s / 2 && this.bytes[10] == 0) {
                        this.bytes[10] = 4;
                    }
                }
            }
        } else if (this.type == 5 || this.type == 6) {
            if (this.type == 6 && this.ints[0] - this.ints[4] >= 12288) {
                this.removeObject();
            } else {
                this.ints[0] = this.ints[0] + this.ints[1];
                if (this.type == 5 && this.ints[2] != 0) {
                    this.ints[1] = this.ints[1] + this.ints[2];
                    if (this.ints[0] < 0) {
                        this.ints[0] = 0;
                        this.ints[1] = -(this.ints[1] / 3);
                        if (Math.abs(this.ints[1]) < 512) {
                            this.removeObject();
                        } else {
                            this.xVel /= 2;
                            this.yVel /= 2;
                        }
                    }
                }
            }
            if (this.spriteId == 15) {
                this.bytes[0] = (byte)(this.bytes[0] - 1);
                if (this.bytes[0] <= 0) {
                    gameWorld.addObject(GameObject.createSmoke(this.x >> 8, this.y >> 8, 0, 0, 0, this.ints[0], 2, 1));
                    this.bytes[0] = 4;
                }
            }
        }
        if (this.isEntity()) {
            if (this.type != 2 || this.state != 4) {
                if ((this.type == 3 || this.state == 1 && !gameWorld.isRequestingPath(this)) && this.bytes[3] > 0) {
                    this.bytes[3] = (byte)(this.bytes[3] - 1);
                    if (this.bytes[3] <= 0) {
                        this.scan(true);
                        this.bytes[3] = (byte)(this.type == 2 ? 30 : 60);
                    }
                }
                if (this.bytes[1] > 0) {
                    this.bytes[1] = (byte)(this.bytes[1] - 1);
                }
            }
            if ((this.type == 3 || this.state == 1) && this.bytes[2] > 0) {
                this.bytes[2] = (byte)(this.bytes[2] - 1);
                if (this.bytes[2] <= 0) {
                    n = this.getHitPoints();
                    this.ints[0] = Math.min(n, this.ints[0] + (this.type == 2 ? 5 : 50));
                    this.bytes[1] = 50;
                    if (this.ints[0] < n) {
                        this.bytes[2] = 40;
                    }
                }
            }
        }
    }

    public void updateUnitSpeed(int n, int n2) {
        int n3 = !this.booleans[1] || this.ints[2] == 0 ? this.getMoveSpeed() : this.ints[2];
        this.xVel = this.booleans[4] ? (this.x < n ? n3 : (this.x > n ? -n3 : 0)) : Engine.cap(n - this.x, n3);
        this.yVel = this.booleans[5] ? (this.y < n2 ? n3 : (this.y > n2 ? -n3 : 0)) : Engine.cap(n2 - this.y, n3);
    }

    public void playAttackSound() {
        if (this.isUnitType(3)) {
            return;
        }
        int n = this.getAttackCategory();
        int n2 = n == 3 || n == 2 ? (Engine.rndPositive(101) <= 50 ? 8 : 9) : (GameWorld.UNIT_INTERACTION_RANGE[this.bytes[12]] > 1 ? (Engine.rndPositive(101) <= 50 ? 6 : 7) : (Engine.rndPositive(101) <= 50 ? 4 : 5));
        Device.soundFunction(3, new int[]{n2, this.calculateVolume()});
    }

    public int calculateVolume() {
        return Math.max(0, 100 - 10 * Math.max(Math.abs(GameObject.gameWorld.cursor.row - this.row), Math.abs(GameObject.gameWorld.cursor.col - this.col)));
    }

    public boolean isWithinTiles(GameObject gameObject, int n) {
        return gameWorld.isWithinTiles(this, gameObject, n);
    }

    public boolean isWithinTiles(int n, int n2, int n3) {
        return gameWorld.isWithinTiles(this.row, this.col, n, n2, n3);
    }

    public int getDistance(GameObject gameObject) {
        return GameWorld.getDistance(this.row, this.col, gameObject.row, gameObject.col);
    }

    public GameObject getClosestEnemyObject() {
        GameObject gameObject = null;
        gameWorld.getClass();
        boolean bl = this.isSide(0);
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < Engine.gameCurrentNSides; ++i) {
            if (this.isSameTeamAs(i)) continue;
            GameObject[] gameObjectArray = GameObject.gameWorld.objectsPerSide[i];
            for (int j = 0; j < gameObjectArray.length; ++j) {
                GameObject gameObject2 = gameObjectArray[j];
                if (gameObject2 == null || (gameObject2.type != 2 || !gameObject2.isAlive()) && gameObject2.type != 3 || gameObject2.booleans[0] || bl && !gameWorld.isTileProperty(508, 2, gameObject2.row, gameObject2.col, false)) continue;
                int n2 = this.getDistance(gameObject2);
                if (gameObject != null && n2 >= n && (bl || gameObject.type != 3 || gameObject2.type != 2 || !gameWorld.isWithinTiles(this.row, this.col, gameObject2.row, gameObject2.col, 3))) continue;
                gameObject = gameObject2;
                n = n2;
            }
        }
        return gameObject;
    }

    public void scan(boolean bl) {
        if (this.type == 2 && this.bytes[12] == 0 && this.bytes[19] != -1) {
            int[] nArray = gameWorld.getTileSpiral(this.row, this.col, 2, -1, this.booleans[1] ? 500 : 48, new int[]{this.bytes[19]});
            if (nArray != null) {
                this.interact(nArray[0], nArray[1], null);
            } else {
                this.bytes[19] = -1;
                gameWorld.getClass();
                if (this.isSide(0) && bl) {
                    gameWorld.message(Engine.getText(145), this.row, this.col);
                }
            }
        } else {
            int n;
            int n2 = this.side();
            GameObject gameObject = this.getClosestEnemyObject();
            if (gameObject != null && ((n = this.type == 3 ? GameWorld.BUILDING_VIEW_DISTANCE[this.bytes[4]] : (this.booleans[1] && this.bytes[20] == 1 && GameObject.gameWorld.ais[n2].personality == 0 && GameObject.gameWorld.ais[n2].attackRegionRow != -1 ? -1 : Math.max(GameWorld.UNIT_INTERACTION_RANGE[this.bytes[12]], GameWorld.UNIT_VIEW_DISTANCE[this.bytes[12]]))) == -1 || this.isWithinTiles(gameObject, n))) {
                if (this.type == 3) {
                    this.attack(gameObject, 0);
                } else if (this.canAttack()) {
                    this.interact(gameObject.row, gameObject.col, gameObject);
                    if (n != -1) {
                        this.alarm();
                    }
                }
                gameWorld.getClass();
                if (n2 != 0 && GameObject.gameWorld.ais[n2].personality == 2) {
                    GameObject.gameWorld.ais[n2].personality = 0;
                }
            }
        }
    }

    public boolean canAttack() {
        return this.getAttackPoints() > 0;
    }

    public void loseHealth(GameObject gameObject, int n) {
        if (this.ints[0] <= 0) {
            return;
        }
        int n2 = this.side();
        int n3 = gameObject == null ? -1 : gameObject.side();
        gameWorld.getClass();
        if (n2 == 0 && !this.isOnScreen(false) && GameObject.gameWorld.messageAttackCountdown == 0 && gameObject != null) {
            GameObject.gameWorld.messageAttackCountdown = 100;
            gameWorld.message(Engine.getText(142), this);
        }
        this.ints[0] = this.ints[0] - n;
        if (this.type == 3 || this.state == 1) {
            this.alarm();
        }
        if (this.ints[0] <= 0) {
            boolean bl;
            if (this.type != 3 && this.type == 2) {
                int n4 = n2;
                GameObject.gameWorld.nUnits[n4] = GameObject.gameWorld.nUnits[n4] - 1;
                gameWorld.deselectUnit(this);
                this.booleans[2] = true;
                this.stop();
                this.setSprite(GameWorld.UNIT_SPRITE_DEATHS[this.bytes[12]], n2);
                this.startAnimation(Engine.rndPositive(2));
                this.state = 4;
            }
            gameWorld.getClass();
            if (n2 == 0) {
                if (this.type == 2) {
                    GameObject.gameWorld.statistics[4] = (short)(GameObject.gameWorld.statistics[4] + 1);
                } else {
                    GameObject.gameWorld.statistics[5] = (short)(GameObject.gameWorld.statistics[5] + 1);
                }
            } else if (this.type == 2) {
                gameWorld.getClass();
                if (n3 == 0) {
                    GameObject.gameWorld.statistics[2] = (short)(GameObject.gameWorld.statistics[2] + 1);
                }
                GameObject.gameWorld.ais[n2].unitKilled(this);
            } else {
                gameWorld.getClass();
                if (n3 == 0) {
                    GameObject.gameWorld.statistics[3] = (short)(GameObject.gameWorld.statistics[3] + 1);
                }
                GameObject.gameWorld.ais[n2].buildingDestroyed(this);
            }
            boolean bl2 = bl = gameWorld.getEntityAt(GameObject.gameWorld.cursor.row, GameObject.gameWorld.cursor.col) == this;
            if (this.type == 2) {
                if (this.bytes[14] != -1) {
                    gameWorld.setTileProperty(1, 0, this.bytes[14], this.bytes[15], 0, false);
                }
                gameWorld.getClass();
                if (n2 == 0) {
                    byte by = this.bytes[12];
                    GameObject.gameWorld.nUnitsPerType[by] = (byte)(GameObject.gameWorld.nUnitsPerType[by] - 1);
                }
                gameWorld.addHousing(n2, -1);
                if (this.bytes[23] != -1) {
                    gameWorld.addTileProperty(7168, 10, this.bytes[23], this.bytes[24], -1);
                }
                gameWorld.getClass();
                if (this.isSameTeamAs(0)) {
                    gameWorld.explore(this.row, this.col, GameWorld.UNIT_VIEW_DISTANCE[this.bytes[12]], false);
                }
                this.removeWhenAnimationWrapped = true;
                if (this.getAttackCategory() == 2) {
                    GameObject.createExplosion(this.x >> 8, this.y >> 8, false, true, 1);
                }
            } else {
                int n5;
                byte[] byArray = gameWorld.getBuildingTiles(n2, this.bytes[4]);
                for (n5 = 0; n5 < byArray.length; n5 += 3) {
                    int n6 = this.row + byArray[n5];
                    int n7 = this.col + byArray[n5 + 1];
                    GameObject.createExplosion(n7 * 48, n6 * 48, false, false, 0);
                }
                this.removeObject();
                gameWorld.removeObjects();
                if (this.bytes[4] == 1) {
                    GameObject.gameWorld.hasTownCenter[n2] = n5 = gameWorld.getEntity(3, 1, n2) != null ? 1 : 0;
                    if (GameObject.gameWorld.showBuildingPanel && GameObject.gameWorld.selectedBuildingType == 0 && n5 == 0) {
                        gameWorld.refreshBuildingPanel();
                    }
                }
            }
            if (bl) {
                gameWorld.clearSelectionInfo();
                gameWorld.updateCursorEdges();
            }
            gameWorld.checkGameOver();
            if (this.ints[1] != -1) {
                GameObject.gameWorld.cursor.setRow(this.row);
                GameObject.gameWorld.cursor.setCol(this.col);
                gameWorld.updateCursorEdges();
                gameWorld.failLatestObjective();
                GameObject.gameWorld.currentEvent = null;
                GameObject.gameWorld.eventQueue.removeAllElements();
                GameObject.gameWorld.eventQueue.addElement(new short[]{0, (short)this.ints[1], 0});
                GameObject.gameWorld.playerWon = false;
                GameObject.gameWorld.gameOverCountdown = 40;
            }
        } else {
            this.bytes[1] = 50;
            this.bytes[2] = 100;
            if (this.type == 2) {
                if (!this.booleans[3] && this.canAttack() && (this.objects[0] == null || !this.objects[0].canAttack() || gameObject.type == 2 && this.objects[0].type == 3)) {
                    this.interact(gameObject.row, gameObject.col, gameObject);
                }
            } else if (this.type == 3) {
                gameWorld.getClass();
                if (n2 != 0) {
                    GameObject.gameWorld.ais[n2].buildingAttacked(gameObject);
                }
            }
            gameWorld.getClass();
            if (n2 != 0 && this.isUnitType(0) && gameObject != null) {
                int[] nArray;
                if (this.state == 3) {
                    this.clearInteractionTile();
                    this.bytes[19] = -1;
                    this.stop();
                }
                if ((nArray = gameWorld.getTileSpiral(this.row, this.col, 0, GameWorld.getDirection(gameObject.row, gameObject.col, this.row, this.col), 48, null)) != null) {
                    this.move(nArray[0], nArray[1], false);
                }
            }
        }
    }

    public int getAttackCategory() {
        return this.type == 3 ? 3 : GameWorld.UNIT_ATTACK_CATEGORY[this.bytes[12]];
    }

    public boolean isUnitType(int n) {
        return this.type == 2 && this.bytes[12] == n;
    }

    public boolean isExplorer() {
        return this.type == 2 && this.ints[4] != -1;
    }

    public boolean isAlive() {
        return !this.booleans[2];
    }

    public boolean expandSelection(boolean bl) {
        boolean bl2 = false;
        boolean bl3 = this.bytes[12] == 0;
        boolean bl4 = this.bytes[19] != -1;
        GameObject[] gameObjectArray = GameObject.gameWorld.units[this.side()];
        for (int i = 0; i < gameObjectArray.length; ++i) {
            boolean bl5;
            GameObject gameObject = gameObjectArray[i];
            if (gameObject == null || gameObject == this || !gameObject.isAlive() || !gameObject.isWithinTiles(this, 2) || gameWorld.isUnitSelected(gameObject)) continue;
            boolean bl6 = gameObject.bytes[12] == 0;
            boolean bl7 = bl5 = gameObject.bytes[19] != -1;
            if (bl && gameObject.bytes[12] != this.bytes[12] || bl3 != bl6 || bl3 && bl4 != bl5 || !gameWorld.addUnitToSelection(gameObject)) continue;
            gameObject.expandSelection(bl);
            bl2 = true;
        }
        return bl2;
    }

    public void alarm() {
        GameObject[] gameObjectArray = GameObject.gameWorld.units[this.side()];
        for (int i = 0; i < gameObjectArray.length; ++i) {
            GameObject gameObject;
            GameObject gameObject2 = gameObjectArray[i];
            if (gameObject2 == null || gameObject2 == this || !gameObject2.isWithinTiles(this, 2) || !gameObject2.canAttack() || !gameObject2.isAlive() || !gameObject2.isFree() || (gameObject = gameObject2.getClosestEnemyObject()) == null) continue;
            gameObject2.interact(gameObject.row, gameObject.col, gameObject);
        }
    }

    public void order(int n, int n2) {
        this.order(n, n2, false);
    }

    public void order(int n, int n2, boolean bl) {
        if (this.type == 2 && !this.isAlive()) {
            return;
        }
        this.clearInteractionTile();
        this.bytes[19] = -1;
        if (!bl) {
            this.ints[2] = 0;
        }
        boolean bl2 = gameWorld.isTileProperty(508, 2, n, n2);
        GameObject gameObject = gameWorld.getEntityAt(n, n2);
        if (this.bytes[12] == 0 && gameWorld.isTileSettlerInteractable(n, n2) || gameObject != null && this.canInteractWith(gameObject)) {
            this.interact(n, n2, gameObject);
            if (bl) {
                gameWorld.getClass();
                if (this.isSide(0)) {
                    boolean bl3 = gameWorld.isTileProperty(2, 1, n, n2);
                    if (gameObject == null && bl3 || gameObject != null && gameObject.type == 2 && bl2 || gameObject != null && gameObject.type == 3 && bl3 && gameWorld.isTileBuilding(n, n2, true)) {
                        this.interactFeedback();
                    } else {
                        this.moveFeedback(n, n2);
                    }
                }
            }
        } else {
            this.move(n, n2, true);
            if (bl) {
                this.booleans[3] = true;
            }
            if (bl) {
                gameWorld.getClass();
                if (this.isSide(0)) {
                    this.moveFeedback(n, n2);
                }
            }
        }
    }

    public void moveFeedback(int n, int n2) {
        gameWorld.removeObject(GameObject.gameWorld.marker);
        GameObject.gameWorld.marker.setTile(n, n2);
        GameObject.gameWorld.marker.startAnimation(0);
        gameWorld.addObject(GameObject.gameWorld.marker);
    }

    public void interactFeedback() {
        gameWorld.blinkCursor(1, 4);
    }

    public void stop() {
        this.state = 1;
        boolean bl = this.ints2[1] != null;
        this.ints2[0] = null;
        this.xVel = 0;
        this.yVel = 0;
        this.setMovementAnimation();
        boolean bl2 = false;
        if (!bl) {
            if (this.booleans[3]) {
                this.booleans[3] = false;
            }
            if (this.occupiedByOtherUnit()) {
                bl2 = true;
                if (this.bytes[16] != -1) {
                    this.interact(this.bytes[16], this.bytes[17], null);
                } else {
                    int[] nArray = gameWorld.getTileSpiral(this.row, this.col, 1, -1, 48, null);
                    if (nArray != null) {
                        this.move(nArray[0], nArray[1], false);
                    }
                }
            } else if (this.bytes[16] != -1) {
                if (!this.isAlive()) {
                    this.clearInteractionTile();
                } else if (this.isWithinTiles(this.bytes[16], this.bytes[17], GameWorld.UNIT_INTERACTION_RANGE[this.bytes[12]])) {
                    this.turn(GameWorld.getStraightDirection(this.row, this.col, this.bytes[16], this.bytes[17]));
                    if (this.getAttackPoints() == 0) {
                        this.setInteractAnimation();
                    }
                    this.state = 3;
                }
            } else {
                this.bytes[3] = 30;
            }
        }
        if (!bl2) {
            this.bytes[14] = (byte)this.row;
            this.bytes[15] = (byte)this.col;
            gameWorld.setTileProperty(1, 0, this.row, this.col, 1, false);
        }
        if (this.ints[0] < this.getHitPoints()) {
            this.bytes[2] = 100;
        }
    }

    public void move(int n, int n2, boolean bl) {
        if (this.state != 1) {
            this.stop();
        }
        byte[][] byArray = GameObject.gameWorld.selectedUnits[this.side()].size() <= 15 ? GameObject.gameWorld.formationOffsets1 : GameObject.gameWorld.formationOffsets2;
        int n3 = bl ? gameWorld.getSelectionIndex(this) : -1;
        int n4 = n + (n3 == -1 ? 0 : byArray[this.bytes[13]][2 * n3]);
        int n5 = n2 + (n3 == -1 ? 0 : byArray[this.bytes[13]][2 * n3 + 1]);
        int[] nArray = this.getWayPoints(this.row, this.col, n4, n5);
        this.ints2[0] = null;
        this.ints2[1] = nArray;
        this.bytes[11] = 0;
        gameWorld.requestPath(this, this.row, this.col, nArray[0], nArray[1]);
    }

    public void interact(int n, int n2, GameObject gameObject) {
        int[] nArray;
        if (gameObject != null && gameObject.type == 3) {
            nArray = gameWorld.getClosestBuildingTile(this, gameObject, false);
            n = nArray[0];
            n2 = nArray[1];
        }
        this.bytes[16] = (byte)n;
        this.bytes[17] = (byte)n2;
        if (gameObject != null) {
            this.objects[0] = gameObject;
        }
        if (gameWorld.isTileResource(n, n2)) {
            this.bytes[19] = (byte)Engine.getMapping(GameWorld.TILE_TO_RESOURCE_MAPPING, gameWorld.getTile(n, n2));
        }
        nArray = null;
        if (gameObject != null && GameWorld.UNIT_INTERACTION_RANGE[this.bytes[12]] > 1) {
            if (this.checkRangedAttack(gameObject)) {
                return;
            }
            nArray = new int[]{n, n2};
        } else {
            nArray = gameObject != null && gameObject.type == 3 ? gameWorld.getClosestBuildingTile(this, gameObject, true) : this.findInteractionSlot(n, n2);
        }
        if (nArray != null && nArray[0] != -1 && nArray[1] != -1) {
            this.move(nArray[0], nArray[1], false);
        } else if (this.bytes[14] == -1) {
            int[] nArray2 = gameWorld.getTileSpiral(n, n2, 1, -1, 48, null);
            if (nArray2 != null) {
                this.move(nArray2[0], nArray2[1], false);
            } else {
                this.stopped();
            }
        } else {
            this.stopped();
        }
    }

    public void stopped() {
        if (this.bytes[12] == 0) {
            this.scan(false);
        } else {
            this.clearInteractionTile();
            this.stop();
        }
    }

    public void attack(GameObject gameObject, int n) {
        if (n == 0 && this.type == 2) {
            this.ints[3] = this.getInteractInterval();
        }
        if (gameObject == null || gameObject.booleans[0] || gameObject.type == 2 && !gameObject.isAlive()) {
            if (this.type == 2) {
                this.clearInteractionTile();
                this.stop();
            }
            return;
        }
        if (n == 0) {
            if (this.type == 2) {
                this.bytes[25] = GameWorld.UNIT_INTERACTION_DELAY[this.bytes[12]];
            }
            if (gameObject != null && !gameObject.booleans[0] && this.type == 2) {
                this.setInteractAnimation();
            }
            if (this.type == 3 || GameWorld.UNIT_INTERACTION_RANGE[this.bytes[12]] > 1 && !this.isUnitType(3) && this.getAttackCategory() != 2) {
                if (this.type == 2) {
                    this.spawnWeaponFire(true);
                }
                this.spawnBarrelSmoke(gameObject);
            }
        }
        if (n == 1) {
            boolean bl;
            int n2;
            int n3;
            byte by = this.type == 2 ? GameWorld.UNIT_ATTACK_SPLASH_DAMAGE[this.bytes[12]] : (byte)1;
            int n4 = this.getAttackPoints();
            int n5 = this.type == 2 ? GameWorld.UNIT_ATTACK_POINTS_SPREAD[this.bytes[12]] : 2;
            int n6 = n4;
            if (this.type == 2) {
                n3 = 0;
                if (GameWorld.UNIT_STRONG_AGAINST[this.bytes[12]] != null) {
                    if (gameObject.type == 2) {
                        n2 = gameObject.getAttackCategory();
                        n3 = Engine.getIndexInArray(GameWorld.UNIT_STRONG_AGAINST[this.bytes[12]], n2) != -1 ? 1 : 0;
                    } else {
                        int n7 = n3 = Engine.getIndexInArray(GameWorld.UNIT_STRONG_AGAINST[this.bytes[12]], 3) != -1 ? 1 : 0;
                    }
                }
                if (n3 != 0) {
                    n6 = 300 * n6 / 100;
                }
            }
            if ((n3 = n5) > 0) {
                n6 += Engine.rnd(n3);
            }
            if (by > 0) {
                for (n2 = 0; n2 < Engine.gameCurrentNSides; ++n2) {
                    if (this.isSameTeamAs(n2)) continue;
                    GameObject[] gameObjectArray = GameObject.gameWorld.units[n2];
                    for (bl = false; bl < gameObjectArray.length; bl += 1) {
                        GameObject gameObject2 = gameObjectArray[bl];
                        if (gameObject2 == null || gameObject2 == gameObject || !gameObject2.isAlive() || gameObject2.booleans[0] || !gameObject2.isWithinTiles(gameObject, by)) continue;
                        int n8 = this.getDistance(gameObject2);
                        gameObject2.loseHealth(this, n4 / Math.max(1, n8 * 2));
                    }
                }
            }
            gameObject.loseHealth(this, n6);
            if (this.type == 2 && this.getAttackCategory() == 2) {
                this.spawnWeaponFire(false);
                this.spawnBarrelSmoke(gameObject);
                this.bytes[26] = (byte)(2 * GameWorld.UNIT_INTERACTION_INTERVAL[this.bytes[12]] / 3);
            }
            if (this.type == 3 || this.getAttackCategory() == 2 || this.bytes[12] == 3) {
                n2 = gameObject.col * 48;
                int n9 = gameObject.row * 48;
                if (gameObject.type == 3) {
                    if (gameObject.getBuildingTiles().length > 3) {
                        n2 += 48;
                        n9 += 48;
                    }
                    n2 += Engine.rnd(24);
                    n9 += Engine.rnd(24);
                } else {
                    n2 += Engine.rnd(12);
                    n9 += Engine.rnd(12);
                }
                bl = this.getAttackCategory() == 2;
                GameObject.createExplosion(n2, n9, bl, false, bl ? 0 : 1);
            }
        }
        if ((this.type == 3 || this.bytes[25] == 0) && n == 0) {
            this.attack(gameObject, 1);
        }
    }

    public void spawnBarrelSmoke(GameObject gameObject) {
        int n;
        int n2;
        int n3;
        int n4;
        byte[] byArray;
        int n5 = this.type == 2 ? this.bytes[18] : GameWorld.getStraightDirection(this.row, this.col, gameObject.row, gameObject.col);
        byte by = GameWorld.DIRECTION_OFFSETS[2 * n5];
        byte by2 = GameWorld.DIRECTION_OFFSETS[2 * n5 + 1];
        if (this.type == 3) {
            byArray = this.getBuildingTiles();
            if (byArray.length == 3) {
                n4 = this.col * 48;
                n3 = this.row * 48;
                n2 = 25;
            } else {
                n4 = (this.col + 1) * 48;
                n3 = (this.row + 1) * 48;
                n2 = 49;
            }
            n = 23040;
            n4 += by2 * n2;
            n3 += by * n2;
        } else {
            byArray = this.getFireOffsets(n5);
            n4 = (this.x >> 8) + byArray[0];
            n3 = (this.y >> 8) + byArray[1];
            n = byArray[2] << 8;
        }
        int n6 = this.isUnitType(7) ? 8 : 3;
        for (n2 = 0; n2 < n6; ++n2) {
            int n7 = by2 * 2 * 256 + Engine.rnd(128);
            int n8 = by * 2 * 256 + Engine.rnd(128);
            int n9 = Engine.rnd(128);
            int n10 = this.isUnitType(7) ? Engine.rndPositive(2) : 0;
            gameWorld.addObject(GameObject.createSmoke(n4 + Engine.rnd(2), n3 + Engine.rnd(2), n7, n8, n9, n, 2, n10));
        }
    }

    public byte[] getBuildingTiles() {
        return gameWorld.getBuildingTiles(this.side(), this.bytes[4]);
    }

    public int[] getWayPoints(int n, int n2, int n3, int n4) {
        int[] nArray;
        int[] nArray2;
        if (!gameWorld.isTileWalkable(n3, n4) && (nArray2 = gameWorld.getTileSpiral(n3, n4, 0, -1, 48, null)) != null) {
            n3 = nArray2[0];
            n4 = nArray2[1];
        }
        int n5 = n2 * 48 << 8;
        int n6 = n * 48 << 8;
        int n7 = n4 * 48 << 8;
        int n8 = n3 * 48 << 8;
        int n9 = n7 - n5;
        int n10 = n8 - n6;
        int n11 = Engine.div(Math.max(Math.abs(n9), Math.abs(n10)), 49152) >> 8;
        if (n11 > 0) {
            nArray = new int[2 * n11];
            int n12 = n9 / n11;
            int n13 = n10 / n11;
            int n14 = n5;
            int n15 = n6;
            for (int i = 0; i < 2 * n11 - 2; i += 2) {
                int[] nArray3;
                int n16;
                int n17 = gameWorld.getRow(n15 += n13);
                if (!gameWorld.isTileWalkable(n17, n16 = gameWorld.getCol(n14 += n12)) && (nArray3 = gameWorld.getTileSpiral(n17, n16, 0, -1, 500, null)) != null) {
                    n17 = nArray3[0];
                    n16 = nArray3[1];
                }
                nArray[i] = n17;
                nArray[i + 1] = n16;
            }
            nArray[nArray.length - 2] = n3;
            nArray[nArray.length - 1] = n4;
        } else {
            nArray = new int[]{n3, n4};
        }
        return nArray;
    }

    public void turn(int n) {
        this.bytes[18] = (byte)n;
        this.setMovementAnimation();
    }

    public boolean canInteractWith(GameObject gameObject) {
        return this.getAttackPoints() > 0 && !this.isSameTeamAs(gameObject);
    }

    public boolean isFree() {
        if (this.type == 2) {
            return (this.isUnitType(0) && this.bytes[19] == -1 || !this.isUnitType(0) && this.bytes[16] == -1) && !this.booleans[3];
        }
        return true;
    }

    public boolean isOnScreen(boolean bl) {
        if (!(bl || this.type != 6 && this.type != 5)) {
            return true;
        }
        if (this.type == 3) {
            int[] nArray = gameWorld.logicToIsometric(this.x >> 8, this.y >> 8, GameWorld.tileWidthIsometric, GameWorld.tileHeightIsometric);
            byte[] byArray = gameWorld.getBuildingTiles(this.side(), this.bytes[4]);
            int n = this.getBuildingHeight();
            if (byArray.length == 3) {
                return gameWorld.isRectOnScreen(nArray[0] - GameWorld.tileWidthIsometric / 2, nArray[1] - n, GameWorld.tileWidthIsometric, n + GameWorld.tileHeightIsometric);
            }
            return gameWorld.isRectOnScreen(nArray[0] - GameWorld.tileWidthIsometric, nArray[1] - n, 2 * GameWorld.tileWidthIsometric, n + 2 * GameWorld.tileHeightIsometric);
        }
        int[] nArray = gameWorld.logicToIsometric((this.x >> 8) + 24, (this.y >> 8) + 24, GameWorld.tileWidthIsometric, GameWorld.tileHeightIsometric);
        return gameWorld.isRectOnScreen(nArray[0] + GameWorld.spriteOffsets[this.spriteId][0], nArray[1] + GameWorld.spriteOffsets[this.spriteId][1], GameWorld.spriteImages[this.spriteId][0][0].width, GameWorld.spriteImages[this.spriteId][0][0].height);
    }

    public int getBuildingHeight() {
        return GameWorld.BUILDING_HEIGHT[this.bytes[4]];
    }

    public void clearInteractionTile() {
        if (this.bytes[16] != -1) {
            this.bytes[16] = -1;
            this.bytes[17] = -1;
            this.objects[0] = null;
        }
    }

    public int[] findInteractionSlot(int n, int n2) {
        int n3 = Integer.MAX_VALUE;
        int n4 = -1;
        int n5 = -1;
        for (int i = n - 1; i <= n + 1; ++i) {
            for (int j = n2 - 1; j <= n2 + 1; ++j) {
                int n6;
                if ((i != this.bytes[14] || j != this.bytes[15]) && (!gameWorld.isTileWalkable(i, j) || gameWorld.isTileProperty(1, 0, i, j)) || (n6 = Math.abs(this.row - i) + Math.abs(this.col - j)) >= n3) continue;
                n3 = n6;
                n4 = i;
                n5 = j;
            }
        }
        if (n4 == -1) {
            return null;
        }
        return new int[]{n4, n5};
    }

    public void moveToNext(int n, int n2) {
        this.bytes[4] = (byte)n;
        this.bytes[5] = (byte)n2;
        this.bytes[18] = (byte)GameWorld.getStraightDirection(this.row, this.col, n, n2);
        this.setMovementAnimation();
        int[] nArray = this.ints2[0];
        this.booleans[4] = false;
        this.booleans[5] = false;
        if (this.bytes[10] <= nArray.length / 2 - 2) {
            int n3 = this.bytes[10] + 1;
            int n4 = nArray[2 * n3];
            int n5 = nArray[2 * n3 + 1];
            int n6 = GameWorld.getDirection(this.row, this.col, n, n2);
            if (n6 == GameWorld.getDirection(n, n2, n4, n5)) {
                if (n6 == 6 || n6 == 2) {
                    this.booleans[4] = true;
                } else if (n6 == 0 || n6 == 4) {
                    this.booleans[5] = true;
                } else {
                    this.booleans[4] = true;
                    this.booleans[5] = true;
                }
            }
        }
    }

    public void setPath(int[] nArray, boolean bl) {
        int[] nArray2;
        if (!this.isAlive()) {
            return;
        }
        boolean bl2 = false;
        if (bl && this.ints2[0] != null) {
            bl2 = true;
            nArray2 = new int[this.ints2[0].length + nArray.length];
            System.arraycopy(this.ints2[0], 0, nArray2, 0, this.ints2[0].length);
            System.arraycopy(nArray, 0, nArray2, this.ints2[0].length, nArray.length);
            this.ints2[0] = nArray2;
            nArray = nArray2;
        } else {
            this.ints2[0] = nArray;
            this.bytes[10] = 0;
        }
        nArray2 = this.ints2[1];
        if (nArray2 != null) {
            int n = nArray[nArray.length - 2];
            int n2 = nArray[nArray.length - 1];
            int n3 = nArray2.length / 2;
            this.bytes[11] = (byte)(this.bytes[11] + 1);
            if (this.bytes[11] < n3) {
                int n4 = nArray2[2 * this.bytes[11]];
                int n5 = nArray2[2 * this.bytes[11] + 1];
                gameWorld.requestPath(this, n, n2, n4, n5);
            } else {
                this.ints2[1] = null;
                this.bytes[8] = (byte)n;
                this.bytes[9] = (byte)n2;
            }
        }
        if (this.state != 2) {
            this.state = 2;
            if (this.bytes[14] != -1) {
                gameWorld.setTileProperty(1, 0, this.row, this.col, 0, false);
                this.bytes[14] = -1;
                this.bytes[15] = -1;
            }
            this.setMovementAnimation();
        }
        if (!bl2) {
            this.moveToNext(nArray[0], nArray[1]);
            if (this.bytes[23] != -1) {
                gameWorld.addTileProperty(7168, 10, this.bytes[23], this.bytes[24], -1);
                this.bytes[23] = -1;
                this.bytes[24] = -1;
            }
        }
        this.checkTileOffsets();
    }

    public void nextPathStep() {
        int[] nArray = this.ints2[0];
        this.bytes[10] = (byte)(this.bytes[10] + 1);
        int n = nArray.length / 2;
        if (this.bytes[10] > n - 1) {
            this.stop();
        } else {
            int n2 = nArray[2 * this.bytes[10]];
            int n3 = nArray[2 * this.bytes[10] + 1];
            if (!gameWorld.isTileWalkable(n2, n3)) {
                this.order(this.bytes[8], this.bytes[9]);
            } else if (n2 == this.bytes[8] && n3 == this.bytes[9] && gameWorld.isTileProperty(1, 0, n2, n3, false)) {
                if (this.bytes[16] != -1) {
                    this.order(this.bytes[16], this.bytes[17]);
                } else {
                    this.stop();
                }
            } else {
                this.moveToNext(n2, n3);
            }
            if (this.booleans[1] && !this.isUnitType(0) && this.objects[0] == null) {
                this.scan(false);
            }
        }
        if (this.objects[0] != null && GameWorld.UNIT_INTERACTION_RANGE[this.bytes[12]] > 1) {
            this.checkRangedAttack(this.objects[0]);
        }
        this.ensureTarget();
    }

    public boolean ensureTarget() {
        GameObject gameObject = this.objects[0];
        if (gameObject != null && gameObject.type == 2 && (this.bytes[16] != gameObject.row || this.bytes[17] != gameObject.col)) {
            this.interact(gameObject.row, gameObject.col, gameObject);
            return false;
        }
        return true;
    }

    public boolean occupiedByOtherUnit() {
        return gameWorld.isTileProperty(1, 0, this.row, this.col, false) && (this.row != this.bytes[14] || this.col != this.bytes[15]);
    }

    public boolean checkRangedAttack(GameObject gameObject) {
        if (gameObject != null && this.isWithinTiles(gameObject, GameWorld.UNIT_INTERACTION_RANGE[this.bytes[12]])) {
            if (this.occupiedByOtherUnit()) {
                int[] nArray = gameWorld.getTileSpiral(this.row, this.col, 1, -1, 48, null);
                if (nArray != null) {
                    this.move(nArray[0], nArray[1], false);
                    return true;
                }
            } else {
                this.stop();
                return true;
            }
        }
        return false;
    }

    public void setMovementAnimation() {
        boolean bl = this.state == 2;
        int n = -1;
        switch (this.bytes[18]) {
            case 6: {
                if (bl) {
                    n = 4;
                    break;
                }
                n = 0;
                break;
            }
            case 2: {
                if (bl) {
                    n = 5;
                    break;
                }
                n = 1;
                break;
            }
            case 0: {
                if (bl) {
                    n = 6;
                    break;
                }
                n = 2;
                break;
            }
            case 4: {
                n = bl ? 7 : 3;
            }
        }
        if (n != -1 && n != this.spriteAnimationSequence) {
            this.startAnimation(n);
        }
    }

    public void setInteractAnimation() {
        int n = -1;
        switch (this.bytes[18]) {
            case 6: {
                n = 8;
                break;
            }
            case 2: {
                n = 9;
                break;
            }
            case 0: {
                n = 10;
                break;
            }
            case 4: {
                n = 11;
            }
        }
        if (n != -1) {
            this.startAnimation(n);
        }
    }

    public void paint(Graphics graphics, int n, int n2, boolean bl) {
        block23: {
            int[] nArray;
            block20: {
                int n3;
                int n4;
                boolean bl2;
                int n5;
                block22: {
                    block21: {
                        nArray = gameWorld.logicToIsometric((this.x >> 8) + 24, (this.y >> 8) + 24, GameWorld.tileWidthIsometric, GameWorld.tileHeightIsometric);
                        if (this.type == 2) {
                            gameWorld.getClass();
                            if (this.isSide(0) && gameWorld.isUnitSelected(this)) {
                                graphics.setColor(0xFFFFFF);
                                graphics.drawArc(nArray[0] - GameWorld.SELECTION_CIRCLE_DIMENSIONS[0] / 2 + n, nArray[1] - GameWorld.SELECTION_CIRCLE_DIMENSIONS[1] / 2 - 1 + n2 + 0, (int)GameWorld.SELECTION_CIRCLE_DIMENSIONS[0], (int)GameWorld.SELECTION_CIRCLE_DIMENSIONS[1], 0, 360);
                            }
                        } else if (this.type == 6 || this.type == 5) {
                            if (this.isDebris()) {
                                graphics.setColor(0);
                                graphics.fillArc(nArray[0] - 2 + n, nArray[1] - 1 + n2, 4, 2, 0, 360);
                            }
                            n2 -= (Engine.scale(0, this.ints[0]) >> 8) / 2;
                        }
                        if (this.spriteId >= 0) {
                            this.paintSprite(graphics, nArray, n, n2);
                        }
                        if (this.type != 3 && (this.type != 2 || this.ints[4] == -1 && !this.isAlive())) break block20;
                        n5 = -(this.getHeight() + 9 + Engine.scale(0, 3));
                        if (this.type == 3 && this.state == 0) {
                            n5 -= Engine.scale(0, 3);
                        }
                        boolean bl3 = this.type == 2 ? gameWorld.isUnitSelected(this) : (bl2 = GameObject.gameWorld.selectedBuildingObject == this);
                        if (this.bytes[1] > 0) break block21;
                        gameWorld.getClass();
                        if ((!this.isSide(0) || !gameWorld.isUnitSelected(this)) && this != GameObject.gameWorld.selectionInfoObject && (this.type != 3 || this.state != 0)) break block22;
                    }
                    n3 = this.ints[0] < (n4 = this.getHitPoints()) / 3 ? 0xFF0000 : (this.ints[0] < 2 * n4 / 3 ? 0xFFFF00 : 5064382);
                    int n6 = 100 * this.ints[0] / n4;
                    this.drawBar(graphics, nArray[0] + n, nArray[1] + n5 + n2, n6, n3, bl2);
                }
                if (this.type == 3) {
                    gameWorld.getClass();
                    if (this.isSide(0) && this.state == 2) {
                        n4 = 100 * this.ints[3] / this.ints[4];
                        n3 = 0;
                        if (this.bytes[4] == 2) {
                            n3 += 0;
                        } else if (this.bytes[4] == 8) {
                            n3 += 0;
                        } else if (this.bytes[4] == 7) {
                            n3 += 0;
                        }
                        this.drawBar(graphics, nArray[0] + n, nArray[1] + 2 + 3 + n5 + n2 + n3, n4, 0xFFFF00, bl2);
                    }
                }
                if (this.type == 3 && this.state != 0) {
                    n4 = this.side();
                    byte[] byArray = GameObject.gameWorld.age[n4] == 0 ? GameWorld.BUILDING_FLAG_OFFSETS_DISCOVERY : GameWorld.BUILDING_FLAG_OFFSETS_COLONIAL;
                    GameObject.gameWorld.flagSprite.paintSprite(graphics, nArray, n4, byArray[2 * this.bytes[4]] + n, byArray[2 * this.bytes[4] + 1] + n2);
                }
                break block23;
            }
            if (this.type == 6) {
                FontMgr.drawString(Engine.font, graphics, "+" + this.ints[3], nArray[0] + n, nArray[1] + n2, 33);
            }
        }
    }

    public boolean isDebris() {
        return this.spriteId >= 15 && this.spriteId <= 18;
    }

    public int getHeight() {
        return this.type == 2 ? GameWorld.getSpriteHeight(this.spriteId) : (this.state == 0 ? GameWorld.tileImages[0].height / 2 : this.getBuildingHeight());
    }

    public void drawBar(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        graphics.setColor(0);
        graphics.fillRect(n -= 6, n2, 12, 2);
        graphics.setColor(n4);
        int n5 = Math.max(1, n3 * 12 / 100);
        graphics.fillRect(n, n2, n5, 2);
        if (bl) {
            graphics.setColor(0xFFFFFF);
            graphics.drawRect(n - 1, n2 - 1, 13, 3);
        }
    }

    public void removeObject() {
        if (this.isEntity()) {
            int n = this.side();
            this.booleans[0] = true;
            if (this.type == 3) {
                int[] nArray;
                int n2;
                int n3;
                int n4 = n;
                GameObject.gameWorld.nBuildings[n4] = GameObject.gameWorld.nBuildings[n4] - 1;
                byte by = this.bytes[4];
                GameObject.gameWorld.nBuildingsPerType[by] = (byte)(GameObject.gameWorld.nBuildingsPerType[by] - 1);
                byte[] byArray = gameWorld.getBuildingTiles(n, this.bytes[4]);
                for (int i = 0; i < byArray.length; i += 3) {
                    n3 = this.row + byArray[i];
                    n2 = this.col + byArray[i + 1];
                    gameWorld.setTileProperty(1, 0, n3, n2, 0, false);
                    gameWorld.setTileProperty(512, 9, n3, n2, 0, false);
                    gameWorld.setTile(n3, n2, GameWorld.RUINS_RANDOM[Engine.rndPositive(GameWorld.RUINS_RANDOM.length)]);
                    gameWorld.getClass();
                    if (this.isSameTeamAs(0)) {
                        if (this.state == 0) {
                            gameWorld.addTileProperty(508, 2, n3, n2, -1);
                            continue;
                        }
                        gameWorld.explore(n3, n2, GameWorld.BUILDING_VIEW_DISTANCE[this.bytes[4]], false);
                        continue;
                    }
                    gameWorld.copyPerceivedTile(n3, n2);
                }
                if (this.bytes[4] == 1) {
                    gameWorld.addHousingMax(n, -10);
                } else if (this.bytes[4] == 2) {
                    gameWorld.addHousingMax(n, -5);
                }
                if (this == GameObject.gameWorld.selectedBuildingObject) {
                    gameWorld.closeBuildingPanel();
                }
                if ((nArray = this.ints2[0]) != null) {
                    for (n3 = 0; n3 < nArray.length; n3 += 2) {
                        n2 = nArray[n3];
                        byte by2 = GameWorld.BUILD_ICON_TYPES[n2];
                        int n5 = nArray[n3 + 1];
                        short[] sArray = GameWorld.BUILD_ICON_RESOURCES[n2];
                        int n6 = 0;
                        while (n6 < 3) {
                            int n7 = n6++;
                            sArray[n7] = (short)(sArray[n7] * n5);
                        }
                        gameWorld.addResources(n, sArray);
                        if (by2 != 0) continue;
                        gameWorld.addHousing(n, -n5);
                    }
                }
            }
        }
        gameWorld.removeObject(this);
    }

    public int getScreenValue1() {
        return this.getRow(10) + this.getCol(10);
    }

    public int getScreenValue2() {
        return this.x + this.y;
    }

    public int compareTo(GameObject gameObject) {
        int n = this.getScreenValue1();
        int n2 = this.getScreenValue2();
        int n3 = gameObject.getScreenValue1();
        int n4 = gameObject.getScreenValue2();
        if (n == n3 && n2 == n4) {
            return 0;
        }
        if (n3 < n || n3 == n && n4 < n2) {
            return 1;
        }
        return -1;
    }

    public void setSprite(int n) {
        this.setSprite(n, 0);
    }

    public void setSprite(int n, int n2) {
        this.spriteId = n;
        this.spritePalette = n2;
        this.startAnimation(0);
    }

    public void startAnimation(int n) {
        this.spriteAnimationSequence = n;
        this.spriteAnimationIndex = 0;
        this.spriteAnimationCountdown = GameWorld.spriteAnimationDurations[this.spriteId][this.spriteAnimationSequence][0];
        this.animate = true;
    }

    public void tickSprite() {
        if (this.spriteId >= 0) {
            boolean bl = false;
            if (--this.spriteAnimationCountdown <= 0) {
                ++this.spriteAnimationIndex;
                bl = true;
            }
            if (this.hasAnimationWrapped()) {
                if (GameWorld.spriteAnimationTypes[this.spriteId][this.spriteAnimationSequence] == 1) {
                    this.spriteAnimationIndex = 0;
                } else {
                    --this.spriteAnimationIndex;
                    this.animate = false;
                }
            }
            if (bl) {
                this.spriteAnimationCountdown = GameWorld.spriteAnimationDurations[this.spriteId][this.spriteAnimationSequence][this.spriteAnimationIndex];
            }
        }
    }

    public boolean hasAnimationWrapped() {
        return this.spriteAnimationIndex >= GameWorld.spriteAnimationSequences[this.spriteId][this.spriteAnimationSequence].length;
    }

    public void paintSprite(Graphics graphics, int[] nArray, int n, int n2) {
        this.paintSprite(graphics, nArray, this.spritePalette, n, n2);
    }

    public void paintSprite(Graphics graphics, int[] nArray, int n, int n2, int n3) {
        if (this.spriteId >= 0) {
            DeviceImage deviceImage = GameWorld.spriteImages[this.spriteId][n][GameWorld.spriteAnimationSequences[this.spriteId][this.spriteAnimationSequence][this.spriteAnimationIndex]];
            short s = GameWorld.spriteAnimationProcesses[this.spriteId][this.spriteAnimationSequence][this.spriteAnimationIndex];
            int n4 = GameWorld.spriteOffsets[this.spriteId][0];
            if (s == 2) {
                n4 = -(deviceImage.width + n4);
            }
            deviceImage.drawImageAs(graphics, nArray[0] + (n2 += n4), nArray[1] + (n3 += GameWorld.spriteOffsets[this.spriteId][1]), s);
        }
    }

    public static void paintSprite(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        GameWorld.spriteImages[n][n2][GameWorld.spriteAnimationSequences[n][n3][n4]].drawImageAs(graphics, n5, n6, GameWorld.spriteAnimationProcesses[n][n3][n4], n7);
    }
}

