/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class Engine
extends Device
implements Constants,
Runnable,
CommandListener {
    public static final int GFX_SIZE_SMALL = 0;
    public static final int GFX_SIZE_MEDIUM = 1;
    public static final int GFX_SIZE_LARGE = 2;
    public static final char[] SCALE_VALUES = new char[]{'C', 'd', '\u0096'};
    public static final int MUSIC_THEME = 0;
    public static final int MUSIC_INGAME_1 = 1;
    public static final int MUSIC_INGAME_2 = 2;
    public static final int MUSIC_INGAME_3 = 3;
    public static final int SOUND_WEAPON_CLANG = 4;
    public static final int SOUND_WEAPON_CLANG_2 = 5;
    public static final int SOUND_MUSKET = 6;
    public static final int SOUND_MUSKET_2 = 7;
    public static final int SOUND_CANNON = 8;
    public static final int SOUND_CANNON_2 = 9;
    public static final int SOUND_PRODUCE_UNIT = 10;
    public static final int SOUND_BURNING = 11;
    public static final int SOUND_SOUND_ON = 12;
    public static final String TEAM_CHARACTER_PLAYER = "]";
    public static final String TEAM_CHARACTER_CPU_RED = "$";
    public static final String TEAM_CHARACTER_CPU_GREEN = "_";
    public static final int[] CHEAT_MODE_KEYS = new int[]{4, 8, 4, 4, 8, 8, 4, 4, 4, 8, 8, 8, 16384};
    public static int cheatKeyIndex;
    public static int lastKeyPressed;
    public static boolean showMap;
    public static boolean unlockAllMissions;
    public static String debugTimeStamp;
    public static boolean debugMenu;
    public static int debugAiIndex;
    public static int debugMenuSelectedIndex;
    public static int debugAiParamsSelectedIndex;
    public static int debugMode;
    public static boolean debugForceNoCache;
    public static boolean debugHideBaseTiles;
    public static boolean debugHideTallTiles;
    public int[] debugMemory = new int[88];
    int debugMemoryMin;
    int debugMemoryMax;
    public int[] debugFps;
    public static final int DEBUG_MAP_REVEAL = 0;
    public static final int DEBUG_EDIT = 1;
    public static final int DEBUG_GIVE_PLAYER_RESOURCES = 2;
    public static final int DEBUG_GIVE_AI_RESOURCES = 3;
    public static final int DEBUG_INSTANT_WIN = 4;
    public static final int DEBUG_INSTANT_DEFEAT = 5;
    public static final int DEBUG_ADVANCE_PLAYER_AGE = 6;
    public static final int DEBUG_ADVANCE_AI_AGE = 7;
    public static final int DEBUG_TOGGLE_ALL_MISSIONS = 8;
    public static final int DEBUG_AI_INFO = 9;
    public static final int DEBUG_AI_PARAMS = 10;
    public static final int DEBUG_GENERAL_INFO = 11;
    public static final int DEBUG_MEMORY = 12;
    public static final int DEBUG_MAP_CACHE_BORDERS = 13;
    public static final int DEBUG_FPS = 14;
    public static final int DEBUG_DSST = 15;
    public static final int DEBUG_SLOWMOTION = 16;
    public static final int DEBUG_FASTFORWARD = 17;
    public static final int DEBUG_FORCE_NO_CACHE = 18;
    public static final int DEBUG_KILL_ALL_ENEMIES = 19;
    public static final int DEBUG_TOGGLE_BASE_TILES = 20;
    public static final int DEBUG_TOGGLE_TALL_TILES = 21;
    public static String[] DEBUG_NAMES;
    public static final int DEBUG_AI_UPDATE_INTERVAL = 0;
    public static final int DEBUG_AI_RESOURCE_PER_SETTLER = 1;
    public static final int DEBUG_AI_MAX_SETTLERS_PER_RESOURCE = 2;
    public static final int DEBUG_AI_STAGE_DURATION = 3;
    public static final int DEBUG_AI_STAGE_DEFENSE = 4;
    public static final int DEBUG_AI_STARTING_OUTPOSTS = 5;
    public static final int DEBUG_AI_OUTPOSTS_PER_STAGE = 6;
    public static final int DEBUG_AI_OUTPOST_CHECK_INTERVAL = 7;
    public static final int DEBUG_AI_RANDOM_ATTACK = 8;
    public static final int DEBUG_AI_RANDOM_ATTACK_DECREASE = 9;
    public static String[] DEBUG_AI_NAMES;
    public static int[] DEBUG_AI_VALUES;
    public static int[] debugFeaturesKeys;
    public static int debugFeaturesKeyIndex;
    public static boolean debugDisableBaseTiles;
    public static boolean debugDisableTallTiles;
    public static boolean debugDisableObjects;
    public static boolean debugDisableHud;
    public static boolean debugDisableStatus;
    public static int debugDisablePainingStage;
    public static int debugDisableNImagesDrawn;
    public static int debugDisableNTilesDrawnForCache;
    public static int debugDisableLastResource;
    private boolean resumeSound;
    public static boolean handleEvent;
    public static boolean running;
    public static boolean hideNotify;
    private static long lastTick;
    public static final int EVENT_NONE = 0;
    public static final int EVENT_FORCE_SOUND = 1;
    public static final int EVENT_SHOW_PAUSE_SCREEN = 2;
    public static final int EVENT_SHOW_PAUSE_SCREEN_THEN_FORCE_SOUND = 3;
    public static int lastSound;
    public static boolean vibrateOn;
    public static boolean soundOn;
    public static boolean tipsOn;
    public static boolean cursorNormal;
    public static boolean firstPlay;
    public GameWorld gameWorld;
    public static Display display;
    public static Main parent;
    public static Engine instance;
    public static Random random;
    public static int tick;
    private int logicCounter;
    public static DeviceImage[] tipsImages;
    public static DeviceImage[] arrowHImages;
    public static DeviceImage[] arrowVImages;
    public static DeviceImage[] menuBarImages;
    public static DeviceImage[] menuBorderImages;
    public static DeviceImage menuLogoImage;
    public static DeviceImage woodPanelImage;
    public static DeviceImage loadingBarImage;
    public static DeviceImage loadingBarBgImage;
    public static DeviceImage[] loadingBarBorderImages;
    public static DeviceImage loadingBarGlowImage;
    public static Command commandSoft1;
    public static Command commandSoft2;
    public static int font;
    public static final int GS_UNUSED = -1;
    public static final int GS_INIT_APP = 0;
    public static final int GS_SPLASH = 2;
    public static final int GS_PAUSE = 4;
    public static final int GS_BRAND = 5;
    public static final int GS_MENU = 10;
    public static final int GS_DEMO = 30;
    public static final int GS_CLOSE_GAMEWORLD = 40;
    public static final int GS_INGAME = 100;
    public static int state;
    public static int pauseState;
    private static boolean isPainting;
    public static Menu closeGameWorldMenu;
    public static int gameCurrentMode;
    public static int gameCurrentMissionMode;
    public static int gameCurrentMission;
    public static int gameCurrentMap;
    public static int gameCurrentMapMaxPlayers;
    public static int gameCurrentNSides;
    public static int gameCurrentDifficulty;
    public static int gameUnlockedMission;
    public static byte[] gameCurrentTeams;
    public static boolean[] tipsSeen;
    public static boolean startingCampaignMission;
    public static DeviceImage demoLogoImage;
    public static int debugTick;
    public static int debugPaint;
    private long debugStartFPSTime;
    private int debugFramesRendered;
    private int debugAvgFPS;
    private static final int FPS_RECALC = 6;
    public boolean skipPaint;
    Image offScreen = null;
    public static int menuBorderWidth;
    public static int menuBorderHeight;
    public int loadingBorderLeftX;
    public int loadingBorderRightX;
    public int loadingBorderY;
    public int loadingBarX;
    public int loadingBarY;
    public int loadingBorderWidth;
    public int loadingBorderHeight;
    public int loadingBarWidth;
    public int loadingBarHeight;
    public int loadingBarBgLeftX;
    public int loadingBarBgRightX;
    public static int menuTopHeight;
    public static int brandIndex;
    private static DeviceImage imgBrand;
    private static final int BRAND_DELAY = 3000;
    public static final int DEMO_MENU_EXTRA_OPTION = 0;
    public static final int DEMO_MENU_EXTRA_MENU = 1;
    private DeviceImage splashImage;
    private Menu menuLanguage;
    private String[] languageFiles;
    public static boolean reverseTooltips;
    public static final int IMG_OK = 0;
    public static final int IMG_BACK = 1;
    public static final int IMG_MENU = 2;
    public static final int IMG_HAMMER = 3;
    private static int menuItemHeight;
    public static Menu menuCurrent;
    public static Menu menuMain;
    public static Menu menuSettings;
    public static Menu menuExit;
    public static Menu menuSound;
    public static Menu menuInGame;
    public static Menu menuUpsell;
    public static Menu menuInstructions;
    public static Menu menuSaves;
    public static Menu menuSaveConfirm;
    public static Menu menuEndGameConfirmation;
    public static Menu menuRestartConfirmation;
    public static Menu menuGameOver;
    public static Menu menuSkirmishMaps;
    public static Menu menuCampaign;
    public static Menu menuMissions;
    public static Menu menuControls;
    public static Menu menuDifficulty;
    public static Menu menuTeams;
    public static Menu menuCheat;
    public static Menu menuDebugFeatures;
    public static int menuWidth;
    public static int menuFormWidth;
    public static int menuTotalHeight;
    public static int menuContentHeight;
    public static int MENU_SPACING;
    public static int menuNVisible;
    public static int menuMaxNVisible;
    public static int upsellMode;
    public int currentSaveSlot;
    public static final String RMS_NAME = "aoe3";
    public static final int RMS_SETTINGS = 0;
    public static final int RMS_SAVEGAME_INFO = 1;
    public static final int RMS_SAVEGAME_1 = 2;
    public static final int RMS_SAVEGAME_2 = 3;
    public static final int RMS_SAVE_GAME_3 = 4;
    public static final int N_SAVE_SLOTS = 3;
    public static int[][] SAVES_INFORMATION;
    public static boolean menuSavesSaving;
    public static String[] text;
    public static String trace;
    private static int debugMsgTop;
    private static String[] debugMsgs;
    public static int keysPressed;
    public static int keyLatch;
    public static int keyUnmapped;
    public static boolean blah;
    public static int keyRepeatTimeout;
    public static long currentMem;
    public static String currentMemMsg;
    public static int loadingState;
    public static final int LOADING_STATE_NONE = 0;
    public static final int LOADING_STATE_LOADING = 1;
    public static final int LOADING_STATE_LOADED = 2;
    public static final int LOADING_STATE_SAVING = 3;
    public static final int LOADING_STATE_SAVED = 4;
    public static int loadingProgress;
    public static int loadingProgressDisplay;
    public static String[] loadingTextStrings;
    public static int fadeState;
    public static int fadeStep;
    public static int fadeEvent;
    public static int[] fadeEventParams;
    private static int clipX;
    private static int clipY;
    private static int clipW;
    private static int clipH;

    public Engine(Main main) {
        parent = main;
        instance = this;
        display = Display.getDisplay((MIDlet)main);
        display.setCurrent((Displayable)this);
        Thread thread = new Thread(this);
        this.initDebugVariables();
        thread.start();
    }

    private void initDebugVariables() {
        DEBUG_NAMES = new String[]{"Toggle map reveal", "Edit mode", "Give player resources", "Give AI resources", "Instant win", "Instant defeat", "Advance player age", "Advance AI age", "Toggle all missions", "Ai info", "AI params", "General info", "Memory", "Map cache borders", "Fps", "Dsst", "Slow motion", "Fast forward", "Toggle force no cache", "Kill all enemies", "Toggle base tiles", "Toggle tall tiles"};
        DEBUG_AI_NAMES = new String[]{"Update interval", "Resource per settler", "Max settlers per resource", "Stage duration", "Defense", "Starting outposts", "Outposts per stage", "Outpost check interval", "Random attack", "Random attack decrease"};
        DEBUG_AI_VALUES = new int[]{AI.updateInterval, AI.nResourcesPerSettler, AI.nMaxSettlersPerResource, AI.nTicksPerStage, AI.nDefenseUnits, AI.nStartOutposts, AI.nOutpostsPerStage, AI.outpostBuildCheckInterval, AI.randomAttackPercentage, AI.randomAttackDecrease};
        this.debugMemory = new int[88];
        this.debugMemoryMax = (int)Runtime.getRuntime().totalMemory();
        this.debugFps = new int[88];
    }

    public void run() {
        running = true;
        state = 0;
        this.debugFramesRendered = 0;
        this.debugAvgFPS = 0;
        lastTick = System.currentTimeMillis();
        while (running) {
            long l = System.currentTimeMillis();
            if (this.debugFramesRendered == 0) {
                this.debugStartFPSTime = l;
            }
            try {
                long l2;
                if (handleEvent) {
                    this.handleEvent();
                }
                if (!hideNotify) {
                    l2 = System.currentTimeMillis();
                    this.tick();
                    debugTick = (int)(System.currentTimeMillis() - l2);
                    l2 = System.currentTimeMillis();
                    Engine.doRepaint();
                    if (!this.skipPaint) {
                        debugPaint = (int)(System.currentTimeMillis() - l2);
                    }
                }
                l2 = System.currentTimeMillis() - l;
                if (debugMode == 16) {
                    Thread.sleep(200L);
                } else if (debugMode == 17) {
                    Thread.sleep(10L);
                } else if (l2 < 45L) {
                    Thread.sleep(50L - l2);
                } else {
                    Thread.sleep(5L);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++this.debugFramesRendered;
            if (System.currentTimeMillis() - this.debugStartFPSTime <= 6000L) continue;
            this.debugAvgFPS = this.debugFramesRendered / 6;
            this.debugFramesRendered = 0;
        }
        Device.soundFunction(1);
        parent.destroyApp(true);
        parent.notifyDestroyed();
    }

    /*
     * Unable to fully structure code
     */
    private void tick() {
        block75: {
            block74: {
                Engine.trace = "Engine.tick Start";
                if (Engine.debugMode == 12) {
                    for (var1_1 = 1; var1_1 < this.debugMemory.length; ++var1_1) {
                        this.debugMemory[var1_1 - 1] = this.debugMemory[var1_1];
                    }
                    System.gc();
                    this.debugMemory[this.debugMemory.length - 1] = (int)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
                } else if (Engine.debugMode == 14) {
                    for (var1_1 = 1; var1_1 < this.debugFps.length; ++var1_1) {
                        this.debugFps[var1_1 - 1] = this.debugFps[var1_1];
                    }
                    System.gc();
                    this.debugFps[this.debugFps.length - 1] = this.debugAvgFPS;
                } else if (Engine.debugMode != 15 && Engine.debugMode == 10) {
                    switch (Engine.debugAiParamsSelectedIndex) {
                        case 3: {
                            var1_1 = 100;
                            break;
                        }
                        case 0: 
                        case 7: {
                            var1_1 = 10;
                            break;
                        }
                        case 1: {
                            var1_1 = 5;
                            break;
                        }
                        default: {
                            var1_1 = 1;
                        }
                    }
                    if (Engine.key(1)) {
                        if (--Engine.debugAiParamsSelectedIndex < 0) {
                            Engine.debugAiParamsSelectedIndex = Engine.DEBUG_AI_NAMES.length - 1;
                        }
                    } else if (Engine.key(2)) {
                        if (++Engine.debugAiParamsSelectedIndex > Engine.DEBUG_AI_NAMES.length - 1) {
                            Engine.debugAiParamsSelectedIndex = 0;
                        }
                    } else if (Engine.key(4)) {
                        Engine.DEBUG_AI_VALUES[Engine.debugAiParamsSelectedIndex] = Math.max(0, Engine.DEBUG_AI_VALUES[Engine.debugAiParamsSelectedIndex] - var1_1);
                        Engine.releaseAllKeys();
                    } else if (Engine.key(8)) {
                        v0 = Engine.debugAiParamsSelectedIndex;
                        Engine.DEBUG_AI_VALUES[v0] = Engine.DEBUG_AI_VALUES[v0] + var1_1;
                        Engine.releaseAllKeys();
                    }
                }
                if (this.gameWorld != null && !this.gameWorld.paused || !Engine.key(16384)) break block74;
                if (Engine.debugMode != -1) {
                    Engine.debugMode = -1;
                } else {
                    Engine.debugMenu = Engine.debugMenu == false;
                }
                break block75;
            }
            if (!Engine.debugMenu) break block75;
            if (Engine.key(2)) {
                if (++Engine.debugMenuSelectedIndex > Engine.DEBUG_NAMES.length - 1) {
                    Engine.debugMenuSelectedIndex = 0;
                }
            } else if (Engine.key(1) && --Engine.debugMenuSelectedIndex < 0) {
                Engine.debugMenuSelectedIndex = Engine.DEBUG_NAMES.length - 1;
            }
            if (!Engine.key(16) && !Engine.key(64)) break block75;
            switch (Engine.debugMenuSelectedIndex) {
                case 0: {
                    Engine.showMap = Engine.showMap == false;
                    break;
                }
                case 2: {
                    if (this.gameWorld == null) break;
                    this.gameWorld.getClass();
                    this.gameWorld.addResources(0, new short[]{500, 500, 500});
                    break;
                }
                case 3: {
                    if (this.gameWorld == null) break;
                    for (var1_1 = 0; var1_1 < Engine.gameCurrentNSides; ++var1_1) {
                        this.gameWorld.getClass();
                        if (var1_1 == 0) continue;
                        this.gameWorld.addResources(var1_1, new short[]{500, 500, 500});
                        for (var2_3 = 0; var2_3 < 3; ++var2_3) {
                            this.gameWorld.ais[var1_1].resourceNeeded[var2_3] = (short)Math.max(0, this.gameWorld.ais[var1_1].resourceNeeded[var2_3] - 500);
                        }
                    }
                    break;
                }
                case 4: 
                case 5: {
                    if (this.gameWorld == null) break;
                    this.gameWorld.playerWon = Engine.debugMenuSelectedIndex == 4;
                    this.gameWorld.gameOver();
                    break;
                }
                case 6: 
                case 7: {
                    if (this.gameWorld == null) break;
                    for (var1_1 = 0; var1_1 < Engine.gameCurrentNSides; ++var1_1) {
                        if (Engine.debugMenuSelectedIndex != 6) ** GOTO lbl94
                        this.gameWorld.getClass();
                        if (var1_1 == 0) ** GOTO lbl98
lbl94:
                        // 2 sources

                        if (Engine.debugMenuSelectedIndex != 7) continue;
                        this.gameWorld.getClass();
                        if (var1_1 == 0) continue;
lbl98:
                        // 2 sources

                        if (this.gameWorld.age[var1_1] >= 2) continue;
                        this.gameWorld.nextAge(var1_1);
                    }
                    break;
                }
                case 8: {
                    Engine.unlockAllMissions = Engine.unlockAllMissions == false;
                    break;
                }
                case 18: {
                    Engine.debugForceNoCache = Engine.debugForceNoCache == false;
                    break;
                }
                case 20: {
                    Engine.debugHideBaseTiles = Engine.debugHideBaseTiles == false;
                    break;
                }
                case 21: {
                    Engine.debugHideTallTiles = Engine.debugHideTallTiles == false;
                    break;
                }
                case 9: {
                    if (++Engine.debugAiIndex > Engine.gameCurrentNSides - 1) {
                        Engine.debugAiIndex = 1;
                    }
                    Engine.debugMode = Engine.debugMenuSelectedIndex;
                    break;
                }
                case 19: {
                    for (var1_1 = 0; var1_1 < this.gameWorld.objects.length; ++var1_1) {
                        if (this.gameWorld.objects[var1_1] == null || !this.gameWorld.objects[var1_1].isEntity()) continue;
                        v1 = this.gameWorld.objects[var1_1];
                        this.gameWorld.getClass();
                        if (v1.isSameTeamAs(0)) continue;
                        this.gameWorld.objects[var1_1].loseHealth(null, this.gameWorld.objects[var1_1].ints[0]);
                    }
                    break;
                }
                default: {
                    Engine.debugMode = Engine.debugMenuSelectedIndex;
                }
            }
            Engine.debugMenu = false;
            Engine.lastTick = System.currentTimeMillis();
        }
        if (Engine.debugMenu || Engine.debugMode == 10) {
            return;
        }
        try {
            if (this.resumeSound && Engine.loadingState == 0 && Engine.state != 4) {
                v2 = this.resumeSound = Device.soundFunction(2) == 0;
            }
            if (Engine.keyRepeatTimeout > 0) {
                Engine.keyRepeatTimeout = Math.max(0, Engine.keyRepeatTimeout - 50);
            }
            if (Engine.loadingState != 0) {
                if (Engine.loadingState == 2 && Engine.hasAnyKeyPressed()) {
                    Engine.loadingTextStrings = null;
                    Engine.stopLoading();
                    if (!Engine.startingCampaignMission) {
                        this.gameWorld.playMusic();
                    }
                    Engine.startingCampaignMission = false;
                }
            } else {
                Engine.tickFade();
                if (!Demo.isEnabled() && Engine.state == 10 && Engine.menuCurrent.type != 2 && Engine.lastKeyPressed != -1) {
                    if (Engine.lastKeyPressed == Engine.CHEAT_MODE_KEYS[Engine.cheatKeyIndex]) {
                        if (++Engine.cheatKeyIndex >= Engine.CHEAT_MODE_KEYS.length) {
                            Engine.cheatKeyIndex = 0;
                            Engine.releaseAllKeys();
                            this.initCheatMenu();
                            Engine.setMenu(Engine.menuCheat);
                        }
                    } else {
                        Engine.cheatKeyIndex = 0;
                    }
                    Engine.lastKeyPressed = -1;
                }
                switch (Engine.state) {
                    case 100: {
                        if (Engine.debugMode == 15) break;
                        this.gameWorld.tick();
                        break;
                    }
                    case 5: {
                        if (Engine.fading()) break;
                        this.tickBrand();
                        break;
                    }
                    case 10: {
                        if (Engine.fading()) break;
                        this.tickMenu();
                        break;
                    }
                    case 0: {
                        this.initApp();
                        break;
                    }
                    case 2: {
                        if (Engine.fading()) break;
                        this.tickSplash();
                        break;
                    }
                    case 30: {
                        Demo.tick();
                        break;
                    }
                    case 4: {
                        if (!Engine.hasAnyKeyPressed()) break;
                        Engine.state = Engine.pauseState;
                        if (Engine.lastSound == -1) break;
                        Device.soundFunction(3, new int[]{Engine.lastSound});
                        break;
                    }
                    case 40: {
                        GameObject.gameWorld = null;
                        this.gameWorld = null;
                        v3 = var1_1 = Engine.menuCurrent.type == 2 ? 4 : -1;
                        if (Demo.isEnabled() && var1_1 != -1) {
                            Demo.init(var1_1);
                        } else {
                            Engine.setMenu(Engine.closeGameWorldMenu, Engine.closeGameWorldMenu == Engine.menuMain, false);
                            Device.soundFunction(3, new int[]{0});
                            Engine.state = 10;
                        }
                        Engine.closeGameWorldMenu = Engine.menuMain;
                    }
                }
            }
            ++Engine.tick;
        }
        catch (Exception var1_2) {
            var1_2.printStackTrace();
            Engine.debugWrite("Ex in tick (trace=\"" + Engine.trace + "\"): " + var1_2.toString() + "(state: " + Engine.state + ")", true);
        }
        Engine.trace = "Engine.tick End";
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        Object[] objectArray;
        trace = "Engine.paint Start";
        Graphics graphics2 = graphics;
        try {
            if (loadingState != 0) {
                this.paintLoading(graphics);
            } else {
                switch (state) {
                    case 100: {
                        this.gameWorld.paint(graphics);
                        break;
                    }
                    case 5: {
                        this.paintBrand(graphics);
                        break;
                    }
                    case 10: {
                        this.paintMenu(graphics);
                        break;
                    }
                    case 2: {
                        this.paintSplash(graphics);
                        break;
                    }
                    case 30: {
                        Demo.paint(graphics);
                        break;
                    }
                    case 40: {
                        Engine.cls(graphics, 0);
                        FontMgr.drawString(font, graphics, text == null ? "..." : text[110], 88, 208 - FontMgr.charHeight[font] >> 1, 17);
                        break;
                    }
                    case 4: {
                        Engine.cls(graphics, 0);
                        FontMgr.drawString(font, graphics, text[113], 88, 208 - FontMgr.charHeight[font] >> 1, 17);
                    }
                }
                if (fadeState != 0) {
                    this.drawFade(graphics);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Engine.debugWrite("Ex in paint (trace=\"" + trace + "\"): " + exception.toString(), false);
        }
        if (debugMode == 12 || debugMode == 14) {
            objectArray = debugMode == 12 ? this.debugMemory : this.debugFps;
            n3 = debugMode == 12 ? this.debugMemoryMin : 0;
            n2 = debugMode == 12 ? this.debugMemoryMax : 30;
            n = 52;
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 208 - n, objectArray.length, n);
            graphics.setColor(255);
            for (int i = 0; i < objectArray.length; ++i) {
                int n4 = 100 * (objectArray[i] - n3) / (n2 - n3);
                int n5 = n4 * n / 100;
                graphics.drawLine(i, 208, i, 208 - n5);
            }
            FontMgr.drawString(font, graphics, "" + objectArray[objectArray.length - 1], 1, 207, 68);
            if (debugMode == 12) {
                FontMgr.drawString(font, graphics, n2 / 1000 + "kb", objectArray.length + 1, 208 - n, 20);
                FontMgr.drawString(font, graphics, n3 / 1000 + "kb", objectArray.length, 207, 68);
            } else {
                FontMgr.drawString(font, graphics, n2 + "fps", objectArray.length + 1, 208 - n, 20);
                FontMgr.drawString(font, graphics, n3 + "fps", objectArray.length, 207, 68);
            }
        }
        if (debugMode == 15) {
            FontMgr.drawString(font, graphics, "176 x 208", 88, 104, 3);
        }
        Engine.paintDebug(graphics);
        trace = "Engine.paint End";
        if (debugMenu || debugMode == 10) {
            objectArray = debugMenu ? DEBUG_NAMES : DEBUG_AI_NAMES;
            n3 = FontMgr.charHeight[font] - 3;
            n2 = (208 - objectArray.length * n3) / 2;
            for (n = -1; n < objectArray.length; ++n) {
                if (debugMenu && n == debugMenuSelectedIndex || !debugMenu && n == debugAiParamsSelectedIndex) {
                    graphics.setColor(0x535353);
                } else {
                    graphics.setColor(0);
                }
                graphics.fillRect(0, n2 + 1, 176, FontMgr.charHeight[font]);
                FontMgr.drawString(font, graphics, n == -1 ? (debugMenu ? "Select debug mode (0 cancels)" : "Ai parameters (0 exits)") : (String)objectArray[n] + (debugMenu ? "" : ": " + DEBUG_AI_VALUES[n]), 88, n2, 17);
                n2 += n3;
            }
        }
        super.paint(graphics);
    }

    public void paintLoading(Graphics graphics) {
        int n;
        boolean bl;
        if (loadingTextStrings != null) {
            this.paintMenuBorders(graphics, 0);
        } else {
            Engine.cls(graphics, 0);
        }
        String string = null;
        int n2 = 104;
        boolean bl2 = bl = text != null;
        if (text == null) {
            string = "...";
        } else if (loadingState == 1 || loadingState == 2) {
            if (loadingState == 2) {
                if ((tick & 4) != 0) {
                    string = Engine.getText(113);
                }
            } else {
                string = Engine.getText(110);
            }
            if (loadingTextStrings != null) {
                n = menuBorderHeight / 2;
                for (int i = 0; i < loadingTextStrings.length; ++i) {
                    FontMgr.drawString(font, graphics, loadingTextStrings[i], 88, n, 17);
                    n += FontMgr.charHeight[font];
                }
            }
            n2 = this.loadingBorderY - 2;
        } else if (loadingState == 3) {
            string = Engine.getText(111);
            bl = false;
        } else {
            string = Engine.getText(112);
            bl = false;
        }
        if (string != null) {
            FontMgr.drawString(FontMgr.isRealised(0) ? 0 : 1, graphics, string, 88, n2, bl ? 65 : 3);
        }
        if (bl) {
            n = loadingProgressDisplay * this.loadingBarWidth / 100;
            Engine.drawImageWidth(graphics, loadingBarBgImage, this.loadingBarBgLeftX, this.loadingBorderY, this.loadingBarBgRightX);
            Engine.drawImageWidth(graphics, loadingBarImage, this.loadingBarX, this.loadingBarY, this.loadingBarX + n);
            loadingBarBorderImages[0].drawImage(graphics, this.loadingBorderLeftX, this.loadingBorderY);
            loadingBarBorderImages[1].drawImage(graphics, this.loadingBorderRightX, this.loadingBorderY, 24);
            if (loadingProgressDisplay < 100) {
                loadingBarGlowImage.drawImage(graphics, this.loadingBarX + n - Engine.loadingBarGlowImage.width / 5, this.loadingBarY + this.loadingBarHeight / 2, 3);
            }
        }
    }

    public static void drawImageWidth(Graphics graphics, DeviceImage deviceImage, int n, int n2, int n3) {
        int n4;
        for (n4 = n; n4 <= n3 - deviceImage.width; n4 += deviceImage.width) {
            deviceImage.drawImage(graphics, n4, n2);
        }
        if (n4 < n3) {
            Engine.saveAndClipRect(graphics, n4, 0, n3 - n4, 208);
            deviceImage.drawImage(graphics, n4, n2);
            Engine.restoreClip(graphics);
        }
    }

    private void initApp() {
        Engine.instantMemCheck("Engine.initApp start");
        trace = "Engine.initApp 1";
        this.setBackLight(true);
        Engine.startLoading();
        Engine.startMemCheck("Engine images 1");
        trace = "Engine.initApp 2";
        tipsImages = new DeviceImage(65).divide(4);
        arrowHImages = new DeviceImage(49).divide(2);
        arrowVImages = new DeviceImage(50).divide(2);
        menuBorderImages = new DeviceImage[8];
        Object object = new DeviceImage(58).divide(3);
        Engine.menuBorderImages[0] = object[0];
        Engine.menuBorderImages[1] = new DeviceImage(object[0], 5);
        Engine.menuBorderImages[2] = new DeviceImage(object[0], 3);
        Engine.menuBorderImages[3] = new DeviceImage(object[0], 6);
        Engine.menuBorderImages[4] = object[1];
        Engine.menuBorderImages[5] = new DeviceImage(object[1], 1);
        Engine.menuBorderImages[6] = object[2];
        Engine.menuBorderImages[7] = new DeviceImage(object[2], 2);
        loadingBarBorderImages = new DeviceImage[2];
        object = new DeviceImage(55);
        Engine.loadingBarBorderImages[0] = object;
        Engine.loadingBarBorderImages[1] = new DeviceImage((DeviceImage)object, 2);
        loadingBarGlowImage = new DeviceImage(56);
        loadingBarImage = new DeviceImage(53);
        loadingBarBgImage = new DeviceImage(54);
        Engine.loadMenuResources(0);
        trace = "Engine.initApp 2";
        Engine.endMemCheck();
        Engine.startMemCheck("Font initialization");
        try {
            Device.deviceFunction(1, "1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        trace = "Engine.initApp 3";
        FontMgr.realise(font);
        trace = "Engine.initApp 4";
        this.initUIValues();
        trace = "Engine.initApp 5";
        Engine.endMemCheck();
        object = Engine.getJadValue("ms-skPos");
        if (object != null) {
            reverseTooltips = ((String)object).equals("1");
        }
        trace = "Engine.initApp 6";
        this.setupLanguage();
        trace = "Engine.initApp 7";
        Engine.stopLoading();
    }

    public static DeviceImage[] divideSplittedImage(int n, int n2) {
        DeviceImage[] deviceImageArray = new DeviceImage[n2];
        for (int i = 0; i < n2; ++i) {
            deviceImageArray[i] = new DeviceImage(ResourceMaster.getResource(n + i));
        }
        return deviceImageArray;
    }

    public void initUIValues() {
        menuBorderWidth = Engine.menuBorderImages[0].width;
        menuBorderHeight = Engine.menuBorderImages[0].height;
        this.loadingBorderWidth = 176 - menuBorderWidth;
        this.loadingBorderHeight = Engine.loadingBarBorderImages[0].height;
        this.loadingBorderLeftX = (176 - this.loadingBorderWidth) / 2;
        this.loadingBorderRightX = 176 - this.loadingBorderLeftX;
        this.loadingBorderY = 208 - menuBorderHeight / 2 - this.loadingBorderHeight;
        this.loadingBarHeight = Engine.loadingBarImage.height;
        this.loadingBarX = this.loadingBorderLeftX + Engine.loadingBarBorderImages[0].width - Engine.scale(0, 5);
        this.loadingBarY = this.loadingBorderY + (this.loadingBorderHeight - this.loadingBarHeight) / 2;
        this.loadingBarWidth = 176 - 2 * this.loadingBarX;
        this.loadingBarBgLeftX = this.loadingBarX;
        this.loadingBarBgRightX = 176 - this.loadingBarBgLeftX;
        menuFormWidth = 176 - menuBorderWidth - 6;
    }

    public void setupLanguage() {
        this.setLanguageSelect();
    }

    private void initGameWorld() {
        Device.soundFunction(1);
        if (this.gameWorld != null) {
            this.gameWorld = null;
            GameObject.gameWorld = null;
            System.gc();
        }
        debugMsgs = null;
        debugAiIndex = 0;
        state = 100;
        new GameWorld();
        Engine.stopLoading();
    }

    private void loadRemainingMenuResources() {
        Engine.updateLoading(10);
        woodPanelImage = new DeviceImage(67);
        Engine.loadMenuResources(1);
        menuTopHeight = Engine.menuLogoImage.height;
        Engine.updateLoading(35);
        this.splashImage = new DeviceImage(ResourceMaster.getResourceFromJar("splash.png"));
        Engine.updateLoading(60);
        Device.soundFunction(0);
        Engine.updateLoading(70);
        this.initRMS();
        this.loadRMS(0);
        this.loadRMS(1);
        Engine.updateLoading(80);
        GameWorld.initArrays();
        Engine.updateLoading(95);
        this.initMapsMenu();
        Engine.updateLoading(100, true);
    }

    private void setBrand() {
        if (state != 5) {
            Engine.startLoading();
        }
        boolean bl = false;
        try {
            imgBrand = null;
            byte[] byArray = ResourceMaster.getResourceFromJar("brand" + brandIndex + ".png");
            if (byArray != null) {
                imgBrand = new DeviceImage(byArray);
            }
            if (imgBrand == null) {
                bl = true;
            }
            ++brandIndex;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = true;
        }
        if (bl) {
            this.closeBrand();
            this.setSplash();
        } else {
            if (state != 5) {
                state = 5;
                this.loadRemainingMenuResources();
                Engine.stopLoading();
            }
            if (imgBrand != null) {
                this.logicCounter = (int)System.currentTimeMillis();
            }
            Engine.releaseAllKeys();
        }
    }

    private void tickBrand() {
        if (Engine.key(16) || Engine.key(64)) {
            Engine.fadeOut(false, 3);
        } else if (!Engine.fading() && (int)System.currentTimeMillis() - this.logicCounter > 3000) {
            Engine.fadeOut(false, 3);
        }
    }

    private void closeBrand() {
        imgBrand = null;
    }

    private void paintBrand(Graphics graphics) {
        Engine.cls(graphics, 0);
        if (imgBrand != null) {
            imgBrand.drawImage(graphics, 176 - Engine.imgBrand.width >> 1, 208 - Engine.imgBrand.height >> 1);
        }
        Engine.paintTooltips(graphics, 8);
    }

    public static void cls(Graphics graphics, int n) {
        graphics.setColor(n);
        graphics.fillRect(graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), graphics.getClipHeight());
    }

    private void setSoundEnable() {
        trace = "Engine.setSoundEnable 1";
        try {
            Device.deviceFunction(1, text[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        trace = "Engine.setSoundEnable 2";
        if (!Device.USE_BITMAP_FONTS) {
            FontMgr.release(font);
            font = 1;
        }
        trace = "Engine.setSoundEnable 3";
        this.initMenus();
        trace = "Engine.setSoundEnable 4";
        Engine.setMenu(menuSound);
        Engine.menuCurrent.cursor = 1;
        trace = "Engine.setSoundEnable 5";
    }

    private void setSplash() {
        Engine.releaseAllKeys();
        state = 2;
        Device.soundFunction(3, new int[]{0});
    }

    private void tickSplash() {
        if (Engine.hasAnyKeyPressed()) {
            Engine.fadeOut(false, 4);
        }
    }

    private void paintSplash(Graphics graphics) {
        this.splashImage.drawImage(graphics, 0, 0);
        if (Demo.isEnabled()) {
            Engine.drawBox(graphics, 0, 0, 176, FontMgr.charHeight[font], -1728053248);
            FontMgr.drawString(font, graphics, Engine.getText(302), 88, 0, 17);
        }
        if (!Engine.fading() && (tick & 4) != 0) {
            FontMgr.drawString(font, graphics, Engine.getText(113), 88, 138, 3);
        }
    }

    private void closeSplash() {
        this.splashImage = null;
    }

    private void setLanguageSelect() {
        String string = Engine.getJadValue("ms-multiLang");
        if (string != null) {
            if (string.equals("1")) {
                try {
                    int n;
                    byte[] byArray = ResourceMaster.getResourceFromJar("multi.dat");
                    DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                    int n2 = dataInputStream.readInt();
                    String[] stringArray = new String[n2];
                    this.languageFiles = new String[n2];
                    for (n = 0; n < n2; ++n) {
                        stringArray[n] = dataInputStream.readUTF();
                    }
                    for (n = 0; n < n2; ++n) {
                        this.languageFiles[n] = dataInputStream.readUTF();
                    }
                    this.menuLanguage = new Menu(null, stringArray, 0);
                    Engine.setMenu(this.menuLanguage);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.initLanguage(string);
                this.setSoundEnable();
            }
        } else {
            this.initLanguage("lang.dat");
            this.setSoundEnable();
        }
    }

    private void closeLanguageSelect() {
        this.languageFiles = null;
    }

    private void initLanguage(String string) {
        Engine.startMemCheck("initLanguage");
        trace = "Engine.initLanguage 1";
        Engine.initText("/" + string);
        trace = "Engine.initLanguage 2";
        Demo.init(1);
        trace = "Engine.initLanguage 3";
        Engine.endMemCheck();
    }

    public static void paintTooltips(Graphics graphics, int n) {
        int n2 = 1;
        int n3 = 176 - Engine.tipsImages[0].width - 1;
        int n4 = 208 - Engine.tipsImages[0].height - 2;
        if ((n & 1) != 0) {
            tipsImages[1].drawImage(graphics, reverseTooltips ? n2 : n3, n4);
        } else if ((n & 4) != 0) {
            tipsImages[2].drawImage(graphics, reverseTooltips ? n2 : n3, n4);
        }
        if ((n & 2) != 0) {
            tipsImages[0].drawImage(graphics, reverseTooltips ? n3 : n2, n4);
        } else if ((n & 0x10) != 0) {
            tipsImages[3].drawImage(graphics, reverseTooltips ? n3 : n2, n4);
        }
    }

    private void initMenus() {
        String string;
        trace = text == null ? "Engine.initMenus 1 (text null)" : "Engine.initMenus 1";
        String[] stringArray = new String[]{Engine.getText(26), Engine.getText(27)};
        upsellMode = 0;
        Object object = Engine.getJadValue("ms-upSell");
        if (object != null) {
            upsellMode = Integer.valueOf((String)object);
        }
        if (upsellMode != 0) {
            string = Engine.getJadValue("ms-upSellUrl");
            String string2 = Engine.getText(306, new String[]{string});
            if (upsellMode == 1) {
                menuUpsell = Engine.createForm(text[305], string2, menuMain, null);
            }
        }
        trace = "Engine.initMenus 2";
        object = new Vector();
        if (Demo.isEnabled()) {
            ((Vector)object).addElement(Engine.getText(303));
            string = (String)Demo.getMenuOption(0);
            if (string != null) {
                ((Vector)object).insertElementAt(string, 0);
            }
            if (upsellMode != 0) {
                ((Vector)object).addElement(Engine.getText(305));
            }
        } else {
            ((Vector)object).addElement(Engine.getText(3));
            ((Vector)object).addElement(Engine.getText(4));
            if (upsellMode != 0) {
                ((Vector)object).addElement(Engine.getText(305));
            }
            ((Vector)object).addElement(Engine.getText(5));
        }
        ((Vector)object).addElement(Engine.getText(6));
        ((Vector)object).addElement(Engine.getText(7));
        ((Vector)object).addElement(Engine.getText(8));
        ((Vector)object).addElement(Engine.getText(9));
        closeGameWorldMenu = menuMain = new Menu(Demo.isEnabled() ? Engine.getText(302) : null, Engine.vectorToStringArray((Vector)object), 0);
        trace = "Engine.initMenus 3";
        ((Vector)object).removeAllElements();
        ((Vector)object).addElement(Engine.getText(11));
        ((Vector)object).addElement(Engine.getText(30));
        if (!Demo.isEnabled()) {
            ((Vector)object).addElement(Engine.getText(29));
        }
        ((Vector)object).addElement(Engine.getText(18));
        ((Vector)object).addElement(Engine.getText(6));
        ((Vector)object).addElement(Engine.getText(7));
        ((Vector)object).addElement(Engine.getText(2));
        menuInGame = new Menu(text[10], Engine.vectorToStringArray((Vector)object), 0);
        trace = "Engine.initMenus 4";
        menuSaveConfirm = new Menu(Engine.getText(17), stringArray, 1);
        menuRestartConfirmation = new Menu(Engine.getText(18), stringArray, 1);
        menuExit = new Menu(Engine.getText(9), stringArray, 1);
        menuEndGameConfirmation = new Menu(Engine.getText(16), stringArray, 1);
        menuSound = new Menu(text[25], stringArray, 0);
        menuGameOver = new Menu(Engine.getText(120), new String[]{Engine.getText(18), Engine.getText(2)}, 1);
        trace = "Engine.initMenus 5";
        ((Vector)object).removeAllElements();
        ((Vector)object).addElement(Engine.getText(41));
        ((Vector)object).addElement(Engine.getText(43));
        ((Vector)object).addElement(Engine.getText(45));
        ((Vector)object).addElement(Engine.getText(49));
        menuInstructions = new Menu(Engine.getText(7), Engine.vectorToStringArray((Vector)object), 1);
        trace = "Engine.initMenus 6";
        menuControls = new Menu(Engine.getText(97), new String[]{Engine.getText(35), Engine.getText(36)}, 0);
        menuDifficulty = new Menu(Engine.getText(22), new String[]{Engine.getText(23), Engine.getText(24)}, 1);
        trace = "Engine.initMenus 7";
        trace = "Engine.initMenus 8";
        this.initCheatMenu();
    }

    private void initCheatMenu() {
        String[] stringArray;
        String string = Engine.getText(297);
        if (this.gameWorld == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = Engine.getText(298) + ": " + unlockAllMissions;
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = Engine.getText(298) + ": " + unlockAllMissions;
            stringArray3[1] = Engine.getText(299) + ": " + showMap;
            stringArray3[2] = Engine.getText(300);
            stringArray = stringArray3;
            stringArray3[3] = Engine.getText(301);
        }
        menuCheat = new Menu(string, stringArray, 1);
    }

    private void initDebugFeaturesMenu() {
        menuDebugFeatures = new Menu("Drawing", new String[]{"base tiles: " + (debugDisableBaseTiles ? "off" : "on"), "tall tiles: " + (debugDisableTallTiles ? "off" : "on"), "objects: " + (debugDisableObjects ? "off" : "on"), "hud: " + (debugDisableHud ? "off" : "on"), "status: " + (debugDisableStatus ? "off" : "on")}, 1);
    }

    private void initCampaignMenu() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(Engine.getText(12));
        if (unlockAllMissions || gameUnlockedMission > 0) {
            vector.addElement(Engine.getText(13));
        }
        menuCampaign = new Menu(Engine.getText(3), Engine.vectorToStringArray(vector), 1);
    }

    public static void initMissionsMenu() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i <= (unlockAllMissions ? GameWorld.MISSIONS.length - 1 : gameUnlockedMission); ++i) {
            vector.addElement(Engine.getText(19, new String[]{"" + (i + 1)}));
        }
        if (menuMissions == null) {
            menuMissions = new Menu(Engine.getText(14), Engine.vectorToStringArray(vector), 1);
        } else {
            Engine.menuMissions.text = Engine.vectorToStringArray(vector);
        }
    }

    private void initMapsMenu() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < GameWorld.MAPS_N_PLAYERS.length; i += 2) {
            byte by = GameWorld.MAPS_N_PLAYERS[i];
            byte by2 = GameWorld.MAPS_N_PLAYERS[i + 1];
            vector.addElement(Engine.getText(208 + by + 1) + "");
        }
        menuSkirmishMaps = new Menu(Engine.getText(20), Engine.vectorToStringArray(vector), 1);
    }

    private void initSavesMenu() {
        String[] stringArray = new String[3];
        for (int i = 0; i < 3; ++i) {
            int[] nArray = SAVES_INFORMATION[i];
            stringArray[i] = nArray == null ? Engine.getText(15) : (nArray[0] == 0 ? Engine.getText(3) + " " + nArray[1] : Engine.getText(4)) + " " + Engine.fillZeros("" + nArray[2], 2) + ":" + Engine.fillZeros("" + nArray[3], 2) + ":" + Engine.fillZeros("" + nArray[4], 2);
        }
        if (menuSaves == null) {
            menuSaves = new Menu(Engine.getText(menuSavesSaving ? 29 : 5), stringArray, 1);
        } else {
            Engine.menuSaves.text = stringArray;
        }
    }

    private void initSettingsMenu() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(Engine.getText(soundOn ? 31 : 32));
        vector.addElement(Engine.getText(43) + ": " + Engine.getText(cursorNormal ? 35 : 36));
        vector.addElement(Engine.getText(tipsOn ? 37 : 38));
        menuSettings = new Menu(Engine.getText(6), Engine.vectorToStringArray(vector), 1);
    }

    public static void setMenu(Menu menu) {
        Engine.setMenu(menu, false, true);
    }

    public static void setMenu(Menu menu, boolean bl, boolean bl2) {
        if (menu == null) {
            System.out.println("setMenu() :: newMenu is set to null, aborting!");
            return;
        }
        Engine.releaseAllKeys();
        if (bl2 && menu.type != 0 && !menu.previousLock) {
            menu.previous = menuCurrent;
        }
        menuCurrent = menu;
        menuItemHeight = menu.type == 2 ? FontMgr.charHeight[font] : (int)Engine.menuBarImages[0].height;
        if (bl) {
            Engine.menuCurrent.cursor = 0;
            Engine.menuCurrent.startIndex = 0;
        }
        Engine.calculateMenuSpace(false);
        menuNVisible = Math.min(menuCurrent.length(), menuMaxNVisible);
        menuContentHeight = menuNVisible * (menuItemHeight + MENU_SPACING) - MENU_SPACING;
        menuWidth = menu.type == 2 ? menuFormWidth : 2 * Engine.menuBarImages[0].width;
        state = 10;
    }

    public static void calculateMenuSpace(boolean bl) {
        if (Engine.instance.gameWorld != null) {
            if (!bl) {
                // empty if block
            }
            menuTotalHeight = 208 - menuTopHeight;
        } else {
            menuTotalHeight = bl || menuLogoImage != null ? 208 - menuTopHeight : 208;
        }
        menuContentHeight = menuTotalHeight - menuBorderHeight - 2 * Engine.arrowVImages[0].height;
        menuMaxNVisible = (menuContentHeight + MENU_SPACING) / (menuItemHeight + MENU_SPACING);
    }

    public void paintMenu(Graphics graphics) {
        int n;
        Engine.saveAndSetClip(graphics, 0, 0, 176, 208);
        if (Demo.isEnabled() && Engine.menuCurrent.demoMenuAction != -1 && demoLogoImage != null) {
            Engine.cls(graphics, 0);
            demoLogoImage.drawImage(graphics, 88, 0, 17);
        } else if (Engine.instance.gameWorld == null) {
            if (menuLogoImage != null) {
                Engine.cls(graphics, 0);
                menuLogoImage.drawImage(graphics, 88, 0, 17);
            } else {
                Engine.cls(graphics, 0);
            }
        } else {
            Engine.instance.gameWorld.paint(graphics);
        }
        if (woodPanelImage == null) {
            Engine.cls(graphics, 0);
        } else {
            this.paintMenuBorders(graphics, 208 - menuTotalHeight);
        }
        if (Engine.menuCurrent.title != null) {
            n = menuCurrent == menuSound ? (208 - menuContentHeight) / 2 - 2 * FontMgr.charHeight[font] : 208 - menuTotalHeight + -2;
            FontMgr.drawString(font, graphics, Engine.menuCurrent.title, 88, n, 17);
        }
        n = (Engine.menuCurrent.align & 2) != 0 ? 208 - menuTotalHeight + (menuTotalHeight - menuContentHeight) / 2 : 208 - menuTotalHeight + menuBorderHeight / 2;
        int n2 = n;
        int n3 = Engine.menuCurrent.startIndex;
        for (int i = 0; n3 < menuCurrent.length() && i < menuNVisible; ++n3, ++i) {
            int n4;
            if (Engine.menuCurrent.type != 2) {
                if (menuBarImages.length == 4) {
                    n4 = n3 == Engine.menuCurrent.cursor ? 2 : 0;
                    menuBarImages[n4].drawImage(graphics, 88, n2, 24);
                    menuBarImages[n4 + 1].drawImage(graphics, 88, n2, 20);
                } else {
                    menuBarImages[0].drawImage(graphics, 88, n2, 24);
                    menuBarImages[1].drawImage(graphics, 88, n2, 20);
                    if (n3 == Engine.menuCurrent.cursor) {
                        graphics.setColor(0xFFFFFF);
                        graphics.drawRect(88 - Engine.menuBarImages[0].width, n2, 2 * Engine.menuBarImages[0].width - 1, Engine.menuBarImages[0].height - 1);
                    }
                }
            }
            n4 = (Engine.menuCurrent.align & 4) != 0 ? (176 - menuWidth) / 2 : 88;
            FontMgr.drawString(font, graphics, Engine.menuCurrent.text[n3], n4, n2 + menuItemHeight / 2, Engine.menuCurrent.align);
            n2 += menuItemHeight + MENU_SPACING;
        }
        if (Engine.menuCurrent.type == 2) {
            if (Engine.menuCurrent.startIndex > 0) {
                arrowVImages[0].drawImage(graphics, 88, n - 2, 33);
            }
            if (Engine.menuCurrent.startIndex < menuCurrent.length() - menuNVisible) {
                arrowVImages[1].drawImage(graphics, 88, n + menuContentHeight + 2, 17);
            }
        } else if (menuCurrent.length() > 1) {
            arrowVImages[0].drawImage(graphics, 88, n - 2, 33);
            arrowVImages[1].drawImage(graphics, 88, n + menuContentHeight + 2, 17);
        }
        if (!Engine.fading()) {
            if (Demo.isEnabled() && Engine.menuCurrent.demoMenuAction != -1) {
                Demo.paintToolTips(graphics);
            } else {
                n3 = 0;
                if (Engine.menuCurrent.previous != null || menuCurrent == menuInGame) {
                    n3 |= 1;
                }
                if (!(Engine.menuCurrent.next == null && Engine.menuCurrent.action == -1 && Engine.menuCurrent.type == 2 || !menuSavesSaving && menuCurrent == menuSaves && SAVES_INFORMATION[Engine.menuCurrent.cursor] == null)) {
                    n3 |= 2;
                }
                Engine.paintTooltips(graphics, n3);
            }
        }
        Engine.restoreClip(graphics);
    }

    public void paintMenuBorders(Graphics graphics, int n) {
        int n2;
        if (woodPanelImage != null) {
            for (n2 = n; n2 < 208; n2 += Engine.woodPanelImage.height) {
                Engine.drawImageWidth(graphics, woodPanelImage, 0, n2, 176);
            }
        }
        if (menuBorderImages != null) {
            for (n2 = (int)Engine.menuBorderImages[0].width; n2 < 176 - Engine.menuBorderImages[0].width; n2 += Engine.menuBorderImages[0].width) {
                menuBorderImages[4].drawImage(graphics, n2, n);
                menuBorderImages[5].drawImage(graphics, n2, 208, 36);
            }
            for (n2 = n + Engine.menuBorderImages[0].height; n2 < 208 - Engine.menuBorderImages[0].height; n2 += Engine.menuBorderImages[0].height) {
                menuBorderImages[6].drawImage(graphics, 0, n2);
                menuBorderImages[7].drawImage(graphics, 176, n2, 24);
            }
            menuBorderImages[0].drawImage(graphics, 0, n);
            menuBorderImages[1].drawImageAs(graphics, 176, n, 2, 24);
            menuBorderImages[2].drawImageAs(graphics, 0, 208, 1, 36);
            menuBorderImages[3].drawImageAs(graphics, 176, 208, 3, 40);
        }
    }

    public void tickMenu() {
        if (Engine.isPressedRepeat(1)) {
            --Engine.menuCurrent.cursor;
            if (Engine.menuCurrent.cursor < 0) {
                if (Engine.menuCurrent.type == 2) {
                    Engine.menuCurrent.cursor = 0;
                } else {
                    Engine.menuCurrent.cursor = menuCurrent.length() - 1;
                    Engine.menuCurrent.startIndex = Engine.menuCurrent.cursor - menuNVisible + 1;
                }
            } else if (Engine.menuCurrent.cursor < Engine.menuCurrent.startIndex) {
                --Engine.menuCurrent.startIndex;
            } else if (Engine.menuCurrent.type == 2) {
                --Engine.menuCurrent.startIndex;
            }
        } else if (Engine.isPressedRepeat(2)) {
            int n = menuCurrent.length();
            ++Engine.menuCurrent.cursor;
            if (Engine.menuCurrent.type == 2) {
                if (Engine.menuCurrent.cursor > n - menuNVisible) {
                    Engine.menuCurrent.cursor = n - menuNVisible;
                } else {
                    ++Engine.menuCurrent.startIndex;
                }
            } else if (Engine.menuCurrent.cursor > n - 1) {
                Engine.menuCurrent.cursor = 0;
                Engine.menuCurrent.startIndex = 0;
            } else if (Engine.menuCurrent.cursor > Engine.menuCurrent.startIndex + menuNVisible - 1) {
                ++Engine.menuCurrent.startIndex;
            }
        }
        if (Engine.key(16) || Engine.key(64)) {
            if (Demo.isEnabled() && Engine.menuCurrent.demoMenuAction != -1) {
                Demo.handleDemoMenuAction(Engine.menuCurrent.demoMenuAction);
            } else if (Engine.menuCurrent.action != -1) {
                this.handleMenuAction(Engine.menuCurrent.action);
            } else if (Engine.menuCurrent.next != null) {
                Engine.setMenu(Engine.menuCurrent.next, Engine.menuCurrent.next == menuMain, true);
                if (menuCurrent == menuMissions) {
                    Engine.menuCurrent.previous = menuCampaign;
                }
                if (Engine.menuCurrent.cursor < Engine.menuCurrent.startIndex) {
                    Engine.menuCurrent.startIndex = Engine.menuCurrent.cursor;
                } else if (Engine.menuCurrent.cursor > Engine.menuCurrent.startIndex + menuNVisible - 1) {
                    Engine.menuCurrent.startIndex = Engine.menuCurrent.cursor - menuNVisible + 1;
                }
            } else {
                this.menuAction(menuCurrent, Engine.menuCurrent.cursor);
            }
        } else if (Engine.key(128)) {
            if (Demo.isEnabled() && Engine.menuCurrent.demoMenuAction != -1) {
                Demo.handleDemoMenuBack(Engine.menuCurrent.demoMenuAction);
            } else {
                this.menuBack();
            }
        }
    }

    public void menuBack() {
        if (menuCurrent == menuSettings) {
            Engine.saveRMS(0);
        }
        if (Engine.menuCurrent.previous != null) {
            Engine.menuCurrent.cursor = 0;
            Engine.setMenu(Engine.menuCurrent.previous, false, false);
        } else if (menuCurrent == menuInGame) {
            state = 100;
            this.gameWorld.playMusic();
        }
    }

    public void handleMenuAction(int n) {
        Engine.echo("[Engine.handleMenuAction] " + n);
        switch (n) {
            case 0: {
                if (gameCurrentMode == 1) {
                    Engine.setMenu(menuMain, true, true);
                    break;
                }
                if (Demo.isEnabled() && ++gameCurrentMission >= 2) {
                    state = 40;
                    break;
                }
                Engine.fadeOut(false, 0);
                break;
            }
            case 1: {
                if (this.gameWorld.currentEvent != null && this.gameWorld.currentEvent[0] == 0) {
                    this.gameWorld.currentEvent = null;
                } else {
                    Engine.setMenu(menuInGame);
                }
                this.gameWorld.drawHud = true;
                state = 100;
                break;
            }
            case 2: {
                Engine.setMenu(menuGameOver, true, true);
                break;
            }
            case 3: {
                Engine.fadeOut(false, 0);
                break;
            }
            case 4: {
                Engine.setMenu(menuControls);
                break;
            }
            case 5: {
                state = 40;
            }
        }
    }

    private void menuAction(Menu menu, int n) {
        Object object;
        Object object2;
        if (menu == this.menuLanguage) {
            this.initLanguage(this.languageFiles[this.menuLanguage.cursor]);
            this.closeLanguageSelect();
            Engine.fadeOut(false, 2);
            return;
        }
        String string = menu.text[n];
        if (menu == menuSound) {
            if (string == Engine.getText(26)) {
                soundOn = true;
            } else if (string == Engine.getText(27)) {
                soundOn = false;
            }
            Engine.fadeOut(false, 3);
        }
        if (menu == menuMain) {
            if (string == Engine.getText(3)) {
                gameCurrentMode = 0;
                this.initCampaignMenu();
                Engine.setMenu(menuCampaign, true, true);
            } else if (string == Engine.getText(4)) {
                gameCurrentMode = 1;
                Engine.setMenu(menuSkirmishMaps, true, true);
            } else if (string == Engine.getText(5)) {
                menuSavesSaving = false;
                this.initSavesMenu();
                Engine.setMenu(menuSaves, true, true);
            } else if (string == Engine.getText(8)) {
                object2 = Engine.getJadValue("MIDlet-Version");
                if (object2 == null) {
                    object2 = "?";
                }
                Engine.setMenu(Engine.createForm(text[8], Engine.getText(39, new String[]{text[1], object2}), menu, null));
            } else if (string == Engine.getText(9)) {
                Engine.setMenu(menuExit);
                Engine.menuCurrent.cursor = 1;
            }
        }
        if (menu == menuExit) {
            if (string == Engine.getText(26)) {
                Engine.exit();
            } else if (string == Engine.getText(27)) {
                this.menuBack();
            }
        }
        if (menu == menuCampaign) {
            if (string == Engine.getText(12)) {
                gameCurrentMode = 0;
                gameCurrentMissionMode = 0;
                gameCurrentMission = 0;
                gameCurrentNSides = 2;
                Engine.setMenu(menuDifficulty);
                Engine.menuDifficulty.cursor = gameCurrentDifficulty;
            } else {
                gameCurrentMissionMode = 1;
                Engine.initMissionsMenu();
                Engine.setMenu(menuMissions, true, true);
            }
        }
        if (menu == menuSkirmishMaps) {
            gameCurrentMap = GameWorld.MAPS_N_PLAYERS[2 * n];
            gameCurrentMapMaxPlayers = GameWorld.MAPS_N_PLAYERS[2 * n + 1];
            gameCurrentTeams = new byte[]{0, 1};
            gameCurrentNSides = gameCurrentTeams.length;
            Engine.setMenu(menuDifficulty);
            Engine.menuDifficulty.cursor = gameCurrentDifficulty;
        }
        if (menuCurrent == menuGameOver) {
            if (string == Engine.getText(18)) {
                GameWorld.keepPositions = true;
                Engine.fadeOut(false, 0);
            } else if (string == Engine.getText(2)) {
                state = 40;
            }
        }
        if (menuCurrent == menuControls) {
            cursorNormal = n == 0;
            Engine.saveRMS(0);
            this.gameWorld.currentEvent = null;
            object2 = Engine.createForm(Engine.getText(88), Engine.getText(99), null, null);
            ((Menu)object2).action = 1;
            Engine.setMenu((Menu)object2, true, false);
        }
        if (string == Engine.getText(6)) {
            this.initSettingsMenu();
            Engine.setMenu(menuSettings);
        } else if (string == Engine.getText(7)) {
            Engine.setMenu(menuInstructions, true, true);
        }
        if (menu == menuInGame) {
            if (string == text[11]) {
                this.menuBack();
            } else if (string == Engine.getText(30)) {
                this.gameWorld.setObjectivesScreen();
            } else if (string == Engine.getText(29)) {
                menuSavesSaving = true;
                this.initSavesMenu();
                Engine.setMenu(menuSaves, true, true);
            } else if (string == Engine.getText(18)) {
                Engine.setMenu(menuRestartConfirmation);
                Engine.menuCurrent.cursor = 1;
            } else if (string == Engine.getText(2)) {
                Engine.setMenu(menuEndGameConfirmation);
                Engine.menuCurrent.cursor = 1;
            }
        }
        if (menu == menuEndGameConfirmation) {
            if (string == Engine.getText(26)) {
                state = 40;
            } else {
                this.menuBack();
            }
        }
        if (menu == menuRestartConfirmation) {
            if (string == Engine.getText(26)) {
                GameWorld.keepPositions = true;
                Engine.fadeOut(false, 0);
            } else {
                this.menuBack();
            }
        }
        if (menu == menuDifficulty) {
            gameCurrentDifficulty = n;
            if (gameCurrentMode == 1 && !GameWorld.keepPositions) {
                object2 = Engine.getText(122) + Engine.getText(208 + gameCurrentMap + 1) + "\n" + "" + Engine.getText(22) + ": " + Engine.getText(23 + gameCurrentDifficulty);
                object = Engine.createForm(Engine.getText(121), (String)object2, null, null);
                ((Menu)object).action = 3;
                Engine.setMenu((Menu)object);
            } else {
                Engine.fadeOut(false, 0);
            }
        }
        if (menu == menuSaves) {
            if (menuSavesSaving) {
                this.currentSaveSlot = n;
                if (SAVES_INFORMATION[this.currentSaveSlot] != null) {
                    Engine.setMenu(menuSaveConfirm);
                    Engine.menuCurrent.cursor = 1;
                } else {
                    this.save();
                }
            } else if (SAVES_INFORMATION[n] != null) {
                Engine.fadeOut(false, 1);
                fadeEventParams = new int[]{2 + n};
            }
        }
        if (menu == menuSaveConfirm) {
            if (string == Engine.getText(26)) {
                this.save();
            }
            this.menuBack();
        }
        if (menu == menuMissions) {
            gameCurrentMission = n;
            gameCurrentNSides = n == 14 ? 3 : 2;
            Engine.setMenu(menuDifficulty);
            Engine.menuDifficulty.cursor = gameCurrentDifficulty;
        }
        if (menu == menuSettings) {
            if (string == Engine.getText(31)) {
                soundOn = false;
                menu.updateItem(Engine.getText(32));
                Device.soundFunction(1);
            } else if (string == Engine.getText(32)) {
                soundOn = true;
                menu.updateItem(Engine.getText(31));
                if (this.gameWorld == null) {
                    Device.soundFunction(2);
                } else {
                    Device.soundFunction(3, new int[]{12});
                }
            } else if (string == Engine.getText(33)) {
                vibrateOn = false;
                menu.updateItem(Engine.getText(34));
            } else if (string == Engine.getText(34)) {
                vibrateOn = true;
                menu.updateItem(Engine.getText(33));
                Device.vibrate(50);
            } else if (string.endsWith(Engine.getText(35))) {
                cursorNormal = false;
                menu.updateItem(Engine.getText(43) + ": " + Engine.getText(36));
            } else if (string.endsWith(Engine.getText(36))) {
                cursorNormal = true;
                menu.updateItem(Engine.getText(43) + ": " + Engine.getText(35));
            } else if (string == Engine.getText(37)) {
                tipsOn = false;
                menu.updateItem(Engine.getText(38));
            } else if (string == Engine.getText(38)) {
                tipsOn = true;
                menu.updateItem(Engine.getText(37));
            }
        }
        if (menu == menuInstructions) {
            if (string == Engine.getText(49)) {
                object = new StringBuffer();
                for (int i = 50; i <= 55; ++i) {
                    String string2 = Engine.getText(i);
                    if (string2.length() <= 0) continue;
                    ((StringBuffer)object).append(string2);
                    if (i >= 55) continue;
                    ((StringBuffer)object).append("\n\n");
                }
                object2 = ((StringBuffer)object).toString();
            } else {
                object2 = Engine.getText(40 + 2 * n + 2);
            }
            Engine.setMenu(Engine.createForm(string, (String)object2, menu, null));
        }
        if (menu == menuCheat) {
            if (string.startsWith(Engine.getText(298))) {
                unlockAllMissions = !unlockAllMissions;
                menu.updateItem(Engine.getText(298) + ": " + unlockAllMissions);
            } else if (string.startsWith(Engine.getText(299))) {
                showMap = !showMap;
                menu.updateItem(Engine.getText(299) + ": " + showMap);
                this.gameWorld.sortObjects(false);
            } else if (string == Engine.getText(300)) {
                if (this.gameWorld != null) {
                    this.gameWorld.getClass();
                    this.gameWorld.addResources(0, new short[]{500, 500, 500});
                }
            } else if (string == Engine.getText(301) && this.gameWorld != null) {
                for (int i = 1; i < gameCurrentNSides; ++i) {
                    this.gameWorld.addResources(i, new short[]{500, 500, 500});
                }
            }
        }
        if (Demo.isEnabled()) {
            if (string == Engine.getText(303)) {
                gameCurrentMode = 0;
                gameCurrentMissionMode = 0;
                gameCurrentMission = 0;
                gameCurrentNSides = 2;
                gameCurrentDifficulty = 0;
                Demo.init(3);
            } else if (string == (String)Demo.getMenuOption(0)) {
                Demo.setMenuOption(0, null);
            }
            if (menu == (Menu)Demo.getMenuOption(1)) {
                Demo.setMenuOption(1, string);
            }
        }
        if (string == text[305]) {
            if (upsellMode == 2) {
                Engine.gotoUrl(Engine.getJadValue("ms-upSellUrl"));
            } else {
                Engine.setMenu(menuUpsell);
            }
        }
    }

    public static void gotoUrl(String string) {
        if (string != null) {
            try {
                Device.deviceFunction(0, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Engine.exit();
        }
    }

    public void save() {
        Engine.startLoading(3);
        int[] nArray = this.gameWorld.getTime();
        Engine.SAVES_INFORMATION[this.currentSaveSlot] = new int[]{gameCurrentMode, gameCurrentMission + 1, nArray[0], nArray[1], nArray[2]};
        Engine.saveRMS(1);
        this.gameWorld.save();
        Engine.saveRMS(2 + this.currentSaveSlot);
        Engine.echo("Game saved (" + GameWorld.saveData.length + " bytes)");
        GameWorld.saveData = null;
        this.initSavesMenu();
        Engine.startLoading(4);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Engine.stopLoading();
    }

    public static Menu createForm(String string, String string2, Menu menu, Menu menu2) {
        Menu menu3 = new Menu(string, Engine.getStrings(string2, menuFormWidth, font), 2);
        menu3.previous = menu;
        menu3.next = menu2;
        return menu3;
    }

    public void commandAction(Command command, Displayable displayable) {
    }

    public void initRMS() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)RMS_NAME, (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                for (int i = 0; i <= 4; ++i) {
                    Engine.saveRMS(i);
                }
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            System.out.println("initRMS() :: " + exception);
        }
    }

    public static boolean saveRMS(int n) {
        String string = RMS_NAME;
        int n2 = n;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            if (n2 == 0) {
                dataOutputStream.writeBoolean(firstPlay);
                dataOutputStream.writeBoolean(vibrateOn);
                dataOutputStream.writeBoolean(cursorNormal);
                dataOutputStream.writeBoolean(tipsOn);
                dataOutputStream.writeByte(gameCurrentDifficulty);
                Engine.writeBooleanArray(tipsSeen, dataOutputStream);
                dataOutputStream.writeByte(gameUnlockedMission);
            } else if (n2 == 1) {
                for (int i = 0; i < 3; ++i) {
                    boolean bl = SAVES_INFORMATION[i] != null;
                    dataOutputStream.writeBoolean(bl);
                    if (!bl) continue;
                    for (int j = 0; j < 5; ++j) {
                        dataOutputStream.writeInt(SAVES_INFORMATION[i][j]);
                    }
                }
            } else if (n2 >= 2 && GameWorld.saveData != null) {
                dataOutputStream.writeShort(GameWorld.saveData.length);
                ((OutputStream)dataOutputStream).write(GameWorld.saveData);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            byteArrayOutputStream.close();
            if (recordStore.getNumRecords() <= n) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(n + 1, byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            System.out.println("saveRMS(" + n + ") :: " + exception);
            return false;
        }
        return true;
    }

    public void loadRMS(int n) {
        String string = RMS_NAME;
        int n2 = n;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            if (recordStore.getNumRecords() > n) {
                byte[] byArray = recordStore.getRecord(n + 1);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                if (n2 == 0) {
                    firstPlay = dataInputStream.readBoolean();
                    vibrateOn = dataInputStream.readBoolean();
                    cursorNormal = dataInputStream.readBoolean();
                    tipsOn = dataInputStream.readBoolean();
                    gameCurrentDifficulty = dataInputStream.readByte();
                    tipsSeen = Engine.readBooleanArray(dataInputStream);
                    gameUnlockedMission = dataInputStream.readByte();
                } else if (n2 == 1) {
                    for (int i = 0; i < 3; ++i) {
                        boolean bl = dataInputStream.readBoolean();
                        if (!bl) continue;
                        Engine.SAVES_INFORMATION[i] = new int[5];
                        for (int j = 0; j < 5; ++j) {
                            Engine.SAVES_INFORMATION[i][j] = dataInputStream.readInt();
                        }
                    }
                } else if (n2 >= 2) {
                    short s = dataInputStream.readShort();
                    GameWorld.saveData = new byte[s];
                    dataInputStream.readFully(GameWorld.saveData);
                }
                dataInputStream.close();
                byteArrayInputStream.close();
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            System.out.println("loadRMS(" + n + ") :: " + exception);
        }
    }

    private static void deleteRMS(String string) {
        try {
            RecordStore.deleteRecordStore((String)string);
        }
        catch (Exception exception) {
            System.out.println("deleteRMS(" + string + ") :: " + exception);
        }
    }

    public static void initText(String string) {
        try {
            InputStream inputStream = null;
            DataInputStream dataInputStream = null;
            inputStream = instance.getClass().getResourceAsStream(string);
            dataInputStream = new DataInputStream(inputStream);
            text = new String[dataInputStream.readInt()];
            for (int i = 0; i < text.length; ++i) {
                Engine.text[i] = dataInputStream.readUTF();
            }
        }
        catch (Exception exception) {
            System.out.println("initText(" + string + ") :: " + exception);
            Engine.debugWrite("ERROR: initText(" + string + ") :: " + exception, true);
        }
    }

    public static String getText(int n) {
        if (n < text.length) {
            return text[n];
        }
        return "No text: " + n;
    }

    public static String getText(int n, String[] stringArray) {
        String string = new String(Engine.getText(n));
        if (stringArray.length == 1) {
            string = Engine.replaceText(string, "%U", stringArray[0]);
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                string = Engine.replaceText(string, "%U", stringArray[i]);
            }
        }
        return string;
    }

    public static String replaceText(String string, String string2, String string3) {
        String string4 = "";
        int n = 0;
        n = string.indexOf(string2);
        string4 = n != -1 ? string.substring(0, n) + string3 + string.substring(n + string2.length()) : string;
        return string4;
    }

    public static String[] getStrings(String string, int n, int n2) {
        int n3;
        Vector<String> vector = new Vector<String>();
        int n4 = 0;
        int n5 = string.length();
        String string2 = null;
        do {
            n3 = n4;
            int n6 = string.indexOf(10, n3);
            block1: do {
                int n7 = n3;
                String string3 = string2;
                n3 = Engine.getWordIndex(string, n3);
                if (n6 > -1 && n6 < n3) {
                    n3 = n6;
                }
                if (FontMgr.stringWidth(n2, string2 = string.substring(n4, n3).trim()) <= n) continue;
                if (n7 == n4) {
                    for (int i = string2.length() - 1; i > 0; --i) {
                        String string4 = string2.substring(0, i);
                        if (FontMgr.stringWidth(n2, string4) > n) continue;
                        n3 = n7 + i;
                        string2 = string4;
                        break block1;
                    }
                    break;
                }
                n3 = n7;
                string2 = string3;
                break;
            } while (n3 != n6 && n3 < n5);
            vector.addElement(string2);
        } while ((n4 = ++n3) < n5);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static int getWordIndex(String string, int n) {
        int n2;
        char c = string.charAt(n);
        if (Engine.charIsWord(c)) {
            return n + 1;
        }
        int n3 = 0;
        while ((n2 = string.indexOf(32, n)) == 0) {
            ++n;
        }
        n3 = n2;
        n3 = n3 == -1 ? string.length() : ++n3;
        for (n2 = n + 1; n2 < n3; ++n2) {
            if (!Engine.charIsWord(string.charAt(n2))) continue;
            return n2;
        }
        return n3;
    }

    private static boolean charIsWord(int n) {
        return n >= 11904 && n < 44032 || n >= 63744 && n < 64256 || n >= 65280 && n < 65504;
    }

    public static String getJadValue(String string) {
        String string2 = parent.getAppProperty(string);
        return string2 != null ? string2.trim() : null;
    }

    public static int rnd(int n) {
        return random.nextInt() % n;
    }

    public static int rndPositive(int n) {
        return Math.abs(random.nextInt() % n);
    }

    public static void paintDebug(Graphics graphics) {
        if (debugMsgs == null) {
            return;
        }
        Font font = graphics.getFont();
        Font font2 = Font.getFont((int)0, (int)0, (int)8);
        graphics.setFont(font2);
        graphics.setClip(0, 0, 176, 208);
        int n = 5;
        int n2 = debugMsgTop;
        for (int i = 0; i < debugMsgs.length; ++i) {
            String string = debugMsgs[n2];
            if (string != null) {
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(2, n - 1, font2.stringWidth(string) + 2, font2.getHeight() + 2);
                graphics.setColor(0);
                graphics.drawString(string, 5, n, 20);
                n += graphics.getFont().getHeight();
            }
            if (++n2 != debugMsgs.length) continue;
            n2 = 0;
        }
        graphics.setFont(font);
    }

    public static void debugWrite(String string, boolean bl) {
        if (string == null) {
            string = "(null)";
        }
        System.out.println("DEBUG> " + string);
        Font font = Font.getFont((int)0, (int)0, (int)8);
        if (debugMsgs == null) {
            debugMsgs = new String[208 / (font.getHeight() + 2)];
        }
        while (string.length() > 0) {
            int n;
            for (n = 0; n < string.length() && font.stringWidth(string.substring(0, n + 1)) < 172; ++n) {
            }
            Engine.debugMsgs[Engine.debugMsgTop] = string.substring(0, n);
            debugMsgTop = (debugMsgTop + 1) % debugMsgs.length;
            string = string.substring(n);
        }
    }

    public static String getFreeMemory() {
        System.gc();
        return (Runtime.getRuntime().freeMemory() >> 10) + " K";
    }

    public static String getTotalMemory() {
        return (Runtime.getRuntime().totalMemory() >> 10) + " K";
    }

    public static boolean isPressed(int n) {
        return (keysPressed & n) != 0;
    }

    public static boolean isPressedRepeat(int n) {
        if (keyRepeatTimeout == 0) {
            boolean bl = Engine.isPressed(n);
            if (bl) {
                if (blah) {
                    keyRepeatTimeout = 400;
                    blah = false;
                } else {
                    keyRepeatTimeout = 80;
                }
            }
            return bl;
        }
        return false;
    }

    public static boolean key(int n) {
        if ((keyLatch & n) != 0) {
            keyLatch = 0;
            return true;
        }
        return false;
    }

    public static boolean hasAnyKeyPressed() {
        if (keyLatch != 0) {
            keyLatch = 0;
            return true;
        }
        return false;
    }

    public static void resetKeyBuffers() {
        keyUnmapped = 0;
        keyLatch = 0;
    }

    public static void releaseAllKeys() {
        keysPressed = 0;
        keyLatch = 0;
        keyRepeatTimeout = 0;
        blah = false;
    }

    public synchronized void keyPressed(int n) {
        try {
            int n2 = this.getKeyMap(n);
            keysPressed |= n2;
            lastKeyPressed = n2;
            keyLatch |= n2;
            keyUnmapped = n;
            blah = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Engine.debugWrite("Ex in keyPressed: " + exception.toString(), true);
        }
    }

    public synchronized void keyReleased(int n) {
        try {
            int n2 = this.getKeyMap(n);
            keysPressed &= ~n2;
            keyRepeatTimeout = 0;
            blah = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Engine.debugWrite("Ex in keyReleased: " + exception.toString(), true);
        }
    }

    public static void doRepaint() {
        instance.repaint();
        instance.serviceRepaints();
    }

    private void handleEvent() {
        handleEvent = false;
        Engine.resetKeyBuffers();
        if (state != 4 && loadingState == 0) {
            Device.soundFunction(1);
            if (text != null) {
                pauseState = state;
                state = 4;
            }
        }
        if (this.gameWorld != null) {
            this.gameWorld.hideNotify();
        }
    }

    public static byte[] insertPLTE(byte[] byArray, byte[] byArray2) {
        int n;
        int n2 = 37;
        for (n = 0; n < byArray.length - 4; ++n) {
            if (byArray[n] != 80 || byArray[n + 1] != 76 || byArray[n + 2] != 84 || byArray[n + 3] != 69) continue;
            n2 = n;
            break;
        }
        n = n2 - 4;
        int n3 = ((byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF) & 0xFFFFFFFF;
        byte[] byArray3 = new byte[byArray.length - (n3 += 12) + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        System.arraycopy(byArray2, 0, byArray3, n, byArray2.length);
        System.arraycopy(byArray, n + n3, byArray3, n + byArray2.length, byArray.length - (n + n3));
        return byArray3;
    }

    public static int scale(int n, int n2) {
        if (SCALE_VALUES[n] == 'd') {
            return n2;
        }
        return SCALE_VALUES[n] * n2 / 100;
    }

    public static int[] addToArray(int[] nArray, int[] nArray2, boolean bl) {
        bl = bl && nArray.length > 0;
        int[] nArray3 = nArray;
        int[] nArray4 = new int[nArray.length + nArray2.length];
        if (bl) {
            System.arraycopy(nArray3, 0, nArray4, nArray2.length, nArray3.length);
        } else {
            System.arraycopy(nArray3, 0, nArray4, 0, nArray3.length);
        }
        for (int i = 0; i < nArray2.length; ++i) {
            if (bl) {
                nArray4[i] = nArray2[i];
                continue;
            }
            nArray4[nArray.length + i] = nArray2[i];
        }
        return nArray4;
    }

    public static int[] removeFromArray(int[] nArray, int n, boolean bl) {
        int[] nArray2 = new int[nArray.length - n];
        System.arraycopy(nArray, bl ? n : 0, nArray2, 0, nArray2.length);
        return nArray2;
    }

    public static int[] removeFromArray(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
        int[] nArray3 = new int[Math.max(0, nArray.length - n2 - 1)];
        System.arraycopy(nArray, n2 + 1, nArray3, 0, nArray3.length);
        int[] nArray4 = new int[nArray.length - (n2 - n) - 1];
        System.arraycopy(nArray2, 0, nArray4, 0, nArray2.length);
        System.arraycopy(nArray3, 0, nArray4, nArray2.length, nArray3.length);
        return nArray4;
    }

    public static int[] vectorToIntArray(Vector vector) {
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.elementAt(i);
        }
        return nArray;
    }

    public static String[] vectorToStringArray(Vector vector) {
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static void echo(String string) {
        System.out.println(string);
    }

    public static void echo(int n) {
        Engine.echo("" + n);
    }

    public static void startMemCheck(String string) {
        currentMemMsg = string;
        Runtime.getRuntime().gc();
        currentMem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        Engine.echo("[startMemCheck] " + string + ": " + currentMem);
    }

    public static void endMemCheck() {
        Runtime.getRuntime().gc();
        long l = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        Engine.echo("[endMemCheck] " + currentMemMsg + ": " + l + " (" + (l - currentMem) + " increase)");
    }

    public static void instantMemCheck(String string) {
        Runtime.getRuntime().gc();
        long l = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        Engine.echo("[instantMemCheck] " + string + ": " + l);
    }

    public static void startLoading() {
        if (loadingTextStrings != null) {
            loadingTextStrings = null;
        }
        Engine.startLoading(1);
    }

    public static void startLoadingWithTip() {
        String string;
        while ((string = Engine.getText(50 + Engine.rndPositive(6))).length() == 0) {
        }
        loadingTextStrings = Engine.getStrings(string, 176 - menuBorderWidth, font);
        Engine.startLoading(1);
    }

    public static void startLoading(int n) {
        Device.soundFunction(1, null);
        loadingState = n;
        loadingProgress = 0;
        loadingProgressDisplay = 0;
        if (Engine.instance.gameWorld != null) {
            Engine.instance.gameWorld.hideNotify();
        }
        Engine.doRepaint();
    }

    public static void updateLoading(int n) {
        Engine.updateLoading(n, false);
    }

    public static void updateLoading(int n, boolean bl) {
        if (!bl) {
            loadingProgressDisplay = loadingProgress;
        }
        loadingProgress = n;
        if (bl) {
            loadingProgressDisplay = loadingProgress;
        }
        Engine.doRepaint();
    }

    public static void tickLoading() {
        if (loadingProgressDisplay < loadingProgress) {
            ++loadingProgressDisplay;
            Engine.doRepaint();
        }
    }

    public static void stopLoading() {
        loadingState = loadingTextStrings != null ? 2 : 0;
        Engine.releaseAllKeys();
        ResourceMaster.closeResource();
        lastTick = System.currentTimeMillis();
    }

    public static int cap(int n, int n2) {
        if (n < 0) {
            return Math.max(n, -n2);
        }
        if (n > 0) {
            return Math.min(n, n2);
        }
        return n;
    }

    public static String fillZeros(String string, int n) {
        if (string.length() < n) {
            int n2 = n - string.length();
            for (int i = 0; i < n2; ++i) {
                string = "0" + string;
            }
        }
        return string;
    }

    public static byte[] initByteArray(DataInputStream dataInputStream) throws Exception {
        return Engine.initByteArray(dataInputStream, false);
    }

    public static byte[] initByteArray(DataInputStream dataInputStream, boolean bl) throws Exception {
        int n = bl ? dataInputStream.readShort() : (int)dataInputStream.readByte();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = dataInputStream.readByte();
        }
        return byArray;
    }

    public static byte[][] initByte2Array(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readByte();
        byte[][] byArrayArray = new byte[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readByte();
            if (n2 <= 0) continue;
            byArrayArray[i] = new byte[n2];
            for (int j = 0; j < n2; ++j) {
                byArrayArray[i][j] = dataInputStream.readByte();
            }
        }
        return byArrayArray;
    }

    public static int[] initIntArray(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readInt();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = dataInputStream.readInt();
        }
        return nArray;
    }

    public static short[] initShortArray(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readShort();
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = dataInputStream.readShort();
        }
        return sArray;
    }

    public static short[][] initShort2Array(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readShort();
        short[][] sArrayArray = new short[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readShort();
            if (n2 <= 0) continue;
            sArrayArray[i] = new short[n2];
            for (int j = 0; j < n2; ++j) {
                sArrayArray[i][j] = dataInputStream.readShort();
            }
        }
        return sArrayArray;
    }

    public static int[][] initInt2Array(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readInt();
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readInt();
            if (n2 <= 0) continue;
            nArrayArray[i] = new int[n2];
            for (int j = 0; j < n2; ++j) {
                nArrayArray[i][j] = dataInputStream.readInt();
            }
        }
        return nArrayArray;
    }

    public static int getMapping(byte[] byArray, int n) {
        for (int i = 0; i < byArray.length; i += 2) {
            if (n != byArray[i]) continue;
            return byArray[i + 1];
        }
        return -1;
    }

    public static short getMapping(short[] sArray, int n) {
        for (int i = 0; i < sArray.length; i += 2) {
            if (n != sArray[i]) continue;
            return sArray[i + 1];
        }
        return -1;
    }

    public static int getMappingReversed(byte[] byArray, int n) {
        for (int i = 0; i < byArray.length; i += 2) {
            if (n != byArray[i + 1]) continue;
            return byArray[i];
        }
        return -1;
    }

    public static int getMapping(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; i += 2) {
            if (!string.equals(stringArray[i])) continue;
            return Integer.parseInt(stringArray[i + 1]);
        }
        return -1;
    }

    public static byte[] fromVectorToByteArray(Vector vector) {
        byte[] byArray = new byte[vector.size()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (Byte)vector.elementAt(i);
        }
        return byArray;
    }

    public static short[] fromVectorToShortArray(Vector vector) {
        short[] sArray = new short[vector.size()];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (Short)vector.elementAt(i);
        }
        return sArray;
    }

    public static int[] fromVectorToIntArray(Vector vector) {
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.elementAt(i);
        }
        return nArray;
    }

    public static String[] fromVectorToStringArray(Vector vector) {
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static byte[][] fromVectorsToByteArrays(Vector vector) {
        byte[][] byArrayArray = new byte[vector.size()][];
        for (int i = 0; i < byArrayArray.length; ++i) {
            Object e = vector.elementAt(i);
            if (e == null) continue;
            Vector vector2 = (Vector)e;
            byArrayArray[i] = new byte[vector2.size()];
            for (int j = 0; j < byArrayArray[i].length; ++j) {
                byArrayArray[i][j] = (Byte)vector2.elementAt(j);
            }
        }
        return byArrayArray;
    }

    public static int getIndexInArray(byte[] byArray, int n) {
        for (int i = 0; i < byArray.length; ++i) {
            if (n != byArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static int getIndexInArray(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static int mul(int n, int n2) {
        return (n >> 4) * (n2 >> 4);
    }

    public static int div(int n, int n2) {
        int n3 = n2 >> 8 == 0 ? n : (n << 8) / n2;
        return n3;
    }

    public static void writeIntArray(int[] nArray, DataOutputStream dataOutputStream) throws Exception {
        if (nArray == null) {
            dataOutputStream.writeByte(-1);
        } else {
            dataOutputStream.writeByte(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                dataOutputStream.writeInt(nArray[i]);
            }
        }
    }

    public static void writeShortArray(short[] sArray, DataOutputStream dataOutputStream) throws Exception {
        if (sArray == null) {
            dataOutputStream.writeByte(-1);
        } else {
            dataOutputStream.writeByte(sArray.length);
            for (int i = 0; i < sArray.length; ++i) {
                dataOutputStream.writeShort(sArray[i]);
            }
        }
    }

    public static void writeInt2Array(int[][] nArray, DataOutputStream dataOutputStream) throws Exception {
        if (nArray == null) {
            dataOutputStream.writeByte(-1);
        } else {
            dataOutputStream.writeByte(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == null) {
                    dataOutputStream.writeByte(-1);
                    continue;
                }
                Engine.writeIntArray(nArray[i], dataOutputStream);
            }
        }
    }

    public static void writeBooleanArray(boolean[] blArray, DataOutputStream dataOutputStream) throws Exception {
        if (blArray == null) {
            dataOutputStream.writeShort(-1);
        } else {
            dataOutputStream.writeShort(blArray.length);
            for (int i = 0; i < blArray.length; ++i) {
                dataOutputStream.writeBoolean(blArray[i]);
            }
        }
    }

    public static void writeObjectArray(GameObject[] gameObjectArray, DataOutputStream dataOutputStream) throws Exception {
        if (gameObjectArray == null) {
            dataOutputStream.writeByte(-1);
        } else {
            dataOutputStream.writeByte(gameObjectArray.length);
            for (int i = 0; i < gameObjectArray.length; ++i) {
                dataOutputStream.writeShort(gameObjectArray[i] == null ? -1 : gameObjectArray[i].id);
            }
        }
    }

    public static int[] readIntArray(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readByte();
        if (n == -1) {
            return null;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = dataInputStream.readInt();
        }
        return nArray;
    }

    public static short[] readShortArray(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readByte();
        if (n == -1) {
            return null;
        }
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = dataInputStream.readShort();
        }
        return sArray;
    }

    public static int[][] readInt2Array(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readByte();
        if (n == -1) {
            return null;
        }
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readByte();
            if (n2 == -1) continue;
            nArrayArray[i] = new int[n2];
            for (int j = 0; j < n2; ++j) {
                nArrayArray[i][j] = dataInputStream.readInt();
            }
        }
        return nArrayArray;
    }

    public static boolean[] readBooleanArray(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readShort();
        if (n == -1) {
            return null;
        }
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = dataInputStream.readBoolean();
        }
        return blArray;
    }

    public static GameObject[] readObjectArray(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readByte();
        if (n == -1) {
            return null;
        }
        GameObject[] gameObjectArray = new GameObject[n];
        for (int i = 0; i < n; ++i) {
            short s = dataInputStream.readShort();
            if (s == -1) continue;
            gameObjectArray[i] = new GameObject(s, 0);
        }
        return gameObjectArray;
    }

    public static void writeByteArray(byte[] byArray, DataOutputStream dataOutputStream) throws Exception {
        if (byArray == null) {
            dataOutputStream.writeShort(-1);
        } else {
            dataOutputStream.writeShort(byArray.length);
            ((OutputStream)dataOutputStream).write(byArray);
        }
    }

    public static byte[] readByteArray(DataInputStream dataInputStream) throws Exception {
        short s = dataInputStream.readShort();
        if (s == -1) {
            return null;
        }
        byte[] byArray = new byte[s];
        dataInputStream.readFully(byArray);
        return byArray;
    }

    public static void exit() {
        running = false;
    }

    public static void fadeOut(boolean bl, int n) {
        if (bl) {
            fadeState = 3;
            fadeEvent = n;
        } else {
            fadeStep = 0;
            fadeState = 2;
            fadeEvent = n;
        }
    }

    public static void fadeIn(boolean bl) {
        if (bl) {
            fadeState = 0;
        } else {
            fadeStep = 0;
            fadeState = 1;
        }
        fadeEvent = -1;
    }

    public static void tickFade() {
        if (fadeState == 1 || fadeState == 2) {
            if (fadeStep > -1) {
                Engine.releaseAllKeys();
                if (fadeState == 1) {
                    fadeState = 0;
                } else if (fadeState == 2) {
                    fadeState = 3;
                    instance.handleFadeEvent(3, fadeEvent);
                    Engine.fadeIn(false);
                }
                return;
            }
            ++fadeStep;
            if (Engine.instance.gameWorld != null) {
                Engine.instance.gameWorld.drawHud = true;
            }
        }
    }

    public static boolean fading() {
        return fadeState != 0;
    }

    public void handleFadeEvent(int n, int n2) {
        if (n2 >= 5) {
            this.gameWorld.handleFadeEvent(n2);
        } else {
            Engine.echo("[Engine.handeFadeEvent] " + n2);
            switch (n2) {
                case 0: {
                    if (gameCurrentMode == 0) {
                        startingCampaignMission = true;
                    }
                    Engine.startLoadingWithTip();
                    this.initGameWorld();
                    break;
                }
                case 1: {
                    Engine.startLoadingWithTip();
                    Engine.echo("Loading slot " + fadeEventParams[0]);
                    this.loadRMS(fadeEventParams[0]);
                    if (GameWorld.saveData == null) {
                        Engine.echo("null save data");
                    }
                    Engine.echo("Loading game (" + GameWorld.saveData.length + " bytes)");
                    this.initGameWorld();
                    GameWorld.saveData = null;
                    break;
                }
                case 2: {
                    this.setSoundEnable();
                    break;
                }
                case 3: {
                    this.setBrand();
                    break;
                }
                case 4: {
                    this.closeSplash();
                    Engine.setMenu(menuMain);
                }
            }
        }
    }

    public void drawFade(Graphics graphics) {
        Engine.saveAndSetClip(graphics, 0, 0, 176, 208);
        if (fadeState == 3) {
            Engine.cls(graphics, 0);
        } else if (fadeState == 1 || fadeState == 2) {
            Device.drawFadeEffect(graphics);
        }
        Engine.restoreClip(graphics);
    }

    public static int getColor(int n, int n2, int n3, int n4) {
        if (n3 <= 0) {
            return n;
        }
        if (n3 >= n4) {
            return n2;
        }
        int n5 = n >> 16 & 0xFF;
        int n6 = n >> 8 & 0xFF;
        int n7 = n & 0xFF;
        int n8 = n2 >> 16 & 0xFF;
        int n9 = n2 >> 8 & 0xFF;
        int n10 = n2 & 0xFF;
        return (n8 - n5) * n3 / n4 + n5 << 16 | (n9 - n6) * n3 / n4 + n6 << 8 | (n10 - n7) * n3 / n4 + n7;
    }

    public static void drawBox(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Device.drawARGBRect(graphics, n5, n, n2, n3, n4);
    }

    public static void saveAndSetClip(Graphics graphics, int n, int n2, int n3, int n4) {
        Engine.saveClip(graphics);
        graphics.setClip(n, n2, n3, n4);
    }

    public static void saveAndClipRect(Graphics graphics, int n, int n2, int n3, int n4) {
        Engine.saveClip(graphics);
        graphics.clipRect(n, n2, n3, n4);
    }

    public static void saveClip(Graphics graphics) {
        clipX = graphics.getClipX();
        clipY = graphics.getClipY();
        clipW = graphics.getClipWidth();
        clipH = graphics.getClipHeight();
    }

    public static void restoreClip(Graphics graphics) {
        graphics.setClip(clipX, clipY, clipW, clipH);
    }

    public static void loadMenuBorderImages() {
    }

    public static void loadMenuResources(int n) {
        if (n != 0) {
            if (n == 2) {
                // empty if block
            }
        } else {
            menuBarImages = new DeviceImage[4];
            DeviceImage[] deviceImageArray = new DeviceImage(57).divide(2);
            Engine.menuBarImages[0] = deviceImageArray[0];
            Engine.menuBarImages[1] = new DeviceImage(deviceImageArray[0], 2);
            Engine.menuBarImages[2] = deviceImageArray[1];
            Engine.menuBarImages[3] = new DeviceImage(deviceImageArray[1], 2);
        }
        if (n == 2) {
            Engine.updateLoading(50);
        }
        if (n == 1 || n == 2) {
            menuLogoImage = new DeviceImage(59);
        }
        if (n == 2) {
            Engine.updateLoading(100, true);
        }
    }

    public static void unloadMenuResources() {
        menuLogoImage = null;
        System.gc();
    }

    static {
        debugTimeStamp = null;
        debugMode = -1;
        lastSound = -1;
        vibrateOn = false;
        soundOn = true;
        tipsOn = true;
        cursorNormal = true;
        firstPlay = true;
        random = new Random();
        font = 0;
        state = -1;
        tipsSeen = new boolean[2];
        MENU_SPACING = Math.max(1, Engine.scale(0, 2));
        SAVES_INFORMATION = new int[3][];
    }
}

