/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DeviceImage
implements Constants {
    public static final boolean USE_CLIPPING = false;
    public Image image;
    private int manipulation = 0;
    private int clip_x;
    private int clip_y;
    public short width;
    public short height;
    static Hashtable rotatedCache = new Hashtable();

    public DeviceImage() {
    }

    public DeviceImage(byte[] byArray) {
        this.createImage(byArray);
    }

    public DeviceImage(int n) {
        this.createImage(ResourceMaster.getResource(n));
    }

    private void createImage(byte[] byArray) {
        try {
            this.image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
            this.width = (short)this.image.getWidth();
            this.height = (short)this.image.getHeight();
        }
        catch (Exception exception) {
            System.out.println("DeviceImage :: Error loading " + byArray);
            System.out.println(exception);
        }
    }

    public DeviceImage(DeviceImage deviceImage, int n, int n2, int n3, int n4) {
        this.width = (short)n3;
        this.height = (short)n4;
        this.image = deviceImage.image;
        this.clip_x = n;
        this.clip_y = n2;
    }

    public DeviceImage(DeviceImage deviceImage, int n) {
        this.image = deviceImage.image;
        this.width = deviceImage.width;
        this.height = deviceImage.height;
        this.clip_x = deviceImage.clip_x;
        this.clip_y = deviceImage.clip_y;
        this.manipulation = n;
    }

    public DeviceImage[] divide(int n) {
        int n2 = this.width / n;
        short s = this.height;
        return this.divide(n2, s);
    }

    public DeviceImage[] divide(int n, int n2) {
        int n3 = this.width / n;
        int n4 = this.height / n2;
        DeviceImage[] deviceImageArray = new DeviceImage[n4 * n3];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                deviceImageArray[n5++] = new DeviceImage(this, j * n, i * n2, n, n2);
            }
        }
        return deviceImageArray;
    }

    public void drawImage(Graphics graphics, int n, int n2) {
        this.drawImage(graphics, n, n2, 20);
    }

    public void drawImage(Graphics graphics, int n, int n2, int n3) {
        if (this.manipulation == 0) {
            graphics.drawRegion(this.image, this.clip_x, this.clip_y, (int)this.width, (int)this.height, 0, n, n2, n3);
        } else {
            Image image = null;
            String string = new String(this.image.hashCode() + "/" + this.manipulation);
            image = (Image)rotatedCache.get(string);
            if (image == null) {
                image = Image.createImage((Image)this.image, (int)0, (int)0, (int)this.image.getWidth(), (int)this.image.getHeight(), (int)this.manipulation);
                rotatedCache.put(string, image);
            }
            int n4 = 0;
            int n5 = 0;
            short s = 0;
            int n6 = 0;
            switch (this.manipulation) {
                case 0: {
                    n4 = this.clip_x;
                    n5 = this.clip_y;
                    s = this.width;
                    n6 = this.height;
                    break;
                }
                case 5: {
                    n4 = this.clip_y;
                    n5 = this.clip_x;
                    s = this.height;
                    n6 = this.width;
                    break;
                }
                case 3: {
                    n4 = this.image.getWidth() - (this.clip_x + this.width);
                    n5 = this.image.getHeight() - (this.clip_y + this.height);
                    s = this.width;
                    n6 = this.height;
                    break;
                }
                case 6: {
                    n5 = this.image.getWidth() - (this.clip_x + this.width);
                    n4 = this.image.getHeight() - (this.clip_y + this.height);
                    n6 = this.width;
                    s = this.height;
                    break;
                }
                case 2: {
                    n4 = this.image.getWidth() - (this.clip_x + this.width);
                    n5 = this.clip_y;
                    s = this.width;
                    n6 = this.height;
                    break;
                }
                case 7: {
                    n4 = this.image.getHeight() - (this.clip_y + this.height);
                    n5 = this.image.getWidth() - (this.clip_x + this.width);
                    s = this.height;
                    n6 = this.width;
                    break;
                }
                case 1: {
                    n5 = this.image.getHeight() - (this.clip_y + this.height);
                    n4 = this.image.getWidth() - (this.clip_x + this.width);
                    n6 = this.height;
                    s = this.width;
                    break;
                }
                case 4: {
                    n5 = this.image.getWidth() - (this.clip_x + this.width);
                    n4 = this.clip_y;
                    n6 = this.width;
                    s = this.height;
                }
            }
            graphics.drawRegion(image, n4, n5, (int)s, n6, 0, n, n2, n3);
        }
    }

    public void drawImageAs(Graphics graphics, int n, int n2, int n3) {
        this.drawImageAs(graphics, n, n2, n3, 20);
    }

    public void drawImageAs(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n3 == 0) {
            graphics.drawRegion(this.image, this.clip_x, this.clip_y, (int)this.width, (int)this.height, 0, n, n2, n4);
        } else {
            Image image = null;
            String string = new String(this.image.hashCode() + "/" + n3);
            image = (Image)rotatedCache.get(string);
            if (image == null) {
                image = Image.createImage((Image)this.image, (int)0, (int)0, (int)this.image.getWidth(), (int)this.image.getHeight(), (int)n3);
                rotatedCache.put(string, image);
            }
            int n5 = 0;
            int n6 = 0;
            short s = 0;
            short s2 = 0;
            switch (n3) {
                case 0: {
                    n5 = this.clip_x;
                    n6 = this.clip_y;
                    s = this.width;
                    s2 = this.height;
                    break;
                }
                case 5: {
                    n5 = this.clip_y;
                    n6 = this.clip_x;
                    s = this.height;
                    s2 = this.width;
                    break;
                }
                case 3: {
                    n5 = this.image.getWidth() - (this.clip_x + this.width);
                    n6 = this.image.getHeight() - (this.clip_y + this.height);
                    s = this.width;
                    s2 = this.height;
                    break;
                }
                case 6: {
                    n6 = this.image.getWidth() - (this.clip_x + this.width);
                    n5 = this.image.getHeight() - (this.clip_y + this.height);
                    s2 = this.width;
                    s = this.height;
                    break;
                }
                case 2: {
                    n5 = this.image.getWidth() - (this.clip_x + this.width);
                    n6 = this.clip_y;
                    s = this.width;
                    s2 = this.height;
                    break;
                }
                case 7: {
                    n5 = this.image.getHeight() - (this.clip_y + this.height);
                    n6 = this.image.getWidth() - (this.clip_x + this.width);
                    s = this.height;
                    s2 = this.width;
                    break;
                }
                case 1: {
                    n5 = this.clip_x;
                    n6 = this.clip_y;
                    s2 = this.height;
                    s = this.width;
                    break;
                }
                case 4: {
                    n6 = this.image.getWidth() - (this.clip_x + this.width);
                    n5 = this.clip_y;
                    s2 = this.width;
                    s = this.height;
                }
            }
            graphics.drawRegion(image, n5, n6, (int)s, (int)s2, 0, n, n2, n4);
        }
    }

    public void drawImageNoClipping(Graphics graphics, int n, int n2) {
        graphics.drawImage(this.image, n - this.clip_x, n2 - this.clip_y, 20);
    }
}

