/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Hashtable;

public class ResourceMaster {
    private static final boolean STORE_HASH_ID = true;
    private static final boolean PRELOAD_PAK_CONTENT = true;
    private static DataInputStream dis;
    private static int[] fileHashList;
    private static int[] fileOffset;
    private static int[] fileLength;
    private static byte[][] fileBytes;
    private static int disPosition;
    private static int currentPak;
    private static Hashtable resourceCache;

    public static byte[] getResource(int n) {
        byte[] byArray;
        System.out.println();
        System.gc();
        System.out.println("Getting resource " + n + " (" + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) + ")");
        Engine.tickLoading();
        if (n == -1) {
            System.out.println("Attempt to load unbundled resource");
            return null;
        }
        if (resourceCache == null) {
            resourceCache = new Hashtable();
        }
        if ((byArray = (byte[])resourceCache.get(new Integer(n))) != null) {
            return byArray;
        }
        int n2 = n & 0xFFFF;
        int n3 = n >> 16 & 0xFFFF;
        byte[] byArray2 = null;
        try {
            if (n3 == 0) {
                byArray2 = ResourceMaster.getResourceFromJar(n2 + ".res", true);
            }
            resourceCache.put(new Integer(n), byArray2);
        }
        catch (Exception exception) {
            System.out.println("Error loading fileID: " + n2 + ", PAK: " + n3);
            exception.printStackTrace();
        }
        return byArray2;
    }

    public static boolean isCached(int n) {
        return resourceCache.containsKey(new Integer(n));
    }

    public static byte[] getResourceFromJar(String string) {
        return ResourceMaster.getResourceFromJar(string, false);
    }

    public static byte[] getResourceFromJar(String string, boolean bl) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            InputStream inputStream = ((Object)((Object)Engine.parent)).getClass().getResourceAsStream("/" + string);
            if (bl) {
                inputStream.skip(4L);
            }
            int n = 0;
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            inputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void closeResource() {
        currentPak = -1;
        fileOffset = null;
        fileLength = null;
        fileHashList = null;
        fileBytes = null;
        try {
            if (dis != null) {
                dis.close();
                dis = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void initPak(int n) {
        if (currentPak != -1) {
            ResourceMaster.closeResource();
        }
        currentPak = n;
        dis = new DataInputStream(((Object)((Object)Engine.parent)).getClass().getResourceAsStream("/" + n + ".pak"));
        try {
            int n2;
            int n3 = dis.readShort();
            int[] nArray = new int[n3];
            int[] nArray2 = new int[n3];
            fileHashList = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                ResourceMaster.fileHashList[n2] = dis.readInt();
                nArray[n2] = dis.readInt();
                nArray2[n2] = dis.readInt();
            }
            fileBytes = new byte[n3][];
            for (n2 = 0; n2 < n3; ++n2) {
                ResourceMaster.fileBytes[n2] = new byte[nArray2[n2]];
                dis.read(fileBytes[n2]);
            }
            nArray = null;
            nArray2 = null;
            dis.close();
        }
        catch (Exception exception) {
            System.out.println("Error initialising PAK: " + n);
            exception.printStackTrace();
        }
    }

    public static String getRealResName(int n) {
        return null;
    }

    public static String getRealResPath(int n) {
        return null;
    }

    static {
        currentPak = -1;
    }
}

