/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameWorld
implements Constants {
    public static final String OBJECTIVE_CHARACTER_COMPLETE = "{";
    public static final String OBJECTIVE_CHARACTER_FAILED = "}";
    public static final String OBJECTIVE_CHARACTER_UNCOMPLETE = "[";
    public static byte[] N_TYPE_BYTES;
    public static byte[] N_TYPE_INTS;
    public static byte[] N_TYPE_INTS2;
    public static byte[] N_TYPE_BOOLEANS;
    public static byte[] N_TYPE_OBJECTS;
    public static byte[] DIRECTION_OFFSETS;
    public static short[][] UNIT_NAMES;
    public static short[] UNIT_NAMES_NO_UPGRADES;
    public static byte[][] UNIT_LEVELS;
    public static short[] UNIT_BUILD_TIMES;
    public static byte[] UNIT_FORMATION_PRIORITY;
    public static short[] UNIT_MOVE_SPEED;
    public static short[] UNIT_HIT_POINTS;
    public static short[] UNIT_ATTACK_POINTS;
    public static byte[] UNIT_ATTACK_POINTS_SPREAD;
    public static short[] UNIT_INTERACTION_INTERVAL;
    public static byte[] UNIT_INTERACTION_DELAY;
    public static byte[] UNIT_ATTACK_SPLASH_DAMAGE;
    public static byte[] UNIT_INTERACTION_RANGE;
    public static byte[] UNIT_VIEW_DISTANCE;
    public static byte[][] UNIT_STRONG_AGAINST;
    public static byte[] UNIT_ATTACK_CATEGORY;
    public static byte[] UNIT_PRODUCTION_STACKS;
    public static byte[] UNIT_SPRITES;
    public static byte[] UNIT_SPRITE_DEATHS;
    public static short[] BUILDING_HIT_POINTS;
    public static byte[][] BUILDING_TILES_DISCOVERY;
    public static byte[][] BUILDING_TILES_COLONIAL;
    public static byte[] BUILDING_EXITS;
    public static byte[] BUILDING_VIEW_DISTANCE;
    public static byte[] BUILDING_ATTACK_POINTS;
    public static byte[][] BUILDING_PANEL_ICONS;
    public static byte[] BUILD_ICON_TYPES;
    public static byte[] BUILD_ICON_AGES;
    public static short[][] BUILD_ICON_RESOURCES;
    public static byte[] BUILDING_TYPE_TO_ATTACK_CATEGORY_MAPPING;
    public static byte[] BUILD_ICON_TO_UPGRADE_LEVEL_MAPPING;
    public static short[] AGE_BUILD_TIMES;
    public static short[] UPGRADE_BUILD_TIMES;
    public static byte[] BUILD_ICON_TO_RESOURCE_MAPPING;
    public static byte[] TILE_TO_RESOURCE_MAPPING;
    public static short[] TILE_RESOURCE_AMOUNT;
    public static byte[] TILE_RESOURCE_TO_TILE_REGULAR_MAPPING;
    public static byte[] TILE_WALKABLE;
    public static byte[] TILE_UNWALKABLE;
    public static int[] CURSOR_MOVEMENT_DIRECTIONS_NORMAL;
    public static int[] CURSOR_MOVEMENT_DIRECTIONS_DIAGONAL;
    public static byte[] CROWDED_TILE_OFFSETS;
    public static byte[] SUPPORT_CARD_ICONS;
    public static short[][] SUPPORT_CARD_EFFECTS;
    public static byte[][] SUPPORT_CARD_AGES;
    public static short[][][] MISSIONS;
    public static byte[] MISSION_MAPS;
    public static byte[][] MISSION_START_AGES;
    public static int[] MISSION_BUILD_ICONS;
    public static byte[] MAPS_N_PLAYERS;
    public static int[] LEVEL_RESOURCES;
    public static byte[] CURSOR_EDGE_PAINT_OFFSETS;
    public static byte[] TILE_SHEET_MAPPING;
    public static byte[][] TILE_BEACH_ANIMATIONS;
    public static byte[] BUILDING_FLAG_OFFSETS_DISCOVERY;
    public static byte[] BUILDING_FLAG_OFFSETS_COLONIAL;
    public static byte[] BUILDING_HEIGHT;
    public static byte[] BUILDING_CHIMNEY_OFFSETS_DISCOVERY;
    public static byte[] BUILDING_CHIMNEY_OFFSETS_COLONIAL;
    public static byte[][] BUILDING_WINDOW_OFFSETS;
    public static byte[] ARTILLERY_FIRE_OFFSETS;
    public static byte[] INFANTRY_FIRE_OFFSETS;
    public static byte[] CAVALRY_FIRE_OFFSETS;
    public static int[][] SPRITE_RESOURCES;
    public static byte[] GRASS_RANDOM;
    public static byte[] GRASS_SAND_RANDOM;
    public static byte[] RUINS_RANDOM;
    public static byte[] RESOURCE_TILES;
    public static byte[] BUILD_ICONS_MAPPING;
    public static byte[] TILE_SIZE_OFFSET;
    public static byte[] SELECTION_CIRCLE_DIMENSIONS;
    public static short[] MANIPULATION_MAPPING;
    public static boolean initialized;
    public int state;
    public int STATE_GAME = 0;
    public int STATE_CAPITAL_SCREEN = 1;
    public int STATE_CUTSCENE = 2;
    public int STATE_CREDITS = 3;
    public int viewY;
    public int viewHeight;
    public int mapViewX;
    public int mapViewY;
    public boolean scroll = true;
    public int hudHeight;
    public int hudXpHeight;
    public int hudXpTextX;
    public int hudFoodIconX;
    public int hudWoodIconX;
    public int hudGoldIconX;
    public int hudHousingIconX;
    public short[] hudBuildIconX;
    public short[] hudBuildTextX;
    public boolean drawHud = true;
    public int statusHeight;
    public boolean showBuildingPanel;
    public int buildPanelSelectedIndex;
    public int selectedBuildingType = -1;
    public GameObject selectedBuildingObject;
    public boolean buildPanelQueue;
    public int currentBuildingType = -1;
    public int[] buildPanelIcons;
    public int buildPanelStartIndex;
    public int buildPanelQueueStartIndex;
    public int buildPanelLeftArrowX;
    public int buildPanelRightArrowX;
    public int buildPanelArrowsY;
    public int buildPanelQueueArrowsY;
    public int buildPanelNIconsVisible;
    public int buildPanelIconsX;
    public int buildPanelY;
    public int nHousesBeingBuilt;
    public int buildPanelQueueY;
    public int buildPanelHeight;
    public int buildPanelTopHeight;
    public String buildPanelName;
    public int buildPanelNameX;
    public int buildPanelNameEndX;
    public int buildPanelNameXCountdown;
    public boolean razeConfirmation;
    public boolean showBuildIconDescription;
    public int showBuildIconDescriptionCountdown;
    public String[] buildIconDescriptionStrings;
    public int buildIconDescriptionHeight;
    public int level;
    public byte[] mapData;
    public byte[] mapDataPerceived;
    public int[] mapPropertyData;
    public boolean[] mapPropertyBuildingPercieved;
    public int mapRows;
    public int mapCols;
    public int mapWidth;
    public int mapHeight;
    public static int tileWidthIsometric;
    public static int tileHeightIsometric;
    public static int tileWidthSmallIsometric;
    public static int tileHeightSmallIsometric;
    public byte[][] objectLayers;
    public static final int MAP_CACHE_ROWS = 8;
    public static final int MAP_CACHE_COLS = 8;
    public Image[] mapCacheImages;
    public int mapCacheSectionWidth;
    public int mapCacheSectionHeight;
    public boolean[] cacheSection;
    public static boolean cacheAllTiles;
    public Vector mapCacheSectionImageRepository;
    public boolean mapCacheBufferForce;
    public int mapCacheBufferX;
    public int mapCacheBufferY;
    public int mapCacheBufferWidth;
    public int mapCacheBufferHeight;
    public Image mapCacheBufferImageCurrent;
    public Image mapCacheBufferImageOther;
    public int mapXOffset;
    public Vector tallTiles;
    public byte[] recacheTiles;
    public boolean miniMapActive;
    public int miniMapViewWidth;
    public int miniMapViewHeight;
    public int miniMapViewX;
    public int miniMapViewY;
    public int miniMapX;
    public int miniMapY;
    public Image miniMapCacheImage;
    public GameObject focusedObject;
    public GameObject[] objectsOnScreen;
    public GameObject marker;
    public GameObject[] objects;
    public GameObject[][] objectsPerSide;
    public GameObject[][] units;
    public GameObject[][] buildings;
    public Vector[] selectedUnits;
    public GameObject flagSprite;
    public Vector objectsToAdd = new Vector();
    public Vector objectsToRemove = new Vector();
    public byte[][] formationOffsets1;
    public byte[][] formationOffsets2;
    public GameObject cursor;
    public boolean cursorVisible = true;
    public int cursorBlinkCountdown;
    public int cursorBlinkCountdownPasses;
    public int cursorBlinkInterval;
    public DeviceImage selectionInfoIcon;
    public String selectionInfoString;
    public GameObject selectionInfoObject;
    public static DeviceImage[] tileImages;
    public static DeviceImage[] tileTallImages;
    public static DeviceImage tileFogImage;
    public static DeviceImage[] tileSmallImages;
    public static DeviceImage[] tileSmallTallImages;
    public static DeviceImage[] tileSmallBuildingsImages;
    public static DeviceImage tileBlackImage;
    public static DeviceImage[] iconImages;
    public static DeviceImage[] cursorImages;
    public static DeviceImage[] buildIconImages;
    public static DeviceImage messageIconImage;
    public static DeviceImage[] minimapIconImages;
    public static DeviceImage[] pauseImages;
    public static DeviceImage portraitImage;
    public static DeviceImage[] selectionCircleImages;
    public static DeviceImage capitalScreenBgImage;
    public static DeviceImage[] ageIconImages;
    public static DeviceImage rallyPointFlagImage;
    public static DeviceImage[] tileDarkImages;
    public static DeviceImage[] tileTallDarkImages;
    public static DeviceImage cursorImage;
    public static DeviceImage[] cursorIconImages;
    public static DeviceImage[] numberImages;
    public static DeviceImage[] healthBarImages;
    public static DeviceImage[][][] spriteImages;
    public static int[][] spriteOffsets;
    public static byte[][][] spriteAnimationSequences;
    public static byte[][] spriteAnimationTypes;
    public static short[][][] spriteAnimationProcesses;
    public static byte[][][] spriteAnimationDurations;
    public AI[] ais;
    public short[][] resources;
    public int xpPoints;
    public int xpLevel;
    public int[] housing;
    public int[] housingMax;
    public final int playerSide;
    public int[] nUnits;
    public int[] nBuildings;
    public int[] age;
    public int xpPointsDisplay;
    public byte[] nBuildingsPerType;
    public byte[] nUnitsPerType;
    public byte[][] upgrades;
    public boolean[] hasTownCenter;
    public int gameTime;
    public short[] statistics = new short[9];
    public Vector objectives = new Vector();
    public Vector eventQueue = new Vector();
    public short[] currentEvent;
    public int eventDialogStartIndex;
    public int eventDialogHeight;
    public int eventDialogNVisible;
    public int eventDialogBlockCountdown;
    public String[] eventDialog;
    public GameObject eventFocusSavedObject;
    public GameObject eventObject;
    public Vector messageQueue = new Vector();
    public Vector messageDataQueue = new Vector();
    public String[] message;
    public int messageCountdown;
    public int messageRow = -1;
    public int messageCol = -1;
    public GameObject messageObject;
    public int messageActiveCountdown;
    public int messageAttackCountdown;
    public int nextSettlerStartIndex;
    public boolean nextBrowsingTowncenters;
    public int nextMilitarySideIndex;
    public int nextMilitaryStartIndex;
    public int nextMilitaryCountdown;
    public String[] cutsceneStrings;
    public boolean paused;
    public boolean showPauseIcon;
    public int pauseIconCountdown;
    public boolean playerWon;
    public int gameOverCountdown;
    public int playCountdown;
    public static byte[] saveData;
    public static boolean loadingSavedGame;
    public int buildIconsEnabled;
    public int canBuildCountdown;
    public boolean updateCursorPosition;
    public int musicIndex;
    public static boolean keepPositions;
    public static byte[] positions;
    public int tileBeachAnimationIndex;
    public int tileBeachAnimationCountdown;
    public boolean canBuild;
    public int cursorX;
    public int cursorY;
    public int buildPanelNameNCharacters;
    public int buildPanelNameStartIndex;
    public int buildPanelNameEndIndex;
    public static int soundFxBlockCountdown;
    public static long lastGameTime;
    public byte[] DIRECTIONS_RND = new byte[]{0, 6, 4, 2};
    public static final int ICON_ROW_BUILD_PANEL = 0;
    public static final int ICON_ROW_BUILD_PANEL_QUEUE = 1;
    public static final int ICON_ROW_SUPPORT_CARDS = 2;
    public int nRevolutionsLeftThisTick;
    public int currentPathIndex;
    public int savedPathIndex = 0;
    Vector vSources = new Vector();
    Vector vFromTo = new Vector();
    Vector vCurrentNodes = new Vector();
    Vector vCheapestNodes = new Vector();
    Vector vNodes = new Vector();
    Vector vSourcesPlayer = new Vector();
    Vector vFromToPlayer = new Vector();
    Vector vSourcesEnemy = new Vector();
    Vector vFromToEnemy = new Vector();
    public AStarNode currentNode;
    public Vector cheapestOpenNodes;
    public Hashtable currentNodes;
    public byte[] currentFromTo;
    public static final int SURROUNDED_UNWALKABLE = 0;
    public static final int SURROUNDED_UNWALKABLE_AND_BLOCKED = 1;
    public int capitalScreenSelectionAge;
    public int capitalScreenSelectionIndex;
    public int[] capitalScreenStartIndex;
    public int capitalScreenNIconsVisible;
    public String capitalCurrentName;
    public int capitalScreenLeftArrowX;
    public int capitalScreenRightArrowX;
    public int capitalScreenIconsX;
    public int[][] supportCardIcons;
    public byte[] supportCardUses;
    public int capitalScreenDrawingAge;
    public boolean cutSceneViewed;
    public int cutSceneForwardMethod;
    public int cutSceneFadeEvent;
    public int cutSceneAutoCountdown;
    public DeviceImage creditsImage;
    public String[] creditsStrings;
    public int creditsX;
    public int creditsY;

    public GameWorld() {
        this.playerSide = 0;
        Engine.showMap = false;
        Engine.echo("[GameWorld.<init>] " + Engine.gameCurrentMode);
        Engine.trace = "GameWorld.<init> Start";
        Engine.instance.gameWorld = this;
        GameObject.currentId = 0;
        GameObject.gameWorld = this;
        Engine.updateLoading(10);
        if (!initialized) {
            this.loadGfx();
            Engine.updateLoading(40);
            this.loadData();
            ResourceMaster.closeResource();
            Engine.updateLoading(70);
            initialized = true;
        }
        this.initUIValues();
        this.tallTiles = new Vector();
        Device.soundFunction(4);
        Engine.updateLoading(80);
        if (saveData != null) {
            this.load();
        } else {
            this.setDefaultValues();
            if (Engine.gameCurrentMode == 1) {
                this.loadMap(Engine.gameCurrentMap);
                this.loadObjectLayer(0);
                this.eventQueue.addElement(new short[]{7, 300, 300, 300});
                this.eventQueue.addElement(new short[]{2, 2, 233});
                this.eventQueue.addElement(new short[]{4, 0});
            } else {
                this.loadMap(MISSION_MAPS[Engine.gameCurrentMission]);
                this.parseMissionEvents();
            }
        }
        if (Engine.firstPlay) {
            if (Engine.tipsOn) {
                int n = 1;
                if (Engine.gameCurrentMode == 0) {
                    for (int i = 0; i < this.eventQueue.size(); ++i) {
                        short[] sArray = (short[])this.eventQueue.elementAt(i);
                        if (sArray[0] != 10) continue;
                        n = i + 1;
                        break;
                    }
                }
                this.eventQueue.insertElementAt(new short[]{0, 98, 1, 88}, n);
            }
            Engine.firstPlay = false;
        }
        Engine.updateLoading(95);
        this.buildIconsEnabled = Engine.gameCurrentMode == 1 ? Integer.MAX_VALUE : MISSION_BUILD_ICONS[Engine.gameCurrentMission];
        this.focusedObject = this.cursor;
        this.scrollView(true);
        this.tickEvents();
        Engine.updateLoading(100, true);
        this.musicIndex = 1 + (Engine.gameCurrentMode == 1 ? Engine.rndPositive(3) : Engine.gameCurrentMission % 3);
        Engine.trace = "GameWorld.<init> End";
        Engine.debugMode = -1;
    }

    public static void initArrays() {
        Engine.startMemCheck("GameWorld.initArrays");
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(ResourceMaster.getResource(44)));
            Engine.echo("[GameWorld.initArrays] Common arrays");
            N_TYPE_BYTES = Engine.initByteArray(dataInputStream);
            N_TYPE_INTS = Engine.initByteArray(dataInputStream);
            N_TYPE_INTS2 = Engine.initByteArray(dataInputStream);
            N_TYPE_BOOLEANS = Engine.initByteArray(dataInputStream);
            N_TYPE_OBJECTS = Engine.initByteArray(dataInputStream);
            DIRECTION_OFFSETS = Engine.initByteArray(dataInputStream);
            CURSOR_MOVEMENT_DIRECTIONS_NORMAL = Engine.initIntArray(dataInputStream);
            CURSOR_MOVEMENT_DIRECTIONS_DIAGONAL = Engine.initIntArray(dataInputStream);
            CROWDED_TILE_OFFSETS = Engine.initByteArray(dataInputStream);
            BUILD_ICON_TO_RESOURCE_MAPPING = Engine.initByteArray(dataInputStream);
            BUILD_ICON_TYPES = Engine.initByteArray(dataInputStream);
            BUILD_ICON_AGES = Engine.initByteArray(dataInputStream);
            BUILD_ICON_RESOURCES = Engine.initShort2Array(dataInputStream);
            AGE_BUILD_TIMES = Engine.initShortArray(dataInputStream);
            TILE_TO_RESOURCE_MAPPING = Engine.initByteArray(dataInputStream);
            TILE_RESOURCE_AMOUNT = Engine.initShortArray(dataInputStream);
            TILE_RESOURCE_TO_TILE_REGULAR_MAPPING = Engine.initByteArray(dataInputStream);
            TILE_WALKABLE = Engine.initByteArray(dataInputStream);
            TILE_UNWALKABLE = Engine.initByteArray(dataInputStream);
            LEVEL_RESOURCES = Engine.initIntArray(dataInputStream);
            ARTILLERY_FIRE_OFFSETS = Engine.initByteArray(dataInputStream);
            INFANTRY_FIRE_OFFSETS = Engine.initByteArray(dataInputStream);
            CAVALRY_FIRE_OFFSETS = Engine.initByteArray(dataInputStream);
            GRASS_RANDOM = Engine.initByteArray(dataInputStream);
            GRASS_SAND_RANDOM = Engine.initByteArray(dataInputStream);
            RUINS_RANDOM = Engine.initByteArray(dataInputStream);
            RESOURCE_TILES = Engine.initByteArray(dataInputStream);
            MANIPULATION_MAPPING = Engine.initShortArray(dataInputStream);
            Engine.echo("[GameWorld.initArrays] Level arrays");
            MAPS_N_PLAYERS = Engine.initByteArray(dataInputStream);
            Engine.echo("[GameWorld.initArrays] Home city arrays");
            Engine.echo("[GameWorld.initArrays] Tile animations arrays");
            Engine.echo("[GameWorld.initArrays] Tile sheet arrays");
            TILE_SHEET_MAPPING = Engine.initByteArray(dataInputStream, true);
            Engine.echo("[GameWorld.initArrays] Sprite arrays");
            SPRITE_RESOURCES = Engine.initInt2Array(dataInputStream);
            UNIT_SPRITES = Engine.initByteArray(dataInputStream);
            Engine.echo("[GameWorld.initArrays] Sprite death arrays");
            UNIT_SPRITE_DEATHS = Engine.initByteArray(dataInputStream);
            Engine.echo("[GameWorld.initArrays] Unit arrays");
            UNIT_BUILD_TIMES = Engine.initShortArray(dataInputStream);
            UNIT_FORMATION_PRIORITY = Engine.initByteArray(dataInputStream);
            UNIT_MOVE_SPEED = Engine.initShortArray(dataInputStream);
            UNIT_HIT_POINTS = Engine.initShortArray(dataInputStream);
            UNIT_ATTACK_POINTS = Engine.initShortArray(dataInputStream);
            UNIT_ATTACK_POINTS_SPREAD = Engine.initByteArray(dataInputStream);
            UNIT_INTERACTION_INTERVAL = Engine.initShortArray(dataInputStream);
            UNIT_INTERACTION_DELAY = Engine.initByteArray(dataInputStream);
            UNIT_ATTACK_SPLASH_DAMAGE = Engine.initByteArray(dataInputStream);
            UNIT_INTERACTION_RANGE = Engine.initByteArray(dataInputStream);
            UNIT_VIEW_DISTANCE = Engine.initByteArray(dataInputStream);
            UNIT_STRONG_AGAINST = Engine.initByte2Array(dataInputStream);
            UNIT_ATTACK_CATEGORY = Engine.initByteArray(dataInputStream);
            UNIT_PRODUCTION_STACKS = Engine.initByteArray(dataInputStream);
            BUILDING_TYPE_TO_ATTACK_CATEGORY_MAPPING = Engine.initByteArray(dataInputStream);
            BUILD_ICON_TO_UPGRADE_LEVEL_MAPPING = Engine.initByteArray(dataInputStream);
            UPGRADE_BUILD_TIMES = Engine.initShortArray(dataInputStream);
            UNIT_NAMES = Engine.initShort2Array(dataInputStream);
            UNIT_LEVELS = Engine.initByte2Array(dataInputStream);
            Engine.echo("[GameWorld.initArrays] Building arrays");
            BUILDING_TILES_DISCOVERY = Engine.initByte2Array(dataInputStream);
            BUILDING_EXITS = Engine.initByteArray(dataInputStream);
            BUILDING_HIT_POINTS = Engine.initShortArray(dataInputStream);
            BUILDING_VIEW_DISTANCE = Engine.initByteArray(dataInputStream);
            BUILDING_ATTACK_POINTS = Engine.initByteArray(dataInputStream);
            BUILDING_PANEL_ICONS = Engine.initByte2Array(dataInputStream);
            BUILDING_TILES_COLONIAL = Engine.initByte2Array(dataInputStream);
            BUILDING_WINDOW_OFFSETS = Engine.initByte2Array(dataInputStream);
            BUILDING_CHIMNEY_OFFSETS_DISCOVERY = Engine.initByteArray(dataInputStream);
            BUILDING_CHIMNEY_OFFSETS_COLONIAL = Engine.initByteArray(dataInputStream);
            BUILD_ICONS_MAPPING = Engine.initByteArray(dataInputStream);
            Engine.echo("[GameWorld.initArrays] Gfx size arrays");
            CURSOR_EDGE_PAINT_OFFSETS = Engine.initByteArray(dataInputStream);
            BUILDING_FLAG_OFFSETS_DISCOVERY = Engine.initByteArray(dataInputStream);
            BUILDING_HEIGHT = Engine.initByteArray(dataInputStream);
            TILE_SIZE_OFFSET = Engine.initByteArray(dataInputStream);
            BUILDING_FLAG_OFFSETS_COLONIAL = Engine.initByteArray(dataInputStream);
            SELECTION_CIRCLE_DIMENSIONS = Engine.initByteArray(dataInputStream);
            Engine.echo("[GameWorld.initArrays] Mission arrays");
            MISSION_MAPS = Engine.initByteArray(dataInputStream);
            MISSION_START_AGES = Engine.initByte2Array(dataInputStream);
            MISSION_BUILD_ICONS = Engine.initIntArray(dataInputStream);
            int n = dataInputStream.readByte();
            MISSIONS = new short[n][][];
            for (int i = 0; i < n; ++i) {
                GameWorld.MISSIONS[i] = Engine.initShort2Array(dataInputStream);
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Engine.endMemCheck();
    }

    public void generateFormationOffsets() {
        this.formationOffsets1 = this.generateFormationOffsets(15, 3);
        this.formationOffsets2 = this.generateFormationOffsets(30, 5);
    }

    public byte[][] generateFormationOffsets(int n, int n2) {
        byte[][] byArrayArray = new byte[8][];
        for (int i = 0; i < 8; ++i) {
            byArrayArray[i] = this.generateFormationOffsets(n, n2, i);
        }
        return byArrayArray;
    }

    public byte[] generateFormationOffsets(int n, int n2, int n3) {
        int n4 = (n3 + 2) % 8;
        byte by = DIRECTION_OFFSETS[2 * n4];
        byte by2 = DIRECTION_OFFSETS[2 * n4 + 1];
        int n5 = (n3 + 4) % 8;
        byte by3 = DIRECTION_OFFSETS[2 * n5];
        byte by4 = DIRECTION_OFFSETS[2 * n5 + 1];
        byte[] byArray = new byte[2 * n];
        for (int i = 0; i < n; ++i) {
            int n6;
            int n7 = i / n2;
            int n8 = i % n2;
            int n9 = n6 = n8 == 0 ? 0 : (n8 + 1) / 2;
            if (n8 % 2 == 1) {
                n6 = -n6;
            }
            int n10 = n7 * by3 + n6 * by;
            int n11 = n7 * by4 + n6 * by2;
            byArray[2 * i] = (byte)n10;
            byArray[2 * i + 1] = (byte)n11;
        }
        return byArray;
    }

    public void setDefaultValues() {
        Engine.startMemCheck("GameWorld.setDefaultValues");
        if (Engine.gameCurrentMode == 0) {
            Engine.gameCurrentTeams = Engine.gameCurrentMission == 14 ? new byte[]{0, 1, 0} : new byte[]{0, 1};
        }
        this.setSideVariables();
        this.generateFormationOffsets();
        this.nBuildingsPerType = new byte[9];
        this.nUnitsPerType = new byte[8];
        this.cursor = new GameObject(1);
        this.marker = GameObject.createMarker();
        this.flagSprite = GameObject.createSprite(21);
        Engine.endMemCheck();
    }

    public void setSideVariables() {
        int n;
        int n2;
        Engine.echo("[GameWorld.setSideVariables] " + Engine.gameCurrentNSides);
        this.nUnits = new int[Engine.gameCurrentNSides];
        this.nBuildings = new int[Engine.gameCurrentNSides];
        this.resources = new short[Engine.gameCurrentNSides][3];
        this.housing = new int[Engine.gameCurrentNSides];
        this.housingMax = new int[Engine.gameCurrentNSides];
        this.selectedUnits = new Vector[Engine.gameCurrentNSides];
        this.hasTownCenter = new boolean[Engine.gameCurrentNSides];
        this.objects = new GameObject[5];
        this.objectsPerSide = new GameObject[Engine.gameCurrentNSides][5];
        this.units = new GameObject[Engine.gameCurrentNSides][5];
        this.buildings = new GameObject[Engine.gameCurrentNSides][5];
        this.age = new int[Engine.gameCurrentNSides];
        this.upgrades = new byte[Engine.gameCurrentNSides][3];
        this.ais = new AI[Engine.gameCurrentNSides];
        for (n2 = 0; n2 < Engine.gameCurrentNSides; ++n2) {
            if (Engine.gameCurrentMode == 0) {
                this.age[n2] = n2 < 2 ? MISSION_START_AGES[Engine.gameCurrentMission][n2] : 0;
            }
            for (n = 0; n < 3; ++n) {
                this.upgrades[n2][n] = (byte)n;
            }
            this.selectedUnits[n2] = new Vector();
            if (n2 == 0) continue;
            this.ais[n2] = new AI(this, n2);
        }
        if (positions == null || !keepPositions) {
            positions = new byte[Engine.gameCurrentNSides];
            if (Engine.gameCurrentMode == 1) {
                for (n2 = 0; n2 < Engine.gameCurrentNSides; ++n2) {
                    GameWorld.positions[n2] = -1;
                }
                for (n2 = 0; n2 < Engine.gameCurrentNSides; ++n2) {
                    n = Engine.rndPositive(Engine.gameCurrentMapMaxPlayers);
                    if (Engine.getIndexInArray(positions, n) == -1) {
                        GameWorld.positions[n2] = (byte)n;
                        continue;
                    }
                    --n2;
                }
            } else {
                for (n2 = 0; n2 < Engine.gameCurrentNSides; ++n2) {
                    GameWorld.positions[n2] = (byte)n2;
                }
            }
        }
        keepPositions = false;
    }

    public void loadGfx() {
        Engine.startMemCheck("GameWorld.loadGfx");
        this.loadGameResources(false);
        tileFogImage = new DeviceImage(70);
        byte by = 0;
        for (int i = 0; i < BUILD_ICONS_MAPPING.length; ++i) {
            if (BUILD_ICONS_MAPPING[i] <= by) continue;
            by = BUILD_ICONS_MAPPING[i];
        }
        buildIconImages = new DeviceImage(51).divide(by + 1);
        iconImages = new DeviceImage(66).divide(5);
        GameWorld.iconImages[0] = null;
        messageIconImage = new DeviceImage(60);
        pauseImages = new DeviceImage(61).divide(2);
        rallyPointFlagImage = new DeviceImage(63);
        Engine.endMemCheck();
    }

    public void loadData() {
        Engine.startMemCheck("GameWorld.loadData");
        int[] nArray = new int[]{47, -1};
        int[] nArray2 = new int[]{47, -1};
        int[] nArray3 = new int[]{47, -1, 45, 46, -1};
        for (int i = 0; i < 24; ++i) {
            int n = -1;
            for (int j = 0; j < SPRITE_RESOURCES[i].length; ++j) {
                if (SPRITE_RESOURCES[i][j] == -1) continue;
                n = SPRITE_RESOURCES[i][j];
                break;
            }
            if (i == 4 || i == 5) {
                this.loadSprite(n, i, nArray2);
                continue;
            }
            if (i == 12) {
                this.loadSprite(n, i, nArray3);
                continue;
            }
            this.loadSprite(n, i, (int[])(i < 14 ? nArray : null));
        }
        Engine.endMemCheck();
    }

    public void loadSprite(int n, int n2, int[] nArray) {
        if (n == -1) {
            return;
        }
        try {
            byte[] byArray;
            int n3;
            int n4;
            int n5;
            Engine.echo("[GameWorld.loadSprite] Loading sprite into slot " + n2);
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(ResourceMaster.getResource(n)));
            byte by = dataInputStream.readByte();
            GameWorld.spriteOffsets[n2][0] = dataInputStream.readByte();
            GameWorld.spriteOffsets[n2][1] = dataInputStream.readByte();
            int n6 = dataInputStream.readByte();
            GameWorld.spriteAnimationSequences[n2] = new byte[n6][];
            GameWorld.spriteAnimationProcesses[n2] = new short[n6][];
            GameWorld.spriteAnimationDurations[n2] = new byte[n6][];
            GameWorld.spriteAnimationTypes[n2] = new byte[n6];
            for (n5 = 0; n5 < n6; ++n5) {
                GameWorld.spriteAnimationTypes[n2][n5] = dataInputStream.readByte();
                byte by2 = dataInputStream.readByte();
                GameWorld.spriteAnimationSequences[n2][n5] = new byte[by2];
                GameWorld.spriteAnimationProcesses[n2][n5] = new short[by2];
                GameWorld.spriteAnimationDurations[n2][n5] = new byte[by2];
                for (n4 = 0; n4 < by2; ++n4) {
                    GameWorld.spriteAnimationSequences[n2][n5][n4] = dataInputStream.readByte();
                    n3 = dataInputStream.readByte();
                    GameWorld.spriteAnimationProcesses[n2][n5][n4] = Engine.getMapping(MANIPULATION_MAPPING, n3);
                    GameWorld.spriteAnimationDurations[n2][n5][n4] = dataInputStream.readByte();
                }
            }
            n5 = dataInputStream.readByte();
            byte[][] byArrayArray = new byte[n5][];
            for (n4 = 0; n4 < n5; ++n4) {
                n3 = dataInputStream.readInt();
                byArray = new byte[n3];
                dataInputStream.readFully(byArray);
                byArrayArray[n4] = byArray;
            }
            n4 = dataInputStream.readByte();
            if (nArray != null) {
                n4 = nArray.length;
            }
            GameWorld.spriteImages[n2] = new DeviceImage[n4 + 1][];
            if (n5 == 1) {
                GameWorld.spriteImages[n2][0] = new DeviceImage(byArrayArray[0]).divide(by);
            } else {
                GameWorld.spriteImages[n2][0] = new DeviceImage[n5];
                for (n3 = 0; n3 < n5; ++n3) {
                    GameWorld.spriteImages[n2][0][n3] = new DeviceImage(byArrayArray[n3]);
                }
            }
            for (n3 = 0; n3 < n4; ++n3) {
                int n7;
                byArray = null;
                if (nArray != null) {
                    if (nArray[n3] != -1) {
                        byArray = ResourceMaster.getResource(nArray[n3]);
                    }
                } else {
                    n7 = dataInputStream.readShort();
                    byArray = new byte[n7];
                    dataInputStream.readFully(byArray);
                }
                if (byArray == null) continue;
                if (n5 == 1) {
                    GameWorld.spriteImages[n2][n3 + 1] = new DeviceImage(Engine.insertPLTE(byArrayArray[0], byArray)).divide(by);
                    continue;
                }
                GameWorld.spriteImages[n2][n3 + 1] = new DeviceImage[n5];
                for (n7 = 0; n7 < n5; ++n7) {
                    GameWorld.spriteImages[n2][n3 + 1][n7] = new DeviceImage(Engine.insertPLTE(byArrayArray[n7], byArray));
                }
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            Engine.echo("Sprite in slot " + n2 + " failed to load");
            exception.printStackTrace();
        }
    }

    public static int getSpriteHeight(int n) {
        return GameWorld.spriteImages[n][0][0].height;
    }

    public void initUIValues() {
        short s = GameWorld.iconImages[1].width;
        int n = Device.USE_BITMAP_FONTS ? FontMgr.charWidth(Engine.font, '0') : (int)GameWorld.numberImages[0].width;
        boolean bl = false;
        this.hudHeight = Device.USE_BITMAP_FONTS ? FontMgr.charHeight[Engine.font] + this.hudXpHeight : GameWorld.numberImages[0].height + 2 + this.hudXpHeight;
        int n2 = 5 * s + 6 + 20 * n + 2 * n / 3;
        int n3 = Math.max(0, (176 - n2) / 4);
        this.hudFoodIconX = 1;
        int n4 = s + 1 + 5 * n + n3;
        this.hudWoodIconX = this.hudFoodIconX + n4;
        this.hudGoldIconX = this.hudWoodIconX + n4;
        this.hudHousingIconX = 176 - 5 * n - s;
        int n5 = 176 - 2 * Engine.tipsImages[0].width - 2 * Engine.arrowHImages[0].width - 4;
        this.buildPanelNIconsVisible = (n5 + 2) / (GameWorld.buildIconImages[0].width + 2);
        int n6 = this.buildPanelNIconsVisible * (GameWorld.buildIconImages[0].width + 2) - 2;
        this.buildPanelIconsX = (176 - n6) / 2;
        int n7 = 1 + Engine.tipsImages[0].width + 2;
        int n8 = 175 - Engine.tipsImages[0].width - 2;
        this.buildPanelLeftArrowX = n7 + (this.buildPanelIconsX - n7) / 2 - Engine.arrowHImages[0].width / 2 - 1;
        this.buildPanelRightArrowX = this.buildPanelIconsX + n6 + (n8 - (this.buildPanelIconsX + n6)) / 2 - Engine.arrowHImages[0].width / 2 + 1;
        this.buildPanelArrowsY = 208 - Engine.woodPanelImage.height + (Engine.woodPanelImage.height - Engine.arrowVImages[0].height) / 2;
        this.buildPanelY = 208 - Engine.woodPanelImage.height;
        this.buildPanelHeight = Engine.woodPanelImage.height + 2;
        this.buildPanelTopHeight = Device.USE_BITMAP_FONTS ? 2 * FontMgr.charHeight[Engine.font] : FontMgr.charHeight[Engine.font] + GameWorld.numberImages[0].height;
        this.buildPanelQueueY = this.buildPanelY - this.buildPanelTopHeight - GameWorld.buildIconImages[0].height - 5;
        this.buildPanelQueueArrowsY = this.buildPanelQueueY + 1 + GameWorld.buildIconImages[0].height / 2 - Engine.arrowVImages[0].height / 2;
        this.hudBuildIconX = new short[3];
        this.hudBuildTextX = new short[3];
        this.hudBuildIconX[0] = 1;
        this.hudBuildTextX[0] = (short)(this.hudBuildIconX[0] + s + 1);
        this.hudBuildIconX[1] = (short)(this.hudBuildTextX[0] + 4 * n);
        this.hudBuildTextX[1] = (short)(this.hudBuildIconX[1] + s + 1);
        this.hudBuildIconX[2] = (short)(this.hudBuildTextX[1] + 4 * n);
        this.hudBuildTextX[2] = (short)(this.hudBuildIconX[2] + s + 1);
        this.viewY = this.hudHeight;
        this.viewHeight = 208 - this.hudHeight - this.statusHeight;
        tileWidthIsometric = GameWorld.tileImages[0].width;
        tileHeightIsometric = GameWorld.tileImages[0].height + TILE_SIZE_OFFSET[0];
        Engine.echo("[GameWorld.iniUIValues] tile size: " + tileWidthIsometric + ", " + tileHeightIsometric);
        this.eventDialogHeight = 3 * GameWorld.portraitImage.height / 4;
        this.eventDialogNVisible = (this.eventDialogHeight - Engine.menuBorderHeight / 3 - 4) / FontMgr.charHeight[Engine.font];
        if (this.eventDialogNVisible < 3) {
            this.eventDialogHeight = 3 * FontMgr.charHeight[Engine.font] + Engine.menuBorderHeight / 3 + 4;
            this.eventDialogNVisible = 3;
        }
    }

    public String getUnitName(int n, int n2) {
        byte by = UNIT_ATTACK_CATEGORY[n2];
        byte by2 = UNIT_LEVELS[n2][this.upgrades[n][by]];
        return Engine.getText(UNIT_NAMES[n2][by2]);
    }

    public String getBuildingName(int n, int n2) {
        if (n2 == 3 && this.age[n] == 2) {
            return Engine.getText(182);
        }
        return Engine.getText(173 + n2);
    }

    public static String getAgeName(int n) {
        return Engine.getText(184 + n);
    }

    public static String getTradeName(int n) {
        return Engine.getText(188 + n);
    }

    public static String getUpgradeName(int n, int n2) {
        String string = GameWorld.getCategoryName(Engine.getMapping(BUILDING_TYPE_TO_ATTACK_CATEGORY_MAPPING, n));
        String string2 = Engine.getText(204 + n2 + 1);
        return Engine.getText(115, new String[]{string, string2});
    }

    public static String getCategoryName(int n) {
        return Engine.getText(199 + n + 1);
    }

    public static String getResourceName(int n) {
        return Engine.getText(195 + n + 1);
    }

    public String getSupportCardName(int n) {
        short[] sArray = SUPPORT_CARD_EFFECTS[n];
        if (sArray[0] == 8) {
            return sArray[2] + " x " + this.getUnitName(0, sArray[1]);
        }
        return sArray[2] + " " + GameWorld.getResourceName(sArray[1]);
    }

    public void loadMap(int n) {
        Engine.startMemCheck("GameWorld.loadMap " + n);
        this.level = n;
        try {
            int n2;
            int n3;
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(ResourceMaster.getResource(LEVEL_RESOURCES[n])));
            this.mapRows = dataInputStream.readByte();
            this.mapCols = dataInputStream.readByte();
            this.mapWidth = this.mapCols * 48;
            this.mapHeight = this.mapRows * 48;
            int n4 = this.mapRows * this.mapCols;
            this.mapData = new byte[n4];
            this.mapDataPerceived = new byte[n4];
            this.mapPropertyBuildingPercieved = new boolean[n4];
            this.mapPropertyData = new int[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = dataInputStream.readByte();
                if (n2 == 2) {
                    n2 = GRASS_RANDOM[Engine.rndPositive(GRASS_RANDOM.length)];
                } else if (n2 == 3) {
                    n2 = GRASS_SAND_RANDOM[Engine.rndPositive(GRASS_SAND_RANDOM.length)];
                }
                this.mapData[n3] = n2;
                this.mapDataPerceived[n3] = this.mapData[n3];
                if (!this.isTileResource(this.mapData[n3])) continue;
                this.setTileProperty(536739840, 17, n3 / this.mapCols, n3 % this.mapCols, TILE_RESOURCE_AMOUNT[Engine.getMapping(TILE_TO_RESOURCE_MAPPING, (int)this.mapData[n3])], false);
            }
            n3 = dataInputStream.readByte();
            this.objectLayers = new byte[n3][];
            for (n2 = 0; n2 < n3; ++n2) {
                byte by = dataInputStream.readByte();
                byte[] byArray = new byte[by * 3];
                dataInputStream.readFully(byArray);
                this.objectLayers[n2] = byArray;
            }
            dataInputStream.close();
            dataInputStream = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.mapXOffset = this.mapRows * tileWidthIsometric / 2;
        Engine.endMemCheck();
    }

    public void loadObjectLayer(int n) {
        Engine.startMemCheck("GameWorld.loadObjectLayer " + n + " (" + this.objectLayers[n].length / 3 + " objects)");
        for (int i = 0; i < this.objectLayers[n].length; i += 3) {
            Object object;
            int n2;
            int n3;
            byte by;
            byte by2 = this.objectLayers[n][i];
            Object object2 = this.objectLayers[n][i + 1];
            Object object3 = this.objectLayers[n][i + 2];
            int n4 = by2 / 16;
            if (positions != null && Engine.getIndexInArray(positions, n4) == -1) continue;
            int n5 = positions != null ? Engine.getIndexInArray(positions, n4) : n;
            if (n5 == 2) {
                n5 = 0;
            }
            if ((by = BUILD_ICON_TYPES[n3 = by2 % 16]) == 0) {
                if (this.nUnits[n5] >= 30) continue;
                n2 = n3 - 8;
                if (this.isTileProperty(1, 0, (int)object2, (int)object3, false)) {
                    object = this.getTileSpiral((int)object2, (int)object3, 1, -1, 100, null);
                    object2 = object[0];
                    object3 = object[1];
                }
                object = GameObject.createUnit(n2, n5, object2, object3);
                this.addObject((GameObject)object, true);
                int n6 = n5;
                this.housing[n6] = this.housing[n6] + 1;
                if (this.cursor.ints2[0] != null || n5 != 0) continue;
                this.cursor.setTile((int)object2, (int)object3);
                this.scrollView(true);
                continue;
            }
            n2 = n3 - -1;
            object = GameObject.createBuilding(n2, n5);
            this.addObject((GameObject)object, true);
            ((GameObject)object).placeBuilding((int)object2, (int)object3);
            ((GameObject)object).completeBuilding(false);
            if (n2 != 1 || n5 != 0) continue;
            this.cursor.setTile((int)object2, (int)object3);
            this.scrollView(true);
        }
        this.objectLayers[n] = null;
        this.sortObjects(false);
        this.updateCursorPosition();
        Engine.endMemCheck();
    }

    public void parseMissionEvents() {
        for (int i = 0; i < MISSIONS[Engine.gameCurrentMission].length; ++i) {
            short[] sArray = MISSIONS[Engine.gameCurrentMission][i];
            short[] sArray2 = new short[sArray.length];
            System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
            this.eventQueue.addElement(sArray2);
        }
    }

    public void save() {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(this.gameTime);
            dataOutputStream.writeByte(Engine.gameCurrentMode);
            if (Engine.gameCurrentMode == 0) {
                dataOutputStream.writeByte(Engine.gameCurrentMissionMode);
                dataOutputStream.writeByte(Engine.gameCurrentMission);
            }
            dataOutputStream.writeByte(Engine.gameCurrentMap);
            dataOutputStream.writeByte(Engine.gameCurrentNSides);
            Engine.writeByteArray(Engine.gameCurrentTeams, dataOutputStream);
            Engine.writeByteArray(positions, dataOutputStream);
            dataOutputStream.writeByte(this.level);
            Engine.echo("[GameWorld.save] Saving properties");
            for (int i = 0; i < Engine.gameCurrentNSides; ++i) {
                dataOutputStream.writeByte(this.age[i]);
                Engine.writeShortArray(this.resources[i], dataOutputStream);
                Engine.writeByteArray(this.upgrades[i], dataOutputStream);
            }
            Engine.writeShortArray(this.statistics, dataOutputStream);
            dataOutputStream.writeByte(this.gameOverCountdown);
            dataOutputStream.writeBoolean(this.playerWon);
            Engine.echo("[GameWorld.save] Saving tiles");
            Vector<Object> vector = new Vector<Object>();
            for (n = 0; n < this.mapRows; ++n) {
                for (int i = 0; i < this.mapCols; ++i) {
                    int n2;
                    int n3 = this.getTile(n, i);
                    if (Engine.getIndexInArray(RUINS_RANDOM, n3) != -1) {
                        vector.addElement(new int[]{3, n, i});
                    } else if (this.isTileProperty(0x20000000, 29, n, i, false)) {
                        vector.addElement(new int[]{1, n, i});
                    }
                    if (this.isTileProperty(2, 1, n, i, false)) {
                        vector.addElement(new int[]{0, n, i});
                    }
                    if (!this.isTileResource(n3) || (n2 = this.getTileProperty(536739840, 17, n, i)) >= TILE_RESOURCE_AMOUNT[Engine.getMapping(TILE_TO_RESOURCE_MAPPING, n3)]) continue;
                    vector.addElement(new int[]{2, n, i, n2});
                }
            }
            dataOutputStream.writeShort(vector.size());
            for (n = 0; n < vector.size(); ++n) {
                int[] nArray = (int[])vector.elementAt(n);
                dataOutputStream.writeByte(nArray[0]);
                dataOutputStream.writeByte(nArray[1]);
                dataOutputStream.writeByte(nArray[2]);
                if (nArray[0] != 2) continue;
                dataOutputStream.writeShort(nArray[3]);
            }
            Engine.writeByteArray(this.mapDataPerceived, dataOutputStream);
            Engine.writeBooleanArray(this.mapPropertyBuildingPercieved, dataOutputStream);
            Engine.echo("[GameWorld.save] Saving objects");
            ((OutputStream)dataOutputStream).write(this.cursor.toBytes());
            vector = new Vector();
            for (n = 0; n < this.objects.length; ++n) {
                if (this.objects[n] == null || !this.objects[n].isEntity()) continue;
                vector.addElement(this.objects[n]);
            }
            dataOutputStream.writeShort(vector.size());
            for (n = 0; n < vector.size(); ++n) {
                GameObject gameObject = (GameObject)vector.elementAt(n);
                ((OutputStream)dataOutputStream).write(gameObject.toBytes());
            }
            Engine.echo("[GameWorld.save] Saving events");
            Engine.writeShortArray(this.currentEvent, dataOutputStream);
            dataOutputStream.writeByte(this.eventQueue.size());
            Enumeration enumeration = this.eventQueue.elements();
            while (enumeration.hasMoreElements()) {
                Engine.writeShortArray((short[])enumeration.nextElement(), dataOutputStream);
            }
            dataOutputStream.writeByte(this.objectives.size());
            enumeration = this.objectives.elements();
            while (enumeration.hasMoreElements()) {
                Engine.writeShortArray((short[])enumeration.nextElement(), dataOutputStream);
            }
            for (int i = 0; i < Engine.gameCurrentNSides; ++i) {
                if (i == 0) continue;
                dataOutputStream.writeByte(this.ais[i].personality);
                dataOutputStream.writeByte(this.ais[i].stage);
                dataOutputStream.writeShort(this.ais[i].stageCountdown);
                dataOutputStream.writeByte(this.ais[i].startRow);
                dataOutputStream.writeByte(this.ais[i].startCol);
                dataOutputStream.writeBoolean(this.ais[i].lost);
                dataOutputStream.writeBoolean(this.ais[i].buildFort);
                dataOutputStream.writeBoolean(this.ais[i].hasMarket);
                dataOutputStream.writeByte(this.ais[i].marketTicker);
            }
            saveData = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void load() {
        loadingSavedGame = true;
        try {
            int n;
            int n2;
            int n3;
            short s;
            int n4;
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(saveData));
            this.gameTime = dataInputStream.readInt();
            Engine.gameCurrentMode = dataInputStream.readByte();
            if (Engine.gameCurrentMode == 0) {
                Engine.gameCurrentMissionMode = dataInputStream.readByte();
                Engine.gameCurrentMission = dataInputStream.readByte();
            }
            Engine.gameCurrentMap = dataInputStream.readByte();
            Engine.gameCurrentNSides = dataInputStream.readByte();
            Engine.gameCurrentTeams = Engine.readByteArray(dataInputStream);
            positions = Engine.readByteArray(dataInputStream);
            keepPositions = true;
            this.setDefaultValues();
            this.loadMap(dataInputStream.readByte());
            for (n4 = 0; n4 < Engine.gameCurrentNSides; ++n4) {
                this.age[n4] = dataInputStream.readByte();
                this.resources[n4] = Engine.readShortArray(dataInputStream);
                this.upgrades[n4] = Engine.readByteArray(dataInputStream);
            }
            this.statistics = Engine.readShortArray(dataInputStream);
            this.gameOverCountdown = dataInputStream.readByte();
            this.playerWon = dataInputStream.readBoolean();
            n4 = dataInputStream.readShort();
            for (int i = 0; i < n4; ++i) {
                s = dataInputStream.readByte();
                n3 = dataInputStream.readByte();
                byte by = dataInputStream.readByte();
                if (s == 3) {
                    this.setTile(n3, by, RUINS_RANDOM[Engine.rndPositive(RUINS_RANDOM.length)]);
                    continue;
                }
                if (s == 0) {
                    this.setTileProperty(2, 1, n3, by, 1, false);
                    continue;
                }
                if (s == 1) {
                    this.setTile(n3, by, Engine.getMapping(TILE_RESOURCE_TO_TILE_REGULAR_MAPPING, this.getTile(n3, by)));
                    this.setTileProperty(0x20000000, 29, n3, by, 1, false);
                    continue;
                }
                if (s != 2) continue;
                n2 = dataInputStream.readShort();
                this.setTileProperty(536739840, 17, n3, by, n2, false);
                this.setTile(n3, by, this.getResourceTile(n3, by));
            }
            this.mapDataPerceived = Engine.readByteArray(dataInputStream);
            this.mapPropertyBuildingPercieved = Engine.readBooleanArray(dataInputStream);
            this.cursor = GameObject.fromStream(dataInputStream);
            this.updateCursorPosition = true;
            Hashtable<Integer, GameObject> hashtable = new Hashtable<Integer, GameObject>();
            s = dataInputStream.readShort();
            for (n3 = 0; n3 < s; ++n3) {
                GameObject gameObject = GameObject.fromStream(dataInputStream);
                this.addObject(gameObject, true);
                hashtable.put(new Integer(gameObject.id), gameObject);
                if (gameObject.type == 2) {
                    this.addHousing(gameObject.side(), 1);
                    continue;
                }
                if (gameObject.type != 3) continue;
                n2 = gameObject.state;
                gameObject.placeBuilding(gameObject.row, gameObject.col);
                if (n2 == 0) continue;
                gameObject.completeBuilding(false);
            }
            this.addObjects();
            this.convertObjectIdsToObjects(hashtable);
            hashtable = null;
            this.currentEvent = Engine.readShortArray(dataInputStream);
            n3 = dataInputStream.readByte();
            for (n = 0; n < n3; ++n) {
                this.eventQueue.addElement(Engine.readShortArray(dataInputStream));
            }
            n = dataInputStream.readByte();
            for (n2 = 0; n2 < n; ++n2) {
                this.objectives.addElement(Engine.readShortArray(dataInputStream));
            }
            for (n2 = 0; n2 < Engine.gameCurrentNSides; ++n2) {
                if (n2 == 0) continue;
                this.ais[n2].personality = dataInputStream.readByte();
                this.ais[n2].stage = dataInputStream.readByte();
                this.ais[n2].stageCountdown = dataInputStream.readShort();
                this.ais[n2].startRow = dataInputStream.readByte();
                this.ais[n2].startCol = dataInputStream.readByte();
                this.ais[n2].lost = dataInputStream.readBoolean();
                this.ais[n2].buildFort = dataInputStream.readBoolean();
                this.ais[n2].hasMarket = dataInputStream.readBoolean();
                this.ais[n2].marketTicker = dataInputStream.readByte();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        loadingSavedGame = false;
    }

    public void convertObjectIdsToObjects(Hashtable hashtable) {
        for (int i = 0; i < this.objects.length; ++i) {
            GameObject[] gameObjectArray;
            if (this.objects[i] == null || this.objects[i].objects == null || (gameObjectArray = this.objects[i].objects) == null) continue;
            for (int j = 0; j < gameObjectArray.length; ++j) {
                if (gameObjectArray[j] == null) continue;
                gameObjectArray[j] = (GameObject)hashtable.get(new Integer(gameObjectArray[j].id));
            }
        }
    }

    public int[] getTime() {
        int n = this.gameTime;
        int n2 = n / 1000;
        int n3 = n2 / 60;
        n2 -= n3 * 60;
        int n4 = n3 / 60;
        return new int[]{n4, n3 -= n4 * 60, n2};
    }

    public void setupMapCache() {
    }

    public void cacheAll() {
        for (int i = 0; i < this.mapRows; ++i) {
            for (int j = 0; j < this.mapCols; ++j) {
                this.reCacheMapAtTile(i, j);
                if (!this.isTileTall(this.getTile(i, j), false)) continue;
                this.addTallTile(i, j);
            }
        }
    }

    public void cacheVisible() {
        if (this.mapCacheImages == null) {
            this.mapCacheImages = new Image[64];
        }
        for (int i = 0; i < this.cacheSection.length; ++i) {
            if (this.cacheSection[i] || !this.isMapCacheSectionOnScreen(i / 8, i % 8) || this.mapCacheImages[i] != null) continue;
            this.cacheSection[i] = true;
        }
    }

    public boolean isMapCacheSectionOnScreen(int n, int n2) {
        return this.isRectOnScreen(n2 * this.mapCacheSectionWidth - this.mapRows * tileWidthIsometric / 2, n * this.mapCacheSectionHeight, this.mapCacheSectionWidth, this.mapCacheSectionHeight);
    }

    public void checkMapCache() {
        int n;
        for (n = 0; n < this.cacheSection.length; ++n) {
            if (!this.cacheSection[n]) continue;
            this.cacheSection[n] = false;
            this.cacheMapSection(n / 8, n % 8);
        }
        for (n = 0; n < this.mapPropertyData.length; ++n) {
            this.setTileProperty(8192, 13, n / this.mapCols, n % this.mapCols, 0, false);
        }
    }

    public void checkMapCacheBufferPosition() {
        this.mapCacheBufferX = this.mapViewX;
        this.mapCacheBufferY = this.mapViewY;
    }

    public boolean isTileOnBuffer(int n, int n2) {
        int[] nArray = this.getTileEdgePoints(n, n2);
        for (int i = 0; i < nArray.length; i += 2) {
            if (nArray[i] + tileWidthIsometric <= this.mapCacheBufferX && nArray[i] - tileWidthIsometric >= this.mapCacheBufferX + this.mapCacheBufferWidth && nArray[i + 1] + tileHeightIsometric <= this.mapCacheBufferY && nArray[i + 1] - tileHeightIsometric >= this.mapCacheBufferY + this.mapCacheBufferHeight) continue;
            return true;
        }
        return false;
    }

    public int[] getTileEdgePoints(int n, int n2) {
        int[] nArray = this.logicToIsometric(n2 * 48, n * 48, tileWidthIsometric, tileHeightIsometric);
        int n3 = nArray[0] - tileWidthIsometric / 2;
        int n4 = n3 + tileWidthIsometric;
        int n5 = nArray[1];
        int n6 = n5 + tileHeightIsometric;
        return new int[]{n3, n5, n3, n6, n4, n5, n4, n6};
    }

    public void cacheMapSection(int n, int n2) {
        Graphics graphics;
        if (Engine.debugForceNoCache) {
            return;
        }
        int n3 = n * 8 + n2;
        boolean bl = false;
        if (this.mapCacheImages[n3] == null) {
            this.mapCacheImages[n3] = Image.createImage((int)this.mapCacheSectionWidth, (int)this.mapCacheSectionHeight);
            bl = true;
            graphics = this.mapCacheImages[n3].getGraphics();
        } else {
            graphics = this.mapCacheImages[n3].getGraphics();
            bl = false;
        }
        if (bl) {
            Engine.cls(graphics, 0);
        }
        int n4 = n2 * this.mapCacheSectionWidth - this.mapXOffset;
        int n5 = n * this.mapCacheSectionHeight;
        this.drawWorld(graphics, -n4, -n5, this.mapCacheSectionWidth, this.mapCacheSectionHeight, 1);
    }

    public void reCacheMapAtTile(int n, int n2) {
        boolean bl = false;
        int[] nArray = this.getTileEdgePoints(n, n2);
        for (int i = 0; i < nArray.length; i += 2) {
            int n3 = nArray[i + 1] / this.mapCacheSectionHeight;
            int n4 = (nArray[i] + this.mapRows * tileWidthIsometric / 2) / this.mapCacheSectionWidth;
            if (!GameWorld.isOnMap(n3, n4, 8, 8)) continue;
            this.cacheSection[n3 * 8 + n4] = true;
            if (bl || !this.cacheSection[n3 * 8 + n4]) continue;
            bl = true;
        }
        if (bl) {
            this.setTileProperty(8192, 13, n, n2, 1, false);
        }
    }

    public void drawMapCache(Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = -n2 / this.mapCacheSectionHeight;
        int n7 = (-n2 + 208) / this.mapCacheSectionHeight;
        int n8 = -(n -= this.mapXOffset) / this.mapCacheSectionWidth;
        int n9 = (-n + 176) / this.mapCacheSectionWidth;
        n6 = Math.max(Math.min(7, n6), 0);
        n7 = Math.max(Math.min(7, n7), 0);
        n8 = Math.max(Math.min(7, n8), 0);
        n9 = Math.max(Math.min(7, n9), 0);
        for (n5 = n6; n5 <= n7; ++n5) {
            for (n4 = n8; n4 <= n9; ++n4) {
                int n10;
                Image image = this.mapCacheImages[n5 * 8 + n4];
                if (image != null) {
                    n3 = n4 * this.mapCacheSectionWidth + n;
                    n10 = n5 * this.mapCacheSectionHeight + n2;
                    graphics.drawImage(image, n3, n10, 20);
                    continue;
                }
                if (Engine.debugMode != 13) continue;
                n3 = n4 * this.mapCacheSectionWidth + n;
                n10 = n5 * this.mapCacheSectionHeight + n2;
                graphics.setColor(0xFFFFFF);
                graphics.drawLine(n3, n10, n3 + this.mapCacheSectionWidth, n10 + this.mapCacheSectionHeight);
                graphics.drawLine(n3, n10 + this.mapCacheSectionHeight, n3 + this.mapCacheSectionWidth, n10);
            }
        }
        if (Engine.debugMode == 13) {
            for (n5 = n6; n5 <= n7; ++n5) {
                for (n4 = n8; n4 <= n9; ++n4) {
                    int n11 = n4 * this.mapCacheSectionWidth + n;
                    n3 = n5 * this.mapCacheSectionHeight + n2;
                    graphics.setColor(0xFFFFFF);
                    graphics.drawRect(n11 - 1, n3 - 1, this.mapCacheSectionWidth + 1, this.mapCacheSectionHeight + 1);
                    FontMgr.drawString(Engine.font, graphics, n5 + "," + n4, n11 + 3, n3 + 1, 20);
                    FontMgr.drawString(Engine.font, graphics, n5 + "," + n4, n11 + 3, n3 + this.mapCacheSectionHeight - 1, 68);
                    FontMgr.drawString(Engine.font, graphics, n5 + "," + n4, n11 + this.mapCacheSectionWidth - 3, n3 + 1, 24);
                    FontMgr.drawString(Engine.font, graphics, n5 + "," + n4, n11 + this.mapCacheSectionWidth - 3, n3 + this.mapCacheSectionHeight - 1, 72);
                }
            }
        }
    }

    public void cacheMiniMap() {
        int n = (this.mapRows + this.mapCols) * (tileWidthSmallIsometric / 2);
        int n2 = (this.mapRows + this.mapCols) * (tileHeightSmallIsometric / 2) + tileHeightSmallIsometric / 2;
        this.miniMapCacheImage = Image.createImage((int)n, (int)n2);
        Graphics graphics = this.miniMapCacheImage.getGraphics();
        Engine.cls(graphics, 0);
        this.drawWorld(graphics, this.mapRows * (tileWidthSmallIsometric / 2), 0, n, n2, 3);
    }

    public GameObject[] addObjectToArray(GameObject[] gameObjectArray, GameObject gameObject) {
        int n = -1;
        for (int i = 0; i < gameObjectArray.length; ++i) {
            if (gameObjectArray[i] != null) continue;
            n = i;
        }
        if (n == -1) {
            GameObject[] gameObjectArray2 = new GameObject[gameObjectArray.length + 5];
            System.arraycopy(gameObjectArray, 0, gameObjectArray2, 0, gameObjectArray.length);
            n = gameObjectArray.length;
            gameObjectArray = gameObjectArray2;
            gameObjectArray2 = null;
        }
        gameObjectArray[n] = gameObject;
        return gameObjectArray;
    }

    public void addObject(GameObject gameObject) {
        this.addObject(gameObject, false);
    }

    public void addObject(GameObject gameObject, boolean bl) {
        if (!this.objectsToAdd.contains(gameObject)) {
            this.objectsToAdd.addElement(gameObject);
        }
        if (bl) {
            this.addObjects();
        }
    }

    public void removeObjectFromArray(GameObject[] gameObjectArray, GameObject gameObject) {
        for (int i = 0; i < gameObjectArray.length; ++i) {
            if (gameObjectArray[i] != gameObject) continue;
            gameObjectArray[i] = null;
            break;
        }
    }

    public void removeObject(GameObject gameObject) {
        if (!this.objectsToRemove.contains(gameObject)) {
            this.objectsToRemove.addElement(gameObject);
        }
    }

    public void addObjects() {
        Enumeration enumeration = this.objectsToAdd.elements();
        while (enumeration.hasMoreElements()) {
            int n;
            GameObject gameObject = (GameObject)enumeration.nextElement();
            this.objects = this.addObjectToArray(this.objects, gameObject);
            if (gameObject.isEntity()) {
                this.objectsPerSide[gameObject.side()] = this.addObjectToArray(this.objectsPerSide[gameObject.side()], gameObject);
            }
            if (gameObject.type == 2) {
                if (!gameObject.isAlive()) continue;
                n = gameObject.side();
                this.units[n] = this.addObjectToArray(this.units[n], gameObject);
                int n2 = n;
                this.nUnits[n2] = this.nUnits[n2] + 1;
                if (n == 0) {
                    byte by = gameObject.bytes[12];
                    this.nUnitsPerType[by] = (byte)(this.nUnitsPerType[by] + 1);
                } else {
                    this.ais[n].unitTrained(gameObject);
                }
                if (loadingSavedGame) {
                    if (gameObject.bytes[14] != -1) {
                        this.setTileProperty(1, 0, gameObject.bytes[14], gameObject.bytes[15], 1, false);
                    }
                } else {
                    gameObject.stop();
                }
                if (gameObject.isSameTeamAs(0)) {
                    this.explore(gameObject.row, gameObject.col, UNIT_VIEW_DISTANCE[gameObject.bytes[12]], true);
                }
                this.addTileProperty(7168, 10, gameObject.row, gameObject.col, 1);
                gameObject.bytes[23] = (byte)gameObject.row;
                gameObject.bytes[24] = (byte)gameObject.col;
            } else if (gameObject.type == 3) {
                n = gameObject.side();
                this.buildings[n] = this.addObjectToArray(this.buildings[n], gameObject);
                int n3 = n;
                this.nBuildings[n3] = this.nBuildings[n3] + 1;
            }
            if (this.cursor == null || gameObject.row != this.cursor.row || gameObject.col != this.cursor.col) continue;
            this.updateCursorPosition = true;
        }
        this.objectsToAdd.removeAllElements();
    }

    public void removeObjects() {
        Enumeration enumeration = this.objectsToRemove.elements();
        while (enumeration.hasMoreElements()) {
            GameObject gameObject = (GameObject)enumeration.nextElement();
            this.removeObjectFromArray(this.objects, gameObject);
            if (!gameObject.isEntity()) continue;
            int n = gameObject.side();
            if (gameObject.isEntity()) {
                this.removeObjectFromArray(this.objectsPerSide[n], gameObject);
            }
            if (gameObject.type == 2) {
                this.removeObjectFromArray(this.units[n], gameObject);
            } else {
                this.removeObjectFromArray(this.buildings[n], gameObject);
            }
            this.checkGameOver();
        }
        this.objectsToRemove.removeAllElements();
    }

    public void checkGameOver() {
        for (int i = 0; i < Engine.gameCurrentNSides; ++i) {
            if (this.nUnits[i] != 0 || this.nBuildings[i] != 0) continue;
            if (i == 0) {
                if (this.gameOverCountdown != 0) continue;
                this.failLatestObjective();
                this.playerWon = false;
                this.gameOverCountdown = 40;
                continue;
            }
            if (Engine.gameCurrentMode != 1 || this.ais[i].lost) continue;
            this.ais[i].lost = true;
            this.message(Engine.getText(148, new String[]{Engine.getText(223 + i + 1)}));
        }
    }

    public void failLatestObjective() {
        short[] sArray = (short[])this.objectives.elementAt(this.objectives.size() - 1);
        sArray[1] = 2;
        this.message(Engine.getText(139, new String[]{this.getObjectiveName(sArray)}));
    }

    public void gameOver() {
        Engine.instance.gameWorld = null;
        int[] nArray = this.getTime();
        String string = Engine.getText(123, new String[]{"" + Engine.fillZeros("" + nArray[0], 2) + ":" + Engine.fillZeros("" + nArray[1], 2) + ":" + Engine.fillZeros("" + nArray[2], 2)}) + "\n" + Engine.getText(124, new String[]{"" + this.statistics[0]}) + "\n" + Engine.getText(125, new String[]{"" + this.statistics[1]}) + "\n" + Engine.getText(126, new String[]{"" + this.statistics[2]}) + "\n" + Engine.getText(127, new String[]{"" + this.statistics[3]}) + "\n" + Engine.getText(128, new String[]{"" + this.statistics[4]}) + "\n" + Engine.getText(129, new String[]{"" + this.statistics[5]}) + "\n" + Engine.getText(130, new String[]{"" + this.statistics[6]}) + "\n" + Engine.getText(131, new String[]{"" + this.statistics[7]}) + "\n" + Engine.getText(132, new String[]{"" + this.statistics[8]});
        Menu menu = Engine.createForm(Engine.getText(this.playerWon ? 118 : 119), string, null, null);
        if (this.playerWon) {
            if (Engine.gameCurrentMode == 1) {
                menu.action = 5;
            } else {
                Engine.gameUnlockedMission = Math.min(Math.max(Engine.gameUnlockedMission, Engine.gameCurrentMission + 1), MISSIONS.length - 1);
                Engine.saveRMS(0);
                if (Engine.gameCurrentMissionMode == 0) {
                    menu.action = Engine.gameCurrentMission < MISSIONS.length - 1 ? 0 : 5;
                } else {
                    menu.action = 5;
                    Engine.initMissionsMenu();
                    Engine.calculateMenuSpace(true);
                    Engine.menuMissions.setCursor(Math.min(Engine.gameCurrentMission + 1, MISSIONS.length - 1));
                    Engine.menuMissions.previous = Engine.menuMain;
                    Engine.menuMain.setCursor(0);
                    Engine.closeGameWorldMenu = Engine.menuMissions;
                }
            }
        } else {
            menu.action = 2;
        }
        Engine.setMenu(menu, true, false);
        this.stopMusic();
    }

    public void tick() {
        int n;
        this.tickPathfinding();
        if (this.state == this.STATE_CUTSCENE) {
            this.tickCutscene();
            return;
        }
        if (this.eventDialogBlockCountdown > 0) {
            --this.eventDialogBlockCountdown;
            if (this.eventDialogBlockCountdown <= 0) {
                Engine.releaseAllKeys();
            }
        }
        if (this.tickEvents()) {
            return;
        }
        if (this.pauseIconCountdown > 0 && --this.pauseIconCountdown <= 0) {
            this.showPauseIcon = !this.showPauseIcon;
            this.pauseIconCountdown = 3;
        }
        if (!this.showBuildingPanel && this.cursor.state != 1 && this.cursor.state != 2 && !this.isAnyUnitSelected(0) && Engine.key(128)) {
            Engine.setMenu(Engine.menuInGame, true, true);
            this.stopMusic();
            Engine.lastSound = -1;
            return;
        }
        if (Engine.key(4096)) {
            boolean bl = this.paused = !this.paused;
            if (this.paused) {
                this.showPauseIcon = true;
                this.pauseIconCountdown = 3;
            } else {
                this.playCountdown = 15;
            }
        } else if (!this.paused && Engine.key(16384)) {
            n = -1;
            int n2 = -1;
            if (this.messageObject != null) {
                if (this.messageObject.booleans[0]) {
                    this.messageObject = null;
                } else {
                    n = this.messageObject.row;
                    n2 = this.messageObject.col;
                }
            } else if (this.messageRow != -1) {
                n = this.messageRow;
                n2 = this.messageCol;
            }
            if (n != -1) {
                this.cursor.setRow(n);
                this.cursor.setCol(n2);
                this.updateCursorPosition = true;
            } else {
                GameObject gameObject = this.getNextSettler();
                if (gameObject == null) {
                    this.nextSettlerStartIndex = 0;
                    gameObject = this.getNextSettler();
                }
                if (gameObject != null) {
                    this.cursor.setTile(gameObject.row, gameObject.col);
                    this.updateCursorPosition = true;
                }
            }
        }
        if (this.showBuildingPanel) {
            this.tickBuildingPanel();
        } else {
            this.tickCursor();
        }
        if (this.showBuildIconDescriptionCountdown > 0 && --this.showBuildIconDescriptionCountdown <= 0) {
            this.showBuildIconDescription();
        }
        if (this.showBuildingPanel && this.buildPanelNameXCountdown != -1) {
            if (this.buildPanelNameXCountdown > 0) {
                --this.buildPanelNameXCountdown;
                if (this.buildPanelNameXCountdown == 0 && this.buildPanelNameX == this.buildPanelNameEndX) {
                    this.buildPanelNameX = 2;
                    this.buildPanelNameXCountdown = 10;
                }
            } else if (this.buildPanelNameXCountdown == 0) {
                if (this.buildPanelNameX > this.buildPanelNameEndX) {
                    --this.buildPanelNameX;
                } else {
                    this.buildPanelNameXCountdown = 10;
                }
            }
        }
        for (n = 0; n < this.objects.length; ++n) {
            if (this.objects[n] == null || this.objects[n].type == 1) continue;
            this.objects[n].tick();
        }
        this.removeObjects();
        this.addObjects();
        if (this.scroll) {
            this.scrollView(false);
        }
        this.sortObjects(false);
        this.tickMessage();
        if (this.updateCursorPosition) {
            this.updateCursorPosition();
            this.updateCursorPosition = false;
        }
        if (this.paused) {
            return;
        }
        this.gameTime += 50;
        if (this.playCountdown > 0) {
            --this.playCountdown;
        }
        if (this.gameOverCountdown > 0) {
            --this.gameOverCountdown;
            if (this.gameOverCountdown <= 0) {
                this.gameOverCountdown = -1;
                Engine.fadeOut(false, 7);
            }
        }
        if (this.cursor.state == 1 && this.canBuildCountdown > 0) {
            --this.canBuildCountdown;
            if (this.canBuildCountdown <= 0 && this.cursor.state == 1) {
                this.updateCursorEdges();
                this.canBuildCountdown = 15;
            }
        }
        this.flagSprite.tickSprite();
        for (n = 0; n < Engine.gameCurrentNSides; ++n) {
            if (this.ais[n] == null) continue;
            this.ais[n].tick();
        }
        this.checkObjectives();
    }

    public GameObject getNextSettler() {
        GameObject[] gameObjectArray = Engine.debugMode == 9 ? this.units[Engine.debugAiIndex] : this.units[0];
        for (int i = this.nextSettlerStartIndex; i < gameObjectArray.length; ++i) {
            GameObject gameObject = gameObjectArray[i];
            if (gameObject == null || Engine.debugMode != 9 && (!gameObject.isUnitType(0) || !gameObject.isFree())) continue;
            this.nextSettlerStartIndex = i + 1;
            return gameObject;
        }
        return null;
    }

    public GameObject getNextMilitary() {
        if (this.nextBrowsingTowncenters) {
            while (this.nextMilitarySideIndex < Engine.gameCurrentNSides) {
                GameObject[] gameObjectArray = this.buildings[this.nextMilitarySideIndex];
                for (int i = this.nextMilitaryStartIndex; i < gameObjectArray.length; ++i) {
                    GameObject gameObject = gameObjectArray[i];
                    if (gameObject == null || gameObject.bytes[4] != 1 || !gameObject.anyBuildingTileVisible()) continue;
                    this.nextMilitaryStartIndex = 0;
                    ++this.nextMilitarySideIndex;
                    return gameObject;
                }
                this.nextMilitaryStartIndex = 0;
                ++this.nextMilitarySideIndex;
            }
            this.nextBrowsingTowncenters = false;
        } else {
            GameObject[] gameObjectArray = this.units[0];
            for (int i = this.nextMilitaryStartIndex; i < gameObjectArray.length; ++i) {
                GameObject gameObject = gameObjectArray[i];
                if (gameObject == null || gameObject.isUnitType(0)) continue;
                this.nextMilitaryStartIndex = i + 1;
                return gameObject;
            }
            this.nextBrowsingTowncenters = true;
            this.nextMilitarySideIndex = 0;
        }
        this.nextMilitaryStartIndex = 0;
        return null;
    }

    public void sortObjects(boolean bl) {
        GameObject[] gameObjectArray = new GameObject[this.objects.length];
        int n = 0;
        for (int i = 0; i < this.objects.length; ++i) {
            GameObject gameObject = this.objects[i];
            if (gameObject == null) continue;
            if (bl) {
                gameObject.isOnScreen = gameObject.type == 2 && this.isTileProperty(508, 2, gameObject.row, gameObject.col, false);
            } else {
                boolean bl2 = gameObject.spriteId == 19 || gameObject.isOnScreen(false) && (gameObject.type == 3 ? gameObject.anyBuildingTileVisible() : this.isTileProperty(508, 2, gameObject.row, gameObject.col, false)) ? true : (gameObject.isOnScreen = false);
            }
            if (!gameObject.isOnScreen) continue;
            gameObjectArray[n++] = this.objects[i];
        }
        this.objectsOnScreen = new GameObject[n];
        if (n > 0) {
            System.arraycopy(gameObjectArray, 0, this.objectsOnScreen, 0, n);
            this.quickSort(this.objectsOnScreen, 0, this.objectsOnScreen.length - 1);
        }
    }

    public void quickSort(GameObject[] gameObjectArray, int n, int n2) {
        GameObject gameObject;
        int n3 = n;
        int n4 = n2 + 1;
        GameObject gameObject2 = gameObjectArray[n];
        while (true) {
            if (++n3 < gameObjectArray.length && gameObjectArray[n3].compareTo(gameObject2) < 0) {
                continue;
            }
            while (gameObjectArray[--n4].compareTo(gameObject2) > 0) {
            }
            if (n3 < n4) {
                gameObject = gameObjectArray[n3];
                gameObjectArray[n3] = gameObjectArray[n4];
                gameObjectArray[n4] = gameObject;
            }
            if (n3 > n4) break;
        }
        gameObject = gameObjectArray[n];
        gameObjectArray[n] = gameObjectArray[n4];
        gameObjectArray[n4] = gameObject;
        if (n < n4) {
            this.quickSort(gameObjectArray, n, n4);
        }
        if (n3 < n2) {
            this.quickSort(gameObjectArray, n3, n2);
        }
    }

    public boolean handleEvent(short[] sArray) {
        Engine.echo("[GameWorld.handleEvent] " + sArray[0]);
        switch (sArray[0]) {
            case 0: {
                Engine.releaseAllKeys();
                if (sArray[2] == 0) {
                    this.eventDialog = Engine.getStrings(Engine.getText(sArray[1]), 176 - GameWorld.portraitImage.width - 10, Engine.font);
                    this.eventDialogStartIndex = 0;
                    this.eventDialogBlockCountdown = 20;
                    break;
                }
                if (Engine.tipsOn) {
                    Menu menu = Engine.createForm(sArray[3] == -1 ? null : Engine.getText(sArray[3]), Engine.getText(sArray[1]), null, null);
                    if (sArray[1] == 98) {
                        this.sortObjects(false);
                        menu.action = 4;
                    } else {
                        menu.action = 1;
                    }
                    Engine.setMenu(menu, true, false);
                    break;
                }
                this.currentEvent = null;
                return true;
            }
            case 1: {
                short s = sArray[1];
                this.loadObjectLayer(s);
                return true;
            }
            case 2: {
                short[] sArray2 = null;
                switch (sArray[1]) {
                    case 0: 
                    case 1: 
                    case 3: {
                        sArray2 = new short[]{sArray[1], 0, sArray[2], sArray[3], sArray[4]};
                        break;
                    }
                    case 2: 
                    case 4: {
                        sArray2 = new short[]{sArray[1], 0, sArray[2]};
                    }
                }
                this.objectives.addElement(sArray2);
                this.message(Engine.getText(137, new String[]{this.getObjectiveName(sArray2)}));
                return true;
            }
            case 3: {
                if (this.gameOverCountdown == 0) {
                    short[] sArray3 = (short[])this.objectives.elementAt(this.objectives.size() - 1);
                    sArray3[1] = 1;
                    this.message(Engine.getText(138, new String[]{this.getObjectiveName(sArray3)}));
                    return true;
                }
            }
            case 5: 
            case 6: {
                this.getEntityAt((int)sArray[1], (int)sArray[2]).ints[1] = sArray[3];
                return true;
            }
            case 8: {
                return true;
            }
            case 7: {
                for (int i = 0; i < Engine.gameCurrentNSides; ++i) {
                    this.addResources(i, new short[]{sArray[1], sArray[2], sArray[3]});
                }
                return true;
            }
            case 12: {
                for (int i = 0; i < Engine.gameCurrentNSides; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        this.upgrades[i][j] = (byte)sArray[j + 1];
                    }
                }
                return true;
            }
            case 9: {
                this.ais[1].personality = sArray[1];
                return true;
            }
            case 10: {
                this.cutSceneViewed = false;
                if (Engine.fadeState != 3) {
                    Engine.fadeOut(false, 6);
                    Engine.fadeEventParams = new int[]{sArray[1]};
                } else {
                    this.setCutscene(Engine.getText(sArray[1]));
                }
                if (sArray.length > 2) {
                    this.cutSceneForwardMethod = sArray[2];
                    if (this.cutSceneForwardMethod == 1) {
                        this.cutSceneAutoCountdown = 70;
                    }
                    this.cutSceneFadeEvent = sArray[3];
                    break;
                }
                this.cutSceneForwardMethod = 0;
                this.cutSceneFadeEvent = 5;
                break;
            }
            case 11: {
                this.playerWon = true;
                Engine.fadeOut(false, 9);
                break;
            }
            case 13: {
                Device.soundFunction(3, new int[]{0});
                return true;
            }
            case 4: {
                return false;
            }
        }
        return false;
    }

    public void playMusic() {
        Device.soundFunction(3, new int[]{this.musicIndex});
    }

    public void stopMusic() {
        Device.soundFunction(1);
    }

    public void setObjectivesScreen() {
        String string = Device.USE_BITMAP_FONTS ? OBJECTIVE_CHARACTER_COMPLETE : "V";
        String string2 = Device.USE_BITMAP_FONTS ? OBJECTIVE_CHARACTER_UNCOMPLETE : "-";
        String string3 = Device.USE_BITMAP_FONTS ? OBJECTIVE_CHARACTER_FAILED : "X";
        StringBuffer stringBuffer = new StringBuffer();
        if (this.objectives.size() == 0) {
            stringBuffer.append("");
        } else {
            for (int i = 0; i < this.objectives.size(); ++i) {
                short[] sArray = (short[])this.objectives.elementAt(i);
                String string4 = sArray[1] == 1 ? string + " " : (sArray[1] == 2 ? string3 + " " : string2 + " ");
                stringBuffer.append(string4 + this.getObjectiveName(sArray) + "\n");
            }
        }
        Menu menu = Engine.createForm(Engine.getText(30), stringBuffer.toString(), Engine.menuCurrent, null);
        menu.align = 20;
        Engine.setMenu(menu);
    }

    public void checkObjectives() {
        Enumeration enumeration = this.objectives.elements();
        while (enumeration.hasMoreElements()) {
            short[] sArray = (short[])enumeration.nextElement();
            boolean bl = sArray[1] == 1;
            if (bl) continue;
            switch (sArray[0]) {
                case 0: {
                    if (this.nBuildingsPerType[sArray[3]] < sArray[4]) break;
                    bl = true;
                    break;
                }
                case 1: {
                    if (this.nUnitsPerType[sArray[3]] < sArray[4]) break;
                    bl = true;
                    break;
                }
                case 2: {
                    if (!this.isAllEnemiesKilled()) break;
                    bl = true;
                    break;
                }
                case 3: {
                    if (this.resources[0][sArray[3]] < sArray[4]) break;
                    bl = true;
                }
            }
            if (!bl) continue;
            sArray[1] = 1;
            this.message(Engine.getText(138, new String[]{this.getObjectiveName(sArray)}));
        }
    }

    public boolean isAllEnemiesKilled() {
        for (int i = 0; i < Engine.gameCurrentNSides; ++i) {
            if (Engine.gameCurrentTeams[i] == Engine.gameCurrentTeams[0] || this.nUnits[i] <= 0 && this.nBuildings[i] <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isObjectivesComplete() {
        Enumeration enumeration = this.objectives.elements();
        while (enumeration.hasMoreElements()) {
            short[] sArray = (short[])enumeration.nextElement();
            boolean bl = sArray[1] == 1;
            if (bl) continue;
            return false;
        }
        return true;
    }

    public String getObjectiveName(short[] sArray) {
        short s = sArray[2];
        switch (sArray[0]) {
            case 0: {
                return Engine.getText(s, new String[]{"" + sArray[4], this.getBuildingName(0, sArray[3])});
            }
            case 1: {
                return Engine.getText(s, new String[]{"" + sArray[4], this.getUnitName(0, sArray[3])});
            }
            case 3: {
                return Engine.getText(s, new String[]{"" + sArray[4], GameWorld.getResourceName(sArray[3])});
            }
            case 2: 
            case 4: {
                return Engine.getText(s);
            }
        }
        return null;
    }

    public void tickMiniMap() {
        if (Engine.isPressed(1)) {
            this.miniMapViewY -= Engine.scale(0, 3);
        } else if (Engine.isPressed(2)) {
            this.miniMapViewY += Engine.scale(0, 3);
        }
        if (Engine.isPressed(4)) {
            this.miniMapViewX -= Engine.scale(0, 3);
        } else if (Engine.isPressed(8)) {
            this.miniMapViewX += Engine.scale(0, 3);
        }
        int[] nArray = this.isometricToLogic(this.miniMapViewX - this.mapRows * (tileWidthSmallIsometric / 2), this.miniMapViewY, tileWidthSmallIsometric, tileHeightSmallIsometric);
        boolean bl = false;
        if (nArray[0] > this.mapWidth) {
            nArray[0] = this.mapWidth;
            bl = true;
        } else if (nArray[0] < 0) {
            nArray[0] = 0;
            bl = true;
        }
        if (nArray[1] > this.mapHeight) {
            nArray[1] = this.mapHeight;
            bl = true;
        } else if (nArray[1] < 0) {
            nArray[1] = 0;
            bl = true;
        }
        if (bl) {
            int[] nArray2 = this.logicToIsometric(nArray[0], nArray[1], tileWidthSmallIsometric, tileHeightSmallIsometric);
            this.miniMapViewX = nArray2[0] + this.mapRows * (tileWidthSmallIsometric / 2);
            this.miniMapViewY = nArray2[1];
        }
        this.miniMapX = this.miniMapCacheImage.getWidth() < 176 ? (176 - this.miniMapCacheImage.getWidth()) / 2 : Math.max(Math.min(0, -this.miniMapViewX + 88), 176 - this.miniMapCacheImage.getWidth());
        this.miniMapY = this.miniMapCacheImage.getHeight() < this.viewHeight ? this.hudHeight + (this.viewHeight - this.miniMapCacheImage.getHeight()) / 2 : Math.min(this.hudHeight, Math.max(208 - this.miniMapCacheImage.getHeight(), this.hudHeight + this.viewHeight / 2 - this.miniMapViewY));
    }

    public boolean tickEvents() {
        if (this.currentEvent != null) {
            this.tickEvent();
        } else if (this.eventQueue.size() > 0) {
            do {
                this.currentEvent = (short[])this.eventQueue.elementAt(0);
                this.eventQueue.removeElementAt(0);
            } while (this.handleEvent(this.currentEvent) && this.eventQueue.size() > 0 && !this.isCurrentEventLocking());
        } else if (this.messageQueue.size() == 0 && this.gameOverCountdown == 0) {
            this.playerWon = true;
            this.gameOverCountdown = 40;
        }
        return this.currentEvent != null && this.currentEvent[0] != 4;
    }

    public void tickEvent() {
        switch (this.currentEvent[0]) {
            case 0: {
                if (this.currentEvent[2] != 0 || this.eventDialogBlockCountdown != 0 || !Engine.key(16) && !Engine.key(64)) break;
                this.eventDialogStartIndex += this.eventDialogNVisible;
                if (this.eventDialogStartIndex < this.eventDialog.length) break;
                this.currentEvent = null;
                this.eventDialog = null;
                break;
            }
            case 4: {
                if (this.paused) break;
                if (this.currentEvent[1] == 0) {
                    if (!this.isObjectivesComplete()) break;
                    this.currentEvent = null;
                    break;
                }
                if (this.currentEvent[1] == 1) {
                    if (!this.isAllEnemiesKilled()) break;
                    this.currentEvent = null;
                    break;
                }
                if (this.currentEvent[1] != 2) break;
                if (this.currentEvent[2] <= 0) {
                    this.currentEvent = null;
                    break;
                }
                this.currentEvent[2] = (short)(this.currentEvent[2] - 1);
                break;
            }
            case 10: {
                if (!this.cutSceneViewed) break;
                this.currentEvent = null;
                break;
            }
            default: {
                this.currentEvent = null;
            }
        }
    }

    public boolean isCurrentEventLocking() {
        return this.currentEvent != null && (this.currentEvent[0] == 0 || this.currentEvent[0] == 10);
    }

    public void blinkCursor(int n, int n2) {
        this.cursorBlinkCountdown = n;
        this.cursorBlinkInterval = n;
        this.cursorBlinkCountdownPasses = n2;
    }

    public void tickCursor() {
        if (Engine.key(16)) {
            this.cursorAction(16, this.cursor.row, this.cursor.col);
        } else if (Engine.key(64)) {
            this.cursorAction(64, this.cursor.row, this.cursor.col);
        } else if (Engine.key(128)) {
            this.cursorBack();
        } else {
            int n;
            int n2 = this.cursor.row;
            int n3 = this.cursor.col;
            int[] nArray = Engine.cursorNormal ? CURSOR_MOVEMENT_DIRECTIONS_NORMAL : CURSOR_MOVEMENT_DIRECTIONS_DIAGONAL;
            for (n = 0; n < nArray.length; n += 2) {
                if (!Engine.isPressedRepeat(nArray[n])) continue;
                this.cursor.moveX(DIRECTION_OFFSETS[2 * nArray[n + 1] + 1] * 48 << 8);
                this.cursor.moveY(DIRECTION_OFFSETS[2 * nArray[n + 1]] * 48 << 8);
            }
            n = Math.min(Math.max(0, this.cursor.row), this.mapRows - 1);
            int n4 = Math.min(Math.max(0, this.cursor.col), this.mapCols - 1);
            this.cursor.setRow(n);
            this.cursor.setCol(n4);
            if (n != n2 || n4 != n3) {
                this.updateCursorPosition(n2, n3, n, n4);
            }
        }
    }

    public void cursorAction(int n, int n2, int n3) {
        if (n == 64) {
            if (this.cursor.state != 1 && this.cursor.state != 2) {
                this.showBuildingPanel(null, 0, true);
            }
        } else if (n == 16) {
            if (this.cursor.state == 1) {
                short[] sArray = BUILD_ICON_RESOURCES[-1 + this.currentBuildingType];
                boolean bl = this.canBuild(0, this.currentBuildingType, n2, n3);
                if (!bl) {
                    this.updateCursorEdges();
                    this.message(Engine.getText(140));
                    return;
                }
                bl = this.hasResources(0, sArray);
                if (bl) {
                    this.removeResources(0, sArray);
                    GameObject gameObject = GameObject.createBuilding(this.currentBuildingType, 0);
                    this.addObject(gameObject, true);
                    gameObject.placeBuilding(n2, n3);
                    this.currentBuildingType = -1;
                    this.cursor.state = 0;
                    this.blinkCursor(0, 0);
                    this.cursorVisible = true;
                } else {
                    this.message(Engine.getText(133));
                }
                this.updateCursorPosition = true;
            } else if (this.cursor.state == 2) {
                if (this.isTileWalkable(this.cursor.row, this.cursor.col)) {
                    this.selectedBuildingObject.bytes[7] = (byte)this.cursor.row;
                    this.selectedBuildingObject.bytes[8] = (byte)this.cursor.col;
                    this.cursor.setTile(this.selectedBuildingObject.row, this.selectedBuildingObject.col);
                    this.cursor.state = 0;
                    this.updateCursorEdges();
                    this.showBuildIconDescription = false;
                    this.showBuildIconDescriptionCountdown = 15;
                    this.showBuildingPanel = true;
                }
            } else {
                boolean bl = this.isAnyUnitSelected(0);
                if (Engine.debugMode == 1) {
                    GameObject gameObject = this.getEntityAt(n2, n3);
                    if (gameObject == null) {
                        this.addObject(GameObject.createUnit(0, 0, this.cursor.row, this.cursor.col));
                        this.addHousing(0, 1);
                    } else if (gameObject.type == 2) {
                        int n4 = gameObject.side();
                        int n5 = gameObject.bytes[12];
                        gameObject.removeObject();
                        if (n4 == 0) {
                            this.explore(gameObject.row, gameObject.col, UNIT_VIEW_DISTANCE[gameObject.bytes[12]], false);
                        }
                        int n6 = n4;
                        this.nUnits[n6] = this.nUnits[n6] - 1;
                        this.addHousing(n4, -1);
                        this.removeObjects();
                        if (gameObject.bytes[23] != -1) {
                            this.addTileProperty(7168, 10, gameObject.bytes[23], gameObject.bytes[24], -1);
                        }
                        if (gameObject.bytes[14] != -1) {
                            this.setTileProperty(1, 0, gameObject.bytes[14], gameObject.bytes[15], 0, false);
                        }
                        if (n4 != 0) {
                            this.ais[n4].unitKilled(gameObject);
                        }
                        if (++n5 > 7) {
                            GameObject gameObject2 = GameObject.createBuilding(3, n4);
                            this.addObject(gameObject2, true);
                            gameObject2.placeBuilding(this.cursor.row, this.cursor.col);
                            gameObject2.completeBuilding(false);
                        } else {
                            GameObject gameObject3 = GameObject.createUnit(n5, n4, this.cursor.row, this.cursor.col);
                            this.addObject(gameObject3);
                            this.addHousing(n4, 1);
                        }
                        this.addObjects();
                        this.updateCursorPosition = true;
                    } else if (gameObject.type == 3) {
                        gameObject.removeObject();
                        this.setTile(this.cursor.row, this.cursor.col, 2);
                        int n7 = gameObject.side() + 1;
                        if (n7 > Engine.gameCurrentNSides - 1) {
                            this.clearSelectionInfo();
                            return;
                        }
                        this.addObject(GameObject.createUnit(0, n7, this.cursor.row, this.cursor.col));
                        this.addHousing(n7, 1);
                    }
                } else {
                    GameObject gameObject = this.getEntityAt(n2, n3, bl ? 2 : 1, 0, -1);
                    if (gameObject != null && gameObject.isSide(0)) {
                        if (gameObject.type == 2) {
                            if (this.isUnitSelected(gameObject)) {
                                this.expandSelection(gameObject);
                            } else {
                                this.selectUnit(gameObject);
                            }
                        } else if (gameObject.state != 0) {
                            this.showBuildingPanel(gameObject, gameObject.bytes[4], true);
                        }
                    } else if (bl) {
                        this.order(this.selectedUnits[0], n2, n3, true);
                    }
                }
            }
        }
    }

    public void cursorBack() {
        if (this.cursor.state == 1) {
            this.cursor.state = 0;
            this.cursorVisible = true;
            this.blinkCursor(0, 0);
            this.refreshBuildingPanel();
            this.updateCursorPosition = true;
        } else if (this.cursor.state == 2) {
            this.cursor.setTile(this.selectedBuildingObject.row, this.selectedBuildingObject.col);
            this.cursor.state = 0;
            this.updateCursorEdges();
            this.showBuildingPanel = true;
            this.showBuildIconDescription = false;
            this.showBuildIconDescriptionCountdown = 15;
        } else if (this.isAnyUnitSelected(0)) {
            this.deselectAllUnits(0);
            this.updateCursorPosition = true;
        }
    }

    public void updateCursorPosition() {
        this.updateCursorPosition(this.cursor.row, this.cursor.col, this.cursor.row, this.cursor.col);
    }

    public void updateCursorPosition(int n, int n2, int n3, int n4) {
        byte[] byArray;
        this.clearSelectionInfo();
        if (this.cursor.state == 0) {
            if (n != n3 || n2 != n4) {
                if (this.isTileProperty(2, 1, n, n2, false) && this.isTileBuilding(n, n2, true)) {
                    int n5 = 0;
                    int n6 = 0;
                    if (n < n3) {
                        n5 = 1;
                    } else if (n > n3) {
                        n5 = -1;
                    } else {
                        n6 = n2 < n4 ? 1 : -1;
                    }
                    while (this.isTileBuilding(n3, n4, true)) {
                        n3 += n5;
                        n4 += n6;
                    }
                    this.cursor.setRow(n3);
                    this.cursor.setCol(n4);
                } else if (this.isTileProperty(2, 1, n3, n4, false) && this.isTileBuilding(n3, n4, true)) {
                    GameObject gameObject = this.getEntityAt(n3, n4);
                    this.cursor.setRow(gameObject.row);
                    this.cursor.setCol(gameObject.col);
                }
            }
            this.checkSelectionInfo();
        } else if (this.cursor.state == 1 && (byArray = this.getBuildingTiles(0, this.currentBuildingType)).length > 3) {
            for (int i = 0; i < byArray.length; i += 3) {
                int n7 = n3 + byArray[i];
                int n8 = n4 + byArray[i + 1];
                if (this.isOnMap(n7, n8)) continue;
                if (n7 > this.mapRows - 1) {
                    this.cursor.setRow(n3 - 1);
                }
                if (n8 <= this.mapCols - 1) break;
                this.cursor.setCol(n4 - 1);
                break;
            }
        }
        this.updateCursorEdges();
    }

    public void clearSelectionInfo() {
        if (this.selectionInfoString != null) {
            this.selectionInfoString = null;
            this.selectionInfoIcon = null;
            this.selectionInfoObject = null;
        }
    }

    public void checkSelectionInfo() {
        this.clearSelectionInfo();
        boolean bl = this.isTileProperty(508, 2, this.cursor.row, this.cursor.col, false);
        GameObject gameObject = this.getEntityAt(this.cursor.row, this.cursor.col);
        if (gameObject != null) {
            if (gameObject.type == 3 && !gameObject.anyBuildingTileVisible() || gameObject.type == 2 && !bl) {
                return;
            }
            this.selectionInfoObject = gameObject;
            if (gameObject.type == 2 && gameObject.isAlive()) {
                this.selectionInfoString = this.getUnitName(gameObject.side(), gameObject.bytes[12]);
            } else if (gameObject.type == 3) {
                this.selectionInfoString = this.getBuildingName(gameObject.bytes[0], gameObject.bytes[4]);
            }
        } else if (this.isTileResource(this.cursor.row, this.cursor.col)) {
            if (!bl) {
                return;
            }
            this.selectionInfoString = "" + this.getTileProperty(536739840, 17, this.cursor.row, this.cursor.col);
            int n = this.getTile(this.cursor.row, this.cursor.col);
            if (n == 5 || n == 78 || n == 79) {
                this.selectionInfoIcon = iconImages[1];
            } else if (n == 0 || n == 76 || n == 1 || n == 77) {
                this.selectionInfoIcon = iconImages[2];
            } else if (n == 6 || n == 74 || n == 75) {
                this.selectionInfoIcon = iconImages[3];
            }
        }
    }

    public void updateCursorEdges() {
        int n = this.cursor.row;
        int n2 = this.cursor.col;
        int n3 = 0;
        if (this.cursor.state == 1 || this.isTileProperty(2, 1, n, n2, false) && this.isTileBuilding(n, n2, true)) {
            Object object;
            int n4;
            int n5;
            int n6;
            boolean bl = false;
            if (this.cursor.state == 1) {
                n6 = this.currentBuildingType;
                n5 = n;
                n4 = n2;
                bl = !this.canBuild(0, n6, n5, n4);
            } else {
                object = this.getEntityAt(n, n2);
                n6 = ((GameObject)object).bytes[4];
                n5 = ((GameObject)object).row;
                n4 = ((GameObject)object).col;
            }
            n3 = bl ? 8 : 0;
            object = this.getBuildingTiles(0, n6);
            if (((Object)object).length > 3) {
                int n7 = n5;
                int n8 = n4;
                this.cursor.ints2[0] = new int[]{n7 - 1, n8 - 1, 7 + n3, n7 + 2, n8 + 2, 3 + n3, n7, n8 - 1, 6 + n3, n7 + 1, n8 - 1, 6 + n3, n7 + 2, n8 - 1, 5 + n3, n7 + 2, n8, 4 + n3, n7 + 2, n8 + 1, 4 + n3, n7 + 1, n8 + 2, 2 + n3, n7, n8 + 2, 2 + n3, n7 - 1, n8 + 2, 1 + n3, n7 - 1, n8, 0 + n3, n7 - 1, n8 + 1, 0 + n3};
                return;
            }
        }
        this.cursor.ints2[0] = new int[]{n - 1, n2 - 1, 7 + n3, n, n2 - 1, 6 + n3, n + 1, n2 - 1, 5 + n3, n + 1, n2, 4 + n3, n + 1, n2 + 1, 3 + n3, n, n2 + 1, 2 + n3, n - 1, n2 + 1, 1 + n3, n - 1, n2, 0 + n3};
    }

    public boolean canBuild(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = -1;
        int n8 = -1;
        byte[] byArray = this.getBuildingTiles(n, n2);
        for (n6 = 0; n6 < byArray.length; n6 += 3) {
            n5 = n3 + byArray[n6];
            int n9 = n4 + byArray[n6 + 1];
            if (this.isOnMap(n5, n9)) {
                int n10;
                int n11 = this.getTile(n5, n9);
                if (n11 == 25 || n11 == 26 || n11 == 30 || n11 == 31 || n11 == 32) {
                    return false;
                }
                if (this.isTileProperty(1, 0, n5, n9)) {
                    return false;
                }
                if (n == 0) {
                    if (!this.isTileProperty(2, 1, n5, n9)) {
                        return false;
                    }
                    for (n10 = 0; n10 < Engine.gameCurrentNSides; ++n10) {
                        if (n10 == 0 || !this.ais[n10].productionEnabled || !this.isWithinTiles(n3, n4, this.ais[n10].startRow, this.ais[n10].startCol, 7)) continue;
                        return false;
                    }
                }
                for (n10 = 0; n10 < Engine.gameCurrentNSides; ++n10) {
                    GameObject[] gameObjectArray = this.units[n10];
                    for (int i = 0; i < gameObjectArray.length; ++i) {
                        GameObject gameObject = gameObjectArray[i];
                        if (gameObject == null || (gameObject.row != n5 || gameObject.col != n9) && (gameObject.bytes[4] != n5 || gameObject.bytes[5] != n9)) continue;
                        return false;
                    }
                }
                if (n5 > n7) {
                    n7 = n5;
                }
                if (n9 <= n8) continue;
                n8 = n9;
                continue;
            }
            return false;
        }
        for (n6 = n3 - 1; n6 <= n7 + 1; ++n6) {
            for (n5 = n4 - 1; n5 <= n8 + 1; ++n5) {
                if (this.isOnMap(n6, n5)) {
                    if (this.isTileWalkable(n6, n5)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public void order(Vector vector, int n, int n2, boolean bl) {
        GameObject gameObject;
        int n3;
        GameObject gameObject2 = (GameObject)vector.elementAt(0);
        int n4 = vector.size();
        int n5 = GameWorld.getDirection(gameObject2.row, gameObject2.col, n, n2);
        int n6 = Integer.MAX_VALUE;
        for (n3 = 0; n3 < n4; ++n3) {
            gameObject = (GameObject)vector.elementAt(n3);
            int n7 = gameObject.getMoveSpeed();
            if (n7 >= n6) continue;
            n6 = n7;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            gameObject = (GameObject)vector.elementAt(n3);
            gameObject.bytes[13] = (byte)n5;
            gameObject.ints[2] = n6;
            gameObject.order(n, n2, bl);
        }
    }

    public void explore(int n, int n2, int n3, boolean bl) {
        for (int i = -n3; i <= n3; ++i) {
            for (int j = -n3; j <= n3; ++j) {
                int n4 = n + i;
                int n5 = n2 + j;
                boolean bl2 = this.isOnMap(n4, n5);
                if (!bl2) continue;
                boolean bl3 = this.isTileProperty(2, 1, n4, n5, false);
                if (!this.isWithinTiles(0, 0, i, j, n3)) continue;
                boolean bl4 = false;
                if (bl) {
                    this.addTileProperty(508, 2, n4, n5, 1, false);
                    if (this.isTileBuilding(n4, n5, false)) {
                        GameObject gameObject = this.getEntityAt(n4, n5, 2, 0, 3);
                        if (gameObject == null) continue;
                        int n6 = gameObject.row;
                        int n7 = gameObject.col;
                        byte[] byArray = this.getBuildingTiles(0, gameObject.bytes[4]);
                        for (int k = 0; k < byArray.length; k += 3) {
                            int n8 = n6 + byArray[k];
                            int n9 = n7 + byArray[k + 1];
                            this.setTileProperty(2, 1, n8, n9, 1, false);
                            this.copyPerceivedTile(n8, n9);
                            if (!this.cursor.isOnTile(n8, n9)) continue;
                            this.updateCursorPosition = true;
                        }
                        continue;
                    }
                    if (!bl3) {
                        this.setTileProperty(2, 1, n4, n5, 1, false);
                    }
                    this.copyPerceivedTile(n4, n5);
                    continue;
                }
                this.addTileProperty(508, 2, n4, n5, -1, false);
                if (!this.cursor.isOnTile(n4, n5)) continue;
                this.updateCursorPosition = true;
            }
        }
    }

    public static int getDirection(int n, int n2, int n3, int n4) {
        int n5 = n3 - n;
        int n6 = n4 - n2;
        if (Math.abs(n6) == 0) {
            if (n5 > 0) {
                return 4;
            }
            return 0;
        }
        if (Math.abs(n5) == 0) {
            if (n6 > 0) {
                return 2;
            }
            return 6;
        }
        if (n5 < 0) {
            if (n6 < 0) {
                return 7;
            }
            return 1;
        }
        if (n6 < 0) {
            return 5;
        }
        return 3;
    }

    public static int getStraightDirection(int n, int n2, int n3, int n4) {
        int n5 = n3 - n;
        int n6 = n4 - n2;
        if (Math.abs(n5) < Math.abs(n6)) {
            return GameWorld.getDirection(n, n2, n, n4);
        }
        return GameWorld.getDirection(n, n2, n3, n2);
    }

    public void setTile(int n, int n2, int n3) {
        if (!this.isOnMap(n, n2)) {
            return;
        }
        this.mapData[n * this.mapCols + n2] = (byte)n3;
        if (this.isTileProperty(508, 2, n, n2, false)) {
            this.mapDataPerceived[n * this.mapCols + n2] = (byte)n3;
        }
        if (this.isTileTall(n3, false)) {
            this.addTallTile(n, n2);
        } else {
            for (int i = 0; i < this.tallTiles.size(); ++i) {
                byte[] byArray = (byte[])this.tallTiles.elementAt(i);
                if (byArray[0] != n || byArray[1] != n2) continue;
                this.tallTiles.removeElementAt(i);
                --i;
            }
        }
    }

    public void addTallTile(int n, int n2) {
        if (this.tallTiles.size() == 0) {
            this.tallTiles.addElement(new byte[]{(byte)n, (byte)n2});
        } else {
            int n3;
            for (n3 = 0; n3 < this.tallTiles.size(); ++n3) {
                byte[] byArray = (byte[])this.tallTiles.elementAt(n3);
                if (byArray[0] != n || byArray[1] != n2) continue;
                return;
            }
            n3 = 0;
            for (int i = 0; i < this.tallTiles.size(); ++i) {
                byte[] byArray = (byte[])this.tallTiles.elementAt(i);
                int n4 = this.mapCols * byArray[0] + byArray[1];
                if (this.mapCols * n + n2 >= n4) continue;
                this.tallTiles.insertElementAt(new byte[]{(byte)n, (byte)n2}, i);
                n3 = 1;
                break;
            }
            if (n3 == 0) {
                this.tallTiles.addElement(new byte[]{(byte)n, (byte)n2});
            }
        }
    }

    public void tickTileAnimations() {
        --this.tileBeachAnimationCountdown;
        if (this.tileBeachAnimationCountdown <= 0) {
            this.tileBeachAnimationIndex = (this.tileBeachAnimationIndex + 1) % 2;
            this.tileBeachAnimationCountdown = 26;
        }
    }

    public int[] getTileSpiral(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        int n6;
        int n7 = n4 == -1 ? this.DIRECTIONS_RND[Engine.rndPositive(4)] : n4;
        boolean bl = Engine.rndPositive(2) == 0;
        int n8 = 0;
        int n9 = n6 = 1;
        int n10 = n;
        int n11 = n2;
        int n12 = 0;
        boolean bl2 = false;
        do {
            n10 += DIRECTION_OFFSETS[2 * n7];
            n11 += DIRECTION_OFFSETS[2 * n7 + 1];
            if (--n9 <= 0) {
                if (++n8 == 2) {
                    n8 = 0;
                    ++n6;
                }
                n9 = n6;
                if (bl) {
                    n7 = (n7 + 2) % 8;
                } else if ((n7 -= 2) < 0) {
                    n7 += 8;
                }
            }
            if (n3 == 0) {
                bl2 = this.isOnMap(n10, n11) && this.isTileWalkable(n10, n11);
            } else if (n3 == 1) {
                bl2 = this.isOnMap(n10, n11) && !this.isTileProperty(1, 0, n10, n11, false) && this.isTileWalkable(n10, n11);
            } else if (n3 == 2) {
                bl2 = this.isOnMap(n10, n11) && !this.isTileSurroundedWithUnwalkableTiles(n10, n11, 1) && (nArray[0] == -1 ? this.isTileResource(n10, n11) : Engine.getMapping(TILE_TO_RESOURCE_MAPPING, this.getTile(n10, n11)) == nArray[0]);
            } else if (n3 == 3) {
                bl2 = this.canBuild(nArray[0], nArray[1], n10, n11);
            }
            if (++n12 < n5) continue;
            return null;
        } while (!bl2);
        return new int[]{n10, n11};
    }

    public int[] getClosestBuildingTile(GameObject gameObject, GameObject gameObject2, boolean bl) {
        int n = Integer.MAX_VALUE;
        int n2 = -1;
        int n3 = -1;
        for (int i = gameObject2.row - (bl ? 1 : 0); i <= gameObject2.bytes[5] + (bl ? (byte)1 : 0); ++i) {
            for (int j = gameObject2.col - (bl ? 1 : 0); j <= gameObject2.bytes[6] + (bl ? (byte)1 : 0); ++j) {
                int n4;
                if (bl && this.isTileProperty(512, 9, i, j, false) || bl && (i != gameObject.bytes[14] || j != gameObject.bytes[15]) && (!this.isTileWalkable(i, j) || this.isTileProperty(1, 0, i, j)) || (n4 = Math.abs(gameObject.row - i) + Math.abs(gameObject.col - j)) >= n) continue;
                n = n4;
                n2 = i;
                n3 = j;
            }
        }
        return new int[]{n2, n3};
    }

    public int getTile(int n, int n2) {
        return this.getTile(n, n2, false);
    }

    public int getTile(int n, int n2, boolean bl) {
        if (!Engine.showMap && bl) {
            return this.mapDataPerceived[n * this.mapCols + n2];
        }
        return this.mapData[n * this.mapCols + n2];
    }

    public int getResourceTile(int n, int n2) {
        int n3;
        int n4 = n3 = this.getTile(n, n2, true);
        int n5 = this.getTileProperty(536739840, 17, n, n2);
        short s = TILE_RESOURCE_AMOUNT[Engine.getMapping(TILE_TO_RESOURCE_MAPPING, n3)];
        if (n3 == 0 || n3 == 76) {
            if (n5 < s / 2) {
                n4 = 76;
            }
        } else if (n3 == 1 || n3 == 77) {
            if (n5 < s / 2) {
                n4 = 77;
            }
        } else if (this.isTileBush(n3)) {
            if (n5 < s / 3) {
                n4 = 79;
            } else if (n5 < 2 * s / 3) {
                n4 = 78;
            }
        } else if (this.isTileRock(n3)) {
            if (n5 < s / 3) {
                n4 = 75;
            } else if (n5 < 2 * s / 3) {
                n4 = 74;
            }
        }
        return n4;
    }

    public boolean isTileTall(int n, boolean bl) {
        if (bl) {
            return n != -1 && TILE_SHEET_MAPPING[2 * n] >= 100;
        }
        return n != 0 && n != 1 && n != -1 && TILE_SHEET_MAPPING[2 * n] >= 100;
    }

    public void setTileProperty(int n, int n2, int n3, int n4, int n5) {
        this.setTileProperty(n, n2, n3, n4, n5, true);
    }

    public void setTileProperty(int n, int n2, int n3, int n4, int n5, boolean bl) {
        if (bl && !this.isOnMap(n3, n4)) {
            return;
        }
        if (n == 7168 && (n5 < 0 || n5 > 4)) {
            return;
        }
        int n6 = n3 * this.mapCols + n4;
        this.mapPropertyData[n6] = this.mapPropertyData[n6] & ~n;
        int n7 = n3 * this.mapCols + n4;
        this.mapPropertyData[n7] = this.mapPropertyData[n7] | n5 << n2;
        if (n == 512 && this.isTileProperty(508, 2, n3, n4, false)) {
            boolean bl2 = this.mapPropertyBuildingPercieved[n3 * this.mapCols + n4] = n5 != 0;
        }
        if (n == 508 && n5 < 0) {
            Engine.debugWrite("Visible set to negative value!", true);
        }
    }

    public void addTileProperty(int n, int n2, int n3, int n4, int n5) {
        this.addTileProperty(n, n2, n3, n4, n5, true);
    }

    public void addTileProperty(int n, int n2, int n3, int n4, int n5, boolean bl) {
        this.setTileProperty(n, n2, n3, n4, this.getTileProperty(n, n2, n3, n4) + n5, bl);
    }

    public int getTileProperty(int n, int n2, int n3, int n4) {
        return this.getTileProperty(n, n2, n3, n4, true);
    }

    public int getTileProperty(int n, int n2, int n3, int n4, boolean bl) {
        if (bl && !this.isOnMap(n3, n4)) {
            return 0;
        }
        return (this.mapPropertyData[n3 * this.mapCols + n4] & n) >> n2;
    }

    public void copyPerceivedTile(int n, int n2) {
        this.mapDataPerceived[this.mapCols * n + n2] = this.mapData[this.mapCols * n + n2];
        this.mapPropertyBuildingPercieved[this.mapCols * n + n2] = this.isTileBuilding(n, n2, false);
    }

    public boolean isTileBuilding(int n, int n2, boolean bl) {
        if (!Engine.showMap && bl) {
            return this.mapPropertyBuildingPercieved[n * this.mapCols + n2];
        }
        return this.isTileProperty(512, 9, n, n2);
    }

    public boolean isTileProperty(int n, int n2, int n3, int n4) {
        return this.isTileProperty(n, n2, n3, n4, true);
    }

    public boolean isTileProperty(int n, int n2, int n3, int n4, boolean bl) {
        if (Engine.showMap && (n == 2 || n == 508)) {
            return true;
        }
        return this.getTileProperty(n, n2, n3, n4, bl) != 0;
    }

    public boolean isTileWalkable(int n, int n2) {
        return this.isTileWalkable(n, n2, true);
    }

    public boolean isTileWalkable(int n, int n2, boolean bl) {
        if (!bl || this.isOnMap(n, n2)) {
            return Engine.getIndexInArray(TILE_WALKABLE, this.getTile(n, n2)) != -1;
        }
        return false;
    }

    public boolean isTileBeach(int n) {
        return n >= 7 && n <= 18 || n >= 62 && n <= 73;
    }

    public boolean isTileResource(int n, int n2) {
        return this.isTileResource(this.getTile(n, n2));
    }

    public boolean isTileResource(int n) {
        return Engine.getIndexInArray(RESOURCE_TILES, n) != -1;
    }

    public boolean isTileBush(int n) {
        return n == 5 || n == 78 || n == 79;
    }

    public boolean isTileRock(int n) {
        return n == 6 || n == 74 || n == 75;
    }

    public boolean isTileSettlerInteractable(int n, int n2) {
        return this.isTileResource(n, n2);
    }

    public boolean isOnMap(int n, int n2) {
        return GameWorld.isOnMap(n, n2, this.mapRows, this.mapCols);
    }

    public static boolean isOnMap(int n, int n2, int n3, int n4) {
        return n >= 0 && n <= n3 - 1 && n2 >= 0 && n2 <= n4 - 1;
    }

    public static int getDistance(int n, int n2, int n3, int n4) {
        return Math.max(Math.abs(n - n3), Math.abs(n2 - n4));
    }

    public boolean isWithinTiles(int n, int n2, int n3, int n4, int n5) {
        return GameWorld.getDistance(n, n2, n3, n4) <= n5 && (n5 <= 1 || Math.abs(n - n3) != Math.abs(n2 - n4) || Math.abs(n - n3) != n5);
    }

    public boolean isWithinTiles(GameObject gameObject, GameObject gameObject2, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        if (gameObject.type == 2) {
            n6 = gameObject.row;
            n7 = gameObject.col;
        } else {
            n5 = Integer.MAX_VALUE;
            byte[] byArray = this.getBuildingTiles(0, gameObject.bytes[4]);
            for (n4 = 0; n4 < byArray.length; n4 += 3) {
                int n8 = gameObject.row + byArray[n4];
                n3 = gameObject.col + byArray[n4 + 1];
                n2 = GameWorld.getDistance(n8, n3, gameObject2.row, gameObject2.col);
                if (n2 >= n5) continue;
                n5 = n2;
                n6 = n8;
                n7 = n3;
            }
        }
        n5 = 0;
        int n9 = 0;
        if (gameObject2.type == 2) {
            n5 = gameObject2.row;
            n9 = gameObject2.col;
        } else {
            n4 = Integer.MAX_VALUE;
            byte[] byArray = this.getBuildingTiles(0, gameObject2.bytes[4]);
            for (n3 = 0; n3 < byArray.length; n3 += 3) {
                n2 = gameObject2.row + byArray[n3];
                int n10 = gameObject2.col + byArray[n3 + 1];
                int n11 = GameWorld.getDistance(n2, n10, gameObject.row, gameObject.col);
                if (n11 >= n4) continue;
                n4 = n11;
                n5 = n2;
                n9 = n10;
            }
        }
        return this.isWithinTiles(n6, n7, n5, n9, n);
    }

    public boolean hasResources(int n, short[] sArray) {
        return this.resources[n][0] >= sArray[0] && this.resources[n][1] >= sArray[1] && this.resources[n][2] >= sArray[2];
    }

    public short[] missingResources(int n, short[] sArray) {
        return new short[]{(short)Math.max(0, sArray[0] - this.resources[n][0]), (short)Math.max(0, sArray[1] - this.resources[n][1]), (short)Math.max(0, sArray[2] - this.resources[n][2])};
    }

    public int getLowestResource(int n) {
        int n2 = -1;
        int s = Integer.MAX_VALUE;
        for (int i = 0; i < 3; ++i) {
            short s2;
            if (this.resources[n][i] >= s2) continue;
            s2 = this.resources[n][i];
            n2 = i;
        }
        return n2;
    }

    public void addResources(int n, short[] sArray) {
        for (int i = 0; i < 3; ++i) {
            this.resources[n][i] = (short)Math.min(29999, this.resources[n][i] + sArray[i]);
        }
        if (n == 0) {
            this.drawHud = true;
        }
    }

    public void addResource(int n, int n2, int n3) {
        short s = (short)n3;
        this.addResources(n, new short[]{n2 == 0 ? s : (short)0, n2 == 1 ? s : (short)0, n2 == 2 ? s : (short)0});
    }

    public void removeResources(int n, short[] sArray) {
        for (int i = 0; i < 3; ++i) {
            short[] sArray2 = this.resources[n];
            int n2 = i;
            sArray2[n2] = (short)(sArray2[n2] - sArray[i]);
        }
        if (n == 0) {
            this.drawHud = true;
        }
    }

    public void addHousing(int n, int n2) {
        int n3 = n;
        this.housing[n3] = this.housing[n3] + n2;
        if (n == 0) {
            this.drawHud = true;
        }
    }

    public void addHousingMax(int n, int n2) {
        int n3 = n;
        this.housingMax[n3] = this.housingMax[n3] + n2;
        if (n == 0) {
            this.drawHud = true;
        }
    }

    public void addXp(int n, int n2, int n3, boolean bl, GameObject gameObject) {
        this.xpPoints += n;
        if (this.xpPoints >= 3000 * (this.xpLevel + 1)) {
            ++this.xpLevel;
            this.xpPoints -= 3000 * this.xpLevel;
            this.xpPointsDisplay = 0;
            this.message(Engine.getText(134));
            if (Engine.tipsOn && !Engine.tipsSeen[0]) {
                Engine.tipsSeen[0] = true;
                if (!Demo.isEnabled()) {
                    this.handleEvent(new short[]{0, 94, 1, 88});
                }
            }
        }
        if (bl) {
            this.addObject(GameObject.createText(n3 * 48 - 24, n2 * 48 - 24, 2 * gameObject.getHeight() << 8, n));
        }
        this.drawHud = true;
    }

    public GameObject getEntityAt(int n, int n2) {
        return this.getEntityAt(n, n2, 0, -1, -1);
    }

    public GameObject getEntityAt(int n, int n2, int n3, int n4, int n5) {
        GameObject[] gameObjectArray = n3 == 1 ? this.objectsPerSide[n4] : this.objects;
        GameObject gameObject = null;
        for (int i = 0; i < gameObjectArray.length; ++i) {
            GameObject gameObject2 = gameObjectArray[i];
            if (gameObject2 == null || !gameObject2.isEntity()) continue;
            boolean bl = false;
            if ((n5 == 2 || n5 == -1) && gameObject2.type == 2) {
                if (gameObject2.isAlive() && gameObject2.row == n && gameObject2.col == n2) {
                    bl = true;
                }
            } else if ((n5 == 3 || n5 == -1) && gameObject2.type == 3 && n >= gameObject2.row && n <= gameObject2.bytes[5] && n2 >= gameObject2.col && n2 <= gameObject2.bytes[6]) {
                bl = true;
            }
            if (!bl) continue;
            gameObject = gameObject2;
            if (n3 == 1) {
                bl = gameObject2.isSide(n4);
            } else if (n3 == 2) {
                boolean bl2 = bl = !gameObject2.isSide(n4);
            }
            if (bl) break;
        }
        return gameObject;
    }

    public GameObject getEntityWithId(int n) {
        for (int i = 0; i < this.objects.length; ++i) {
            GameObject gameObject = this.objects[i];
            if (gameObject == null || !gameObject.isEntity() || gameObject.id != n) continue;
            return gameObject;
        }
        return null;
    }

    public GameObject getEntity(int n, int n2, int n3) {
        GameObject[] gameObjectArray = n == 2 ? this.units[n3] : this.buildings[n3];
        for (int i = 0; i < gameObjectArray.length; ++i) {
            GameObject gameObject = gameObjectArray[i];
            if (gameObject == null || n2 != -1 && (n != 2 || n2 != gameObject.bytes[12]) && (n != 3 || n2 != gameObject.bytes[4])) continue;
            return gameObject;
        }
        return null;
    }

    public int countEntities(int n, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < this.objects.length; ++i) {
            GameObject gameObject = this.objects[i];
            if (gameObject == null || gameObject.type != n || !gameObject.isSide(n3) || n2 != -1 && (n != 2 || n2 != gameObject.bytes[12]) && (n != 3 || n2 != gameObject.bytes[4])) continue;
            ++n4;
        }
        return n4;
    }

    public byte[] getBuildingTiles(int n, int n2) {
        if (this.age[n] == 0) {
            return BUILDING_TILES_DISCOVERY[n2];
        }
        return BUILDING_TILES_COLONIAL[n2];
    }

    public GameObject getExplorer() {
        GameObject[] gameObjectArray = this.units[0];
        for (int i = 0; i < gameObjectArray.length; ++i) {
            GameObject gameObject = gameObjectArray[i];
            if (gameObject == null || !gameObject.isExplorer()) continue;
            return gameObject;
        }
        return null;
    }

    public void deselectUnit(GameObject gameObject) {
        this.selectedUnits[gameObject.side()].removeElement(gameObject);
    }

    public void deselectAllUnits(int n) {
        this.selectedUnits[n].removeAllElements();
    }

    public void selectUnit(GameObject gameObject) {
        this.deselectAllUnits(gameObject.side());
        this.addUnitToSelection(gameObject);
    }

    public void addUnitsToSelection(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.addUnitToSelection((GameObject)vector.elementAt(i));
        }
    }

    public boolean addUnitToSelection(GameObject gameObject) {
        if (this.isUnitSelected(gameObject)) {
            return true;
        }
        int n = gameObject.side();
        byte by = gameObject.ints[4] == -1 ? UNIT_FORMATION_PRIORITY[gameObject.bytes[12]] : (byte)-1;
        int n2 = this.selectedUnits[n].size();
        for (int i = 0; i < n2; ++i) {
            GameObject gameObject2 = (GameObject)this.selectedUnits[n].elementAt(i);
            if (by >= UNIT_FORMATION_PRIORITY[gameObject2.bytes[12]]) continue;
            this.selectedUnits[n].insertElementAt(gameObject, i);
            return true;
        }
        this.selectedUnits[n].addElement(gameObject);
        return true;
    }

    public boolean isUnitSelected(GameObject gameObject) {
        return this.selectedUnits[gameObject.side()].contains(gameObject);
    }

    public boolean isAnyUnitSelected(int n) {
        return this.selectedUnits[n].size() > 0;
    }

    public int getSelectionIndex(GameObject gameObject) {
        return this.selectedUnits[gameObject.side()].indexOf(gameObject);
    }

    public void expandSelection(GameObject gameObject) {
        boolean bl;
        if (!gameObject.isAlive()) {
            return;
        }
        boolean bl2 = bl = gameObject.bytes[12] == 0;
        if (!gameObject.expandSelection(true)) {
            if (bl) {
                this.selectUnit(gameObject);
            } else if (!gameObject.expandSelection(false)) {
                this.selectUnit(gameObject);
            }
        }
    }

    public int getRow(int n) {
        return (n >> 8) / 48;
    }

    public int getCol(int n) {
        return (n >> 8) / 48;
    }

    public void scrollView(boolean bl) {
        if (this.focusedObject != null) {
            int[] nArray = this.logicToIsometric(this.focusedObject.x >> 8, this.focusedObject.y >> 8, tileWidthIsometric, tileHeightIsometric);
            int n = nArray[0] - 88;
            int n2 = nArray[1] - this.viewHeight / 2;
            if (bl) {
                this.mapViewX = n;
                this.mapViewY = n2;
            } else {
                int n3 = (n - this.mapViewX) / 2;
                int n4 = (n2 - this.mapViewY) / 2;
                this.mapViewX = n3 == 0 && this.mapViewX != n ? n : (this.mapViewX += n3);
                this.mapViewY = n4 == 0 && this.mapViewY != n2 ? n2 : (this.mapViewY += n4);
            }
        }
    }

    public void nextAge(int n) {
        int n2 = n;
        this.age[n2] = this.age[n2] + 1;
        if (n == 0) {
            if (this.showBuildingPanel) {
                this.refreshBuildingPanel();
            }
            this.message(Engine.getText(141, new String[]{GameWorld.getAgeName(this.age[n])}));
        }
        GameObject[] gameObjectArray = this.buildings[n];
        for (int i = 0; i < gameObjectArray.length; ++i) {
            GameObject gameObject = gameObjectArray[i];
            if (gameObject == null) continue;
            if (gameObject.state != 0) {
                gameObject.updateBuildingTileMap(false);
            }
            if (gameObject.row != this.cursor.row || gameObject.col != this.cursor.col) continue;
            this.updateCursorPosition = true;
        }
    }

    public void nextUpgrade(GameObject gameObject, int n, int n2, int n3) {
        int n4 = gameObject.side();
        this.upgrades[n4][n] = (byte)n2;
        if (n4 == 0) {
            int n5;
            if (this.showBuildingPanel) {
                this.refreshBuildingPanel();
            }
            this.message(Engine.getText(146, new String[]{GameWorld.getUpgradeName(gameObject.bytes[4], n2 - 1)}));
            int n6 = n2 - 1;
            GameObject[] gameObjectArray = this.units[0];
            for (n5 = 0; n5 < gameObjectArray.length; ++n5) {
                GameObject gameObject2 = gameObjectArray[n5];
                if (gameObject2 == null || gameObject2.getAttackCategory() != n) continue;
                int n7 = GameObject.getBonus(n6, gameObject2.bytes[12]);
                int n8 = gameObject2.getBonus();
                if (n8 <= n7) continue;
                gameObject2.ints[0] = (100 + n8 - n7) * gameObject2.ints[0] / 100;
            }
            for (n5 = 0; n5 < Engine.gameCurrentNSides; ++n5) {
                if (n5 == 0) continue;
                this.ais[n5].playerUpgraded(gameObject.bytes[4], n3);
            }
        } else {
            Engine.echo("[GameWorld.nextUpgrade] " + gameObject.side() + ", " + n + ", " + n2);
        }
        this.updateCursorPosition = true;
    }

    public void showBuildingPanel(GameObject gameObject, int n, boolean bl) {
        if (BUILDING_PANEL_ICONS[n] != null) {
            Vector<Integer> vector = new Vector<Integer>();
            for (int i = 0; i < BUILDING_PANEL_ICONS[n].length; ++i) {
                byte by = BUILDING_PANEL_ICONS[n][i];
                byte by2 = BUILD_ICON_TYPES[by];
                boolean bl2 = BUILD_ICONS_MAPPING[by] == -1 ? false : (by2 == 1 ? (by == 0 ? true : this.hasTownCenter[0]) : true);
                if (!bl2) continue;
                boolean bl3 = bl2 = (this.buildIconsEnabled & 1 << by) != 0;
                if (!bl2) continue;
                boolean bl4 = bl2 = this.age[0] >= BUILD_ICON_AGES[by];
                if (!bl2) continue;
                if (by2 == 2) {
                    boolean bl5 = bl2 = this.age[0] == BUILD_ICON_AGES[by];
                    if (bl2) {
                        bl2 = !this.isBuildIconQueued(by);
                    }
                } else if (by2 == 4) {
                    int n2 = Engine.getMapping(BUILDING_TYPE_TO_ATTACK_CATEGORY_MAPPING, n);
                    boolean bl6 = bl2 = this.age[0] >= n2;
                    if (bl2) {
                        int n3 = Engine.getMapping(BUILD_ICON_TO_UPGRADE_LEVEL_MAPPING, (int)by);
                        boolean bl7 = bl2 = this.upgrades[0][n2] == n3 - 1;
                        if (bl2) {
                            boolean bl8 = bl2 = !this.isBuildIconQueuedInBuilding(gameObject, by);
                        }
                    }
                }
                if (!bl2) continue;
                vector.addElement(new Integer(by));
            }
            this.buildPanelIcons = Engine.vectorToIntArray(vector);
            if (bl) {
                this.selectedBuildingObject = gameObject;
                this.selectedBuildingType = n;
                this.buildPanelSelectedIndex = 0;
                this.buildPanelStartIndex = 0;
                this.buildPanelQueueStartIndex = 0;
                this.buildPanelQueue = false;
                this.showBuildingPanel = true;
            } else {
                this.checkBuildingPanelEdges(false);
            }
            this.updateBuildPanelName();
        }
    }

    public void refreshBuildingPanel() {
        this.showBuildingPanel(this.selectedBuildingObject, this.selectedBuildingType, false);
    }

    public boolean isBuildIconQueued(int n) {
        GameObject[] gameObjectArray = this.buildings[0];
        for (int i = 0; i < gameObjectArray.length; ++i) {
            GameObject gameObject = gameObjectArray[i];
            if (gameObject == null || !this.isBuildIconQueuedInBuilding(gameObject, n)) continue;
            return true;
        }
        return false;
    }

    public boolean isBuildIconQueuedInBuilding(GameObject gameObject, int n) {
        int[] nArray = gameObject.ints2[0];
        if (nArray != null) {
            for (int i = 0; i < nArray.length; i += 2) {
                if (nArray[i] != n) continue;
                return true;
            }
        }
        return false;
    }

    public void tickBuildingPanel() {
        boolean bl = false;
        if (Engine.isPressedRepeat(4)) {
            --this.buildPanelSelectedIndex;
            bl = true;
        } else if (Engine.isPressedRepeat(8)) {
            ++this.buildPanelSelectedIndex;
            bl = true;
        } else if (Engine.key(1)) {
            if (this.selectedBuildingObject != null && this.selectedBuildingObject.ints2[0].length > 0) {
                this.buildPanelQueue = true;
                this.buildPanelSelectedIndex += this.buildPanelQueueStartIndex - this.buildPanelStartIndex;
                bl = true;
            }
        } else if (Engine.key(2)) {
            this.buildPanelQueue = false;
            this.buildPanelSelectedIndex += this.buildPanelStartIndex - this.buildPanelQueueStartIndex;
            bl = true;
        } else if (Engine.key(128)) {
            this.closeBuildingPanel();
        } else if (Engine.key(16) || Engine.key(64)) {
            this.buildingPanelAction();
        }
        if (bl) {
            this.checkBuildingPanelEdges(true);
            this.updateBuildPanelName();
        }
    }

    public void closeBuildingPanel() {
        if (this.selectedBuildingObject != null) {
            this.selectedBuildingObject = null;
        }
        this.buildPanelIcons = null;
        this.buildPanelName = null;
        this.showBuildingPanel = false;
        this.updateCursorPosition = true;
    }

    public void checkBuildingPanelEdges(boolean bl) {
        if (this.buildPanelQueue) {
            int[] nArray = this.checkIconRowEdges(this.selectedBuildingObject.ints2[0].length / 2, this.buildPanelSelectedIndex, this.buildPanelQueueStartIndex, this.buildPanelNIconsVisible, bl);
            this.buildPanelSelectedIndex = nArray[0];
            this.buildPanelQueueStartIndex = nArray[1];
        } else {
            int[] nArray = this.checkIconRowEdges(this.buildPanelIcons.length, this.buildPanelSelectedIndex, this.buildPanelStartIndex, this.buildPanelNIconsVisible, bl);
            this.buildPanelSelectedIndex = nArray[0];
            this.buildPanelStartIndex = nArray[1];
        }
    }

    public int[] checkIconRowEdges(int n, int n2, int n3, int n4, boolean bl) {
        if (n2 < 0) {
            if (bl) {
                n2 = n - 1;
                n3 = Math.max(0, n2 - n4 + 1);
            } else {
                n2 = 0;
                n3 = 0;
            }
        } else if (n2 < n3) {
            --n3;
        }
        if (n2 > n - 1) {
            if (bl) {
                n2 = 0;
                n3 = 0;
            } else {
                n2 = n - 1;
                n3 = Math.max(0, n2 - n4 + 1);
            }
        } else if (n2 > n3 + n4 - 1) {
            ++n3;
        }
        if (n3 + n4 > n) {
            n3 = Math.max(0, n - n4);
        }
        return new int[]{n2, n3};
    }

    public void updateBuildPanelName() {
        int n = this.buildPanelQueue ? this.selectedBuildingObject.ints2[0][2 * this.buildPanelSelectedIndex] : this.buildPanelIcons[this.buildPanelSelectedIndex];
        byte by = BUILD_ICON_TYPES[n];
        String string = null;
        if (by == 0) {
            string = this.getUnitName(0, n - 8);
        } else if (by == 1) {
            string = this.getBuildingName(0, n - -1);
        } else if (by == 2) {
            string = Engine.getText(114, new String[]{GameWorld.getAgeName(n - 16 + 1)});
        } else if (by == 3) {
            string = GameWorld.getTradeName(n - 18);
        } else if (by == 4) {
            string = GameWorld.getUpgradeName(this.selectedBuildingObject.bytes[4], n - 24);
        } else if (n == 22) {
            string = Engine.getText(192);
            this.razeConfirmation = false;
        } else if (n == 23) {
            string = Engine.getText(194);
        }
        if (string != null) {
            this.setBuildPanelName(string);
        }
        this.buildIconDescriptionStrings = this.getBuildIconDescription(n);
        if (this.buildIconDescriptionStrings != null) {
            this.buildIconDescriptionHeight = 4 + Math.max(3, this.buildIconDescriptionStrings.length) * FontMgr.charHeight[Engine.font];
            this.showBuildIconDescriptionCountdown = 15;
        }
        this.showBuildIconDescription = false;
    }

    public String[] getBuildIconDescription(int n) {
        byte by = BUILD_ICON_TYPES[n];
        if (by == 2) {
            n = 16;
        } else if (by == 4) {
            n = 24;
        } else if (by == 3) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(Engine.getText(56 + n + 1) + "\n\n");
        if (by == 0) {
            byte[] byArray;
            int n2;
            int n3 = n - 8;
            stringBuffer.append(Engine.getText(84) + GameObject.getHitPoints(0, 2, n3, false) + "\n");
            int n4 = GameObject.getAttackPoints(0, 2, n3, false);
            if (n4 > 0) {
                byte by2 = UNIT_ATTACK_POINTS_SPREAD[n3];
                stringBuffer.append(Engine.getText(85) + (n4 - by2) + " - " + (n4 + by2) + "\n");
                n2 = UNIT_INTERACTION_RANGE[n3];
                stringBuffer.append(Engine.getText(86) + Engine.getText(n2 > 1 ? 26 : 27) + "\n");
            }
            if ((byArray = UNIT_STRONG_AGAINST[n3]) != null) {
                stringBuffer.append(Engine.getText(87));
                for (n2 = 0; n2 < byArray.length; ++n2) {
                    String string = GameWorld.getCategoryName(byArray[n2]);
                    stringBuffer.append(string);
                    if (n2 >= byArray.length - 1) continue;
                    stringBuffer.append(", ");
                }
            }
        } else if (by == 1) {
            int n5 = n - -1;
            stringBuffer.append(Engine.getText(84) + GameObject.getHitPoints(0, 3, n5, false));
            int n6 = GameObject.getAttackPoints(0, 3, n5, false);
            if (n6 > 0) {
                stringBuffer.append("\n" + Engine.getText(85) + n6);
            }
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return Engine.getStrings(stringBuffer.toString(), 168, Engine.font);
    }

    public void buildingPanelAction() {
        if (this.buildPanelQueue) {
            int n = this.selectedBuildingObject.ints2[0][2 * this.buildPanelSelectedIndex];
            this.addResources(0, BUILD_ICON_RESOURCES[n]);
            if (BUILD_ICON_TYPES[n] == 0) {
                this.addHousing(this.selectedBuildingObject.side(), -1);
            }
            this.selectedBuildingObject.removeFromBuildQueue(this.buildPanelSelectedIndex, 1);
        } else {
            int n = this.buildPanelIcons[this.buildPanelSelectedIndex];
            byte by = BUILD_ICON_TYPES[n];
            if (!this.hasResources(0, BUILD_ICON_RESOURCES[n])) {
                this.message(Engine.getText(133));
                return;
            }
            if (by == 1) {
                if (n == 0 || n == 1) {
                    int n2;
                    int n3 = 0;
                    GameObject[] gameObjectArray = this.buildings[0];
                    for (n2 = 0; n2 < gameObjectArray.length; ++n2) {
                        if (gameObjectArray[n2] == null) continue;
                        if (gameObjectArray[n2].bytes[4] == 2) {
                            n3 += 5;
                            continue;
                        }
                        if (gameObjectArray[n2].bytes[4] != 1) continue;
                        n3 += 10;
                    }
                    int n4 = n2 = n == 0 ? 10 : 5;
                    if (n3 + n2 > 30) {
                        this.message(Engine.getText(136));
                        return;
                    }
                }
                this.currentBuildingType = n - -1;
                this.cursorBlinkCountdown = 2;
                this.canBuildCountdown = 15;
                this.cursor.state = 1;
                this.blinkCursor(2, -1);
                this.updateCursorPosition = true;
                this.closeBuildingPanel();
            } else if (by == 3) {
                this.removeResources(0, BUILD_ICON_RESOURCES[n]);
                int n5 = n == 18 || n == 19 ? 75 : 100;
                this.addResource(0, Engine.getMapping(BUILD_ICON_TO_RESOURCE_MAPPING, n), n5);
            } else if (by == 0 || by == 2 || by == 4) {
                this.selectedBuildingObject.tryQueueBuilding(n);
                if (by == 2 || by == 4) {
                    this.refreshBuildingPanel();
                }
            } else if (n == 22) {
                if (this.razeConfirmation) {
                    this.selectedBuildingObject.loseHealth(null, this.selectedBuildingObject.ints[0]);
                    this.closeBuildingPanel();
                } else {
                    this.razeConfirmation = true;
                    this.setBuildPanelName(Engine.getText(193));
                }
            } else if (n == 23) {
                this.cursor.setTile(this.selectedBuildingObject.bytes[7], this.selectedBuildingObject.bytes[8]);
                this.cursor.state = 2;
                this.showBuildingPanel = false;
            }
        }
    }

    public void setBuildPanelName(String string) {
        this.buildPanelName = string;
        int n = FontMgr.stringWidth(Engine.font, string);
        this.buildPanelNameX = 2;
        if (n > 172) {
            this.buildPanelNameEndX = 2 - (n - 172) - 2;
            this.buildPanelNameXCountdown = 10;
        } else {
            this.buildPanelNameXCountdown = -1;
        }
    }

    public void showBuildIconDescription() {
        if (Engine.tipsOn) {
            this.showBuildIconDescription = true;
        }
    }

    public void drawBuildingPanel(Graphics graphics) {
        int n;
        int n2;
        this.drawIconRow(graphics, this.buildPanelIconsX, this.buildPanelY, this.buildPanelLeftArrowX, this.buildPanelRightArrowX, this.buildPanelArrowsY, this.buildPanelIcons, this.buildPanelStartIndex, this.buildPanelNIconsVisible, this.buildPanelQueue ? -1 : this.buildPanelSelectedIndex, 0);
        if (this.selectedBuildingObject != null) {
            this.drawIconRow(graphics, this.buildPanelIconsX, this.buildPanelQueueY, this.buildPanelLeftArrowX, this.buildPanelRightArrowX, this.buildPanelQueueArrowsY, this.selectedBuildingObject.ints2[0], this.buildPanelQueueStartIndex, this.buildPanelNIconsVisible, this.buildPanelQueue ? this.buildPanelSelectedIndex : -1, 1);
        }
        int n3 = 208 - Engine.woodPanelImage.height - this.buildPanelTopHeight;
        graphics.setColor(3155992);
        graphics.fillRect(0, n3, 176, this.buildPanelTopHeight);
        FontMgr.drawString(Engine.font, graphics, this.buildPanelName, this.buildPanelNameX, n3, 20);
        if (!this.buildPanelQueue) {
            n2 = Device.USE_BITMAP_FONTS ? FontMgr.charHeight[Engine.font] : (int)GameWorld.numberImages[0].height;
            n = this.buildPanelIcons[this.buildPanelSelectedIndex];
            short[] sArray = BUILD_ICON_RESOURCES[n];
            if (sArray[0] != 0 || sArray[1] != 0 || sArray[2] != 0) {
                short[] sArray2 = this.missingResources(0, sArray);
                n3 = 208 - Engine.woodPanelImage.height - n2;
                int n4 = n3 + n2 / 2;
                for (int i = 0; i < 3; ++i) {
                    iconImages[1 + i].drawImage(graphics, this.hudBuildIconX[i], n4, 6);
                    String string = "" + sArray[i];
                    if (sArray2[i] > 0) {
                        int n5 = Device.USE_BITMAP_FONTS ? FontMgr.stringWidth(Engine.font, string) : string.length() * GameWorld.numberImages[0].width;
                        graphics.setColor(10423571);
                        graphics.fillRect((int)this.hudBuildTextX[i], n3, n5, Device.USE_BITMAP_FONTS ? this.buildPanelTopHeight / 2 : (int)GameWorld.numberImages[0].height);
                    }
                    if (Device.USE_BITMAP_FONTS) {
                        FontMgr.drawString(Engine.font, graphics, string, this.hudBuildTextX[i], n3, 20);
                        continue;
                    }
                    this.drawNumbers(graphics, string, this.hudBuildTextX[i], n3, 20);
                }
            }
        }
        if (this.showBuildIconDescription && this.buildIconDescriptionStrings != null) {
            n2 = this.buildPanelY - this.buildPanelTopHeight - 2 - this.buildIconDescriptionHeight;
            if (this.selectedBuildingObject != null && this.selectedBuildingObject.ints2[0].length > 0) {
                n2 -= 4 + GameWorld.buildIconImages[0].height;
            }
            Engine.drawBox(graphics, 2, n2, 172, this.buildIconDescriptionHeight, -1728053248);
            n3 = n2 + 2;
            for (n = 0; n < this.buildIconDescriptionStrings.length; ++n) {
                FontMgr.drawString(Engine.font, graphics, this.buildIconDescriptionStrings[n], 4, n3, 20);
                n3 += FontMgr.charHeight[Engine.font];
            }
        }
        Engine.paintTooltips(graphics, 16);
    }

    public void drawIconRow(Graphics graphics, int n, int n2, int n3, int n4, int n5, int[] nArray, int n6, int n7, int n8, int n9) {
        boolean bl = n9 == 1;
        int n10 = GameWorld.buildIconImages[0].height + 2;
        int n11 = n2 + 2;
        if (!bl) {
            Engine.drawImageWidth(graphics, Engine.woodPanelImage, 0, n2, 176);
        }
        int n12 = n;
        int n13 = n11;
        int n14 = bl ? nArray.length / 2 : nArray.length;
        int n15 = n6;
        for (int i = 0; n15 < n14 && i < n7; ++n15, ++i) {
            int n16;
            if (n15 == n8 || bl) {
                graphics.setColor(n15 == n8 ? (n9 == 2 ? 47616 : 0xFFFFFF) : 0);
                graphics.fillRect(n12 - 1, n13 - 1, n10, n10);
            }
            buildIconImages[BUILD_ICONS_MAPPING[bl ? nArray[2 * n15] : nArray[n15]]].drawImage(graphics, n12, n13);
            if (bl) {
                if (n15 == 0) {
                    n16 = this.selectedBuildingObject.ints[4];
                    int n17 = n16 == 0 ? 0 : 100 * this.selectedBuildingObject.ints[3] / n16;
                    int n18 = (100 - n17) * GameWorld.buildIconImages[0].height / 100;
                    Engine.drawBox(graphics, n12, n13, GameWorld.buildIconImages[0].width, n18, -1776689094);
                }
                if ((n16 = nArray[2 * n15 + 1]) > 1) {
                    FontMgr.drawString(Engine.font, graphics, "" + n16, n12 + 2, n13 + GameWorld.buildIconImages[0].height - 2, 68);
                }
            } else if (n9 == 2) {
                n16 = SUPPORT_CARD_AGES[this.capitalScreenDrawingAge][n15];
                if (this.age[0] < this.capitalScreenDrawingAge || this.supportCardUses[n16] == 0) {
                    Engine.drawBox(graphics, n12, n13, GameWorld.buildIconImages[0].width, GameWorld.buildIconImages[0].height, -1437379757);
                }
            }
            n12 += GameWorld.buildIconImages[0].width + 2;
        }
        if (n6 > 0) {
            Engine.arrowHImages[0].drawImage(graphics, n3, n5);
        }
        if (n6 + n7 < n14) {
            Engine.arrowHImages[1].drawImage(graphics, n4, n5);
        }
    }

    public void paint(Graphics graphics) {
        int n;
        Engine.trace = "GameWorld.paint Start";
        if (this.state == this.STATE_CUTSCENE) {
            this.drawCutscene(graphics);
            return;
        }
        int n2 = -this.mapViewX;
        int n3 = this.viewY - this.mapViewY;
        graphics.setClip(0, this.hudHeight, 176, 208 - this.hudHeight);
        Engine.cls(graphics, 0);
        this.drawWorld(graphics, n2, n3, 176, this.viewHeight, 0);
        if (Engine.debugMode == 11) {
            for (n = 0; n < this.objects.length; ++n) {
                GameObject gameObject = this.objects[n];
                if (gameObject == null) continue;
                int[] nArray = this.logicToIsometric(gameObject.x >> 8, gameObject.y >> 8, tileWidthIsometric, tileHeightIsometric);
                if (gameObject.type == 2) {
                    int[] nArray2;
                    int n4;
                    int[] nArray3;
                    int n5;
                    int n6;
                    int[] nArray4 = gameObject.ints2[0];
                    byte by = gameObject.bytes[10];
                    if (nArray4 != null) {
                        graphics.setColor(255);
                        int n7 = nArray[0];
                        n6 = nArray[1] + tileHeightIsometric / 2;
                        for (int i = 2 * by; i < nArray4.length; i += 2) {
                            int[] nArray5 = this.logicToIsometric(nArray4[i + 1] * 48, nArray4[i] * 48, tileWidthIsometric, tileHeightIsometric);
                            n5 = nArray5[0];
                            int n8 = nArray5[1] + tileHeightIsometric / 2;
                            graphics.drawLine(n7 + n2, n6 + n3, n5 + n2, n8 + n3);
                            n7 = n5;
                            n6 = n8;
                        }
                        nArray3 = this.logicToIsometric(nArray4[nArray4.length - 1] * 48, nArray4[nArray4.length - 2] * 48, tileWidthIsometric, tileHeightIsometric);
                        n4 = nArray3[0];
                        n5 = nArray3[1] + tileHeightIsometric / 2;
                        graphics.setColor(0);
                        graphics.fillRect(n4 - 2 + n2, n5 - 2 + n3, 4, 4);
                    }
                    if ((nArray2 = gameObject.ints2[1]) == null) continue;
                    for (n6 = 0; n6 < nArray2.length; n6 += 2) {
                        nArray3 = this.logicToIsometric(nArray2[n6 + 1] * 48, nArray2[n6] * 48, tileWidthIsometric, tileHeightIsometric);
                        n4 = nArray3[0];
                        n5 = nArray3[1] + tileHeightIsometric / 2;
                        graphics.setColor(0);
                        graphics.fillArc(n4 - 3 + n2, n5 - 3 + n3, 6, 6, 0, 360);
                    }
                    continue;
                }
                if (gameObject.type != 3) continue;
                FontMgr.drawString(Engine.font, graphics, "" + gameObject.bytes[4], nArray[0] - 4 + n2, nArray[1] + n3, 72);
            }
        }
        this.drawHud(graphics);
        this.drawStatus(graphics);
        if (this.eventDialog != null) {
            int n9;
            for (int i = n = 208 - this.eventDialogHeight; i < 208; i += Engine.woodPanelImage.height) {
                Engine.drawImageWidth(graphics, Engine.woodPanelImage, 0, i, 176);
            }
            n = 208 - this.eventDialogHeight;
            DeviceImage deviceImage = Engine.menuBorderImages[4];
            for (n9 = 0; n9 < 176; n9 += Engine.menuBorderWidth) {
                deviceImage.drawImage(graphics, n9, n);
            }
            portraitImage.drawImage(graphics, 0, 208, 36);
            n = 208 - this.eventDialogHeight + Engine.menuBorderHeight / 3 + 2;
            n9 = this.eventDialogStartIndex;
            for (int i = 0; n9 < this.eventDialog.length && i < this.eventDialogNVisible; ++n9, ++i) {
                FontMgr.drawString(Engine.font, graphics, this.eventDialog[n9], GameWorld.portraitImage.width + 2, n, 20);
                n += FontMgr.charHeight[Engine.font];
            }
            if (this.eventDialogBlockCountdown == 0) {
                Engine.paintTooltips(graphics, 2);
            }
        }
        if (this.cursorBlinkCountdown > 0) {
            --this.cursorBlinkCountdown;
            if (this.cursorBlinkCountdown <= 0) {
                boolean bl = this.cursorVisible = !this.cursorVisible;
                if (this.cursorBlinkCountdownPasses == -1) {
                    this.cursorBlinkCountdown = this.cursorBlinkInterval;
                } else {
                    --this.cursorBlinkCountdownPasses;
                    if (this.cursorBlinkCountdownPasses == 0) {
                        this.cursorVisible = true;
                    } else {
                        this.cursorBlinkCountdown = this.cursorBlinkInterval;
                    }
                }
            }
        }
        Engine.trace = "GameWorld.paint End";
    }

    public void drawWorld(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.drawWorld(graphics, n, n2, n3, n4, n5, 0, 0);
    }

    public void drawWorld(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n5 == 2) {
            int n8 = 0;
            for (int i = 0; i < this.tallTiles.size(); ++i) {
                byte[] byArray = (byte[])this.tallTiles.elementAt(i);
                boolean bl = this.isTileProperty(508, 2, byArray[0], byArray[1], false);
                if (!bl) continue;
                DeviceImage deviceImage = this.getTileImage(this.getTile(byArray[0], byArray[1]), false, bl);
                int[] nArray = this.logicToIsometric(byArray[1] * 48, byArray[0] * 48, tileWidthIsometric, tileHeightIsometric);
                if (!this.isRectOnScreen(nArray[0] - tileWidthIsometric / 2, nArray[1] - (deviceImage.height - tileHeightIsometric), tileWidthIsometric, deviceImage.height)) continue;
                while (n8 < this.objectsOnScreen.length && this.objectsOnScreen[n8].getScreenValue1() < this.mapCols * byArray[0] + byArray[1]) {
                    this.objectsOnScreen[n8].paint(graphics, n, n2, false);
                    ++n8;
                }
                deviceImage.drawImage(graphics, nArray[0] + n, nArray[1] + tileHeightIsometric + n2, 33);
            }
            while (n8 < this.objectsOnScreen.length) {
                this.objectsOnScreen[n8].paint(graphics, n, n2, false);
                ++n8;
            }
            return;
        }
        int n9 = tileWidthIsometric;
        int n10 = -n - n9 / 2;
        int n11 = tileHeightIsometric;
        int n12 = -n2 - n11 / 2;
        int[] nArray = this.isometricToLogic(n10, n12, n9, n11);
        if (nArray[0] < 0) {
            nArray[0] = nArray[0] - 48;
        }
        if (nArray[1] < 0) {
            nArray[1] = nArray[1] - 48;
        }
        int n13 = nArray[1] / 48;
        int n14 = nArray[0] / 48;
        int[] nArray2 = this.logicToIsometric(n14 * 48, n13 * 48, n9, n11);
        int n15 = nArray2[0];
        int n16 = nArray2[1];
        int n17 = n15;
        int n18 = n15 + (this.cursor.col - n14) * n9 / 2 - (this.cursor.row - n13) * n9 / 2;
        int n19 = n16 + (this.cursor.col - n14) * n11 / 2 + (this.cursor.row - n13) * n11 / 2;
        int n20 = n13;
        int n21 = n14;
        int n22 = n20;
        int n23 = n21;
        int n24 = 0;
        int n25 = 0;
        while (true) {
            int n26;
            int n27;
            int n28;
            int n29;
            int n30;
            boolean bl = this.isOnMap(n22, n23);
            boolean bl2 = false;
            if (bl && (n5 == 1 || this.isRectOnScreen(n15 - n9 / 2, n16 - 2 * n11, n9, n11 + 2 * n11)) && (n5 != 1 || bl2 || cacheAllTiles) && (n30 = this.getTile(n22, n23, true)) != -1) {
                n29 = this.isTileProperty(2, 1, n22, n23, false);
                n28 = this.isTileProperty(508, 2, n22, n23, false);
                n27 = -1;
                n26 = 0;
                if (n29 != 0) {
                    n27 = n30;
                }
                if (n27 != -1) {
                    this.getTileImage(n27, false, n28 != 0).drawImageAs(graphics, n15 + n + n6, n16 + n11 + n2 + n7, n27 == -2 || n26 != 0 ? 0 : (int)Engine.getMapping(MANIPULATION_MAPPING, (int)TILE_SHEET_MAPPING[2 * n27 + 1]), 33);
                }
                if (n5 != 1 && n29 != 0 && n28 == 0) {
                    tileFogImage.drawImage(graphics, n15 + n + n6, n16 + n11 + n2 + n7, 33);
                }
            }
            --n22;
            ++n23;
            if ((n15 += n9) - n9 / 2 + n <= n3) continue;
            if (n5 == 0 || n5 == 2) {
                if (this.cursorVisible && !this.isCurrentEventLocking()) {
                    if (this.cursor.state == 2) {
                        if (this.cursor.row + this.cursor.col == n22 + n23) {
                            int[] nArray3 = this.logicToIsometric(this.cursor.col * 48, this.cursor.row * 48, n9, n11);
                            rallyPointFlagImage.drawImage(graphics, nArray3[0] + n + n6, nArray3[1] + n11 / 2 + n2 + n7, 33);
                        }
                    } else {
                        int n31;
                        int n32;
                        int n33;
                        int n34;
                        int[] nArray4 = this.cursor.ints2[0];
                        for (n29 = 0; n29 < nArray4.length; n29 += 3) {
                            n28 = nArray4[n29];
                            n27 = nArray4[n29 + 1];
                            n26 = nArray4[n29 + 2] % 8;
                            if (n28 + n27 != n22 + n23 || (n26 == 4 || n26 == 2 || n26 == 3) && this.isOnMap(n28, n27) && this.isTileTall(this.getTile(n28, n27, true), false) && this.isTileProperty(2, 1, n28, n27, false)) continue;
                            n34 = n27 - this.cursor.col;
                            n33 = n28 - this.cursor.row;
                            n32 = n34 * n9 / 2 - n33 * n9 / 2;
                            n31 = n34 * n11 / 2 + n33 * n11 / 2;
                            cursorImages[nArray4[n29 + 2]].drawImage(graphics, n18 + n32 + CURSOR_EDGE_PAINT_OFFSETS[2 * n26] + n + n6, n19 + n31 + CURSOR_EDGE_PAINT_OFFSETS[2 * n26 + 1] + n2 + n7);
                        }
                        if (this.cursor.state == 1) {
                            n29 = this.cursor.row;
                            n28 = this.cursor.col;
                            byte[] byArray = this.getBuildingTiles(0, this.currentBuildingType);
                            for (n26 = 0; n26 < byArray.length; n26 += 3) {
                                n34 = n29 + byArray[n26];
                                n33 = n28 + byArray[n26 + 1];
                                if (n34 + n33 != n22 + n23) continue;
                                n32 = n33 - this.cursor.col;
                                n31 = n34 - this.cursor.row;
                                int n35 = n32 * n9 / 2 - n31 * n9 / 2;
                                int n36 = n32 * n11 / 2 + n31 * n11 / 2;
                                byte by = byArray[n26 + 2];
                                if (by < 0) continue;
                                this.getTileImage(by, false, true).drawImage(graphics, n18 + n35 + n + n6, n19 + n36 + tileHeightIsometric + n2 + n7, 33);
                            }
                        }
                    }
                }
                for (n30 = n25; n30 < this.objectsOnScreen.length; ++n30) {
                    GameObject gameObject = this.objectsOnScreen[n30];
                    ++n25;
                    int n37 = n28 = gameObject.type == 3 ? gameObject.row + gameObject.col : gameObject.getRow(10) + gameObject.getCol(10);
                    if (n28 > n22 + n23) {
                        --n25;
                        break;
                    }
                    gameObject.paint(graphics, n + n6, n2 + n7, false);
                }
            }
            if ((n16 += n11 / 2) - 3 * n11 + n2 > n4) break;
            if (n24 % 2 == 0) {
                n22 = n20 + 1;
                n23 = n21;
                n15 = n17 - n9 / 2;
            } else {
                n22 = n20;
                n23 = n21 + 1;
                n15 = n17;
            }
            n20 = n22;
            n21 = n23;
            ++n24;
        }
    }

    public DeviceImage getTileImage(int n, boolean bl, boolean bl2) {
        if ((n = TILE_SHEET_MAPPING[2 * n]) >= 100) {
            if (!bl2) {
                // empty if block
            }
            return tileTallImages[n - 100];
        }
        if (!bl2) {
            // empty if block
        }
        return tileImages[n];
    }

    public int[] logicToIsometric(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (48 % (n3 / 2) != 0 || 48 % (n4 / 2) != 0) {
            n6 = Engine.div(n - n2 << 8, Engine.div(12288, (n3 << 8) / 2)) >> 8;
            n5 = Engine.div(n + n2 << 8, Engine.div(12288, (n4 << 8) / 2)) >> 8;
        } else {
            n6 = (n - n2) / (48 / (n3 / 2));
            n5 = (n + n2) / (48 / (n4 / 2));
        }
        return new int[]{n6, n5};
    }

    public int[] isometricToLogic(int n, int n2, int n3, int n4) {
        int n5 = Engine.div(12288, n3 << 8);
        int n6 = Engine.div(12288, n4 << 8);
        int n7 = Engine.mul(n << 8, n5) + Engine.mul(n2 << 8, n6);
        int n8 = Engine.mul(n2 << 8, n6) - Engine.mul(n << 8, n5);
        return new int[]{n7 >> 8, n8 >> 8};
    }

    public void drawHud(Graphics graphics) {
        int n;
        int n2;
        boolean bl = false;
        if (!this.drawHud) {
            return;
        }
        Engine.saveAndSetClip(graphics, 0, 0, 176, this.hudHeight);
        graphics.setColor(3221272);
        graphics.fillRect(0, 0, 176, this.hudHeight);
        int n3 = this.hudHeight - this.hudXpHeight;
        short s = GameWorld.iconImages[1].width;
        if (Device.USE_BITMAP_FONTS) {
            n2 = 0;
            n = 20;
        } else {
            n2 = 1;
            n = 20;
        }
        iconImages[1].drawImage(graphics, this.hudFoodIconX, n3 / 2, 6);
        if (Device.USE_BITMAP_FONTS) {
            FontMgr.drawString(Engine.font, graphics, "" + this.resources[0][0], this.hudFoodIconX + s + 1, n2, n);
        } else {
            this.drawNumbers(graphics, "" + this.resources[0][0], this.hudFoodIconX + s + 1, n2, n);
        }
        iconImages[2].drawImage(graphics, this.hudWoodIconX, n3 / 2, 6);
        if (Device.USE_BITMAP_FONTS) {
            FontMgr.drawString(Engine.font, graphics, "" + this.resources[0][1], this.hudWoodIconX + s + 1, n2, n);
        } else {
            this.drawNumbers(graphics, "" + this.resources[0][1], this.hudWoodIconX + s + 1, n2, n);
        }
        iconImages[3].drawImage(graphics, this.hudGoldIconX, n3 / 2, 6);
        if (Device.USE_BITMAP_FONTS) {
            FontMgr.drawString(Engine.font, graphics, "" + this.resources[0][2], this.hudGoldIconX + s + 1, n2, n);
        } else {
            this.drawNumbers(graphics, "" + this.resources[0][2], this.hudGoldIconX + s + 1, n2, n);
        }
        iconImages[4].drawImage(graphics, this.hudHousingIconX, n3 / 2, 6);
        if (Device.USE_BITMAP_FONTS) {
            FontMgr.drawString(Engine.font, graphics, this.housing[0] + "/" + this.housingMax[0], this.hudHousingIconX + s + 0, n2, n);
        } else {
            this.drawNumbers(graphics, this.housing[0] + "/" + this.housingMax[0], this.hudHousingIconX + s + 0, n2, n);
        }
        Engine.restoreClip(graphics);
        this.drawHud = false;
    }

    public void drawNumbers(Graphics graphics, String string, int n, int n2, int n3) {
        int n4 = n;
        for (int i = 0; i < string.length(); ++i) {
            int n5 = string.charAt(i) == '/' ? 10 : string.charAt(i) - 48;
            numberImages[n5].drawImage(graphics, n4, n2, n3);
            n4 += GameWorld.numberImages[n5].width;
        }
    }

    public void drawStatus(Graphics graphics) {
        int n;
        int n2;
        int n3 = 0;
        if (this.paused) {
            if (this.showPauseIcon) {
                pauseImages[0].drawImage(graphics, 172, this.hudHeight + 4, 24);
            }
        } else if (this.playCountdown > 0) {
            pauseImages[1].drawImage(graphics, 172, this.hudHeight + 4, 24);
        }
        n3 = this.showBuildingPanel || this.cursor.state == 1 || this.cursor.state == 2 || this.isAnyUnitSelected(0) ? (n3 |= 1) : (n3 |= 4);
        if (!this.showBuildingPanel && this.cursor.state == 0) {
            n3 |= 0x10;
        }
        if (this.showBuildingPanel) {
            if (this.eventDialog == null) {
                this.drawBuildingPanel(graphics);
            }
        } else if (this.selectionInfoString != null && this.cursor.state != 1 && this.cursor.state != 2) {
            n2 = Engine.tipsImages[0].width + 6;
            if (this.selectionInfoIcon != null) {
                this.selectionInfoIcon.drawImage(graphics, n2, 206 - FontMgr.charHeight[Engine.font] / 2 + -1, 6);
                n2 += this.selectionInfoIcon.width + 1;
            }
            FontMgr.drawString(Engine.font, graphics, this.selectionInfoString, n2, 206, 68);
        }
        if (this.message != null) {
            messageIconImage.drawImage(graphics, 1, this.hudHeight + 1);
            n2 = GameWorld.messageIconImage.width + 2;
            n = this.hudHeight + 1;
            for (int i = 0; i < this.message.length; ++i) {
                FontMgr.drawString(Engine.font, graphics, this.message[i], n2, n, 20);
                n += FontMgr.charHeight[Engine.font] + 1;
            }
        }
        Engine.paintTooltips(graphics, n3);
        if (Engine.debugMode == 11) {
            n2 = FontMgr.charHeight[Engine.font] - 2;
            n = this.hudHeight + 1;
            FontMgr.drawString(Engine.font, graphics, "Cursor: " + this.cursor.row + ", " + this.cursor.col, 1, n, 20);
            n += n2;
            if (this.currentEvent != null && this.currentEvent[0] == 4 && this.currentEvent[1] == 2) {
                FontMgr.drawString(Engine.font, graphics, "Event wait: " + this.currentEvent[2], 1, n, 20);
                n += n2;
            }
        } else if (Engine.debugMode == 9) {
            n2 = FontMgr.charHeight[Engine.font] - 4;
            n = this.hudHeight + 1;
            FontMgr.drawString(Engine.font, graphics, "AI info (" + Engine.debugAiIndex + ") / " + this.ais[Engine.debugAiIndex].productionEnabled + " / " + this.ais[Engine.debugAiIndex].personality + " / " + this.ais[Engine.debugAiIndex].lost, 1, n, 20);
            FontMgr.drawString(Engine.font, graphics, "Next update in: " + this.ais[Engine.debugAiIndex].checkCounter, 1, n += n2, 20);
            FontMgr.drawString(Engine.font, graphics, "Stage: " + this.ais[Engine.debugAiIndex].stage + " / " + this.ais[Engine.debugAiIndex].stageCountdown, 1, n += n2, 20);
            FontMgr.drawString(Engine.font, graphics, "Units: " + this.ais[Engine.debugAiIndex].units.size(), 1, n += n2, 20);
            FontMgr.drawString(Engine.font, graphics, "Settlers: " + this.ais[Engine.debugAiIndex].settlers.size(), 1, n += n2, 20);
            FontMgr.drawString(Engine.font, graphics, "Attack units: " + this.ais[Engine.debugAiIndex].attackUnits.size(), 1, n += n2, 20);
            FontMgr.drawString(Engine.font, graphics, "Defense units: " + this.ais[Engine.debugAiIndex].defenseUnits.size(), 1, n += n2, 20);
            FontMgr.drawString(Engine.font, graphics, "Attack region: " + this.ais[Engine.debugAiIndex].attackRegionRow + ", " + this.ais[Engine.debugAiIndex].attackRegionCol, 1, n += n2, 20);
            FontMgr.drawString(Engine.font, graphics, "Buildings: " + this.ais[Engine.debugAiIndex].buildings.size(), 1, n += n2, 20);
            FontMgr.drawString(Engine.font, graphics, "Market ticker: " + this.ais[Engine.debugAiIndex].marketTickerCountdown, 1, n += n2, 20);
            FontMgr.drawString(Engine.font, graphics, "Build fort: " + this.ais[Engine.debugAiIndex].buildFort, 1, n += n2, 20);
            FontMgr.drawString(Engine.font, graphics, "Resources: " + this.resources[Engine.debugAiIndex][0] + "/" + this.resources[Engine.debugAiIndex][1] + "/" + this.resources[Engine.debugAiIndex][2], 1, n += n2, 20);
            FontMgr.drawString(Engine.font, graphics, "Resource gathering: " + this.ais[Engine.debugAiIndex].resourceGathering[0] + "/" + this.ais[Engine.debugAiIndex].resourceGathering[1] + "/" + this.ais[Engine.debugAiIndex].resourceGathering[2], 1, n += n2, 20);
            FontMgr.drawString(Engine.font, graphics, "Resource needed: " + this.ais[Engine.debugAiIndex].resourceNeeded[0] + "/" + this.ais[Engine.debugAiIndex].resourceNeeded[1] + "/" + this.ais[Engine.debugAiIndex].resourceNeeded[2], 1, n += n2, 20);
            FontMgr.drawString(Engine.font, graphics, "Housing: " + this.housing[Engine.debugAiIndex] + "/" + this.housingMax[Engine.debugAiIndex], 1, n += n2, 20);
            FontMgr.drawString(Engine.font, graphics, "Current age: " + GameWorld.getAgeName(this.age[this.ais[Engine.debugAiIndex].side]), 1, n += n2, 20);
            FontMgr.drawString(Engine.font, graphics, "Advancing to age: " + GameWorld.getAgeName(this.ais[Engine.debugAiIndex].ageCurrentAdvancing), 1, n += n2, 20);
            FontMgr.drawString(Engine.font, graphics, "Age queue: " + AI.queueToString(this.ais[Engine.debugAiIndex].ageQueue, 2), 1, n += n2, 20);
            FontMgr.drawString(Engine.font, graphics, "Upgrade queue: " + AI.queueToString(this.ais[Engine.debugAiIndex].upgradeQueue, 1), 1, n += n2, 20);
            FontMgr.drawString(Engine.font, graphics, "Build queue: " + AI.queueToString(this.ais[Engine.debugAiIndex].buildQueue, 2), 1, n += n2, 20);
            FontMgr.drawString(Engine.font, graphics, "Unit queue: " + AI.queueToString(this.ais[Engine.debugAiIndex].unitQueue, 2), 1, n += n2, 20);
        } else if (Engine.debugMode == 13) {
            // empty if block
        }
        if (Engine.debugMode == 1 || Engine.debugMode == 15 || Engine.debugMode == 16 || Engine.debugMode == 17) {
            FontMgr.drawString(Engine.font, graphics, Engine.DEBUG_NAMES[Engine.debugMode] + " (0 exits)", 88, 206, 65);
        } else if (Engine.debugForceNoCache) {
            FontMgr.drawString(Engine.font, graphics, "Forcing no cache", 88, 206, 65);
        }
    }

    public boolean isRectOnScreen(int n, int n2, int n3, int n4) {
        int n5 = this.mapViewY;
        int n6 = this.mapViewY + this.viewHeight;
        int n7 = this.mapViewX;
        int n8 = this.mapViewX + 176;
        return n2 <= n6 && n2 + n4 >= n5 && n <= n8 && n + n3 >= n7;
    }

    public void message(String string) {
        this.message(string, -1, -1);
    }

    public void message(String string, GameObject gameObject) {
        this.messageQueue.addElement(string);
        this.messageDataQueue.addElement(new int[]{gameObject.id});
    }

    public void message(String string, int n, int n2) {
        boolean bl = false;
        Enumeration enumeration = this.messageQueue.elements();
        while (enumeration.hasMoreElements()) {
            if (!string.equals(enumeration.nextElement())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.messageQueue.addElement(string);
            this.messageDataQueue.addElement(new int[]{n, n2});
        }
    }

    public void tickMessage() {
        if (this.message == null) {
            if (this.messageQueue.size() > 0) {
                String string = (String)this.messageQueue.elementAt(0);
                int[] nArray = (int[])this.messageDataQueue.elementAt(0);
                this.message = Engine.getStrings(string, 176 - GameWorld.messageIconImage.width - GameWorld.pauseImages[0].width - 6, Engine.font);
                if (nArray.length == 2) {
                    if (nArray[0] != -1) {
                        this.messageRow = nArray[0];
                        this.messageCol = nArray[1];
                    }
                } else {
                    this.messageObject = this.getEntityWithId(nArray[0]);
                }
                this.messageQueue.removeElementAt(0);
                this.messageDataQueue.removeElementAt(0);
                this.messageCountdown = 40;
                this.messageActiveCountdown = 100;
            }
        } else {
            --this.messageCountdown;
            if (this.messageCountdown <= 0) {
                this.message = null;
                this.messageObject = null;
            }
        }
        if (this.messageAttackCountdown > 0) {
            --this.messageAttackCountdown;
        }
        if (this.messageActiveCountdown > 0) {
            --this.messageActiveCountdown;
            if (this.messageActiveCountdown <= 0) {
                this.messageRow = -1;
                this.messageCol = -1;
                this.messageObject = null;
            }
        }
    }

    public void requestPath(GameObject gameObject, int n, int n2, int n3, int n4) {
        if (this.isRequestingPath(gameObject)) {
            this.removePathRequest(gameObject);
        }
        this.vSources.addElement(gameObject);
        this.vFromTo.addElement(new byte[]{(byte)n, (byte)n2, (byte)n3, (byte)n4});
        this.vCheapestNodes.addElement(null);
        this.vCurrentNodes.addElement(null);
        this.vNodes.addElement(null);
    }

    public boolean isRequestingPath(GameObject gameObject) {
        return this.vSources.contains(gameObject);
    }

    public void removePathRequest(GameObject gameObject) {
        for (int i = 0; i < this.vSources.size(); ++i) {
            if (this.vSources.elementAt(i) != gameObject) continue;
            this.removePathRequest(i);
            --i;
        }
    }

    public void removePathRequest(int n) {
        this.vSources.removeElementAt(n);
        this.vFromTo.removeElementAt(n);
        this.vCheapestNodes.removeElementAt(n);
        this.vCurrentNodes.removeElementAt(n);
        this.vNodes.removeElementAt(n);
    }

    public void tickPathfinding() {
        if (this.vFromTo.size() > 0) {
            this.nRevolutionsLeftThisTick = 6;
            this.currentPathIndex = this.savedPathIndex = Math.min(this.vFromTo.size() - 1, this.savedPathIndex);
        }
        while (this.vFromTo.size() > 0) {
            byte[] byArray = (byte[])this.vFromTo.elementAt(this.currentPathIndex);
            this.currentNode = null;
            if (this.vCurrentNodes.elementAt(this.currentPathIndex) != null) {
                this.currentNode = (AStarNode)this.vCurrentNodes.elementAt(this.currentPathIndex);
            }
            this.cheapestOpenNodes = null;
            if (this.vCheapestNodes.elementAt(this.currentPathIndex) != null) {
                this.cheapestOpenNodes = (Vector)this.vCheapestNodes.elementAt(this.currentPathIndex);
            }
            this.currentNodes = null;
            if (this.vNodes.elementAt(this.currentPathIndex) != null) {
                this.currentNodes = (Hashtable)this.vNodes.elementAt(this.currentPathIndex);
            }
            GameObject gameObject = (GameObject)this.vSources.elementAt(this.currentPathIndex);
            int[] nArray = this.getPathToTile(byArray[0], byArray[1], byArray[2], byArray[3], 1);
            if (nArray == null || nArray.length > 0) {
                this.removePathRequest(this.currentPathIndex);
                --this.currentPathIndex;
            }
            if (nArray != null) {
                if (nArray.length == 0) {
                    this.vCurrentNodes.setElementAt(this.currentNode, this.currentPathIndex);
                    this.vCheapestNodes.setElementAt(this.cheapestOpenNodes, this.currentPathIndex);
                    this.vNodes.setElementAt(this.currentNodes, this.currentPathIndex);
                } else {
                    gameObject.setPath(nArray, true);
                }
            }
            this.currentNode = null;
            this.cheapestOpenNodes = null;
            this.currentNodes = null;
            if (++this.currentPathIndex >= this.vFromTo.size()) {
                this.currentPathIndex = 0;
            }
            if (--this.nRevolutionsLeftThisTick <= 0) {
                if (this.vFromTo.size() == 0) {
                    this.savedPathIndex = 0;
                    break;
                }
                this.savedPathIndex = this.currentPathIndex;
                break;
            }
            if (nArray != null) continue;
            Engine.echo("No path found");
        }
    }

    public void tickPathFinding(Vector vector, Vector vector2, int n) {
        for (int i = 0; i < n; ++i) {
            if (vector.size() <= 0) continue;
            GameObject gameObject = (GameObject)vector.elementAt(0);
            byte[] byArray = (byte[])vector2.elementAt(0);
            int[] nArray = this.getPathToTile(byArray[0], byArray[1], byArray[2], byArray[3], 20);
            if (nArray != null && nArray.length > 0) {
                this.removePathRequest(gameObject);
                gameObject.setPath(nArray, true);
                this.currentNode = null;
                this.cheapestOpenNodes = null;
                this.currentNodes = null;
            } else if (nArray == null) {
                this.removePathRequest(gameObject);
                this.currentNode = null;
                this.cheapestOpenNodes = null;
                this.currentNodes = null;
            }
            if (nArray != null && nArray.length != 0) continue;
            gameObject.ints2[1] = null;
            gameObject.stop();
        }
    }

    public boolean isTileSurroundedWithUnwalkableTiles(int n, int n2, int n3) {
        for (int i = n - 1; i <= n + 1; ++i) {
            for (int j = n2 - 1; j <= n2 + 1; ++j) {
                if (i == n && j == n2 || !this.isOnMap(i, j) || !this.isTileWalkable(i, j) || n3 != 0 && this.isTileProperty(1, 0, i, j)) continue;
                return false;
            }
        }
        return true;
    }

    public int[] getPathToTile(int n, int n2, int n3, int n4, int n5) {
        if (n == n3 && n2 == n4) {
            return new int[]{n, n2};
        }
        if (this.currentNodes == null && (this.isTileSurroundedWithUnwalkableTiles(n3, n4, 0) || !this.isOnMap(n3, n4))) {
            return null;
        }
        try {
            int n6 = n;
            int n7 = n2;
            if (this.currentNodes == null) {
                this.currentNode = new AStarNode(null, n, n2, 0, 0, 0, 1);
                this.currentNodes = new Hashtable();
                this.currentNodes.put(new Short((short)(n * this.mapCols + n2)), this.currentNode);
                this.cheapestOpenNodes = new Vector();
            }
            for (int i = 0; n5 == -1 || i < n5; ++i) {
                if (this.currentNode == null) {
                    Engine.echo("Path not found (currentNode == null)! (" + n + "," + n2 + " -> " + n3 + "," + n4 + ")");
                    this.printPath(n, n2, n3, n4);
                    return null;
                }
                this.currentNode.list = 2;
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        AStarNode aStarNode;
                        int n8;
                        int n9;
                        int n10;
                        int n11 = this.currentNode.row + j;
                        int n12 = this.currentNode.col + k;
                        boolean bl = false;
                        if (!(Math.abs(j) + Math.abs(k) != 2 || this.isTileWalkable(n11, n12 - k) && this.isTileWalkable(n11 - j, n12))) {
                            bl = true;
                        }
                        if (!bl) {
                            int n13 = this.getTile(this.currentNode.row, this.currentNode.col);
                            n10 = this.isOnMap(n11, n12) ? this.getTile(n11, n12) : -1;
                            n9 = GameWorld.getDirection(this.currentNode.row, this.currentNode.col, n11, n12);
                            for (n8 = 0; n8 < TILE_UNWALKABLE.length; n8 += 3) {
                                if ((TILE_UNWALKABLE[n8] != 0 || TILE_UNWALKABLE[n8 + 1] != n13) && (TILE_UNWALKABLE[n8] != 1 || TILE_UNWALKABLE[n8 + 1] != n10) || TILE_UNWALKABLE[n8 + 2] != n9) continue;
                                bl = true;
                                break;
                            }
                        }
                        if (bl) continue;
                        if (n11 == n3 && n12 == n4) {
                            return this.constructPath(n6, n7, n11, n12);
                        }
                        if (n11 < 0 || n11 >= this.mapRows || n12 < 0 || n12 >= this.mapCols || (aStarNode = (AStarNode)this.currentNodes.get(new Short((short)(n11 * this.mapCols + n12)))) != null && aStarNode.list == 2 || bl) continue;
                        if (this.isTileWalkable(n11, n12)) {
                            n10 = Math.abs(k) + Math.abs(j) == 2 ? this.currentNode.g + 361 : this.currentNode.g + 256;
                            n9 = Math.abs(n11 - n3) + Math.abs(n12 - n4) << 8;
                            n8 = n10 + n9;
                            if (aStarNode != null && aStarNode.list == 1) {
                                if (n10 >= aStarNode.g) continue;
                                aStarNode.parent = this.currentNode;
                                aStarNode.g = n10;
                                aStarNode.f = n8;
                                continue;
                            }
                            AStarNode aStarNode2 = new AStarNode(this.currentNode, n11, n12, n10, n9, n8, 1);
                            this.currentNodes.put(new Short((short)(n11 * this.mapCols + n12)), aStarNode2);
                            boolean bl2 = false;
                            for (int i2 = 0; i2 < this.cheapestOpenNodes.size(); ++i2) {
                                AStarNode aStarNode3 = (AStarNode)this.cheapestOpenNodes.elementAt(i2);
                                if (aStarNode2.f >= aStarNode3.f) continue;
                                this.cheapestOpenNodes.insertElementAt(aStarNode2, i2);
                                bl2 = true;
                                break;
                            }
                            if (bl2) continue;
                            this.cheapestOpenNodes.addElement(aStarNode2);
                            continue;
                        }
                        if (n11 != n3 || n12 != n4) continue;
                        return this.constructPath(n6, n7, n11, n12);
                    }
                }
                if (this.cheapestOpenNodes.size() == 0) {
                    this.currentNode = null;
                    continue;
                }
                this.currentNode = (AStarNode)this.cheapestOpenNodes.elementAt(0);
                this.cheapestOpenNodes.removeElementAt(0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printPath(n, n2, n3, n4);
        }
        return new int[0];
    }

    public int[] constructPath(int n, int n2, int n3, int n4) {
        Vector<int[]> vector = new Vector<int[]>();
        vector.addElement(new int[]{n3, n4});
        while (this.currentNode != null && (this.currentNode.row != n || this.currentNode.col != n2)) {
            vector.addElement(new int[]{this.currentNode.row, this.currentNode.col});
            this.currentNode = this.currentNode.parent;
        }
        int[] nArray = new int[vector.size() << 1];
        int n5 = vector.size() - 1;
        int n6 = 0;
        while (n5 >= 0) {
            int[] nArray2 = (int[])vector.elementAt(n5);
            nArray[n6] = (short)nArray2[0];
            nArray[n6 + 1] = (short)nArray2[1];
            --n5;
            n6 += 2;
        }
        return this.backtrackPath(nArray, n, n2);
    }

    public int[] backtrackPath(int[] nArray, int n, int n2) {
        for (int i = nArray.length - 2; i >= 0; i -= 2) {
            int n3 = nArray[i];
            int n4 = nArray[i + 1];
            if (!this.isTileWalkable(n3, n4)) continue;
            int[] nArray2 = new int[i + 2];
            System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
            nArray = nArray2;
            return nArray2;
        }
        return new int[]{n, n2};
    }

    public void printPath(int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.mapRows; ++i) {
            for (int j = 0; j < this.mapCols; ++j) {
                if (i == n3 && j == n4) {
                    System.out.print("E");
                    continue;
                }
                if (i == n && j == n2) {
                    System.out.print("S");
                    continue;
                }
                if (this.isTileProperty(1, 0, i, j)) {
                    System.out.print("B");
                    continue;
                }
                if (!this.isTileWalkable(i, j)) {
                    System.out.print("X");
                    continue;
                }
                System.out.print("O");
            }
            System.out.println();
        }
    }

    public void setCapitalScreen() {
        if (this.getEntity(3, 1, 0) == null) {
            this.helpPopup(null, Engine.getText(149), false);
        } else {
            this.capitalScreenSelectionAge = 0;
            this.capitalScreenSelectionIndex = 0;
            this.capitalScreenStartIndex = new int[3];
            this.supportCardIcons = new int[SUPPORT_CARD_AGES.length][];
            for (int i = 0; i < this.supportCardIcons.length; ++i) {
                this.supportCardIcons[i] = new int[SUPPORT_CARD_AGES[i].length];
                for (int j = 0; j < this.supportCardIcons[i].length; ++j) {
                    this.supportCardIcons[i][j] = SUPPORT_CARD_ICONS[SUPPORT_CARD_AGES[i][j]];
                }
            }
            this.updateCapitalScreenName();
            this.state = this.STATE_CAPITAL_SCREEN;
            Engine.state = 100;
            if (Engine.tipsOn && !Engine.tipsSeen[1]) {
                Engine.tipsSeen[1] = true;
                this.helpPopup(Engine.getText(47), Engine.getText(95), true);
            }
        }
    }

    public void tickCapitalScreen() {
        boolean bl = false;
        if (Engine.key(128)) {
            this.state = this.STATE_GAME;
            this.supportCardIcons = null;
            Engine.state = 10;
        } else if (Engine.isPressedRepeat(4)) {
            --this.capitalScreenSelectionIndex;
            bl = true;
        } else if (Engine.isPressedRepeat(8)) {
            ++this.capitalScreenSelectionIndex;
            bl = true;
        } else if (Engine.isPressedRepeat(1)) {
            if (this.capitalScreenSelectionAge > 0) {
                this.capitalScreenSelectionIndex += this.capitalScreenStartIndex[this.capitalScreenSelectionAge - 1] - this.capitalScreenStartIndex[this.capitalScreenSelectionAge];
                --this.capitalScreenSelectionAge;
                bl = true;
            }
        } else if (Engine.isPressedRepeat(2)) {
            if (this.capitalScreenSelectionAge < 2) {
                this.capitalScreenSelectionIndex += this.capitalScreenStartIndex[this.capitalScreenSelectionAge + 1] - this.capitalScreenStartIndex[this.capitalScreenSelectionAge];
                ++this.capitalScreenSelectionAge;
                bl = true;
            }
        } else if (Engine.key(16) || Engine.key(64)) {
            this.capitalScreenAction();
        }
        if (bl) {
            this.checkCapitalScreenEdges(true);
            this.updateCapitalScreenName();
        }
    }

    public void checkCapitalScreenEdges(boolean bl) {
        int[] nArray = this.checkIconRowEdges(SUPPORT_CARD_AGES[this.capitalScreenSelectionAge].length, this.capitalScreenSelectionIndex, this.capitalScreenStartIndex[this.capitalScreenSelectionAge], this.capitalScreenNIconsVisible, bl);
        this.capitalScreenSelectionIndex = nArray[0];
        this.capitalScreenStartIndex[this.capitalScreenSelectionAge] = nArray[1];
    }

    public void updateCapitalScreenName() {
        this.capitalCurrentName = this.getSupportCardName(SUPPORT_CARD_AGES[this.capitalScreenSelectionAge][this.capitalScreenSelectionIndex]);
    }

    public void drawCapitalScreen(Graphics graphics) {
        this.drawHud(graphics);
        byte by = SUPPORT_CARD_AGES[this.capitalScreenSelectionAge][this.capitalScreenSelectionIndex];
        int n = this.hudHeight;
        int n2 = FontMgr.charHeight[Engine.font];
        graphics.setColor(0);
        graphics.fillRect(0, n, 176, n2);
        FontMgr.drawString(Engine.font, graphics, GameWorld.getAgeName(this.age[0]), 88, n, 17);
        graphics.fillRect(0, n += n2, 176, 208 - n);
        n = 208 - 3 * Engine.woodPanelImage.height - n2 - 1;
        graphics.setColor(3221272);
        graphics.fillRect(0, n, 176, n2);
        FontMgr.drawString(Engine.font, graphics, this.capitalCurrentName, 2, n, 20);
        FontMgr.drawString(Engine.font, graphics, Engine.getText(116, new String[]{this.supportCardUses[by] == -1 ? Engine.getText(117) : "" + this.supportCardUses[by]}), 174, n, 24);
        n += n2;
        for (int i = 0; i < 3; ++i) {
            int n3 = n + (Engine.woodPanelImage.height - Engine.arrowVImages[0].height) / 2;
            this.capitalScreenDrawingAge = i;
            this.drawIconRow(graphics, this.capitalScreenIconsX, n, this.capitalScreenLeftArrowX, this.capitalScreenRightArrowX, n3, this.supportCardIcons[i], this.capitalScreenStartIndex[i], this.capitalScreenNIconsVisible, i == this.capitalScreenSelectionAge ? this.capitalScreenSelectionIndex : -1, 2);
            ageIconImages[i].drawImage(graphics, 2, n + 2);
            n += Engine.woodPanelImage.height;
        }
        Engine.paintTooltips(graphics, this.xpLevel > 0 && this.age[0] >= this.capitalScreenSelectionAge && this.supportCardUses[by] != 0 ? 3 : 1);
    }

    public void capitalScreenAction() {
        byte by = SUPPORT_CARD_AGES[this.capitalScreenSelectionAge][this.capitalScreenSelectionIndex];
        if (this.xpLevel <= 0 || this.age[0] < this.capitalScreenSelectionAge || this.supportCardUses[by] == 0) {
            return;
        }
        byte by2 = SUPPORT_CARD_AGES[this.capitalScreenSelectionAge][this.capitalScreenSelectionIndex];
        short[] sArray = SUPPORT_CARD_EFFECTS[by2];
        if (sArray[0] == 8) {
            int n = -1;
            int n2 = -1;
            GameObject gameObject = this.getEntity(3, 1, 0);
            if (gameObject != null) {
                n = gameObject.row;
                n2 = gameObject.col;
            }
            if (n != -1) {
                this.handleEvent(new short[]{sArray[0], sArray[1], 0, (short)n, (short)n2, sArray[2]});
                this.cursor.setTile(n, n2);
                this.updateCursorPosition = true;
            }
        } else {
            this.handleEvent(new short[]{sArray[0], sArray[1] == 0 ? sArray[2] : (short)0, sArray[1] == 1 ? sArray[2] : (short)0, sArray[1] == 2 ? sArray[2] : (short)0});
        }
        --this.xpLevel;
        if (this.supportCardUses[by] > 0) {
            byte by3 = by;
            this.supportCardUses[by3] = (byte)(this.supportCardUses[by3] - 1);
        }
        this.playMusic();
        this.state = this.STATE_GAME;
    }

    public void setCutscene(String string) {
        this.cutsceneStrings = Engine.getStrings(string, 166, Engine.font);
        this.state = this.STATE_CUTSCENE;
    }

    public void drawCutscene(Graphics graphics) {
        Engine.cls(graphics, 0);
        int n = (208 - this.cutsceneStrings.length * FontMgr.charHeight[Engine.font]) / 2;
        for (int i = 0; i < this.cutsceneStrings.length; ++i) {
            FontMgr.drawString(Engine.font, graphics, this.cutsceneStrings[i], 88, n, 17);
            n += FontMgr.charHeight[Engine.font];
        }
        if (this.cutSceneForwardMethod == 0) {
            Engine.paintTooltips(graphics, 2);
        }
    }

    public void tickCutscene() {
        if (Engine.fading()) {
            return;
        }
        boolean bl = false;
        if (this.cutSceneForwardMethod == 1) {
            if (Engine.key(16) || Engine.key(64)) {
                this.cutSceneFadeEvent = 7;
                bl = true;
            } else {
                bl = --this.cutSceneAutoCountdown <= 0;
            }
        } else if (Engine.key(16) || Engine.key(64)) {
            bl = true;
        }
        if (bl) {
            this.cutSceneViewed = true;
            Engine.releaseAllKeys();
            Engine.fadeOut(false, this.cutSceneFadeEvent);
        }
    }

    public void handleFadeEvent(int n) {
        Engine.echo("[GameWorld.handleFadeEvent] " + n);
        switch (n) {
            case 5: {
                Engine.fadeIn(false);
                this.playMusic();
                this.state = this.STATE_GAME;
                break;
            }
            case 6: {
                this.stopMusic();
                this.setCutscene(Engine.getText(Engine.fadeEventParams[0]));
                break;
            }
            case 7: {
                this.gameOver();
                break;
            }
            case 8: {
                this.currentEvent = null;
                this.tickEvents();
                break;
            }
            case 9: {
                this.eventQueue.addElement(new short[]{10, 296, 0, 8});
                this.eventQueue.addElement(new short[]{13});
                int n2 = Integer.parseInt(Engine.getText(100));
                for (int i = 0; i < n2; ++i) {
                    this.eventQueue.addElement(new short[]{10, (short)(101 + i), 1, (short)(i == n2 - 1 ? 7 : 8)});
                }
                break;
            }
        }
    }

    public void helpPopup(String string, String string2, boolean bl) {
        Menu menu = Engine.createForm(string, string2, null, bl ? null : Engine.menuInGame);
        if (bl) {
            menu.action = 1;
        }
        Engine.setMenu(menu, true, false);
        Engine.state = 10;
    }

    public void hideNotify() {
        this.drawHud = true;
    }

    public void setCredits() {
        this.creditsImage = new DeviceImage(-1);
        this.creditsX = 0;
        this.creditsY = 53248;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Engine.getText(296) + "\n\n\n\n\n\n\n\n\n\n");
        int n = Integer.parseInt(Engine.getText(100));
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(Engine.getText(101 + i) + "\n\n\n");
        }
        this.creditsStrings = Engine.getStrings(stringBuffer.toString(), 166, Engine.font);
        Device.soundFunction(3, new int[]{0});
        this.state = this.STATE_CREDITS;
    }

    public void tickCredits() {
        int n = FontMgr.charHeight[Engine.font];
        if (this.creditsX >> 8 > -(this.creditsImage.width - 176)) {
            this.creditsX -= 85;
        }
        if ((this.creditsY >> 8) + this.creditsStrings.length * n < -n) {
            if (!Engine.fading()) {
                Engine.fadeOut(false, 7);
            }
        } else {
            this.creditsY -= 170;
        }
        if ((Engine.key(16) || Engine.key(64)) && !Engine.fading()) {
            Engine.fadeOut(false, 7);
        }
    }

    public void closeCredits() {
        this.creditsImage = null;
        this.creditsStrings = null;
    }

    public void drawCredits(Graphics graphics) {
        int n = FontMgr.charHeight[Engine.font];
        Engine.cls(graphics, 0);
        this.creditsImage.drawImage(graphics, this.creditsX >> 8, 104, 6);
        int n2 = this.creditsY >> 8;
        for (int i = 0; i < this.creditsStrings.length; ++i) {
            if (n2 > -n && n2 + n < 208 + n) {
                FontMgr.drawString(Engine.font, graphics, this.creditsStrings[i], 88, n2, 17);
            }
            n2 += n;
        }
    }

    public void loadGameResources(boolean bl) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < TILE_SHEET_MAPPING.length; i += 2) {
            byte by = TILE_SHEET_MAPPING[i];
            if (by < 100) {
                if (by + 1 <= n) continue;
                n = by + 1;
                continue;
            }
            if (by + 1 - 100 <= n2) continue;
            n2 = by + 1 - 100;
        }
        tileImages = new DeviceImage(68).divide(n);
        if (bl) {
            Engine.updateLoading(20);
        }
        tileTallImages = new DeviceImage(69).divide(n2);
        if (bl) {
            Engine.updateLoading(40);
        }
        cursorImages = new DeviceImage(52).divide(16);
        portraitImage = new DeviceImage(62);
        if (bl) {
            Engine.updateLoading(60);
        }
        if (!Device.USE_BITMAP_FONTS) {
            numberImages = Engine.divideSplittedImage(-1, 11);
        }
        if (bl) {
            Engine.updateLoading(80);
        }
        if (bl) {
            Engine.updateLoading(100);
        }
    }

    public void unloadGameResources() {
        tileImages = null;
        tileTallImages = null;
        portraitImage = null;
        cursorImages = null;
        if (!Device.USE_BITMAP_FONTS) {
            numberImages = null;
        }
        System.gc();
    }

    static {
        spriteImages = new DeviceImage[24][][];
        spriteOffsets = new int[24][2];
        spriteAnimationSequences = new byte[24][][];
        spriteAnimationTypes = new byte[24][];
        spriteAnimationProcesses = new short[24][][];
        spriteAnimationDurations = new byte[24][][];
    }
}

