/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class DeviceSound {
    public static Player[] sounds;
    public static int[] SOUND_FILES;
    public static int[] SOUND_FORMATS;
    public static int[] SOUND_MAPPING;
    private static byte[][] soundBytes;
    public static Player midi_current;
    public static Player wav_current;

    public static void init() {
        try {
            sounds = new Player[SOUND_FILES.length];
            soundBytes = new byte[SOUND_FILES.length][];
            for (int i = 0; i < sounds.length; ++i) {
                if (SOUND_FILES[i] == -1) continue;
                DeviceSound.soundBytes[i] = ResourceMaster.getResource(SOUND_FILES[i]);
                if (SOUND_FORMATS[i] != 0) continue;
            }
        }
        catch (Exception exception) {
            Engine.echo("DeviceSound.init() :: " + exception);
        }
    }

    public static void reload() {
        for (int i = 0; i < sounds.length; ++i) {
            if (sounds[i] == null) continue;
            sounds[i].close();
            DeviceSound.sounds[i] = null;
        }
        DeviceSound.init();
    }

    public static void play(int n) {
        DeviceSound.play(n, 100);
    }

    public static void play(int n, int n2) {
        boolean bl;
        boolean bl2 = bl = SOUND_FORMATS[n = SOUND_MAPPING[n]] == 0;
        if (bl) {
            Engine.lastSound = n;
        }
        if (!Engine.soundOn || Engine.hideNotify) {
            return;
        }
        try {
            if (bl) {
                DeviceSound.stop(true);
                DeviceSound.sounds[n] = Manager.createPlayer((InputStream)new ByteArrayInputStream(soundBytes[n]), (String)(SOUND_FORMATS[n] == 0 ? "audio/midi" : "audio/x-wav"));
                sounds[n].realize();
                sounds[n].prefetch();
                midi_current = sounds[n];
                midi_current.setLoopCount(-1);
                midi_current.setMediaTime(0L);
                VolumeControl volumeControl = (VolumeControl)midi_current.getControl("VolumeControl");
                if (volumeControl != null) {
                    volumeControl.setLevel(50);
                }
                midi_current.start();
            } else if (!DeviceSound.isSoundPlaying(false) && n2 > 0 && GameWorld.soundFxBlockCountdown == 0) {
                DeviceSound.stop(false);
                wav_current = Manager.createPlayer((InputStream)new ByteArrayInputStream(soundBytes[n]), (String)(SOUND_FORMATS[n] == 0 ? "audio/midi" : "audio/x-wav"));
                wav_current.realize();
                wav_current.prefetch();
                VolumeControl volumeControl = (VolumeControl)wav_current.getControl("VolumeControl");
                if (volumeControl != null) {
                    volumeControl.setLevel(n2);
                }
                wav_current.start();
                GameWorld.soundFxBlockCountdown = 20;
                Thread.yield();
            }
        }
        catch (Exception exception) {
            Engine.echo("DeviceSound.play(" + n + ") :: " + exception);
            Engine.debugWrite("Error when playing sound: " + exception.toString(), true);
            Engine.debugWrite(exception.getClass().getName() + ": " + exception.getMessage(), true);
        }
    }

    public static void stop(boolean bl) {
        try {
            if (bl && midi_current != null) {
                midi_current.close();
                midi_current = null;
            } else if (!bl && wav_current != null) {
                wav_current.stop();
                wav_current.close();
                wav_current = null;
            }
        }
        catch (Exception exception) {
            System.out.println("DeviceSound.stop() :: " + exception);
        }
    }

    public static boolean resume() {
        int n = Engine.lastSound;
        if (Engine.soundOn && n != -1 && !DeviceSound.isSoundPlaying(true)) {
            DeviceSound.play(n);
            return DeviceSound.isSoundPlaying(true);
        }
        return true;
    }

    public static boolean isSoundPlaying(boolean bl) {
        if (bl) {
            return midi_current != null && midi_current.getState() == 400;
        }
        return wav_current != null && wav_current.getState() == 400;
    }

    static {
        SOUND_FILES = new int[]{5, 2, 3, 4, -1, -1, -1, -1, -1, -1, -1, -1};
        SOUND_FORMATS = new int[]{0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1};
        SOUND_MAPPING = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 4};
    }
}

