/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

public class Device
extends GameCanvas
implements Constants {
    public static final int DEVICE_ID = 300;
    public static final int WIDTH = 176;
    public static final int HEIGHT = 208;
    public static final int GFX_SIZE_UI = 0;
    public static final int GFX_SIZE_GAME = 0;
    public static final int DEVICE_MANIPULATION_NONE = 0;
    public static final int DEVICE_MANIPULATION_FLIP_HORIZONTAL = 1;
    public static final int DEVICE_MANIPULATION_FLIP_VERTICAL = 2;
    public static final int DEVICE_MANIPULATION_ROTATE_90 = 5;
    public static final int DEVICE_MANIPULATION_ROTATE_180 = 3;
    public static final int DEVICE_MANIPULATION_ROTATE_270 = 6;
    public static final int HUD_NUMBERS_OFFSET_Y = 0;
    public static final int STATUS_ICON_OFFSET_Y = -1;
    public static final int MENU_TITLE_OFFSET_Y = -2;
    public static boolean USE_BITMAP_FONTS;
    private static final int MIDP_TYPEFACE_SMALL = 0;
    private static final int MIDP_TYPEFACE_MEDIUM = 1;
    private static final int MIDP_TYPEFACE_LARGE = 2;
    public static final Font[] MIDP_TYPEFACES;
    public static final int[] MIDP_FONT_PROPS;
    private static final int BMP_TYPEFACE_BLOCK = 0;
    public static final int[] BMP_TYPEFACES;
    public static int[] FONT_TYPE;
    public static final int[] FONT_COMPOSITIONS;
    public static final boolean BUGGY_TO_UPPER_CASE = true;
    public static final int HANDLE_EVENT_DELAY = 0;
    public static final int EVENT = 2;
    private static final int KEY_UP_MAPPING = 50;
    private static final int KEY_DOWN_MAPPING = 56;
    private static final int KEY_LEFT_MAPPING = 52;
    private static final int KEY_RIGHT_MAPPING = 54;
    private static final int KEY_UL_MAPPING = 49;
    private static final int KEY_UR_MAPPING = 51;
    private static final int KEY_DL_MAPPING = 55;
    private static final int KEY_DR_MAPPING = 57;
    private static final int KEY_FIRE_MAPPING = 53;
    private static final int KEY_FIRE2_MAPPING = 48;
    private static final int KEY_STAR_MAPPING = 42;
    private static final int KEY_SOFTLEFT = -6;
    private static final int KEY_SOFTRIGHT = -7;
    public static final String[] STRING_8WAY;
    public static int[] buffer;

    public Device() {
        super(false);
        this.setFullScreenMode(true);
    }

    public static int soundFunction(int n) {
        return Device.soundFunction(n, new int[]{0});
    }

    public static int soundFunction(int n, int[] nArray) {
        switch (n) {
            case 0: {
                Engine.startMemCheck("Device.soundFunction init");
                DeviceSound.init();
                Engine.endMemCheck();
                break;
            }
            case 3: {
                DeviceSound.play(nArray[0], nArray.length == 1 ? 100 : nArray[1]);
                break;
            }
            case 1: {
                DeviceSound.stop(true);
                break;
            }
            case 2: {
                return DeviceSound.resume() ? 1 : 0;
            }
            case 4: {
                DeviceSound.reload();
            }
        }
        return 0;
    }

    public static int deviceFunction(int n, String string) throws Exception {
        switch (n) {
            case 0: {
                Engine.parent.platformRequest(string);
                break;
            }
            case 1: {
                USE_BITMAP_FONTS = string.equals("1");
            }
        }
        return 0;
    }

    public static void vibrate(int n) {
    }

    public void setBackLight(boolean bl) {
    }

    public void hideNotify() {
        Engine.handleEvent = true;
        Engine.hideNotify = true;
        Device.soundFunction(1);
    }

    public void showNotify() {
        Engine.releaseAllKeys();
        Engine.hideNotify = false;
    }

    public int getKeyMap(int n) {
        if (n == 53) {
            return 16;
        }
        if (n == -6 || n == 6) {
            return Engine.reverseTooltips ? 128 : 64;
        }
        if (n == -7 || n == 7) {
            return Engine.reverseTooltips ? 64 : 128;
        }
        if (n == 50) {
            return 1;
        }
        if (n == 56) {
            return 2;
        }
        if (n == 52) {
            return 4;
        }
        if (n == 54) {
            return 8;
        }
        if (n == 49) {
            return 256;
        }
        if (n == 51) {
            return 512;
        }
        if (n == 55) {
            return 1024;
        }
        if (n == 57) {
            return 2048;
        }
        if (n == 42) {
            return 4096;
        }
        if (n == 35) {
            return 8192;
        }
        if (n == 48) {
            return 16384;
        }
        switch (this.getGameAction(n)) {
            case 1: {
                return 1;
            }
            case 6: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 5: {
                return 8;
            }
            case 8: {
                return 16;
            }
        }
        return 0;
    }

    public void paint(Graphics graphics) {
    }

    public static void drawFadeEffect(Graphics graphics) {
    }

    public static void drawARGBRect(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        for (int i = 0; i < n4; ++i) {
            Device.buffer[i] = n;
        }
        graphics.drawRGB(buffer, 0, 0, n2, n3, n4, n5, true);
    }

    static {
        MIDP_TYPEFACES = new Font[]{Font.getFont((int)0, (int)0, (int)8), Font.getFont((int)0, (int)0, (int)0), Font.getFont((int)0, (int)0, (int)16)};
        MIDP_FONT_PROPS = new int[]{-1, 0, -1, -1, -1, -2};
        BMP_TYPEFACES = new int[]{0, 1};
        FONT_TYPE = new int[]{0, 1};
        FONT_COMPOSITIONS = new int[]{0, -1, 0, -2};
        STRING_8WAY = new String[]{"2", "8", "4", "6", "1", "3", "7", "9"};
        buffer = new int[176];
    }
}

