/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Vector;

public class AI
implements Constants {
    public static final int AI_STATE_INIT = 0;
    public static final int AI_STATE_NORMAL = 1;
    public static int updateInterval = 100;
    public static int nResourcesPerSettler = 30;
    public static int nMaxSettlersPerResource = 3;
    public static int nTicksPerStage = 2000;
    public static byte[] maxAttackUnits = new byte[]{3, 10, 14};
    public static int nDefenseUnits = 2;
    public static int nStartOutposts = 0;
    public static int nOutpostsPerStage = 1;
    public static int outpostBuildCheckInterval = 300;
    public static int randomAttackPercentage = 25;
    public static int randomAttackDecrease = 7;
    public int state;
    public GameWorld gameWorld;
    public int side;
    public int checkCounter;
    public int stage;
    public int stageCountdown = Engine.DEBUG_AI_VALUES[3];
    public int personality;
    public static final int REGION_SIZE = 10;
    public int regionRows;
    public int regionCols;
    public byte[] regionThreat;
    public byte[][] regionResources;
    public int regionCurrentUpdateRow;
    public int regionCurrentUpdateCol;
    public boolean regionCurrentUpdateDone;
    public Vector settlers = new Vector();
    public Vector units = new Vector();
    public Vector buildings = new Vector();
    public Vector attackUnits = new Vector();
    public int attackRegionRow = -1;
    public int attackRegionCol = -1;
    public Vector defenseUnits = new Vector();
    public int startRow = -1;
    public int startCol = -1;
    public int startRegionRow = -1;
    public int startRegionCol = -1;
    public boolean productionEnabled;
    public boolean lost;
    public boolean buildFort;
    public boolean hasMarket;
    public int marketTicker;
    public int marketTickerCountdown;
    public int[] ageQueue = new int[0];
    public int ageCurrentAdvancing;
    public int[] buildQueue = new int[0];
    public int buildHousesBeingBuilt = 0;
    public int[] unitQueue = new int[0];
    public short[] resourceNeeded = new short[3];
    public byte[] resourceGathering = new byte[3];
    private static final byte[][] MARKET_SEQUENCES = new byte[][]{{0, 0, 1, 2, -1, 0, 0, 1, 2, -1}, {1, 1, 0, 2, -1, 1, 1, 0, 2, -1}, {2, 2, 2, 2, 2, 0, 0, -1, 1, 1}};
    public int[] upgradeQueue = new int[0];
    public static final byte[][] UNIT_TYPE_DISPOSITION = new byte[][]{{0, 100, 0, 0, 0, 0, 0, 0}, {0, 20, 24, 23, 23, 0, 10, 0}, {0, 5, 15, 15, 24, 23, 8, 10}};
    public static final int COUNT_ATTACK_UNITS = 0;
    public static final int COUNT_SETTLERS = 1;

    public AI(GameWorld gameWorld, int n) {
        this.gameWorld = gameWorld;
        this.side = n;
        this.state = 0;
    }

    public void init() {
        boolean bl = this.startRow != -1;
        GameObject[] gameObjectArray = this.gameWorld.objectsPerSide[this.side];
        for (int i = 0; i < gameObjectArray.length; ++i) {
            GameObject gameObject = gameObjectArray[i];
            if (gameObject == null) continue;
            if (gameObject.type == 2) {
                if (gameObject.bytes[12] != 0) continue;
                if (!bl && this.startRow == -1) {
                    this.startRow = gameObject.row;
                    this.startCol = gameObject.col;
                }
                this.productionEnabled = true;
                continue;
            }
            if (gameObject.type != 3 || gameObject.bytes[4] != 1) continue;
            if (!bl) {
                this.startRow = gameObject.row;
                this.startCol = gameObject.col;
            }
            this.productionEnabled = true;
        }
        this.startRegionRow = this.startRow / 10;
        this.startRegionCol = this.startCol / 10;
        this.regionRows = this.gameWorld.mapRows / 10;
        if (this.gameWorld.mapRows % 10 != 0) {
            ++this.regionRows;
        }
        this.regionCols = this.gameWorld.mapCols / 10;
        if (this.gameWorld.mapCols % 10 != 0) {
            ++this.regionCols;
        }
        this.regionThreat = new byte[this.regionRows * this.regionCols];
        this.regionResources = new byte[this.regionRows * this.regionCols][3];
        this.regionCurrentUpdateRow = 0;
        this.regionCurrentUpdateCol = 0;
        this.checkCounter = Engine.rndPositive(Engine.DEBUG_AI_VALUES[0]);
        this.ageCurrentAdvancing = this.gameWorld.age[this.side];
        this.marketTickerCountdown = 10;
        this.state = 1;
    }

    public void updateRegionThreat() {
        int n;
        for (n = 0; n < this.regionThreat.length; ++n) {
            this.regionThreat[n] = 0;
        }
        for (n = 0; n < Engine.gameCurrentNSides; ++n) {
            if (n == this.side) continue;
            GameObject[] gameObjectArray = this.gameWorld.objectsPerSide[n];
            for (int i = 0; i < gameObjectArray.length; ++i) {
                GameObject gameObject = gameObjectArray[i];
                if (gameObject == null || !gameObject.isEntity() || gameObject.isSameTeamAs(this.side)) continue;
                int n2 = gameObject.row / 10;
                int n3 = gameObject.col / 10;
                int n4 = gameObject.canAttack() ? 2 : 1;
                int n5 = n2 * this.regionCols + n3;
                this.regionThreat[n5] = (byte)(this.regionThreat[n5] + n4);
            }
        }
    }

    public void updateRegionResources() {
        if (this.regionCurrentUpdateRow != -1) {
            int n;
            int n2 = this.regionCurrentUpdateRow * this.regionCols + this.regionCurrentUpdateCol;
            for (n = 0; n < 3; ++n) {
                this.regionResources[n2][n] = 0;
            }
            n = this.regionCurrentUpdateRow * 10;
            int n3 = this.regionCurrentUpdateCol * 10;
            int n4 = Math.min(this.gameWorld.mapRows - 1, n + 10);
            int n5 = Math.min(this.gameWorld.mapCols - 1, n3 + 10);
            for (int i = n; i <= n4; ++i) {
                for (int j = n3; j <= n5; ++j) {
                    int n6 = this.gameWorld.getTile(i, j);
                    if (!this.gameWorld.isTileResource(n6)) continue;
                    byte[] byArray = this.regionResources[n2];
                    int n7 = Engine.getMapping(GameWorld.TILE_TO_RESOURCE_MAPPING, n6);
                    byArray[n7] = (byte)(byArray[n7] + 1);
                }
            }
            if (++this.regionCurrentUpdateCol >= this.regionCols) {
                if (++this.regionCurrentUpdateRow >= this.regionRows) {
                    this.regionCurrentUpdateRow = -1;
                    this.regionCurrentUpdateCol = -1;
                    this.regionCurrentUpdateDone = true;
                } else {
                    this.regionCurrentUpdateCol = 0;
                }
            }
        }
    }

    public void updateResourceGathering() {
        for (int i = 0; i < 3; ++i) {
            this.resourceGathering[i] = 0;
        }
        Enumeration enumeration = this.settlers.elements();
        while (enumeration.hasMoreElements()) {
            GameObject gameObject = (GameObject)enumeration.nextElement();
            byte by = gameObject.bytes[19];
            if (by == -1) continue;
            byte by2 = by;
            this.resourceGathering[by2] = (byte)(this.resourceGathering[by2] + 1);
        }
    }

    public byte[] getBestAttackRegion() {
        int n;
        int n2;
        int n3 = -1;
        int n4 = Integer.MAX_VALUE;
        int n5 = -1;
        int n6 = -1;
        for (n2 = 0; n2 < this.regionRows; ++n2) {
            for (n = 0; n < this.regionCols; ++n) {
                int n7 = this.regionThreat[n2 * this.regionCols + n];
                int n8 = GameWorld.getDistance(this.startRegionRow, this.startRegionCol, n2, n);
                if (n8 >= n4 || n7 <= 0) continue;
                n4 = n8;
                n5 = n2;
                n6 = n;
                n3 = n7;
            }
        }
        if (n4 < Integer.MAX_VALUE) {
            for (n2 = n5 - 1; n2 < n5 + 1; ++n2) {
                for (n = n6 - 1; n < n6 + 1; ++n) {
                    if (!GameWorld.isOnMap(n2, n, this.regionRows, this.regionCols)) continue;
                    n3 += this.regionThreat[n2 * this.regionCols + n] / 8;
                }
            }
            return new byte[]{(byte)n5, (byte)n6, (byte)n3};
        }
        return null;
    }

    public byte[] getBestResourceRegion(int n) {
        int n2 = -1;
        int n3 = Integer.MAX_VALUE;
        int n4 = -1;
        int n5 = -1;
        int by = Integer.MAX_VALUE;
        for (int i = 0; i < this.regionRows; ++i) {
            for (int j = 0; j < this.regionCols; ++j) {
                int n6;
                byte by2;
                int n7 = this.regionResources[i * this.regionCols + j][n];
                if (n7 <= 0) continue;
                byte by3 = this.regionThreat[i * this.regionCols + j];
                int n8 = GameWorld.getDistance(this.startRegionRow, this.startRegionCol, i, j);
                if (by3 < by2 || by3 == by2 && n8 < n3) {
                    by2 = by3;
                    n6 = n7;
                } else {
                    n6 = 0;
                }
                if (n6 <= 0) continue;
                n3 = n8;
                n4 = i;
                n5 = j;
                n2 = n6;
            }
        }
        if (n3 < Integer.MAX_VALUE) {
            return new byte[]{(byte)n4, (byte)n5, (byte)n2};
        }
        return null;
    }

    public void tick() {
        if (this.lost) {
            return;
        }
        switch (this.state) {
            case 0: {
                this.init();
                break;
            }
            case 1: {
                if (--this.checkCounter <= 0) {
                    this.checkCounter = Engine.DEBUG_AI_VALUES[0];
                    this.updateRegionThreat();
                    if (this.productionEnabled) {
                        this.updateResourceGathering();
                        this.tryResource();
                        this.tryTrain();
                        this.tryBuild();
                        this.tryAge();
                        this.tryUpgrade();
                        int n = this.gameWorld.countEntities(3, 3, this.side);
                        int n2 = Engine.DEBUG_AI_VALUES[5] + this.stage * Engine.DEBUG_AI_VALUES[6];
                        if (n < n2) {
                            this.buildBuilding(3, false);
                        }
                        if (this.buildFort && this.gameWorld.getEntity(3, 8, this.side) == null) {
                            this.buildBuilding(8, false);
                        }
                        if (this.stage >= 1 && this.gameWorld.getEntity(3, 7, this.side) == null) {
                            this.buildBuilding(7, false);
                        }
                    }
                    this.tryCombat();
                    this.regionCurrentUpdateRow = 0;
                    this.regionCurrentUpdateCol = 0;
                    this.regionCurrentUpdateDone = false;
                }
                if (this.productionEnabled) {
                    this.updateRegionResources();
                    --this.marketTickerCountdown;
                    if (this.marketTickerCountdown <= 0) {
                        this.marketTicker = (this.marketTicker + 1) % MARKET_SEQUENCES[0].length;
                        this.marketTickerCountdown = 10;
                    }
                }
                if (this.stageCountdown > 0 && --this.stageCountdown <= 0) {
                    ++this.stage;
                    if (this.stage == 2) {
                        this.buildFort = true;
                    }
                    if (this.stage < 2) {
                        this.stageCountdown = (this.stage + 1) * Engine.DEBUG_AI_VALUES[3];
                    }
                }
                if (this.gameWorld.nUnits[this.side] == this.units.size()) break;
                Engine.echo("****** unit count wrong for ai side " + this.side + " (" + this.gameWorld.nUnits[this.side] + " <-> " + this.units.size() + ")");
            }
        }
    }

    public void advanceAge(int n, boolean bl) {
        if (!this.productionEnabled) {
            return;
        }
        if (AI.isInQueue(this.ageQueue, n, 2)) {
            return;
        }
        if (this.ageCurrentAdvancing >= n) {
            return;
        }
        if (n - this.ageCurrentAdvancing > 1) {
            this.advanceAge(n - 1, true);
        }
        this.ageQueue = Engine.addToArray(this.ageQueue, new int[]{n, 0}, bl);
    }

    public void tryAge() {
        if (this.ageQueue.length == 0) {
            return;
        }
        int n = this.ageQueue[0];
        int n2 = 16 + n - 1;
        boolean bl = false;
        if (this.ageQueue[1] == 0) {
            this.ageQueue[1] = 1;
            this.getResources(GameWorld.BUILD_ICON_RESOURCES[n2]);
        }
        bl = !this.gameWorld.hasResources(this.side, GameWorld.BUILD_ICON_RESOURCES[n2]);
        GameObject gameObject = null;
        if (!bl) {
            int[] nArray = this.getRequiredBuildingTypes(n2);
            gameObject = this.checkBuilding(nArray);
            boolean bl2 = bl = gameObject == null;
        }
        if (!bl && gameObject.tryQueueBuilding(n2)) {
            this.ageCurrentAdvancing = n;
            this.ageQueue = Engine.removeFromArray(this.ageQueue, 2, true);
        }
    }

    public boolean checkAge(int n) {
        if (this.gameWorld.age[this.side] < n) {
            this.advanceAge(n, false);
            return true;
        }
        return false;
    }

    public void buildBuilding(int n, boolean bl) {
        if (!this.productionEnabled) {
            return;
        }
        if (AI.isInQueue(this.buildQueue, n, 2)) {
            return;
        }
        this.buildQueue = Engine.addToArray(this.buildQueue, new int[]{n, 0}, bl);
    }

    public void tryBuild() {
        if (this.buildQueue.length == 0) {
            return;
        }
        int n = this.buildQueue[0];
        int n2 = -1 + n;
        boolean bl = false;
        if (this.buildQueue[1] == 0) {
            this.buildQueue[1] = 1;
            this.getResources(GameWorld.BUILD_ICON_RESOURCES[n2]);
        }
        boolean bl2 = bl = !this.gameWorld.hasResources(this.side, GameWorld.BUILD_ICON_RESOURCES[n2]);
        if (!bl) {
            boolean bl3 = bl = n2 != 0 && this.checkBuilding(new int[]{1}) == null;
        }
        if (!bl) {
            byte by = GameWorld.BUILD_ICON_AGES[n2];
            bl = this.checkAge(by);
        }
        if (!bl) {
            int[] nArray = this.gameWorld.getTileSpiral(this.startRow, this.startCol, 3, -1, 500, new int[]{this.side, n});
            if (nArray != null) {
                int n3 = nArray[0];
                int n4 = nArray[1];
                this.gameWorld.removeResources(this.side, GameWorld.BUILD_ICON_RESOURCES[n2]);
                GameObject gameObject = GameObject.createBuilding(n, this.side);
                this.gameWorld.addObject(gameObject, true);
                gameObject.placeBuilding(n3, n4);
                this.buildings.addElement(gameObject);
                if (n == 2) {
                    ++this.buildHousesBeingBuilt;
                }
                this.buildQueue = Engine.removeFromArray(this.buildQueue, 2, true);
                return;
            }
            Engine.echo("[AI.buildTry] Could not find a spot to build " + this.gameWorld.getBuildingName(this.side, n));
        }
    }

    public void buildingBuilt(GameObject gameObject) {
        if (gameObject.bytes[4] == 2) {
            this.buildHousesBeingBuilt = Math.max(0, this.buildHousesBeingBuilt - 1);
        }
        if (gameObject.bytes[4] == 8) {
            this.buildFort = false;
        }
        if (gameObject.bytes[4] == 7) {
            this.hasMarket = true;
        }
    }

    public void buildingAttacked(GameObject gameObject) {
        for (int i = 0; i < this.defenseUnits.size(); ++i) {
            GameObject gameObject2 = (GameObject)this.defenseUnits.elementAt(i);
            if (!gameObject2.isFree()) continue;
            gameObject2.interact(gameObject.row, gameObject.col, gameObject);
        }
    }

    public void buildingDestroyed(GameObject gameObject) {
        this.buildings.removeElement(gameObject);
        if (gameObject.bytes[4] == 7) {
            this.hasMarket = false;
        }
    }

    public GameObject checkBuilding(int[] nArray) {
        GameObject gameObject = null;
        for (int i = 0; i < nArray.length; ++i) {
            GameObject gameObject2 = this.gameWorld.getEntity(3, nArray[i], this.side);
            if (gameObject2 == null) continue;
            gameObject = gameObject2;
            if (gameObject2.state != 0) break;
        }
        if (gameObject == null) {
            this.buildBuilding(nArray[0], nArray[0] == 1);
        } else if (gameObject.state != 0) {
            return gameObject;
        }
        return null;
    }

    public void trainUnit(int n, boolean bl) {
        if (!this.productionEnabled) {
            return;
        }
        this.unitQueue = Engine.addToArray(this.unitQueue, new int[]{n, 0}, bl);
    }

    public void tryTrain() {
        if (this.unitQueue.length == 0) {
            return;
        }
        int n = this.unitQueue[0];
        int n2 = 8 + n;
        boolean bl = false;
        if (this.unitQueue[1] == 0) {
            this.unitQueue[1] = 1;
            this.getResources(GameWorld.BUILD_ICON_RESOURCES[n2]);
        }
        boolean bl2 = bl = !this.gameWorld.hasResources(this.side, GameWorld.BUILD_ICON_RESOURCES[n2]);
        if (!bl) {
            byte by = GameWorld.BUILD_ICON_AGES[n2];
            bl = this.checkAge(by);
        }
        GameObject gameObject = null;
        if (!bl) {
            int[] nArray = this.getRequiredBuildingTypes(n2);
            gameObject = this.checkBuilding(nArray);
            boolean bl3 = bl = gameObject == null;
        }
        if (!bl && this.gameWorld.housing[this.side] >= this.gameWorld.housingMax[this.side] + this.buildHousesBeingBuilt * 5) {
            this.buildBuilding(2, true);
            bl = true;
        }
        if (!bl && gameObject.tryQueueBuilding(n2)) {
            this.unitQueue = Engine.removeFromArray(this.unitQueue, 2, true);
        }
    }

    public int[] getRequiredBuildingTypes(int n) {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < GameWorld.BUILDING_PANEL_ICONS.length; ++i) {
            if (GameWorld.BUILDING_PANEL_ICONS[i] == null) continue;
            for (int j = 0; j < GameWorld.BUILDING_PANEL_ICONS[i].length; ++j) {
                if (GameWorld.BUILDING_PANEL_ICONS[i][j] != n) continue;
                vector.addElement(new Integer(i));
            }
        }
        return Engine.vectorToIntArray(vector);
    }

    public void unitTrained(GameObject gameObject) {
        this.units.addElement(gameObject);
        if (gameObject.bytes[12] == 0) {
            this.settlers.addElement(gameObject);
        } else if (gameObject.bytes[20] == 2 || this.productionEnabled && this.defenseUnits.size() < Engine.DEBUG_AI_VALUES[4] + this.stage) {
            gameObject.bytes[20] = 2;
            this.defenseUnits.addElement(gameObject);
        } else {
            gameObject.bytes[20] = 1;
            this.attackUnits.addElement(gameObject);
        }
    }

    public void unitKilled(GameObject gameObject) {
        this.units.removeElement(gameObject);
        if (gameObject.isUnitType(0)) {
            this.settlers.removeElement(gameObject);
        } else {
            this.defenseUnits.removeElement(gameObject);
            this.attackUnits.removeElement(gameObject);
            if (this.attackUnits.size() == 0) {
                this.attackRegionRow = -1;
                this.attackRegionCol = -1;
                for (int i = 0; i < this.units.size(); ++i) {
                    GameObject gameObject2 = (GameObject)this.units.elementAt(i);
                    if (gameObject2.bytes[12] == 0 || this.defenseUnits.contains(gameObject2)) continue;
                    this.attackUnits.addElement(gameObject2);
                }
            }
        }
    }

    public void getResources(short[] sArray) {
        if (!this.productionEnabled) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            int n = i;
            this.resourceNeeded[n] = (short)(this.resourceNeeded[n] + sArray[i]);
        }
    }

    public void tryResource() {
        if (!this.productionEnabled) {
            return;
        }
        int n = Integer.MAX_VALUE;
        int n2 = -1;
        for (int i = 0; i < 3; ++i) {
            if (this.resourceNeeded[i] == 0) continue;
            int n3 = this.resourceNeeded[i] / Engine.DEBUG_AI_VALUES[1];
            int n4 = Engine.DEBUG_AI_VALUES[2];
            int n5 = this.resourceGathering[i] - (n3 = Math.min(n3, n4 += this.stage));
            if (n5 >= n) continue;
            n = n5;
            n2 = i;
        }
        GameObject gameObject = null;
        Enumeration enumeration = this.settlers.elements();
        while (enumeration.hasMoreElements()) {
            GameObject gameObject2 = (GameObject)enumeration.nextElement();
            if (gameObject2.bytes[19] != -1) continue;
            gameObject = gameObject2;
            break;
        }
        int n6 = -1;
        if (gameObject != null) {
            n6 = n >= 0 ? this.gameWorld.getLowestResource(this.side) : n2;
        } else if (n < 0) {
            if (n2 == 0 && this.gameWorld.resources[this.side][0] < GameWorld.BUILD_ICON_RESOURCES[8][0]) {
                n6 = 0;
                Enumeration enumeration2 = this.settlers.elements();
                while (enumeration2.hasMoreElements()) {
                    GameObject gameObject3 = (GameObject)enumeration2.nextElement();
                    if (gameObject3.bytes[19] == 0) continue;
                    gameObject = gameObject3;
                    break;
                }
            } else if (!AI.isInQueue(this.unitQueue, 0, 2)) {
                this.trainUnit(0, true);
            }
        }
        if (this.regionCurrentUpdateDone && gameObject != null && n6 != -1) {
            int n7;
            int n8;
            int[] nArray;
            byte[] byArray = this.getBestResourceRegion(n6);
            if (byArray == null) {
                for (int i = 0; i < 3 && (i == n6 || (byArray = this.getBestResourceRegion(i)) == null); ++i) {
                }
            }
            if (byArray != null && (nArray = this.gameWorld.getTileSpiral(n8 = byArray[0] * 10 + 5, n7 = byArray[1] * 10 + 5, 0, GameWorld.getDirection(n8, n7, gameObject.row, gameObject.col), 48, null)) != null) {
                gameObject.clearInteractionTile();
                gameObject.move(nArray[0], nArray[1], false);
                gameObject.bytes[19] = (byte)n6;
            }
        }
    }

    public void resourceGathered(GameObject gameObject, int n, int n2) {
        if (this.hasMarket) {
            n = MARKET_SEQUENCES[n][this.marketTicker];
        }
        if (n != -1) {
            this.gameWorld.addResource(this.side, n, n2);
            this.resourceNeeded[n] = (short)Math.max(0, this.resourceNeeded[n] - n2);
        }
    }

    public void playerUpgraded(int n, int n2) {
        if (!this.productionEnabled) {
            return;
        }
        this.upgradeQueue = Engine.addToArray(this.upgradeQueue, new int[]{n, n2, 0}, false);
    }

    public void tryUpgrade() {
        if (this.upgradeQueue.length == 0) {
            return;
        }
        int n = this.upgradeQueue[0];
        int n2 = this.upgradeQueue[1];
        boolean bl = false;
        if (this.upgradeQueue[2] == 0) {
            this.upgradeQueue[2] = 1;
            this.getResources(GameWorld.BUILD_ICON_RESOURCES[n2]);
        }
        boolean bl2 = bl = !this.gameWorld.hasResources(this.side, GameWorld.BUILD_ICON_RESOURCES[n2]);
        if (!bl) {
            byte by = GameWorld.BUILD_ICON_AGES[n2];
            bl = this.checkAge(by);
        }
        GameObject gameObject = null;
        if (!bl) {
            gameObject = this.checkBuilding(new int[]{n});
            boolean bl3 = bl = gameObject == null;
        }
        if (!bl && gameObject.tryQueueBuilding(n2)) {
            this.upgradeQueue = Engine.removeFromArray(this.upgradeQueue, 3, true);
        }
    }

    public void tryCombat() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.attackRegionRow != -1) {
            if (this.regionThreat[this.attackRegionRow * this.regionCols + this.attackRegionCol] == 0) {
                this.attackRegionRow = -1;
                this.attackRegionCol = -1;
            } else {
                int n5 = this.attackRegionRow * 10 + 5;
                n4 = this.attackRegionCol * 10 + 5;
                for (n3 = 0; n3 < this.attackUnits.size(); ++n3) {
                    GameObject gameObject = (GameObject)this.attackUnits.elementAt(n3);
                    if (gameObject.state != 1 || gameObject.bytes[16] != -1) continue;
                    gameObject.move(n5, n4, false);
                }
            }
        }
        if (this.attackRegionRow != -1) {
            return;
        }
        byte[] byArray = this.getBestAttackRegion();
        if (byArray == null) {
            return;
        }
        n4 = byArray[0];
        n3 = byArray[1];
        int n6 = Math.min(maxAttackUnits[this.stage], Math.max(1, byArray[2] / 2));
        n6 += nDefenseUnits + this.stage;
        boolean bl = Engine.rndPositive(101) <= Engine.DEBUG_AI_VALUES[8] - this.stage * Engine.DEBUG_AI_VALUES[9];
        boolean bl2 = false;
        int n7 = this.attackUnits.size();
        if (this.productionEnabled) {
            if (bl && n7 > 0) {
                n6 = n7;
            } else {
                n2 = this.countUnitsInQueue(0);
                n = n6 - n7 - n2;
                if (n > 0) {
                    block1: for (int i = 0; i < n; ++i) {
                        int n8 = Engine.rndPositive(101);
                        int n9 = 0;
                        for (int j = 0; j < UNIT_TYPE_DISPOSITION[this.stage].length; ++j) {
                            if (n8 > (n9 += UNIT_TYPE_DISPOSITION[this.stage][j]) || GameWorld.BUILD_ICONS_MAPPING[8 + j] < 0) continue;
                            this.trainUnit(j, false);
                            continue block1;
                        }
                    }
                }
            }
        }
        if (this.productionEnabled && n7 < n6) {
            bl2 = true;
        }
        if (!this.productionEnabled && n7 == 0) {
            bl2 = true;
        }
        if (this.personality == 0 && !bl2) {
            this.gameWorld.addUnitsToSelection(this.attackUnits);
            n2 = n4 * 10 + 5;
            n = n3 * 10 + 5;
            int[] nArray = this.gameWorld.getTileSpiral(n2, n, 0, -1, 99, null);
            if (nArray != null) {
                this.gameWorld.order(this.gameWorld.selectedUnits[this.side], nArray[0], nArray[1], false);
                this.attackRegionRow = n4;
                this.attackRegionCol = n3;
            }
            this.gameWorld.deselectAllUnits(this.side);
        }
    }

    public int countUnitsInQueue(int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.unitQueue.length; ++n2) {
            if ((n != 0 || this.unitQueue[n2] == 0) && (n != 1 || this.unitQueue[n2] != 0)) continue;
            ++n3;
        }
        for (n2 = 0; n2 < this.buildings.size(); ++n2) {
            GameObject gameObject = (GameObject)this.buildings.elementAt(n2);
            int[] nArray = gameObject.ints2[0];
            if (nArray == null) continue;
            for (int i = 0; i < nArray.length; i += 2) {
                byte by = GameWorld.BUILD_ICON_TYPES[nArray[i]];
                if (by != 0) continue;
                int n4 = nArray[i] - 8;
                if ((n != 0 || n4 == 0) && (n != 1 || n4 != 0)) continue;
                n3 += nArray[i + 1];
            }
        }
        return n3;
    }

    public static boolean isInQueue(int[] nArray, int n, int n2) {
        for (int i = 0; i < nArray.length; i += n2) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    public static String queueToString(int[] nArray, int n) {
        String string = "";
        for (int i = 0; i < nArray.length; i += n) {
            string = string + nArray[i];
            if (i >= nArray.length - n) continue;
            string = string + ", ";
        }
        return string;
    }
}

