/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.lcdui.Image;

final class Bitmap {
    Image m_Image;
    String m_FileName;

    private Bitmap(Image image) {
        this.m_Image = image;
    }

    static final Bitmap createImage(String string) throws IOException {
        Image image = Image.createImage((String)string);
        if (null == image) {
            return null;
        }
        Bitmap bitmap = new Bitmap(image);
        bitmap.m_FileName = string;
        return bitmap;
    }

    static final Bitmap createImage(InputStream inputStream) throws IOException {
        Image image = Image.createImage((InputStream)inputStream);
        if (null == image) {
            return null;
        }
        return new Bitmap(image);
    }

    static final Bitmap createPaletted(String string, int[] nArray) throws IOException {
        PngInputStream pngInputStream = new PngInputStream(Boxal.getInputStream(string), nArray);
        Bitmap bitmap = Bitmap.createImage(pngInputStream);
        bitmap.m_FileName = string;
        ((InputStream)pngInputStream).close();
        return bitmap;
    }

    final int getWidth() {
        return this.m_Image.getWidth();
    }

    final int getHeight() {
        return this.m_Image.getHeight();
    }

    static final class PngInputStream
    extends InputStream {
        protected InputStream m_Stream;
        protected byte[] m_PatchData;
        protected int m_Offset;
        protected boolean m_IsClosed;
        static final int[] TABLE_Crc = new int[256];

        PngInputStream(InputStream inputStream, int[] nArray) throws IOException {
            this.m_Stream = inputStream;
            this.m_PatchData = PngInputStream.CreatePatch(new DataInputStream(inputStream), nArray);
            this.m_IsClosed = false;
        }

        public int read() throws IOException {
            int n = this.m_Offset < this.m_PatchData.length ? this.m_PatchData[this.m_Offset] & 0xFF : this.m_Stream.read();
            ++this.m_Offset;
            return n;
        }

        public void close() throws IOException {
            if (this.m_IsClosed) {
                return;
            }
            this.m_IsClosed = true;
            this.m_Stream.close();
            super.close();
        }

        static final byte[] CreatePatch(DataInputStream dataInputStream, int[] nArray) throws IOException {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            for (n = 0; n < 8; ++n) {
                dataOutputStream.write(dataInputStream.read());
            }
            n = 0;
            block4: while (n == 0) {
                int n2;
                int n3 = dataInputStream.readInt();
                int n4 = dataInputStream.readInt();
                dataOutputStream.writeInt(n3);
                dataOutputStream.writeInt(n4);
                switch (n4) {
                    case 1347179589: {
                        byte[] byArray = new byte[n3 + 4];
                        byArray[0] = (byte)(n4 >> 24 & 0xFF);
                        byArray[1] = (byte)(n4 >> 16 & 0xFF);
                        byArray[2] = (byte)(n4 >> 8 & 0xFF);
                        byArray[3] = (byte)(n4 >> 0 & 0xFF);
                        for (n2 = 0; n2 < n3 / 3; ++n2) {
                            int n5 = nArray[n2];
                            byArray[4 + n2 * 3 + 0] = (byte)(n5 >> 16 & 0xFF);
                            byArray[4 + n2 * 3 + 1] = (byte)(n5 >> 8 & 0xFF);
                            byArray[4 + n2 * 3 + 2] = (byte)(n5 >> 0 & 0xFF);
                        }
                        PngInputStream.WriteChunk(dataOutputStream, byArray);
                        dataInputStream.skip(n3 + 4);
                        n = 1;
                        continue block4;
                    }
                }
                for (n2 = 0; n2 < n3 + 4; ++n2) {
                    dataOutputStream.write(dataInputStream.read());
                }
            }
            dataOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }

        static final void WriteChunk(OutputStream outputStream, byte[] byArray) throws IOException {
            outputStream.write(byArray, 4, byArray.length - 4);
            long l = PngInputStream.CalcCRC(byArray, byArray.length);
            outputStream.write((byte)(l >> 24 & 0xFFL));
            outputStream.write((byte)(l >> 16 & 0xFFL));
            outputStream.write((byte)(l >> 8 & 0xFFL));
            outputStream.write((byte)(l >> 0 & 0xFFL));
        }

        static final long CalcCRC(byte[] byArray, int n) {
            int n2 = -1;
            for (int i = 0; i < n; ++i) {
                n2 = TABLE_Crc[(n2 ^ byArray[i]) & 0xFF] ^ n2 >>> 8;
            }
            return ~n2;
        }

        static {
            for (int i = 0; i < 256; ++i) {
                int n = i;
                for (int j = 0; j < 8; ++j) {
                    if ((n & 1) != 0) {
                        n = 0xEDB88320 ^ n >>> 1;
                        continue;
                    }
                    n >>>= 1;
                }
                PngInputStream.TABLE_Crc[i] = n;
            }
        }
    }
}

